from _collections_abc import dict_items, dict_keys, dict_values
from collections.abc import Iterable
from datetime import datetime, timedelta
from typing import Any, overload

from _typeshed import SupportsKeysAndGetItem

VALID_KEY_CHARS: Any

class CreateError(Exception): ...
class UpdateError(Exception): ...

class SessionBase(dict[str, Any]):
    TEST_COOKIE_NAME: str
    TEST_COOKIE_VALUE: str
    accessed: bool
    modified: bool
    serializer: Any
    def __init__(self, session_key: str | None = None) -> None: ...
    async def aset(self, key: str, value: Any) -> None: ...
    @property
    def key_salt(self) -> str: ...
    @overload
    async def aget(self, key: str) -> Any | None: ...
    @overload
    async def aget(self, key: str, default: Any) -> Any: ...
    @overload
    async def apop(self, key: str) -> Any: ...
    @overload
    async def apop(self, key: str, default: Any) -> Any: ...
    async def asetdefault(self, key: str, value: Any) -> Any: ...
    def set_test_cookie(self) -> None: ...
    async def aset_test_cookie(self) -> None: ...
    def test_cookie_worked(self) -> bool: ...
    async def atest_cookie_worked(self) -> bool: ...
    def delete_test_cookie(self) -> None: ...
    async def adelete_test_cookie(self) -> None: ...
    def encode(self, session_dict: dict[str, Any]) -> str: ...
    def decode(self, session_data: bytes | str) -> dict[str, Any]: ...
    @overload  # type: ignore[override]
    def update(self, dict_: SupportsKeysAndGetItem[str, Any]) -> None: ...
    @overload
    def update(self, dict_: Iterable[tuple[str, Any]]) -> None: ...
    @overload
    async def aupdate(self, dict_: SupportsKeysAndGetItem[str, Any]) -> None: ...
    @overload
    async def aupdate(self, dict_: Iterable[tuple[str, Any]]) -> None: ...
    def has_key(self, key: Any) -> bool: ...
    async def ahas_key(self, key: Any) -> bool: ...
    async def akeys(self) -> dict_keys[str, Any]: ...
    async def avalues(self) -> dict_values[str, Any]: ...
    async def aitems(self) -> dict_items[str, Any]: ...
    def clear(self) -> None: ...
    def is_empty(self) -> bool: ...
    def _get_session_key(self) -> str | None: ...
    def _set_session_key(self, value: str | None) -> None: ...
    @property
    def session_key(self) -> str | None: ...
    @property
    def _session_key(self) -> str | None: ...
    @_session_key.setter
    def _session_key(self, value: str | None) -> None: ...
    def get_session_cookie_age(self) -> int: ...
    def get_expiry_age(self, **kwargs: Any) -> int: ...
    async def aget_expiry_age(self, **kwargs: Any) -> int: ...
    def get_expiry_date(self, **kwargs: Any) -> datetime: ...
    async def aget_expiry_date(self, **kwargs: Any) -> datetime: ...
    def set_expiry(self, value: datetime | timedelta | int | None) -> None: ...
    async def aset_expiry(self, value: datetime | timedelta | int | None) -> None: ...
    def get_expire_at_browser_close(self) -> bool: ...
    async def aget_expire_at_browser_close(self) -> bool: ...
    def flush(self) -> None: ...
    async def aflush(self) -> None: ...
    def cycle_key(self) -> None: ...
    async def acycle_key(self) -> None: ...
    def exists(self, session_key: str) -> bool: ...
    async def aexists(self, session_key: str) -> bool: ...
    def create(self) -> None: ...
    async def acreate(self) -> None: ...
    def save(self, must_create: bool = False) -> None: ...
    async def asave(self, must_create: bool = False) -> None: ...
    def delete(self, session_key: str | None = None) -> None: ...
    async def adelete(self, session_key: str | None = None) -> None: ...
    def load(self) -> dict[str, Any]: ...
    async def aload(self) -> dict[str, Any]: ...
    @classmethod
    def clear_expired(cls) -> None: ...
    @classmethod
    async def aclear_expired(cls) -> None: ...
