/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.BaseDmlHelper;
import com.intellij.database.dialects.base.LimitPlace;
import com.intellij.database.dialects.base.generator.dml.DmlGenerator;
import com.intellij.database.dialects.base.generator.dml.UtilKt;
import com.intellij.database.model.DasObject;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.QueryColumns;
import com.intellij.database.script.generator.dml.QueryColumnsGenerationResult;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014J:\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/base/generator/dml/BaseSelectGenerator;", "Lcom/intellij/database/dialects/base/generator/dml/DmlGenerator;", "Lcom/intellij/database/script/generator/dml/SelectGenerationResult;", "Lcom/intellij/database/script/generator/dml/SelectTask;", "task", "dbms", "Lcom/intellij/database/Dbms;", "helper", "Lcom/intellij/database/dialects/base/BaseDmlHelper;", "<init>", "(Lcom/intellij/database/script/generator/dml/SelectTask;Lcom/intellij/database/Dbms;Lcom/intellij/database/dialects/base/BaseDmlHelper;)V", "getDbms", "()Lcom/intellij/database/Dbms;", "getHelper", "()Lcom/intellij/database/dialects/base/BaseDmlHelper;", "generate", "isLimitSupported", "", "appendLimitAtTheEnd", "", "table", "Lcom/intellij/database/model/DasObject;", "builder", "Lcom/intellij/database/util/DdlBuilder;", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "limitPlace", "Lcom/intellij/database/dialects/base/LimitPlace;", "limit", "", "offset", "intellij.database.dialects.base"})
public class BaseSelectGenerator
extends DmlGenerator<SelectGenerationResult, SelectTask> {
    @NotNull
    private final Dbms dbms;
    @NotNull
    private final BaseDmlHelper helper;

    public BaseSelectGenerator(@NotNull SelectTask task, @NotNull Dbms dbms, @NotNull BaseDmlHelper helper) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        super((DmlTask)task);
        this.dbms = dbms;
        this.helper = helper;
    }

    @NotNull
    protected final Dbms getDbms() {
        return this.dbms;
    }

    @NotNull
    protected final BaseDmlHelper getHelper() {
        return this.helper;
    }

    @Override
    @NotNull
    public SelectGenerationResult generate() {
        WhereClause it;
        String string;
        DdlBuilder builder = ((SelectTask)this.getTask()).getOutput();
        DasObject table = ((SelectTask)this.getTask()).getTable();
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect((Dbms)this.dbms);
        Intrinsics.checkNotNullExpressionValue((Object)databaseDialectEx, (String)"getDatabaseDialect(...)");
        DatabaseDialectEx dialect = databaseDialectEx;
        boolean limited = this.isLimitSupported() && (!GridUtilCore.isPageSizeUnlimited((int)((SelectTask)this.getTask()).getLimit()) || ((SelectTask)this.getTask()).getOffset() > 0);
        LimitPlace limitPlace = this.helper.getPlaceForLimit(table);
        if (limited) {
            LimitPlace.BOTH.appendLimit(table, builder, this.helper, dialect, limitPlace, ((SelectTask)this.getTask()).getLimit(), ((SelectTask)this.getTask()).getOffset(), true);
        }
        builder.keyword("SELECT").space();
        if (limited) {
            LimitPlace.BEGIN.appendLimit(table, builder, this.helper, dialect, limitPlace, ((SelectTask)this.getTask()).getLimit(), ((SelectTask)this.getTask()).getOffset(), true);
        }
        if ((string = ((SelectTask)this.getTask()).getAlias()) == null) {
            string = "t";
        }
        String alias = string;
        QueryColumnsGenerationResult columnsResult = (QueryColumnsGenerationResult)this.helper.generate((DmlTask)DmlTaskKt.queryColumns((QueryColumns)((SelectTask)this.getTask()).getColumns()).withExpressions(((SelectTask)this.getTask()).getExpressionColumns()).table(table).version(((SelectTask)this.getTask()).getVersion()).alias(alias).appendRowId(((SelectTask)this.getTask()).getAppendRowId()).build(builder));
        DmlUtilKt.space((DdlBuilder)builder, (boolean)((SelectTask)this.getTask()).getInsertNewLines());
        this.helper.appendFromTable(builder, table, alias, ((SelectTask)this.getTask()).getTableSamplingSize());
        WhereClause whereClause = ((SelectTask)this.getTask()).getWhereClause();
        if (whereClause != null) {
            it = whereClause;
            boolean bl = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)((SelectTask)this.getTask()).getInsertNewLines());
            UtilKt.generateWhere(this.dbms, it, builder, this.getTask(), true);
        }
        OrderBy orderBy = ((SelectTask)this.getTask()).getOrderBy();
        if (orderBy != null) {
            it = orderBy;
            boolean bl = false;
            DmlUtilKt.space((DdlBuilder)builder, (boolean)((SelectTask)this.getTask()).getInsertNewLines());
            UtilKt.generateOrderBy((OrderBy)it, builder, true);
        }
        if (limited) {
            this.appendLimitAtTheEnd(table, builder, dialect, limitPlace, ((SelectTask)this.getTask()).getLimit(), ((SelectTask)this.getTask()).getOffset());
        }
        return new SelectGenerationResult(builder, columnsResult.getRowIdIdx(), columnsResult.getColumnsToHide());
    }

    protected boolean isLimitSupported() {
        return true;
    }

    protected void appendLimitAtTheEnd(@Nullable DasObject table, @NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, @NotNull LimitPlace limitPlace, int limit, int offset) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)((Object)limitPlace), (String)"limitPlace");
        LimitPlace.BOTH.appendLimit(table, builder, this.helper, dialect, limitPlace, limit, offset, false);
        LimitPlace.END.appendLimit(table, builder, this.helper, dialect, limitPlace, limit, offset, false);
    }
}

