/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.javascript.types.TSSymbol;
import com.intellij.javascript.types.TSType;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.processors.JSQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver;", "Lcom/intellij/psi/impl/source/resolve/ResolveCache$PolyVariantResolver;", "Lcom/intellij/lang/javascript/psi/impl/JSPropertyNameReference;", "<init>", "()V", "resolve", "", "Lcom/intellij/psi/ResolveResult;", "reference", "incompleteCode", "", "(Lcom/intellij/lang/javascript/psi/impl/JSPropertyNameReference;Z)[Lcom/intellij/psi/ResolveResult;", "resolveWithQualifiedItemProcessor", "parent", "Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;", "property", "Lcom/intellij/lang/javascript/psi/JSProperty;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "(Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;Lcom/intellij/lang/javascript/psi/JSProperty;Ljava/lang/String;)[Lcom/intellij/psi/ResolveResult;", "getExplicitElement", "Lcom/intellij/psi/PsiElement;", "rr", "element", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nJSPropertyNameResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSPropertyNameResolver.kt\ncom/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,84:1\n30#2,2:85\n774#3:87\n865#3,2:88\n1669#3,8:90\n37#4,2:98\n*S KotlinDebug\n*F\n+ 1 JSPropertyNameResolver.kt\ncom/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver\n*L\n27#1:85,2\n66#1:87\n66#1:88,2\n67#1:90,8\n68#1:98,2\n*E\n"})
public final class JSPropertyNameResolver
implements ResolveCache.PolyVariantResolver<JSPropertyNameReference> {
    @NotNull
    public static final JSPropertyNameResolver INSTANCE = new JSPropertyNameResolver();

    private JSPropertyNameResolver() {
    }

    @NotNull
    public ResolveResult[] resolve(@NotNull JSPropertyNameReference reference, boolean incompleteCode) {
        ResolveResult[] resolveResultArray;
        ResolveResult[] resolveResultArray2;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        JSProperty jSProperty = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)jSProperty, (String)"getElement(...)");
        JSProperty property = jSProperty;
        String string = property.getName();
        if (string == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ResolveResult.EMPTY_ARRAY;
        }
        String name = string;
        PsiElement psiElement = property.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSObjectLiteralExpression");
        JSObjectLiteralExpression parent = (JSObjectLiteralExpression)psiElement;
        Project project = parent.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<TypeScriptCompilerEvaluationFacade> serviceClass$iv = TypeScriptCompilerEvaluationFacade.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        TSType typeFromService = ((TypeScriptCompilerEvaluationFacade)object).getContextualTSTypeFromService(parent, false);
        if (typeFromService != null) {
            TSSymbol symbol = typeFromService.getProperty(name);
            if (symbol == null) {
                resolveResultArray2 = ResolveResult.EMPTY_ARRAY;
            } else {
                List elements = CollectionsKt.distinct((Iterable)symbol.findPsiDeclarations());
                resolveResultArray2 = JSResolveResult.toResolveResults(elements);
            }
        } else {
            resolveResultArray2 = this.resolveWithQualifiedItemProcessor(parent, property, name);
        }
        ResolveResult[] results = resolveResultArray2;
        Intrinsics.checkNotNull((Object)results);
        if (!(results.length == 0)) {
            resolveResultArray = results;
        } else {
            ResolveResult[] resolveResultArray3 = new ResolveResult[]{new JSResolveResult((PsiElement)property)};
            resolveResultArray = resolveResultArray3;
        }
        return resolveResultArray;
    }

    /*
     * WARNING - void declaration
     */
    private final ResolveResult[] resolveWithQualifiedItemProcessor(JSObjectLiteralExpression parent, JSProperty property, String name) {
        void $this$toTypedArray$iv;
        Collection $this$distinctBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        JSType type = JSDialectSpecificHandlersFactory.findExpectedType(parent, JSExpectedTypeKind.CONTEXTUAL);
        if (type == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ResolveResult.EMPTY_ARRAY;
        }
        JSQualifiedItemProcessor jSQualifiedItemProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)property).createJSQualifiedItemProcessor(new ResolveResultSink((PsiElement)property, name), (PsiElement)property);
        Intrinsics.checkNotNullExpressionValue((Object)jSQualifiedItemProcessor, (String)"createJSQualifiedItemProcessor(...)");
        JSQualifiedItemProcessor processor = jSQualifiedItemProcessor;
        PsiFile containingFile = property.getContainingFile();
        if (type instanceof JSIntersectionType) {
            for (JSType typeComponent : ((JSIntersectionType)type).getTypes()) {
                processor.process(typeComponent, new JSEvaluateContext(containingFile));
            }
        } else {
            processor.process(type, new JSEvaluateContext(containingFile));
        }
        Object[] objectArray = processor.getResultsAsResolveResults();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getResultsAsResolveResults(...)");
        Object[] results = objectArray;
        Iterable iterable = ArraysKt.filterNotNull((Object[])results);
        boolean $i$f$filter = false;
        void var11_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResolveResult it = (ResolveResult)element$iv$iv;
            boolean bl = false;
            if (!(!(it.getElement() instanceof TypeScriptIndexSignature))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<PsiElement> set$iv = new HashSet<PsiElement>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ResolveResult it = (ResolveResult)e$iv;
            boolean bl = false;
            PsiElement key$iv = INSTANCE.getExplicitElement(it);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ResolveResult[] filteredResults = thisCollection$iv.toArray(new ResolveResult[0]);
        if (!(filteredResults.length == 0)) {
            return filteredResults;
        }
        return results;
    }

    private final PsiElement getExplicitElement(ResolveResult rr) {
        PsiElement element;
        PsiElement psiElement = element = rr.getElement();
        return psiElement != null ? this.getExplicitElement(psiElement) : null;
    }

    private final PsiElement getExplicitElement(PsiElement element) {
        PsiElement psiElement;
        if (element instanceof TypeScriptProxyImplicitElement) {
            PsiElement psiElement2 = ((TypeScriptProxyImplicitElement)element).getExplicitElement();
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getExplicitElement(...)");
        } else {
            psiElement = element;
        }
        return psiElement;
    }
}

