/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.ConsolesMigrationManagerKt;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.settings.UserParametersTable;
import com.intellij.database.settings.UserPatterns;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.FileContentUtil;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/settings/UserParametersComponent;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lcom/intellij/database/settings/DatabaseSettings;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "pattenList", "Lcom/intellij/database/settings/UserParametersTable;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "reset", "", "settings", "isModified", "", "apply", "getComponent", "Ljavax/swing/JComponent;", "dispose", "intellij.database.impl"})
public final class UserParametersComponent
implements ConfigurableUi<DatabaseSettings>,
Disposable {
    @NotNull
    private final UserParametersTable pattenList = new UserParametersTable(this);
    @NotNull
    private final DialogPanel panel = BuilderKt.panel(arg_0 -> UserParametersComponent.panel$lambda$0(this, arg_0));

    public void reset(@NotNull DatabaseSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.pattenList.reset(settings);
        this.panel.reset();
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return this.pattenList.isModified(settings) || this.panel.isModified();
    }

    public void apply(@NotNull DatabaseSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.pattenList.apply(settings);
        this.panel.apply();
        DatabaseSettings.fireSettingsChanged();
        FileContentUtil.reparseOpenedFiles();
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.panel;
    }

    public void dispose() {
    }

    private static final Unit panel$lambda$0(UserParametersComponent this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        DatabaseSettings settings = DatabaseSettings.getSettings();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> UserParametersComponent.panel$lambda$0$0(settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> UserParametersComponent.panel$lambda$0$1(settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> UserParametersComponent.panel$lambda$0$2(settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> UserParametersComponent.panel$lambda$0$3(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)(ConsolesMigrationManagerKt.isConsoleMigrationFlagEnabled() ? "settings.enable.in.query.files" : "settings.enable.in.console.and.sql.files"), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        UserPatterns userPatterns = $settings.getUserPatterns();
        Intrinsics.checkNotNullExpressionValue((Object)userPatterns, (String)"getUserPatterns(...)");
        ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(userPatterns){

            public Object get() {
                return ((UserPatterns)this.receiver).inScripts;
            }

            public void set(Object value) {
                ((UserPatterns)this.receiver).inScripts = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.enable.in.string.literals.with.sql.injection", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        UserPatterns userPatterns = $settings.getUserPatterns();
        Intrinsics.checkNotNullExpressionValue((Object)userPatterns, (String)"getUserPatterns(...)");
        ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(userPatterns){

            public Object get() {
                return ((UserPatterns)this.receiver).inLiterals;
            }

            public void set(Object value) {
                ((UserPatterns)this.receiver).inLiterals = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$2(DatabaseSettings $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message((String)"settings.substitute.inside.sql.strings", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        UserPatterns userPatterns = $settings.getUserPatterns();
        Intrinsics.checkNotNullExpressionValue((Object)userPatterns, (String)"getUserPatterns(...)");
        ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(userPatterns){

            public Object get() {
                return ((UserPatterns)this.receiver).processStrings;
            }

            public void set(Object value) {
                ((UserPatterns)this.receiver).processStrings = (Boolean)value;
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$3(UserParametersComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = this$0.pattenList.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        Cell cell = $this$row.cell(jComponent);
        String string = DatabaseBundle.message((String)"settings.parameter.patterns", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        cell.label(string, LabelPosition.TOP).align(Align.FILL);
        return Unit.INSTANCE;
    }
}

