/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.geodesic;

import org.locationtech.proj4j.geodesic.Pair;

public class GeoMath {
    public static final int digits = 53;

    public static double sq(double x) {
        return x * x;
    }

    public static double atanh(double x) {
        double y = Math.abs(x);
        y = Math.log1p(2.0 * y / (1.0 - y)) / 2.0;
        return x > 0.0 ? y : (x < 0.0 ? -y : x);
    }

    public static void norm(Pair p, double sinx, double cosx) {
        double r = Math.hypot(sinx, cosx);
        p.first = sinx / r;
        p.second = cosx / r;
    }

    public static void sum(Pair p, double u, double v) {
        double s = u + v;
        double up = s - v;
        double vpp = s - up;
        double t = s != 0.0 ? 0.0 - ((up -= u) + (vpp -= v)) : s;
        p.first = s;
        p.second = t;
    }

    public static double polyval(int N, double[] p, int s, double x) {
        double y;
        double d = y = N < 0 ? 0.0 : p[s++];
        while (--N >= 0) {
            y = y * x + p[s++];
        }
        return y;
    }

    public static double AngRound(double x) {
        double z = 0.0625;
        double y = Math.abs(x);
        y = y < 0.0625 ? 0.0625 - (0.0625 - y) : y;
        return Math.copySign(y, x);
    }

    public static double AngNormalize(double x) {
        double y = Math.IEEEremainder(x, 360.0);
        return Math.abs(y) == 180.0 ? Math.copySign(180.0, x) : y;
    }

    public static double LatFix(double x) {
        return Math.abs(x) > 90.0 ? Double.NaN : x;
    }

    public static void AngDiff(Pair p, double x, double y) {
        GeoMath.sum(p, Math.IEEEremainder(-x, 360.0), Math.IEEEremainder(y, 360.0));
        GeoMath.sum(p, Math.IEEEremainder(p.first, 360.0), p.second);
        if (p.first == 0.0 || Math.abs(p.first) == 180.0) {
            p.first = Math.copySign(p.first, p.second == 0.0 ? y - x : -p.second);
        }
    }

    public static void sincosd(Pair p, double x) {
        double cosx;
        double sinx;
        double r = x % 360.0;
        int q = (int)Math.round(r / 90.0);
        r -= (double)(90 * q);
        r = Math.toRadians(r);
        double s = Math.sin(r);
        double c2 = Math.cos(r);
        switch (q & 3) {
            case 0: {
                sinx = s;
                cosx = c2;
                break;
            }
            case 1: {
                sinx = c2;
                cosx = -s;
                break;
            }
            case 2: {
                sinx = -s;
                cosx = -c2;
                break;
            }
            default: {
                sinx = -c2;
                cosx = s;
            }
        }
        if (sinx == 0.0) {
            sinx = Math.copySign(sinx, x);
        }
        p.first = sinx;
        p.second = 0.0 + cosx;
    }

    public static void sincosde(Pair p, double x, double t) {
        double cosx;
        double sinx;
        int q = (int)Math.round(x / 90.0);
        double r = x - (double)(90 * q);
        r = Math.toRadians(GeoMath.AngRound(r + t));
        double s = Math.sin(r);
        double c2 = Math.cos(r);
        switch (q & 3) {
            case 0: {
                sinx = s;
                cosx = c2;
                break;
            }
            case 1: {
                sinx = c2;
                cosx = -s;
                break;
            }
            case 2: {
                sinx = -s;
                cosx = -c2;
                break;
            }
            default: {
                sinx = -c2;
                cosx = s;
            }
        }
        if (sinx == 0.0) {
            sinx = Math.copySign(sinx, x);
        }
        p.first = sinx;
        p.second = 0.0 + cosx;
    }

    public static double atan2d(double y, double x) {
        int q = 0;
        if (Math.abs(y) > Math.abs(x)) {
            double t = x;
            x = y;
            y = t;
            q = 2;
        }
        if (x < 0.0) {
            x = -x;
            ++q;
        }
        double ang = Math.toDegrees(Math.atan2(y, x));
        switch (q) {
            case 1: {
                ang = Math.copySign(180.0, y) - ang;
                break;
            }
            case 2: {
                ang = 90.0 - ang;
                break;
            }
            case 3: {
                ang = -90.0 + ang;
                break;
            }
        }
        return ang;
    }

    private GeoMath() {
    }
}

