/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvForestNodesAlphabeticalComparator;
import com.intellij.database.view.structure.DvForestNodesNaturalComparator;
import com.intellij.database.view.structure.DvNodeComparator;
import com.intellij.database.view.structure.DvTreeAbstractLayer;
import com.intellij.database.view.structure.DvTreeStoreyLayer;
import com.intellij.database.view.structure.forest.DvArm;
import com.intellij.database.view.structure.forest.DvBushRef;
import com.intellij.database.view.structure.forest.DvFolder;
import com.intellij.database.view.structure.forest.DvForest;
import com.intellij.database.view.structure.forest.DvForestService;
import com.intellij.database.view.structure.forest.DvRootFolder;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b\u0015J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020 H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0#2\u0006\u0010!\u001a\u00020 H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020 0#2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020 H\u0016J\u0015\u0010)\u001a\u00070\u0017\u00a2\u0006\u0002\b\u00182\u0006\u0010!\u001a\u00020 H\u0016J\b\u0010*\u001a\u00020\u0012H\u0016J\u0015\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-H\u0010\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-H\u0010\u00a2\u0006\u0002\b0J\u001d\u00101\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u000203H\u0010\u00a2\u0006\u0002\b4R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00065"}, d2={"Lcom/intellij/database/view/structure/DvTreeForestLayer;", "Lcom/intellij/database/view/structure/DvTreeStoreyLayer;", "<init>", "()V", "forestService", "Lcom/intellij/database/view/structure/forest/DvForestService;", "getForestService", "()Lcom/intellij/database/view/structure/forest/DvForestService;", "setForestService", "(Lcom/intellij/database/view/structure/forest/DvForestService;)V", "forest", "Lcom/intellij/database/view/structure/forest/DvForest;", "Lcom/intellij/database/view/DataSourceNode;", "getForest", "()Lcom/intellij/database/view/structure/forest/DvForest;", "setForest", "(Lcom/intellij/database/view/structure/forest/DvForest;)V", "setup", "", "base", "Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "setup$intellij_database_core_impl", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "root", "Lcom/intellij/database/view/structure/forest/DvRootFolder;", "getRoot", "()Lcom/intellij/database/view/structure/forest/DvRootFolder;", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "childrenOf", "Lkotlin/sequences/Sequence;", "childrenOfFolder", "folder", "Lcom/intellij/database/view/structure/forest/DvFolder;", "isAlwaysLeaf", "", "presentableNameOf", "clearAll", "onDataSourceAdded", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "onDataSourceAdded$intellij_database_core_impl", "onDataSourcePathChanged", "onDataSourcePathChanged$intellij_database_core_impl", "onDataSourceRemoved", "dbms", "Lcom/intellij/database/Dbms;", "onDataSourceRemoved$intellij_database_core_impl", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeForestLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeForestLayer.kt\ncom/intellij/database/view/structure/DvTreeForestLayer\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,119:1\n30#2,2:120\n*S KotlinDebug\n*F\n+ 1 DvTreeForestLayer.kt\ncom/intellij/database/view/structure/DvTreeForestLayer\n*L\n23#1:120,2\n*E\n"})
public final class DvTreeForestLayer
extends DvTreeStoreyLayer {
    public DvForestService forestService;
    public DvForest<DataSourceNode> forest;

    @NotNull
    public final DvForestService getForestService() {
        DvForestService dvForestService = this.forestService;
        if (dvForestService != null) {
            return dvForestService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"forestService");
        return null;
    }

    public final void setForestService(@NotNull DvForestService dvForestService) {
        Intrinsics.checkNotNullParameter((Object)dvForestService, (String)"<set-?>");
        this.forestService = dvForestService;
    }

    @NotNull
    public final DvForest<DataSourceNode> getForest() {
        DvForest<DataSourceNode> dvForest = this.forest;
        if (dvForest != null) {
            return dvForest;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"forest");
        return null;
    }

    public final void setForest(@NotNull DvForest<DataSourceNode> dvForest) {
        Intrinsics.checkNotNullParameter(dvForest, (String)"<set-?>");
        this.forest = dvForest;
    }

    @Override
    public void setup$intellij_database_core_impl(@NotNull DvTreeAbstractLayer base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        super.setup$intellij_database_core_impl(base);
        ComponentManager $this$service$iv = (ComponentManager)this.getContext().project;
        boolean $i$f$service = false;
        Class<DvForestService> serviceClass$iv = DvForestService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.setForestService((DvForestService)object);
        this.setForest(this.getForestService().getForest());
    }

    @Override
    @NotNull
    protected String getName() {
        return "Forest";
    }

    @Override
    @NotNull
    public DvRootFolder getRoot() {
        return this.getForest().getRoot();
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof DvArm ? (BasicNode)((DvArm)node).getParent() : (basicNode instanceof DataSourceNode ? (BasicNode)this.getForest().treeParentOfBush((DataSourceNode)((BasicUniqueBush)node)) : this.getBase().parentOf(node));
    }

    @Override
    @NotNull
    public Sequence<BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof DvFolder ? this.childrenOfFolder((DvFolder)node) : (basicNode instanceof DvBushRef ? this.getForest().treeVisibleChildrenOf(node) : SequencesKt.emptySequence());
    }

    private final Sequence<BasicNode> childrenOfFolder(DvFolder folder) {
        boolean sortForest = this.getContext().vo.getSortForest();
        if (sortForest) {
            DvNodeComparator comparator = this.getContext().vo.getUseNaturalOrder() ? (DvNodeComparator)DvForestNodesNaturalComparator.INSTANCE : (DvNodeComparator)DvForestNodesAlphabeticalComparator.INSTANCE;
            Sequence sortedFolders = SequencesKt.sortedWith((Sequence)CollectionsKt.asSequence((Iterable)folder.getInnerFolders()), (Comparator)comparator);
            Sequence sortedDataSources = SequencesKt.mapNotNull((Sequence)SequencesKt.sortedWith((Sequence)CollectionsKt.asSequence((Iterable)folder.getInnerBushRefList()), (Comparator)comparator), DvTreeForestLayer::childrenOfFolder$lambda$0);
            return SequencesKt.plus((Sequence)sortedFolders, (Sequence)sortedDataSources);
        }
        return this.getForest().treeVisibleChildrenOf(folder);
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvArm ? false : this.getBase().isAlwaysLeaf(node);
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof DvArm) {
            String string2 = ((DvArm)node).getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        } else {
            string = node.toString();
        }
        return string;
    }

    @Override
    public void clearAll() {
    }

    @Override
    public void onDataSourceAdded$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        DvForestService.importRestDataSources$default(this.getForestService(), false, 1, null);
    }

    @Override
    public void onDataSourcePathChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        AbstractDataSource abstractDataSource = dataSource instanceof AbstractDataSource ? (AbstractDataSource)dataSource : null;
        if (abstractDataSource == null) {
            return;
        }
        AbstractDataSource ads = abstractDataSource;
        DataSourceNode dsn = ads.node;
        DvForest<DataSourceNode> dvForest = this.getForest();
        Intrinsics.checkNotNull((Object)dsn);
        DvBushRef<DataSourceNode> bush = dvForest.getBushRef((DataSourceNode)((BasicUniqueBush)dsn));
        if (bush != null) {
            String treePath = bush.getParent().getPath();
            String dsPath = ((AbstractDataSource)dataSource).getGroupName();
            if (!Intrinsics.areEqual((Object)dsPath, (Object)treePath)) {
                DvFolder theOldFolder = bush.getParent();
                String string = dsPath;
                String[] theNewPath = string != null ? string.split("/") : new String[]{};
                DvForest.modifyTree$default(this.getForest(), false, () -> DvTreeForestLayer.onDataSourcePathChanged$lambda$0(this, theNewPath, theOldFolder, bush), 1, null);
            }
        } else {
            DvForestService.importRestDataSources$default(this.getForestService(), false, 1, null);
        }
    }

    @Override
    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        AbstractDataSource abstractDataSource = dataSource instanceof AbstractDataSource ? (AbstractDataSource)dataSource : null;
        if (abstractDataSource == null) {
            return;
        }
        AbstractDataSource theDataSource = abstractDataSource;
        DataSourceNode dsn = theDataSource.node;
        DvForest<DataSourceNode> dvForest = this.getForestService().getForest();
        Intrinsics.checkNotNull((Object)dsn);
        DvBushRef<DataSourceNode> bushRef = dvForest.getBushRef((DataSourceNode)((BasicUniqueBush)dsn));
        DvForest.modifyTree$default(this.getForest(), false, () -> DvTreeForestLayer.onDataSourceRemoved$lambda$0(bushRef, this, dsn), 1, null);
    }

    private static final DataSourceNode childrenOfFolder$lambda$0(DvBushRef it) {
        Object b = it.getBush();
        return b instanceof DataSourceNode ? (DataSourceNode)b : null;
    }

    private static final Unit onDataSourcePathChanged$lambda$0(DvTreeForestLayer this$0, String[] $theNewPath, DvFolder $theOldFolder, DvBushRef $bush) {
        DvForest<DataSourceNode> dvForest = this$0.getForest();
        Intrinsics.checkNotNull((Object)$theNewPath);
        DvFolder theTargetFolder = dvForest.ensureFolderPath($theNewPath);
        $theOldFolder.excludeBushRef($bush, false);
        $bush.assignParent(theTargetFolder);
        DvFolder.resurrectBushRef$default(theTargetFolder, $bush, false, 0, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit onDataSourceRemoved$lambda$0(DvBushRef $bushRef, DvTreeForestLayer this$0, DataSourceNode $dsn) {
        if ($bushRef != null) {
            $bushRef.getParent().excludeBushRef($bushRef, true);
        } else {
            DvForest<DataSourceNode> dvForest = this$0.getForest();
            Intrinsics.checkNotNull((Object)$dsn);
            dvForest.deregisterBush((DataSourceNode)((BasicUniqueBush)$dsn));
        }
        return Unit.INSTANCE;
    }
}

