/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.GlobUtilKt;
import com.intellij.util.containers.MultiMap;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.CallHierarchyRegistrationOptions;
import org.eclipse.lsp4j.CodeActionRegistrationOptions;
import org.eclipse.lsp4j.CodeLensRegistrationOptions;
import org.eclipse.lsp4j.ColorProviderOptions;
import org.eclipse.lsp4j.CompletionRegistrationOptions;
import org.eclipse.lsp4j.DeclarationRegistrationOptions;
import org.eclipse.lsp4j.DefinitionRegistrationOptions;
import org.eclipse.lsp4j.DiagnosticRegistrationOptions;
import org.eclipse.lsp4j.DidChangeWatchedFilesRegistrationOptions;
import org.eclipse.lsp4j.DocumentFormattingRegistrationOptions;
import org.eclipse.lsp4j.DocumentHighlightRegistrationOptions;
import org.eclipse.lsp4j.DocumentLinkRegistrationOptions;
import org.eclipse.lsp4j.DocumentOnTypeFormattingRegistrationOptions;
import org.eclipse.lsp4j.DocumentRangeFormattingRegistrationOptions;
import org.eclipse.lsp4j.DocumentSymbolRegistrationOptions;
import org.eclipse.lsp4j.ExecuteCommandRegistrationOptions;
import org.eclipse.lsp4j.FoldingRangeProviderOptions;
import org.eclipse.lsp4j.HoverRegistrationOptions;
import org.eclipse.lsp4j.ImplementationRegistrationOptions;
import org.eclipse.lsp4j.InlayHintRegistrationOptions;
import org.eclipse.lsp4j.InlineValueRegistrationOptions;
import org.eclipse.lsp4j.LinkedEditingRangeRegistrationOptions;
import org.eclipse.lsp4j.MonikerRegistrationOptions;
import org.eclipse.lsp4j.ReferenceRegistrationOptions;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.SelectionRangeRegistrationOptions;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.lsp4j.SignatureHelpRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentChangeRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentRegistrationOptions;
import org.eclipse.lsp4j.TextDocumentSaveRegistrationOptions;
import org.eclipse.lsp4j.TypeDefinitionRegistrationOptions;
import org.eclipse.lsp4j.TypeHierarchyRegistrationOptions;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.WorkspaceSymbolRegistrationOptions;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0006J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006J\u001e\u0010\u0017\u001a\u00020\u00182\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bJ,\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001e\"\u0004\b\u0000\u0010\u001f2\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001f0\u001c0\u001bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities;", "", "LspDynamicCapabilities", "()V", "capabilityToInfo", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities$CapabilityInfo;", "gson", "Lcom/google/gson/Gson;", "patternToPathMatcherCache", "", "Ljava/nio/file/PathMatcher;", "registerCapability", "", "registration", "Lorg/eclipse/lsp4j/Registration;", "unregisterCapability", "unregistration", "Lorg/eclipse/lsp4j/Unregistration;", "getPathMatcherCaching", "globPattern", "S", "hasCapability", "", "capability", "capabilityAndOptionsClass", "Lkotlin/Pair;", "Ljava/lang/Class;", "getCapabilityRegistrationOptions", "", "T", "CapabilityInfo", "Companion", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspDynamicCapabilities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDynamicCapabilities.kt\ncom/intellij/platform/lsp/impl/LspDynamicCapabilities\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n382#2,7:150\n23#3:157\n1617#4,9:158\n1869#4:167\n1870#4:169\n1626#4:170\n1#5:168\n*S KotlinDebug\n*F\n+ 1 LspDynamicCapabilities.kt\ncom/intellij/platform/lsp/impl/LspDynamicCapabilities\n*L\n103#1:150,7\n112#1:157\n146#1:158,9\n146#1:167\n146#1:169\n146#1:170\n146#1:168\n*E\n"})
public final class LspDynamicCapabilities {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiMap<String, CapabilityInfo> capabilityToInfo;
    @NotNull
    private final Gson gson;
    @NotNull
    private final Map<String, PathMatcher> patternToPathMatcherCache;
    @NotNull
    private static final Map<String, Class<?>> capabilityToLsp4jRegistrationOptionsClass = new LinkedHashMap();
    @NotNull
    private static final Pair<String, Class<CallHierarchyRegistrationOptions>> prepareCallHierarchy = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/prepareCallHierarchy", CallHierarchyRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<CodeActionRegistrationOptions>> codeAction = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/codeAction", CodeActionRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<CodeLensRegistrationOptions>> codeLens = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/codeLens", CodeLensRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<ColorProviderOptions>> documentColor = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/documentColor", ColorProviderOptions.class);
    @NotNull
    private static final Pair<String, Class<CompletionRegistrationOptions>> completion = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/completion", CompletionRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DeclarationRegistrationOptions>> declaration = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/declaration", DeclarationRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DefinitionRegistrationOptions>> definition = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/definition", DefinitionRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DiagnosticRegistrationOptions>> diagnostic = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/diagnostic", DiagnosticRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DidChangeWatchedFilesRegistrationOptions>> didChangeWatchedFiles = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "workspace/didChangeWatchedFiles", DidChangeWatchedFilesRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentFormattingRegistrationOptions>> formatting = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/formatting", DocumentFormattingRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentHighlightRegistrationOptions>> documentHighlight = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/documentHighlight", DocumentHighlightRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentLinkRegistrationOptions>> documentLink = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/documentLink", DocumentLinkRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentOnTypeFormattingRegistrationOptions>> onTypeFormatting = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/onTypeFormatting", DocumentOnTypeFormattingRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentRangeFormattingRegistrationOptions>> rangeFormatting = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/rangeFormatting", DocumentRangeFormattingRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<DocumentSymbolRegistrationOptions>> documentSymbol = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/documentSymbol", DocumentSymbolRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<FoldingRangeProviderOptions>> foldingRange = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/foldingRange", FoldingRangeProviderOptions.class);
    @NotNull
    private static final Pair<String, Class<ExecuteCommandRegistrationOptions>> executeCommand = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "workspace/executeCommand", ExecuteCommandRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<HoverRegistrationOptions>> hover = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/hover", HoverRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<ImplementationRegistrationOptions>> implementation = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/implementation", ImplementationRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<InlayHintRegistrationOptions>> inlayHint = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/inlayHint", InlayHintRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<InlineValueRegistrationOptions>> inlineValue = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/inlineValue", InlineValueRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<LinkedEditingRangeRegistrationOptions>> linkedEditingRange = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/linkedEditingRange", LinkedEditingRangeRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<MonikerRegistrationOptions>> moniker = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/moniker", MonikerRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<ReferenceRegistrationOptions>> references = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/references", ReferenceRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<RenameOptions>> rename = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/rename", RenameOptions.class);
    @NotNull
    private static final Pair<String, Class<SelectionRangeRegistrationOptions>> selectionRange = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/selectionRange", SelectionRangeRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<SemanticTokensWithRegistrationOptions>> semanticTokens = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/semanticTokens", SemanticTokensWithRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<SignatureHelpRegistrationOptions>> signatureHelp = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/signatureHelp", SignatureHelpRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentRegistrationOptions>> didOpen = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/didOpen", TextDocumentRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentChangeRegistrationOptions>> didChange = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/didChange", TextDocumentChangeRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentRegistrationOptions>> willSave = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/willSave", TextDocumentRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentRegistrationOptions>> willSaveWaitUntil = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/willSaveWaitUntil", TextDocumentRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentRegistrationOptions>> didClose = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/didClose", TextDocumentRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TextDocumentSaveRegistrationOptions>> didSave = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/didSave", TextDocumentSaveRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TypeDefinitionRegistrationOptions>> typeDefinition = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/typeDefinition", TypeDefinitionRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<TypeHierarchyRegistrationOptions>> prepareTypeHierarchy = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "textDocument/prepareTypeHierarchy", TypeHierarchyRegistrationOptions.class);
    @NotNull
    private static final Pair<String, Class<WorkspaceSymbolRegistrationOptions>> symbol = com.intellij.platform.lsp.impl.LspDynamicCapabilities$Companion.access$registration(Companion, "workspace/symbol", WorkspaceSymbolRegistrationOptions.class);

    public LspDynamicCapabilities() {
        MultiMap multiMap = MultiMap.createConcurrent();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"createConcurrent(...)");
        this.capabilityToInfo = multiMap;
        Gson gson = new MessageJsonHandler(MapsKt.emptyMap()).getGson();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"getGson(...)");
        this.gson = gson;
        this.patternToPathMatcherCache = new HashMap();
    }

    public final void registerCapability(@NotNull Registration registration) {
        Intrinsics.checkNotNullParameter((Object)registration, (String)"registration");
        String string = registration.getMethod();
        String string2 = registration.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        Object object = registration.getRegisterOptions();
        this.capabilityToInfo.putValue((Object)string, (Object)new CapabilityInfo(string2, object instanceof JsonObject ? (JsonObject)object : null, this.S(registration)));
    }

    public final void unregisterCapability(@NotNull Unregistration unregistration) {
        Intrinsics.checkNotNullParameter((Object)unregistration, (String)"unregistration");
        Collection collection = this.capabilityToInfo.get((Object)unregistration.getMethod());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Collection collection2 = collection;
        collection2.removeIf(arg_0 -> LspDynamicCapabilities.S(arg_0 -> LspDynamicCapabilities.S(unregistration, arg_0), arg_0));
        if (collection2.isEmpty()) {
            this.capabilityToInfo.remove((Object)unregistration.getMethod());
        }
    }

    @NotNull
    public final PathMatcher getPathMatcherCaching(@NotNull String globPattern) {
        PathMatcher pathMatcher;
        Intrinsics.checkNotNullParameter((Object)globPattern, (String)"globPattern");
        Map<String, PathMatcher> map = this.patternToPathMatcherCache;
        String string = globPattern;
        boolean bl = false;
        PathMatcher pathMatcher2 = map.get(string);
        if (pathMatcher2 == null) {
            boolean bl2 = false;
            PathMatcher pathMatcher3 = GlobUtilKt.getPathMatcher$default((String)globPattern, (boolean)false, (int)2, null);
            map.put(string, pathMatcher3);
            pathMatcher = pathMatcher3;
        } else {
            pathMatcher = pathMatcher2;
        }
        return pathMatcher;
    }

    private final Object S(Registration registration) {
        Object object = registration.getRegisterOptions();
        JsonObject jsonObject = object instanceof JsonObject ? (JsonObject)object : null;
        if (jsonObject == null) {
            return null;
        }
        JsonObject jsonObject2 = jsonObject;
        Class<?> clazz = capabilityToLsp4jRegistrationOptionsClass.get(registration.getMethod());
        if (clazz == null) {
            return null;
        }
        Class<?> clazz2 = clazz;
        try {
            return this.gson.fromJson((JsonElement)jsonObject2, clazz2);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            LspDynamicCapabilities lspDynamicCapabilities = this;
            boolean bl = false;
            Logger logger = Logger.getInstance(LspDynamicCapabilities.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to convert options of `" + registration.getMethod() + "` to " + clazz2.getSimpleName() + " class: " + jsonSyntaxException + "\n" + jsonObject2);
            return null;
        }
    }

    public final boolean hasCapability(@NotNull String capability) {
        Intrinsics.checkNotNullParameter((Object)capability, (String)"capability");
        return this.capabilityToInfo.containsKey((Object)capability);
    }

    public final boolean hasCapability(@NotNull Pair<String, ? extends Class<?>> capabilityAndOptionsClass) {
        Intrinsics.checkNotNullParameter(capabilityAndOptionsClass, (String)"capabilityAndOptionsClass");
        return this.hasCapability((String)capabilityAndOptionsClass.getFirst());
    }

    @NotNull
    public final <T> List<T> getCapabilityRegistrationOptions(@NotNull Pair<String, Class<T>> capabilityAndOptionsClass) {
        Intrinsics.checkNotNullParameter(capabilityAndOptionsClass, (String)"capabilityAndOptionsClass");
        Collection collection = this.capabilityToInfo.get(capabilityAndOptionsClass.getFirst());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        Iterable iterable = collection;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection2 = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator = iterable3.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object t2;
            Object t3 = t2 = iterator.next();
            boolean bl4 = false;
            CapabilityInfo capabilityInfo = (CapabilityInfo)t3;
            boolean bl5 = false;
            if (capabilityInfo.getLsp4jRegistrationOptions() == null) continue;
            boolean bl6 = false;
            collection2.add(object);
        }
        return CollectionsKt.filterIsInstance((Iterable)((List)collection2), (Class)((Class)capabilityAndOptionsClass.getSecond()));
    }

    private static final boolean S(Unregistration unregistration, CapabilityInfo capabilityInfo) {
        return Intrinsics.areEqual((Object)capabilityInfo.getRegistrationId(), (Object)unregistration.getId());
    }

    private static final boolean S(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities$CapabilityInfo;", "", "registrationId", "", "rawRegistrationOptions", "Lcom/google/gson/JsonObject;", "lsp4jRegistrationOptions", "LspDynamicCapabilities$CapabilityInfo", "(Ljava/lang/String;Lcom/google/gson/JsonObject;Ljava/lang/Object;)V", "getRegistrationId", "()Ljava/lang/String;", "getRawRegistrationOptions", "()Lcom/google/gson/JsonObject;", "getLsp4jRegistrationOptions", "()Ljava/lang/Object;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.lsp.impl"})
    private static final class CapabilityInfo {
        @NotNull
        private final String registrationId;
        @Nullable
        private final JsonObject rawRegistrationOptions;
        @Nullable
        private final Object lsp4jRegistrationOptions;

        public CapabilityInfo(@NotNull String registrationId, @Nullable JsonObject rawRegistrationOptions, @Nullable Object lsp4jRegistrationOptions) {
            Intrinsics.checkNotNullParameter((Object)registrationId, (String)"registrationId");
            this.registrationId = registrationId;
            this.rawRegistrationOptions = rawRegistrationOptions;
            this.lsp4jRegistrationOptions = lsp4jRegistrationOptions;
        }

        @NotNull
        public final String getRegistrationId() {
            return this.registrationId;
        }

        @Nullable
        public final JsonObject getRawRegistrationOptions() {
            return this.rawRegistrationOptions;
        }

        @Nullable
        public final Object getLsp4jRegistrationOptions() {
            return this.lsp4jRegistrationOptions;
        }

        @NotNull
        public final String component1() {
            return this.registrationId;
        }

        @Nullable
        public final JsonObject component2() {
            return this.rawRegistrationOptions;
        }

        @Nullable
        public final Object component3() {
            return this.lsp4jRegistrationOptions;
        }

        @NotNull
        public final CapabilityInfo copy(@NotNull String registrationId, @Nullable JsonObject rawRegistrationOptions, @Nullable Object lsp4jRegistrationOptions) {
            Intrinsics.checkNotNullParameter((Object)registrationId, (String)"registrationId");
            return new CapabilityInfo(registrationId, rawRegistrationOptions, lsp4jRegistrationOptions);
        }

        public static /* synthetic */ CapabilityInfo copy$default(CapabilityInfo capabilityInfo, String string, JsonObject jsonObject, Object object, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                string = capabilityInfo.registrationId;
            }
            if ((n2 & 2) != 0) {
                jsonObject = capabilityInfo.rawRegistrationOptions;
            }
            if ((n2 & 4) != 0) {
                object = capabilityInfo.lsp4jRegistrationOptions;
            }
            return capabilityInfo.copy(string, jsonObject, object);
        }

        @NotNull
        public String toString() {
            return "CapabilityInfo(registrationId=" + this.registrationId + ", rawRegistrationOptions=" + this.rawRegistrationOptions + ", lsp4jRegistrationOptions=" + this.lsp4jRegistrationOptions + ")";
        }

        public int hashCode() {
            int n2 = this.registrationId.hashCode();
            n2 = n2 * 31 + (this.rawRegistrationOptions == null ? 0 : this.rawRegistrationOptions.hashCode());
            n2 = n2 * 31 + (this.lsp4jRegistrationOptions == null ? 0 : this.lsp4jRegistrationOptions.hashCode());
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CapabilityInfo)) {
                return false;
            }
            CapabilityInfo capabilityInfo = (CapabilityInfo)other;
            if (!Intrinsics.areEqual((Object)this.registrationId, (Object)capabilityInfo.registrationId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rawRegistrationOptions, (Object)capabilityInfo.rawRegistrationOptions)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lsp4jRegistrationOptions, (Object)capabilityInfo.lsp4jRegistrationOptions);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010v\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hw0\u00070\t\"\u0004\b\u0000\u0010w2\u0006\u0010x\u001a\u00020\u00062\f\u0010y\u001a\b\u0012\u0004\u0012\u0002Hw0\u0007H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR#\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR#\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR#\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR#\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR#\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR#\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\fR#\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\fR#\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\fR#\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\fR#\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\fR#\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\fR#\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\fR#\u00101\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\fR#\u00104\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\fR#\u00107\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002080\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\fR#\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\fR#\u0010=\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\fR#\u0010@\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020A0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\fR#\u0010C\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\fR#\u0010F\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020G0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\fR#\u0010I\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020J0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\fR#\u0010L\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010\fR#\u0010O\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020P0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010\fR#\u0010R\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020S0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010\fR#\u0010U\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020V0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010\fR#\u0010X\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020Y0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010\fR#\u0010[\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\fR#\u0010^\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020_0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010\fR#\u0010a\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020b0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010\fR#\u0010d\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020_0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010\fR#\u0010f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020_0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010\fR#\u0010h\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020_0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010\fR#\u0010j\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020k0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010\fR#\u0010m\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020n0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010\fR#\u0010p\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020q0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010\fR#\u0010s\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020t0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\bu\u0010\f\u00a8\u0006z"}, d2={"Lcom/intellij/platform/lsp/impl/LspDynamicCapabilities$Companion;", "", "LspDynamicCapabilities$Companion", "()V", "capabilityToLsp4jRegistrationOptionsClass", "", "", "Ljava/lang/Class;", "prepareCallHierarchy", "Lkotlin/Pair;", "Lorg/eclipse/lsp4j/CallHierarchyRegistrationOptions;", "getPrepareCallHierarchy", "()Lkotlin/Pair;", "codeAction", "Lorg/eclipse/lsp4j/CodeActionRegistrationOptions;", "getCodeAction", "codeLens", "Lorg/eclipse/lsp4j/CodeLensRegistrationOptions;", "getCodeLens", "documentColor", "Lorg/eclipse/lsp4j/ColorProviderOptions;", "getDocumentColor", "completion", "Lorg/eclipse/lsp4j/CompletionRegistrationOptions;", "getCompletion", "declaration", "Lorg/eclipse/lsp4j/DeclarationRegistrationOptions;", "getDeclaration", "definition", "Lorg/eclipse/lsp4j/DefinitionRegistrationOptions;", "getDefinition", "diagnostic", "Lorg/eclipse/lsp4j/DiagnosticRegistrationOptions;", "getDiagnostic", "didChangeWatchedFiles", "Lorg/eclipse/lsp4j/DidChangeWatchedFilesRegistrationOptions;", "getDidChangeWatchedFiles", "formatting", "Lorg/eclipse/lsp4j/DocumentFormattingRegistrationOptions;", "getFormatting", "documentHighlight", "Lorg/eclipse/lsp4j/DocumentHighlightRegistrationOptions;", "getDocumentHighlight", "documentLink", "Lorg/eclipse/lsp4j/DocumentLinkRegistrationOptions;", "getDocumentLink", "onTypeFormatting", "Lorg/eclipse/lsp4j/DocumentOnTypeFormattingRegistrationOptions;", "getOnTypeFormatting", "rangeFormatting", "Lorg/eclipse/lsp4j/DocumentRangeFormattingRegistrationOptions;", "getRangeFormatting", "documentSymbol", "Lorg/eclipse/lsp4j/DocumentSymbolRegistrationOptions;", "getDocumentSymbol", "foldingRange", "Lorg/eclipse/lsp4j/FoldingRangeProviderOptions;", "getFoldingRange", "executeCommand", "Lorg/eclipse/lsp4j/ExecuteCommandRegistrationOptions;", "getExecuteCommand", "hover", "Lorg/eclipse/lsp4j/HoverRegistrationOptions;", "getHover", "implementation", "Lorg/eclipse/lsp4j/ImplementationRegistrationOptions;", "getImplementation", "inlayHint", "Lorg/eclipse/lsp4j/InlayHintRegistrationOptions;", "getInlayHint", "inlineValue", "Lorg/eclipse/lsp4j/InlineValueRegistrationOptions;", "getInlineValue", "linkedEditingRange", "Lorg/eclipse/lsp4j/LinkedEditingRangeRegistrationOptions;", "getLinkedEditingRange", "moniker", "Lorg/eclipse/lsp4j/MonikerRegistrationOptions;", "getMoniker", "references", "Lorg/eclipse/lsp4j/ReferenceRegistrationOptions;", "getReferences", "rename", "Lorg/eclipse/lsp4j/RenameOptions;", "getRename", "selectionRange", "Lorg/eclipse/lsp4j/SelectionRangeRegistrationOptions;", "getSelectionRange", "semanticTokens", "Lorg/eclipse/lsp4j/SemanticTokensWithRegistrationOptions;", "getSemanticTokens", "signatureHelp", "Lorg/eclipse/lsp4j/SignatureHelpRegistrationOptions;", "getSignatureHelp", "didOpen", "Lorg/eclipse/lsp4j/TextDocumentRegistrationOptions;", "getDidOpen", "didChange", "Lorg/eclipse/lsp4j/TextDocumentChangeRegistrationOptions;", "getDidChange", "willSave", "getWillSave", "willSaveWaitUntil", "getWillSaveWaitUntil", "didClose", "getDidClose", "didSave", "Lorg/eclipse/lsp4j/TextDocumentSaveRegistrationOptions;", "getDidSave", "typeDefinition", "Lorg/eclipse/lsp4j/TypeDefinitionRegistrationOptions;", "getTypeDefinition", "prepareTypeHierarchy", "Lorg/eclipse/lsp4j/TypeHierarchyRegistrationOptions;", "getPrepareTypeHierarchy", "symbol", "Lorg/eclipse/lsp4j/WorkspaceSymbolRegistrationOptions;", "getSymbol", "S", "T", "registrationCapability", "registrationOptionsClass", "intellij.platform.lsp.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<String, Class<CallHierarchyRegistrationOptions>> getPrepareCallHierarchy() {
            return prepareCallHierarchy;
        }

        @NotNull
        public final Pair<String, Class<CodeActionRegistrationOptions>> getCodeAction() {
            return codeAction;
        }

        @NotNull
        public final Pair<String, Class<CodeLensRegistrationOptions>> getCodeLens() {
            return codeLens;
        }

        @NotNull
        public final Pair<String, Class<ColorProviderOptions>> getDocumentColor() {
            return documentColor;
        }

        @NotNull
        public final Pair<String, Class<CompletionRegistrationOptions>> getCompletion() {
            return completion;
        }

        @NotNull
        public final Pair<String, Class<DeclarationRegistrationOptions>> getDeclaration() {
            return declaration;
        }

        @NotNull
        public final Pair<String, Class<DefinitionRegistrationOptions>> getDefinition() {
            return definition;
        }

        @NotNull
        public final Pair<String, Class<DiagnosticRegistrationOptions>> getDiagnostic() {
            return diagnostic;
        }

        @NotNull
        public final Pair<String, Class<DidChangeWatchedFilesRegistrationOptions>> getDidChangeWatchedFiles() {
            return didChangeWatchedFiles;
        }

        @NotNull
        public final Pair<String, Class<DocumentFormattingRegistrationOptions>> getFormatting() {
            return formatting;
        }

        @NotNull
        public final Pair<String, Class<DocumentHighlightRegistrationOptions>> getDocumentHighlight() {
            return documentHighlight;
        }

        @NotNull
        public final Pair<String, Class<DocumentLinkRegistrationOptions>> getDocumentLink() {
            return documentLink;
        }

        @NotNull
        public final Pair<String, Class<DocumentOnTypeFormattingRegistrationOptions>> getOnTypeFormatting() {
            return onTypeFormatting;
        }

        @NotNull
        public final Pair<String, Class<DocumentRangeFormattingRegistrationOptions>> getRangeFormatting() {
            return rangeFormatting;
        }

        @NotNull
        public final Pair<String, Class<DocumentSymbolRegistrationOptions>> getDocumentSymbol() {
            return documentSymbol;
        }

        @NotNull
        public final Pair<String, Class<FoldingRangeProviderOptions>> getFoldingRange() {
            return foldingRange;
        }

        @NotNull
        public final Pair<String, Class<ExecuteCommandRegistrationOptions>> getExecuteCommand() {
            return executeCommand;
        }

        @NotNull
        public final Pair<String, Class<HoverRegistrationOptions>> getHover() {
            return hover;
        }

        @NotNull
        public final Pair<String, Class<ImplementationRegistrationOptions>> getImplementation() {
            return implementation;
        }

        @NotNull
        public final Pair<String, Class<InlayHintRegistrationOptions>> getInlayHint() {
            return inlayHint;
        }

        @NotNull
        public final Pair<String, Class<InlineValueRegistrationOptions>> getInlineValue() {
            return inlineValue;
        }

        @NotNull
        public final Pair<String, Class<LinkedEditingRangeRegistrationOptions>> getLinkedEditingRange() {
            return linkedEditingRange;
        }

        @NotNull
        public final Pair<String, Class<MonikerRegistrationOptions>> getMoniker() {
            return moniker;
        }

        @NotNull
        public final Pair<String, Class<ReferenceRegistrationOptions>> getReferences() {
            return references;
        }

        @NotNull
        public final Pair<String, Class<RenameOptions>> getRename() {
            return rename;
        }

        @NotNull
        public final Pair<String, Class<SelectionRangeRegistrationOptions>> getSelectionRange() {
            return selectionRange;
        }

        @NotNull
        public final Pair<String, Class<SemanticTokensWithRegistrationOptions>> getSemanticTokens() {
            return semanticTokens;
        }

        @NotNull
        public final Pair<String, Class<SignatureHelpRegistrationOptions>> getSignatureHelp() {
            return signatureHelp;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentRegistrationOptions>> getDidOpen() {
            return didOpen;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentChangeRegistrationOptions>> getDidChange() {
            return didChange;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentRegistrationOptions>> getWillSave() {
            return willSave;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentRegistrationOptions>> getWillSaveWaitUntil() {
            return willSaveWaitUntil;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentRegistrationOptions>> getDidClose() {
            return didClose;
        }

        @NotNull
        public final Pair<String, Class<TextDocumentSaveRegistrationOptions>> getDidSave() {
            return didSave;
        }

        @NotNull
        public final Pair<String, Class<TypeDefinitionRegistrationOptions>> getTypeDefinition() {
            return typeDefinition;
        }

        @NotNull
        public final Pair<String, Class<TypeHierarchyRegistrationOptions>> getPrepareTypeHierarchy() {
            return prepareTypeHierarchy;
        }

        @NotNull
        public final Pair<String, Class<WorkspaceSymbolRegistrationOptions>> getSymbol() {
            return symbol;
        }

        private final <T> Pair<String, Class<T>> S(String string, Class<T> clazz) {
            Pair pair = TuplesKt.to((Object)string, clazz);
            capabilityToLsp4jRegistrationOptionsClass.put(string, clazz);
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Pair access$registration(Companion $this, String registrationCapability, Class registrationOptionsClass) {
            return $this.S(registrationCapability, registrationOptionsClass);
        }
    }
}

