/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.inlays.progress;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.fus.JupyterFeaturesCollector;
import com.intellij.jupyter.core.fus.JupyterFusCellRunStatus;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.JupyterConsoleUtil;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.SystemNotifications;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u00020\n2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/core/jupyter/inlays/progress/JupyterProgressStatusChangeNotificator;", "Lcom/intellij/jupyter/core/jupyter/actions/CellExecutionListener;", "Lcom/intellij/openapi/Disposable$Default;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/openapi/project/Project;)V", "executionStopped", "", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "jupyterStatus", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;", "endTime", "Ljava/time/ZonedDateTime;", "sendNotification", "content", "", "notificationType", "Lcom/intellij/notification/NotificationType;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "createViewNotebookAction", "notebook", "fusStatus", "Lcom/intellij/jupyter/core/fus/JupyterFusCellRunStatus;", "durationSeconds", "", "formatDuration", "diff", "Ljava/time/Duration;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterProgressStatusChangeNotificator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterProgressStatusChangeNotificator.kt\ncom/intellij/jupyter/core/jupyter/inlays/progress/JupyterProgressStatusChangeNotificator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,113:1\n4225#2,11:114\n*S KotlinDebug\n*F\n+ 1 JupyterProgressStatusChangeNotificator.kt\ncom/intellij/jupyter/core/jupyter/inlays/progress/JupyterProgressStatusChangeNotificator\n*L\n83#1:114,11\n*E\n"})
public final class JupyterProgressStatusChangeNotificator
implements CellExecutionListener,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BackedNotebookVirtualFile notebookVirtualFile;
    @NotNull
    private final Project project;

    public JupyterProgressStatusChangeNotificator(@NotNull BackedNotebookVirtualFile notebookVirtualFile2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile2, (String)"notebookVirtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.notebookVirtualFile = notebookVirtualFile2;
        this.project = project;
    }

    @Override
    public void executionStopped(@NotNull NotebookIntervalPointer cellPointer, @NotNull JupyterExecutionStatus jupyterStatus, @NotNull ZonedDateTime endTime) {
        Pair pair;
        ZonedDateTime endTime2;
        Duration duration;
        long durationSeconds;
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        if (JupyterConsoleUtil.INSTANCE.isJupyterConsoleView(this.notebookVirtualFile.getFile())) {
            return;
        }
        if (jupyterStatus == JupyterExecutionStatus.ABORTED) {
            return;
        }
        if (!JupyterSettings.Companion.getInstance().getNotifyCellExecution()) {
            return;
        }
        NotebookCellLines.Interval interval = cellPointer.get();
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        JupyterCell cell = this.notebookVirtualFile.getNotebook().getCell(interval2.getOrdinal());
        ZonedDateTime zonedDateTime = cell.getExecutionStartTime();
        if (zonedDateTime == null) {
            return;
        }
        ZonedDateTime startTime = zonedDateTime;
        ZonedDateTime zonedDateTime2 = cell.getExecutionEndTime();
        if (zonedDateTime2 == null) {
            zonedDateTime2 = ZonedDateTime.now();
        }
        if ((durationSeconds = (duration = Duration.between(startTime, endTime2 = zonedDateTime2)).toSeconds()) < (long)JupyterSettings.Companion.getInstance().getCellNotificationTimeSec()) {
            return;
        }
        Intrinsics.checkNotNull((Object)duration);
        String durationStr = this.formatDuration(duration);
        if (WhenMappings.$EnumSwitchMapping$0[jupyterStatus.ordinal()] == 1) {
            var15_11 = new Object[]{durationStr};
            Pair pair2 = new Pair((Object)NotificationType.ERROR, (Object)JupyterBundle.message("notification.jupyter.cell.executed.err.title", var15_11));
            pair = pair2;
        } else {
            var15_11 = new Object[]{durationStr};
            Pair pair3 = new Pair((Object)NotificationType.INFORMATION, (Object)JupyterBundle.message("notification.jupyter.cell.executed.ok.title", var15_11));
            pair = pair3;
        }
        Pair pair4 = pair;
        NotificationType notificationType = (NotificationType)pair4.component1();
        String content = (String)pair4.component2();
        JupyterFusCellRunStatus fusStatus = switch (WhenMappings.$EnumSwitchMapping$0[jupyterStatus.ordinal()]) {
            case 1 -> JupyterFusCellRunStatus.STOPPED_ERR;
            case 2 -> JupyterFusCellRunStatus.STOPPED_OK;
            default -> JupyterFusCellRunStatus.UNDEFINED;
        };
        JupyterFeaturesCollector.Companion.onCellFinishedNotificationShown(fusStatus, durationSeconds);
        AnAction action = this.createViewNotebookAction(this.notebookVirtualFile, cellPointer, fusStatus, durationSeconds);
        this.sendNotification(content, notificationType, action);
    }

    private final void sendNotification(@Nls String content, NotificationType notificationType, AnAction action) {
        Notification notification = new Notification("Jupyter", "", content, notificationType).setDisplayId("cell.execution.finished");
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setDisplayId(...)");
        Notification notification2 = notification;
        notification2.addAction(action);
        Notifications.Bus.notify((Notification)notification2, (Project)this.project);
        SystemNotifications.getInstance().notify(NotificationGroupManager.getInstance().getNotificationGroup("Jupyter").getDisplayId(), JupyterBundle.message("notification.jupyter.cell.executed.system.notification.title", new Object[0]), content);
    }

    private final AnAction createViewNotebookAction(BackedNotebookVirtualFile notebook, NotebookIntervalPointer cellPointer, JupyterFusCellRunStatus fusStatus, long durationSeconds) {
        NotificationAction notificationAction = NotificationAction.createSimple((String)JupyterBundle.message("notification.jupyter.cell.view.notebook.action", new Object[0]), () -> JupyterProgressStatusChangeNotificator.createViewNotebookAction$lambda$0(this, notebook, fusStatus, durationSeconds, cellPointer));
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimple(...)");
        return (AnAction)notificationAction;
    }

    private final String formatDuration(Duration diff) {
        return diff.compareTo(Duration.ofMinutes(1L)) < 0 ? diff.toSeconds() + "s" : (diff.compareTo(Duration.ofHours(1L)) < 0 ? diff.toMinutes() + "m " + diff.toSecondsPart() + "s" : diff.toHours() + "h " + diff.toMinutesPart() + "m");
    }

    /*
     * WARNING - void declaration
     */
    private static final void createViewNotebookAction$lambda$0(JupyterProgressStatusChangeNotificator this$0, BackedNotebookVirtualFile $notebook, JupyterFusCellRunStatus $fusStatus, long $durationSeconds, NotebookIntervalPointer $cellPointer) {
        block3: {
            TextEditor textEditor;
            void $this$filterIsInstanceTo$iv$iv;
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this$0.project);
            FileEditor[] fileEditorArray = fileEditorManager.openFile($notebook.getFile(), true);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
            Object[] $this$filterIsInstance$iv = fileEditorArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof TextEditor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            TextEditor textEditor2 = (TextEditor)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            JupyterFeaturesCollector.Companion.onClickCellFinishedNotification($fusStatus, $durationSeconds);
            NotebookCellLines.Interval interval = $cellPointer.get();
            if (interval == null) break block3;
            NotebookCellLines.Interval interval2 = interval;
            boolean bl = false;
            int startLine = interval2.getLines().getFirst();
            LogicalPosition logicalPosition = new LogicalPosition(startLine, 0);
            TextEditor textEditor3 = textEditor2;
            if (textEditor3 != null && (textEditor3 = textEditor3.getEditor()) != null && (textEditor3 = textEditor3.getCaretModel()) != null) {
                textEditor3.moveToLogicalPosition(logicalPosition);
            }
            if ((textEditor = textEditor2) != null && (textEditor = textEditor.getEditor()) != null && (textEditor = textEditor.getScrollingModel()) != null) {
                textEditor.scrollToCaret(ScrollType.CENTER);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/inlays/progress/JupyterProgressStatusChangeNotificator$Companion;", "", "<init>", "()V", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile file = backedNotebookVirtualFile;
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            JupyterProgressStatusChangeNotificator manager = new JupyterProgressStatusChangeNotificator(file, project2);
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)((Disposable)manager));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterExecutionStatus.values().length];
            try {
                nArray[JupyterExecutionStatus.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionStatus.OK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

