/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.simplify;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.ExpConverter;
import tech.units.indriya.function.LogConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.function.PowersOfIntConverter;
import tech.units.indriya.function.PowersOfPiConverter;
import tech.units.indriya.function.RationalConverter;
import tech.units.indriya.internal.simplify.SimplificationWorker;

public final class Simplifier {
    static final Map<Class<?>, Integer> normalFormOrder = new HashMap(6);

    public static AbstractConverter compose(AbstractConverter a, AbstractConverter b, BiPredicate<AbstractConverter, AbstractConverter> simpleComposeTest, BinaryOperator<AbstractConverter> simpleComposeAction) {
        if (a.isIdentity()) {
            if (b.isIdentity()) {
                return Simplifier.isNormalFormOrderWhenIdentity(a, b) ? a : b;
            }
            return b;
        }
        if (b.isIdentity()) {
            return a;
        }
        if (simpleComposeTest.test(a, b)) {
            return (AbstractConverter)simpleComposeAction.apply(a, b);
        }
        boolean commutative = a.isLinear() && b.isLinear();
        boolean swap = commutative && !Simplifier.isNormalFormOrderWhenCommutative(a, b);
        AbstractConverter.Pair nonSimplifiedForm = swap ? new AbstractConverter.Pair(b, a) : new AbstractConverter.Pair(a, b);
        return new SimplificationWorker(simpleComposeTest, simpleComposeAction).simplify(nonSimplifiedForm.getConversionSteps());
    }

    static boolean isNormalFormOrderWhenIdentity(AbstractConverter a, AbstractConverter b) {
        if (a.getClass().equals(b.getClass())) {
            return true;
        }
        return normalFormOrder.get(a.getClass()) <= normalFormOrder.get(b.getClass());
    }

    static boolean isNormalFormOrderWhenCommutative(AbstractConverter a, AbstractConverter b) {
        if (a.getClass().equals(b.getClass())) {
            if (a instanceof PowersOfIntConverter) {
                return ((PowersOfIntConverter)a).getBase() <= ((PowersOfIntConverter)b).getBase();
            }
            return true;
        }
        Integer orderA = Objects.requireNonNull(normalFormOrder.get(a.getClass()), () -> String.format("no normal-form order defined for class '%s'", a.getClass().getName()));
        Integer orderB = Objects.requireNonNull(normalFormOrder.get(b.getClass()), () -> String.format("no normal-form order defined for class '%s'", b.getClass().getName()));
        return orderA <= orderB;
    }

    static {
        normalFormOrder.put(AbstractConverter.IDENTITY.getClass(), 0);
        normalFormOrder.put(PowersOfIntConverter.class, 1);
        normalFormOrder.put(RationalConverter.class, 2);
        normalFormOrder.put(PowersOfPiConverter.class, 3);
        normalFormOrder.put(MultiplyConverter.class, 4);
        normalFormOrder.put(AddConverter.class, 5);
        normalFormOrder.put(LogConverter.class, 6);
        normalFormOrder.put(ExpConverter.class, 7);
        normalFormOrder.put(AbstractConverter.Pair.class, 99);
    }
}

