/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.tags;

import com.intellij.jinja.parsing.Jinja2ElementTypes;
import com.intellij.jinja.psi.Jinja2NamedExpressionImpl;
import com.intellij.jinja.ref.TypedReference;
import com.intellij.jinja.tags.Jinja2ImportTagBase;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.jinja.template.psi.VariableDeclarationProcessor;
import com.intellij.jinja.template.psi.VariableDeclaringTag;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.types.PyType;
import java.util.LinkedHashMap;
import java.util.Map;

public class Jinja2FromTag
extends Jinja2ImportTagBase
implements VariableDeclaringTag {
    public Jinja2FromTag(ASTNode astNode) {
        super(astNode);
    }

    public Map<String, Jinja2NamedExpressionImpl> getImportedReferences() {
        LinkedHashMap<String, Jinja2NamedExpressionImpl> result = new LinkedHashMap<String, Jinja2NamedExpressionImpl>();
        boolean afterAs = false;
        String lastName = null;
        Jinja2NamedExpressionImpl lastExpression = null;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiElement psiElement = child.getPsi();
            if (psiElement instanceof Jinja2NamedExpressionImpl) {
                Jinja2NamedExpressionImpl namedExpression = (Jinja2NamedExpressionImpl)psiElement;
                if (!afterAs) {
                    result.put(namedExpression.getName(), namedExpression);
                    lastExpression = namedExpression;
                    lastName = namedExpression.getName();
                    continue;
                }
                result.remove(lastName);
                result.put(namedExpression.getName(), lastExpression);
                continue;
            }
            if (child.getElementType() == Jinja2ElementTypes.SOFT_KEYWORD && child.getText().equals("as")) {
                afterAs = true;
                continue;
            }
            if (child.getElementType() != DjangoTemplateTokenTypes.COMMA) continue;
            afterAs = false;
        }
        return result;
    }

    @Override
    public String toString() {
        return "Jinja2FromTag";
    }

    @Override
    public boolean processVariableDeclarations(VariableDeclarationProcessor processor, boolean insideTag) {
        Map<String, Jinja2NamedExpressionImpl> importedReferences = this.getImportedReferences();
        String name = processor.getTargetName();
        if (name != null) {
            Jinja2NamedExpressionImpl expression = importedReferences.get(name);
            if (expression != null) {
                PsiElement target;
                PsiReference reference = (PsiReference)ContainerUtil.find((Object[])expression.getReferences(), it -> it instanceof TypedReference);
                PsiElement psiElement = target = reference != null ? reference.resolve() : null;
                if (target != null && !processor.processVariableDeclaration(name, target, this)) {
                    return false;
                }
            }
        } else {
            for (Map.Entry<String, Jinja2NamedExpressionImpl> entry : importedReferences.entrySet()) {
                PsiReference reference = (PsiReference)ContainerUtil.find((Object[])entry.getValue().getReferences(), it -> it instanceof TypedReference);
                PsiElement target = reference != null ? reference.resolve() : null;
                if (target == null || processor.processVariableDeclaration(entry.getKey(), target, this)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public PyType computeVariableType() {
        return null;
    }
}

