/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.git.nbstripout;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.git.nbstripout.BinaryInstaller;
import com.intellij.jupyter.git.nbstripout.DistributionInfo;
import com.intellij.jupyter.git.nbstripout.JupyterGitService;
import com.intellij.jupyter.git.nbstripout.JupyterGitServiceKt;
import com.intellij.jupyter.git.nbstripout.JupyterGitSettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.io.ProcessKt;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import git4idea.GitUtil;
import git4idea.config.GitConfigUtil;
import git4idea.repo.GitRepository;
import java.io.Closeable;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00152\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0006\u0010\u001b\u001a\u00020\u0015J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\fJ\n\u0010\u001f\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010 \u001a\u00020\fH\u0002J\u000e\u0010!\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u0082@\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\"J\u0016\u0010'\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u0082@\u00a2\u0006\u0002\u0010&J\u000e\u0010(\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\"J\u000e\u0010)\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\"J\u000e\u0010*\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\"J\u0016\u0010*\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0082@\u00a2\u0006\u0002\u0010&J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0002J\u0006\u0010+\u001a\u00020\u0015J\u000e\u0010,\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/jupyter/git/nbstripout/JupyterGitService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "scope", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "value", "", "needInstallFilter", "getNeedInstallFilter", "()Z", "numberOfChangedJupyterFilesInGit", "", "notificationShown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "dispose", "", "updateNumberOfJupyterFilesInChanges", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "removed", "checkVcsAsync", "getDistribution", "Lcom/intellij/jupyter/git/nbstripout/DistributionInfo;", "isSupportedSystem", "getDistributionInfoOrNull", "isEnabled", "isNbstripoutConfigured", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isNbstripoutFilterApplied", "repository", "Lgit4idea/repo/GitRepository;", "(Lgit4idea/repo/GitRepository;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isNbstripoutFilterConfigured", "isNbstripoutInstalled", "configureNbstripoutFilter", "applyNbstripoutFilter", "installAndApplyAsync", "installNbstripout", "intellij.jupyter.git"})
@SourceDebugExtension(value={"SMAP\nJupyterGitService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterGitService.kt\ncom/intellij/jupyter/git/nbstripout/JupyterGitService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,266:1\n30#2,2:267\n1740#3,3:269\n1740#3,3:272\n774#3:275\n865#3,2:276\n1869#3,2:278\n774#3:280\n865#3,2:281\n1869#3,2:283\n*S KotlinDebug\n*F\n+ 1 JupyterGitService.kt\ncom/intellij/jupyter/git/nbstripout/JupyterGitService\n*L\n140#1:267,2\n148#1:269,3\n158#1:272,3\n179#1:275\n179#1:276,2\n179#1:278,2\n185#1:280\n185#1:281,2\n185#1:283,2\n*E\n"})
public final class JupyterGitService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    private boolean needInstallFilter;
    private int numberOfChangedJupyterFilesInGit;
    @NotNull
    private AtomicBoolean notificationShown;

    public JupyterGitService(@NotNull Project project, @NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        this.project = project;
        this.scope = CoroutineScopeKt.childScope$default((CoroutineScope)parentScope, (String)"JupyterGit", null, (boolean)false, (int)6, null);
        this.notificationShown = new AtomicBoolean(false);
        this.project.getMessageBus().connect((Disposable)this).subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> JupyterGitService._init_$lambda$0(this));
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        final ChangeListManager changeListManager2 = changeListManager;
        Collection collection = changeListManager2.getAllChanges();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
        this.updateNumberOfJupyterFilesInChanges(collection, false);
        changeListManager2.addChangeListListener(new ChangeListListener(){

            public void changesAdded(Collection<? extends Change> changes, ChangeList toList) {
                Collection collection = changeListManager2.getAllChanges();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
                this.updateNumberOfJupyterFilesInChanges(collection, false);
            }

            public void changesRemoved(Collection<? extends Change> changes, ChangeList fromList) {
                Collection collection = changeListManager2.getAllChanges();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
                this.updateNumberOfJupyterFilesInChanges(collection, true);
            }
        });
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    public final boolean getNeedInstallFilter() {
        return this.needInstallFilter;
    }

    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
    }

    private final void updateNumberOfJupyterFilesInChanges(Collection<? extends Change> changes, boolean removed) {
        int before = this.numberOfChangedJupyterFilesInGit;
        ChangesUtil.processChangesByVcs((Project)this.project, changes, (arg_0, arg_1) -> JupyterGitService.updateNumberOfJupyterFilesInChanges$lambda$0(this, removed, arg_0, arg_1));
        if (before == 0 && this.numberOfChangedJupyterFilesInGit != 0) {
            this.checkVcsAsync();
        }
    }

    public final void checkVcsAsync() {
        if (!this.isEnabled() || this.numberOfChangedJupyterFilesInGit == 0) {
            this.needInstallFilter = false;
        } else {
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ JupyterGitService this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = JupyterGitService.access$isNbstripoutConfigured(this.this$0, (Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            if (!((Boolean)v0).booleanValue()) {
                                JupyterGitService.access$setNeedInstallFilter$p(this.this$0, true);
                                if (JupyterGitService.access$getNotificationShown$p(this.this$0).compareAndSet(false, true)) {
                                    v1 = new Notification("Jupyter", JupyterBundle.message((String)"action.nbstripout.notification.text", (Object[])new Object[0]), NotificationType.INFORMATION).setDisplayId("nbstripout.filter");
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"setDisplayId(...)");
                                    notification = v1;
                                    notification.addAction(ActionManager.getInstance().getAction("InstallNbstripoutFilter"));
                                    notification.addAction(ActionManager.getInstance().getAction("IgnoreNbstripoutFilter"));
                                    notification.addAction(ActionManager.getInstance().getAction("AboutNbstripoutFilter"));
                                    Notifications.Bus.notify((Notification)notification);
                                }
                            } else {
                                JupyterGitService.access$setNeedInstallFilter$p(this.this$0, false);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final DistributionInfo getDistribution() {
        DistributionInfo distributionInfo = this.getDistributionInfoOrNull();
        if (distributionInfo == null) {
            throw new IllegalStateException(("Unsupported OS " + OS.CURRENT + " and Arch " + CpuArch.CURRENT).toString());
        }
        return distributionInfo;
    }

    public final boolean isSupportedSystem() {
        return JupyterGitServiceKt.access$getDistributionInfos$p().containsKey(TuplesKt.to((Object)OS.CURRENT, (Object)CpuArch.CURRENT));
    }

    private final DistributionInfo getDistributionInfoOrNull() {
        OS os = OS.CURRENT;
        CpuArch arch = CpuArch.CURRENT;
        DistributionInfo distributionInfo = (DistributionInfo)JupyterGitServiceKt.access$getDistributionInfos$p().get(TuplesKt.to((Object)os, (Object)arch));
        return distributionInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isEnabled() {
        if (!Registry.Companion.is("jupyter.nbstripout.enabled", false)) return false;
        if (!this.isSupportedSystem()) return false;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<JupyterGitSettings> serviceClass$iv = JupyterGitSettings.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (!((JupyterGitSettings)object).getNbstripoutCheckEnabled()) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final Object isNbstripoutConfigured(Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isNbstripoutConfigured.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ JupyterGitService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JupyterGitService.access$isNbstripoutConfigured(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.isNbstripoutInstalled((Continuation<? super Boolean>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) break;
                $continuation.label = 2;
                v1 = this.isNbstripoutFilterConfigured((Continuation<? super Boolean>)$continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl29
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                if (!((Boolean)v1).booleanValue()) break;
                $continuation.label = 3;
                v2 = this.isNbstripoutFilterApplied((Continuation<? super Boolean>)$continuation);
                if (v2 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl38
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl38:
                // 2 sources

                return v2;
            }
        }
        return Boxing.boxBoolean((boolean)false);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object isNbstripoutFilterApplied(Continuation<? super Boolean> $completion) {
        block8: {
            if (!($completion instanceof isNbstripoutFilterApplied.1)) ** GOTO lbl-1000
            var9_2 = $completion;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ JupyterGitService this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return JupyterGitService.access$isNbstripoutFilterApplied(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = GitUtil.getRepositories((Project)this.project);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getRepositories(...)");
                    $this$all$iv = v0;
                    $i$f$all = 0;
                    if (!((Collection)$this$all$iv).isEmpty()) ** GOTO lbl19
                    v1 = true;
                    break block8;
lbl19:
                    // 1 sources

                    var4_7 = $this$all$iv.iterator();
lbl20:
                    // 2 sources

                    while (var4_7.hasNext()) {
                        element$iv = var4_7.next();
                        it = (GitRepository)element$iv;
                        $i$a$-all-JupyterGitService$isNbstripoutFilterApplied$2 = 0;
                        Intrinsics.checkNotNull((Object)it);
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$all$iv);
                        $continuation.L$1 = var4_7;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)it);
                        $continuation.I$0 = $i$f$all;
                        $continuation.I$1 = $i$a$-all-JupyterGitService$isNbstripoutFilterApplied$2;
                        $continuation.label = 1;
                        v2 = this.isNbstripoutFilterApplied(it, (Continuation<? super Boolean>)$continuation);
                        if (v2 == var10_4) {
                            return var10_4;
                        }
                        ** GOTO lbl46
                    }
                    break;
                }
                case 1: {
                    $i$a$-all-JupyterGitService$isNbstripoutFilterApplied$2 = $continuation.I$1;
                    $i$f$all = $continuation.I$0;
                    it = (GitRepository)$continuation.L$3;
                    element$iv = $continuation.L$2;
                    var4_7 = (Iterator<T>)$continuation.L$1;
                    $this$all$iv = (Iterable)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl46:
                    // 2 sources

                    if (((Boolean)v2).booleanValue()) ** GOTO lbl20
                    v1 = false;
                    break block8;
                }
            }
            v1 = true;
        }
        return Boxing.boxBoolean((boolean)v1);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object isNbstripoutFilterApplied(GitRepository repository, Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(repository, null){
            int label;
            final /* synthetic */ GitRepository $repository;
            {
                this.$repository = $repository;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$repository.getRoot().findChild(".gitattributes") == null) ** GOTO lbl-1000
                        v0 = this.$repository.getRoot().findChild(".gitattributes");
                        Intrinsics.checkNotNull((Object)v0);
                        $this$any$iv = StringsKt.lines((CharSequence)VirtualFileUtil.readText((VirtualFile)v0));
                        $i$f$any = false;
                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl14
                        v1 = false;
                        ** GOTO lbl21
lbl14:
                        // 2 sources

                        for (T element$iv : $this$any$iv) {
                            line = (String)element$iv;
                            $i$a$-any-JupyterGitService$isNbstripoutFilterApplied$4$1 = false;
                            if (!StringsKt.startsWith$default((String)line, (String)"*.ipynb filter", (boolean)false, (int)2, null)) continue;
                            v1 = true;
                            ** GOTO lbl21
                        }
                        v1 = false;
lbl21:
                        // 3 sources

                        if (v1) lbl-1000:
                        // 2 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        return Boxing.boxBoolean((boolean)v2);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object isNbstripoutFilterConfigured(Continuation<? super Boolean> $completion) {
        block8: {
            if (!($completion instanceof isNbstripoutFilterConfigured.1)) ** GOTO lbl-1000
            var9_2 = $completion;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ JupyterGitService this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return JupyterGitService.access$isNbstripoutFilterConfigured(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = GitUtil.getRepositories((Project)this.project);
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getRepositories(...)");
                    $this$all$iv = v0;
                    $i$f$all = 0;
                    if (!((Collection)$this$all$iv).isEmpty()) ** GOTO lbl19
                    v1 = true;
                    break block8;
lbl19:
                    // 1 sources

                    var4_7 = $this$all$iv.iterator();
lbl20:
                    // 2 sources

                    while (var4_7.hasNext()) {
                        element$iv = var4_7.next();
                        it = (GitRepository)element$iv;
                        $i$a$-all-JupyterGitService$isNbstripoutFilterConfigured$2 = 0;
                        Intrinsics.checkNotNull((Object)it);
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$all$iv);
                        $continuation.L$1 = var4_7;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)it);
                        $continuation.I$0 = $i$f$all;
                        $continuation.I$1 = $i$a$-all-JupyterGitService$isNbstripoutFilterConfigured$2;
                        $continuation.label = 1;
                        v2 = this.isNbstripoutFilterConfigured(it, (Continuation<? super Boolean>)$continuation);
                        if (v2 == var10_4) {
                            return var10_4;
                        }
                        ** GOTO lbl46
                    }
                    break;
                }
                case 1: {
                    $i$a$-all-JupyterGitService$isNbstripoutFilterConfigured$2 = $continuation.I$1;
                    $i$f$all = $continuation.I$0;
                    it = (GitRepository)$continuation.L$3;
                    element$iv = $continuation.L$2;
                    var4_7 = (Iterator<T>)$continuation.L$1;
                    $this$all$iv = (Iterable)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl46:
                    // 2 sources

                    if (((Boolean)v2).booleanValue()) ** GOTO lbl20
                    v1 = false;
                    break block8;
                }
            }
            v1 = true;
        }
        return Boxing.boxBoolean((boolean)v1);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object isNbstripoutFilterConfigured(GitRepository repository, Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(repository, null){
            int label;
            final /* synthetic */ GitRepository $repository;
            {
                this.$repository = $repository;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return Boxing.boxBoolean((boolean)GitConfigUtil.getValues((Project)this.$repository.getProject(), (VirtualFile)this.$repository.getRoot(), null).containsKey("filter.nbstripoutfast.required"));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Object isNbstripoutInstalled(Continuation<? super Boolean> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(null){
            Object L$0;
            int label;

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_3 = new String[]{"nbstripout-fast", "--version"};
                        cl = new GeneralCommandLine(var3_3);
                        v0 = cl.createProcess();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"createProcess(...)");
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)cl);
                        this.label = 1;
                        v1 = ProcessKt.awaitExit((Process)v0, (Continuation)((Continuation)this));
                        ** if (v1 != var6_2) goto lbl16
lbl15:
                        // 1 sources

                        return var6_2;
lbl16:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        cl = (GeneralCommandLine)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl23:
                            // 2 sources

                            var4_7 = ((Number)v1).intValue();
                        }
                        catch (ProcessNotCreatedException <unused var>) {
                            var4_7 = 127;
                        }
                        exitCode = var4_7;
                        return Boxing.boxBoolean((boolean)(exitCode == 0));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object configureNbstripoutFilter(Continuation<? super Unit> $completion) {
        if (!($completion instanceof configureNbstripoutFilter.1)) ** GOTO lbl-1000
        var12_2 = $completion;
        if ((var12_2.label & -2147483648) != 0) {
            var12_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ JupyterGitService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JupyterGitService.access$configureNbstripoutFilter(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = GitUtil.getRepositories((Project)this.project);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getRepositories(...)");
                $this$filter$iv = v0;
                $i$f$filter = 0;
                var4_7 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = 0;
                var7_11 = $this$filterTo$iv$iv.iterator();
lbl20:
                // 3 sources

                while (var7_11.hasNext()) {
                    element$iv$iv = var7_11.next();
                    repository = (GitRepository)element$iv$iv;
                    $i$a$-filter-JupyterGitService$configureNbstripoutFilter$2 = 0;
                    Intrinsics.checkNotNull((Object)repository);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$filter$iv);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$filterTo$iv$iv);
                    $continuation.L$2 = destination$iv$iv;
                    $continuation.L$3 = var7_11;
                    $continuation.L$4 = element$iv$iv;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)repository);
                    $continuation.I$0 = $i$f$filter;
                    $continuation.I$1 = $i$f$filterTo;
                    $continuation.I$2 = $i$a$-filter-JupyterGitService$configureNbstripoutFilter$2;
                    $continuation.label = 1;
                    v1 = this.isNbstripoutFilterConfigured(repository, (Continuation<? super Boolean>)$continuation);
                    if (v1 == var13_4) {
                        return var13_4;
                    }
                    ** GOTO lbl52
                }
                break;
            }
            case 1: {
                $i$a$-filter-JupyterGitService$configureNbstripoutFilter$2 = $continuation.I$2;
                $i$f$filterTo = $continuation.I$1;
                $i$f$filter = $continuation.I$0;
                repository = (GitRepository)$continuation.L$5;
                element$iv$iv = $continuation.L$4;
                var7_11 = (Iterator<T>)$continuation.L$3;
                destination$iv$iv = (Collection)$continuation.L$2;
                $this$filterTo$iv$iv = (Iterable)$continuation.L$1;
                $this$filter$iv = (Iterable)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl52:
                // 2 sources

                if (!((Boolean)v1 == false)) ** GOTO lbl20
                destination$iv$iv.add(element$iv$iv);
                ** GOTO lbl20
            }
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (GitRepository)element$iv;
            $i$a$-forEach-JupyterGitService$configureNbstripoutFilter$3 = false;
            Intrinsics.checkNotNull((Object)it);
            this.configureNbstripoutFilter(it);
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object applyNbstripoutFilter(Continuation<? super Unit> $completion) {
        if (!($completion instanceof applyNbstripoutFilter.1)) ** GOTO lbl-1000
        var12_2 = $completion;
        if ((var12_2.label & -2147483648) != 0) {
            var12_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                final /* synthetic */ JupyterGitService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JupyterGitService.access$applyNbstripoutFilter(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = GitUtil.getRepositories((Project)this.project);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getRepositories(...)");
                $this$filter$iv = v0;
                $i$f$filter = 0;
                var4_7 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = 0;
                var7_11 = $this$filterTo$iv$iv.iterator();
lbl20:
                // 3 sources

                while (var7_11.hasNext()) {
                    element$iv$iv = var7_11.next();
                    repository = (GitRepository)element$iv$iv;
                    $i$a$-filter-JupyterGitService$applyNbstripoutFilter$2 = 0;
                    Intrinsics.checkNotNull((Object)repository);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$filter$iv);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$filterTo$iv$iv);
                    $continuation.L$2 = destination$iv$iv;
                    $continuation.L$3 = var7_11;
                    $continuation.L$4 = element$iv$iv;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)repository);
                    $continuation.I$0 = $i$f$filter;
                    $continuation.I$1 = $i$f$filterTo;
                    $continuation.I$2 = $i$a$-filter-JupyterGitService$applyNbstripoutFilter$2;
                    $continuation.label = 1;
                    v1 = this.isNbstripoutFilterApplied(repository, (Continuation<? super Boolean>)$continuation);
                    if (v1 == var13_4) {
                        return var13_4;
                    }
                    ** GOTO lbl52
                }
                break;
            }
            case 1: {
                $i$a$-filter-JupyterGitService$applyNbstripoutFilter$2 = $continuation.I$2;
                $i$f$filterTo = $continuation.I$1;
                $i$f$filter = $continuation.I$0;
                repository = (GitRepository)$continuation.L$5;
                element$iv$iv = $continuation.L$4;
                var7_11 = (Iterator<T>)$continuation.L$3;
                destination$iv$iv = (Collection)$continuation.L$2;
                $this$filterTo$iv$iv = (Iterable)$continuation.L$1;
                $this$filter$iv = (Iterable)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl52:
                // 2 sources

                if (!((Boolean)v1 == false)) ** GOTO lbl20
                destination$iv$iv.add(element$iv$iv);
                ** GOTO lbl20
            }
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = 0;
        var4_7 = $this$forEach$iv.iterator();
lbl60:
        // 3 sources

        while (var4_7.hasNext()) {
            element$iv = var4_7.next();
            it = (GitRepository)element$iv;
            $i$a$-forEach-JupyterGitService$applyNbstripoutFilter$3 = 0;
            Intrinsics.checkNotNull((Object)it);
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
            $continuation.L$1 = var4_7;
            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
            $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)it);
            $continuation.L$4 = null;
            $continuation.L$5 = null;
            $continuation.I$0 = $i$f$forEach;
            $continuation.I$1 = $i$a$-forEach-JupyterGitService$applyNbstripoutFilter$3;
            $continuation.label = 2;
            v2 = this.applyNbstripoutFilter(it, (Continuation<? super Unit>)$continuation);
            if (v2 != var13_4) continue;
            return var13_4;
        }
        {
            break;
            case 2: {
                $i$a$-forEach-JupyterGitService$applyNbstripoutFilter$3 = $continuation.I$1;
                $i$f$forEach = $continuation.I$0;
                it = (GitRepository)$continuation.L$3;
                element$iv = $continuation.L$2;
                var4_7 = (Iterator)$continuation.L$1;
                $this$forEach$iv = (Iterable)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                ** GOTO lbl60
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object applyNbstripoutFilter(GitRepository repository, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(repository, null){
            int label;
            final /* synthetic */ GitRepository $repository;
            {
                this.$repository = $repository;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        WriteIntentReadAction.run(() -> applyNbstripoutFilter.5.invokeSuspend$lambda$0(this.$repository));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private static final void invokeSuspend$lambda$0(GitRepository $repository) {
                block9: {
                    String string;
                    void $this$fold$iv;
                    VirtualFile virtualFile = $repository.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                    VirtualFile gitattributes = VirtualFileUtil.findOrCreateFile((VirtualFile)virtualFile, (String)".gitattributes");
                    String text = VirtualFileUtil.readText((VirtualFile)gitattributes);
                    Iterable iterable = StringsKt.lines((CharSequence)text);
                    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\"\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0017"}, d2={"com/intellij/jupyter/git/nbstripout/JupyterGitService$applyNbstripoutFilter$5$1$Result", "", "appendFilter", "", "appendDiff", "<init>", "(ZZ)V", "getAppendFilter", "()Z", "setAppendFilter", "(Z)V", "getAppendDiff", "setAppendDiff", "component1", "component2", "copy", "(ZZ)Lcom/intellij/jupyter/git/nbstripout/JupyterGitService$applyNbstripoutFilter$5$1$Result;", "equals", "other", "hashCode", "", "toString", "", "intellij.jupyter.git"})
                    public final class Result {
                        private boolean appendFilter;
                        private boolean appendDiff;

                        public Result(boolean appendFilter, boolean appendDiff) {
                            this.appendFilter = appendFilter;
                            this.appendDiff = appendDiff;
                        }

                        public /* synthetic */ Result(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                            if ((n & 1) != 0) {
                                bl = true;
                            }
                            if ((n & 2) != 0) {
                                bl2 = true;
                            }
                            this(bl, bl2);
                        }

                        public final boolean getAppendFilter() {
                            return this.appendFilter;
                        }

                        public final void setAppendFilter(boolean bl) {
                            this.appendFilter = bl;
                        }

                        public final boolean getAppendDiff() {
                            return this.appendDiff;
                        }

                        public final void setAppendDiff(boolean bl) {
                            this.appendDiff = bl;
                        }

                        public final boolean component1() {
                            return this.appendFilter;
                        }

                        public final boolean component2() {
                            return this.appendDiff;
                        }

                        public final Result copy(boolean appendFilter, boolean appendDiff) {
                            return new Result(appendFilter, appendDiff);
                        }

                        public static /* synthetic */ Result copy$default(Result result2, boolean bl, boolean bl2, int n, Object object) {
                            if ((n & 1) != 0) {
                                bl = result2.appendFilter;
                            }
                            if ((n & 2) != 0) {
                                bl2 = result2.appendDiff;
                            }
                            return result2.copy(bl, bl2);
                        }

                        public String toString() {
                            return "Result(appendFilter=" + this.appendFilter + ", appendDiff=" + this.appendDiff + ")";
                        }

                        public int hashCode() {
                            int result2 = Boolean.hashCode(this.appendFilter);
                            result2 = result2 * 31 + Boolean.hashCode(this.appendDiff);
                            return result2;
                        }

                        public boolean equals(Object other) {
                            if (this == other) {
                                return true;
                            }
                            if (!(other instanceof Result)) {
                                return false;
                            }
                            Result result2 = (Result)other;
                            if (this.appendFilter != result2.appendFilter) {
                                return false;
                            }
                            return this.appendDiff == result2.appendDiff;
                        }
                    }
                    Object initial$iv = new Result(false, false, 3, null);
                    boolean $i$f$fold = false;
                    Result accumulator$iv = initial$iv;
                    for (T element$iv : $this$fold$iv) {
                        void line;
                        String string2 = (String)element$iv;
                        Result r = accumulator$iv;
                        boolean bl = false;
                        accumulator$iv = StringsKt.startsWith$default((String)line, (String)"*.ipynb filter", (boolean)false, (int)2, null) ? Result.copy$default(r, false, false, 2, null) : (StringsKt.startsWith$default((String)line, (String)"*.ipynb diff", (boolean)false, (int)2, null) ? Result.copy$default(r, false, false, 1, null) : r);
                    }
                    Result r = accumulator$iv;
                    Object $this$invokeSuspend_u24lambda_u240_u241 = initial$iv = CollectionsKt.createListBuilder();
                    boolean bl = false;
                    if (r.getAppendFilter()) {
                        $this$invokeSuspend_u24lambda_u240_u241.add("*.ipynb filter=nbstripoutfast");
                    }
                    if (r.getAppendDiff()) {
                        $this$invokeSuspend_u24lambda_u240_u241.add("*.ipynb diff=ipynb");
                    }
                    List append = CollectionsKt.build((List)initial$iv);
                    if (!(!((Collection)append).isEmpty())) break block9;
                    Closeable closeable = new StringWriter(text.length() + 100);
                    Object object = null;
                    try {
                        StringWriter writer = (StringWriter)closeable;
                        boolean bl2 = false;
                        writer.append(text);
                        if (!StringsKt.isBlank((CharSequence)text) && StringsKt.last((CharSequence)text) != '\n') {
                            writer.write("\n");
                        }
                        Iterable $this$forEach$iv = append;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            writer.write(it);
                            writer.write("\n");
                        }
                        string = writer.toString();
                    }
                    catch (Throwable throwable) {
                        try {
                            object = throwable;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            CloseableKt.closeFinally((Closeable)closeable, object);
                            throw throwable2;
                        }
                    }
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    String string3 = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"use(...)");
                    String updated = string3;
                    WriteAction.run(() -> applyNbstripoutFilter.5.invokeSuspend$lambda$0$3(gitattributes, updated));
                }
            }

            private static final void invokeSuspend$lambda$0$3(VirtualFile $gitattributes, String $updated) {
                VfsUtil.saveText((VirtualFile)$gitattributes, (String)$updated);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void configureNbstripoutFilter(GitRepository repository) {
        GitConfigUtil.setValue((Project)repository.getProject(), (VirtualFile)repository.getRoot(), (String)"filter.nbstripoutfast.clean", (String)"nbstripout-fast", (String[])new String[0]);
        GitConfigUtil.setValue((Project)repository.getProject(), (VirtualFile)repository.getRoot(), (String)"filter.nbstripoutfast.smudge", (String)"cat", (String[])new String[0]);
        GitConfigUtil.setValue((Project)repository.getProject(), (VirtualFile)repository.getRoot(), (String)"filter.nbstripoutfast.required", (String)"true", (String[])new String[0]);
        GitConfigUtil.setValue((Project)repository.getProject(), (VirtualFile)repository.getRoot(), (String)"diff.ipynb.textconv", (String)"nbstripout-fast -t", (String[])new String[0]);
    }

    public final void installAndApplyAsync() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JupyterGitService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = JupyterGitService.access$installNbstripout(this.this$0, (Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = JupyterGitService.access$configureNbstripoutFilter(this.this$0, (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        this.label = 3;
                        v2 = JupyterGitService.access$applyNbstripoutFilter(this.this$0, (Continuation)this);
                        if (v2 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl29
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        JupyterGitService.access$setNeedInstallFilter$p(this.this$0, false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object installNbstripout(Continuation<? super Unit> $completion) {
        if (!($completion instanceof installNbstripout.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ JupyterGitService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JupyterGitService.access$installNbstripout(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.isNbstripoutInstalled((Continuation<? super Boolean>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    distributionInfo = this.getDistribution();
                    BinaryInstaller.Companion.create(this.project).withDownloadUrl((Function1<? super BinaryInstaller.Configuration, String>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, installNbstripout$lambda$0(com.intellij.jupyter.git.nbstripout.DistributionInfo com.intellij.jupyter.git.nbstripout.BinaryInstaller$Configuration ), (Lcom/intellij/jupyter/git/nbstripout/BinaryInstaller$Configuration;)Ljava/lang/String;)((DistributionInfo)distributionInfo)).withChecksum((Function1<? super BinaryInstaller.Configuration, String>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, installNbstripout$lambda$1(com.intellij.jupyter.git.nbstripout.DistributionInfo com.intellij.jupyter.git.nbstripout.BinaryInstaller$Configuration ), (Lcom/intellij/jupyter/git/nbstripout/BinaryInstaller$Configuration;)Ljava/lang/String;)((DistributionInfo)distributionInfo)).withBinaryName((Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, installNbstripout$lambda$2(com.intellij.jupyter.git.nbstripout.DistributionInfo ), ()Ljava/lang/String;)((DistributionInfo)distributionInfo)).withFileToVerifyFilter((Function1<? super BinaryInstaller.Configuration, ? extends Function1<? super Path, Boolean>>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, installNbstripout$lambda$3(com.intellij.jupyter.git.nbstripout.BinaryInstaller$Configuration ), (Lcom/intellij/jupyter/git/nbstripout/BinaryInstaller$Configuration;)Lkotlin/jvm/functions/Function1;)()).install();
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void _init_$lambda$0(JupyterGitService this$0) {
        this$0.checkVcsAsync();
    }

    private static final void updateNumberOfJupyterFilesInChanges$lambda$0(JupyterGitService this$0, boolean $removed, AbstractVcs vcs, List changes) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        if (Intrinsics.areEqual((Object)vcs.getName(), (Object)"Git")) {
            for (Change change : changes) {
                Object object = change;
                boolean bl = object != null && (object = object.getAfterRevision()) != null && (object = object.getFile()) != null && (object = object.getName()) != null ? StringsKt.endsWith$default((String)object, (String)".ipynb", (boolean)false, (int)2, null) : false;
                if (!bl) continue;
                this$0.numberOfChangedJupyterFilesInGit = this$0.numberOfChangedJupyterFilesInGit + ($removed ? -1 : 1);
            }
        }
    }

    private static final String installNbstripout$lambda$0(DistributionInfo $distributionInfo, BinaryInstaller.Configuration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $distributionInfo.getUrl();
    }

    private static final String installNbstripout$lambda$1(DistributionInfo $distributionInfo, BinaryInstaller.Configuration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $distributionInfo.getChecksum();
    }

    private static final String installNbstripout$lambda$2(DistributionInfo $distributionInfo) {
        return $distributionInfo.getFile();
    }

    private static final Function1 installNbstripout$lambda$3(BinaryInstaller.Configuration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JupyterGitService::installNbstripout$lambda$3$0;
    }

    private static final boolean installNbstripout$lambda$3$0(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.endsWith$default((String)PathsKt.getName((Path)path), (String)".whl", (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ Object access$isNbstripoutConfigured(JupyterGitService $this, Continuation $completion) {
        return $this.isNbstripoutConfigured((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ void access$setNeedInstallFilter$p(JupyterGitService $this, boolean bl) {
        $this.needInstallFilter = bl;
    }

    public static final /* synthetic */ AtomicBoolean access$getNotificationShown$p(JupyterGitService $this) {
        return $this.notificationShown;
    }

    public static final /* synthetic */ Object access$isNbstripoutFilterApplied(JupyterGitService $this, Continuation $completion) {
        return $this.isNbstripoutFilterApplied((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$isNbstripoutFilterApplied(JupyterGitService $this, GitRepository repository, Continuation $completion) {
        return $this.isNbstripoutFilterApplied(repository, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$isNbstripoutFilterConfigured(JupyterGitService $this, Continuation $completion) {
        return $this.isNbstripoutFilterConfigured((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$isNbstripoutFilterConfigured(JupyterGitService $this, GitRepository repository, Continuation $completion) {
        return $this.isNbstripoutFilterConfigured(repository, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$isNbstripoutInstalled(JupyterGitService $this, Continuation $completion) {
        return $this.isNbstripoutInstalled((Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$configureNbstripoutFilter(JupyterGitService $this, Continuation $completion) {
        return $this.configureNbstripoutFilter((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$applyNbstripoutFilter(JupyterGitService $this, Continuation $completion) {
        return $this.applyNbstripoutFilter((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$applyNbstripoutFilter(JupyterGitService $this, GitRepository repository, Continuation $completion) {
        return $this.applyNbstripoutFilter(repository, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$installNbstripout(JupyterGitService $this, Continuation $completion) {
        return $this.installNbstripout((Continuation<? super Unit>)$completion);
    }
}

