<?php
// This file was auto-generated from sdk-root/src/data/marketplace-agreement/2020-03-01/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2020-03-01', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'agreement-marketplace', 'jsonVersion' => '1.0', 'protocol' => 'json', 'protocols' => [ 'json', ], 'serviceAbbreviation' => 'Agreement Service', 'serviceFullName' => 'AWS Marketplace Agreement Service', 'serviceId' => 'Marketplace Agreement', 'signatureVersion' => 'v4', 'signingName' => 'aws-marketplace', 'targetPrefix' => 'AWSMPCommerceService_v20200301', 'uid' => 'marketplace-agreement-2020-03-01', ], 'operations' => [ 'DescribeAgreement' => [ 'name' => 'DescribeAgreement', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeAgreementInput', ], 'output' => [ 'shape' => 'DescribeAgreementOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetAgreementTerms' => [ 'name' => 'GetAgreementTerms', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetAgreementTermsInput', ], 'output' => [ 'shape' => 'GetAgreementTermsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'SearchAgreements' => [ 'name' => 'SearchAgreements', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'SearchAgreementsInput', ], 'output' => [ 'shape' => 'SearchAgreementsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], ], 'shapes' => [ 'AWSAccountId' => [ 'type' => 'string', 'max' => 32, 'min' => 1, 'pattern' => '[0-9]+', ], 'AcceptedTerm' => [ 'type' => 'structure', 'members' => [ 'legalTerm' => [ 'shape' => 'LegalTerm', ], 'supportTerm' => [ 'shape' => 'SupportTerm', ], 'renewalTerm' => [ 'shape' => 'RenewalTerm', ], 'usageBasedPricingTerm' => [ 'shape' => 'UsageBasedPricingTerm', ], 'configurableUpfrontPricingTerm' => [ 'shape' => 'ConfigurableUpfrontPricingTerm', ], 'byolPricingTerm' => [ 'shape' => 'ByolPricingTerm', ], 'recurringPaymentTerm' => [ 'shape' => 'RecurringPaymentTerm', ], 'validityTerm' => [ 'shape' => 'ValidityTerm', ], 'paymentScheduleTerm' => [ 'shape' => 'PaymentScheduleTerm', ], 'freeTrialPricingTerm' => [ 'shape' => 'FreeTrialPricingTerm', ], 'fixedUpfrontPricingTerm' => [ 'shape' => 'FixedUpfrontPricingTerm', ], 'variablePaymentTerm' => [ 'shape' => 'VariablePaymentTerm', ], ], 'union' => true, ], 'AcceptedTermList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AcceptedTerm', ], ], 'Acceptor' => [ 'type' => 'structure', 'members' => [ 'accountId' => [ 'shape' => 'AWSAccountId', ], ], ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'requestId' => [ 'shape' => 'RequestId', ], 'message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'AgreementResourceType' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z]+', ], 'AgreementStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'ARCHIVED', 'CANCELLED', 'EXPIRED', 'RENEWED', 'REPLACED', 'ROLLED_BACK', 'SUPERSEDED', 'TERMINATED', ], ], 'AgreementType' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[A-Za-z]+', ], 'AgreementViewSummary' => [ 'type' => 'structure', 'members' => [ 'agreementId' => [ 'shape' => 'ResourceId', ], 'acceptanceTime' => [ 'shape' => 'Timestamp', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'endTime' => [ 'shape' => 'Timestamp', ], 'agreementType' => [ 'shape' => 'AgreementType', ], 'acceptor' => [ 'shape' => 'Acceptor', ], 'proposer' => [ 'shape' => 'Proposer', ], 'proposalSummary' => [ 'shape' => 'ProposalSummary', ], 'status' => [ 'shape' => 'AgreementStatus', ], ], ], 'AgreementViewSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AgreementViewSummary', ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'BoundedString' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, 'pattern' => '(.)+', ], 'ByolPricingTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], ], ], 'Catalog' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z]+', ], 'ConfigurableUpfrontPricingTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], 'currencyCode' => [ 'shape' => 'CurrencyCode', ], 'rateCards' => [ 'shape' => 'ConfigurableUpfrontRateCardList', ], 'configuration' => [ 'shape' => 'ConfigurableUpfrontPricingTermConfiguration', ], ], ], 'ConfigurableUpfrontPricingTermConfiguration' => [ 'type' => 'structure', 'required' => [ 'selectorValue', 'dimensions', ], 'members' => [ 'selectorValue' => [ 'shape' => 'BoundedString', ], 'dimensions' => [ 'shape' => 'DimensionList', ], ], ], 'ConfigurableUpfrontRateCardItem' => [ 'type' => 'structure', 'members' => [ 'selector' => [ 'shape' => 'Selector', ], 'constraints' => [ 'shape' => 'Constraints', ], 'rateCard' => [ 'shape' => 'RateCardList', ], ], ], 'ConfigurableUpfrontRateCardList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConfigurableUpfrontRateCardItem', ], ], 'Constraints' => [ 'type' => 'structure', 'members' => [ 'multipleDimensionSelection' => [ 'shape' => 'BoundedString', ], 'quantityConfiguration' => [ 'shape' => 'BoundedString', ], ], ], 'CurrencyCode' => [ 'type' => 'string', 'max' => 3, 'min' => 3, 'pattern' => '[A-Z]+', ], 'DescribeAgreementInput' => [ 'type' => 'structure', 'required' => [ 'agreementId', ], 'members' => [ 'agreementId' => [ 'shape' => 'ResourceId', ], ], ], 'DescribeAgreementOutput' => [ 'type' => 'structure', 'members' => [ 'agreementId' => [ 'shape' => 'ResourceId', ], 'acceptor' => [ 'shape' => 'Acceptor', ], 'proposer' => [ 'shape' => 'Proposer', ], 'startTime' => [ 'shape' => 'Timestamp', ], 'endTime' => [ 'shape' => 'Timestamp', ], 'acceptanceTime' => [ 'shape' => 'Timestamp', ], 'agreementType' => [ 'shape' => 'AgreementType', ], 'estimatedCharges' => [ 'shape' => 'EstimatedCharges', ], 'proposalSummary' => [ 'shape' => 'ProposalSummary', ], 'status' => [ 'shape' => 'AgreementStatus', ], ], ], 'Dimension' => [ 'type' => 'structure', 'required' => [ 'dimensionKey', 'dimensionValue', ], 'members' => [ 'dimensionKey' => [ 'shape' => 'BoundedString', ], 'dimensionValue' => [ 'shape' => 'ZeroValueInteger', ], ], ], 'DimensionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Dimension', ], 'min' => 1, ], 'DocumentItem' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'BoundedString', ], 'url' => [ 'shape' => 'BoundedString', ], 'version' => [ 'shape' => 'BoundedString', ], ], ], 'DocumentList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DocumentItem', ], ], 'EstimatedCharges' => [ 'type' => 'structure', 'members' => [ 'currencyCode' => [ 'shape' => 'CurrencyCode', ], 'agreementValue' => [ 'shape' => 'BoundedString', ], ], ], 'ExceptionMessage' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'Filter' => [ 'type' => 'structure', 'members' => [ 'name' => [ 'shape' => 'FilterName', ], 'values' => [ 'shape' => 'FilterValueList', ], ], ], 'FilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Filter', ], 'max' => 10, 'min' => 1, ], 'FilterName' => [ 'type' => 'string', 'max' => 32, 'min' => 1, 'pattern' => '[A-Za-z_]+', ], 'FilterValue' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[A-Za-z0-9+:_-]+', ], 'FilterValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FilterValue', ], 'max' => 1, 'min' => 1, ], 'FixedUpfrontPricingTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], 'currencyCode' => [ 'shape' => 'CurrencyCode', ], 'duration' => [ 'shape' => 'BoundedString', ], 'price' => [ 'shape' => 'BoundedString', ], 'grants' => [ 'shape' => 'GrantList', ], ], ], 'FreeTrialPricingTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], 'duration' => [ 'shape' => 'BoundedString', ], 'grants' => [ 'shape' => 'GrantList', ], ], ], 'GetAgreementTermsInput' => [ 'type' => 'structure', 'required' => [ 'agreementId', ], 'members' => [ 'agreementId' => [ 'shape' => 'ResourceId', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'GetAgreementTermsOutput' => [ 'type' => 'structure', 'members' => [ 'acceptedTerms' => [ 'shape' => 'AcceptedTermList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'GrantItem' => [ 'type' => 'structure', 'members' => [ 'dimensionKey' => [ 'shape' => 'BoundedString', ], 'maxQuantity' => [ 'shape' => 'PositiveIntegerWithDefaultValueOne', ], ], ], 'GrantList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GrantItem', ], ], 'ISO8601Duration' => [ 'type' => 'string', 'pattern' => '([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?', ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'requestId' => [ 'shape' => 'RequestId', ], 'message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, 'fault' => true, ], 'LegalTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], 'documents' => [ 'shape' => 'DocumentList', ], ], ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 50, 'min' => 1, ], 'NextToken' => [ 'type' => 'string', 'max' => 8192, 'min' => 0, 'pattern' => '[a-zA-Z0-9+/=]+', ], 'OfferId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '\\S{1,64}', ], 'OfferSetId' => [ 'type' => 'string', 'pattern' => '\\S{1,50}', ], 'PaymentRequestApprovalStrategy' => [ 'type' => 'string', 'enum' => [ 'AUTO_APPROVE_ON_EXPIRATION', 'WAIT_FOR_APPROVAL', ], ], 'PaymentScheduleTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], 'currencyCode' => [ 'shape' => 'CurrencyCode', ], 'schedule' => [ 'shape' => 'ScheduleList', ], ], ], 'PositiveIntegerWithDefaultValueOne' => [ 'type' => 'integer', 'box' => true, 'min' => 1, ], 'ProposalSummary' => [ 'type' => 'structure', 'members' => [ 'resources' => [ 'shape' => 'Resources', ], 'offerId' => [ 'shape' => 'OfferId', ], 'offerSetId' => [ 'shape' => 'OfferSetId', ], ], ], 'Proposer' => [ 'type' => 'structure', 'members' => [ 'accountId' => [ 'shape' => 'AWSAccountId', ], ], ], 'RateCardItem' => [ 'type' => 'structure', 'members' => [ 'dimensionKey' => [ 'shape' => 'BoundedString', ], 'price' => [ 'shape' => 'BoundedString', ], ], ], 'RateCardList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RateCardItem', ], ], 'RecurringPaymentTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], 'currencyCode' => [ 'shape' => 'CurrencyCode', ], 'billingPeriod' => [ 'shape' => 'BoundedString', ], 'price' => [ 'shape' => 'BoundedString', ], ], ], 'RenewalTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], 'configuration' => [ 'shape' => 'RenewalTermConfiguration', ], ], ], 'RenewalTermConfiguration' => [ 'type' => 'structure', 'required' => [ 'enableAutoRenew', ], 'members' => [ 'enableAutoRenew' => [ 'shape' => 'Boolean', ], ], ], 'RequestId' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[A-Za-z0-9-]+', ], 'Resource' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'ResourceId', ], 'type' => [ 'shape' => 'AgreementResourceType', ], ], ], 'ResourceId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[A-Za-z0-9_/-]+', ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'requestId' => [ 'shape' => 'RequestId', ], 'message' => [ 'shape' => 'ExceptionMessage', ], 'resourceId' => [ 'shape' => 'ResourceId', ], 'resourceType' => [ 'shape' => 'ResourceType', ], ], 'exception' => true, ], 'ResourceType' => [ 'type' => 'string', 'enum' => [ 'Agreement', ], ], 'Resources' => [ 'type' => 'list', 'member' => [ 'shape' => 'Resource', ], ], 'ScheduleItem' => [ 'type' => 'structure', 'members' => [ 'chargeDate' => [ 'shape' => 'Timestamp', ], 'chargeAmount' => [ 'shape' => 'BoundedString', ], ], ], 'ScheduleList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ScheduleItem', ], ], 'SearchAgreementsInput' => [ 'type' => 'structure', 'members' => [ 'catalog' => [ 'shape' => 'Catalog', ], 'filters' => [ 'shape' => 'FilterList', ], 'sort' => [ 'shape' => 'Sort', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'SearchAgreementsOutput' => [ 'type' => 'structure', 'members' => [ 'agreementViewSummaries' => [ 'shape' => 'AgreementViewSummaryList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'Selector' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'BoundedString', ], 'value' => [ 'shape' => 'BoundedString', ], ], ], 'Sort' => [ 'type' => 'structure', 'members' => [ 'sortBy' => [ 'shape' => 'SortBy', ], 'sortOrder' => [ 'shape' => 'SortOrder', ], ], ], 'SortBy' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '[A-Za-z_]+', ], 'SortOrder' => [ 'type' => 'string', 'enum' => [ 'ASCENDING', 'DESCENDING', ], ], 'SupportTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], 'refundPolicy' => [ 'shape' => 'BoundedString', ], ], ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'requestId' => [ 'shape' => 'RequestId', ], 'message' => [ 'shape' => 'ExceptionMessage', ], ], 'exception' => true, ], 'Timestamp' => [ 'type' => 'timestamp', ], 'UnversionedTermType' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, 'pattern' => '[A-Za-z]+', ], 'UsageBasedPricingTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], 'currencyCode' => [ 'shape' => 'CurrencyCode', ], 'rateCards' => [ 'shape' => 'UsageBasedRateCardList', ], ], ], 'UsageBasedRateCardItem' => [ 'type' => 'structure', 'members' => [ 'rateCard' => [ 'shape' => 'RateCardList', ], ], ], 'UsageBasedRateCardList' => [ 'type' => 'list', 'member' => [ 'shape' => 'UsageBasedRateCardItem', ], ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'requestId' => [ 'shape' => 'RequestId', ], 'message' => [ 'shape' => 'ExceptionMessage', ], 'reason' => [ 'shape' => 'ValidationExceptionReason', ], 'fields' => [ 'shape' => 'ValidationExceptionFieldList', ], ], 'exception' => true, ], 'ValidationExceptionField' => [ 'type' => 'structure', 'required' => [ 'name', 'message', ], 'members' => [ 'name' => [ 'shape' => 'BoundedString', ], 'message' => [ 'shape' => 'BoundedString', ], ], ], 'ValidationExceptionFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidationExceptionField', ], ], 'ValidationExceptionReason' => [ 'type' => 'string', 'enum' => [ 'INVALID_AGREEMENT_ID', 'MISSING_AGREEMENT_ID', 'INVALID_CATALOG', 'INVALID_FILTER_NAME', 'INVALID_FILTER_VALUES', 'INVALID_SORT_BY', 'INVALID_SORT_ORDER', 'INVALID_NEXT_TOKEN', 'INVALID_MAX_RESULTS', 'UNSUPPORTED_FILTERS', 'OTHER', ], ], 'ValidityTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], 'agreementDuration' => [ 'shape' => 'BoundedString', ], 'agreementStartDate' => [ 'shape' => 'Timestamp', ], 'agreementEndDate' => [ 'shape' => 'Timestamp', ], ], ], 'VariablePaymentTerm' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'UnversionedTermType', ], 'currencyCode' => [ 'shape' => 'CurrencyCode', ], 'maxTotalChargeAmount' => [ 'shape' => 'BoundedString', ], 'configuration' => [ 'shape' => 'VariablePaymentTermConfiguration', ], ], ], 'VariablePaymentTermConfiguration' => [ 'type' => 'structure', 'required' => [ 'paymentRequestApprovalStrategy', ], 'members' => [ 'paymentRequestApprovalStrategy' => [ 'shape' => 'PaymentRequestApprovalStrategy', ], 'expirationDuration' => [ 'shape' => 'ISO8601Duration', ], ], ], 'ZeroValueInteger' => [ 'type' => 'integer', 'min' => 0, ], ],];
