/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.data.input.InputCellFileAction;
import com.intellij.jupyter.core.jupyter.data.input.InputCellTableAction;
import com.intellij.jupyter.core.jupyter.data.input.JupyterAttachNewFileAction;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputValuesContributorExtensionPoint;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.utils.JupyterPathUtils;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "cell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "createLabel", "Ljavax/swing/JLabel;", "text", "font", "Ljava/awt/Font;", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterDataInputSelectPopupAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataInputSelectPopupAction.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,301:1\n1#2:302\n1374#3:303\n1460#3,5:304\n1374#3:309\n1460#3,5:310\n1491#3:315\n1516#3,3:316\n1519#3,3:326\n382#4,7:319\n216#5,2:329\n*S KotlinDebug\n*F\n+ 1 JupyterDataInputSelectPopupAction.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction\n*L\n145#1:303\n145#1:304,5\n146#1:309\n146#1:310,5\n159#1:315\n159#1:316,3\n159#1:326,3\n159#1:319,7\n159#1:329,2\n*E\n"})
public final class JupyterDataInputSelectPopupAction
extends DumbAwareAction
implements CustomComponentAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final JupyterCell cell;
    @NotNull
    private static final Key<String> IS_FILE_OR_TABLE_SET;

    public JupyterDataInputSelectPopupAction(@NotNull Editor editor, @NotNull JupyterCell cell) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.editor = editor;
        this.cell = cell;
        Presentation it = presentation = this.getTemplatePresentation();
        boolean bl = false;
        it.putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        it.putClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR, (Object)true);
    }

    public void update(@NotNull AnActionEvent e) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = JupyterEditorExtensionsKt.getNotebookFileOrNull(this.editor);
        if (object != null && (object = object.getFile()) != null && (object = object.toNioPath()) != null) {
            Object it = object;
            boolean bl = false;
            JupyterDataInputCellMetadata jupyterDataInputCellMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata(this.cell);
            path = jupyterDataInputCellMetadata != null ? jupyterDataInputCellMetadata.getFilePath((Path)it) : null;
        } else {
            path = null;
        }
        Path dataPath = path;
        Project project = this.editor.getProject();
        if (dataPath != null && project != null) {
            String fileName = JupyterPathUtils.INSTANCE.getFileUserPresentableString(dataPath, project);
            Presentation presentation = e.getPresentation();
            String string = FileUtil.toSystemDependentName((String)StringUtil.escapeMnemonics((String)fileName));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
            presentation.setText(com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputSelectPopupAction$Companion.trimPath$default(Companion, string, 100, '\u0000', 2, null));
            e.getPresentation().putClientProperty(IS_FILE_OR_TABLE_SET, (Object)"FILE");
            e.getPresentation().putClientProperty(ActionUtil.TOOLTIP_TEXT, (Object)fileName);
        } else if (JupyterDataInputCellTableMetadataKt.getHasTableMetadata(this.cell)) {
            Project project2 = e.getProject();
            JupyterDataInputCellTableMetadata jupyterDataInputCellTableMetadata = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata(this.cell);
            String tableName = jupyterDataInputCellTableMetadata != null ? jupyterDataInputCellTableMetadata.getTableName() : null;
            Presentation presentation = e.getPresentation();
            String string = tableName;
            if (string == null) {
                string = "";
            }
            presentation.setText(StringUtil.escapeMnemonics((String)string));
            e.getPresentation().putClientProperty(IS_FILE_OR_TABLE_SET, (Object)"TABLE");
            JupyterDataInputCellTableMetadata jupyterDataInputCellTableMetadata2 = JupyterDataInputCellTableMetadataKt.getDataInputTableMetadata(this.cell);
            String dataSourceUniqueId = jupyterDataInputCellTableMetadata2 != null ? jupyterDataInputCellTableMetadata2.getDataSourceUniqueId() : null;
            String tooltip = tableName;
            if (project2 != null && dataSourceUniqueId != null) {
                String sourceName;
                block11: {
                    String string2;
                    for (JupyterDataInputValuesContributorExtensionPoint it : (Iterable)JupyterDataInputValuesContributorExtensionPoint.Companion.getEP_NAME$intellij_jupyter_core().getExtensionList()) {
                        boolean bl = false;
                        String string3 = it.getNameOfDataSource(project2, dataSourceUniqueId);
                        if (string3 == null) continue;
                        string2 = string3;
                        break block11;
                    }
                    string2 = sourceName = null;
                }
                if (sourceName != null) {
                    HtmlBuilder htmlBuilder = new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)JupyterBundle.message("jupyter.data.input.toolbar.table", new Object[0])).wrapWith("strong")).append(HtmlChunk.nbsp());
                    String string4 = tableName;
                    if (string4 == null) {
                        string4 = "";
                    }
                    tooltip = htmlBuilder.append(HtmlChunk.text((String)string4)).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.text((String)JupyterBundle.message("jupyter.data.input.toolbar.source", new Object[0])).wrapWith("strong")).append(HtmlChunk.nbsp()).append(HtmlChunk.text((String)sourceName)).toString();
                }
            }
            e.getPresentation().putClientProperty(ActionUtil.TOOLTIP_TEXT, (Object)tooltip);
        } else {
            e.getPresentation().setText(JupyterBundle.message("jupyter.data.input.toolbar.dnd.text.no.file", new Object[0]));
            e.getPresentation().putClientProperty(IS_FILE_OR_TABLE_SET, (Object)"NOTHING");
            e.getPresentation().putClientProperty(ActionUtil.TOOLTIP_TEXT, (Object)JupyterBundle.message("jupyter.data.input.toolbar.dnd.text.no.file", new Object[0]));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JComponent jComponent = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (jComponent == null) {
            return;
        }
        JComponent component2 = jComponent;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        JBPopup popup = this.createPopup(dataContext, project2);
        if (popup == null) {
            JupyterAttachNewFileAction.Companion.attachNewFile$intellij_jupyter_core(project2, this.editor, this.cell);
        } else {
            popup.showUnderneathOf((Component)component2);
        }
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        ActionButtonWithText button2 = new ActionButtonWithText(this, presentation, place, dimension){
            final /* synthetic */ Presentation $presentation;
            {
                this.$presentation = $presentation;
                super((AnAction)$receiver, $presentation, $place, $super_call_param$1);
            }

            public Insets getInsets() {
                JBInsets jBInsets = JBInsets.emptyInsets();
                Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
                return (Insets)jBInsets;
            }

            protected boolean shallPaintDownArrow() {
                return true;
            }

            public String getToolTipText() {
                return (String)this.$presentation.getClientProperty(ActionUtil.TOOLTIP_TEXT);
            }
        };
        button2.setHorizontalTextAlignment(2);
        button2.setFont((Font)JBFont.small());
        JupyterDataInputCellMetadata jupyterDataInputCellMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata(this.cell);
        String text = (jupyterDataInputCellMetadata != null ? jupyterDataInputCellMetadata.hasFileMetadata() : false) ? JupyterBundle.message("jupyter.data.input.toolbar.file", new Object[0]) : JupyterBundle.message("jupyter.data.input.toolbar.table", new Object[0]);
        Font font = button2.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        JLabel textLabel = this.createLabel(text, font);
        JupyterDataInputCellMetadata jupyterDataInputCellMetadata2 = JupyterDataInputCellMetadataKt.getDataInputMetadata(this.cell);
        textLabel.setVisible((jupyterDataInputCellMetadata2 != null ? jupyterDataInputCellMetadata2.hasFileMetadata() : false) || JupyterDataInputCellTableMetadataKt.getHasTableMetadata(this.cell));
        presentation.addPropertyChangeListener(arg_0 -> JupyterDataInputSelectPopupAction.createCustomComponent$lambda$3(this, textLabel, arg_0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(textLabel);
        panel.add((Component)button2);
        return panel;
    }

    private final JLabel createLabel(@Nls String text, Font font) {
        JLabel label = new JLabel(text);
        label.setFont(font);
        label.setForeground(UIUtil.getLabelInfoForeground());
        label.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        return label;
    }

    /*
     * WARNING - void declaration
     */
    private final JBPopup createPopup(DataContext dataContext, Project project) {
        Iterable $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        Iterable $this$flatMap$iv = JupyterDataInputValuesContributorExtensionPoint.Companion.getEP_NAME$intellij_jupyter_core().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            JupyterDataInputValuesContributorExtensionPoint it = (JupyterDataInputValuesContributorExtensionPoint)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles(project);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List files = (List)destination$iv$iv;
        Iterable $this$flatMap$iv2 = JupyterDataInputValuesContributorExtensionPoint.Companion.getEP_NAME$intellij_jupyter_core().getExtensionList();
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv2;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JupyterDataInputValuesContributorExtensionPoint it = (JupyterDataInputValuesContributorExtensionPoint)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getTables(project);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List tables = (List)destination$iv$iv2;
        if (files.isEmpty() && tables.isEmpty()) {
            return null;
        }
        if (!((Collection)files).isEmpty()) {
            actionGroup.add((AnAction)Separator.create((String)JupyterBundle.message("jupyter.data.input.toolbar.text.files", new Object[0])));
            for (VirtualFile file : files) {
                actionGroup.add((AnAction)new InputCellFileAction(file, this.editor, this.cell));
            }
        }
        if (!((Collection)tables).isEmpty()) {
            void $this$forEach$iv;
            void $this$groupByTo$iv$iv;
            Object $this$groupBy$iv = tables;
            boolean $i$f$groupBy = false;
            $this$flatMapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                JupyterDataInputValuesContributorExtensionPoint.TableInfo it = (JupyterDataInputValuesContributorExtensionPoint.TableInfo)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it.getConnectionName();
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String connectionName = (String)entry.getKey();
                List tables2 = (List)entry.getValue();
                actionGroup.add((AnAction)Separator.create((String)connectionName));
                for (JupyterDataInputValuesContributorExtensionPoint.TableInfo table : tables2) {
                    actionGroup.add((AnAction)new InputCellTableAction(table, this.cell, this.editor));
                }
            }
        }
        actionGroup.add((AnAction)Separator.getInstance());
        actionGroup.add((AnAction)new JupyterAttachNewFileAction(this.editor, this.cell));
        Condition preselectCondition = arg_0 -> JupyterDataInputSelectPopupAction.createPopup$lambda$8(this, arg_0);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, null, -1, preselectCondition, null);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup = listPopup;
        return (JBPopup)popup;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private static final void createCustomComponent$lambda$3(JupyterDataInputSelectPopupAction this$0, JLabel $textLabel, PropertyChangeEvent event) {
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)IS_FILE_OR_TABLE_SET.toString())) {
            JupyterDataInputCellMetadata jupyterDataInputCellMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata(this$0.cell);
            String text = (jupyterDataInputCellMetadata != null ? jupyterDataInputCellMetadata.hasFileMetadata() : false) ? JupyterBundle.message("jupyter.data.input.toolbar.file", new Object[0]) : JupyterBundle.message("jupyter.data.input.toolbar.table", new Object[0]);
            $textLabel.setText(text);
            JupyterDataInputCellMetadata jupyterDataInputCellMetadata2 = JupyterDataInputCellMetadataKt.getDataInputMetadata(this$0.cell);
            $textLabel.setVisible((jupyterDataInputCellMetadata2 != null ? jupyterDataInputCellMetadata2.hasFileMetadata() : false) || JupyterDataInputCellTableMetadataKt.getHasTableMetadata(this$0.cell));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createPopup$lambda$8(JupyterDataInputSelectPopupAction this$0, AnAction it) {
        if (it instanceof InputCellFileAction) {
            JupyterDataInputCellMetadata jupyterDataInputCellMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata(this$0.cell);
            if (Intrinsics.areEqual((Object)((InputCellFileAction)it).getNotebookRelativizedFilePath(), (Object)(jupyterDataInputCellMetadata != null ? jupyterDataInputCellMetadata.getNotebookRelativedFilePath() : null))) return true;
        }
        if (!(it instanceof InputCellTableAction)) return false;
        if (!Intrinsics.areEqual((Object)((InputCellTableAction)it).getCell(), (Object)this$0.cell)) return false;
        return true;
    }

    static {
        Key key = Key.create((String)"IS_FILE_OR_TABLE_SET");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_FILE_OR_TABLE_SET = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction$Companion;", "", "<init>", "()V", "IS_FILE_OR_TABLE_SET", "Lcom/intellij/openapi/util/Key;", "", "trimPath", "maxLength", "", "sep", "", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterDataInputSelectPopupAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataInputSelectPopupAction.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,301:1\n1#2:302\n774#3:303\n865#3,2:304\n*S KotlinDebug\n*F\n+ 1 JupyterDataInputSelectPopupAction.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction$Companion\n*L\n208#1:303\n208#1:304,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NlsSafe
        @NotNull
        public final String trimPath(@NotNull String $this$trimPath, int maxLength, char sep) {
            StringBuilder stringBuilder;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$trimPath, (String)"<this>");
            if (!(maxLength >= 4)) {
                boolean $i$a$-require-JupyterDataInputSelectPopupAction$Companion$trimPath$22 = false;
                String $i$a$-require-JupyterDataInputSelectPopupAction$Companion$trimPath$22 = "maxLength must be >= 4";
                throw new IllegalArgumentException($i$a$-require-JupyterDataInputSelectPopupAction$Companion$trimPath$22.toString());
            }
            if ($this$trimPath.length() <= maxLength) {
                return $this$trimPath;
            }
            String sepStr = String.valueOf(sep);
            String ellipsis = "...";
            char[] cArray = new char[]{sep};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)$this$trimPath, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List tokens = (List)destination$iv$iv;
            if (tokens.size() < 2) {
                return StringsKt.take((String)$this$trimPath, (int)(maxLength - 3)) + ellipsis;
            }
            String prefix = StringsKt.startsWith$default((CharSequence)$this$trimPath, (char)sep, (boolean)false, (int)2, null) ? sepStr : "";
            String first = (String)CollectionsKt.first((List)tokens);
            String last = (String)CollectionsKt.last((List)tokens);
            int baseLen = prefix.length() + first.length() + sepStr.length() + ellipsis.length() + sepStr.length() + last.length();
            if (baseLen > maxLength) {
                return prefix + first + sepStr + ellipsis + sepStr + last;
            }
            List middle = new ArrayList();
            int currentLen = baseLen;
            for (String part : tokens.subList(1, tokens.size() - 1)) {
                int addLen = sepStr.length() + part.length();
                if (currentLen + addLen > maxLength) break;
                middle.add(part);
                currentLen += addLen;
            }
            String middleSection = !((Collection)middle).isEmpty() ? sepStr + CollectionsKt.joinToString$default((Iterable)middle, (CharSequence)sepStr, null, null, (int)0, null, null, (int)62, null) : "";
            StringBuilder $this$trimPath_u24lambda_u242 = stringBuilder = new StringBuilder(currentLen);
            boolean bl = false;
            $this$trimPath_u24lambda_u242.append(prefix);
            $this$trimPath_u24lambda_u242.append(first);
            $this$trimPath_u24lambda_u242.append(middleSection);
            $this$trimPath_u24lambda_u242.append(sepStr);
            $this$trimPath_u24lambda_u242.append(ellipsis);
            $this$trimPath_u24lambda_u242.append(sepStr);
            $this$trimPath_u24lambda_u242.append(last);
            return stringBuilder.toString();
        }

        public static /* synthetic */ String trimPath$default(Companion companion, String string, int n, char c, int n2, Object object) {
            if ((n2 & 2) != 0) {
                c = File.separatorChar;
            }
            return companion.trimPath(string, n, c);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

