/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class BaseExtResourceAction
extends BaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            BaseExtResourceAction.$$$reportNull$$$0(0);
        }
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        String uri = BaseExtResourceAction.findUri(psiFile, offset);
        if (uri == null || !this.isAcceptableUri(uri)) {
            return false;
        }
        this.setText(XmlBundle.message(this.getQuickFixKeyId(), new Object[0]));
        return true;
    }

    protected boolean isAcceptableUri(String uri) {
        return true;
    }

    protected abstract String getQuickFixKeyId();

    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message(this.getQuickFixKeyId(), new Object[0]);
        if (string == null) {
            BaseExtResourceAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            BaseExtResourceAction.$$$reportNull$$$0(2);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        String uri = BaseExtResourceAction.findUri(psiFile, offset);
        if (uri == null) {
            return;
        }
        this.doInvoke(psiFile, offset, uri, editor);
    }

    protected abstract void doInvoke(@NotNull PsiFile var1, int var2, @NotNull String var3, Editor var4) throws IncorrectOperationException;

    @Nullable
    @NlsSafe
    public static String findUri(PsiFile psiFile, int offset) {
        PsiElement element = psiFile.findElementAt(offset);
        if (element == null || element instanceof PsiWhiteSpace) {
            return null;
        }
        PsiReference currentRef = psiFile.getViewProvider().findReferenceAt(offset, psiFile.getLanguage());
        if (currentRef == null) {
            currentRef = psiFile.getViewProvider().findReferenceAt(offset);
        }
        if (currentRef instanceof URLReference || currentRef instanceof DependentNSReference) {
            return currentRef.getCanonicalText();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/BaseExtResourceAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/BaseExtResourceAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

