/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ckb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "فیجی";
        final String metaValue_NR = "نائوروو";
        final String metaValue_TV = "تووڤالوو";
        final String metaValue_ar = "عەرەبی";
        final String metaValue_hy = "ئەرمەنی";
        final String metaValue_el = "یۆنانی";
        final String metaValue_he = "عیبری";
        final String metaValue_ja = "ژاپۆنی";
        final String metaValue_km = "خمێر";
        final String metaValue_kn = "کاننادا";
        final String metaValue_la = "لاتینی";
        final String metaValue_ml = "مالایالام";
        final String metaValue_mn = "مەنگۆلی";
        final String metaValue_MM = "میانمار";
        final String metaValue_or = "ئۆدیا";
        final String metaValue_ta = "تامیلی";
        final String metaValue_te = "تێلووگوو";
        final String metaValue_th = "تایلەندی";
        final String metaValue_bo = "تەبەتی";
        final Object[][] data = new Object[][] {
            { "001", "جیهان" },
            { "002", "ئەفریقا" },
            { "003", "ئەمەریکای باکوور" },
            { "005", "ئەمەریکای باشوور" },
            { "009", "ئۆقیانووسیا" },
            { "011", "ڕۆژاوای ئەفریقا" },
            { "013", "ئەمریکای ناوەڕاست" },
            { "014", "ڕۆژھەڵاتی ئەفریقا" },
            { "015", "باکووری ئەفریقا" },
            { "017", "ناوەڕاستی ئەفریقا" },
            { "018", "باشووری ئەفریقا" },
            { "019", "ئەمەریکای باکوور و باشوور" },
            { "021", "ئەمریکای باکوور" },
            { "029", "کاریبی" },
            { "030", "ڕۆژهەڵاتی ئاسیا" },
            { "034", "باشووری ئاسیا" },
            { "035", "باشووری ڕۆژھەڵاتی ئاسیا" },
            { "039", "باشووری ئەورووپا" },
            { "053", "ئۆسترالیا" },
            { "054", "میلانێزیا" },
            { "057", "ناوچەی مایکرۆنیزیا" },
            { "061", "پۆلینیزیا" },
            { "142", "ئاسیا" },
            { "143", "ناوەڕاستی ئاسیا" },
            { "145", "ڕۆژاوای ئاسیا" },
            { "150", "ئەورووپا" },
            { "151", "ڕۆژهەڵاتی ئەورووپا" },
            { "154", "باکووری ئەورووپا" },
            { "155", "ڕۆژاوای ئەورووپا" },
            { "202", "ئەفریقای ژێر سەحرا" },
            { "419", "ئەمەریکای لاتین" },
            { "AC", "دوورگەی ئاسینسیۆن" },
            { "AD", "ئاندۆرا" },
            { "AE", "میرنشینە یەکگرتووە عەرەبییەکان" },
            { "AF", "ئەفغانستان" },
            { "AG", "ئانتیگوا و باربودا" },
            { "AI", "ئانگویلا" },
            { "AL", "ئەڵبانیا" },
            { "AM", "ئەرمەنستان" },
            { "AO", "ئەنگۆلا" },
            { "AQ", "ئانتارکتیکا" },
            { "AR", "ئەرژەنتین" },
            { "AS", "ساموای ئەمەریکایی" },
            { "AT", "نەمسا" },
            { "AU", "ئوسترالیا" },
            { "AW", "ئارووبا" },
            { "AX", "دوورگەکانی ئالاند" },
            { "AZ", "ئازەربایجان" },
            { "BA", "بۆسنیا و ھەرزەگۆڤینا" },
            { "BB", "باربادۆس" },
            { "BD", "بەنگلادیش" },
            { "BE", "بەلژیک" },
            { "BF", "بورکینافاسۆ" },
            { "BG", "بولگاریا" },
            { "BH", "بەحرەین" },
            { "BI", "بوروندی" },
            { "BJ", "بێنین" },
            { "BL", "سەن بارتێلێمی" },
            { "BM", "بێرموودا" },
            { "BN", "بروونای" },
            { "BO", "بۆلیڤیا" },
            { "BQ", "دوورگە کاریبیەکانی هۆڵەندا" },
            { "BR", "برازیل" },
            { "BS", "بەھاما" },
            { "BT", "بووتان" },
            { "BV", "دوورگەی بووڤێ" },
            { "BW", "بۆتسوانا" },
            { "BY", "بیلاڕووس" },
            { "BZ", "بەلیز" },
            { "CA", "کەنەدا" },
            { "CC", "دوورگەکانی کیلینگ" },
            { "CD", "کۆنگۆ کینشاسا" },
            { "CF", "کۆماری ئەفریقای ناوەڕاست" },
            { "CG", "کۆنگۆ برازاڤیل" },
            { "CH", "سویسڕا" },
            { "CI", "کۆتدیڤوار" },
            { "CK", "دوورگەکانی کوک" },
            { "CL", "چیلی" },
            { "CM", "کامیرۆن" },
            { "CN", "چین" },
            { "CO", "کۆلۆمبیا" },
            { "CP", "دوورگەی کلیپێرتۆن" },
            { "CR", "کۆستاریکا" },
            { "CU", "کووبا" },
            { "CV", "کەیپڤەرد" },
            { "CW", "کوراچاو" },
            { "CX", "دوورگەی کریسمس" },
            { "CY", "قیبرس" },
            { "CZ", "کۆماری چیک" },
            { "DE", "ئەڵمانیا" },
            { "DG", "دیەگۆ گارسیا" },
            { "DJ", "جیبووتی" },
            { "DK", "دانمارک" },
            { "DM", "دۆمینیکا" },
            { "DO", "کۆماری دۆمینیکا" },
            { "DZ", "جەزایر" },
            { "EA", "سێئووتا و مێلییا" },
            { "EC", "ئیکوادۆر" },
            { "EE", "ئیستۆنیا" },
            { "EG", "میسر" },
            { "EH", "سەحرای ڕۆژاوا" },
            { "ER", "ئەریتریا" },
            { "ES", "ئیسپانیا" },
            { "ET", "ئەتیۆپیا" },
            { "EU", "یەکێتیی ئەورووپا" },
            { "EZ", "ناوچەی یۆرۆ" },
            { "FI", "فینلاند" },
            { "FJ", metaValue_FJ },
            { "FK", "دوورگەکانی مالڤیناس (دوورگەکانی فاڵکلاند)" },
            { "FM", "مایکرۆنیزیا" },
            { "FO", "دوورگەکانی فارەو" },
            { "FR", "فەڕەنسا" },
            { "GA", "گابۆن" },
            { "GB", "شانشینی یەکگرتوو" },
            { "GD", "گرینادا" },
            { "GE", "گورجستان" },
            { "GF", "گیانای فەرەنسا" },
            { "GG", "گێرنزی" },
            { "GH", "غەنا" },
            { "GI", "گیبرالتار" },
            { "GL", "گرینلاند" },
            { "GM", "گامبیا" },
            { "GN", "گینێ" },
            { "GP", "گوادێلۆپ" },
            { "GQ", "گینێی ئیستوایی" },
            { "GR", "یۆنان" },
            { "GS", "دوورگەکانی جۆرجیا و ساندویچی باشوور" },
            { "GT", "گواتیمالا" },
            { "GU", "گوام" },
            { "GW", "گینێ بیساو" },
            { "GY", "گویانا" },
            { "HK", "هۆنگ کۆنگ" },
            { "HM", "دوورگەکانی هێرد و مەکدانڵد" },
            { "HN", "ھۆندووراس" },
            { "HR", "کرۆواتیا" },
            { "HT", "ھایتی" },
            { "HU", "هەنگاریا" },
            { "IC", "دوورگەکانی کەناری" },
            { "ID", "ئیندۆنیزیا" },
            { "IE", "ئیرلەند" },
            { "IL", "ئیسرائیل" },
            { "IM", "دوورگەی مان" },
            { "IN", "ھیندستان" },
            { "IQ", "عێراق" },
            { "IR", "ئێران" },
            { "IS", "ئایسلەند" },
            { "IT", "ئیتالیا" },
            { "JE", "جێرسی" },
            { "JM", "جامایکا" },
            { "JO", "ئوردن" },
            { "JP", "ژاپۆن" },
            { "KE", "کینیا" },
            { "KG", "کرگیزستان" },
            { "KH", "کەمبۆدیا" },
            { "KI", "کیریباس" },
            { "KM", "دوورگەکانی کۆمۆر" },
            { "KN", "سەن کیتس و نیڤیس" },
            { "KP", "کۆریای باکوور" },
            { "KR", "کۆریای باشوور" },
            { "KW", "کوەیت" },
            { "KY", "دوورگەکانی کایمان" },
            { "KZ", "کازاخستان" },
            { "LA", "لاوس" },
            { "LB", "لوبنان" },
            { "LC", "سەن لووسیا" },
            { "LI", "لیختنشتاین" },
            { "LK", "سریلانکا" },
            { "LR", "لیبەریا" },
            { "LS", "لەسۆتۆ" },
            { "LT", "لیتوانایا" },
            { "LU", "لوکسەمبورگ" },
            { "LV", "لاتڤیا" },
            { "LY", "لیبیا" },
            { "MA", "مەغریب" },
            { "MC", "مۆناکۆ" },
            { "MD", "مۆلدۆڤا" },
            { "ME", "مۆنتینیگرۆ" },
            { "MF", "سەن مارتین" },
            { "MG", "ماداگاسکار" },
            { "MH", "دوورگەکانی مارشاڵ" },
            { "MK", "مەکدۆنیای باکوور" },
            { "ML", "مالی" },
            { "MM", metaValue_MM },
            { "MN", "مەنگۆلیا" },
            { "MO", "ماکائۆ" },
            { "MP", "دوورگەکانی ماریانای باکوور" },
            { "MQ", "مارتینیک" },
            { "MR", "مۆریتانیا" },
            { "MS", "مۆنتسێرات" },
            { "MT", "ماڵتا" },
            { "MU", "مووریتیووس" },
            { "MV", "مالدیڤ" },
            { "MW", "مالاوی" },
            { "MX", "مەکسیک" },
            { "MY", "مالیزیا" },
            { "MZ", "مۆزامبیک" },
            { "NA", "نامیبیا" },
            { "NC", "نیووکالێدۆنیا" },
            { "NE", "نیجەر" },
            { "NF", "دوورگەی نۆرفۆڵک" },
            { "NG", "نیجریا" },
            { "NI", "نیکاراگوا" },
            { "NL", "ھۆڵەندا" },
            { "NO", "نۆرویژ" },
            { "NP", "نیپال" },
            { "NR", metaValue_NR },
            { "NU", "نیووئی" },
            { "NZ", "نیوزیلاند" },
            { "OM", "عومان" },
            { "PA", "پاناما" },
            { "PE", "پێروو" },
            { "PF", "پۆلینیسیای فەرەنسا" },
            { "PG", "پاپوا گینێی نوێ" },
            { "PH", "فلیپین" },
            { "PK", "پاکستان" },
            { "PL", "پۆڵەندا" },
            { "PM", "سەن پیێر و میکێلۆن" },
            { "PN", "دوورگەکانی پیتکەرن" },
            { "PR", "پۆرتۆڕیکۆ" },
            { "PS", "ناوچە فەلەستینیەکان" },
            { "PT", "پورتوگال" },
            { "PW", "پالاو" },
            { "PY", "پاراگوای" },
            { "QA", "قەتەر" },
            { "QO", "دەرەوەی ئۆقیانووسیا" },
            { "RE", "ڕییوونیەن" },
            { "RO", "ڕۆمانیا" },
            { "RS", "سربیا" },
            { "RU", "ڕووسیا" },
            { "RW", "ڕواندا" },
            { "SA", "عەرەبستانی سەعوودی" },
            { "SB", "دوورگەکانی سلێمان" },
            { "SC", "سیشێل" },
            { "SD", "سوودان" },
            { "SE", "سوید" },
            { "SG", "سینگاپور" },
            { "SH", "سەن هێلێنا" },
            { "SI", "سلۆڤێنیا" },
            { "SJ", "سڤالبارد و یان مایەن" },
            { "SK", "سلۆڤاکیا" },
            { "SL", "سیەرالیۆن" },
            { "SM", "سان مارینۆ" },
            { "SN", "سێنێگاڵ" },
            { "SO", "سۆمالیا" },
            { "SR", "سورینام" },
            { "SS", "سوودانی باشوور" },
            { "ST", "ساوتۆمێ و پرینسیپی" },
            { "SV", "ئێلسالڤادۆر" },
            { "SX", "سینت مارتن" },
            { "SY", "سووریا" },
            { "SZ", "سوازیلاند" },
            { "TA", "تریستێن دا کوونا" },
            { "TC", "دوورگەکانی تورکس و کایکۆس" },
            { "TD", "چاد" },
            { "TF", "هەرێمە باشووریەکانی فەرەنسا" },
            { "TG", "تۆگۆ" },
            { "TH", "تایلەند" },
            { "TJ", "تاجیکستان" },
            { "TK", "تۆکێلاو" },
            { "TL", "تیمۆری ڕۆژھەڵات" },
            { "TM", "تورکمانستان" },
            { "TN", "توونس" },
            { "TO", "تۆنگا" },
            { "TR", "تورکیا" },
            { "TT", "ترینیداد و تۆباگو" },
            { "TV", metaValue_TV },
            { "TW", "تایوان" },
            { "TZ", "تانزانیا" },
            { "UA", "ئۆکرانیا" },
            { "UG", "ئوگاندا" },
            { "UM", "دوورگەکانی دەرەوەی ئەمریکا" },
            { "UN", "نەتەوە یەکگرتووەکان" },
            { "US", "ویلایەتە یەکگرتووەکان" },
            { "UY", "ئوروگوای" },
            { "UZ", "ئوزبەکستان" },
            { "VA", "ڤاتیکان" },
            { "VC", "سەینت ڤینسەنت و گرینادینز" },
            { "VE", "ڤەنزوێلا" },
            { "VG", "دوورگەکانی ڤیرجنی بەریتانیا" },
            { "VI", "دوورگەکانی ڤیرجنی ئەمەریکا" },
            { "VN", "ڤیەتنام" },
            { "VU", "ڤانوواتوو" },
            { "WF", "والیس و فوتونا" },
            { "WS", "ساموا" },
            { "XK", "کۆسۆڤۆ" },
            { "YE", "یەمەن" },
            { "YT", "مایۆت" },
            { "ZA", "ئەفریقای باشوور" },
            { "ZM", "زامبیا" },
            { "ZW", "زیمبابوی" },
            { "ZZ", "ناوچەی نەناسراو" },
            { "aa", "ئەفار" },
            { "ab", "ئەبخازی" },
            { "af", "ئەفریکانس" },
            { "ak", "ئاکان" },
            { "am", "ئەمھەری" },
            { "an", "ئاراگۆنی" },
            { "ar", metaValue_ar },
            { "as", "ئاسامی" },
            { "av", "ئەڤاری" },
            { "ay", "ئایمارا" },
            { "az", "ئازەربایجانی" },
            { "ba", "باشکیەر" },
            { "be", "بیلاڕووسی" },
            { "bg", "بۆلگاری" },
            { "bi", "بیسلاما" },
            { "bm", "بامبارا" },
            { "bn", "بەنگلادێشی" },
            { "bo", metaValue_bo },
            { "br", "برێتونی" },
            { "bs", "بۆسنی" },
            { "ca", "كاتالۆنی" },
            { "ce", "چیچانی" },
            { "ch", "چامۆرۆ" },
            { "co", "کۆرسیکی" },
            { "cs", "چێکی" },
            { "cu", "سلاویی کلیسەیی" },
            { "cv", "چووڤاشی" },
            { "cy", "وێلزی" },
            { "da", "دانماركی" },
            { "de", "ئەڵمانی" },
            { "dv", "دیڤێهی" },
            { "dz", "دزوونگخا" },
            { "ee", "ئێوێیی" },
            { "el", metaValue_el },
            { "en", "ئینگلیزی" },
            { "eo", "ئێسپیرانتۆ" },
            { "es", "ئیسپانی" },
            { "et", "ئیستۆنی" },
            { "eu", "باسکی" },
            { "fa", "فارسی" },
            { "ff", "فوولایی" },
            { "fi", "فینلەندی" },
            { "fj", metaValue_FJ },
            { "fo", "فەرۆیی" },
            { "fr", "فەرەنسی" },
            { "fy", "فریسیی ڕۆژاوا" },
            { "ga", "ئیرلەندی" },
            { "gd", "گه‌لیكی سكۆتله‌ندی" },
            { "gl", "گالیسی" },
            { "gn", "گووارانی" },
            { "gu", "گوجاراتی" },
            { "gv", "مانکی" },
            { "ha", "هائووسا" },
            { "he", metaValue_he },
            { "hi", "هیندی" },
            { "hr", "كرواتی" },
            { "ht", "کریولی هائیتی" },
            { "hu", "هەنگاری" },
            { "hy", metaValue_hy },
            { "hz", "هێرێرۆ" },
            { "ia", "ئینترلینگووا" },
            { "id", "ئیندۆنیزی" },
            { "ig", "ئیگبۆ" },
            { "ii", "سیچوان یی" },
            { "io", "ئیدۆ" },
            { "is", "ئیسلەندی" },
            { "it", "ئیتالی" },
            { "iu", "ئینوکتیتوت" },
            { "ja", metaValue_ja },
            { "jv", "جاڤایی" },
            { "ka", "گۆرجستانی" },
            { "ki", "کیکوویوو" },
            { "kj", "کوانیاما" },
            { "kk", "کازاخی" },
            { "kl", "کالالیسووت" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", "كۆری" },
            { "kr", "کانووری" },
            { "ks", "کەشمیری" },
            { "ku", "کوردی" },
            { "kv", "کۆمی" },
            { "kw", "کۆڕنی" },
            { "ky", "كرگیزی" },
            { "la", metaValue_la },
            { "lb", "لوکسەمبورگی" },
            { "lg", "گاندا" },
            { "li", "لیمبورگی" },
            { "ln", "لينگالا" },
            { "lo", "لائۆیی" },
            { "lt", "لیتوانی" },
            { "lu", "لووبا کاتانگا" },
            { "lv", "لێتۆنی" },
            { "mg", "مالاگاسی" },
            { "mh", "مارشاڵی" },
            { "mi", "مائۆری" },
            { "mk", "ماكێدۆنی" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "ماراتی" },
            { "ms", "مالیزی" },
            { "mt", "ماڵتی" },
            { "my", "میانماری" },
            { "na", metaValue_NR },
            { "nb", "نەرویژیی بۆکمال" },
            { "nd", "ئندێبێلێی باکوور" },
            { "ne", "نیپالی" },
            { "ng", "ندۆنگا" },
            { "nl", "هۆڵەندی" },
            { "nn", "نەرویژیی نینۆرسک" },
            { "no", "نۆروێژی" },
            { "nr", "ئندێبێلێی باشوور" },
            { "nv", "ناڤاجۆ" },
            { "ny", "نیانجا" },
            { "oc", "ئۆکسیتانی" },
            { "om", "ئۆرۆمۆ" },
            { "or", metaValue_or },
            { "os", "ئۆسێتی" },
            { "pa", "پەنجابی" },
            { "pl", "پۆڵەندی" },
            { "ps", "پەشتوو" },
            { "pt", "پورتوگالی" },
            { "qu", "کێچوا" },
            { "rm", "ڕۆمانش" },
            { "rn", "ڕووندی" },
            { "ro", "ڕۆمانی" },
            { "ru", "ڕووسی" },
            { "rw", "کینیارواندا" },
            { "sa", "سانسکريت" },
            { "sc", "ساردینی" },
            { "sd", "سيندی" },
            { "se", "سامیی باکوور" },
            { "sg", "سانگۆ" },
            { "si", "سینهالی" },
            { "sk", "سلۆڤاكی" },
            { "sl", "سلۆڤێنی" },
            { "sm", "سامۆیی" },
            { "sn", "شۆنا" },
            { "so", "سۆمالی" },
            { "sq", "ئەڵبانی" },
            { "sr", "سربی" },
            { "ss", "سواتی" },
            { "st", "سۆتۆی باشوور" },
            { "su", "سوندانی" },
            { "sv", "سویدی" },
            { "sw", "سواهیلی" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "تاجیکی" },
            { "th", metaValue_th },
            { "ti", "تیگرینیا" },
            { "tk", "تورکمانی" },
            { "tn", "تسوانا" },
            { "to", "تۆنگان" },
            { "tr", "تورکی" },
            { "ts", "تسۆنگا" },
            { "tt", "تاتاری" },
            { "ty", "تاهیتی" },
            { "ug", "ئۆیخۆری" },
            { "uk", "ئۆكراینی" },
            { "ur", "ئۆردوو" },
            { "uz", "ئوزبەکی" },
            { "ve", "ڤێندا" },
            { "vi", "ڤیەتنامی" },
            { "vo", "ڤۆلاپووک" },
            { "wa", "والوون" },
            { "wo", "وۆلۆف" },
            { "xh", "سسوسا" },
            { "yi", "ییدیش" },
            { "yo", "یۆرووبا" },
            { "zh", "چینی" },
            { "zu", "زوولوو" },
            { "ace", "ئاچەیی" },
            { "ada", "دانگمێ" },
            { "ady", "ئادیگی" },
            { "agq", "ئاگێم" },
            { "ain", "ئاینوو" },
            { "ale", "ئالیوت" },
            { "alt", "ئاڵتایی باشوور" },
            { "anp", "ئەنگیکا" },
            { "arn", "ماپووچە" },
            { "arp", "ئاراپاهۆ" },
            { "asa", "ئاسوو" },
            { "ast", "ئاستۆری" },
            { "awa", "ئاوادهی" },
            { "ban", "بالی" },
            { "bas", "باسا" },
            { "bem", "بێمبا" },
            { "bez", "بێنا" },
            { "bho", "بوجپووری" },
            { "bin", "بینی" },
            { "bla", "سیکسیکا" },
            { "brx", "بۆدۆ" },
            { "bug", "بووگی" },
            { "byn", "بلین" },
            { "ceb", "سێبوانۆ" },
            { "cgg", "کیگا" },
            { "chk", "چووکی" },
            { "chm", "ماری" },
            { "cho", "چۆکتاو" },
            { "chr", "چێرۆکی" },
            { "chy", "شایان" },
            { "ckb", "کوردیی ناوەندی" },
            { "crs", "فەرەنسیی سیشێلی" },
            { "dak", "داکۆتایی" },
            { "dar", "دارگینی" },
            { "dav", "تایتا" },
            { "dgr", "دۆگریب" },
            { "dje", "زارما" },
            { "dsb", "سربیی خوارین" },
            { "dua", "دووالا" },
            { "dyo", "جۆلافۆنی" },
            { "dzg", "دازا" },
            { "ebu", "ئێمبوو" },
            { "efi", "ئێفیک" },
            { "eka", "ئێکاجووک" },
            { "ewo", "ئێوۆندۆ" },
            { "fil", "فیلیپینی" },
            { "fon", "فۆنی" },
            { "fur", "فریئوولی" },
            { "gaa", "گایی" },
            { "gez", "گیزی" },
            { "gil", "گیلبێرتی" },
            { "gor", "گۆرۆنتالی" },
            { "gsw", "ئەڵمانیی سویسڕا" },
            { "guz", "گووسی" },
            { "gwi", "گویچین" },
            { "haw", "هاوایی" },
            { "hil", "هیلیگاینۆن" },
            { "hmn", "همۆنگ" },
            { "hsb", "سربیی سەروو" },
            { "hup", "هووپا" },
            { "iba", "ئیبان" },
            { "ibb", "ئیبیبۆ" },
            { "ilo", "ئیلۆکۆ" },
            { "inh", "ئینگووش" },
            { "jbo", "لۆژبان" },
            { "jgo", "نگۆمبا" },
            { "jmc", "ماچامێ" },
            { "kab", "کبائیلی" },
            { "kac", "کاچین" },
            { "kaj", "کیجوو" },
            { "kam", "کامبا" },
            { "kbd", "کاباردی" },
            { "kcg", "تیاپ" },
            { "kde", "ماکۆندە" },
            { "kea", "کابووڤێردیانۆ" },
            { "kfo", "کۆرۆ" },
            { "kha", "کهاسی" },
            { "khq", "کۆیرا چینی" },
            { "kkj", "کاکۆ" },
            { "kln", "کالێنجین" },
            { "kmb", "کیمبووندوو" },
            { "kok", "کۆنکانی" },
            { "kpe", "کپێلێ" },
            { "krc", "کاراچای بالکار" },
            { "krl", "کارێلی" },
            { "kru", "کوورووخ" },
            { "ksb", "شامابالا" },
            { "ksf", "بافیا" },
            { "ksh", "کۆلۆنی" },
            { "kum", "کوومیک" },
            { "lad", "لادینۆ" },
            { "lag", "لانگی" },
            { "lez", "لەزگی" },
            { "lkt", "لاکۆتا" },
            { "loz", "لۆزی" },
            { "lrc", "لوڕیی باکوور" },
            { "lua", "لووبا لوولووا" },
            { "lun", "لووندا" },
            { "luo", "لووئۆ" },
            { "lus", "میزۆ" },
            { "luy", "لوویا" },
            { "mad", "مادووری" },
            { "mag", "ماگاهی" },
            { "mai", "مائیتیلی" },
            { "mak", "ماکاسار" },
            { "mas", "ماسایی" },
            { "mdf", "مۆکشا" },
            { "men", "مێندێ" },
            { "mer", "مێروو" },
            { "mfe", "مۆریسی" },
            { "mgh", "ماخوامیتۆ" },
            { "mgo", "مێتە" },
            { "mic", "میکماک" },
            { "min", "مینانکاباو" },
            { "mni", "مانیپووری" },
            { "moh", "مۆهاوک" },
            { "mos", "مۆسی" },
            { "mua", "موندانگ" },
            { "mul", "چەند زمان" },
            { "mus", "کریک" },
            { "mwl", "میراندی" },
            { "myv", "ئێرزیا" },
            { "mzn", "مازەندەرانی" },
            { "nap", "ناپۆلی" },
            { "naq", "ناما" },
            { "new", "نێواری" },
            { "nia", "نیاس" },
            { "niu", "نیئوویی" },
            { "nmg", "کواسیۆ" },
            { "nnh", "نگیمبوون" },
            { "nog", "نۆگای" },
            { "nqo", "نکۆ" },
            { "nso", "سۆتۆی باکوور" },
            { "nus", "نوێر" },
            { "nyn", "نیانکۆلێ" },
            { "pag", "پانگاسینان" },
            { "pam", "پامپانگا" },
            { "pap", "پاپیامێنتۆ" },
            { "pau", "پالائوویی" },
            { "pcm", "پیجینی نیجریا" },
            { "prg", "پڕووسی" },
            { "quc", "کیچەیی" },
            { "rap", "ڕاپانوویی" },
            { "rar", "ڕاڕۆتۆنگان" },
            { "rof", "ڕۆمبۆ" },
            { "rup", "ئارمۆمانی" },
            { "rwk", "ڕوا" },
            { "sad", "سانداوێ" },
            { "sah", "ساخا" },
            { "saq", "سامبووروو" },
            { "sat", "سانتالی" },
            { "sba", "نگامبای" },
            { "sbp", "سانگوو" },
            { "scn", "سیسیلی" },
            { "sco", "سکۆتس" },
            { "sdh", "کوردیی باشووری" },
            { "seh", "سێنا" },
            { "ses", "کۆیرابۆرۆ سێنی" },
            { "shi", "شیلها" },
            { "shn", "شان" },
            { "sma", "سامیی باشوور" },
            { "smj", "لوولێ سامی" },
            { "smn", "ئیناری سامی" },
            { "sms", "سامیی سکۆڵت" },
            { "snk", "سۆنینکێ" },
            { "srn", "سرانان تۆنگۆ" },
            { "ssy", "ساهۆ" },
            { "suk", "سووکووما" },
            { "swb", "کۆمۆری" },
            { "syr", "سریانی" },
            { "tem", "تیمنێ" },
            { "teo", "تێسوو" },
            { "tet", "تێتووم" },
            { "tig", "تیگرێ" },
            { "tlh", "كلینگۆن" },
            { "tpi", "تۆکپیسین" },
            { "trv", "تارۆکۆ" },
            { "tum", "تومبووکا" },
            { "tvl", metaValue_TV },
            { "twq", "تاساواک" },
            { "tyv", "تووڤینی" },
            { "tzm", "ئەمازیغی ناوەڕاست" },
            { "udm", "ئوودموورت" },
            { "umb", "ئومبووندوو" },
            { "und", "زمانی نەناسراو" },
            { "vai", "ڤایی" },
            { "vun", "ڤوونجوو" },
            { "wae", "والسێر" },
            { "wal", "وۆلایتا" },
            { "war", "وارای" },
            { "xal", "کالمیک" },
            { "xog", "سۆگا" },
            { "yav", "یانگبێن" },
            { "ybb", "یێمبا" },
            { "yue", "کانتۆنی" },
            { "zgh", "ئەمازیغیی مەغریب" },
            { "zun", "زوونی" },
            { "zxx", "هیچ ناوەرۆکی زمانی نیە" },
            { "zza", "زازا" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Beng", "بەنگالی" },
            { "Bopo", "بۆپۆمۆفۆ" },
            { "Brai", "برەیل" },
            { "Cyrl", "سریلیک" },
            { "Deva", "دەڤەناگەری" },
            { "Ethi", "ئەتیۆپیک" },
            { "Geor", "گورجی" },
            { "Grek", metaValue_el },
            { "Gujr", "گوجەراتی" },
            { "Guru", "گورموکھی" },
            { "Hanb", "هان لەگەڵ بۆپۆمۆفۆ" },
            { "Hang", "ھانگول" },
            { "Hani", "ھان" },
            { "Hans", "ئاسانکراو" },
            { "Hant", "دێرین" },
            { "Hebr", metaValue_he },
            { "Hira", "ھیراگانا" },
            { "Hrkt", "ژاپۆنیی بڕگەیی" },
            { "Jamo", "جامۆ" },
            { "Jpan", metaValue_ja },
            { "Kana", "کاتاکانا" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", "کۆری" },
            { "Laoo", "لائۆ" },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mymr", metaValue_MM },
            { "Orya", metaValue_or },
            { "Sinh", "سینھالا" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "تانا" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Zmth", "نیشانەی بیرکاری" },
            { "Zsye", "ئیمۆجی" },
            { "Zsym", "هێماکان" },
            { "Zxxx", "نەنووسراو" },
            { "Zyyy", "باو" },
            { "Zzzz", "خەتی نەناسراو" },
            { "en_AU", "ئینگلیزیی ئۆسترالیایی" },
            { "en_CA", "ئینگلیزیی کەنەدایی" },
            { "en_GB", "ئینگلیزیی بریتانیایی" },
            { "en_US", "ئینگلیزیی ئەمەریکایی" },
            { "nl_BE", "فلێمی" },
            { "ro_MD", "مۆڵداڤی" },
            { "sw_CD", "سواهیلیی کۆنگۆ" },
            { "ar_001", "عەرەبیی ستاندارد" },
            { "az_Arab", "ئازەربایجانی باشووری" },
            { "zh_Hans", "چینی (چینیی ئاسانکراو)" },
            { "zh_Hant", "چینی (چینیی دێرین)" },
            { "ListCompositionPattern", "{0}، {1}" },
        };
        return data;
    }
}
