// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`StartDeviceAuthorization`](crate::operation::start_device_authorization::builders::StartDeviceAuthorizationFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_id(impl Into<String>)`](crate::operation::start_device_authorization::builders::StartDeviceAuthorizationFluentBuilder::client_id) / [`set_client_id(Option<String>)`](crate::operation::start_device_authorization::builders::StartDeviceAuthorizationFluentBuilder::set_client_id):<br>required: **true**<br><p>The unique identifier string for the client that is registered with IAM Identity Center. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p><br>
    ///   - [`client_secret(impl Into<String>)`](crate::operation::start_device_authorization::builders::StartDeviceAuthorizationFluentBuilder::client_secret) / [`set_client_secret(Option<String>)`](crate::operation::start_device_authorization::builders::StartDeviceAuthorizationFluentBuilder::set_client_secret):<br>required: **true**<br><p>A secret string that is generated for the client. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p><br>
    ///   - [`start_url(impl Into<String>)`](crate::operation::start_device_authorization::builders::StartDeviceAuthorizationFluentBuilder::start_url) / [`set_start_url(Option<String>)`](crate::operation::start_device_authorization::builders::StartDeviceAuthorizationFluentBuilder::set_start_url):<br>required: **true**<br><p>The URL for the Amazon Web Services access portal. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html">Using the Amazon Web Services access portal</a> in the <i>IAM Identity Center User Guide</i>.</p><br>
    /// - On success, responds with [`StartDeviceAuthorizationOutput`](crate::operation::start_device_authorization::StartDeviceAuthorizationOutput) with field(s):
    ///   - [`device_code(Option<String>)`](crate::operation::start_device_authorization::StartDeviceAuthorizationOutput::device_code): <p>The short-lived code that is used by the device when polling for a session token.</p>
    ///   - [`user_code(Option<String>)`](crate::operation::start_device_authorization::StartDeviceAuthorizationOutput::user_code): <p>A one-time user verification code. This is needed to authorize an in-use device.</p>
    ///   - [`verification_uri(Option<String>)`](crate::operation::start_device_authorization::StartDeviceAuthorizationOutput::verification_uri): <p>The URI of the verification page that takes the <code>userCode</code> to authorize the device.</p>
    ///   - [`verification_uri_complete(Option<String>)`](crate::operation::start_device_authorization::StartDeviceAuthorizationOutput::verification_uri_complete): <p>An alternate URL that the client can use to automatically launch a browser. This process skips the manual step in which the user visits the verification page and enters their code.</p>
    ///   - [`expires_in(i32)`](crate::operation::start_device_authorization::StartDeviceAuthorizationOutput::expires_in): <p>Indicates the number of seconds in which the verification code will become invalid.</p>
    ///   - [`interval(i32)`](crate::operation::start_device_authorization::StartDeviceAuthorizationOutput::interval): <p>Indicates the number of seconds the client must wait between attempts when polling for a session.</p>
    /// - On failure, responds with [`SdkError<StartDeviceAuthorizationError>`](crate::operation::start_device_authorization::StartDeviceAuthorizationError)
    pub fn start_device_authorization(&self) -> crate::operation::start_device_authorization::builders::StartDeviceAuthorizationFluentBuilder {
        crate::operation::start_device_authorization::builders::StartDeviceAuthorizationFluentBuilder::new(self.handle.clone())
    }
}
