// File generated by `rustc_codegen_gcc/tools/generate_intrinsics.py`
// DO NOT EDIT IT!
/// Translate a given LLVM intrinsic name to an equivalent GCC one.
fn map_arch_intrinsic(full_name: &str) -> &'static str {
    let Some(name) = full_name.strip_prefix("llvm.") else {
        unimplemented!("***** unsupported LLVM intrinsic {}", full_name)
    };
    let Some((arch, name)) = name.split_once('.') else {
        unimplemented!("***** unsupported LLVM intrinsic {}", name)
    };
    match arch {
        "AMDGPU" => {
            #[expect(non_snake_case)]
            fn AMDGPU(name: &str, full_name: &str) -> &'static str {
                match name {
                    // AMDGPU
                    "div.fixup.f32" => "__builtin_amdgpu_div_fixup",
                    "div.fixup.f64" => "__builtin_amdgpu_div_fixup",
                    "div.fixup.v2f64" => "__builtin_amdgpu_div_fixup",
                    "div.fixup.v4f32" => "__builtin_amdgpu_div_fixup",
                    "div.fmas.f32" => "__builtin_amdgpu_div_fmas",
                    "div.fmas.f64" => "__builtin_amdgpu_div_fmas",
                    "div.fmas.v2f64" => "__builtin_amdgpu_div_fmas",
                    "div.fmas.v4f32" => "__builtin_amdgpu_div_fmas",
                    "ldexp.f32" => "__builtin_amdgpu_ldexp",
                    "ldexp.f64" => "__builtin_amdgpu_ldexp",
                    "ldexp.v2f64" => "__builtin_amdgpu_ldexp",
                    "ldexp.v4f32" => "__builtin_amdgpu_ldexp",
                    "rcp.f32" => "__builtin_amdgpu_rcp",
                    "rcp.f64" => "__builtin_amdgpu_rcp",
                    "rcp.v2f64" => "__builtin_amdgpu_rcp",
                    "rcp.v4f32" => "__builtin_amdgpu_rcp",
                    "rsq.clamped.f32" => "__builtin_amdgpu_rsq_clamped",
                    "rsq.clamped.f64" => "__builtin_amdgpu_rsq_clamped",
                    "rsq.clamped.v2f64" => "__builtin_amdgpu_rsq_clamped",
                    "rsq.clamped.v4f32" => "__builtin_amdgpu_rsq_clamped",
                    "rsq.f32" => "__builtin_amdgpu_rsq",
                    "rsq.f64" => "__builtin_amdgpu_rsq",
                    "rsq.v2f64" => "__builtin_amdgpu_rsq",
                    "rsq.v4f32" => "__builtin_amdgpu_rsq",
                    "trig.preop.f32" => "__builtin_amdgpu_trig_preop",
                    "trig.preop.f64" => "__builtin_amdgpu_trig_preop",
                    "trig.preop.v2f64" => "__builtin_amdgpu_trig_preop",
                    "trig.preop.v4f32" => "__builtin_amdgpu_trig_preop",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            AMDGPU(name, full_name)
        }
        "aarch64" => {
            fn aarch64(name: &str, full_name: &str) -> &'static str {
                match name {
                    // aarch64
                    "chkfeat" => "__builtin_arm_chkfeat",
                    "dmb" => "__builtin_arm_dmb",
                    "dsb" => "__builtin_arm_dsb",
                    "gcspopm" => "__builtin_arm_gcspopm",
                    "gcsss" => "__builtin_arm_gcsss",
                    "isb" => "__builtin_arm_isb",
                    "prefetch" => "__builtin_arm_prefetch",
                    "sme.in.streaming.mode" => "__builtin_arm_in_streaming_mode",
                    "sve.aesd" => "__builtin_sve_svaesd_u8",
                    "sve.aese" => "__builtin_sve_svaese_u8",
                    "sve.aesimc" => "__builtin_sve_svaesimc_u8",
                    "sve.aesmc" => "__builtin_sve_svaesmc_u8",
                    "sve.rax1" => "__builtin_sve_svrax1_u64",
                    "sve.rdffr" => "__builtin_sve_svrdffr",
                    "sve.rdffr.z" => "__builtin_sve_svrdffr_z",
                    "sve.setffr" => "__builtin_sve_svsetffr",
                    "sve.sm4e" => "__builtin_sve_svsm4e_u32",
                    "sve.sm4ekey" => "__builtin_sve_svsm4ekey_u32",
                    "sve.wrffr" => "__builtin_sve_svwrffr",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            aarch64(name, full_name)
        }
        "amdgcn" => {
            fn amdgcn(name: &str, full_name: &str) -> &'static str {
                match name {
                    // amdgcn
                    "add.max.i32" => "__builtin_amdgcn_add_max_i32",
                    "add.max.u32" => "__builtin_amdgcn_add_max_u32",
                    "add.min.i32" => "__builtin_amdgcn_add_min_i32",
                    "add.min.u32" => "__builtin_amdgcn_add_min_u32",
                    "alignbyte" => "__builtin_amdgcn_alignbyte",
                    "ashr.pk.i8.i32" => "__builtin_amdgcn_ashr_pk_i8_i32",
                    "ashr.pk.u8.i32" => "__builtin_amdgcn_ashr_pk_u8_i32",
                    "buffer.wbinvl1" => "__builtin_amdgcn_buffer_wbinvl1",
                    "buffer.wbinvl1.sc" => "__builtin_amdgcn_buffer_wbinvl1_sc",
                    "buffer.wbinvl1.vol" => "__builtin_amdgcn_buffer_wbinvl1_vol",
                    "cluster.id.x" => "__builtin_amdgcn_cluster_id_x",
                    "cluster.id.y" => "__builtin_amdgcn_cluster_id_y",
                    "cluster.id.z" => "__builtin_amdgcn_cluster_id_z",
                    "cluster.load.async.to.lds.b128" => {
                        "__builtin_amdgcn_cluster_load_async_to_lds_b128"
                    }
                    "cluster.load.async.to.lds.b32" => {
                        "__builtin_amdgcn_cluster_load_async_to_lds_b32"
                    }
                    "cluster.load.async.to.lds.b64" => {
                        "__builtin_amdgcn_cluster_load_async_to_lds_b64"
                    }
                    "cluster.load.async.to.lds.b8" => {
                        "__builtin_amdgcn_cluster_load_async_to_lds_b8"
                    }
                    "cluster.workgroup.flat.id" => "__builtin_amdgcn_cluster_workgroup_flat_id",
                    "cluster.workgroup.id.x" => "__builtin_amdgcn_cluster_workgroup_id_x",
                    "cluster.workgroup.id.y" => "__builtin_amdgcn_cluster_workgroup_id_y",
                    "cluster.workgroup.id.z" => "__builtin_amdgcn_cluster_workgroup_id_z",
                    "cluster.workgroup.max.flat.id" => {
                        "__builtin_amdgcn_cluster_workgroup_max_flat_id"
                    }
                    "cluster.workgroup.max.id.x" => "__builtin_amdgcn_cluster_workgroup_max_id_x",
                    "cluster.workgroup.max.id.y" => "__builtin_amdgcn_cluster_workgroup_max_id_y",
                    "cluster.workgroup.max.id.z" => "__builtin_amdgcn_cluster_workgroup_max_id_z",
                    "cubeid" => "__builtin_amdgcn_cubeid",
                    "cubema" => "__builtin_amdgcn_cubema",
                    "cubesc" => "__builtin_amdgcn_cubesc",
                    "cubetc" => "__builtin_amdgcn_cubetc",
                    "cvt.f16.bf8" => "__builtin_amdgcn_cvt_f16_bf8",
                    "cvt.f16.fp8" => "__builtin_amdgcn_cvt_f16_fp8",
                    "cvt.f32.bf8" => "__builtin_amdgcn_cvt_f32_bf8",
                    "cvt.f32.fp8" => "__builtin_amdgcn_cvt_f32_fp8",
                    "cvt.f32.fp8.e5m3" => "__builtin_amdgcn_cvt_f32_fp8_e5m3",
                    "cvt.off.f32.i4" => "__builtin_amdgcn_cvt_off_f32_i4",
                    "cvt.pk.bf8.f16" => "__builtin_amdgcn_cvt_pk_bf8_f16",
                    "cvt.pk.bf8.f32" => "__builtin_amdgcn_cvt_pk_bf8_f32",
                    "cvt.pk.f16.bf8" => "__builtin_amdgcn_cvt_pk_f16_bf8",
                    "cvt.pk.f16.fp8" => "__builtin_amdgcn_cvt_pk_f16_fp8",
                    "cvt.pk.f32.bf8" => "__builtin_amdgcn_cvt_pk_f32_bf8",
                    "cvt.pk.f32.fp8" => "__builtin_amdgcn_cvt_pk_f32_fp8",
                    "cvt.pk.fp8.f16" => "__builtin_amdgcn_cvt_pk_fp8_f16",
                    "cvt.pk.fp8.f32" => "__builtin_amdgcn_cvt_pk_fp8_f32",
                    "cvt.pk.fp8.f32.e5m3" => "__builtin_amdgcn_cvt_pk_fp8_f32_e5m3",
                    "cvt.pk.i16" => "__builtin_amdgcn_cvt_pk_i16",
                    "cvt.pk.u16" => "__builtin_amdgcn_cvt_pk_u16",
                    "cvt.pk.u8.f32" => "__builtin_amdgcn_cvt_pk_u8_f32",
                    "cvt.pknorm.i16" => "__builtin_amdgcn_cvt_pknorm_i16",
                    "cvt.pknorm.u16" => "__builtin_amdgcn_cvt_pknorm_u16",
                    "cvt.pkrtz" => "__builtin_amdgcn_cvt_pkrtz",
                    "cvt.scale.pk16.bf16.bf6" => "__builtin_amdgcn_cvt_scale_pk16_bf16_bf6",
                    "cvt.scale.pk16.bf16.fp6" => "__builtin_amdgcn_cvt_scale_pk16_bf16_fp6",
                    "cvt.scale.pk16.f16.bf6" => "__builtin_amdgcn_cvt_scale_pk16_f16_bf6",
                    "cvt.scale.pk16.f16.fp6" => "__builtin_amdgcn_cvt_scale_pk16_f16_fp6",
                    "cvt.scale.pk16.f32.bf6" => "__builtin_amdgcn_cvt_scale_pk16_f32_bf6",
                    "cvt.scale.pk16.f32.fp6" => "__builtin_amdgcn_cvt_scale_pk16_f32_fp6",
                    "cvt.scale.pk8.bf16.bf8" => "__builtin_amdgcn_cvt_scale_pk8_bf16_bf8",
                    "cvt.scale.pk8.bf16.fp4" => "__builtin_amdgcn_cvt_scale_pk8_bf16_fp4",
                    "cvt.scale.pk8.bf16.fp8" => "__builtin_amdgcn_cvt_scale_pk8_bf16_fp8",
                    "cvt.scale.pk8.f16.bf8" => "__builtin_amdgcn_cvt_scale_pk8_f16_bf8",
                    "cvt.scale.pk8.f16.fp4" => "__builtin_amdgcn_cvt_scale_pk8_f16_fp4",
                    "cvt.scale.pk8.f16.fp8" => "__builtin_amdgcn_cvt_scale_pk8_f16_fp8",
                    "cvt.scale.pk8.f32.bf8" => "__builtin_amdgcn_cvt_scale_pk8_f32_bf8",
                    "cvt.scale.pk8.f32.fp4" => "__builtin_amdgcn_cvt_scale_pk8_f32_fp4",
                    "cvt.scale.pk8.f32.fp8" => "__builtin_amdgcn_cvt_scale_pk8_f32_fp8",
                    "cvt.scalef32.2xpk16.bf6.f32" => "__builtin_amdgcn_cvt_scalef32_2xpk16_bf6_f32",
                    "cvt.scalef32.2xpk16.fp6.f32" => "__builtin_amdgcn_cvt_scalef32_2xpk16_fp6_f32",
                    "cvt.scalef32.f16.bf8" => "__builtin_amdgcn_cvt_scalef32_f16_bf8",
                    "cvt.scalef32.f16.fp8" => "__builtin_amdgcn_cvt_scalef32_f16_fp8",
                    "cvt.scalef32.f32.bf8" => "__builtin_amdgcn_cvt_scalef32_f32_bf8",
                    "cvt.scalef32.f32.fp8" => "__builtin_amdgcn_cvt_scalef32_f32_fp8",
                    "cvt.scalef32.pk.bf16.bf8" => "__builtin_amdgcn_cvt_scalef32_pk_bf16_bf8",
                    "cvt.scalef32.pk.bf16.fp4" => "__builtin_amdgcn_cvt_scalef32_pk_bf16_fp4",
                    "cvt.scalef32.pk.bf16.fp8" => "__builtin_amdgcn_cvt_scalef32_pk_bf16_fp8",
                    "cvt.scalef32.pk.bf8.bf16" => "__builtin_amdgcn_cvt_scalef32_pk_bf8_bf16",
                    "cvt.scalef32.pk.bf8.f16" => "__builtin_amdgcn_cvt_scalef32_pk_bf8_f16",
                    "cvt.scalef32.pk.bf8.f32" => "__builtin_amdgcn_cvt_scalef32_pk_bf8_f32",
                    "cvt.scalef32.pk.f16.bf8" => "__builtin_amdgcn_cvt_scalef32_pk_f16_bf8",
                    "cvt.scalef32.pk.f16.fp4" => "__builtin_amdgcn_cvt_scalef32_pk_f16_fp4",
                    "cvt.scalef32.pk.f16.fp8" => "__builtin_amdgcn_cvt_scalef32_pk_f16_fp8",
                    "cvt.scalef32.pk.f32.bf8" => "__builtin_amdgcn_cvt_scalef32_pk_f32_bf8",
                    "cvt.scalef32.pk.f32.fp4" => "__builtin_amdgcn_cvt_scalef32_pk_f32_fp4",
                    "cvt.scalef32.pk.f32.fp8" => "__builtin_amdgcn_cvt_scalef32_pk_f32_fp8",
                    "cvt.scalef32.pk.fp4.bf16" => "__builtin_amdgcn_cvt_scalef32_pk_fp4_bf16",
                    "cvt.scalef32.pk.fp4.f16" => "__builtin_amdgcn_cvt_scalef32_pk_fp4_f16",
                    "cvt.scalef32.pk.fp4.f32" => "__builtin_amdgcn_cvt_scalef32_pk_fp4_f32",
                    "cvt.scalef32.pk.fp8.bf16" => "__builtin_amdgcn_cvt_scalef32_pk_fp8_bf16",
                    "cvt.scalef32.pk.fp8.f16" => "__builtin_amdgcn_cvt_scalef32_pk_fp8_f16",
                    "cvt.scalef32.pk.fp8.f32" => "__builtin_amdgcn_cvt_scalef32_pk_fp8_f32",
                    "cvt.scalef32.pk16.bf6.bf16" => "__builtin_amdgcn_cvt_scalef32_pk16_bf6_bf16",
                    "cvt.scalef32.pk16.bf6.f16" => "__builtin_amdgcn_cvt_scalef32_pk16_bf6_f16",
                    "cvt.scalef32.pk16.bf6.f32" => "__builtin_amdgcn_cvt_scalef32_pk16_bf6_f32",
                    "cvt.scalef32.pk16.fp6.bf16" => "__builtin_amdgcn_cvt_scalef32_pk16_fp6_bf16",
                    "cvt.scalef32.pk16.fp6.f16" => "__builtin_amdgcn_cvt_scalef32_pk16_fp6_f16",
                    "cvt.scalef32.pk16.fp6.f32" => "__builtin_amdgcn_cvt_scalef32_pk16_fp6_f32",
                    "cvt.scalef32.pk32.bf16.bf6" => "__builtin_amdgcn_cvt_scalef32_pk32_bf16_bf6",
                    "cvt.scalef32.pk32.bf16.fp6" => "__builtin_amdgcn_cvt_scalef32_pk32_bf16_fp6",
                    "cvt.scalef32.pk32.bf6.bf16" => "__builtin_amdgcn_cvt_scalef32_pk32_bf6_bf16",
                    "cvt.scalef32.pk32.bf6.f16" => "__builtin_amdgcn_cvt_scalef32_pk32_bf6_f16",
                    "cvt.scalef32.pk32.f16.bf6" => "__builtin_amdgcn_cvt_scalef32_pk32_f16_bf6",
                    "cvt.scalef32.pk32.f16.fp6" => "__builtin_amdgcn_cvt_scalef32_pk32_f16_fp6",
                    "cvt.scalef32.pk32.f32.bf6" => "__builtin_amdgcn_cvt_scalef32_pk32_f32_bf6",
                    "cvt.scalef32.pk32.f32.fp6" => "__builtin_amdgcn_cvt_scalef32_pk32_f32_fp6",
                    "cvt.scalef32.pk32.fp6.bf16" => "__builtin_amdgcn_cvt_scalef32_pk32_fp6_bf16",
                    "cvt.scalef32.pk32.fp6.f16" => "__builtin_amdgcn_cvt_scalef32_pk32_fp6_f16",
                    "cvt.scalef32.pk8.bf8.bf16" => "__builtin_amdgcn_cvt_scalef32_pk8_bf8_bf16",
                    "cvt.scalef32.pk8.bf8.f16" => "__builtin_amdgcn_cvt_scalef32_pk8_bf8_f16",
                    "cvt.scalef32.pk8.bf8.f32" => "__builtin_amdgcn_cvt_scalef32_pk8_bf8_f32",
                    "cvt.scalef32.pk8.fp4.bf16" => "__builtin_amdgcn_cvt_scalef32_pk8_fp4_bf16",
                    "cvt.scalef32.pk8.fp4.f16" => "__builtin_amdgcn_cvt_scalef32_pk8_fp4_f16",
                    "cvt.scalef32.pk8.fp4.f32" => "__builtin_amdgcn_cvt_scalef32_pk8_fp4_f32",
                    "cvt.scalef32.pk8.fp8.bf16" => "__builtin_amdgcn_cvt_scalef32_pk8_fp8_bf16",
                    "cvt.scalef32.pk8.fp8.f16" => "__builtin_amdgcn_cvt_scalef32_pk8_fp8_f16",
                    "cvt.scalef32.pk8.fp8.f32" => "__builtin_amdgcn_cvt_scalef32_pk8_fp8_f32",
                    "cvt.scalef32.sr.bf8.bf16" => "__builtin_amdgcn_cvt_scalef32_sr_bf8_bf16",
                    "cvt.scalef32.sr.bf8.f16" => "__builtin_amdgcn_cvt_scalef32_sr_bf8_f16",
                    "cvt.scalef32.sr.bf8.f32" => "__builtin_amdgcn_cvt_scalef32_sr_bf8_f32",
                    "cvt.scalef32.sr.fp8.bf16" => "__builtin_amdgcn_cvt_scalef32_sr_fp8_bf16",
                    "cvt.scalef32.sr.fp8.f16" => "__builtin_amdgcn_cvt_scalef32_sr_fp8_f16",
                    "cvt.scalef32.sr.fp8.f32" => "__builtin_amdgcn_cvt_scalef32_sr_fp8_f32",
                    "cvt.scalef32.sr.pk.fp4.bf16" => "__builtin_amdgcn_cvt_scalef32_sr_pk_fp4_bf16",
                    "cvt.scalef32.sr.pk.fp4.f16" => "__builtin_amdgcn_cvt_scalef32_sr_pk_fp4_f16",
                    "cvt.scalef32.sr.pk.fp4.f32" => "__builtin_amdgcn_cvt_scalef32_sr_pk_fp4_f32",
                    "cvt.scalef32.sr.pk16.bf6.bf16" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk16_bf6_bf16"
                    }
                    "cvt.scalef32.sr.pk16.bf6.f16" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk16_bf6_f16"
                    }
                    "cvt.scalef32.sr.pk16.bf6.f32" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk16_bf6_f32"
                    }
                    "cvt.scalef32.sr.pk16.fp6.bf16" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk16_fp6_bf16"
                    }
                    "cvt.scalef32.sr.pk16.fp6.f16" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk16_fp6_f16"
                    }
                    "cvt.scalef32.sr.pk16.fp6.f32" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk16_fp6_f32"
                    }
                    "cvt.scalef32.sr.pk32.bf6.bf16" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk32_bf6_bf16"
                    }
                    "cvt.scalef32.sr.pk32.bf6.f16" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk32_bf6_f16"
                    }
                    "cvt.scalef32.sr.pk32.bf6.f32" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk32_bf6_f32"
                    }
                    "cvt.scalef32.sr.pk32.fp6.bf16" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk32_fp6_bf16"
                    }
                    "cvt.scalef32.sr.pk32.fp6.f16" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk32_fp6_f16"
                    }
                    "cvt.scalef32.sr.pk32.fp6.f32" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk32_fp6_f32"
                    }
                    "cvt.scalef32.sr.pk8.bf8.bf16" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk8_bf8_bf16"
                    }
                    "cvt.scalef32.sr.pk8.bf8.f16" => "__builtin_amdgcn_cvt_scalef32_sr_pk8_bf8_f16",
                    "cvt.scalef32.sr.pk8.bf8.f32" => "__builtin_amdgcn_cvt_scalef32_sr_pk8_bf8_f32",
                    "cvt.scalef32.sr.pk8.fp4.bf16" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk8_fp4_bf16"
                    }
                    "cvt.scalef32.sr.pk8.fp4.f16" => "__builtin_amdgcn_cvt_scalef32_sr_pk8_fp4_f16",
                    "cvt.scalef32.sr.pk8.fp4.f32" => "__builtin_amdgcn_cvt_scalef32_sr_pk8_fp4_f32",
                    "cvt.scalef32.sr.pk8.fp8.bf16" => {
                        "__builtin_amdgcn_cvt_scalef32_sr_pk8_fp8_bf16"
                    }
                    "cvt.scalef32.sr.pk8.fp8.f16" => "__builtin_amdgcn_cvt_scalef32_sr_pk8_fp8_f16",
                    "cvt.scalef32.sr.pk8.fp8.f32" => "__builtin_amdgcn_cvt_scalef32_sr_pk8_fp8_f32",
                    "cvt.sr.bf16.f32" => "__builtin_amdgcn_cvt_sr_bf16_f32",
                    "cvt.sr.bf8.f16" => "__builtin_amdgcn_cvt_sr_bf8_f16",
                    "cvt.sr.bf8.f32" => "__builtin_amdgcn_cvt_sr_bf8_f32",
                    "cvt.sr.f16.f32" => "__builtin_amdgcn_cvt_sr_f16_f32",
                    "cvt.sr.fp8.f16" => "__builtin_amdgcn_cvt_sr_fp8_f16",
                    "cvt.sr.fp8.f32" => "__builtin_amdgcn_cvt_sr_fp8_f32",
                    "cvt.sr.fp8.f32.e5m3" => "__builtin_amdgcn_cvt_sr_fp8_f32_e5m3",
                    "cvt.sr.pk.bf16.f32" => "__builtin_amdgcn_cvt_sr_pk_bf16_f32",
                    "cvt.sr.pk.f16.f32" => "__builtin_amdgcn_cvt_sr_pk_f16_f32",
                    "dispatch.id" => "__builtin_amdgcn_dispatch_id",
                    "dot4.f32.bf8.bf8" => "__builtin_amdgcn_dot4_f32_bf8_bf8",
                    "dot4.f32.bf8.fp8" => "__builtin_amdgcn_dot4_f32_bf8_fp8",
                    "dot4.f32.fp8.bf8" => "__builtin_amdgcn_dot4_f32_fp8_bf8",
                    "dot4.f32.fp8.fp8" => "__builtin_amdgcn_dot4_f32_fp8_fp8",
                    "ds.add.gs.reg.rtn" => "__builtin_amdgcn_ds_add_gs_reg_rtn",
                    "ds.atomic.async.barrier.arrive.b64" => {
                        "__builtin_amdgcn_ds_atomic_async_barrier_arrive_b64"
                    }
                    "ds.atomic.barrier.arrive.rtn.b64" => {
                        "__builtin_amdgcn_ds_atomic_barrier_arrive_rtn_b64"
                    }
                    "ds.bpermute" => "__builtin_amdgcn_ds_bpermute",
                    "ds.bpermute.fi.b32" => "__builtin_amdgcn_ds_bpermute_fi_b32",
                    "ds.gws.barrier" => "__builtin_amdgcn_ds_gws_barrier",
                    "ds.gws.init" => "__builtin_amdgcn_ds_gws_init",
                    "ds.gws.sema.br" => "__builtin_amdgcn_ds_gws_sema_br",
                    "ds.gws.sema.p" => "__builtin_amdgcn_ds_gws_sema_p",
                    "ds.gws.sema.release.all" => "__builtin_amdgcn_ds_gws_sema_release_all",
                    "ds.gws.sema.v" => "__builtin_amdgcn_ds_gws_sema_v",
                    "ds.permute" => "__builtin_amdgcn_ds_permute",
                    "ds.sub.gs.reg.rtn" => "__builtin_amdgcn_ds_sub_gs_reg_rtn",
                    "ds.swizzle" => "__builtin_amdgcn_ds_swizzle",
                    "endpgm" => "__builtin_amdgcn_endpgm",
                    "fdot2" => "__builtin_amdgcn_fdot2",
                    "fdot2.bf16.bf16" => "__builtin_amdgcn_fdot2_bf16_bf16",
                    "fdot2.f16.f16" => "__builtin_amdgcn_fdot2_f16_f16",
                    "fdot2.f32.bf16" => "__builtin_amdgcn_fdot2_f32_bf16",
                    "fdot2c.f32.bf16" => "__builtin_amdgcn_fdot2c_f32_bf16",
                    "flat.prefetch" => "__builtin_amdgcn_flat_prefetch",
                    "fmul.legacy" => "__builtin_amdgcn_fmul_legacy",
                    "global.load.async.to.lds.b128" => {
                        "__builtin_amdgcn_global_load_async_to_lds_b128"
                    }
                    "global.load.async.to.lds.b32" => {
                        "__builtin_amdgcn_global_load_async_to_lds_b32"
                    }
                    "global.load.async.to.lds.b64" => {
                        "__builtin_amdgcn_global_load_async_to_lds_b64"
                    }
                    "global.load.async.to.lds.b8" => "__builtin_amdgcn_global_load_async_to_lds_b8",
                    "global.load.lds" => "__builtin_amdgcn_global_load_lds",
                    "global.prefetch" => "__builtin_amdgcn_global_prefetch",
                    "global.store.async.from.lds.b128" => {
                        "__builtin_amdgcn_global_store_async_from_lds_b128"
                    }
                    "global.store.async.from.lds.b32" => {
                        "__builtin_amdgcn_global_store_async_from_lds_b32"
                    }
                    "global.store.async.from.lds.b64" => {
                        "__builtin_amdgcn_global_store_async_from_lds_b64"
                    }
                    "global.store.async.from.lds.b8" => {
                        "__builtin_amdgcn_global_store_async_from_lds_b8"
                    }
                    "groupstaticsize" => "__builtin_amdgcn_groupstaticsize",
                    "iglp.opt" => "__builtin_amdgcn_iglp_opt",
                    "implicit.buffer.ptr" => "__builtin_amdgcn_implicit_buffer_ptr",
                    "implicitarg.ptr" => "__builtin_amdgcn_implicitarg_ptr",
                    "interp.mov" => "__builtin_amdgcn_interp_mov",
                    "interp.p1" => "__builtin_amdgcn_interp_p1",
                    "interp.p1.f16" => "__builtin_amdgcn_interp_p1_f16",
                    "interp.p2" => "__builtin_amdgcn_interp_p2",
                    "interp.p2.f16" => "__builtin_amdgcn_interp_p2_f16",
                    "is.private" => "__builtin_amdgcn_is_private",
                    "is.shared" => "__builtin_amdgcn_is_shared",
                    "kernarg.segment.ptr" => "__builtin_amdgcn_kernarg_segment_ptr",
                    "lerp" => "__builtin_amdgcn_lerp",
                    "mbcnt.hi" => "__builtin_amdgcn_mbcnt_hi",
                    "mbcnt.lo" => "__builtin_amdgcn_mbcnt_lo",
                    "mfma.f32.16x16x16bf16.1k" => "__builtin_amdgcn_mfma_f32_16x16x16bf16_1k",
                    "mfma.f32.16x16x16f16" => "__builtin_amdgcn_mfma_f32_16x16x16f16",
                    "mfma.f32.16x16x1f32" => "__builtin_amdgcn_mfma_f32_16x16x1f32",
                    "mfma.f32.16x16x2bf16" => "__builtin_amdgcn_mfma_f32_16x16x2bf16",
                    "mfma.f32.16x16x32.bf16" => "__builtin_amdgcn_mfma_f32_16x16x32_bf16",
                    "mfma.f32.16x16x32.bf8.bf8" => "__builtin_amdgcn_mfma_f32_16x16x32_bf8_bf8",
                    "mfma.f32.16x16x32.bf8.fp8" => "__builtin_amdgcn_mfma_f32_16x16x32_bf8_fp8",
                    "mfma.f32.16x16x32.f16" => "__builtin_amdgcn_mfma_f32_16x16x32_f16",
                    "mfma.f32.16x16x32.fp8.bf8" => "__builtin_amdgcn_mfma_f32_16x16x32_fp8_bf8",
                    "mfma.f32.16x16x32.fp8.fp8" => "__builtin_amdgcn_mfma_f32_16x16x32_fp8_fp8",
                    "mfma.f32.16x16x4bf16.1k" => "__builtin_amdgcn_mfma_f32_16x16x4bf16_1k",
                    "mfma.f32.16x16x4f16" => "__builtin_amdgcn_mfma_f32_16x16x4f16",
                    "mfma.f32.16x16x4f32" => "__builtin_amdgcn_mfma_f32_16x16x4f32",
                    "mfma.f32.16x16x8.xf32" => "__builtin_amdgcn_mfma_f32_16x16x8_xf32",
                    "mfma.f32.16x16x8bf16" => "__builtin_amdgcn_mfma_f32_16x16x8bf16",
                    "mfma.f32.32x32x16.bf16" => "__builtin_amdgcn_mfma_f32_32x32x16_bf16",
                    "mfma.f32.32x32x16.bf8.bf8" => "__builtin_amdgcn_mfma_f32_32x32x16_bf8_bf8",
                    "mfma.f32.32x32x16.bf8.fp8" => "__builtin_amdgcn_mfma_f32_32x32x16_bf8_fp8",
                    "mfma.f32.32x32x16.f16" => "__builtin_amdgcn_mfma_f32_32x32x16_f16",
                    "mfma.f32.32x32x16.fp8.bf8" => "__builtin_amdgcn_mfma_f32_32x32x16_fp8_bf8",
                    "mfma.f32.32x32x16.fp8.fp8" => "__builtin_amdgcn_mfma_f32_32x32x16_fp8_fp8",
                    "mfma.f32.32x32x1f32" => "__builtin_amdgcn_mfma_f32_32x32x1f32",
                    "mfma.f32.32x32x2bf16" => "__builtin_amdgcn_mfma_f32_32x32x2bf16",
                    "mfma.f32.32x32x2f32" => "__builtin_amdgcn_mfma_f32_32x32x2f32",
                    "mfma.f32.32x32x4.xf32" => "__builtin_amdgcn_mfma_f32_32x32x4_xf32",
                    "mfma.f32.32x32x4bf16" => "__builtin_amdgcn_mfma_f32_32x32x4bf16",
                    "mfma.f32.32x32x4bf16.1k" => "__builtin_amdgcn_mfma_f32_32x32x4bf16_1k",
                    "mfma.f32.32x32x4f16" => "__builtin_amdgcn_mfma_f32_32x32x4f16",
                    "mfma.f32.32x32x8bf16.1k" => "__builtin_amdgcn_mfma_f32_32x32x8bf16_1k",
                    "mfma.f32.32x32x8f16" => "__builtin_amdgcn_mfma_f32_32x32x8f16",
                    "mfma.f32.4x4x1f32" => "__builtin_amdgcn_mfma_f32_4x4x1f32",
                    "mfma.f32.4x4x2bf16" => "__builtin_amdgcn_mfma_f32_4x4x2bf16",
                    "mfma.f32.4x4x4bf16.1k" => "__builtin_amdgcn_mfma_f32_4x4x4bf16_1k",
                    "mfma.f32.4x4x4f16" => "__builtin_amdgcn_mfma_f32_4x4x4f16",
                    "mfma.f64.16x16x4f64" => "__builtin_amdgcn_mfma_f64_16x16x4f64",
                    "mfma.f64.4x4x4f64" => "__builtin_amdgcn_mfma_f64_4x4x4f64",
                    "mfma.i32.16x16x16i8" => "__builtin_amdgcn_mfma_i32_16x16x16i8",
                    "mfma.i32.16x16x32.i8" => "__builtin_amdgcn_mfma_i32_16x16x32_i8",
                    "mfma.i32.16x16x4i8" => "__builtin_amdgcn_mfma_i32_16x16x4i8",
                    "mfma.i32.16x16x64.i8" => "__builtin_amdgcn_mfma_i32_16x16x64_i8",
                    "mfma.i32.32x32x16.i8" => "__builtin_amdgcn_mfma_i32_32x32x16_i8",
                    "mfma.i32.32x32x32.i8" => "__builtin_amdgcn_mfma_i32_32x32x32_i8",
                    "mfma.i32.32x32x4i8" => "__builtin_amdgcn_mfma_i32_32x32x4i8",
                    "mfma.i32.32x32x8i8" => "__builtin_amdgcn_mfma_i32_32x32x8i8",
                    "mfma.i32.4x4x4i8" => "__builtin_amdgcn_mfma_i32_4x4x4i8",
                    "mqsad.pk.u16.u8" => "__builtin_amdgcn_mqsad_pk_u16_u8",
                    "mqsad.u32.u8" => "__builtin_amdgcn_mqsad_u32_u8",
                    "msad.u8" => "__builtin_amdgcn_msad_u8",
                    "perm" => "__builtin_amdgcn_perm",
                    "perm.pk16.b4.u4" => "__builtin_amdgcn_perm_pk16_b4_u4",
                    "perm.pk16.b6.u4" => "__builtin_amdgcn_perm_pk16_b6_u4",
                    "perm.pk16.b8.u4" => "__builtin_amdgcn_perm_pk16_b8_u4",
                    "permlane.bcast" => "__builtin_amdgcn_permlane_bcast",
                    "permlane.down" => "__builtin_amdgcn_permlane_down",
                    "permlane.idx.gen" => "__builtin_amdgcn_permlane_idx_gen",
                    "permlane.up" => "__builtin_amdgcn_permlane_up",
                    "permlane.xor" => "__builtin_amdgcn_permlane_xor",
                    "permlane16.var" => "__builtin_amdgcn_permlane16_var",
                    "permlanex16.var" => "__builtin_amdgcn_permlanex16_var",
                    "pk.add.max.i16" => "__builtin_amdgcn_pk_add_max_i16",
                    "pk.add.max.u16" => "__builtin_amdgcn_pk_add_max_u16",
                    "pk.add.min.i16" => "__builtin_amdgcn_pk_add_min_i16",
                    "pk.add.min.u16" => "__builtin_amdgcn_pk_add_min_u16",
                    "prng.b32" => "__builtin_amdgcn_prng_b32",
                    "qsad.pk.u16.u8" => "__builtin_amdgcn_qsad_pk_u16_u8",
                    "queue.ptr" => "__builtin_amdgcn_queue_ptr",
                    "raw.ptr.buffer.load.lds" => "__builtin_amdgcn_raw_ptr_buffer_load_lds",
                    "rcp.legacy" => "__builtin_amdgcn_rcp_legacy",
                    "rsq.legacy" => "__builtin_amdgcn_rsq_legacy",
                    "s.barrier" => "__builtin_amdgcn_s_barrier",
                    "s.barrier.init" => "__builtin_amdgcn_s_barrier_init",
                    "s.barrier.join" => "__builtin_amdgcn_s_barrier_join",
                    "s.barrier.leave" => "__builtin_amdgcn_s_barrier_leave",
                    "s.barrier.signal" => "__builtin_amdgcn_s_barrier_signal",
                    "s.barrier.signal.isfirst" => "__builtin_amdgcn_s_barrier_signal_isfirst",
                    "s.barrier.signal.var" => "__builtin_amdgcn_s_barrier_signal_var",
                    "s.barrier.wait" => "__builtin_amdgcn_s_barrier_wait",
                    "s.buffer.prefetch.data" => "__builtin_amdgcn_s_buffer_prefetch_data",
                    "s.cluster.barrier" => "__builtin_amdgcn_s_cluster_barrier",
                    "s.dcache.inv" => "__builtin_amdgcn_s_dcache_inv",
                    "s.dcache.inv.vol" => "__builtin_amdgcn_s_dcache_inv_vol",
                    "s.dcache.wb" => "__builtin_amdgcn_s_dcache_wb",
                    "s.dcache.wb.vol" => "__builtin_amdgcn_s_dcache_wb_vol",
                    "s.decperflevel" => "__builtin_amdgcn_s_decperflevel",
                    "s.get.barrier.state" => "__builtin_amdgcn_s_get_barrier_state",
                    "s.get.named.barrier.state" => "__builtin_amdgcn_s_get_named_barrier_state",
                    "s.get.waveid.in.workgroup" => "__builtin_amdgcn_s_get_waveid_in_workgroup",
                    "s.getpc" => "__builtin_amdgcn_s_getpc",
                    "s.getreg" => "__builtin_amdgcn_s_getreg",
                    "s.incperflevel" => "__builtin_amdgcn_s_incperflevel",
                    "s.memrealtime" => "__builtin_amdgcn_s_memrealtime",
                    "s.memtime" => "__builtin_amdgcn_s_memtime",
                    "s.monitor.sleep" => "__builtin_amdgcn_s_monitor_sleep",
                    "s.sendmsg" => "__builtin_amdgcn_s_sendmsg",
                    "s.sendmsghalt" => "__builtin_amdgcn_s_sendmsghalt",
                    "s.setprio" => "__builtin_amdgcn_s_setprio",
                    "s.setprio.inc.wg" => "__builtin_amdgcn_s_setprio_inc_wg",
                    "s.setreg" => "__builtin_amdgcn_s_setreg",
                    "s.sleep" => "__builtin_amdgcn_s_sleep",
                    "s.sleep.var" => "__builtin_amdgcn_s_sleep_var",
                    "s.ttracedata" => "__builtin_amdgcn_s_ttracedata",
                    "s.ttracedata.imm" => "__builtin_amdgcn_s_ttracedata_imm",
                    "s.wait.asynccnt" => "__builtin_amdgcn_s_wait_asynccnt",
                    "s.wait.event.export.ready" => "__builtin_amdgcn_s_wait_event_export_ready",
                    "s.wait.tensorcnt" => "__builtin_amdgcn_s_wait_tensorcnt",
                    "s.waitcnt" => "__builtin_amdgcn_s_waitcnt",
                    "sad.hi.u8" => "__builtin_amdgcn_sad_hi_u8",
                    "sad.u16" => "__builtin_amdgcn_sad_u16",
                    "sad.u8" => "__builtin_amdgcn_sad_u8",
                    "sat.pk4.i4.i8" => "__builtin_amdgcn_sat_pk4_i4_i8",
                    "sat.pk4.u4.u8" => "__builtin_amdgcn_sat_pk4_u4_u8",
                    "sched.barrier" => "__builtin_amdgcn_sched_barrier",
                    "sched.group.barrier" => "__builtin_amdgcn_sched_group_barrier",
                    "sdot2" => "__builtin_amdgcn_sdot2",
                    "sdot4" => "__builtin_amdgcn_sdot4",
                    "sdot8" => "__builtin_amdgcn_sdot8",
                    "smfmac.f32.16x16x128.bf8.bf8" => {
                        "__builtin_amdgcn_smfmac_f32_16x16x128_bf8_bf8"
                    }
                    "smfmac.f32.16x16x128.bf8.fp8" => {
                        "__builtin_amdgcn_smfmac_f32_16x16x128_bf8_fp8"
                    }
                    "smfmac.f32.16x16x128.fp8.bf8" => {
                        "__builtin_amdgcn_smfmac_f32_16x16x128_fp8_bf8"
                    }
                    "smfmac.f32.16x16x128.fp8.fp8" => {
                        "__builtin_amdgcn_smfmac_f32_16x16x128_fp8_fp8"
                    }
                    "smfmac.f32.16x16x32.bf16" => "__builtin_amdgcn_smfmac_f32_16x16x32_bf16",
                    "smfmac.f32.16x16x32.f16" => "__builtin_amdgcn_smfmac_f32_16x16x32_f16",
                    "smfmac.f32.16x16x64.bf16" => "__builtin_amdgcn_smfmac_f32_16x16x64_bf16",
                    "smfmac.f32.16x16x64.bf8.bf8" => "__builtin_amdgcn_smfmac_f32_16x16x64_bf8_bf8",
                    "smfmac.f32.16x16x64.bf8.fp8" => "__builtin_amdgcn_smfmac_f32_16x16x64_bf8_fp8",
                    "smfmac.f32.16x16x64.f16" => "__builtin_amdgcn_smfmac_f32_16x16x64_f16",
                    "smfmac.f32.16x16x64.fp8.bf8" => "__builtin_amdgcn_smfmac_f32_16x16x64_fp8_bf8",
                    "smfmac.f32.16x16x64.fp8.fp8" => "__builtin_amdgcn_smfmac_f32_16x16x64_fp8_fp8",
                    "smfmac.f32.32x32x16.bf16" => "__builtin_amdgcn_smfmac_f32_32x32x16_bf16",
                    "smfmac.f32.32x32x16.f16" => "__builtin_amdgcn_smfmac_f32_32x32x16_f16",
                    "smfmac.f32.32x32x32.bf16" => "__builtin_amdgcn_smfmac_f32_32x32x32_bf16",
                    "smfmac.f32.32x32x32.bf8.bf8" => "__builtin_amdgcn_smfmac_f32_32x32x32_bf8_bf8",
                    "smfmac.f32.32x32x32.bf8.fp8" => "__builtin_amdgcn_smfmac_f32_32x32x32_bf8_fp8",
                    "smfmac.f32.32x32x32.f16" => "__builtin_amdgcn_smfmac_f32_32x32x32_f16",
                    "smfmac.f32.32x32x32.fp8.bf8" => "__builtin_amdgcn_smfmac_f32_32x32x32_fp8_bf8",
                    "smfmac.f32.32x32x32.fp8.fp8" => "__builtin_amdgcn_smfmac_f32_32x32x32_fp8_fp8",
                    "smfmac.f32.32x32x64.bf8.bf8" => "__builtin_amdgcn_smfmac_f32_32x32x64_bf8_bf8",
                    "smfmac.f32.32x32x64.bf8.fp8" => "__builtin_amdgcn_smfmac_f32_32x32x64_bf8_fp8",
                    "smfmac.f32.32x32x64.fp8.bf8" => "__builtin_amdgcn_smfmac_f32_32x32x64_fp8_bf8",
                    "smfmac.f32.32x32x64.fp8.fp8" => "__builtin_amdgcn_smfmac_f32_32x32x64_fp8_fp8",
                    "smfmac.i32.16x16x128.i8" => "__builtin_amdgcn_smfmac_i32_16x16x128_i8",
                    "smfmac.i32.16x16x64.i8" => "__builtin_amdgcn_smfmac_i32_16x16x64_i8",
                    "smfmac.i32.32x32x32.i8" => "__builtin_amdgcn_smfmac_i32_32x32x32_i8",
                    "smfmac.i32.32x32x64.i8" => "__builtin_amdgcn_smfmac_i32_32x32x64_i8",
                    "struct.ptr.buffer.load.lds" => "__builtin_amdgcn_struct_ptr_buffer_load_lds",
                    "sudot4" => "__builtin_amdgcn_sudot4",
                    "sudot8" => "__builtin_amdgcn_sudot8",
                    "tensor.load.to.lds" => "__builtin_amdgcn_tensor_load_to_lds",
                    "tensor.load.to.lds.d2" => "__builtin_amdgcn_tensor_load_to_lds_d2",
                    "tensor.store.from.lds" => "__builtin_amdgcn_tensor_store_from_lds",
                    "tensor.store.from.lds.d2" => "__builtin_amdgcn_tensor_store_from_lds_d2",
                    "udot2" => "__builtin_amdgcn_udot2",
                    "udot4" => "__builtin_amdgcn_udot4",
                    "udot8" => "__builtin_amdgcn_udot8",
                    "wave.barrier" => "__builtin_amdgcn_wave_barrier",
                    "wavefrontsize" => "__builtin_amdgcn_wavefrontsize",
                    "workgroup.id.x" => "__builtin_amdgcn_workgroup_id_x",
                    "workgroup.id.y" => "__builtin_amdgcn_workgroup_id_y",
                    "workgroup.id.z" => "__builtin_amdgcn_workgroup_id_z",
                    "workitem.id.x" => "__builtin_amdgcn_workitem_id_x",
                    "workitem.id.y" => "__builtin_amdgcn_workitem_id_y",
                    "workitem.id.z" => "__builtin_amdgcn_workitem_id_z",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            amdgcn(name, full_name)
        }
        "arm" => {
            fn arm(name: &str, full_name: &str) -> &'static str {
                match name {
                    // arm
                    "cdp" => "__builtin_arm_cdp",
                    "cdp2" => "__builtin_arm_cdp2",
                    "cmse.tt" => "__builtin_arm_cmse_TT",
                    "cmse.tta" => "__builtin_arm_cmse_TTA",
                    "cmse.ttat" => "__builtin_arm_cmse_TTAT",
                    "cmse.ttt" => "__builtin_arm_cmse_TTT",
                    "dmb" => "__builtin_arm_dmb",
                    "dsb" => "__builtin_arm_dsb",
                    "get.fpscr" => "__builtin_arm_get_fpscr",
                    "isb" => "__builtin_arm_isb",
                    "ldc" => "__builtin_arm_ldc",
                    "ldc2" => "__builtin_arm_ldc2",
                    "ldc2l" => "__builtin_arm_ldc2l",
                    "ldcl" => "__builtin_arm_ldcl",
                    "mcr" => "__builtin_arm_mcr",
                    "mcr2" => "__builtin_arm_mcr2",
                    "mcrr" => "__builtin_arm_mcrr",
                    "mcrr2" => "__builtin_arm_mcrr2",
                    "mrc" => "__builtin_arm_mrc",
                    "mrc2" => "__builtin_arm_mrc2",
                    "qadd" => "__builtin_arm_qadd",
                    "qadd16" => "__builtin_arm_qadd16",
                    "qadd8" => "__builtin_arm_qadd8",
                    "qasx" => "__builtin_arm_qasx",
                    "qsax" => "__builtin_arm_qsax",
                    "qsub" => "__builtin_arm_qsub",
                    "qsub16" => "__builtin_arm_qsub16",
                    "qsub8" => "__builtin_arm_qsub8",
                    "sadd16" => "__builtin_arm_sadd16",
                    "sadd8" => "__builtin_arm_sadd8",
                    "sasx" => "__builtin_arm_sasx",
                    "sel" => "__builtin_arm_sel",
                    "set.fpscr" => "__builtin_arm_set_fpscr",
                    "shadd16" => "__builtin_arm_shadd16",
                    "shadd8" => "__builtin_arm_shadd8",
                    "shasx" => "__builtin_arm_shasx",
                    "shsax" => "__builtin_arm_shsax",
                    "shsub16" => "__builtin_arm_shsub16",
                    "shsub8" => "__builtin_arm_shsub8",
                    "smlabb" => "__builtin_arm_smlabb",
                    "smlabt" => "__builtin_arm_smlabt",
                    "smlad" => "__builtin_arm_smlad",
                    "smladx" => "__builtin_arm_smladx",
                    "smlald" => "__builtin_arm_smlald",
                    "smlaldx" => "__builtin_arm_smlaldx",
                    "smlatb" => "__builtin_arm_smlatb",
                    "smlatt" => "__builtin_arm_smlatt",
                    "smlawb" => "__builtin_arm_smlawb",
                    "smlawt" => "__builtin_arm_smlawt",
                    "smlsd" => "__builtin_arm_smlsd",
                    "smlsdx" => "__builtin_arm_smlsdx",
                    "smlsld" => "__builtin_arm_smlsld",
                    "smlsldx" => "__builtin_arm_smlsldx",
                    "smuad" => "__builtin_arm_smuad",
                    "smuadx" => "__builtin_arm_smuadx",
                    "smulbb" => "__builtin_arm_smulbb",
                    "smulbt" => "__builtin_arm_smulbt",
                    "smultb" => "__builtin_arm_smultb",
                    "smultt" => "__builtin_arm_smultt",
                    "smulwb" => "__builtin_arm_smulwb",
                    "smulwt" => "__builtin_arm_smulwt",
                    "smusd" => "__builtin_arm_smusd",
                    "smusdx" => "__builtin_arm_smusdx",
                    "ssat" => "__builtin_arm_ssat",
                    "ssat16" => "__builtin_arm_ssat16",
                    "ssax" => "__builtin_arm_ssax",
                    "ssub16" => "__builtin_arm_ssub16",
                    "ssub8" => "__builtin_arm_ssub8",
                    "stc" => "__builtin_arm_stc",
                    "stc2" => "__builtin_arm_stc2",
                    "stc2l" => "__builtin_arm_stc2l",
                    "stcl" => "__builtin_arm_stcl",
                    "sxtab16" => "__builtin_arm_sxtab16",
                    "sxtb16" => "__builtin_arm_sxtb16",
                    "thread.pointer" => "__builtin_thread_pointer",
                    "uadd16" => "__builtin_arm_uadd16",
                    "uadd8" => "__builtin_arm_uadd8",
                    "uasx" => "__builtin_arm_uasx",
                    "uhadd16" => "__builtin_arm_uhadd16",
                    "uhadd8" => "__builtin_arm_uhadd8",
                    "uhasx" => "__builtin_arm_uhasx",
                    "uhsax" => "__builtin_arm_uhsax",
                    "uhsub16" => "__builtin_arm_uhsub16",
                    "uhsub8" => "__builtin_arm_uhsub8",
                    "uqadd16" => "__builtin_arm_uqadd16",
                    "uqadd8" => "__builtin_arm_uqadd8",
                    "uqasx" => "__builtin_arm_uqasx",
                    "uqsax" => "__builtin_arm_uqsax",
                    "uqsub16" => "__builtin_arm_uqsub16",
                    "uqsub8" => "__builtin_arm_uqsub8",
                    "usad8" => "__builtin_arm_usad8",
                    "usada8" => "__builtin_arm_usada8",
                    "usat" => "__builtin_arm_usat",
                    "usat16" => "__builtin_arm_usat16",
                    "usax" => "__builtin_arm_usax",
                    "usub16" => "__builtin_arm_usub16",
                    "usub8" => "__builtin_arm_usub8",
                    "uxtab16" => "__builtin_arm_uxtab16",
                    "uxtb16" => "__builtin_arm_uxtb16",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            arm(name, full_name)
        }
        "bpf" => {
            fn bpf(name: &str, full_name: &str) -> &'static str {
                match name {
                    // bpf
                    "btf.type.id" => "__builtin_bpf_btf_type_id",
                    "compare" => "__builtin_bpf_compare",
                    "getelementptr.and.load" => "__builtin_bpf_getelementptr_and_load",
                    "getelementptr.and.store" => "__builtin_bpf_getelementptr_and_store",
                    "load.byte" => "__builtin_bpf_load_byte",
                    "load.half" => "__builtin_bpf_load_half",
                    "load.word" => "__builtin_bpf_load_word",
                    "passthrough" => "__builtin_bpf_passthrough",
                    "preserve.enum.value" => "__builtin_bpf_preserve_enum_value",
                    "preserve.field.info" => "__builtin_bpf_preserve_field_info",
                    "preserve.type.info" => "__builtin_bpf_preserve_type_info",
                    "pseudo" => "__builtin_bpf_pseudo",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            bpf(name, full_name)
        }
        "cuda" => {
            fn cuda(name: &str, full_name: &str) -> &'static str {
                match name {
                    // cuda
                    "syncthreads" => "__syncthreads",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            cuda(name, full_name)
        }
        "hexagon" => {
            fn hexagon(name: &str, full_name: &str) -> &'static str {
                match name {
                    // hexagon
                    "A2.abs" => "__builtin_HEXAGON_A2_abs",
                    "A2.absp" => "__builtin_HEXAGON_A2_absp",
                    "A2.abssat" => "__builtin_HEXAGON_A2_abssat",
                    "A2.add" => "__builtin_HEXAGON_A2_add",
                    "A2.addh.h16.hh" => "__builtin_HEXAGON_A2_addh_h16_hh",
                    "A2.addh.h16.hl" => "__builtin_HEXAGON_A2_addh_h16_hl",
                    "A2.addh.h16.lh" => "__builtin_HEXAGON_A2_addh_h16_lh",
                    "A2.addh.h16.ll" => "__builtin_HEXAGON_A2_addh_h16_ll",
                    "A2.addh.h16.sat.hh" => "__builtin_HEXAGON_A2_addh_h16_sat_hh",
                    "A2.addh.h16.sat.hl" => "__builtin_HEXAGON_A2_addh_h16_sat_hl",
                    "A2.addh.h16.sat.lh" => "__builtin_HEXAGON_A2_addh_h16_sat_lh",
                    "A2.addh.h16.sat.ll" => "__builtin_HEXAGON_A2_addh_h16_sat_ll",
                    "A2.addh.l16.hl" => "__builtin_HEXAGON_A2_addh_l16_hl",
                    "A2.addh.l16.ll" => "__builtin_HEXAGON_A2_addh_l16_ll",
                    "A2.addh.l16.sat.hl" => "__builtin_HEXAGON_A2_addh_l16_sat_hl",
                    "A2.addh.l16.sat.ll" => "__builtin_HEXAGON_A2_addh_l16_sat_ll",
                    "A2.addi" => "__builtin_HEXAGON_A2_addi",
                    "A2.addp" => "__builtin_HEXAGON_A2_addp",
                    "A2.addpsat" => "__builtin_HEXAGON_A2_addpsat",
                    "A2.addsat" => "__builtin_HEXAGON_A2_addsat",
                    "A2.addsp" => "__builtin_HEXAGON_A2_addsp",
                    "A2.and" => "__builtin_HEXAGON_A2_and",
                    "A2.andir" => "__builtin_HEXAGON_A2_andir",
                    "A2.andp" => "__builtin_HEXAGON_A2_andp",
                    "A2.aslh" => "__builtin_HEXAGON_A2_aslh",
                    "A2.asrh" => "__builtin_HEXAGON_A2_asrh",
                    "A2.combine.hh" => "__builtin_HEXAGON_A2_combine_hh",
                    "A2.combine.hl" => "__builtin_HEXAGON_A2_combine_hl",
                    "A2.combine.lh" => "__builtin_HEXAGON_A2_combine_lh",
                    "A2.combine.ll" => "__builtin_HEXAGON_A2_combine_ll",
                    "A2.combineii" => "__builtin_HEXAGON_A2_combineii",
                    "A2.combinew" => "__builtin_HEXAGON_A2_combinew",
                    "A2.max" => "__builtin_HEXAGON_A2_max",
                    "A2.maxp" => "__builtin_HEXAGON_A2_maxp",
                    "A2.maxu" => "__builtin_HEXAGON_A2_maxu",
                    "A2.maxup" => "__builtin_HEXAGON_A2_maxup",
                    "A2.min" => "__builtin_HEXAGON_A2_min",
                    "A2.minp" => "__builtin_HEXAGON_A2_minp",
                    "A2.minu" => "__builtin_HEXAGON_A2_minu",
                    "A2.minup" => "__builtin_HEXAGON_A2_minup",
                    "A2.neg" => "__builtin_HEXAGON_A2_neg",
                    "A2.negp" => "__builtin_HEXAGON_A2_negp",
                    "A2.negsat" => "__builtin_HEXAGON_A2_negsat",
                    "A2.not" => "__builtin_HEXAGON_A2_not",
                    "A2.notp" => "__builtin_HEXAGON_A2_notp",
                    "A2.or" => "__builtin_HEXAGON_A2_or",
                    "A2.orir" => "__builtin_HEXAGON_A2_orir",
                    "A2.orp" => "__builtin_HEXAGON_A2_orp",
                    "A2.roundsat" => "__builtin_HEXAGON_A2_roundsat",
                    "A2.sat" => "__builtin_HEXAGON_A2_sat",
                    "A2.satb" => "__builtin_HEXAGON_A2_satb",
                    "A2.sath" => "__builtin_HEXAGON_A2_sath",
                    "A2.satub" => "__builtin_HEXAGON_A2_satub",
                    "A2.satuh" => "__builtin_HEXAGON_A2_satuh",
                    "A2.sub" => "__builtin_HEXAGON_A2_sub",
                    "A2.subh.h16.hh" => "__builtin_HEXAGON_A2_subh_h16_hh",
                    "A2.subh.h16.hl" => "__builtin_HEXAGON_A2_subh_h16_hl",
                    "A2.subh.h16.lh" => "__builtin_HEXAGON_A2_subh_h16_lh",
                    "A2.subh.h16.ll" => "__builtin_HEXAGON_A2_subh_h16_ll",
                    "A2.subh.h16.sat.hh" => "__builtin_HEXAGON_A2_subh_h16_sat_hh",
                    "A2.subh.h16.sat.hl" => "__builtin_HEXAGON_A2_subh_h16_sat_hl",
                    "A2.subh.h16.sat.lh" => "__builtin_HEXAGON_A2_subh_h16_sat_lh",
                    "A2.subh.h16.sat.ll" => "__builtin_HEXAGON_A2_subh_h16_sat_ll",
                    "A2.subh.l16.hl" => "__builtin_HEXAGON_A2_subh_l16_hl",
                    "A2.subh.l16.ll" => "__builtin_HEXAGON_A2_subh_l16_ll",
                    "A2.subh.l16.sat.hl" => "__builtin_HEXAGON_A2_subh_l16_sat_hl",
                    "A2.subh.l16.sat.ll" => "__builtin_HEXAGON_A2_subh_l16_sat_ll",
                    "A2.subp" => "__builtin_HEXAGON_A2_subp",
                    "A2.subri" => "__builtin_HEXAGON_A2_subri",
                    "A2.subsat" => "__builtin_HEXAGON_A2_subsat",
                    "A2.svaddh" => "__builtin_HEXAGON_A2_svaddh",
                    "A2.svaddhs" => "__builtin_HEXAGON_A2_svaddhs",
                    "A2.svadduhs" => "__builtin_HEXAGON_A2_svadduhs",
                    "A2.svavgh" => "__builtin_HEXAGON_A2_svavgh",
                    "A2.svavghs" => "__builtin_HEXAGON_A2_svavghs",
                    "A2.svnavgh" => "__builtin_HEXAGON_A2_svnavgh",
                    "A2.svsubh" => "__builtin_HEXAGON_A2_svsubh",
                    "A2.svsubhs" => "__builtin_HEXAGON_A2_svsubhs",
                    "A2.svsubuhs" => "__builtin_HEXAGON_A2_svsubuhs",
                    "A2.swiz" => "__builtin_HEXAGON_A2_swiz",
                    "A2.sxtb" => "__builtin_HEXAGON_A2_sxtb",
                    "A2.sxth" => "__builtin_HEXAGON_A2_sxth",
                    "A2.sxtw" => "__builtin_HEXAGON_A2_sxtw",
                    "A2.tfr" => "__builtin_HEXAGON_A2_tfr",
                    "A2.tfrih" => "__builtin_HEXAGON_A2_tfrih",
                    "A2.tfril" => "__builtin_HEXAGON_A2_tfril",
                    "A2.tfrp" => "__builtin_HEXAGON_A2_tfrp",
                    "A2.tfrpi" => "__builtin_HEXAGON_A2_tfrpi",
                    "A2.tfrsi" => "__builtin_HEXAGON_A2_tfrsi",
                    "A2.vabsh" => "__builtin_HEXAGON_A2_vabsh",
                    "A2.vabshsat" => "__builtin_HEXAGON_A2_vabshsat",
                    "A2.vabsw" => "__builtin_HEXAGON_A2_vabsw",
                    "A2.vabswsat" => "__builtin_HEXAGON_A2_vabswsat",
                    "A2.vaddb.map" => "__builtin_HEXAGON_A2_vaddb_map",
                    "A2.vaddh" => "__builtin_HEXAGON_A2_vaddh",
                    "A2.vaddhs" => "__builtin_HEXAGON_A2_vaddhs",
                    "A2.vaddub" => "__builtin_HEXAGON_A2_vaddub",
                    "A2.vaddubs" => "__builtin_HEXAGON_A2_vaddubs",
                    "A2.vadduhs" => "__builtin_HEXAGON_A2_vadduhs",
                    "A2.vaddw" => "__builtin_HEXAGON_A2_vaddw",
                    "A2.vaddws" => "__builtin_HEXAGON_A2_vaddws",
                    "A2.vavgh" => "__builtin_HEXAGON_A2_vavgh",
                    "A2.vavghcr" => "__builtin_HEXAGON_A2_vavghcr",
                    "A2.vavghr" => "__builtin_HEXAGON_A2_vavghr",
                    "A2.vavgub" => "__builtin_HEXAGON_A2_vavgub",
                    "A2.vavgubr" => "__builtin_HEXAGON_A2_vavgubr",
                    "A2.vavguh" => "__builtin_HEXAGON_A2_vavguh",
                    "A2.vavguhr" => "__builtin_HEXAGON_A2_vavguhr",
                    "A2.vavguw" => "__builtin_HEXAGON_A2_vavguw",
                    "A2.vavguwr" => "__builtin_HEXAGON_A2_vavguwr",
                    "A2.vavgw" => "__builtin_HEXAGON_A2_vavgw",
                    "A2.vavgwcr" => "__builtin_HEXAGON_A2_vavgwcr",
                    "A2.vavgwr" => "__builtin_HEXAGON_A2_vavgwr",
                    "A2.vcmpbeq" => "__builtin_HEXAGON_A2_vcmpbeq",
                    "A2.vcmpbgtu" => "__builtin_HEXAGON_A2_vcmpbgtu",
                    "A2.vcmpheq" => "__builtin_HEXAGON_A2_vcmpheq",
                    "A2.vcmphgt" => "__builtin_HEXAGON_A2_vcmphgt",
                    "A2.vcmphgtu" => "__builtin_HEXAGON_A2_vcmphgtu",
                    "A2.vcmpweq" => "__builtin_HEXAGON_A2_vcmpweq",
                    "A2.vcmpwgt" => "__builtin_HEXAGON_A2_vcmpwgt",
                    "A2.vcmpwgtu" => "__builtin_HEXAGON_A2_vcmpwgtu",
                    "A2.vconj" => "__builtin_HEXAGON_A2_vconj",
                    "A2.vmaxb" => "__builtin_HEXAGON_A2_vmaxb",
                    "A2.vmaxh" => "__builtin_HEXAGON_A2_vmaxh",
                    "A2.vmaxub" => "__builtin_HEXAGON_A2_vmaxub",
                    "A2.vmaxuh" => "__builtin_HEXAGON_A2_vmaxuh",
                    "A2.vmaxuw" => "__builtin_HEXAGON_A2_vmaxuw",
                    "A2.vmaxw" => "__builtin_HEXAGON_A2_vmaxw",
                    "A2.vminb" => "__builtin_HEXAGON_A2_vminb",
                    "A2.vminh" => "__builtin_HEXAGON_A2_vminh",
                    "A2.vminub" => "__builtin_HEXAGON_A2_vminub",
                    "A2.vminuh" => "__builtin_HEXAGON_A2_vminuh",
                    "A2.vminuw" => "__builtin_HEXAGON_A2_vminuw",
                    "A2.vminw" => "__builtin_HEXAGON_A2_vminw",
                    "A2.vnavgh" => "__builtin_HEXAGON_A2_vnavgh",
                    "A2.vnavghcr" => "__builtin_HEXAGON_A2_vnavghcr",
                    "A2.vnavghr" => "__builtin_HEXAGON_A2_vnavghr",
                    "A2.vnavgw" => "__builtin_HEXAGON_A2_vnavgw",
                    "A2.vnavgwcr" => "__builtin_HEXAGON_A2_vnavgwcr",
                    "A2.vnavgwr" => "__builtin_HEXAGON_A2_vnavgwr",
                    "A2.vraddub" => "__builtin_HEXAGON_A2_vraddub",
                    "A2.vraddub.acc" => "__builtin_HEXAGON_A2_vraddub_acc",
                    "A2.vrsadub" => "__builtin_HEXAGON_A2_vrsadub",
                    "A2.vrsadub.acc" => "__builtin_HEXAGON_A2_vrsadub_acc",
                    "A2.vsubb.map" => "__builtin_HEXAGON_A2_vsubb_map",
                    "A2.vsubh" => "__builtin_HEXAGON_A2_vsubh",
                    "A2.vsubhs" => "__builtin_HEXAGON_A2_vsubhs",
                    "A2.vsubub" => "__builtin_HEXAGON_A2_vsubub",
                    "A2.vsububs" => "__builtin_HEXAGON_A2_vsububs",
                    "A2.vsubuhs" => "__builtin_HEXAGON_A2_vsubuhs",
                    "A2.vsubw" => "__builtin_HEXAGON_A2_vsubw",
                    "A2.vsubws" => "__builtin_HEXAGON_A2_vsubws",
                    "A2.xor" => "__builtin_HEXAGON_A2_xor",
                    "A2.xorp" => "__builtin_HEXAGON_A2_xorp",
                    "A2.zxtb" => "__builtin_HEXAGON_A2_zxtb",
                    "A2.zxth" => "__builtin_HEXAGON_A2_zxth",
                    "A4.andn" => "__builtin_HEXAGON_A4_andn",
                    "A4.andnp" => "__builtin_HEXAGON_A4_andnp",
                    "A4.bitsplit" => "__builtin_HEXAGON_A4_bitsplit",
                    "A4.bitspliti" => "__builtin_HEXAGON_A4_bitspliti",
                    "A4.boundscheck" => "__builtin_HEXAGON_A4_boundscheck",
                    "A4.cmpbeq" => "__builtin_HEXAGON_A4_cmpbeq",
                    "A4.cmpbeqi" => "__builtin_HEXAGON_A4_cmpbeqi",
                    "A4.cmpbgt" => "__builtin_HEXAGON_A4_cmpbgt",
                    "A4.cmpbgti" => "__builtin_HEXAGON_A4_cmpbgti",
                    "A4.cmpbgtu" => "__builtin_HEXAGON_A4_cmpbgtu",
                    "A4.cmpbgtui" => "__builtin_HEXAGON_A4_cmpbgtui",
                    "A4.cmpheq" => "__builtin_HEXAGON_A4_cmpheq",
                    "A4.cmpheqi" => "__builtin_HEXAGON_A4_cmpheqi",
                    "A4.cmphgt" => "__builtin_HEXAGON_A4_cmphgt",
                    "A4.cmphgti" => "__builtin_HEXAGON_A4_cmphgti",
                    "A4.cmphgtu" => "__builtin_HEXAGON_A4_cmphgtu",
                    "A4.cmphgtui" => "__builtin_HEXAGON_A4_cmphgtui",
                    "A4.combineir" => "__builtin_HEXAGON_A4_combineir",
                    "A4.combineri" => "__builtin_HEXAGON_A4_combineri",
                    "A4.cround.ri" => "__builtin_HEXAGON_A4_cround_ri",
                    "A4.cround.rr" => "__builtin_HEXAGON_A4_cround_rr",
                    "A4.modwrapu" => "__builtin_HEXAGON_A4_modwrapu",
                    "A4.orn" => "__builtin_HEXAGON_A4_orn",
                    "A4.ornp" => "__builtin_HEXAGON_A4_ornp",
                    "A4.rcmpeq" => "__builtin_HEXAGON_A4_rcmpeq",
                    "A4.rcmpeqi" => "__builtin_HEXAGON_A4_rcmpeqi",
                    "A4.rcmpneq" => "__builtin_HEXAGON_A4_rcmpneq",
                    "A4.rcmpneqi" => "__builtin_HEXAGON_A4_rcmpneqi",
                    "A4.round.ri" => "__builtin_HEXAGON_A4_round_ri",
                    "A4.round.ri.sat" => "__builtin_HEXAGON_A4_round_ri_sat",
                    "A4.round.rr" => "__builtin_HEXAGON_A4_round_rr",
                    "A4.round.rr.sat" => "__builtin_HEXAGON_A4_round_rr_sat",
                    "A4.tlbmatch" => "__builtin_HEXAGON_A4_tlbmatch",
                    "A4.vcmpbeq.any" => "__builtin_HEXAGON_A4_vcmpbeq_any",
                    "A4.vcmpbeqi" => "__builtin_HEXAGON_A4_vcmpbeqi",
                    "A4.vcmpbgt" => "__builtin_HEXAGON_A4_vcmpbgt",
                    "A4.vcmpbgti" => "__builtin_HEXAGON_A4_vcmpbgti",
                    "A4.vcmpbgtui" => "__builtin_HEXAGON_A4_vcmpbgtui",
                    "A4.vcmpheqi" => "__builtin_HEXAGON_A4_vcmpheqi",
                    "A4.vcmphgti" => "__builtin_HEXAGON_A4_vcmphgti",
                    "A4.vcmphgtui" => "__builtin_HEXAGON_A4_vcmphgtui",
                    "A4.vcmpweqi" => "__builtin_HEXAGON_A4_vcmpweqi",
                    "A4.vcmpwgti" => "__builtin_HEXAGON_A4_vcmpwgti",
                    "A4.vcmpwgtui" => "__builtin_HEXAGON_A4_vcmpwgtui",
                    "A4.vrmaxh" => "__builtin_HEXAGON_A4_vrmaxh",
                    "A4.vrmaxuh" => "__builtin_HEXAGON_A4_vrmaxuh",
                    "A4.vrmaxuw" => "__builtin_HEXAGON_A4_vrmaxuw",
                    "A4.vrmaxw" => "__builtin_HEXAGON_A4_vrmaxw",
                    "A4.vrminh" => "__builtin_HEXAGON_A4_vrminh",
                    "A4.vrminuh" => "__builtin_HEXAGON_A4_vrminuh",
                    "A4.vrminuw" => "__builtin_HEXAGON_A4_vrminuw",
                    "A4.vrminw" => "__builtin_HEXAGON_A4_vrminw",
                    "A5.vaddhubs" => "__builtin_HEXAGON_A5_vaddhubs",
                    "A6.vcmpbeq.notany" => "__builtin_HEXAGON_A6_vcmpbeq_notany",
                    "A7.clip" => "__builtin_HEXAGON_A7_clip",
                    "A7.croundd.ri" => "__builtin_HEXAGON_A7_croundd_ri",
                    "A7.croundd.rr" => "__builtin_HEXAGON_A7_croundd_rr",
                    "A7.vclip" => "__builtin_HEXAGON_A7_vclip",
                    "C2.all8" => "__builtin_HEXAGON_C2_all8",
                    "C2.and" => "__builtin_HEXAGON_C2_and",
                    "C2.andn" => "__builtin_HEXAGON_C2_andn",
                    "C2.any8" => "__builtin_HEXAGON_C2_any8",
                    "C2.bitsclr" => "__builtin_HEXAGON_C2_bitsclr",
                    "C2.bitsclri" => "__builtin_HEXAGON_C2_bitsclri",
                    "C2.bitsset" => "__builtin_HEXAGON_C2_bitsset",
                    "C2.cmpeq" => "__builtin_HEXAGON_C2_cmpeq",
                    "C2.cmpeqi" => "__builtin_HEXAGON_C2_cmpeqi",
                    "C2.cmpeqp" => "__builtin_HEXAGON_C2_cmpeqp",
                    "C2.cmpgei" => "__builtin_HEXAGON_C2_cmpgei",
                    "C2.cmpgeui" => "__builtin_HEXAGON_C2_cmpgeui",
                    "C2.cmpgt" => "__builtin_HEXAGON_C2_cmpgt",
                    "C2.cmpgti" => "__builtin_HEXAGON_C2_cmpgti",
                    "C2.cmpgtp" => "__builtin_HEXAGON_C2_cmpgtp",
                    "C2.cmpgtu" => "__builtin_HEXAGON_C2_cmpgtu",
                    "C2.cmpgtui" => "__builtin_HEXAGON_C2_cmpgtui",
                    "C2.cmpgtup" => "__builtin_HEXAGON_C2_cmpgtup",
                    "C2.cmplt" => "__builtin_HEXAGON_C2_cmplt",
                    "C2.cmpltu" => "__builtin_HEXAGON_C2_cmpltu",
                    "C2.mask" => "__builtin_HEXAGON_C2_mask",
                    "C2.mux" => "__builtin_HEXAGON_C2_mux",
                    "C2.muxii" => "__builtin_HEXAGON_C2_muxii",
                    "C2.muxir" => "__builtin_HEXAGON_C2_muxir",
                    "C2.muxri" => "__builtin_HEXAGON_C2_muxri",
                    "C2.not" => "__builtin_HEXAGON_C2_not",
                    "C2.or" => "__builtin_HEXAGON_C2_or",
                    "C2.orn" => "__builtin_HEXAGON_C2_orn",
                    "C2.pxfer.map" => "__builtin_HEXAGON_C2_pxfer_map",
                    "C2.tfrpr" => "__builtin_HEXAGON_C2_tfrpr",
                    "C2.tfrrp" => "__builtin_HEXAGON_C2_tfrrp",
                    "C2.vitpack" => "__builtin_HEXAGON_C2_vitpack",
                    "C2.vmux" => "__builtin_HEXAGON_C2_vmux",
                    "C2.xor" => "__builtin_HEXAGON_C2_xor",
                    "C4.and.and" => "__builtin_HEXAGON_C4_and_and",
                    "C4.and.andn" => "__builtin_HEXAGON_C4_and_andn",
                    "C4.and.or" => "__builtin_HEXAGON_C4_and_or",
                    "C4.and.orn" => "__builtin_HEXAGON_C4_and_orn",
                    "C4.cmplte" => "__builtin_HEXAGON_C4_cmplte",
                    "C4.cmpltei" => "__builtin_HEXAGON_C4_cmpltei",
                    "C4.cmplteu" => "__builtin_HEXAGON_C4_cmplteu",
                    "C4.cmplteui" => "__builtin_HEXAGON_C4_cmplteui",
                    "C4.cmpneq" => "__builtin_HEXAGON_C4_cmpneq",
                    "C4.cmpneqi" => "__builtin_HEXAGON_C4_cmpneqi",
                    "C4.fastcorner9" => "__builtin_HEXAGON_C4_fastcorner9",
                    "C4.fastcorner9.not" => "__builtin_HEXAGON_C4_fastcorner9_not",
                    "C4.nbitsclr" => "__builtin_HEXAGON_C4_nbitsclr",
                    "C4.nbitsclri" => "__builtin_HEXAGON_C4_nbitsclri",
                    "C4.nbitsset" => "__builtin_HEXAGON_C4_nbitsset",
                    "C4.or.and" => "__builtin_HEXAGON_C4_or_and",
                    "C4.or.andn" => "__builtin_HEXAGON_C4_or_andn",
                    "C4.or.or" => "__builtin_HEXAGON_C4_or_or",
                    "C4.or.orn" => "__builtin_HEXAGON_C4_or_orn",
                    "F2.conv.d2df" => "__builtin_HEXAGON_F2_conv_d2df",
                    "F2.conv.d2sf" => "__builtin_HEXAGON_F2_conv_d2sf",
                    "F2.conv.df2d" => "__builtin_HEXAGON_F2_conv_df2d",
                    "F2.conv.df2d.chop" => "__builtin_HEXAGON_F2_conv_df2d_chop",
                    "F2.conv.df2sf" => "__builtin_HEXAGON_F2_conv_df2sf",
                    "F2.conv.df2ud" => "__builtin_HEXAGON_F2_conv_df2ud",
                    "F2.conv.df2ud.chop" => "__builtin_HEXAGON_F2_conv_df2ud_chop",
                    "F2.conv.df2uw" => "__builtin_HEXAGON_F2_conv_df2uw",
                    "F2.conv.df2uw.chop" => "__builtin_HEXAGON_F2_conv_df2uw_chop",
                    "F2.conv.df2w" => "__builtin_HEXAGON_F2_conv_df2w",
                    "F2.conv.df2w.chop" => "__builtin_HEXAGON_F2_conv_df2w_chop",
                    "F2.conv.sf2d" => "__builtin_HEXAGON_F2_conv_sf2d",
                    "F2.conv.sf2d.chop" => "__builtin_HEXAGON_F2_conv_sf2d_chop",
                    "F2.conv.sf2df" => "__builtin_HEXAGON_F2_conv_sf2df",
                    "F2.conv.sf2ud" => "__builtin_HEXAGON_F2_conv_sf2ud",
                    "F2.conv.sf2ud.chop" => "__builtin_HEXAGON_F2_conv_sf2ud_chop",
                    "F2.conv.sf2uw" => "__builtin_HEXAGON_F2_conv_sf2uw",
                    "F2.conv.sf2uw.chop" => "__builtin_HEXAGON_F2_conv_sf2uw_chop",
                    "F2.conv.sf2w" => "__builtin_HEXAGON_F2_conv_sf2w",
                    "F2.conv.sf2w.chop" => "__builtin_HEXAGON_F2_conv_sf2w_chop",
                    "F2.conv.ud2df" => "__builtin_HEXAGON_F2_conv_ud2df",
                    "F2.conv.ud2sf" => "__builtin_HEXAGON_F2_conv_ud2sf",
                    "F2.conv.uw2df" => "__builtin_HEXAGON_F2_conv_uw2df",
                    "F2.conv.uw2sf" => "__builtin_HEXAGON_F2_conv_uw2sf",
                    "F2.conv.w2df" => "__builtin_HEXAGON_F2_conv_w2df",
                    "F2.conv.w2sf" => "__builtin_HEXAGON_F2_conv_w2sf",
                    "F2.dfadd" => "__builtin_HEXAGON_F2_dfadd",
                    "F2.dfclass" => "__builtin_HEXAGON_F2_dfclass",
                    "F2.dfcmpeq" => "__builtin_HEXAGON_F2_dfcmpeq",
                    "F2.dfcmpge" => "__builtin_HEXAGON_F2_dfcmpge",
                    "F2.dfcmpgt" => "__builtin_HEXAGON_F2_dfcmpgt",
                    "F2.dfcmpuo" => "__builtin_HEXAGON_F2_dfcmpuo",
                    "F2.dffixupd" => "__builtin_HEXAGON_F2_dffixupd",
                    "F2.dffixupn" => "__builtin_HEXAGON_F2_dffixupn",
                    "F2.dffixupr" => "__builtin_HEXAGON_F2_dffixupr",
                    "F2.dffma" => "__builtin_HEXAGON_F2_dffma",
                    "F2.dffma.lib" => "__builtin_HEXAGON_F2_dffma_lib",
                    "F2.dffma.sc" => "__builtin_HEXAGON_F2_dffma_sc",
                    "F2.dffms" => "__builtin_HEXAGON_F2_dffms",
                    "F2.dffms.lib" => "__builtin_HEXAGON_F2_dffms_lib",
                    "F2.dfimm.n" => "__builtin_HEXAGON_F2_dfimm_n",
                    "F2.dfimm.p" => "__builtin_HEXAGON_F2_dfimm_p",
                    "F2.dfmax" => "__builtin_HEXAGON_F2_dfmax",
                    "F2.dfmin" => "__builtin_HEXAGON_F2_dfmin",
                    "F2.dfmpy" => "__builtin_HEXAGON_F2_dfmpy",
                    "F2.dfmpyfix" => "__builtin_HEXAGON_F2_dfmpyfix",
                    "F2.dfmpyhh" => "__builtin_HEXAGON_F2_dfmpyhh",
                    "F2.dfmpylh" => "__builtin_HEXAGON_F2_dfmpylh",
                    "F2.dfmpyll" => "__builtin_HEXAGON_F2_dfmpyll",
                    "F2.dfsub" => "__builtin_HEXAGON_F2_dfsub",
                    "F2.sfadd" => "__builtin_HEXAGON_F2_sfadd",
                    "F2.sfclass" => "__builtin_HEXAGON_F2_sfclass",
                    "F2.sfcmpeq" => "__builtin_HEXAGON_F2_sfcmpeq",
                    "F2.sfcmpge" => "__builtin_HEXAGON_F2_sfcmpge",
                    "F2.sfcmpgt" => "__builtin_HEXAGON_F2_sfcmpgt",
                    "F2.sfcmpuo" => "__builtin_HEXAGON_F2_sfcmpuo",
                    "F2.sffixupd" => "__builtin_HEXAGON_F2_sffixupd",
                    "F2.sffixupn" => "__builtin_HEXAGON_F2_sffixupn",
                    "F2.sffixupr" => "__builtin_HEXAGON_F2_sffixupr",
                    "F2.sffma" => "__builtin_HEXAGON_F2_sffma",
                    "F2.sffma.lib" => "__builtin_HEXAGON_F2_sffma_lib",
                    "F2.sffma.sc" => "__builtin_HEXAGON_F2_sffma_sc",
                    "F2.sffms" => "__builtin_HEXAGON_F2_sffms",
                    "F2.sffms.lib" => "__builtin_HEXAGON_F2_sffms_lib",
                    "F2.sfimm.n" => "__builtin_HEXAGON_F2_sfimm_n",
                    "F2.sfimm.p" => "__builtin_HEXAGON_F2_sfimm_p",
                    "F2.sfmax" => "__builtin_HEXAGON_F2_sfmax",
                    "F2.sfmin" => "__builtin_HEXAGON_F2_sfmin",
                    "F2.sfmpy" => "__builtin_HEXAGON_F2_sfmpy",
                    "F2.sfsub" => "__builtin_HEXAGON_F2_sfsub",
                    "L2.loadw.locked" => "__builtin_HEXAGON_L2_loadw_locked",
                    "L4.loadd.locked" => "__builtin__HEXAGON_L4_loadd_locked",
                    "M2.acci" => "__builtin_HEXAGON_M2_acci",
                    "M2.accii" => "__builtin_HEXAGON_M2_accii",
                    "M2.cmaci.s0" => "__builtin_HEXAGON_M2_cmaci_s0",
                    "M2.cmacr.s0" => "__builtin_HEXAGON_M2_cmacr_s0",
                    "M2.cmacs.s0" => "__builtin_HEXAGON_M2_cmacs_s0",
                    "M2.cmacs.s1" => "__builtin_HEXAGON_M2_cmacs_s1",
                    "M2.cmacsc.s0" => "__builtin_HEXAGON_M2_cmacsc_s0",
                    "M2.cmacsc.s1" => "__builtin_HEXAGON_M2_cmacsc_s1",
                    "M2.cmpyi.s0" => "__builtin_HEXAGON_M2_cmpyi_s0",
                    "M2.cmpyr.s0" => "__builtin_HEXAGON_M2_cmpyr_s0",
                    "M2.cmpyrs.s0" => "__builtin_HEXAGON_M2_cmpyrs_s0",
                    "M2.cmpyrs.s1" => "__builtin_HEXAGON_M2_cmpyrs_s1",
                    "M2.cmpyrsc.s0" => "__builtin_HEXAGON_M2_cmpyrsc_s0",
                    "M2.cmpyrsc.s1" => "__builtin_HEXAGON_M2_cmpyrsc_s1",
                    "M2.cmpys.s0" => "__builtin_HEXAGON_M2_cmpys_s0",
                    "M2.cmpys.s1" => "__builtin_HEXAGON_M2_cmpys_s1",
                    "M2.cmpysc.s0" => "__builtin_HEXAGON_M2_cmpysc_s0",
                    "M2.cmpysc.s1" => "__builtin_HEXAGON_M2_cmpysc_s1",
                    "M2.cnacs.s0" => "__builtin_HEXAGON_M2_cnacs_s0",
                    "M2.cnacs.s1" => "__builtin_HEXAGON_M2_cnacs_s1",
                    "M2.cnacsc.s0" => "__builtin_HEXAGON_M2_cnacsc_s0",
                    "M2.cnacsc.s1" => "__builtin_HEXAGON_M2_cnacsc_s1",
                    "M2.dpmpyss.acc.s0" => "__builtin_HEXAGON_M2_dpmpyss_acc_s0",
                    "M2.dpmpyss.nac.s0" => "__builtin_HEXAGON_M2_dpmpyss_nac_s0",
                    "M2.dpmpyss.rnd.s0" => "__builtin_HEXAGON_M2_dpmpyss_rnd_s0",
                    "M2.dpmpyss.s0" => "__builtin_HEXAGON_M2_dpmpyss_s0",
                    "M2.dpmpyuu.acc.s0" => "__builtin_HEXAGON_M2_dpmpyuu_acc_s0",
                    "M2.dpmpyuu.nac.s0" => "__builtin_HEXAGON_M2_dpmpyuu_nac_s0",
                    "M2.dpmpyuu.s0" => "__builtin_HEXAGON_M2_dpmpyuu_s0",
                    "M2.hmmpyh.rs1" => "__builtin_HEXAGON_M2_hmmpyh_rs1",
                    "M2.hmmpyh.s1" => "__builtin_HEXAGON_M2_hmmpyh_s1",
                    "M2.hmmpyl.rs1" => "__builtin_HEXAGON_M2_hmmpyl_rs1",
                    "M2.hmmpyl.s1" => "__builtin_HEXAGON_M2_hmmpyl_s1",
                    "M2.maci" => "__builtin_HEXAGON_M2_maci",
                    "M2.macsin" => "__builtin_HEXAGON_M2_macsin",
                    "M2.macsip" => "__builtin_HEXAGON_M2_macsip",
                    "M2.mmachs.rs0" => "__builtin_HEXAGON_M2_mmachs_rs0",
                    "M2.mmachs.rs1" => "__builtin_HEXAGON_M2_mmachs_rs1",
                    "M2.mmachs.s0" => "__builtin_HEXAGON_M2_mmachs_s0",
                    "M2.mmachs.s1" => "__builtin_HEXAGON_M2_mmachs_s1",
                    "M2.mmacls.rs0" => "__builtin_HEXAGON_M2_mmacls_rs0",
                    "M2.mmacls.rs1" => "__builtin_HEXAGON_M2_mmacls_rs1",
                    "M2.mmacls.s0" => "__builtin_HEXAGON_M2_mmacls_s0",
                    "M2.mmacls.s1" => "__builtin_HEXAGON_M2_mmacls_s1",
                    "M2.mmacuhs.rs0" => "__builtin_HEXAGON_M2_mmacuhs_rs0",
                    "M2.mmacuhs.rs1" => "__builtin_HEXAGON_M2_mmacuhs_rs1",
                    "M2.mmacuhs.s0" => "__builtin_HEXAGON_M2_mmacuhs_s0",
                    "M2.mmacuhs.s1" => "__builtin_HEXAGON_M2_mmacuhs_s1",
                    "M2.mmaculs.rs0" => "__builtin_HEXAGON_M2_mmaculs_rs0",
                    "M2.mmaculs.rs1" => "__builtin_HEXAGON_M2_mmaculs_rs1",
                    "M2.mmaculs.s0" => "__builtin_HEXAGON_M2_mmaculs_s0",
                    "M2.mmaculs.s1" => "__builtin_HEXAGON_M2_mmaculs_s1",
                    "M2.mmpyh.rs0" => "__builtin_HEXAGON_M2_mmpyh_rs0",
                    "M2.mmpyh.rs1" => "__builtin_HEXAGON_M2_mmpyh_rs1",
                    "M2.mmpyh.s0" => "__builtin_HEXAGON_M2_mmpyh_s0",
                    "M2.mmpyh.s1" => "__builtin_HEXAGON_M2_mmpyh_s1",
                    "M2.mmpyl.rs0" => "__builtin_HEXAGON_M2_mmpyl_rs0",
                    "M2.mmpyl.rs1" => "__builtin_HEXAGON_M2_mmpyl_rs1",
                    "M2.mmpyl.s0" => "__builtin_HEXAGON_M2_mmpyl_s0",
                    "M2.mmpyl.s1" => "__builtin_HEXAGON_M2_mmpyl_s1",
                    "M2.mmpyuh.rs0" => "__builtin_HEXAGON_M2_mmpyuh_rs0",
                    "M2.mmpyuh.rs1" => "__builtin_HEXAGON_M2_mmpyuh_rs1",
                    "M2.mmpyuh.s0" => "__builtin_HEXAGON_M2_mmpyuh_s0",
                    "M2.mmpyuh.s1" => "__builtin_HEXAGON_M2_mmpyuh_s1",
                    "M2.mmpyul.rs0" => "__builtin_HEXAGON_M2_mmpyul_rs0",
                    "M2.mmpyul.rs1" => "__builtin_HEXAGON_M2_mmpyul_rs1",
                    "M2.mmpyul.s0" => "__builtin_HEXAGON_M2_mmpyul_s0",
                    "M2.mmpyul.s1" => "__builtin_HEXAGON_M2_mmpyul_s1",
                    "M2.mnaci" => "__builtin_HEXAGON_M2_mnaci",
                    "M2.mpy.acc.hh.s0" => "__builtin_HEXAGON_M2_mpy_acc_hh_s0",
                    "M2.mpy.acc.hh.s1" => "__builtin_HEXAGON_M2_mpy_acc_hh_s1",
                    "M2.mpy.acc.hl.s0" => "__builtin_HEXAGON_M2_mpy_acc_hl_s0",
                    "M2.mpy.acc.hl.s1" => "__builtin_HEXAGON_M2_mpy_acc_hl_s1",
                    "M2.mpy.acc.lh.s0" => "__builtin_HEXAGON_M2_mpy_acc_lh_s0",
                    "M2.mpy.acc.lh.s1" => "__builtin_HEXAGON_M2_mpy_acc_lh_s1",
                    "M2.mpy.acc.ll.s0" => "__builtin_HEXAGON_M2_mpy_acc_ll_s0",
                    "M2.mpy.acc.ll.s1" => "__builtin_HEXAGON_M2_mpy_acc_ll_s1",
                    "M2.mpy.acc.sat.hh.s0" => "__builtin_HEXAGON_M2_mpy_acc_sat_hh_s0",
                    "M2.mpy.acc.sat.hh.s1" => "__builtin_HEXAGON_M2_mpy_acc_sat_hh_s1",
                    "M2.mpy.acc.sat.hl.s0" => "__builtin_HEXAGON_M2_mpy_acc_sat_hl_s0",
                    "M2.mpy.acc.sat.hl.s1" => "__builtin_HEXAGON_M2_mpy_acc_sat_hl_s1",
                    "M2.mpy.acc.sat.lh.s0" => "__builtin_HEXAGON_M2_mpy_acc_sat_lh_s0",
                    "M2.mpy.acc.sat.lh.s1" => "__builtin_HEXAGON_M2_mpy_acc_sat_lh_s1",
                    "M2.mpy.acc.sat.ll.s0" => "__builtin_HEXAGON_M2_mpy_acc_sat_ll_s0",
                    "M2.mpy.acc.sat.ll.s1" => "__builtin_HEXAGON_M2_mpy_acc_sat_ll_s1",
                    "M2.mpy.hh.s0" => "__builtin_HEXAGON_M2_mpy_hh_s0",
                    "M2.mpy.hh.s1" => "__builtin_HEXAGON_M2_mpy_hh_s1",
                    "M2.mpy.hl.s0" => "__builtin_HEXAGON_M2_mpy_hl_s0",
                    "M2.mpy.hl.s1" => "__builtin_HEXAGON_M2_mpy_hl_s1",
                    "M2.mpy.lh.s0" => "__builtin_HEXAGON_M2_mpy_lh_s0",
                    "M2.mpy.lh.s1" => "__builtin_HEXAGON_M2_mpy_lh_s1",
                    "M2.mpy.ll.s0" => "__builtin_HEXAGON_M2_mpy_ll_s0",
                    "M2.mpy.ll.s1" => "__builtin_HEXAGON_M2_mpy_ll_s1",
                    "M2.mpy.nac.hh.s0" => "__builtin_HEXAGON_M2_mpy_nac_hh_s0",
                    "M2.mpy.nac.hh.s1" => "__builtin_HEXAGON_M2_mpy_nac_hh_s1",
                    "M2.mpy.nac.hl.s0" => "__builtin_HEXAGON_M2_mpy_nac_hl_s0",
                    "M2.mpy.nac.hl.s1" => "__builtin_HEXAGON_M2_mpy_nac_hl_s1",
                    "M2.mpy.nac.lh.s0" => "__builtin_HEXAGON_M2_mpy_nac_lh_s0",
                    "M2.mpy.nac.lh.s1" => "__builtin_HEXAGON_M2_mpy_nac_lh_s1",
                    "M2.mpy.nac.ll.s0" => "__builtin_HEXAGON_M2_mpy_nac_ll_s0",
                    "M2.mpy.nac.ll.s1" => "__builtin_HEXAGON_M2_mpy_nac_ll_s1",
                    "M2.mpy.nac.sat.hh.s0" => "__builtin_HEXAGON_M2_mpy_nac_sat_hh_s0",
                    "M2.mpy.nac.sat.hh.s1" => "__builtin_HEXAGON_M2_mpy_nac_sat_hh_s1",
                    "M2.mpy.nac.sat.hl.s0" => "__builtin_HEXAGON_M2_mpy_nac_sat_hl_s0",
                    "M2.mpy.nac.sat.hl.s1" => "__builtin_HEXAGON_M2_mpy_nac_sat_hl_s1",
                    "M2.mpy.nac.sat.lh.s0" => "__builtin_HEXAGON_M2_mpy_nac_sat_lh_s0",
                    "M2.mpy.nac.sat.lh.s1" => "__builtin_HEXAGON_M2_mpy_nac_sat_lh_s1",
                    "M2.mpy.nac.sat.ll.s0" => "__builtin_HEXAGON_M2_mpy_nac_sat_ll_s0",
                    "M2.mpy.nac.sat.ll.s1" => "__builtin_HEXAGON_M2_mpy_nac_sat_ll_s1",
                    "M2.mpy.rnd.hh.s0" => "__builtin_HEXAGON_M2_mpy_rnd_hh_s0",
                    "M2.mpy.rnd.hh.s1" => "__builtin_HEXAGON_M2_mpy_rnd_hh_s1",
                    "M2.mpy.rnd.hl.s0" => "__builtin_HEXAGON_M2_mpy_rnd_hl_s0",
                    "M2.mpy.rnd.hl.s1" => "__builtin_HEXAGON_M2_mpy_rnd_hl_s1",
                    "M2.mpy.rnd.lh.s0" => "__builtin_HEXAGON_M2_mpy_rnd_lh_s0",
                    "M2.mpy.rnd.lh.s1" => "__builtin_HEXAGON_M2_mpy_rnd_lh_s1",
                    "M2.mpy.rnd.ll.s0" => "__builtin_HEXAGON_M2_mpy_rnd_ll_s0",
                    "M2.mpy.rnd.ll.s1" => "__builtin_HEXAGON_M2_mpy_rnd_ll_s1",
                    "M2.mpy.sat.hh.s0" => "__builtin_HEXAGON_M2_mpy_sat_hh_s0",
                    "M2.mpy.sat.hh.s1" => "__builtin_HEXAGON_M2_mpy_sat_hh_s1",
                    "M2.mpy.sat.hl.s0" => "__builtin_HEXAGON_M2_mpy_sat_hl_s0",
                    "M2.mpy.sat.hl.s1" => "__builtin_HEXAGON_M2_mpy_sat_hl_s1",
                    "M2.mpy.sat.lh.s0" => "__builtin_HEXAGON_M2_mpy_sat_lh_s0",
                    "M2.mpy.sat.lh.s1" => "__builtin_HEXAGON_M2_mpy_sat_lh_s1",
                    "M2.mpy.sat.ll.s0" => "__builtin_HEXAGON_M2_mpy_sat_ll_s0",
                    "M2.mpy.sat.ll.s1" => "__builtin_HEXAGON_M2_mpy_sat_ll_s1",
                    "M2.mpy.sat.rnd.hh.s0" => "__builtin_HEXAGON_M2_mpy_sat_rnd_hh_s0",
                    "M2.mpy.sat.rnd.hh.s1" => "__builtin_HEXAGON_M2_mpy_sat_rnd_hh_s1",
                    "M2.mpy.sat.rnd.hl.s0" => "__builtin_HEXAGON_M2_mpy_sat_rnd_hl_s0",
                    "M2.mpy.sat.rnd.hl.s1" => "__builtin_HEXAGON_M2_mpy_sat_rnd_hl_s1",
                    "M2.mpy.sat.rnd.lh.s0" => "__builtin_HEXAGON_M2_mpy_sat_rnd_lh_s0",
                    "M2.mpy.sat.rnd.lh.s1" => "__builtin_HEXAGON_M2_mpy_sat_rnd_lh_s1",
                    "M2.mpy.sat.rnd.ll.s0" => "__builtin_HEXAGON_M2_mpy_sat_rnd_ll_s0",
                    "M2.mpy.sat.rnd.ll.s1" => "__builtin_HEXAGON_M2_mpy_sat_rnd_ll_s1",
                    "M2.mpy.up" => "__builtin_HEXAGON_M2_mpy_up",
                    "M2.mpy.up.s1" => "__builtin_HEXAGON_M2_mpy_up_s1",
                    "M2.mpy.up.s1.sat" => "__builtin_HEXAGON_M2_mpy_up_s1_sat",
                    "M2.mpyd.acc.hh.s0" => "__builtin_HEXAGON_M2_mpyd_acc_hh_s0",
                    "M2.mpyd.acc.hh.s1" => "__builtin_HEXAGON_M2_mpyd_acc_hh_s1",
                    "M2.mpyd.acc.hl.s0" => "__builtin_HEXAGON_M2_mpyd_acc_hl_s0",
                    "M2.mpyd.acc.hl.s1" => "__builtin_HEXAGON_M2_mpyd_acc_hl_s1",
                    "M2.mpyd.acc.lh.s0" => "__builtin_HEXAGON_M2_mpyd_acc_lh_s0",
                    "M2.mpyd.acc.lh.s1" => "__builtin_HEXAGON_M2_mpyd_acc_lh_s1",
                    "M2.mpyd.acc.ll.s0" => "__builtin_HEXAGON_M2_mpyd_acc_ll_s0",
                    "M2.mpyd.acc.ll.s1" => "__builtin_HEXAGON_M2_mpyd_acc_ll_s1",
                    "M2.mpyd.hh.s0" => "__builtin_HEXAGON_M2_mpyd_hh_s0",
                    "M2.mpyd.hh.s1" => "__builtin_HEXAGON_M2_mpyd_hh_s1",
                    "M2.mpyd.hl.s0" => "__builtin_HEXAGON_M2_mpyd_hl_s0",
                    "M2.mpyd.hl.s1" => "__builtin_HEXAGON_M2_mpyd_hl_s1",
                    "M2.mpyd.lh.s0" => "__builtin_HEXAGON_M2_mpyd_lh_s0",
                    "M2.mpyd.lh.s1" => "__builtin_HEXAGON_M2_mpyd_lh_s1",
                    "M2.mpyd.ll.s0" => "__builtin_HEXAGON_M2_mpyd_ll_s0",
                    "M2.mpyd.ll.s1" => "__builtin_HEXAGON_M2_mpyd_ll_s1",
                    "M2.mpyd.nac.hh.s0" => "__builtin_HEXAGON_M2_mpyd_nac_hh_s0",
                    "M2.mpyd.nac.hh.s1" => "__builtin_HEXAGON_M2_mpyd_nac_hh_s1",
                    "M2.mpyd.nac.hl.s0" => "__builtin_HEXAGON_M2_mpyd_nac_hl_s0",
                    "M2.mpyd.nac.hl.s1" => "__builtin_HEXAGON_M2_mpyd_nac_hl_s1",
                    "M2.mpyd.nac.lh.s0" => "__builtin_HEXAGON_M2_mpyd_nac_lh_s0",
                    "M2.mpyd.nac.lh.s1" => "__builtin_HEXAGON_M2_mpyd_nac_lh_s1",
                    "M2.mpyd.nac.ll.s0" => "__builtin_HEXAGON_M2_mpyd_nac_ll_s0",
                    "M2.mpyd.nac.ll.s1" => "__builtin_HEXAGON_M2_mpyd_nac_ll_s1",
                    "M2.mpyd.rnd.hh.s0" => "__builtin_HEXAGON_M2_mpyd_rnd_hh_s0",
                    "M2.mpyd.rnd.hh.s1" => "__builtin_HEXAGON_M2_mpyd_rnd_hh_s1",
                    "M2.mpyd.rnd.hl.s0" => "__builtin_HEXAGON_M2_mpyd_rnd_hl_s0",
                    "M2.mpyd.rnd.hl.s1" => "__builtin_HEXAGON_M2_mpyd_rnd_hl_s1",
                    "M2.mpyd.rnd.lh.s0" => "__builtin_HEXAGON_M2_mpyd_rnd_lh_s0",
                    "M2.mpyd.rnd.lh.s1" => "__builtin_HEXAGON_M2_mpyd_rnd_lh_s1",
                    "M2.mpyd.rnd.ll.s0" => "__builtin_HEXAGON_M2_mpyd_rnd_ll_s0",
                    "M2.mpyd.rnd.ll.s1" => "__builtin_HEXAGON_M2_mpyd_rnd_ll_s1",
                    "M2.mpyi" => "__builtin_HEXAGON_M2_mpyi",
                    "M2.mpysmi" => "__builtin_HEXAGON_M2_mpysmi",
                    "M2.mpysu.up" => "__builtin_HEXAGON_M2_mpysu_up",
                    "M2.mpyu.acc.hh.s0" => "__builtin_HEXAGON_M2_mpyu_acc_hh_s0",
                    "M2.mpyu.acc.hh.s1" => "__builtin_HEXAGON_M2_mpyu_acc_hh_s1",
                    "M2.mpyu.acc.hl.s0" => "__builtin_HEXAGON_M2_mpyu_acc_hl_s0",
                    "M2.mpyu.acc.hl.s1" => "__builtin_HEXAGON_M2_mpyu_acc_hl_s1",
                    "M2.mpyu.acc.lh.s0" => "__builtin_HEXAGON_M2_mpyu_acc_lh_s0",
                    "M2.mpyu.acc.lh.s1" => "__builtin_HEXAGON_M2_mpyu_acc_lh_s1",
                    "M2.mpyu.acc.ll.s0" => "__builtin_HEXAGON_M2_mpyu_acc_ll_s0",
                    "M2.mpyu.acc.ll.s1" => "__builtin_HEXAGON_M2_mpyu_acc_ll_s1",
                    "M2.mpyu.hh.s0" => "__builtin_HEXAGON_M2_mpyu_hh_s0",
                    "M2.mpyu.hh.s1" => "__builtin_HEXAGON_M2_mpyu_hh_s1",
                    "M2.mpyu.hl.s0" => "__builtin_HEXAGON_M2_mpyu_hl_s0",
                    "M2.mpyu.hl.s1" => "__builtin_HEXAGON_M2_mpyu_hl_s1",
                    "M2.mpyu.lh.s0" => "__builtin_HEXAGON_M2_mpyu_lh_s0",
                    "M2.mpyu.lh.s1" => "__builtin_HEXAGON_M2_mpyu_lh_s1",
                    "M2.mpyu.ll.s0" => "__builtin_HEXAGON_M2_mpyu_ll_s0",
                    "M2.mpyu.ll.s1" => "__builtin_HEXAGON_M2_mpyu_ll_s1",
                    "M2.mpyu.nac.hh.s0" => "__builtin_HEXAGON_M2_mpyu_nac_hh_s0",
                    "M2.mpyu.nac.hh.s1" => "__builtin_HEXAGON_M2_mpyu_nac_hh_s1",
                    "M2.mpyu.nac.hl.s0" => "__builtin_HEXAGON_M2_mpyu_nac_hl_s0",
                    "M2.mpyu.nac.hl.s1" => "__builtin_HEXAGON_M2_mpyu_nac_hl_s1",
                    "M2.mpyu.nac.lh.s0" => "__builtin_HEXAGON_M2_mpyu_nac_lh_s0",
                    "M2.mpyu.nac.lh.s1" => "__builtin_HEXAGON_M2_mpyu_nac_lh_s1",
                    "M2.mpyu.nac.ll.s0" => "__builtin_HEXAGON_M2_mpyu_nac_ll_s0",
                    "M2.mpyu.nac.ll.s1" => "__builtin_HEXAGON_M2_mpyu_nac_ll_s1",
                    "M2.mpyu.up" => "__builtin_HEXAGON_M2_mpyu_up",
                    "M2.mpyud.acc.hh.s0" => "__builtin_HEXAGON_M2_mpyud_acc_hh_s0",
                    "M2.mpyud.acc.hh.s1" => "__builtin_HEXAGON_M2_mpyud_acc_hh_s1",
                    "M2.mpyud.acc.hl.s0" => "__builtin_HEXAGON_M2_mpyud_acc_hl_s0",
                    "M2.mpyud.acc.hl.s1" => "__builtin_HEXAGON_M2_mpyud_acc_hl_s1",
                    "M2.mpyud.acc.lh.s0" => "__builtin_HEXAGON_M2_mpyud_acc_lh_s0",
                    "M2.mpyud.acc.lh.s1" => "__builtin_HEXAGON_M2_mpyud_acc_lh_s1",
                    "M2.mpyud.acc.ll.s0" => "__builtin_HEXAGON_M2_mpyud_acc_ll_s0",
                    "M2.mpyud.acc.ll.s1" => "__builtin_HEXAGON_M2_mpyud_acc_ll_s1",
                    "M2.mpyud.hh.s0" => "__builtin_HEXAGON_M2_mpyud_hh_s0",
                    "M2.mpyud.hh.s1" => "__builtin_HEXAGON_M2_mpyud_hh_s1",
                    "M2.mpyud.hl.s0" => "__builtin_HEXAGON_M2_mpyud_hl_s0",
                    "M2.mpyud.hl.s1" => "__builtin_HEXAGON_M2_mpyud_hl_s1",
                    "M2.mpyud.lh.s0" => "__builtin_HEXAGON_M2_mpyud_lh_s0",
                    "M2.mpyud.lh.s1" => "__builtin_HEXAGON_M2_mpyud_lh_s1",
                    "M2.mpyud.ll.s0" => "__builtin_HEXAGON_M2_mpyud_ll_s0",
                    "M2.mpyud.ll.s1" => "__builtin_HEXAGON_M2_mpyud_ll_s1",
                    "M2.mpyud.nac.hh.s0" => "__builtin_HEXAGON_M2_mpyud_nac_hh_s0",
                    "M2.mpyud.nac.hh.s1" => "__builtin_HEXAGON_M2_mpyud_nac_hh_s1",
                    "M2.mpyud.nac.hl.s0" => "__builtin_HEXAGON_M2_mpyud_nac_hl_s0",
                    "M2.mpyud.nac.hl.s1" => "__builtin_HEXAGON_M2_mpyud_nac_hl_s1",
                    "M2.mpyud.nac.lh.s0" => "__builtin_HEXAGON_M2_mpyud_nac_lh_s0",
                    "M2.mpyud.nac.lh.s1" => "__builtin_HEXAGON_M2_mpyud_nac_lh_s1",
                    "M2.mpyud.nac.ll.s0" => "__builtin_HEXAGON_M2_mpyud_nac_ll_s0",
                    "M2.mpyud.nac.ll.s1" => "__builtin_HEXAGON_M2_mpyud_nac_ll_s1",
                    "M2.mpyui" => "__builtin_HEXAGON_M2_mpyui",
                    "M2.nacci" => "__builtin_HEXAGON_M2_nacci",
                    "M2.naccii" => "__builtin_HEXAGON_M2_naccii",
                    "M2.subacc" => "__builtin_HEXAGON_M2_subacc",
                    "M2.vabsdiffh" => "__builtin_HEXAGON_M2_vabsdiffh",
                    "M2.vabsdiffw" => "__builtin_HEXAGON_M2_vabsdiffw",
                    "M2.vcmac.s0.sat.i" => "__builtin_HEXAGON_M2_vcmac_s0_sat_i",
                    "M2.vcmac.s0.sat.r" => "__builtin_HEXAGON_M2_vcmac_s0_sat_r",
                    "M2.vcmpy.s0.sat.i" => "__builtin_HEXAGON_M2_vcmpy_s0_sat_i",
                    "M2.vcmpy.s0.sat.r" => "__builtin_HEXAGON_M2_vcmpy_s0_sat_r",
                    "M2.vcmpy.s1.sat.i" => "__builtin_HEXAGON_M2_vcmpy_s1_sat_i",
                    "M2.vcmpy.s1.sat.r" => "__builtin_HEXAGON_M2_vcmpy_s1_sat_r",
                    "M2.vdmacs.s0" => "__builtin_HEXAGON_M2_vdmacs_s0",
                    "M2.vdmacs.s1" => "__builtin_HEXAGON_M2_vdmacs_s1",
                    "M2.vdmpyrs.s0" => "__builtin_HEXAGON_M2_vdmpyrs_s0",
                    "M2.vdmpyrs.s1" => "__builtin_HEXAGON_M2_vdmpyrs_s1",
                    "M2.vdmpys.s0" => "__builtin_HEXAGON_M2_vdmpys_s0",
                    "M2.vdmpys.s1" => "__builtin_HEXAGON_M2_vdmpys_s1",
                    "M2.vmac2" => "__builtin_HEXAGON_M2_vmac2",
                    "M2.vmac2es" => "__builtin_HEXAGON_M2_vmac2es",
                    "M2.vmac2es.s0" => "__builtin_HEXAGON_M2_vmac2es_s0",
                    "M2.vmac2es.s1" => "__builtin_HEXAGON_M2_vmac2es_s1",
                    "M2.vmac2s.s0" => "__builtin_HEXAGON_M2_vmac2s_s0",
                    "M2.vmac2s.s1" => "__builtin_HEXAGON_M2_vmac2s_s1",
                    "M2.vmac2su.s0" => "__builtin_HEXAGON_M2_vmac2su_s0",
                    "M2.vmac2su.s1" => "__builtin_HEXAGON_M2_vmac2su_s1",
                    "M2.vmpy2es.s0" => "__builtin_HEXAGON_M2_vmpy2es_s0",
                    "M2.vmpy2es.s1" => "__builtin_HEXAGON_M2_vmpy2es_s1",
                    "M2.vmpy2s.s0" => "__builtin_HEXAGON_M2_vmpy2s_s0",
                    "M2.vmpy2s.s0pack" => "__builtin_HEXAGON_M2_vmpy2s_s0pack",
                    "M2.vmpy2s.s1" => "__builtin_HEXAGON_M2_vmpy2s_s1",
                    "M2.vmpy2s.s1pack" => "__builtin_HEXAGON_M2_vmpy2s_s1pack",
                    "M2.vmpy2su.s0" => "__builtin_HEXAGON_M2_vmpy2su_s0",
                    "M2.vmpy2su.s1" => "__builtin_HEXAGON_M2_vmpy2su_s1",
                    "M2.vraddh" => "__builtin_HEXAGON_M2_vraddh",
                    "M2.vradduh" => "__builtin_HEXAGON_M2_vradduh",
                    "M2.vrcmaci.s0" => "__builtin_HEXAGON_M2_vrcmaci_s0",
                    "M2.vrcmaci.s0c" => "__builtin_HEXAGON_M2_vrcmaci_s0c",
                    "M2.vrcmacr.s0" => "__builtin_HEXAGON_M2_vrcmacr_s0",
                    "M2.vrcmacr.s0c" => "__builtin_HEXAGON_M2_vrcmacr_s0c",
                    "M2.vrcmpyi.s0" => "__builtin_HEXAGON_M2_vrcmpyi_s0",
                    "M2.vrcmpyi.s0c" => "__builtin_HEXAGON_M2_vrcmpyi_s0c",
                    "M2.vrcmpyr.s0" => "__builtin_HEXAGON_M2_vrcmpyr_s0",
                    "M2.vrcmpyr.s0c" => "__builtin_HEXAGON_M2_vrcmpyr_s0c",
                    "M2.vrcmpys.acc.s1" => "__builtin_HEXAGON_M2_vrcmpys_acc_s1",
                    "M2.vrcmpys.s1" => "__builtin_HEXAGON_M2_vrcmpys_s1",
                    "M2.vrcmpys.s1rp" => "__builtin_HEXAGON_M2_vrcmpys_s1rp",
                    "M2.vrmac.s0" => "__builtin_HEXAGON_M2_vrmac_s0",
                    "M2.vrmpy.s0" => "__builtin_HEXAGON_M2_vrmpy_s0",
                    "M2.xor.xacc" => "__builtin_HEXAGON_M2_xor_xacc",
                    "M4.and.and" => "__builtin_HEXAGON_M4_and_and",
                    "M4.and.andn" => "__builtin_HEXAGON_M4_and_andn",
                    "M4.and.or" => "__builtin_HEXAGON_M4_and_or",
                    "M4.and.xor" => "__builtin_HEXAGON_M4_and_xor",
                    "M4.cmpyi.wh" => "__builtin_HEXAGON_M4_cmpyi_wh",
                    "M4.cmpyi.whc" => "__builtin_HEXAGON_M4_cmpyi_whc",
                    "M4.cmpyr.wh" => "__builtin_HEXAGON_M4_cmpyr_wh",
                    "M4.cmpyr.whc" => "__builtin_HEXAGON_M4_cmpyr_whc",
                    "M4.mac.up.s1.sat" => "__builtin_HEXAGON_M4_mac_up_s1_sat",
                    "M4.mpyri.addi" => "__builtin_HEXAGON_M4_mpyri_addi",
                    "M4.mpyri.addr" => "__builtin_HEXAGON_M4_mpyri_addr",
                    "M4.mpyri.addr.u2" => "__builtin_HEXAGON_M4_mpyri_addr_u2",
                    "M4.mpyrr.addi" => "__builtin_HEXAGON_M4_mpyrr_addi",
                    "M4.mpyrr.addr" => "__builtin_HEXAGON_M4_mpyrr_addr",
                    "M4.nac.up.s1.sat" => "__builtin_HEXAGON_M4_nac_up_s1_sat",
                    "M4.or.and" => "__builtin_HEXAGON_M4_or_and",
                    "M4.or.andn" => "__builtin_HEXAGON_M4_or_andn",
                    "M4.or.or" => "__builtin_HEXAGON_M4_or_or",
                    "M4.or.xor" => "__builtin_HEXAGON_M4_or_xor",
                    "M4.pmpyw" => "__builtin_HEXAGON_M4_pmpyw",
                    "M4.pmpyw.acc" => "__builtin_HEXAGON_M4_pmpyw_acc",
                    "M4.vpmpyh" => "__builtin_HEXAGON_M4_vpmpyh",
                    "M4.vpmpyh.acc" => "__builtin_HEXAGON_M4_vpmpyh_acc",
                    "M4.vrmpyeh.acc.s0" => "__builtin_HEXAGON_M4_vrmpyeh_acc_s0",
                    "M4.vrmpyeh.acc.s1" => "__builtin_HEXAGON_M4_vrmpyeh_acc_s1",
                    "M4.vrmpyeh.s0" => "__builtin_HEXAGON_M4_vrmpyeh_s0",
                    "M4.vrmpyeh.s1" => "__builtin_HEXAGON_M4_vrmpyeh_s1",
                    "M4.vrmpyoh.acc.s0" => "__builtin_HEXAGON_M4_vrmpyoh_acc_s0",
                    "M4.vrmpyoh.acc.s1" => "__builtin_HEXAGON_M4_vrmpyoh_acc_s1",
                    "M4.vrmpyoh.s0" => "__builtin_HEXAGON_M4_vrmpyoh_s0",
                    "M4.vrmpyoh.s1" => "__builtin_HEXAGON_M4_vrmpyoh_s1",
                    "M4.xor.and" => "__builtin_HEXAGON_M4_xor_and",
                    "M4.xor.andn" => "__builtin_HEXAGON_M4_xor_andn",
                    "M4.xor.or" => "__builtin_HEXAGON_M4_xor_or",
                    "M4.xor.xacc" => "__builtin_HEXAGON_M4_xor_xacc",
                    "M5.vdmacbsu" => "__builtin_HEXAGON_M5_vdmacbsu",
                    "M5.vdmpybsu" => "__builtin_HEXAGON_M5_vdmpybsu",
                    "M5.vmacbsu" => "__builtin_HEXAGON_M5_vmacbsu",
                    "M5.vmacbuu" => "__builtin_HEXAGON_M5_vmacbuu",
                    "M5.vmpybsu" => "__builtin_HEXAGON_M5_vmpybsu",
                    "M5.vmpybuu" => "__builtin_HEXAGON_M5_vmpybuu",
                    "M5.vrmacbsu" => "__builtin_HEXAGON_M5_vrmacbsu",
                    "M5.vrmacbuu" => "__builtin_HEXAGON_M5_vrmacbuu",
                    "M5.vrmpybsu" => "__builtin_HEXAGON_M5_vrmpybsu",
                    "M5.vrmpybuu" => "__builtin_HEXAGON_M5_vrmpybuu",
                    "M6.vabsdiffb" => "__builtin_HEXAGON_M6_vabsdiffb",
                    "M6.vabsdiffub" => "__builtin_HEXAGON_M6_vabsdiffub",
                    "M7.dcmpyiw" => "__builtin_HEXAGON_M7_dcmpyiw",
                    "M7.dcmpyiw.acc" => "__builtin_HEXAGON_M7_dcmpyiw_acc",
                    "M7.dcmpyiwc" => "__builtin_HEXAGON_M7_dcmpyiwc",
                    "M7.dcmpyiwc.acc" => "__builtin_HEXAGON_M7_dcmpyiwc_acc",
                    "M7.dcmpyrw" => "__builtin_HEXAGON_M7_dcmpyrw",
                    "M7.dcmpyrw.acc" => "__builtin_HEXAGON_M7_dcmpyrw_acc",
                    "M7.dcmpyrwc" => "__builtin_HEXAGON_M7_dcmpyrwc",
                    "M7.dcmpyrwc.acc" => "__builtin_HEXAGON_M7_dcmpyrwc_acc",
                    "M7.vdmpy" => "__builtin_HEXAGON_M7_vdmpy",
                    "M7.vdmpy.acc" => "__builtin_HEXAGON_M7_vdmpy_acc",
                    "M7.wcmpyiw" => "__builtin_HEXAGON_M7_wcmpyiw",
                    "M7.wcmpyiw.rnd" => "__builtin_HEXAGON_M7_wcmpyiw_rnd",
                    "M7.wcmpyiwc" => "__builtin_HEXAGON_M7_wcmpyiwc",
                    "M7.wcmpyiwc.rnd" => "__builtin_HEXAGON_M7_wcmpyiwc_rnd",
                    "M7.wcmpyrw" => "__builtin_HEXAGON_M7_wcmpyrw",
                    "M7.wcmpyrw.rnd" => "__builtin_HEXAGON_M7_wcmpyrw_rnd",
                    "M7.wcmpyrwc" => "__builtin_HEXAGON_M7_wcmpyrwc",
                    "M7.wcmpyrwc.rnd" => "__builtin_HEXAGON_M7_wcmpyrwc_rnd",
                    "S2.addasl.rrri" => "__builtin_HEXAGON_S2_addasl_rrri",
                    "S2.asl.i.p" => "__builtin_HEXAGON_S2_asl_i_p",
                    "S2.asl.i.p.acc" => "__builtin_HEXAGON_S2_asl_i_p_acc",
                    "S2.asl.i.p.and" => "__builtin_HEXAGON_S2_asl_i_p_and",
                    "S2.asl.i.p.nac" => "__builtin_HEXAGON_S2_asl_i_p_nac",
                    "S2.asl.i.p.or" => "__builtin_HEXAGON_S2_asl_i_p_or",
                    "S2.asl.i.p.xacc" => "__builtin_HEXAGON_S2_asl_i_p_xacc",
                    "S2.asl.i.r" => "__builtin_HEXAGON_S2_asl_i_r",
                    "S2.asl.i.r.acc" => "__builtin_HEXAGON_S2_asl_i_r_acc",
                    "S2.asl.i.r.and" => "__builtin_HEXAGON_S2_asl_i_r_and",
                    "S2.asl.i.r.nac" => "__builtin_HEXAGON_S2_asl_i_r_nac",
                    "S2.asl.i.r.or" => "__builtin_HEXAGON_S2_asl_i_r_or",
                    "S2.asl.i.r.sat" => "__builtin_HEXAGON_S2_asl_i_r_sat",
                    "S2.asl.i.r.xacc" => "__builtin_HEXAGON_S2_asl_i_r_xacc",
                    "S2.asl.i.vh" => "__builtin_HEXAGON_S2_asl_i_vh",
                    "S2.asl.i.vw" => "__builtin_HEXAGON_S2_asl_i_vw",
                    "S2.asl.r.p" => "__builtin_HEXAGON_S2_asl_r_p",
                    "S2.asl.r.p.acc" => "__builtin_HEXAGON_S2_asl_r_p_acc",
                    "S2.asl.r.p.and" => "__builtin_HEXAGON_S2_asl_r_p_and",
                    "S2.asl.r.p.nac" => "__builtin_HEXAGON_S2_asl_r_p_nac",
                    "S2.asl.r.p.or" => "__builtin_HEXAGON_S2_asl_r_p_or",
                    "S2.asl.r.p.xor" => "__builtin_HEXAGON_S2_asl_r_p_xor",
                    "S2.asl.r.r" => "__builtin_HEXAGON_S2_asl_r_r",
                    "S2.asl.r.r.acc" => "__builtin_HEXAGON_S2_asl_r_r_acc",
                    "S2.asl.r.r.and" => "__builtin_HEXAGON_S2_asl_r_r_and",
                    "S2.asl.r.r.nac" => "__builtin_HEXAGON_S2_asl_r_r_nac",
                    "S2.asl.r.r.or" => "__builtin_HEXAGON_S2_asl_r_r_or",
                    "S2.asl.r.r.sat" => "__builtin_HEXAGON_S2_asl_r_r_sat",
                    "S2.asl.r.vh" => "__builtin_HEXAGON_S2_asl_r_vh",
                    "S2.asl.r.vw" => "__builtin_HEXAGON_S2_asl_r_vw",
                    "S2.asr.i.p" => "__builtin_HEXAGON_S2_asr_i_p",
                    "S2.asr.i.p.acc" => "__builtin_HEXAGON_S2_asr_i_p_acc",
                    "S2.asr.i.p.and" => "__builtin_HEXAGON_S2_asr_i_p_and",
                    "S2.asr.i.p.nac" => "__builtin_HEXAGON_S2_asr_i_p_nac",
                    "S2.asr.i.p.or" => "__builtin_HEXAGON_S2_asr_i_p_or",
                    "S2.asr.i.p.rnd" => "__builtin_HEXAGON_S2_asr_i_p_rnd",
                    "S2.asr.i.p.rnd.goodsyntax" => "__builtin_HEXAGON_S2_asr_i_p_rnd_goodsyntax",
                    "S2.asr.i.r" => "__builtin_HEXAGON_S2_asr_i_r",
                    "S2.asr.i.r.acc" => "__builtin_HEXAGON_S2_asr_i_r_acc",
                    "S2.asr.i.r.and" => "__builtin_HEXAGON_S2_asr_i_r_and",
                    "S2.asr.i.r.nac" => "__builtin_HEXAGON_S2_asr_i_r_nac",
                    "S2.asr.i.r.or" => "__builtin_HEXAGON_S2_asr_i_r_or",
                    "S2.asr.i.r.rnd" => "__builtin_HEXAGON_S2_asr_i_r_rnd",
                    "S2.asr.i.r.rnd.goodsyntax" => "__builtin_HEXAGON_S2_asr_i_r_rnd_goodsyntax",
                    "S2.asr.i.svw.trun" => "__builtin_HEXAGON_S2_asr_i_svw_trun",
                    "S2.asr.i.vh" => "__builtin_HEXAGON_S2_asr_i_vh",
                    "S2.asr.i.vw" => "__builtin_HEXAGON_S2_asr_i_vw",
                    "S2.asr.r.p" => "__builtin_HEXAGON_S2_asr_r_p",
                    "S2.asr.r.p.acc" => "__builtin_HEXAGON_S2_asr_r_p_acc",
                    "S2.asr.r.p.and" => "__builtin_HEXAGON_S2_asr_r_p_and",
                    "S2.asr.r.p.nac" => "__builtin_HEXAGON_S2_asr_r_p_nac",
                    "S2.asr.r.p.or" => "__builtin_HEXAGON_S2_asr_r_p_or",
                    "S2.asr.r.p.xor" => "__builtin_HEXAGON_S2_asr_r_p_xor",
                    "S2.asr.r.r" => "__builtin_HEXAGON_S2_asr_r_r",
                    "S2.asr.r.r.acc" => "__builtin_HEXAGON_S2_asr_r_r_acc",
                    "S2.asr.r.r.and" => "__builtin_HEXAGON_S2_asr_r_r_and",
                    "S2.asr.r.r.nac" => "__builtin_HEXAGON_S2_asr_r_r_nac",
                    "S2.asr.r.r.or" => "__builtin_HEXAGON_S2_asr_r_r_or",
                    "S2.asr.r.r.sat" => "__builtin_HEXAGON_S2_asr_r_r_sat",
                    "S2.asr.r.svw.trun" => "__builtin_HEXAGON_S2_asr_r_svw_trun",
                    "S2.asr.r.vh" => "__builtin_HEXAGON_S2_asr_r_vh",
                    "S2.asr.r.vw" => "__builtin_HEXAGON_S2_asr_r_vw",
                    "S2.brev" => "__builtin_HEXAGON_S2_brev",
                    "S2.brevp" => "__builtin_HEXAGON_S2_brevp",
                    "S2.cabacencbin" => "__builtin_HEXAGON_S2_cabacencbin",
                    "S2.cl0" => "__builtin_HEXAGON_S2_cl0",
                    "S2.cl0p" => "__builtin_HEXAGON_S2_cl0p",
                    "S2.cl1" => "__builtin_HEXAGON_S2_cl1",
                    "S2.cl1p" => "__builtin_HEXAGON_S2_cl1p",
                    "S2.clb" => "__builtin_HEXAGON_S2_clb",
                    "S2.clbnorm" => "__builtin_HEXAGON_S2_clbnorm",
                    "S2.clbp" => "__builtin_HEXAGON_S2_clbp",
                    "S2.clrbit.i" => "__builtin_HEXAGON_S2_clrbit_i",
                    "S2.clrbit.r" => "__builtin_HEXAGON_S2_clrbit_r",
                    "S2.ct0" => "__builtin_HEXAGON_S2_ct0",
                    "S2.ct0p" => "__builtin_HEXAGON_S2_ct0p",
                    "S2.ct1" => "__builtin_HEXAGON_S2_ct1",
                    "S2.ct1p" => "__builtin_HEXAGON_S2_ct1p",
                    "S2.deinterleave" => "__builtin_HEXAGON_S2_deinterleave",
                    "S2.extractu" => "__builtin_HEXAGON_S2_extractu",
                    "S2.extractu.rp" => "__builtin_HEXAGON_S2_extractu_rp",
                    "S2.extractup" => "__builtin_HEXAGON_S2_extractup",
                    "S2.extractup.rp" => "__builtin_HEXAGON_S2_extractup_rp",
                    "S2.insert" => "__builtin_HEXAGON_S2_insert",
                    "S2.insert.rp" => "__builtin_HEXAGON_S2_insert_rp",
                    "S2.insertp" => "__builtin_HEXAGON_S2_insertp",
                    "S2.insertp.rp" => "__builtin_HEXAGON_S2_insertp_rp",
                    "S2.interleave" => "__builtin_HEXAGON_S2_interleave",
                    "S2.lfsp" => "__builtin_HEXAGON_S2_lfsp",
                    "S2.lsl.r.p" => "__builtin_HEXAGON_S2_lsl_r_p",
                    "S2.lsl.r.p.acc" => "__builtin_HEXAGON_S2_lsl_r_p_acc",
                    "S2.lsl.r.p.and" => "__builtin_HEXAGON_S2_lsl_r_p_and",
                    "S2.lsl.r.p.nac" => "__builtin_HEXAGON_S2_lsl_r_p_nac",
                    "S2.lsl.r.p.or" => "__builtin_HEXAGON_S2_lsl_r_p_or",
                    "S2.lsl.r.p.xor" => "__builtin_HEXAGON_S2_lsl_r_p_xor",
                    "S2.lsl.r.r" => "__builtin_HEXAGON_S2_lsl_r_r",
                    "S2.lsl.r.r.acc" => "__builtin_HEXAGON_S2_lsl_r_r_acc",
                    "S2.lsl.r.r.and" => "__builtin_HEXAGON_S2_lsl_r_r_and",
                    "S2.lsl.r.r.nac" => "__builtin_HEXAGON_S2_lsl_r_r_nac",
                    "S2.lsl.r.r.or" => "__builtin_HEXAGON_S2_lsl_r_r_or",
                    "S2.lsl.r.vh" => "__builtin_HEXAGON_S2_lsl_r_vh",
                    "S2.lsl.r.vw" => "__builtin_HEXAGON_S2_lsl_r_vw",
                    "S2.lsr.i.p" => "__builtin_HEXAGON_S2_lsr_i_p",
                    "S2.lsr.i.p.acc" => "__builtin_HEXAGON_S2_lsr_i_p_acc",
                    "S2.lsr.i.p.and" => "__builtin_HEXAGON_S2_lsr_i_p_and",
                    "S2.lsr.i.p.nac" => "__builtin_HEXAGON_S2_lsr_i_p_nac",
                    "S2.lsr.i.p.or" => "__builtin_HEXAGON_S2_lsr_i_p_or",
                    "S2.lsr.i.p.xacc" => "__builtin_HEXAGON_S2_lsr_i_p_xacc",
                    "S2.lsr.i.r" => "__builtin_HEXAGON_S2_lsr_i_r",
                    "S2.lsr.i.r.acc" => "__builtin_HEXAGON_S2_lsr_i_r_acc",
                    "S2.lsr.i.r.and" => "__builtin_HEXAGON_S2_lsr_i_r_and",
                    "S2.lsr.i.r.nac" => "__builtin_HEXAGON_S2_lsr_i_r_nac",
                    "S2.lsr.i.r.or" => "__builtin_HEXAGON_S2_lsr_i_r_or",
                    "S2.lsr.i.r.xacc" => "__builtin_HEXAGON_S2_lsr_i_r_xacc",
                    "S2.lsr.i.vh" => "__builtin_HEXAGON_S2_lsr_i_vh",
                    "S2.lsr.i.vw" => "__builtin_HEXAGON_S2_lsr_i_vw",
                    "S2.lsr.r.p" => "__builtin_HEXAGON_S2_lsr_r_p",
                    "S2.lsr.r.p.acc" => "__builtin_HEXAGON_S2_lsr_r_p_acc",
                    "S2.lsr.r.p.and" => "__builtin_HEXAGON_S2_lsr_r_p_and",
                    "S2.lsr.r.p.nac" => "__builtin_HEXAGON_S2_lsr_r_p_nac",
                    "S2.lsr.r.p.or" => "__builtin_HEXAGON_S2_lsr_r_p_or",
                    "S2.lsr.r.p.xor" => "__builtin_HEXAGON_S2_lsr_r_p_xor",
                    "S2.lsr.r.r" => "__builtin_HEXAGON_S2_lsr_r_r",
                    "S2.lsr.r.r.acc" => "__builtin_HEXAGON_S2_lsr_r_r_acc",
                    "S2.lsr.r.r.and" => "__builtin_HEXAGON_S2_lsr_r_r_and",
                    "S2.lsr.r.r.nac" => "__builtin_HEXAGON_S2_lsr_r_r_nac",
                    "S2.lsr.r.r.or" => "__builtin_HEXAGON_S2_lsr_r_r_or",
                    "S2.lsr.r.vh" => "__builtin_HEXAGON_S2_lsr_r_vh",
                    "S2.lsr.r.vw" => "__builtin_HEXAGON_S2_lsr_r_vw",
                    "S2.mask" => "__builtin_HEXAGON_S2_mask",
                    "S2.packhl" => "__builtin_HEXAGON_S2_packhl",
                    "S2.parityp" => "__builtin_HEXAGON_S2_parityp",
                    "S2.setbit.i" => "__builtin_HEXAGON_S2_setbit_i",
                    "S2.setbit.r" => "__builtin_HEXAGON_S2_setbit_r",
                    "S2.shuffeb" => "__builtin_HEXAGON_S2_shuffeb",
                    "S2.shuffeh" => "__builtin_HEXAGON_S2_shuffeh",
                    "S2.shuffob" => "__builtin_HEXAGON_S2_shuffob",
                    "S2.shuffoh" => "__builtin_HEXAGON_S2_shuffoh",
                    "S2.storerb.pbr" => "__builtin_brev_stb",
                    "S2.storerd.pbr" => "__builtin_brev_std",
                    "S2.storerf.pbr" => "__builtin_brev_sthhi",
                    "S2.storerh.pbr" => "__builtin_brev_sth",
                    "S2.storeri.pbr" => "__builtin_brev_stw",
                    "S2.storew.locked" => "__builtin_HEXAGON_S2_storew_locked",
                    "S2.svsathb" => "__builtin_HEXAGON_S2_svsathb",
                    "S2.svsathub" => "__builtin_HEXAGON_S2_svsathub",
                    "S2.tableidxb.goodsyntax" => "__builtin_HEXAGON_S2_tableidxb_goodsyntax",
                    "S2.tableidxd.goodsyntax" => "__builtin_HEXAGON_S2_tableidxd_goodsyntax",
                    "S2.tableidxh.goodsyntax" => "__builtin_HEXAGON_S2_tableidxh_goodsyntax",
                    "S2.tableidxw.goodsyntax" => "__builtin_HEXAGON_S2_tableidxw_goodsyntax",
                    "S2.togglebit.i" => "__builtin_HEXAGON_S2_togglebit_i",
                    "S2.togglebit.r" => "__builtin_HEXAGON_S2_togglebit_r",
                    "S2.tstbit.i" => "__builtin_HEXAGON_S2_tstbit_i",
                    "S2.tstbit.r" => "__builtin_HEXAGON_S2_tstbit_r",
                    "S2.valignib" => "__builtin_HEXAGON_S2_valignib",
                    "S2.valignrb" => "__builtin_HEXAGON_S2_valignrb",
                    "S2.vcnegh" => "__builtin_HEXAGON_S2_vcnegh",
                    "S2.vcrotate" => "__builtin_HEXAGON_S2_vcrotate",
                    "S2.vrcnegh" => "__builtin_HEXAGON_S2_vrcnegh",
                    "S2.vrndpackwh" => "__builtin_HEXAGON_S2_vrndpackwh",
                    "S2.vrndpackwhs" => "__builtin_HEXAGON_S2_vrndpackwhs",
                    "S2.vsathb" => "__builtin_HEXAGON_S2_vsathb",
                    "S2.vsathb.nopack" => "__builtin_HEXAGON_S2_vsathb_nopack",
                    "S2.vsathub" => "__builtin_HEXAGON_S2_vsathub",
                    "S2.vsathub.nopack" => "__builtin_HEXAGON_S2_vsathub_nopack",
                    "S2.vsatwh" => "__builtin_HEXAGON_S2_vsatwh",
                    "S2.vsatwh.nopack" => "__builtin_HEXAGON_S2_vsatwh_nopack",
                    "S2.vsatwuh" => "__builtin_HEXAGON_S2_vsatwuh",
                    "S2.vsatwuh.nopack" => "__builtin_HEXAGON_S2_vsatwuh_nopack",
                    "S2.vsplatrb" => "__builtin_HEXAGON_S2_vsplatrb",
                    "S2.vsplatrh" => "__builtin_HEXAGON_S2_vsplatrh",
                    "S2.vspliceib" => "__builtin_HEXAGON_S2_vspliceib",
                    "S2.vsplicerb" => "__builtin_HEXAGON_S2_vsplicerb",
                    "S2.vsxtbh" => "__builtin_HEXAGON_S2_vsxtbh",
                    "S2.vsxthw" => "__builtin_HEXAGON_S2_vsxthw",
                    "S2.vtrunehb" => "__builtin_HEXAGON_S2_vtrunehb",
                    "S2.vtrunewh" => "__builtin_HEXAGON_S2_vtrunewh",
                    "S2.vtrunohb" => "__builtin_HEXAGON_S2_vtrunohb",
                    "S2.vtrunowh" => "__builtin_HEXAGON_S2_vtrunowh",
                    "S2.vzxtbh" => "__builtin_HEXAGON_S2_vzxtbh",
                    "S2.vzxthw" => "__builtin_HEXAGON_S2_vzxthw",
                    "S4.addaddi" => "__builtin_HEXAGON_S4_addaddi",
                    "S4.addi.asl.ri" => "__builtin_HEXAGON_S4_addi_asl_ri",
                    "S4.addi.lsr.ri" => "__builtin_HEXAGON_S4_addi_lsr_ri",
                    "S4.andi.asl.ri" => "__builtin_HEXAGON_S4_andi_asl_ri",
                    "S4.andi.lsr.ri" => "__builtin_HEXAGON_S4_andi_lsr_ri",
                    "S4.clbaddi" => "__builtin_HEXAGON_S4_clbaddi",
                    "S4.clbpaddi" => "__builtin_HEXAGON_S4_clbpaddi",
                    "S4.clbpnorm" => "__builtin_HEXAGON_S4_clbpnorm",
                    "S4.extract" => "__builtin_HEXAGON_S4_extract",
                    "S4.extract.rp" => "__builtin_HEXAGON_S4_extract_rp",
                    "S4.extractp" => "__builtin_HEXAGON_S4_extractp",
                    "S4.extractp.rp" => "__builtin_HEXAGON_S4_extractp_rp",
                    "S4.lsli" => "__builtin_HEXAGON_S4_lsli",
                    "S4.ntstbit.i" => "__builtin_HEXAGON_S4_ntstbit_i",
                    "S4.ntstbit.r" => "__builtin_HEXAGON_S4_ntstbit_r",
                    "S4.or.andi" => "__builtin_HEXAGON_S4_or_andi",
                    "S4.or.andix" => "__builtin_HEXAGON_S4_or_andix",
                    "S4.or.ori" => "__builtin_HEXAGON_S4_or_ori",
                    "S4.ori.asl.ri" => "__builtin_HEXAGON_S4_ori_asl_ri",
                    "S4.ori.lsr.ri" => "__builtin_HEXAGON_S4_ori_lsr_ri",
                    "S4.parity" => "__builtin_HEXAGON_S4_parity",
                    "S4.stored.locked" => "__builtin_HEXAGON_S4_stored_locked",
                    "S4.subaddi" => "__builtin_HEXAGON_S4_subaddi",
                    "S4.subi.asl.ri" => "__builtin_HEXAGON_S4_subi_asl_ri",
                    "S4.subi.lsr.ri" => "__builtin_HEXAGON_S4_subi_lsr_ri",
                    "S4.vrcrotate" => "__builtin_HEXAGON_S4_vrcrotate",
                    "S4.vrcrotate.acc" => "__builtin_HEXAGON_S4_vrcrotate_acc",
                    "S4.vxaddsubh" => "__builtin_HEXAGON_S4_vxaddsubh",
                    "S4.vxaddsubhr" => "__builtin_HEXAGON_S4_vxaddsubhr",
                    "S4.vxaddsubw" => "__builtin_HEXAGON_S4_vxaddsubw",
                    "S4.vxsubaddh" => "__builtin_HEXAGON_S4_vxsubaddh",
                    "S4.vxsubaddhr" => "__builtin_HEXAGON_S4_vxsubaddhr",
                    "S4.vxsubaddw" => "__builtin_HEXAGON_S4_vxsubaddw",
                    "S5.asrhub.rnd.sat.goodsyntax" => {
                        "__builtin_HEXAGON_S5_asrhub_rnd_sat_goodsyntax"
                    }
                    "S5.asrhub.sat" => "__builtin_HEXAGON_S5_asrhub_sat",
                    "S5.popcountp" => "__builtin_HEXAGON_S5_popcountp",
                    "S5.vasrhrnd.goodsyntax" => "__builtin_HEXAGON_S5_vasrhrnd_goodsyntax",
                    "S6.rol.i.p" => "__builtin_HEXAGON_S6_rol_i_p",
                    "S6.rol.i.p.acc" => "__builtin_HEXAGON_S6_rol_i_p_acc",
                    "S6.rol.i.p.and" => "__builtin_HEXAGON_S6_rol_i_p_and",
                    "S6.rol.i.p.nac" => "__builtin_HEXAGON_S6_rol_i_p_nac",
                    "S6.rol.i.p.or" => "__builtin_HEXAGON_S6_rol_i_p_or",
                    "S6.rol.i.p.xacc" => "__builtin_HEXAGON_S6_rol_i_p_xacc",
                    "S6.rol.i.r" => "__builtin_HEXAGON_S6_rol_i_r",
                    "S6.rol.i.r.acc" => "__builtin_HEXAGON_S6_rol_i_r_acc",
                    "S6.rol.i.r.and" => "__builtin_HEXAGON_S6_rol_i_r_and",
                    "S6.rol.i.r.nac" => "__builtin_HEXAGON_S6_rol_i_r_nac",
                    "S6.rol.i.r.or" => "__builtin_HEXAGON_S6_rol_i_r_or",
                    "S6.rol.i.r.xacc" => "__builtin_HEXAGON_S6_rol_i_r_xacc",
                    "S6.vsplatrbp" => "__builtin_HEXAGON_S6_vsplatrbp",
                    "S6.vtrunehb.ppp" => "__builtin_HEXAGON_S6_vtrunehb_ppp",
                    "S6.vtrunohb.ppp" => "__builtin_HEXAGON_S6_vtrunohb_ppp",
                    "SI.to.SXTHI.asrh" => "__builtin_SI_to_SXTHI_asrh",
                    "V6.extractw" => "__builtin_HEXAGON_V6_extractw",
                    "V6.extractw.128B" => "__builtin_HEXAGON_V6_extractw_128B",
                    "V6.get.qfext" => "__builtin_HEXAGON_V6_get_qfext",
                    "V6.get.qfext.128B" => "__builtin_HEXAGON_V6_get_qfext_128B",
                    "V6.get.qfext.oracc" => "__builtin_HEXAGON_V6_get_qfext_oracc",
                    "V6.get.qfext.oracc.128B" => "__builtin_HEXAGON_V6_get_qfext_oracc_128B",
                    "V6.hi" => "__builtin_HEXAGON_V6_hi",
                    "V6.hi.128B" => "__builtin_HEXAGON_V6_hi_128B",
                    "V6.lo" => "__builtin_HEXAGON_V6_lo",
                    "V6.lo.128B" => "__builtin_HEXAGON_V6_lo_128B",
                    "V6.lvsplatb" => "__builtin_HEXAGON_V6_lvsplatb",
                    "V6.lvsplatb.128B" => "__builtin_HEXAGON_V6_lvsplatb_128B",
                    "V6.lvsplath" => "__builtin_HEXAGON_V6_lvsplath",
                    "V6.lvsplath.128B" => "__builtin_HEXAGON_V6_lvsplath_128B",
                    "V6.lvsplatw" => "__builtin_HEXAGON_V6_lvsplatw",
                    "V6.lvsplatw.128B" => "__builtin_HEXAGON_V6_lvsplatw_128B",
                    "V6.pred.and" => "__builtin_HEXAGON_V6_pred_and",
                    "V6.pred.and.128B" => "__builtin_HEXAGON_V6_pred_and_128B",
                    "V6.pred.and.n" => "__builtin_HEXAGON_V6_pred_and_n",
                    "V6.pred.and.n.128B" => "__builtin_HEXAGON_V6_pred_and_n_128B",
                    "V6.pred.not" => "__builtin_HEXAGON_V6_pred_not",
                    "V6.pred.not.128B" => "__builtin_HEXAGON_V6_pred_not_128B",
                    "V6.pred.or" => "__builtin_HEXAGON_V6_pred_or",
                    "V6.pred.or.128B" => "__builtin_HEXAGON_V6_pred_or_128B",
                    "V6.pred.or.n" => "__builtin_HEXAGON_V6_pred_or_n",
                    "V6.pred.or.n.128B" => "__builtin_HEXAGON_V6_pred_or_n_128B",
                    "V6.pred.scalar2" => "__builtin_HEXAGON_V6_pred_scalar2",
                    "V6.pred.scalar2.128B" => "__builtin_HEXAGON_V6_pred_scalar2_128B",
                    "V6.pred.scalar2v2" => "__builtin_HEXAGON_V6_pred_scalar2v2",
                    "V6.pred.scalar2v2.128B" => "__builtin_HEXAGON_V6_pred_scalar2v2_128B",
                    "V6.pred.xor" => "__builtin_HEXAGON_V6_pred_xor",
                    "V6.pred.xor.128B" => "__builtin_HEXAGON_V6_pred_xor_128B",
                    "V6.set.qfext" => "__builtin_HEXAGON_V6_set_qfext",
                    "V6.set.qfext.128B" => "__builtin_HEXAGON_V6_set_qfext_128B",
                    "V6.shuffeqh" => "__builtin_HEXAGON_V6_shuffeqh",
                    "V6.shuffeqh.128B" => "__builtin_HEXAGON_V6_shuffeqh_128B",
                    "V6.shuffeqw" => "__builtin_HEXAGON_V6_shuffeqw",
                    "V6.shuffeqw.128B" => "__builtin_HEXAGON_V6_shuffeqw_128B",
                    "V6.v6mpyhubs10" => "__builtin_HEXAGON_V6_v6mpyhubs10",
                    "V6.v6mpyhubs10.128B" => "__builtin_HEXAGON_V6_v6mpyhubs10_128B",
                    "V6.v6mpyhubs10.vxx" => "__builtin_HEXAGON_V6_v6mpyhubs10_vxx",
                    "V6.v6mpyhubs10.vxx.128B" => "__builtin_HEXAGON_V6_v6mpyhubs10_vxx_128B",
                    "V6.v6mpyvubs10" => "__builtin_HEXAGON_V6_v6mpyvubs10",
                    "V6.v6mpyvubs10.128B" => "__builtin_HEXAGON_V6_v6mpyvubs10_128B",
                    "V6.v6mpyvubs10.vxx" => "__builtin_HEXAGON_V6_v6mpyvubs10_vxx",
                    "V6.v6mpyvubs10.vxx.128B" => "__builtin_HEXAGON_V6_v6mpyvubs10_vxx_128B",
                    "V6.vS32b.nqpred.ai" => "__builtin_HEXAGON_V6_vS32b_nqpred_ai",
                    "V6.vS32b.nqpred.ai.128B" => "__builtin_HEXAGON_V6_vS32b_nqpred_ai_128B",
                    "V6.vS32b.nt.nqpred.ai" => "__builtin_HEXAGON_V6_vS32b_nt_nqpred_ai",
                    "V6.vS32b.nt.nqpred.ai.128B" => "__builtin_HEXAGON_V6_vS32b_nt_nqpred_ai_128B",
                    "V6.vS32b.nt.qpred.ai" => "__builtin_HEXAGON_V6_vS32b_nt_qpred_ai",
                    "V6.vS32b.nt.qpred.ai.128B" => "__builtin_HEXAGON_V6_vS32b_nt_qpred_ai_128B",
                    "V6.vS32b.qpred.ai" => "__builtin_HEXAGON_V6_vS32b_qpred_ai",
                    "V6.vS32b.qpred.ai.128B" => "__builtin_HEXAGON_V6_vS32b_qpred_ai_128B",
                    "V6.vabs.f8" => "__builtin_HEXAGON_V6_vabs_f8",
                    "V6.vabs.f8.128B" => "__builtin_HEXAGON_V6_vabs_f8_128B",
                    "V6.vabs.hf" => "__builtin_HEXAGON_V6_vabs_hf",
                    "V6.vabs.hf.128B" => "__builtin_HEXAGON_V6_vabs_hf_128B",
                    "V6.vabs.qf16.hf" => "__builtin_HEXAGON_V6_vabs_qf16_hf",
                    "V6.vabs.qf16.hf.128B" => "__builtin_HEXAGON_V6_vabs_qf16_hf_128B",
                    "V6.vabs.qf16.qf16" => "__builtin_HEXAGON_V6_vabs_qf16_qf16",
                    "V6.vabs.qf16.qf16.128B" => "__builtin_HEXAGON_V6_vabs_qf16_qf16_128B",
                    "V6.vabs.qf32.qf32" => "__builtin_HEXAGON_V6_vabs_qf32_qf32",
                    "V6.vabs.qf32.qf32.128B" => "__builtin_HEXAGON_V6_vabs_qf32_qf32_128B",
                    "V6.vabs.qf32.sf" => "__builtin_HEXAGON_V6_vabs_qf32_sf",
                    "V6.vabs.qf32.sf.128B" => "__builtin_HEXAGON_V6_vabs_qf32_sf_128B",
                    "V6.vabs.sf" => "__builtin_HEXAGON_V6_vabs_sf",
                    "V6.vabs.sf.128B" => "__builtin_HEXAGON_V6_vabs_sf_128B",
                    "V6.vabsb" => "__builtin_HEXAGON_V6_vabsb",
                    "V6.vabsb.128B" => "__builtin_HEXAGON_V6_vabsb_128B",
                    "V6.vabsb.sat" => "__builtin_HEXAGON_V6_vabsb_sat",
                    "V6.vabsb.sat.128B" => "__builtin_HEXAGON_V6_vabsb_sat_128B",
                    "V6.vabsdiffh" => "__builtin_HEXAGON_V6_vabsdiffh",
                    "V6.vabsdiffh.128B" => "__builtin_HEXAGON_V6_vabsdiffh_128B",
                    "V6.vabsdiffub" => "__builtin_HEXAGON_V6_vabsdiffub",
                    "V6.vabsdiffub.128B" => "__builtin_HEXAGON_V6_vabsdiffub_128B",
                    "V6.vabsdiffuh" => "__builtin_HEXAGON_V6_vabsdiffuh",
                    "V6.vabsdiffuh.128B" => "__builtin_HEXAGON_V6_vabsdiffuh_128B",
                    "V6.vabsdiffw" => "__builtin_HEXAGON_V6_vabsdiffw",
                    "V6.vabsdiffw.128B" => "__builtin_HEXAGON_V6_vabsdiffw_128B",
                    "V6.vabsh" => "__builtin_HEXAGON_V6_vabsh",
                    "V6.vabsh.128B" => "__builtin_HEXAGON_V6_vabsh_128B",
                    "V6.vabsh.sat" => "__builtin_HEXAGON_V6_vabsh_sat",
                    "V6.vabsh.sat.128B" => "__builtin_HEXAGON_V6_vabsh_sat_128B",
                    "V6.vabsw" => "__builtin_HEXAGON_V6_vabsw",
                    "V6.vabsw.128B" => "__builtin_HEXAGON_V6_vabsw_128B",
                    "V6.vabsw.sat" => "__builtin_HEXAGON_V6_vabsw_sat",
                    "V6.vabsw.sat.128B" => "__builtin_HEXAGON_V6_vabsw_sat_128B",
                    "V6.vadd.hf" => "__builtin_HEXAGON_V6_vadd_hf",
                    "V6.vadd.hf.128B" => "__builtin_HEXAGON_V6_vadd_hf_128B",
                    "V6.vadd.hf.f8" => "__builtin_HEXAGON_V6_vadd_hf_f8",
                    "V6.vadd.hf.f8.128B" => "__builtin_HEXAGON_V6_vadd_hf_f8_128B",
                    "V6.vadd.hf.hf" => "__builtin_HEXAGON_V6_vadd_hf_hf",
                    "V6.vadd.hf.hf.128B" => "__builtin_HEXAGON_V6_vadd_hf_hf_128B",
                    "V6.vadd.qf16" => "__builtin_HEXAGON_V6_vadd_qf16",
                    "V6.vadd.qf16.128B" => "__builtin_HEXAGON_V6_vadd_qf16_128B",
                    "V6.vadd.qf16.mix" => "__builtin_HEXAGON_V6_vadd_qf16_mix",
                    "V6.vadd.qf16.mix.128B" => "__builtin_HEXAGON_V6_vadd_qf16_mix_128B",
                    "V6.vadd.qf32" => "__builtin_HEXAGON_V6_vadd_qf32",
                    "V6.vadd.qf32.128B" => "__builtin_HEXAGON_V6_vadd_qf32_128B",
                    "V6.vadd.qf32.mix" => "__builtin_HEXAGON_V6_vadd_qf32_mix",
                    "V6.vadd.qf32.mix.128B" => "__builtin_HEXAGON_V6_vadd_qf32_mix_128B",
                    "V6.vadd.sf" => "__builtin_HEXAGON_V6_vadd_sf",
                    "V6.vadd.sf.128B" => "__builtin_HEXAGON_V6_vadd_sf_128B",
                    "V6.vadd.sf.bf" => "__builtin_HEXAGON_V6_vadd_sf_bf",
                    "V6.vadd.sf.bf.128B" => "__builtin_HEXAGON_V6_vadd_sf_bf_128B",
                    "V6.vadd.sf.hf" => "__builtin_HEXAGON_V6_vadd_sf_hf",
                    "V6.vadd.sf.hf.128B" => "__builtin_HEXAGON_V6_vadd_sf_hf_128B",
                    "V6.vadd.sf.sf" => "__builtin_HEXAGON_V6_vadd_sf_sf",
                    "V6.vadd.sf.sf.128B" => "__builtin_HEXAGON_V6_vadd_sf_sf_128B",
                    "V6.vaddb" => "__builtin_HEXAGON_V6_vaddb",
                    "V6.vaddb.128B" => "__builtin_HEXAGON_V6_vaddb_128B",
                    "V6.vaddb.dv" => "__builtin_HEXAGON_V6_vaddb_dv",
                    "V6.vaddb.dv.128B" => "__builtin_HEXAGON_V6_vaddb_dv_128B",
                    "V6.vaddbnq" => "__builtin_HEXAGON_V6_vaddbnq",
                    "V6.vaddbnq.128B" => "__builtin_HEXAGON_V6_vaddbnq_128B",
                    "V6.vaddbq" => "__builtin_HEXAGON_V6_vaddbq",
                    "V6.vaddbq.128B" => "__builtin_HEXAGON_V6_vaddbq_128B",
                    "V6.vaddbsat" => "__builtin_HEXAGON_V6_vaddbsat",
                    "V6.vaddbsat.128B" => "__builtin_HEXAGON_V6_vaddbsat_128B",
                    "V6.vaddbsat.dv" => "__builtin_HEXAGON_V6_vaddbsat_dv",
                    "V6.vaddbsat.dv.128B" => "__builtin_HEXAGON_V6_vaddbsat_dv_128B",
                    "V6.vaddcarrysat" => "__builtin_HEXAGON_V6_vaddcarrysat",
                    "V6.vaddcarrysat.128B" => "__builtin_HEXAGON_V6_vaddcarrysat_128B",
                    "V6.vaddclbh" => "__builtin_HEXAGON_V6_vaddclbh",
                    "V6.vaddclbh.128B" => "__builtin_HEXAGON_V6_vaddclbh_128B",
                    "V6.vaddclbw" => "__builtin_HEXAGON_V6_vaddclbw",
                    "V6.vaddclbw.128B" => "__builtin_HEXAGON_V6_vaddclbw_128B",
                    "V6.vaddh" => "__builtin_HEXAGON_V6_vaddh",
                    "V6.vaddh.128B" => "__builtin_HEXAGON_V6_vaddh_128B",
                    "V6.vaddh.dv" => "__builtin_HEXAGON_V6_vaddh_dv",
                    "V6.vaddh.dv.128B" => "__builtin_HEXAGON_V6_vaddh_dv_128B",
                    "V6.vaddhnq" => "__builtin_HEXAGON_V6_vaddhnq",
                    "V6.vaddhnq.128B" => "__builtin_HEXAGON_V6_vaddhnq_128B",
                    "V6.vaddhq" => "__builtin_HEXAGON_V6_vaddhq",
                    "V6.vaddhq.128B" => "__builtin_HEXAGON_V6_vaddhq_128B",
                    "V6.vaddhsat" => "__builtin_HEXAGON_V6_vaddhsat",
                    "V6.vaddhsat.128B" => "__builtin_HEXAGON_V6_vaddhsat_128B",
                    "V6.vaddhsat.dv" => "__builtin_HEXAGON_V6_vaddhsat_dv",
                    "V6.vaddhsat.dv.128B" => "__builtin_HEXAGON_V6_vaddhsat_dv_128B",
                    "V6.vaddhw" => "__builtin_HEXAGON_V6_vaddhw",
                    "V6.vaddhw.128B" => "__builtin_HEXAGON_V6_vaddhw_128B",
                    "V6.vaddhw.acc" => "__builtin_HEXAGON_V6_vaddhw_acc",
                    "V6.vaddhw.acc.128B" => "__builtin_HEXAGON_V6_vaddhw_acc_128B",
                    "V6.vaddubh" => "__builtin_HEXAGON_V6_vaddubh",
                    "V6.vaddubh.128B" => "__builtin_HEXAGON_V6_vaddubh_128B",
                    "V6.vaddubh.acc" => "__builtin_HEXAGON_V6_vaddubh_acc",
                    "V6.vaddubh.acc.128B" => "__builtin_HEXAGON_V6_vaddubh_acc_128B",
                    "V6.vaddubsat" => "__builtin_HEXAGON_V6_vaddubsat",
                    "V6.vaddubsat.128B" => "__builtin_HEXAGON_V6_vaddubsat_128B",
                    "V6.vaddubsat.dv" => "__builtin_HEXAGON_V6_vaddubsat_dv",
                    "V6.vaddubsat.dv.128B" => "__builtin_HEXAGON_V6_vaddubsat_dv_128B",
                    "V6.vaddububb.sat" => "__builtin_HEXAGON_V6_vaddububb_sat",
                    "V6.vaddububb.sat.128B" => "__builtin_HEXAGON_V6_vaddububb_sat_128B",
                    "V6.vadduhsat" => "__builtin_HEXAGON_V6_vadduhsat",
                    "V6.vadduhsat.128B" => "__builtin_HEXAGON_V6_vadduhsat_128B",
                    "V6.vadduhsat.dv" => "__builtin_HEXAGON_V6_vadduhsat_dv",
                    "V6.vadduhsat.dv.128B" => "__builtin_HEXAGON_V6_vadduhsat_dv_128B",
                    "V6.vadduhw" => "__builtin_HEXAGON_V6_vadduhw",
                    "V6.vadduhw.128B" => "__builtin_HEXAGON_V6_vadduhw_128B",
                    "V6.vadduhw.acc" => "__builtin_HEXAGON_V6_vadduhw_acc",
                    "V6.vadduhw.acc.128B" => "__builtin_HEXAGON_V6_vadduhw_acc_128B",
                    "V6.vadduwsat" => "__builtin_HEXAGON_V6_vadduwsat",
                    "V6.vadduwsat.128B" => "__builtin_HEXAGON_V6_vadduwsat_128B",
                    "V6.vadduwsat.dv" => "__builtin_HEXAGON_V6_vadduwsat_dv",
                    "V6.vadduwsat.dv.128B" => "__builtin_HEXAGON_V6_vadduwsat_dv_128B",
                    "V6.vaddw" => "__builtin_HEXAGON_V6_vaddw",
                    "V6.vaddw.128B" => "__builtin_HEXAGON_V6_vaddw_128B",
                    "V6.vaddw.dv" => "__builtin_HEXAGON_V6_vaddw_dv",
                    "V6.vaddw.dv.128B" => "__builtin_HEXAGON_V6_vaddw_dv_128B",
                    "V6.vaddwnq" => "__builtin_HEXAGON_V6_vaddwnq",
                    "V6.vaddwnq.128B" => "__builtin_HEXAGON_V6_vaddwnq_128B",
                    "V6.vaddwq" => "__builtin_HEXAGON_V6_vaddwq",
                    "V6.vaddwq.128B" => "__builtin_HEXAGON_V6_vaddwq_128B",
                    "V6.vaddwsat" => "__builtin_HEXAGON_V6_vaddwsat",
                    "V6.vaddwsat.128B" => "__builtin_HEXAGON_V6_vaddwsat_128B",
                    "V6.vaddwsat.dv" => "__builtin_HEXAGON_V6_vaddwsat_dv",
                    "V6.vaddwsat.dv.128B" => "__builtin_HEXAGON_V6_vaddwsat_dv_128B",
                    "V6.valign4" => "__builtin_HEXAGON_V6_valign4",
                    "V6.valign4.128B" => "__builtin_HEXAGON_V6_valign4_128B",
                    "V6.valignb" => "__builtin_HEXAGON_V6_valignb",
                    "V6.valignb.128B" => "__builtin_HEXAGON_V6_valignb_128B",
                    "V6.valignbi" => "__builtin_HEXAGON_V6_valignbi",
                    "V6.valignbi.128B" => "__builtin_HEXAGON_V6_valignbi_128B",
                    "V6.vand" => "__builtin_HEXAGON_V6_vand",
                    "V6.vand.128B" => "__builtin_HEXAGON_V6_vand_128B",
                    "V6.vandnqrt" => "__builtin_HEXAGON_V6_vandnqrt",
                    "V6.vandnqrt.128B" => "__builtin_HEXAGON_V6_vandnqrt_128B",
                    "V6.vandnqrt.acc" => "__builtin_HEXAGON_V6_vandnqrt_acc",
                    "V6.vandnqrt.acc.128B" => "__builtin_HEXAGON_V6_vandnqrt_acc_128B",
                    "V6.vandqrt" => "__builtin_HEXAGON_V6_vandqrt",
                    "V6.vandqrt.128B" => "__builtin_HEXAGON_V6_vandqrt_128B",
                    "V6.vandqrt.acc" => "__builtin_HEXAGON_V6_vandqrt_acc",
                    "V6.vandqrt.acc.128B" => "__builtin_HEXAGON_V6_vandqrt_acc_128B",
                    "V6.vandvnqv" => "__builtin_HEXAGON_V6_vandvnqv",
                    "V6.vandvnqv.128B" => "__builtin_HEXAGON_V6_vandvnqv_128B",
                    "V6.vandvqv" => "__builtin_HEXAGON_V6_vandvqv",
                    "V6.vandvqv.128B" => "__builtin_HEXAGON_V6_vandvqv_128B",
                    "V6.vandvrt" => "__builtin_HEXAGON_V6_vandvrt",
                    "V6.vandvrt.128B" => "__builtin_HEXAGON_V6_vandvrt_128B",
                    "V6.vandvrt.acc" => "__builtin_HEXAGON_V6_vandvrt_acc",
                    "V6.vandvrt.acc.128B" => "__builtin_HEXAGON_V6_vandvrt_acc_128B",
                    "V6.vaslh" => "__builtin_HEXAGON_V6_vaslh",
                    "V6.vaslh.128B" => "__builtin_HEXAGON_V6_vaslh_128B",
                    "V6.vaslh.acc" => "__builtin_HEXAGON_V6_vaslh_acc",
                    "V6.vaslh.acc.128B" => "__builtin_HEXAGON_V6_vaslh_acc_128B",
                    "V6.vaslhv" => "__builtin_HEXAGON_V6_vaslhv",
                    "V6.vaslhv.128B" => "__builtin_HEXAGON_V6_vaslhv_128B",
                    "V6.vaslw" => "__builtin_HEXAGON_V6_vaslw",
                    "V6.vaslw.128B" => "__builtin_HEXAGON_V6_vaslw_128B",
                    "V6.vaslw.acc" => "__builtin_HEXAGON_V6_vaslw_acc",
                    "V6.vaslw.acc.128B" => "__builtin_HEXAGON_V6_vaslw_acc_128B",
                    "V6.vaslwv" => "__builtin_HEXAGON_V6_vaslwv",
                    "V6.vaslwv.128B" => "__builtin_HEXAGON_V6_vaslwv_128B",
                    "V6.vasr.into" => "__builtin_HEXAGON_V6_vasr_into",
                    "V6.vasr.into.128B" => "__builtin_HEXAGON_V6_vasr_into_128B",
                    "V6.vasrh" => "__builtin_HEXAGON_V6_vasrh",
                    "V6.vasrh.128B" => "__builtin_HEXAGON_V6_vasrh_128B",
                    "V6.vasrh.acc" => "__builtin_HEXAGON_V6_vasrh_acc",
                    "V6.vasrh.acc.128B" => "__builtin_HEXAGON_V6_vasrh_acc_128B",
                    "V6.vasrhbrndsat" => "__builtin_HEXAGON_V6_vasrhbrndsat",
                    "V6.vasrhbrndsat.128B" => "__builtin_HEXAGON_V6_vasrhbrndsat_128B",
                    "V6.vasrhbsat" => "__builtin_HEXAGON_V6_vasrhbsat",
                    "V6.vasrhbsat.128B" => "__builtin_HEXAGON_V6_vasrhbsat_128B",
                    "V6.vasrhubrndsat" => "__builtin_HEXAGON_V6_vasrhubrndsat",
                    "V6.vasrhubrndsat.128B" => "__builtin_HEXAGON_V6_vasrhubrndsat_128B",
                    "V6.vasrhubsat" => "__builtin_HEXAGON_V6_vasrhubsat",
                    "V6.vasrhubsat.128B" => "__builtin_HEXAGON_V6_vasrhubsat_128B",
                    "V6.vasrhv" => "__builtin_HEXAGON_V6_vasrhv",
                    "V6.vasrhv.128B" => "__builtin_HEXAGON_V6_vasrhv_128B",
                    "V6.vasruhubrndsat" => "__builtin_HEXAGON_V6_vasruhubrndsat",
                    "V6.vasruhubrndsat.128B" => "__builtin_HEXAGON_V6_vasruhubrndsat_128B",
                    "V6.vasruhubsat" => "__builtin_HEXAGON_V6_vasruhubsat",
                    "V6.vasruhubsat.128B" => "__builtin_HEXAGON_V6_vasruhubsat_128B",
                    "V6.vasruwuhrndsat" => "__builtin_HEXAGON_V6_vasruwuhrndsat",
                    "V6.vasruwuhrndsat.128B" => "__builtin_HEXAGON_V6_vasruwuhrndsat_128B",
                    "V6.vasruwuhsat" => "__builtin_HEXAGON_V6_vasruwuhsat",
                    "V6.vasruwuhsat.128B" => "__builtin_HEXAGON_V6_vasruwuhsat_128B",
                    "V6.vasrvuhubrndsat" => "__builtin_HEXAGON_V6_vasrvuhubrndsat",
                    "V6.vasrvuhubrndsat.128B" => "__builtin_HEXAGON_V6_vasrvuhubrndsat_128B",
                    "V6.vasrvuhubsat" => "__builtin_HEXAGON_V6_vasrvuhubsat",
                    "V6.vasrvuhubsat.128B" => "__builtin_HEXAGON_V6_vasrvuhubsat_128B",
                    "V6.vasrvwuhrndsat" => "__builtin_HEXAGON_V6_vasrvwuhrndsat",
                    "V6.vasrvwuhrndsat.128B" => "__builtin_HEXAGON_V6_vasrvwuhrndsat_128B",
                    "V6.vasrvwuhsat" => "__builtin_HEXAGON_V6_vasrvwuhsat",
                    "V6.vasrvwuhsat.128B" => "__builtin_HEXAGON_V6_vasrvwuhsat_128B",
                    "V6.vasrw" => "__builtin_HEXAGON_V6_vasrw",
                    "V6.vasrw.128B" => "__builtin_HEXAGON_V6_vasrw_128B",
                    "V6.vasrw.acc" => "__builtin_HEXAGON_V6_vasrw_acc",
                    "V6.vasrw.acc.128B" => "__builtin_HEXAGON_V6_vasrw_acc_128B",
                    "V6.vasrwh" => "__builtin_HEXAGON_V6_vasrwh",
                    "V6.vasrwh.128B" => "__builtin_HEXAGON_V6_vasrwh_128B",
                    "V6.vasrwhrndsat" => "__builtin_HEXAGON_V6_vasrwhrndsat",
                    "V6.vasrwhrndsat.128B" => "__builtin_HEXAGON_V6_vasrwhrndsat_128B",
                    "V6.vasrwhsat" => "__builtin_HEXAGON_V6_vasrwhsat",
                    "V6.vasrwhsat.128B" => "__builtin_HEXAGON_V6_vasrwhsat_128B",
                    "V6.vasrwuhrndsat" => "__builtin_HEXAGON_V6_vasrwuhrndsat",
                    "V6.vasrwuhrndsat.128B" => "__builtin_HEXAGON_V6_vasrwuhrndsat_128B",
                    "V6.vasrwuhsat" => "__builtin_HEXAGON_V6_vasrwuhsat",
                    "V6.vasrwuhsat.128B" => "__builtin_HEXAGON_V6_vasrwuhsat_128B",
                    "V6.vasrwv" => "__builtin_HEXAGON_V6_vasrwv",
                    "V6.vasrwv.128B" => "__builtin_HEXAGON_V6_vasrwv_128B",
                    "V6.vassign" => "__builtin_HEXAGON_V6_vassign",
                    "V6.vassign.128B" => "__builtin_HEXAGON_V6_vassign_128B",
                    "V6.vassign.fp" => "__builtin_HEXAGON_V6_vassign_fp",
                    "V6.vassign.fp.128B" => "__builtin_HEXAGON_V6_vassign_fp_128B",
                    "V6.vassignp" => "__builtin_HEXAGON_V6_vassignp",
                    "V6.vassignp.128B" => "__builtin_HEXAGON_V6_vassignp_128B",
                    "V6.vavgb" => "__builtin_HEXAGON_V6_vavgb",
                    "V6.vavgb.128B" => "__builtin_HEXAGON_V6_vavgb_128B",
                    "V6.vavgbrnd" => "__builtin_HEXAGON_V6_vavgbrnd",
                    "V6.vavgbrnd.128B" => "__builtin_HEXAGON_V6_vavgbrnd_128B",
                    "V6.vavgh" => "__builtin_HEXAGON_V6_vavgh",
                    "V6.vavgh.128B" => "__builtin_HEXAGON_V6_vavgh_128B",
                    "V6.vavghrnd" => "__builtin_HEXAGON_V6_vavghrnd",
                    "V6.vavghrnd.128B" => "__builtin_HEXAGON_V6_vavghrnd_128B",
                    "V6.vavgub" => "__builtin_HEXAGON_V6_vavgub",
                    "V6.vavgub.128B" => "__builtin_HEXAGON_V6_vavgub_128B",
                    "V6.vavgubrnd" => "__builtin_HEXAGON_V6_vavgubrnd",
                    "V6.vavgubrnd.128B" => "__builtin_HEXAGON_V6_vavgubrnd_128B",
                    "V6.vavguh" => "__builtin_HEXAGON_V6_vavguh",
                    "V6.vavguh.128B" => "__builtin_HEXAGON_V6_vavguh_128B",
                    "V6.vavguhrnd" => "__builtin_HEXAGON_V6_vavguhrnd",
                    "V6.vavguhrnd.128B" => "__builtin_HEXAGON_V6_vavguhrnd_128B",
                    "V6.vavguw" => "__builtin_HEXAGON_V6_vavguw",
                    "V6.vavguw.128B" => "__builtin_HEXAGON_V6_vavguw_128B",
                    "V6.vavguwrnd" => "__builtin_HEXAGON_V6_vavguwrnd",
                    "V6.vavguwrnd.128B" => "__builtin_HEXAGON_V6_vavguwrnd_128B",
                    "V6.vavgw" => "__builtin_HEXAGON_V6_vavgw",
                    "V6.vavgw.128B" => "__builtin_HEXAGON_V6_vavgw_128B",
                    "V6.vavgwrnd" => "__builtin_HEXAGON_V6_vavgwrnd",
                    "V6.vavgwrnd.128B" => "__builtin_HEXAGON_V6_vavgwrnd_128B",
                    "V6.vcl0h" => "__builtin_HEXAGON_V6_vcl0h",
                    "V6.vcl0h.128B" => "__builtin_HEXAGON_V6_vcl0h_128B",
                    "V6.vcl0w" => "__builtin_HEXAGON_V6_vcl0w",
                    "V6.vcl0w.128B" => "__builtin_HEXAGON_V6_vcl0w_128B",
                    "V6.vcombine" => "__builtin_HEXAGON_V6_vcombine",
                    "V6.vcombine.128B" => "__builtin_HEXAGON_V6_vcombine_128B",
                    "V6.vconv.bf.qf32" => "__builtin_HEXAGON_V6_vconv_bf_qf32",
                    "V6.vconv.bf.qf32.128B" => "__builtin_HEXAGON_V6_vconv_bf_qf32_128B",
                    "V6.vconv.f8.qf16" => "__builtin_HEXAGON_V6_vconv_f8_qf16",
                    "V6.vconv.f8.qf16.128B" => "__builtin_HEXAGON_V6_vconv_f8_qf16_128B",
                    "V6.vconv.h.hf" => "__builtin_HEXAGON_V6_vconv_h_hf",
                    "V6.vconv.h.hf.128B" => "__builtin_HEXAGON_V6_vconv_h_hf_128B",
                    "V6.vconv.h.hf.rnd" => "__builtin_HEXAGON_V6_vconv_h_hf_rnd",
                    "V6.vconv.h.hf.rnd.128B" => "__builtin_HEXAGON_V6_vconv_h_hf_rnd_128B",
                    "V6.vconv.hf.h" => "__builtin_HEXAGON_V6_vconv_hf_h",
                    "V6.vconv.hf.h.128B" => "__builtin_HEXAGON_V6_vconv_hf_h_128B",
                    "V6.vconv.hf.qf16" => "__builtin_HEXAGON_V6_vconv_hf_qf16",
                    "V6.vconv.hf.qf16.128B" => "__builtin_HEXAGON_V6_vconv_hf_qf16_128B",
                    "V6.vconv.hf.qf32" => "__builtin_HEXAGON_V6_vconv_hf_qf32",
                    "V6.vconv.hf.qf32.128B" => "__builtin_HEXAGON_V6_vconv_hf_qf32_128B",
                    "V6.vconv.qf16.f8" => "__builtin_HEXAGON_V6_vconv_qf16_f8",
                    "V6.vconv.qf16.f8.128B" => "__builtin_HEXAGON_V6_vconv_qf16_f8_128B",
                    "V6.vconv.qf16.hf" => "__builtin_HEXAGON_V6_vconv_qf16_hf",
                    "V6.vconv.qf16.hf.128B" => "__builtin_HEXAGON_V6_vconv_qf16_hf_128B",
                    "V6.vconv.qf16.qf16" => "__builtin_HEXAGON_V6_vconv_qf16_qf16",
                    "V6.vconv.qf16.qf16.128B" => "__builtin_HEXAGON_V6_vconv_qf16_qf16_128B",
                    "V6.vconv.qf32.qf32" => "__builtin_HEXAGON_V6_vconv_qf32_qf32",
                    "V6.vconv.qf32.qf32.128B" => "__builtin_HEXAGON_V6_vconv_qf32_qf32_128B",
                    "V6.vconv.qf32.sf" => "__builtin_HEXAGON_V6_vconv_qf32_sf",
                    "V6.vconv.qf32.sf.128B" => "__builtin_HEXAGON_V6_vconv_qf32_sf_128B",
                    "V6.vconv.sf.qf32" => "__builtin_HEXAGON_V6_vconv_sf_qf32",
                    "V6.vconv.sf.qf32.128B" => "__builtin_HEXAGON_V6_vconv_sf_qf32_128B",
                    "V6.vconv.sf.w" => "__builtin_HEXAGON_V6_vconv_sf_w",
                    "V6.vconv.sf.w.128B" => "__builtin_HEXAGON_V6_vconv_sf_w_128B",
                    "V6.vconv.w.sf" => "__builtin_HEXAGON_V6_vconv_w_sf",
                    "V6.vconv.w.sf.128B" => "__builtin_HEXAGON_V6_vconv_w_sf_128B",
                    "V6.vcvt.b.hf" => "__builtin_HEXAGON_V6_vcvt_b_hf",
                    "V6.vcvt.b.hf.128B" => "__builtin_HEXAGON_V6_vcvt_b_hf_128B",
                    "V6.vcvt.bf.sf" => "__builtin_HEXAGON_V6_vcvt_bf_sf",
                    "V6.vcvt.bf.sf.128B" => "__builtin_HEXAGON_V6_vcvt_bf_sf_128B",
                    "V6.vcvt.f8.hf" => "__builtin_HEXAGON_V6_vcvt_f8_hf",
                    "V6.vcvt.f8.hf.128B" => "__builtin_HEXAGON_V6_vcvt_f8_hf_128B",
                    "V6.vcvt.h.hf" => "__builtin_HEXAGON_V6_vcvt_h_hf",
                    "V6.vcvt.h.hf.128B" => "__builtin_HEXAGON_V6_vcvt_h_hf_128B",
                    "V6.vcvt.hf.b" => "__builtin_HEXAGON_V6_vcvt_hf_b",
                    "V6.vcvt.hf.b.128B" => "__builtin_HEXAGON_V6_vcvt_hf_b_128B",
                    "V6.vcvt.hf.f8" => "__builtin_HEXAGON_V6_vcvt_hf_f8",
                    "V6.vcvt.hf.f8.128B" => "__builtin_HEXAGON_V6_vcvt_hf_f8_128B",
                    "V6.vcvt.hf.h" => "__builtin_HEXAGON_V6_vcvt_hf_h",
                    "V6.vcvt.hf.h.128B" => "__builtin_HEXAGON_V6_vcvt_hf_h_128B",
                    "V6.vcvt.hf.sf" => "__builtin_HEXAGON_V6_vcvt_hf_sf",
                    "V6.vcvt.hf.sf.128B" => "__builtin_HEXAGON_V6_vcvt_hf_sf_128B",
                    "V6.vcvt.hf.ub" => "__builtin_HEXAGON_V6_vcvt_hf_ub",
                    "V6.vcvt.hf.ub.128B" => "__builtin_HEXAGON_V6_vcvt_hf_ub_128B",
                    "V6.vcvt.hf.uh" => "__builtin_HEXAGON_V6_vcvt_hf_uh",
                    "V6.vcvt.hf.uh.128B" => "__builtin_HEXAGON_V6_vcvt_hf_uh_128B",
                    "V6.vcvt.sf.hf" => "__builtin_HEXAGON_V6_vcvt_sf_hf",
                    "V6.vcvt.sf.hf.128B" => "__builtin_HEXAGON_V6_vcvt_sf_hf_128B",
                    "V6.vcvt.ub.hf" => "__builtin_HEXAGON_V6_vcvt_ub_hf",
                    "V6.vcvt.ub.hf.128B" => "__builtin_HEXAGON_V6_vcvt_ub_hf_128B",
                    "V6.vcvt.uh.hf" => "__builtin_HEXAGON_V6_vcvt_uh_hf",
                    "V6.vcvt.uh.hf.128B" => "__builtin_HEXAGON_V6_vcvt_uh_hf_128B",
                    "V6.vcvt2.b.hf" => "__builtin_HEXAGON_V6_vcvt2_b_hf",
                    "V6.vcvt2.b.hf.128B" => "__builtin_HEXAGON_V6_vcvt2_b_hf_128B",
                    "V6.vcvt2.hf.b" => "__builtin_HEXAGON_V6_vcvt2_hf_b",
                    "V6.vcvt2.hf.b.128B" => "__builtin_HEXAGON_V6_vcvt2_hf_b_128B",
                    "V6.vcvt2.hf.ub" => "__builtin_HEXAGON_V6_vcvt2_hf_ub",
                    "V6.vcvt2.hf.ub.128B" => "__builtin_HEXAGON_V6_vcvt2_hf_ub_128B",
                    "V6.vcvt2.ub.hf" => "__builtin_HEXAGON_V6_vcvt2_ub_hf",
                    "V6.vcvt2.ub.hf.128B" => "__builtin_HEXAGON_V6_vcvt2_ub_hf_128B",
                    "V6.vd0" => "__builtin_HEXAGON_V6_vd0",
                    "V6.vd0.128B" => "__builtin_HEXAGON_V6_vd0_128B",
                    "V6.vdd0" => "__builtin_HEXAGON_V6_vdd0",
                    "V6.vdd0.128B" => "__builtin_HEXAGON_V6_vdd0_128B",
                    "V6.vdealb" => "__builtin_HEXAGON_V6_vdealb",
                    "V6.vdealb.128B" => "__builtin_HEXAGON_V6_vdealb_128B",
                    "V6.vdealb4w" => "__builtin_HEXAGON_V6_vdealb4w",
                    "V6.vdealb4w.128B" => "__builtin_HEXAGON_V6_vdealb4w_128B",
                    "V6.vdealh" => "__builtin_HEXAGON_V6_vdealh",
                    "V6.vdealh.128B" => "__builtin_HEXAGON_V6_vdealh_128B",
                    "V6.vdealvdd" => "__builtin_HEXAGON_V6_vdealvdd",
                    "V6.vdealvdd.128B" => "__builtin_HEXAGON_V6_vdealvdd_128B",
                    "V6.vdelta" => "__builtin_HEXAGON_V6_vdelta",
                    "V6.vdelta.128B" => "__builtin_HEXAGON_V6_vdelta_128B",
                    "V6.vdmpy.sf.hf" => "__builtin_HEXAGON_V6_vdmpy_sf_hf",
                    "V6.vdmpy.sf.hf.128B" => "__builtin_HEXAGON_V6_vdmpy_sf_hf_128B",
                    "V6.vdmpy.sf.hf.acc" => "__builtin_HEXAGON_V6_vdmpy_sf_hf_acc",
                    "V6.vdmpy.sf.hf.acc.128B" => "__builtin_HEXAGON_V6_vdmpy_sf_hf_acc_128B",
                    "V6.vdmpybus" => "__builtin_HEXAGON_V6_vdmpybus",
                    "V6.vdmpybus.128B" => "__builtin_HEXAGON_V6_vdmpybus_128B",
                    "V6.vdmpybus.acc" => "__builtin_HEXAGON_V6_vdmpybus_acc",
                    "V6.vdmpybus.acc.128B" => "__builtin_HEXAGON_V6_vdmpybus_acc_128B",
                    "V6.vdmpybus.dv" => "__builtin_HEXAGON_V6_vdmpybus_dv",
                    "V6.vdmpybus.dv.128B" => "__builtin_HEXAGON_V6_vdmpybus_dv_128B",
                    "V6.vdmpybus.dv.acc" => "__builtin_HEXAGON_V6_vdmpybus_dv_acc",
                    "V6.vdmpybus.dv.acc.128B" => "__builtin_HEXAGON_V6_vdmpybus_dv_acc_128B",
                    "V6.vdmpyhb" => "__builtin_HEXAGON_V6_vdmpyhb",
                    "V6.vdmpyhb.128B" => "__builtin_HEXAGON_V6_vdmpyhb_128B",
                    "V6.vdmpyhb.acc" => "__builtin_HEXAGON_V6_vdmpyhb_acc",
                    "V6.vdmpyhb.acc.128B" => "__builtin_HEXAGON_V6_vdmpyhb_acc_128B",
                    "V6.vdmpyhb.dv" => "__builtin_HEXAGON_V6_vdmpyhb_dv",
                    "V6.vdmpyhb.dv.128B" => "__builtin_HEXAGON_V6_vdmpyhb_dv_128B",
                    "V6.vdmpyhb.dv.acc" => "__builtin_HEXAGON_V6_vdmpyhb_dv_acc",
                    "V6.vdmpyhb.dv.acc.128B" => "__builtin_HEXAGON_V6_vdmpyhb_dv_acc_128B",
                    "V6.vdmpyhisat" => "__builtin_HEXAGON_V6_vdmpyhisat",
                    "V6.vdmpyhisat.128B" => "__builtin_HEXAGON_V6_vdmpyhisat_128B",
                    "V6.vdmpyhisat.acc" => "__builtin_HEXAGON_V6_vdmpyhisat_acc",
                    "V6.vdmpyhisat.acc.128B" => "__builtin_HEXAGON_V6_vdmpyhisat_acc_128B",
                    "V6.vdmpyhsat" => "__builtin_HEXAGON_V6_vdmpyhsat",
                    "V6.vdmpyhsat.128B" => "__builtin_HEXAGON_V6_vdmpyhsat_128B",
                    "V6.vdmpyhsat.acc" => "__builtin_HEXAGON_V6_vdmpyhsat_acc",
                    "V6.vdmpyhsat.acc.128B" => "__builtin_HEXAGON_V6_vdmpyhsat_acc_128B",
                    "V6.vdmpyhsuisat" => "__builtin_HEXAGON_V6_vdmpyhsuisat",
                    "V6.vdmpyhsuisat.128B" => "__builtin_HEXAGON_V6_vdmpyhsuisat_128B",
                    "V6.vdmpyhsuisat.acc" => "__builtin_HEXAGON_V6_vdmpyhsuisat_acc",
                    "V6.vdmpyhsuisat.acc.128B" => "__builtin_HEXAGON_V6_vdmpyhsuisat_acc_128B",
                    "V6.vdmpyhsusat" => "__builtin_HEXAGON_V6_vdmpyhsusat",
                    "V6.vdmpyhsusat.128B" => "__builtin_HEXAGON_V6_vdmpyhsusat_128B",
                    "V6.vdmpyhsusat.acc" => "__builtin_HEXAGON_V6_vdmpyhsusat_acc",
                    "V6.vdmpyhsusat.acc.128B" => "__builtin_HEXAGON_V6_vdmpyhsusat_acc_128B",
                    "V6.vdmpyhvsat" => "__builtin_HEXAGON_V6_vdmpyhvsat",
                    "V6.vdmpyhvsat.128B" => "__builtin_HEXAGON_V6_vdmpyhvsat_128B",
                    "V6.vdmpyhvsat.acc" => "__builtin_HEXAGON_V6_vdmpyhvsat_acc",
                    "V6.vdmpyhvsat.acc.128B" => "__builtin_HEXAGON_V6_vdmpyhvsat_acc_128B",
                    "V6.vdsaduh" => "__builtin_HEXAGON_V6_vdsaduh",
                    "V6.vdsaduh.128B" => "__builtin_HEXAGON_V6_vdsaduh_128B",
                    "V6.vdsaduh.acc" => "__builtin_HEXAGON_V6_vdsaduh_acc",
                    "V6.vdsaduh.acc.128B" => "__builtin_HEXAGON_V6_vdsaduh_acc_128B",
                    "V6.veqb" => "__builtin_HEXAGON_V6_veqb",
                    "V6.veqb.128B" => "__builtin_HEXAGON_V6_veqb_128B",
                    "V6.veqb.and" => "__builtin_HEXAGON_V6_veqb_and",
                    "V6.veqb.and.128B" => "__builtin_HEXAGON_V6_veqb_and_128B",
                    "V6.veqb.or" => "__builtin_HEXAGON_V6_veqb_or",
                    "V6.veqb.or.128B" => "__builtin_HEXAGON_V6_veqb_or_128B",
                    "V6.veqb.xor" => "__builtin_HEXAGON_V6_veqb_xor",
                    "V6.veqb.xor.128B" => "__builtin_HEXAGON_V6_veqb_xor_128B",
                    "V6.veqh" => "__builtin_HEXAGON_V6_veqh",
                    "V6.veqh.128B" => "__builtin_HEXAGON_V6_veqh_128B",
                    "V6.veqh.and" => "__builtin_HEXAGON_V6_veqh_and",
                    "V6.veqh.and.128B" => "__builtin_HEXAGON_V6_veqh_and_128B",
                    "V6.veqh.or" => "__builtin_HEXAGON_V6_veqh_or",
                    "V6.veqh.or.128B" => "__builtin_HEXAGON_V6_veqh_or_128B",
                    "V6.veqh.xor" => "__builtin_HEXAGON_V6_veqh_xor",
                    "V6.veqh.xor.128B" => "__builtin_HEXAGON_V6_veqh_xor_128B",
                    "V6.veqhf" => "__builtin_HEXAGON_V6_veqhf",
                    "V6.veqhf.128B" => "__builtin_HEXAGON_V6_veqhf_128B",
                    "V6.veqhf.and" => "__builtin_HEXAGON_V6_veqhf_and",
                    "V6.veqhf.and.128B" => "__builtin_HEXAGON_V6_veqhf_and_128B",
                    "V6.veqhf.or" => "__builtin_HEXAGON_V6_veqhf_or",
                    "V6.veqhf.or.128B" => "__builtin_HEXAGON_V6_veqhf_or_128B",
                    "V6.veqhf.xor" => "__builtin_HEXAGON_V6_veqhf_xor",
                    "V6.veqhf.xor.128B" => "__builtin_HEXAGON_V6_veqhf_xor_128B",
                    "V6.veqsf" => "__builtin_HEXAGON_V6_veqsf",
                    "V6.veqsf.128B" => "__builtin_HEXAGON_V6_veqsf_128B",
                    "V6.veqsf.and" => "__builtin_HEXAGON_V6_veqsf_and",
                    "V6.veqsf.and.128B" => "__builtin_HEXAGON_V6_veqsf_and_128B",
                    "V6.veqsf.or" => "__builtin_HEXAGON_V6_veqsf_or",
                    "V6.veqsf.or.128B" => "__builtin_HEXAGON_V6_veqsf_or_128B",
                    "V6.veqsf.xor" => "__builtin_HEXAGON_V6_veqsf_xor",
                    "V6.veqsf.xor.128B" => "__builtin_HEXAGON_V6_veqsf_xor_128B",
                    "V6.veqw" => "__builtin_HEXAGON_V6_veqw",
                    "V6.veqw.128B" => "__builtin_HEXAGON_V6_veqw_128B",
                    "V6.veqw.and" => "__builtin_HEXAGON_V6_veqw_and",
                    "V6.veqw.and.128B" => "__builtin_HEXAGON_V6_veqw_and_128B",
                    "V6.veqw.or" => "__builtin_HEXAGON_V6_veqw_or",
                    "V6.veqw.or.128B" => "__builtin_HEXAGON_V6_veqw_or_128B",
                    "V6.veqw.xor" => "__builtin_HEXAGON_V6_veqw_xor",
                    "V6.veqw.xor.128B" => "__builtin_HEXAGON_V6_veqw_xor_128B",
                    "V6.vfmax.f8" => "__builtin_HEXAGON_V6_vfmax_f8",
                    "V6.vfmax.f8.128B" => "__builtin_HEXAGON_V6_vfmax_f8_128B",
                    "V6.vfmax.hf" => "__builtin_HEXAGON_V6_vfmax_hf",
                    "V6.vfmax.hf.128B" => "__builtin_HEXAGON_V6_vfmax_hf_128B",
                    "V6.vfmax.sf" => "__builtin_HEXAGON_V6_vfmax_sf",
                    "V6.vfmax.sf.128B" => "__builtin_HEXAGON_V6_vfmax_sf_128B",
                    "V6.vfmin.f8" => "__builtin_HEXAGON_V6_vfmin_f8",
                    "V6.vfmin.f8.128B" => "__builtin_HEXAGON_V6_vfmin_f8_128B",
                    "V6.vfmin.hf" => "__builtin_HEXAGON_V6_vfmin_hf",
                    "V6.vfmin.hf.128B" => "__builtin_HEXAGON_V6_vfmin_hf_128B",
                    "V6.vfmin.sf" => "__builtin_HEXAGON_V6_vfmin_sf",
                    "V6.vfmin.sf.128B" => "__builtin_HEXAGON_V6_vfmin_sf_128B",
                    "V6.vfneg.f8" => "__builtin_HEXAGON_V6_vfneg_f8",
                    "V6.vfneg.f8.128B" => "__builtin_HEXAGON_V6_vfneg_f8_128B",
                    "V6.vfneg.hf" => "__builtin_HEXAGON_V6_vfneg_hf",
                    "V6.vfneg.hf.128B" => "__builtin_HEXAGON_V6_vfneg_hf_128B",
                    "V6.vfneg.sf" => "__builtin_HEXAGON_V6_vfneg_sf",
                    "V6.vfneg.sf.128B" => "__builtin_HEXAGON_V6_vfneg_sf_128B",
                    "V6.vgather.vscattermh" => "__builtin_HEXAGON_V6_vgather_vscattermh",
                    "V6.vgather.vscattermh.128B" => "__builtin_HEXAGON_V6_vgather_vscattermh_128B",
                    "V6.vgathermh" => "__builtin_HEXAGON_V6_vgathermh",
                    "V6.vgathermh.128B" => "__builtin_HEXAGON_V6_vgathermh_128B",
                    "V6.vgathermhq" => "__builtin_HEXAGON_V6_vgathermhq",
                    "V6.vgathermhq.128B" => "__builtin_HEXAGON_V6_vgathermhq_128B",
                    "V6.vgathermhw" => "__builtin_HEXAGON_V6_vgathermhw",
                    "V6.vgathermhw.128B" => "__builtin_HEXAGON_V6_vgathermhw_128B",
                    "V6.vgathermhwq" => "__builtin_HEXAGON_V6_vgathermhwq",
                    "V6.vgathermhwq.128B" => "__builtin_HEXAGON_V6_vgathermhwq_128B",
                    "V6.vgathermw" => "__builtin_HEXAGON_V6_vgathermw",
                    "V6.vgathermw.128B" => "__builtin_HEXAGON_V6_vgathermw_128B",
                    "V6.vgathermwq" => "__builtin_HEXAGON_V6_vgathermwq",
                    "V6.vgathermwq.128B" => "__builtin_HEXAGON_V6_vgathermwq_128B",
                    "V6.vgtb" => "__builtin_HEXAGON_V6_vgtb",
                    "V6.vgtb.128B" => "__builtin_HEXAGON_V6_vgtb_128B",
                    "V6.vgtb.and" => "__builtin_HEXAGON_V6_vgtb_and",
                    "V6.vgtb.and.128B" => "__builtin_HEXAGON_V6_vgtb_and_128B",
                    "V6.vgtb.or" => "__builtin_HEXAGON_V6_vgtb_or",
                    "V6.vgtb.or.128B" => "__builtin_HEXAGON_V6_vgtb_or_128B",
                    "V6.vgtb.xor" => "__builtin_HEXAGON_V6_vgtb_xor",
                    "V6.vgtb.xor.128B" => "__builtin_HEXAGON_V6_vgtb_xor_128B",
                    "V6.vgtbf" => "__builtin_HEXAGON_V6_vgtbf",
                    "V6.vgtbf.128B" => "__builtin_HEXAGON_V6_vgtbf_128B",
                    "V6.vgtbf.and" => "__builtin_HEXAGON_V6_vgtbf_and",
                    "V6.vgtbf.and.128B" => "__builtin_HEXAGON_V6_vgtbf_and_128B",
                    "V6.vgtbf.or" => "__builtin_HEXAGON_V6_vgtbf_or",
                    "V6.vgtbf.or.128B" => "__builtin_HEXAGON_V6_vgtbf_or_128B",
                    "V6.vgtbf.xor" => "__builtin_HEXAGON_V6_vgtbf_xor",
                    "V6.vgtbf.xor.128B" => "__builtin_HEXAGON_V6_vgtbf_xor_128B",
                    "V6.vgth" => "__builtin_HEXAGON_V6_vgth",
                    "V6.vgth.128B" => "__builtin_HEXAGON_V6_vgth_128B",
                    "V6.vgth.and" => "__builtin_HEXAGON_V6_vgth_and",
                    "V6.vgth.and.128B" => "__builtin_HEXAGON_V6_vgth_and_128B",
                    "V6.vgth.or" => "__builtin_HEXAGON_V6_vgth_or",
                    "V6.vgth.or.128B" => "__builtin_HEXAGON_V6_vgth_or_128B",
                    "V6.vgth.xor" => "__builtin_HEXAGON_V6_vgth_xor",
                    "V6.vgth.xor.128B" => "__builtin_HEXAGON_V6_vgth_xor_128B",
                    "V6.vgthf" => "__builtin_HEXAGON_V6_vgthf",
                    "V6.vgthf.128B" => "__builtin_HEXAGON_V6_vgthf_128B",
                    "V6.vgthf.and" => "__builtin_HEXAGON_V6_vgthf_and",
                    "V6.vgthf.and.128B" => "__builtin_HEXAGON_V6_vgthf_and_128B",
                    "V6.vgthf.or" => "__builtin_HEXAGON_V6_vgthf_or",
                    "V6.vgthf.or.128B" => "__builtin_HEXAGON_V6_vgthf_or_128B",
                    "V6.vgthf.xor" => "__builtin_HEXAGON_V6_vgthf_xor",
                    "V6.vgthf.xor.128B" => "__builtin_HEXAGON_V6_vgthf_xor_128B",
                    "V6.vgtsf" => "__builtin_HEXAGON_V6_vgtsf",
                    "V6.vgtsf.128B" => "__builtin_HEXAGON_V6_vgtsf_128B",
                    "V6.vgtsf.and" => "__builtin_HEXAGON_V6_vgtsf_and",
                    "V6.vgtsf.and.128B" => "__builtin_HEXAGON_V6_vgtsf_and_128B",
                    "V6.vgtsf.or" => "__builtin_HEXAGON_V6_vgtsf_or",
                    "V6.vgtsf.or.128B" => "__builtin_HEXAGON_V6_vgtsf_or_128B",
                    "V6.vgtsf.xor" => "__builtin_HEXAGON_V6_vgtsf_xor",
                    "V6.vgtsf.xor.128B" => "__builtin_HEXAGON_V6_vgtsf_xor_128B",
                    "V6.vgtub" => "__builtin_HEXAGON_V6_vgtub",
                    "V6.vgtub.128B" => "__builtin_HEXAGON_V6_vgtub_128B",
                    "V6.vgtub.and" => "__builtin_HEXAGON_V6_vgtub_and",
                    "V6.vgtub.and.128B" => "__builtin_HEXAGON_V6_vgtub_and_128B",
                    "V6.vgtub.or" => "__builtin_HEXAGON_V6_vgtub_or",
                    "V6.vgtub.or.128B" => "__builtin_HEXAGON_V6_vgtub_or_128B",
                    "V6.vgtub.xor" => "__builtin_HEXAGON_V6_vgtub_xor",
                    "V6.vgtub.xor.128B" => "__builtin_HEXAGON_V6_vgtub_xor_128B",
                    "V6.vgtuh" => "__builtin_HEXAGON_V6_vgtuh",
                    "V6.vgtuh.128B" => "__builtin_HEXAGON_V6_vgtuh_128B",
                    "V6.vgtuh.and" => "__builtin_HEXAGON_V6_vgtuh_and",
                    "V6.vgtuh.and.128B" => "__builtin_HEXAGON_V6_vgtuh_and_128B",
                    "V6.vgtuh.or" => "__builtin_HEXAGON_V6_vgtuh_or",
                    "V6.vgtuh.or.128B" => "__builtin_HEXAGON_V6_vgtuh_or_128B",
                    "V6.vgtuh.xor" => "__builtin_HEXAGON_V6_vgtuh_xor",
                    "V6.vgtuh.xor.128B" => "__builtin_HEXAGON_V6_vgtuh_xor_128B",
                    "V6.vgtuw" => "__builtin_HEXAGON_V6_vgtuw",
                    "V6.vgtuw.128B" => "__builtin_HEXAGON_V6_vgtuw_128B",
                    "V6.vgtuw.and" => "__builtin_HEXAGON_V6_vgtuw_and",
                    "V6.vgtuw.and.128B" => "__builtin_HEXAGON_V6_vgtuw_and_128B",
                    "V6.vgtuw.or" => "__builtin_HEXAGON_V6_vgtuw_or",
                    "V6.vgtuw.or.128B" => "__builtin_HEXAGON_V6_vgtuw_or_128B",
                    "V6.vgtuw.xor" => "__builtin_HEXAGON_V6_vgtuw_xor",
                    "V6.vgtuw.xor.128B" => "__builtin_HEXAGON_V6_vgtuw_xor_128B",
                    "V6.vgtw" => "__builtin_HEXAGON_V6_vgtw",
                    "V6.vgtw.128B" => "__builtin_HEXAGON_V6_vgtw_128B",
                    "V6.vgtw.and" => "__builtin_HEXAGON_V6_vgtw_and",
                    "V6.vgtw.and.128B" => "__builtin_HEXAGON_V6_vgtw_and_128B",
                    "V6.vgtw.or" => "__builtin_HEXAGON_V6_vgtw_or",
                    "V6.vgtw.or.128B" => "__builtin_HEXAGON_V6_vgtw_or_128B",
                    "V6.vgtw.xor" => "__builtin_HEXAGON_V6_vgtw_xor",
                    "V6.vgtw.xor.128B" => "__builtin_HEXAGON_V6_vgtw_xor_128B",
                    "V6.vilog2.hf" => "__builtin_HEXAGON_V6_vilog2_hf",
                    "V6.vilog2.hf.128B" => "__builtin_HEXAGON_V6_vilog2_hf_128B",
                    "V6.vilog2.qf16" => "__builtin_HEXAGON_V6_vilog2_qf16",
                    "V6.vilog2.qf16.128B" => "__builtin_HEXAGON_V6_vilog2_qf16_128B",
                    "V6.vilog2.qf32" => "__builtin_HEXAGON_V6_vilog2_qf32",
                    "V6.vilog2.qf32.128B" => "__builtin_HEXAGON_V6_vilog2_qf32_128B",
                    "V6.vilog2.sf" => "__builtin_HEXAGON_V6_vilog2_sf",
                    "V6.vilog2.sf.128B" => "__builtin_HEXAGON_V6_vilog2_sf_128B",
                    "V6.vinsertwr" => "__builtin_HEXAGON_V6_vinsertwr",
                    "V6.vinsertwr.128B" => "__builtin_HEXAGON_V6_vinsertwr_128B",
                    "V6.vlalignb" => "__builtin_HEXAGON_V6_vlalignb",
                    "V6.vlalignb.128B" => "__builtin_HEXAGON_V6_vlalignb_128B",
                    "V6.vlalignbi" => "__builtin_HEXAGON_V6_vlalignbi",
                    "V6.vlalignbi.128B" => "__builtin_HEXAGON_V6_vlalignbi_128B",
                    "V6.vlsrb" => "__builtin_HEXAGON_V6_vlsrb",
                    "V6.vlsrb.128B" => "__builtin_HEXAGON_V6_vlsrb_128B",
                    "V6.vlsrh" => "__builtin_HEXAGON_V6_vlsrh",
                    "V6.vlsrh.128B" => "__builtin_HEXAGON_V6_vlsrh_128B",
                    "V6.vlsrhv" => "__builtin_HEXAGON_V6_vlsrhv",
                    "V6.vlsrhv.128B" => "__builtin_HEXAGON_V6_vlsrhv_128B",
                    "V6.vlsrw" => "__builtin_HEXAGON_V6_vlsrw",
                    "V6.vlsrw.128B" => "__builtin_HEXAGON_V6_vlsrw_128B",
                    "V6.vlsrwv" => "__builtin_HEXAGON_V6_vlsrwv",
                    "V6.vlsrwv.128B" => "__builtin_HEXAGON_V6_vlsrwv_128B",
                    "V6.vlut4" => "__builtin_HEXAGON_V6_vlut4",
                    "V6.vlut4.128B" => "__builtin_HEXAGON_V6_vlut4_128B",
                    "V6.vlutb" => "__builtin_HEXAGON_V6_vlutb",
                    "V6.vlutb.128B" => "__builtin_HEXAGON_V6_vlutb_128B",
                    "V6.vlutb.acc" => "__builtin_HEXAGON_V6_vlutb_acc",
                    "V6.vlutb.acc.128B" => "__builtin_HEXAGON_V6_vlutb_acc_128B",
                    "V6.vlutb.dv" => "__builtin_HEXAGON_V6_vlutb_dv",
                    "V6.vlutb.dv.128B" => "__builtin_HEXAGON_V6_vlutb_dv_128B",
                    "V6.vlutb.dv.acc" => "__builtin_HEXAGON_V6_vlutb_dv_acc",
                    "V6.vlutb.dv.acc.128B" => "__builtin_HEXAGON_V6_vlutb_dv_acc_128B",
                    "V6.vlutvvb" => "__builtin_HEXAGON_V6_vlutvvb",
                    "V6.vlutvvb.128B" => "__builtin_HEXAGON_V6_vlutvvb_128B",
                    "V6.vlutvvb.nm" => "__builtin_HEXAGON_V6_vlutvvb_nm",
                    "V6.vlutvvb.nm.128B" => "__builtin_HEXAGON_V6_vlutvvb_nm_128B",
                    "V6.vlutvvb.oracc" => "__builtin_HEXAGON_V6_vlutvvb_oracc",
                    "V6.vlutvvb.oracc.128B" => "__builtin_HEXAGON_V6_vlutvvb_oracc_128B",
                    "V6.vlutvvb.oracci" => "__builtin_HEXAGON_V6_vlutvvb_oracci",
                    "V6.vlutvvb.oracci.128B" => "__builtin_HEXAGON_V6_vlutvvb_oracci_128B",
                    "V6.vlutvvbi" => "__builtin_HEXAGON_V6_vlutvvbi",
                    "V6.vlutvvbi.128B" => "__builtin_HEXAGON_V6_vlutvvbi_128B",
                    "V6.vlutvwh" => "__builtin_HEXAGON_V6_vlutvwh",
                    "V6.vlutvwh.128B" => "__builtin_HEXAGON_V6_vlutvwh_128B",
                    "V6.vlutvwh.nm" => "__builtin_HEXAGON_V6_vlutvwh_nm",
                    "V6.vlutvwh.nm.128B" => "__builtin_HEXAGON_V6_vlutvwh_nm_128B",
                    "V6.vlutvwh.oracc" => "__builtin_HEXAGON_V6_vlutvwh_oracc",
                    "V6.vlutvwh.oracc.128B" => "__builtin_HEXAGON_V6_vlutvwh_oracc_128B",
                    "V6.vlutvwh.oracci" => "__builtin_HEXAGON_V6_vlutvwh_oracci",
                    "V6.vlutvwh.oracci.128B" => "__builtin_HEXAGON_V6_vlutvwh_oracci_128B",
                    "V6.vlutvwhi" => "__builtin_HEXAGON_V6_vlutvwhi",
                    "V6.vlutvwhi.128B" => "__builtin_HEXAGON_V6_vlutvwhi_128B",
                    "V6.vmax.bf" => "__builtin_HEXAGON_V6_vmax_bf",
                    "V6.vmax.bf.128B" => "__builtin_HEXAGON_V6_vmax_bf_128B",
                    "V6.vmax.hf" => "__builtin_HEXAGON_V6_vmax_hf",
                    "V6.vmax.hf.128B" => "__builtin_HEXAGON_V6_vmax_hf_128B",
                    "V6.vmax.sf" => "__builtin_HEXAGON_V6_vmax_sf",
                    "V6.vmax.sf.128B" => "__builtin_HEXAGON_V6_vmax_sf_128B",
                    "V6.vmaxb" => "__builtin_HEXAGON_V6_vmaxb",
                    "V6.vmaxb.128B" => "__builtin_HEXAGON_V6_vmaxb_128B",
                    "V6.vmaxh" => "__builtin_HEXAGON_V6_vmaxh",
                    "V6.vmaxh.128B" => "__builtin_HEXAGON_V6_vmaxh_128B",
                    "V6.vmaxub" => "__builtin_HEXAGON_V6_vmaxub",
                    "V6.vmaxub.128B" => "__builtin_HEXAGON_V6_vmaxub_128B",
                    "V6.vmaxuh" => "__builtin_HEXAGON_V6_vmaxuh",
                    "V6.vmaxuh.128B" => "__builtin_HEXAGON_V6_vmaxuh_128B",
                    "V6.vmaxw" => "__builtin_HEXAGON_V6_vmaxw",
                    "V6.vmaxw.128B" => "__builtin_HEXAGON_V6_vmaxw_128B",
                    "V6.vmerge.qf" => "__builtin_HEXAGON_V6_vmerge_qf",
                    "V6.vmerge.qf.128B" => "__builtin_HEXAGON_V6_vmerge_qf_128B",
                    "V6.vmin.bf" => "__builtin_HEXAGON_V6_vmin_bf",
                    "V6.vmin.bf.128B" => "__builtin_HEXAGON_V6_vmin_bf_128B",
                    "V6.vmin.hf" => "__builtin_HEXAGON_V6_vmin_hf",
                    "V6.vmin.hf.128B" => "__builtin_HEXAGON_V6_vmin_hf_128B",
                    "V6.vmin.sf" => "__builtin_HEXAGON_V6_vmin_sf",
                    "V6.vmin.sf.128B" => "__builtin_HEXAGON_V6_vmin_sf_128B",
                    "V6.vminb" => "__builtin_HEXAGON_V6_vminb",
                    "V6.vminb.128B" => "__builtin_HEXAGON_V6_vminb_128B",
                    "V6.vminh" => "__builtin_HEXAGON_V6_vminh",
                    "V6.vminh.128B" => "__builtin_HEXAGON_V6_vminh_128B",
                    "V6.vminub" => "__builtin_HEXAGON_V6_vminub",
                    "V6.vminub.128B" => "__builtin_HEXAGON_V6_vminub_128B",
                    "V6.vminuh" => "__builtin_HEXAGON_V6_vminuh",
                    "V6.vminuh.128B" => "__builtin_HEXAGON_V6_vminuh_128B",
                    "V6.vminw" => "__builtin_HEXAGON_V6_vminw",
                    "V6.vminw.128B" => "__builtin_HEXAGON_V6_vminw_128B",
                    "V6.vmpabus" => "__builtin_HEXAGON_V6_vmpabus",
                    "V6.vmpabus.128B" => "__builtin_HEXAGON_V6_vmpabus_128B",
                    "V6.vmpabus.acc" => "__builtin_HEXAGON_V6_vmpabus_acc",
                    "V6.vmpabus.acc.128B" => "__builtin_HEXAGON_V6_vmpabus_acc_128B",
                    "V6.vmpabusv" => "__builtin_HEXAGON_V6_vmpabusv",
                    "V6.vmpabusv.128B" => "__builtin_HEXAGON_V6_vmpabusv_128B",
                    "V6.vmpabuu" => "__builtin_HEXAGON_V6_vmpabuu",
                    "V6.vmpabuu.128B" => "__builtin_HEXAGON_V6_vmpabuu_128B",
                    "V6.vmpabuu.acc" => "__builtin_HEXAGON_V6_vmpabuu_acc",
                    "V6.vmpabuu.acc.128B" => "__builtin_HEXAGON_V6_vmpabuu_acc_128B",
                    "V6.vmpabuuv" => "__builtin_HEXAGON_V6_vmpabuuv",
                    "V6.vmpabuuv.128B" => "__builtin_HEXAGON_V6_vmpabuuv_128B",
                    "V6.vmpahb" => "__builtin_HEXAGON_V6_vmpahb",
                    "V6.vmpahb.128B" => "__builtin_HEXAGON_V6_vmpahb_128B",
                    "V6.vmpahb.acc" => "__builtin_HEXAGON_V6_vmpahb_acc",
                    "V6.vmpahb.acc.128B" => "__builtin_HEXAGON_V6_vmpahb_acc_128B",
                    "V6.vmpahhsat" => "__builtin_HEXAGON_V6_vmpahhsat",
                    "V6.vmpahhsat.128B" => "__builtin_HEXAGON_V6_vmpahhsat_128B",
                    "V6.vmpauhb" => "__builtin_HEXAGON_V6_vmpauhb",
                    "V6.vmpauhb.128B" => "__builtin_HEXAGON_V6_vmpauhb_128B",
                    "V6.vmpauhb.acc" => "__builtin_HEXAGON_V6_vmpauhb_acc",
                    "V6.vmpauhb.acc.128B" => "__builtin_HEXAGON_V6_vmpauhb_acc_128B",
                    "V6.vmpauhuhsat" => "__builtin_HEXAGON_V6_vmpauhuhsat",
                    "V6.vmpauhuhsat.128B" => "__builtin_HEXAGON_V6_vmpauhuhsat_128B",
                    "V6.vmpsuhuhsat" => "__builtin_HEXAGON_V6_vmpsuhuhsat",
                    "V6.vmpsuhuhsat.128B" => "__builtin_HEXAGON_V6_vmpsuhuhsat_128B",
                    "V6.vmpy.hf.f8" => "__builtin_HEXAGON_V6_vmpy_hf_f8",
                    "V6.vmpy.hf.f8.128B" => "__builtin_HEXAGON_V6_vmpy_hf_f8_128B",
                    "V6.vmpy.hf.f8.acc" => "__builtin_HEXAGON_V6_vmpy_hf_f8_acc",
                    "V6.vmpy.hf.f8.acc.128B" => "__builtin_HEXAGON_V6_vmpy_hf_f8_acc_128B",
                    "V6.vmpy.hf.hf" => "__builtin_HEXAGON_V6_vmpy_hf_hf",
                    "V6.vmpy.hf.hf.128B" => "__builtin_HEXAGON_V6_vmpy_hf_hf_128B",
                    "V6.vmpy.hf.hf.acc" => "__builtin_HEXAGON_V6_vmpy_hf_hf_acc",
                    "V6.vmpy.hf.hf.acc.128B" => "__builtin_HEXAGON_V6_vmpy_hf_hf_acc_128B",
                    "V6.vmpy.qf16" => "__builtin_HEXAGON_V6_vmpy_qf16",
                    "V6.vmpy.qf16.128B" => "__builtin_HEXAGON_V6_vmpy_qf16_128B",
                    "V6.vmpy.qf16.hf" => "__builtin_HEXAGON_V6_vmpy_qf16_hf",
                    "V6.vmpy.qf16.hf.128B" => "__builtin_HEXAGON_V6_vmpy_qf16_hf_128B",
                    "V6.vmpy.qf16.mix.hf" => "__builtin_HEXAGON_V6_vmpy_qf16_mix_hf",
                    "V6.vmpy.qf16.mix.hf.128B" => "__builtin_HEXAGON_V6_vmpy_qf16_mix_hf_128B",
                    "V6.vmpy.qf32" => "__builtin_HEXAGON_V6_vmpy_qf32",
                    "V6.vmpy.qf32.128B" => "__builtin_HEXAGON_V6_vmpy_qf32_128B",
                    "V6.vmpy.qf32.hf" => "__builtin_HEXAGON_V6_vmpy_qf32_hf",
                    "V6.vmpy.qf32.hf.128B" => "__builtin_HEXAGON_V6_vmpy_qf32_hf_128B",
                    "V6.vmpy.qf32.mix.hf" => "__builtin_HEXAGON_V6_vmpy_qf32_mix_hf",
                    "V6.vmpy.qf32.mix.hf.128B" => "__builtin_HEXAGON_V6_vmpy_qf32_mix_hf_128B",
                    "V6.vmpy.qf32.qf16" => "__builtin_HEXAGON_V6_vmpy_qf32_qf16",
                    "V6.vmpy.qf32.qf16.128B" => "__builtin_HEXAGON_V6_vmpy_qf32_qf16_128B",
                    "V6.vmpy.qf32.sf" => "__builtin_HEXAGON_V6_vmpy_qf32_sf",
                    "V6.vmpy.qf32.sf.128B" => "__builtin_HEXAGON_V6_vmpy_qf32_sf_128B",
                    "V6.vmpy.rt.hf" => "__builtin_HEXAGON_V6_vmpy_rt_hf",
                    "V6.vmpy.rt.hf.128B" => "__builtin_HEXAGON_V6_vmpy_rt_hf_128B",
                    "V6.vmpy.rt.qf16" => "__builtin_HEXAGON_V6_vmpy_rt_qf16",
                    "V6.vmpy.rt.qf16.128B" => "__builtin_HEXAGON_V6_vmpy_rt_qf16_128B",
                    "V6.vmpy.rt.sf" => "__builtin_HEXAGON_V6_vmpy_rt_sf",
                    "V6.vmpy.rt.sf.128B" => "__builtin_HEXAGON_V6_vmpy_rt_sf_128B",
                    "V6.vmpy.sf.bf" => "__builtin_HEXAGON_V6_vmpy_sf_bf",
                    "V6.vmpy.sf.bf.128B" => "__builtin_HEXAGON_V6_vmpy_sf_bf_128B",
                    "V6.vmpy.sf.bf.acc" => "__builtin_HEXAGON_V6_vmpy_sf_bf_acc",
                    "V6.vmpy.sf.bf.acc.128B" => "__builtin_HEXAGON_V6_vmpy_sf_bf_acc_128B",
                    "V6.vmpy.sf.hf" => "__builtin_HEXAGON_V6_vmpy_sf_hf",
                    "V6.vmpy.sf.hf.128B" => "__builtin_HEXAGON_V6_vmpy_sf_hf_128B",
                    "V6.vmpy.sf.hf.acc" => "__builtin_HEXAGON_V6_vmpy_sf_hf_acc",
                    "V6.vmpy.sf.hf.acc.128B" => "__builtin_HEXAGON_V6_vmpy_sf_hf_acc_128B",
                    "V6.vmpy.sf.sf" => "__builtin_HEXAGON_V6_vmpy_sf_sf",
                    "V6.vmpy.sf.sf.128B" => "__builtin_HEXAGON_V6_vmpy_sf_sf_128B",
                    "V6.vmpybus" => "__builtin_HEXAGON_V6_vmpybus",
                    "V6.vmpybus.128B" => "__builtin_HEXAGON_V6_vmpybus_128B",
                    "V6.vmpybus.acc" => "__builtin_HEXAGON_V6_vmpybus_acc",
                    "V6.vmpybus.acc.128B" => "__builtin_HEXAGON_V6_vmpybus_acc_128B",
                    "V6.vmpybusv" => "__builtin_HEXAGON_V6_vmpybusv",
                    "V6.vmpybusv.128B" => "__builtin_HEXAGON_V6_vmpybusv_128B",
                    "V6.vmpybusv.acc" => "__builtin_HEXAGON_V6_vmpybusv_acc",
                    "V6.vmpybusv.acc.128B" => "__builtin_HEXAGON_V6_vmpybusv_acc_128B",
                    "V6.vmpybv" => "__builtin_HEXAGON_V6_vmpybv",
                    "V6.vmpybv.128B" => "__builtin_HEXAGON_V6_vmpybv_128B",
                    "V6.vmpybv.acc" => "__builtin_HEXAGON_V6_vmpybv_acc",
                    "V6.vmpybv.acc.128B" => "__builtin_HEXAGON_V6_vmpybv_acc_128B",
                    "V6.vmpyewuh" => "__builtin_HEXAGON_V6_vmpyewuh",
                    "V6.vmpyewuh.128B" => "__builtin_HEXAGON_V6_vmpyewuh_128B",
                    "V6.vmpyewuh.64" => "__builtin_HEXAGON_V6_vmpyewuh_64",
                    "V6.vmpyewuh.64.128B" => "__builtin_HEXAGON_V6_vmpyewuh_64_128B",
                    "V6.vmpyh" => "__builtin_HEXAGON_V6_vmpyh",
                    "V6.vmpyh.128B" => "__builtin_HEXAGON_V6_vmpyh_128B",
                    "V6.vmpyh.acc" => "__builtin_HEXAGON_V6_vmpyh_acc",
                    "V6.vmpyh.acc.128B" => "__builtin_HEXAGON_V6_vmpyh_acc_128B",
                    "V6.vmpyhsat.acc" => "__builtin_HEXAGON_V6_vmpyhsat_acc",
                    "V6.vmpyhsat.acc.128B" => "__builtin_HEXAGON_V6_vmpyhsat_acc_128B",
                    "V6.vmpyhsrs" => "__builtin_HEXAGON_V6_vmpyhsrs",
                    "V6.vmpyhsrs.128B" => "__builtin_HEXAGON_V6_vmpyhsrs_128B",
                    "V6.vmpyhss" => "__builtin_HEXAGON_V6_vmpyhss",
                    "V6.vmpyhss.128B" => "__builtin_HEXAGON_V6_vmpyhss_128B",
                    "V6.vmpyhus" => "__builtin_HEXAGON_V6_vmpyhus",
                    "V6.vmpyhus.128B" => "__builtin_HEXAGON_V6_vmpyhus_128B",
                    "V6.vmpyhus.acc" => "__builtin_HEXAGON_V6_vmpyhus_acc",
                    "V6.vmpyhus.acc.128B" => "__builtin_HEXAGON_V6_vmpyhus_acc_128B",
                    "V6.vmpyhv" => "__builtin_HEXAGON_V6_vmpyhv",
                    "V6.vmpyhv.128B" => "__builtin_HEXAGON_V6_vmpyhv_128B",
                    "V6.vmpyhv.acc" => "__builtin_HEXAGON_V6_vmpyhv_acc",
                    "V6.vmpyhv.acc.128B" => "__builtin_HEXAGON_V6_vmpyhv_acc_128B",
                    "V6.vmpyhvsrs" => "__builtin_HEXAGON_V6_vmpyhvsrs",
                    "V6.vmpyhvsrs.128B" => "__builtin_HEXAGON_V6_vmpyhvsrs_128B",
                    "V6.vmpyieoh" => "__builtin_HEXAGON_V6_vmpyieoh",
                    "V6.vmpyieoh.128B" => "__builtin_HEXAGON_V6_vmpyieoh_128B",
                    "V6.vmpyiewh.acc" => "__builtin_HEXAGON_V6_vmpyiewh_acc",
                    "V6.vmpyiewh.acc.128B" => "__builtin_HEXAGON_V6_vmpyiewh_acc_128B",
                    "V6.vmpyiewuh" => "__builtin_HEXAGON_V6_vmpyiewuh",
                    "V6.vmpyiewuh.128B" => "__builtin_HEXAGON_V6_vmpyiewuh_128B",
                    "V6.vmpyiewuh.acc" => "__builtin_HEXAGON_V6_vmpyiewuh_acc",
                    "V6.vmpyiewuh.acc.128B" => "__builtin_HEXAGON_V6_vmpyiewuh_acc_128B",
                    "V6.vmpyih" => "__builtin_HEXAGON_V6_vmpyih",
                    "V6.vmpyih.128B" => "__builtin_HEXAGON_V6_vmpyih_128B",
                    "V6.vmpyih.acc" => "__builtin_HEXAGON_V6_vmpyih_acc",
                    "V6.vmpyih.acc.128B" => "__builtin_HEXAGON_V6_vmpyih_acc_128B",
                    "V6.vmpyihb" => "__builtin_HEXAGON_V6_vmpyihb",
                    "V6.vmpyihb.128B" => "__builtin_HEXAGON_V6_vmpyihb_128B",
                    "V6.vmpyihb.acc" => "__builtin_HEXAGON_V6_vmpyihb_acc",
                    "V6.vmpyihb.acc.128B" => "__builtin_HEXAGON_V6_vmpyihb_acc_128B",
                    "V6.vmpyiowh" => "__builtin_HEXAGON_V6_vmpyiowh",
                    "V6.vmpyiowh.128B" => "__builtin_HEXAGON_V6_vmpyiowh_128B",
                    "V6.vmpyiwb" => "__builtin_HEXAGON_V6_vmpyiwb",
                    "V6.vmpyiwb.128B" => "__builtin_HEXAGON_V6_vmpyiwb_128B",
                    "V6.vmpyiwb.acc" => "__builtin_HEXAGON_V6_vmpyiwb_acc",
                    "V6.vmpyiwb.acc.128B" => "__builtin_HEXAGON_V6_vmpyiwb_acc_128B",
                    "V6.vmpyiwh" => "__builtin_HEXAGON_V6_vmpyiwh",
                    "V6.vmpyiwh.128B" => "__builtin_HEXAGON_V6_vmpyiwh_128B",
                    "V6.vmpyiwh.acc" => "__builtin_HEXAGON_V6_vmpyiwh_acc",
                    "V6.vmpyiwh.acc.128B" => "__builtin_HEXAGON_V6_vmpyiwh_acc_128B",
                    "V6.vmpyiwub" => "__builtin_HEXAGON_V6_vmpyiwub",
                    "V6.vmpyiwub.128B" => "__builtin_HEXAGON_V6_vmpyiwub_128B",
                    "V6.vmpyiwub.acc" => "__builtin_HEXAGON_V6_vmpyiwub_acc",
                    "V6.vmpyiwub.acc.128B" => "__builtin_HEXAGON_V6_vmpyiwub_acc_128B",
                    "V6.vmpyowh" => "__builtin_HEXAGON_V6_vmpyowh",
                    "V6.vmpyowh.128B" => "__builtin_HEXAGON_V6_vmpyowh_128B",
                    "V6.vmpyowh.64.acc" => "__builtin_HEXAGON_V6_vmpyowh_64_acc",
                    "V6.vmpyowh.64.acc.128B" => "__builtin_HEXAGON_V6_vmpyowh_64_acc_128B",
                    "V6.vmpyowh.rnd" => "__builtin_HEXAGON_V6_vmpyowh_rnd",
                    "V6.vmpyowh.rnd.128B" => "__builtin_HEXAGON_V6_vmpyowh_rnd_128B",
                    "V6.vmpyowh.rnd.sacc" => "__builtin_HEXAGON_V6_vmpyowh_rnd_sacc",
                    "V6.vmpyowh.rnd.sacc.128B" => "__builtin_HEXAGON_V6_vmpyowh_rnd_sacc_128B",
                    "V6.vmpyowh.sacc" => "__builtin_HEXAGON_V6_vmpyowh_sacc",
                    "V6.vmpyowh.sacc.128B" => "__builtin_HEXAGON_V6_vmpyowh_sacc_128B",
                    "V6.vmpyub" => "__builtin_HEXAGON_V6_vmpyub",
                    "V6.vmpyub.128B" => "__builtin_HEXAGON_V6_vmpyub_128B",
                    "V6.vmpyub.acc" => "__builtin_HEXAGON_V6_vmpyub_acc",
                    "V6.vmpyub.acc.128B" => "__builtin_HEXAGON_V6_vmpyub_acc_128B",
                    "V6.vmpyubv" => "__builtin_HEXAGON_V6_vmpyubv",
                    "V6.vmpyubv.128B" => "__builtin_HEXAGON_V6_vmpyubv_128B",
                    "V6.vmpyubv.acc" => "__builtin_HEXAGON_V6_vmpyubv_acc",
                    "V6.vmpyubv.acc.128B" => "__builtin_HEXAGON_V6_vmpyubv_acc_128B",
                    "V6.vmpyuh" => "__builtin_HEXAGON_V6_vmpyuh",
                    "V6.vmpyuh.128B" => "__builtin_HEXAGON_V6_vmpyuh_128B",
                    "V6.vmpyuh.acc" => "__builtin_HEXAGON_V6_vmpyuh_acc",
                    "V6.vmpyuh.acc.128B" => "__builtin_HEXAGON_V6_vmpyuh_acc_128B",
                    "V6.vmpyuhe" => "__builtin_HEXAGON_V6_vmpyuhe",
                    "V6.vmpyuhe.128B" => "__builtin_HEXAGON_V6_vmpyuhe_128B",
                    "V6.vmpyuhe.acc" => "__builtin_HEXAGON_V6_vmpyuhe_acc",
                    "V6.vmpyuhe.acc.128B" => "__builtin_HEXAGON_V6_vmpyuhe_acc_128B",
                    "V6.vmpyuhv" => "__builtin_HEXAGON_V6_vmpyuhv",
                    "V6.vmpyuhv.128B" => "__builtin_HEXAGON_V6_vmpyuhv_128B",
                    "V6.vmpyuhv.acc" => "__builtin_HEXAGON_V6_vmpyuhv_acc",
                    "V6.vmpyuhv.acc.128B" => "__builtin_HEXAGON_V6_vmpyuhv_acc_128B",
                    "V6.vmpyuhvs" => "__builtin_HEXAGON_V6_vmpyuhvs",
                    "V6.vmpyuhvs.128B" => "__builtin_HEXAGON_V6_vmpyuhvs_128B",
                    "V6.vmux" => "__builtin_HEXAGON_V6_vmux",
                    "V6.vmux.128B" => "__builtin_HEXAGON_V6_vmux_128B",
                    "V6.vnavgb" => "__builtin_HEXAGON_V6_vnavgb",
                    "V6.vnavgb.128B" => "__builtin_HEXAGON_V6_vnavgb_128B",
                    "V6.vnavgh" => "__builtin_HEXAGON_V6_vnavgh",
                    "V6.vnavgh.128B" => "__builtin_HEXAGON_V6_vnavgh_128B",
                    "V6.vnavgub" => "__builtin_HEXAGON_V6_vnavgub",
                    "V6.vnavgub.128B" => "__builtin_HEXAGON_V6_vnavgub_128B",
                    "V6.vnavgw" => "__builtin_HEXAGON_V6_vnavgw",
                    "V6.vnavgw.128B" => "__builtin_HEXAGON_V6_vnavgw_128B",
                    "V6.vneg.qf16.hf" => "__builtin_HEXAGON_V6_vneg_qf16_hf",
                    "V6.vneg.qf16.hf.128B" => "__builtin_HEXAGON_V6_vneg_qf16_hf_128B",
                    "V6.vneg.qf16.qf16" => "__builtin_HEXAGON_V6_vneg_qf16_qf16",
                    "V6.vneg.qf16.qf16.128B" => "__builtin_HEXAGON_V6_vneg_qf16_qf16_128B",
                    "V6.vneg.qf32.qf32" => "__builtin_HEXAGON_V6_vneg_qf32_qf32",
                    "V6.vneg.qf32.qf32.128B" => "__builtin_HEXAGON_V6_vneg_qf32_qf32_128B",
                    "V6.vneg.qf32.sf" => "__builtin_HEXAGON_V6_vneg_qf32_sf",
                    "V6.vneg.qf32.sf.128B" => "__builtin_HEXAGON_V6_vneg_qf32_sf_128B",
                    "V6.vnormamth" => "__builtin_HEXAGON_V6_vnormamth",
                    "V6.vnormamth.128B" => "__builtin_HEXAGON_V6_vnormamth_128B",
                    "V6.vnormamtw" => "__builtin_HEXAGON_V6_vnormamtw",
                    "V6.vnormamtw.128B" => "__builtin_HEXAGON_V6_vnormamtw_128B",
                    "V6.vnot" => "__builtin_HEXAGON_V6_vnot",
                    "V6.vnot.128B" => "__builtin_HEXAGON_V6_vnot_128B",
                    "V6.vor" => "__builtin_HEXAGON_V6_vor",
                    "V6.vor.128B" => "__builtin_HEXAGON_V6_vor_128B",
                    "V6.vpackeb" => "__builtin_HEXAGON_V6_vpackeb",
                    "V6.vpackeb.128B" => "__builtin_HEXAGON_V6_vpackeb_128B",
                    "V6.vpackeh" => "__builtin_HEXAGON_V6_vpackeh",
                    "V6.vpackeh.128B" => "__builtin_HEXAGON_V6_vpackeh_128B",
                    "V6.vpackhb.sat" => "__builtin_HEXAGON_V6_vpackhb_sat",
                    "V6.vpackhb.sat.128B" => "__builtin_HEXAGON_V6_vpackhb_sat_128B",
                    "V6.vpackhub.sat" => "__builtin_HEXAGON_V6_vpackhub_sat",
                    "V6.vpackhub.sat.128B" => "__builtin_HEXAGON_V6_vpackhub_sat_128B",
                    "V6.vpackob" => "__builtin_HEXAGON_V6_vpackob",
                    "V6.vpackob.128B" => "__builtin_HEXAGON_V6_vpackob_128B",
                    "V6.vpackoh" => "__builtin_HEXAGON_V6_vpackoh",
                    "V6.vpackoh.128B" => "__builtin_HEXAGON_V6_vpackoh_128B",
                    "V6.vpackwh.sat" => "__builtin_HEXAGON_V6_vpackwh_sat",
                    "V6.vpackwh.sat.128B" => "__builtin_HEXAGON_V6_vpackwh_sat_128B",
                    "V6.vpackwuh.sat" => "__builtin_HEXAGON_V6_vpackwuh_sat",
                    "V6.vpackwuh.sat.128B" => "__builtin_HEXAGON_V6_vpackwuh_sat_128B",
                    "V6.vpopcounth" => "__builtin_HEXAGON_V6_vpopcounth",
                    "V6.vpopcounth.128B" => "__builtin_HEXAGON_V6_vpopcounth_128B",
                    "V6.vprefixqb" => "__builtin_HEXAGON_V6_vprefixqb",
                    "V6.vprefixqb.128B" => "__builtin_HEXAGON_V6_vprefixqb_128B",
                    "V6.vprefixqh" => "__builtin_HEXAGON_V6_vprefixqh",
                    "V6.vprefixqh.128B" => "__builtin_HEXAGON_V6_vprefixqh_128B",
                    "V6.vprefixqw" => "__builtin_HEXAGON_V6_vprefixqw",
                    "V6.vprefixqw.128B" => "__builtin_HEXAGON_V6_vprefixqw_128B",
                    "V6.vrdelta" => "__builtin_HEXAGON_V6_vrdelta",
                    "V6.vrdelta.128B" => "__builtin_HEXAGON_V6_vrdelta_128B",
                    "V6.vrmpybub.rtt" => "__builtin_HEXAGON_V6_vrmpybub_rtt",
                    "V6.vrmpybub.rtt.128B" => "__builtin_HEXAGON_V6_vrmpybub_rtt_128B",
                    "V6.vrmpybub.rtt.acc" => "__builtin_HEXAGON_V6_vrmpybub_rtt_acc",
                    "V6.vrmpybub.rtt.acc.128B" => "__builtin_HEXAGON_V6_vrmpybub_rtt_acc_128B",
                    "V6.vrmpybus" => "__builtin_HEXAGON_V6_vrmpybus",
                    "V6.vrmpybus.128B" => "__builtin_HEXAGON_V6_vrmpybus_128B",
                    "V6.vrmpybus.acc" => "__builtin_HEXAGON_V6_vrmpybus_acc",
                    "V6.vrmpybus.acc.128B" => "__builtin_HEXAGON_V6_vrmpybus_acc_128B",
                    "V6.vrmpybusi" => "__builtin_HEXAGON_V6_vrmpybusi",
                    "V6.vrmpybusi.128B" => "__builtin_HEXAGON_V6_vrmpybusi_128B",
                    "V6.vrmpybusi.acc" => "__builtin_HEXAGON_V6_vrmpybusi_acc",
                    "V6.vrmpybusi.acc.128B" => "__builtin_HEXAGON_V6_vrmpybusi_acc_128B",
                    "V6.vrmpybusv" => "__builtin_HEXAGON_V6_vrmpybusv",
                    "V6.vrmpybusv.128B" => "__builtin_HEXAGON_V6_vrmpybusv_128B",
                    "V6.vrmpybusv.acc" => "__builtin_HEXAGON_V6_vrmpybusv_acc",
                    "V6.vrmpybusv.acc.128B" => "__builtin_HEXAGON_V6_vrmpybusv_acc_128B",
                    "V6.vrmpybv" => "__builtin_HEXAGON_V6_vrmpybv",
                    "V6.vrmpybv.128B" => "__builtin_HEXAGON_V6_vrmpybv_128B",
                    "V6.vrmpybv.acc" => "__builtin_HEXAGON_V6_vrmpybv_acc",
                    "V6.vrmpybv.acc.128B" => "__builtin_HEXAGON_V6_vrmpybv_acc_128B",
                    "V6.vrmpyub" => "__builtin_HEXAGON_V6_vrmpyub",
                    "V6.vrmpyub.128B" => "__builtin_HEXAGON_V6_vrmpyub_128B",
                    "V6.vrmpyub.acc" => "__builtin_HEXAGON_V6_vrmpyub_acc",
                    "V6.vrmpyub.acc.128B" => "__builtin_HEXAGON_V6_vrmpyub_acc_128B",
                    "V6.vrmpyub.rtt" => "__builtin_HEXAGON_V6_vrmpyub_rtt",
                    "V6.vrmpyub.rtt.128B" => "__builtin_HEXAGON_V6_vrmpyub_rtt_128B",
                    "V6.vrmpyub.rtt.acc" => "__builtin_HEXAGON_V6_vrmpyub_rtt_acc",
                    "V6.vrmpyub.rtt.acc.128B" => "__builtin_HEXAGON_V6_vrmpyub_rtt_acc_128B",
                    "V6.vrmpyubi" => "__builtin_HEXAGON_V6_vrmpyubi",
                    "V6.vrmpyubi.128B" => "__builtin_HEXAGON_V6_vrmpyubi_128B",
                    "V6.vrmpyubi.acc" => "__builtin_HEXAGON_V6_vrmpyubi_acc",
                    "V6.vrmpyubi.acc.128B" => "__builtin_HEXAGON_V6_vrmpyubi_acc_128B",
                    "V6.vrmpyubv" => "__builtin_HEXAGON_V6_vrmpyubv",
                    "V6.vrmpyubv.128B" => "__builtin_HEXAGON_V6_vrmpyubv_128B",
                    "V6.vrmpyubv.acc" => "__builtin_HEXAGON_V6_vrmpyubv_acc",
                    "V6.vrmpyubv.acc.128B" => "__builtin_HEXAGON_V6_vrmpyubv_acc_128B",
                    "V6.vror" => "__builtin_HEXAGON_V6_vror",
                    "V6.vror.128B" => "__builtin_HEXAGON_V6_vror_128B",
                    "V6.vrotr" => "__builtin_HEXAGON_V6_vrotr",
                    "V6.vrotr.128B" => "__builtin_HEXAGON_V6_vrotr_128B",
                    "V6.vroundhb" => "__builtin_HEXAGON_V6_vroundhb",
                    "V6.vroundhb.128B" => "__builtin_HEXAGON_V6_vroundhb_128B",
                    "V6.vroundhub" => "__builtin_HEXAGON_V6_vroundhub",
                    "V6.vroundhub.128B" => "__builtin_HEXAGON_V6_vroundhub_128B",
                    "V6.vrounduhub" => "__builtin_HEXAGON_V6_vrounduhub",
                    "V6.vrounduhub.128B" => "__builtin_HEXAGON_V6_vrounduhub_128B",
                    "V6.vrounduwuh" => "__builtin_HEXAGON_V6_vrounduwuh",
                    "V6.vrounduwuh.128B" => "__builtin_HEXAGON_V6_vrounduwuh_128B",
                    "V6.vroundwh" => "__builtin_HEXAGON_V6_vroundwh",
                    "V6.vroundwh.128B" => "__builtin_HEXAGON_V6_vroundwh_128B",
                    "V6.vroundwuh" => "__builtin_HEXAGON_V6_vroundwuh",
                    "V6.vroundwuh.128B" => "__builtin_HEXAGON_V6_vroundwuh_128B",
                    "V6.vrsadubi" => "__builtin_HEXAGON_V6_vrsadubi",
                    "V6.vrsadubi.128B" => "__builtin_HEXAGON_V6_vrsadubi_128B",
                    "V6.vrsadubi.acc" => "__builtin_HEXAGON_V6_vrsadubi_acc",
                    "V6.vrsadubi.acc.128B" => "__builtin_HEXAGON_V6_vrsadubi_acc_128B",
                    "V6.vsatdw" => "__builtin_HEXAGON_V6_vsatdw",
                    "V6.vsatdw.128B" => "__builtin_HEXAGON_V6_vsatdw_128B",
                    "V6.vsathub" => "__builtin_HEXAGON_V6_vsathub",
                    "V6.vsathub.128B" => "__builtin_HEXAGON_V6_vsathub_128B",
                    "V6.vsatuwuh" => "__builtin_HEXAGON_V6_vsatuwuh",
                    "V6.vsatuwuh.128B" => "__builtin_HEXAGON_V6_vsatuwuh_128B",
                    "V6.vsatwh" => "__builtin_HEXAGON_V6_vsatwh",
                    "V6.vsatwh.128B" => "__builtin_HEXAGON_V6_vsatwh_128B",
                    "V6.vsb" => "__builtin_HEXAGON_V6_vsb",
                    "V6.vsb.128B" => "__builtin_HEXAGON_V6_vsb_128B",
                    "V6.vscattermh" => "__builtin_HEXAGON_V6_vscattermh",
                    "V6.vscattermh.128B" => "__builtin_HEXAGON_V6_vscattermh_128B",
                    "V6.vscattermh.add" => "__builtin_HEXAGON_V6_vscattermh_add",
                    "V6.vscattermh.add.128B" => "__builtin_HEXAGON_V6_vscattermh_add_128B",
                    "V6.vscattermhq" => "__builtin_HEXAGON_V6_vscattermhq",
                    "V6.vscattermhq.128B" => "__builtin_HEXAGON_V6_vscattermhq_128B",
                    "V6.vscattermhw" => "__builtin_HEXAGON_V6_vscattermhw",
                    "V6.vscattermhw.128B" => "__builtin_HEXAGON_V6_vscattermhw_128B",
                    "V6.vscattermhw.add" => "__builtin_HEXAGON_V6_vscattermhw_add",
                    "V6.vscattermhw.add.128B" => "__builtin_HEXAGON_V6_vscattermhw_add_128B",
                    "V6.vscattermhwq" => "__builtin_HEXAGON_V6_vscattermhwq",
                    "V6.vscattermhwq.128B" => "__builtin_HEXAGON_V6_vscattermhwq_128B",
                    "V6.vscattermw" => "__builtin_HEXAGON_V6_vscattermw",
                    "V6.vscattermw.128B" => "__builtin_HEXAGON_V6_vscattermw_128B",
                    "V6.vscattermw.add" => "__builtin_HEXAGON_V6_vscattermw_add",
                    "V6.vscattermw.add.128B" => "__builtin_HEXAGON_V6_vscattermw_add_128B",
                    "V6.vscattermwq" => "__builtin_HEXAGON_V6_vscattermwq",
                    "V6.vscattermwq.128B" => "__builtin_HEXAGON_V6_vscattermwq_128B",
                    "V6.vsh" => "__builtin_HEXAGON_V6_vsh",
                    "V6.vsh.128B" => "__builtin_HEXAGON_V6_vsh_128B",
                    "V6.vshufeh" => "__builtin_HEXAGON_V6_vshufeh",
                    "V6.vshufeh.128B" => "__builtin_HEXAGON_V6_vshufeh_128B",
                    "V6.vshuffb" => "__builtin_HEXAGON_V6_vshuffb",
                    "V6.vshuffb.128B" => "__builtin_HEXAGON_V6_vshuffb_128B",
                    "V6.vshuffeb" => "__builtin_HEXAGON_V6_vshuffeb",
                    "V6.vshuffeb.128B" => "__builtin_HEXAGON_V6_vshuffeb_128B",
                    "V6.vshuffh" => "__builtin_HEXAGON_V6_vshuffh",
                    "V6.vshuffh.128B" => "__builtin_HEXAGON_V6_vshuffh_128B",
                    "V6.vshuffob" => "__builtin_HEXAGON_V6_vshuffob",
                    "V6.vshuffob.128B" => "__builtin_HEXAGON_V6_vshuffob_128B",
                    "V6.vshuffvdd" => "__builtin_HEXAGON_V6_vshuffvdd",
                    "V6.vshuffvdd.128B" => "__builtin_HEXAGON_V6_vshuffvdd_128B",
                    "V6.vshufoeb" => "__builtin_HEXAGON_V6_vshufoeb",
                    "V6.vshufoeb.128B" => "__builtin_HEXAGON_V6_vshufoeb_128B",
                    "V6.vshufoeh" => "__builtin_HEXAGON_V6_vshufoeh",
                    "V6.vshufoeh.128B" => "__builtin_HEXAGON_V6_vshufoeh_128B",
                    "V6.vshufoh" => "__builtin_HEXAGON_V6_vshufoh",
                    "V6.vshufoh.128B" => "__builtin_HEXAGON_V6_vshufoh_128B",
                    "V6.vsub.hf" => "__builtin_HEXAGON_V6_vsub_hf",
                    "V6.vsub.hf.128B" => "__builtin_HEXAGON_V6_vsub_hf_128B",
                    "V6.vsub.hf.f8" => "__builtin_HEXAGON_V6_vsub_hf_f8",
                    "V6.vsub.hf.f8.128B" => "__builtin_HEXAGON_V6_vsub_hf_f8_128B",
                    "V6.vsub.hf.hf" => "__builtin_HEXAGON_V6_vsub_hf_hf",
                    "V6.vsub.hf.hf.128B" => "__builtin_HEXAGON_V6_vsub_hf_hf_128B",
                    "V6.vsub.hf.mix" => "__builtin_HEXAGON_V6_vsub_hf_mix",
                    "V6.vsub.hf.mix.128B" => "__builtin_HEXAGON_V6_vsub_hf_mix_128B",
                    "V6.vsub.qf16" => "__builtin_HEXAGON_V6_vsub_qf16",
                    "V6.vsub.qf16.128B" => "__builtin_HEXAGON_V6_vsub_qf16_128B",
                    "V6.vsub.qf16.mix" => "__builtin_HEXAGON_V6_vsub_qf16_mix",
                    "V6.vsub.qf16.mix.128B" => "__builtin_HEXAGON_V6_vsub_qf16_mix_128B",
                    "V6.vsub.qf32" => "__builtin_HEXAGON_V6_vsub_qf32",
                    "V6.vsub.qf32.128B" => "__builtin_HEXAGON_V6_vsub_qf32_128B",
                    "V6.vsub.qf32.mix" => "__builtin_HEXAGON_V6_vsub_qf32_mix",
                    "V6.vsub.qf32.mix.128B" => "__builtin_HEXAGON_V6_vsub_qf32_mix_128B",
                    "V6.vsub.sf" => "__builtin_HEXAGON_V6_vsub_sf",
                    "V6.vsub.sf.128B" => "__builtin_HEXAGON_V6_vsub_sf_128B",
                    "V6.vsub.sf.bf" => "__builtin_HEXAGON_V6_vsub_sf_bf",
                    "V6.vsub.sf.bf.128B" => "__builtin_HEXAGON_V6_vsub_sf_bf_128B",
                    "V6.vsub.sf.hf" => "__builtin_HEXAGON_V6_vsub_sf_hf",
                    "V6.vsub.sf.hf.128B" => "__builtin_HEXAGON_V6_vsub_sf_hf_128B",
                    "V6.vsub.sf.mix" => "__builtin_HEXAGON_V6_vsub_sf_mix",
                    "V6.vsub.sf.mix.128B" => "__builtin_HEXAGON_V6_vsub_sf_mix_128B",
                    "V6.vsub.sf.sf" => "__builtin_HEXAGON_V6_vsub_sf_sf",
                    "V6.vsub.sf.sf.128B" => "__builtin_HEXAGON_V6_vsub_sf_sf_128B",
                    "V6.vsubb" => "__builtin_HEXAGON_V6_vsubb",
                    "V6.vsubb.128B" => "__builtin_HEXAGON_V6_vsubb_128B",
                    "V6.vsubb.dv" => "__builtin_HEXAGON_V6_vsubb_dv",
                    "V6.vsubb.dv.128B" => "__builtin_HEXAGON_V6_vsubb_dv_128B",
                    "V6.vsubbnq" => "__builtin_HEXAGON_V6_vsubbnq",
                    "V6.vsubbnq.128B" => "__builtin_HEXAGON_V6_vsubbnq_128B",
                    "V6.vsubbq" => "__builtin_HEXAGON_V6_vsubbq",
                    "V6.vsubbq.128B" => "__builtin_HEXAGON_V6_vsubbq_128B",
                    "V6.vsubbsat" => "__builtin_HEXAGON_V6_vsubbsat",
                    "V6.vsubbsat.128B" => "__builtin_HEXAGON_V6_vsubbsat_128B",
                    "V6.vsubbsat.dv" => "__builtin_HEXAGON_V6_vsubbsat_dv",
                    "V6.vsubbsat.dv.128B" => "__builtin_HEXAGON_V6_vsubbsat_dv_128B",
                    "V6.vsubh" => "__builtin_HEXAGON_V6_vsubh",
                    "V6.vsubh.128B" => "__builtin_HEXAGON_V6_vsubh_128B",
                    "V6.vsubh.dv" => "__builtin_HEXAGON_V6_vsubh_dv",
                    "V6.vsubh.dv.128B" => "__builtin_HEXAGON_V6_vsubh_dv_128B",
                    "V6.vsubhnq" => "__builtin_HEXAGON_V6_vsubhnq",
                    "V6.vsubhnq.128B" => "__builtin_HEXAGON_V6_vsubhnq_128B",
                    "V6.vsubhq" => "__builtin_HEXAGON_V6_vsubhq",
                    "V6.vsubhq.128B" => "__builtin_HEXAGON_V6_vsubhq_128B",
                    "V6.vsubhsat" => "__builtin_HEXAGON_V6_vsubhsat",
                    "V6.vsubhsat.128B" => "__builtin_HEXAGON_V6_vsubhsat_128B",
                    "V6.vsubhsat.dv" => "__builtin_HEXAGON_V6_vsubhsat_dv",
                    "V6.vsubhsat.dv.128B" => "__builtin_HEXAGON_V6_vsubhsat_dv_128B",
                    "V6.vsubhw" => "__builtin_HEXAGON_V6_vsubhw",
                    "V6.vsubhw.128B" => "__builtin_HEXAGON_V6_vsubhw_128B",
                    "V6.vsububh" => "__builtin_HEXAGON_V6_vsububh",
                    "V6.vsububh.128B" => "__builtin_HEXAGON_V6_vsububh_128B",
                    "V6.vsububsat" => "__builtin_HEXAGON_V6_vsububsat",
                    "V6.vsububsat.128B" => "__builtin_HEXAGON_V6_vsububsat_128B",
                    "V6.vsububsat.dv" => "__builtin_HEXAGON_V6_vsububsat_dv",
                    "V6.vsububsat.dv.128B" => "__builtin_HEXAGON_V6_vsububsat_dv_128B",
                    "V6.vsubububb.sat" => "__builtin_HEXAGON_V6_vsubububb_sat",
                    "V6.vsubububb.sat.128B" => "__builtin_HEXAGON_V6_vsubububb_sat_128B",
                    "V6.vsubuhsat" => "__builtin_HEXAGON_V6_vsubuhsat",
                    "V6.vsubuhsat.128B" => "__builtin_HEXAGON_V6_vsubuhsat_128B",
                    "V6.vsubuhsat.dv" => "__builtin_HEXAGON_V6_vsubuhsat_dv",
                    "V6.vsubuhsat.dv.128B" => "__builtin_HEXAGON_V6_vsubuhsat_dv_128B",
                    "V6.vsubuhw" => "__builtin_HEXAGON_V6_vsubuhw",
                    "V6.vsubuhw.128B" => "__builtin_HEXAGON_V6_vsubuhw_128B",
                    "V6.vsubuwsat" => "__builtin_HEXAGON_V6_vsubuwsat",
                    "V6.vsubuwsat.128B" => "__builtin_HEXAGON_V6_vsubuwsat_128B",
                    "V6.vsubuwsat.dv" => "__builtin_HEXAGON_V6_vsubuwsat_dv",
                    "V6.vsubuwsat.dv.128B" => "__builtin_HEXAGON_V6_vsubuwsat_dv_128B",
                    "V6.vsubw" => "__builtin_HEXAGON_V6_vsubw",
                    "V6.vsubw.128B" => "__builtin_HEXAGON_V6_vsubw_128B",
                    "V6.vsubw.dv" => "__builtin_HEXAGON_V6_vsubw_dv",
                    "V6.vsubw.dv.128B" => "__builtin_HEXAGON_V6_vsubw_dv_128B",
                    "V6.vsubwnq" => "__builtin_HEXAGON_V6_vsubwnq",
                    "V6.vsubwnq.128B" => "__builtin_HEXAGON_V6_vsubwnq_128B",
                    "V6.vsubwq" => "__builtin_HEXAGON_V6_vsubwq",
                    "V6.vsubwq.128B" => "__builtin_HEXAGON_V6_vsubwq_128B",
                    "V6.vsubwsat" => "__builtin_HEXAGON_V6_vsubwsat",
                    "V6.vsubwsat.128B" => "__builtin_HEXAGON_V6_vsubwsat_128B",
                    "V6.vsubwsat.dv" => "__builtin_HEXAGON_V6_vsubwsat_dv",
                    "V6.vsubwsat.dv.128B" => "__builtin_HEXAGON_V6_vsubwsat_dv_128B",
                    "V6.vswap" => "__builtin_HEXAGON_V6_vswap",
                    "V6.vswap.128B" => "__builtin_HEXAGON_V6_vswap_128B",
                    "V6.vtmpyb" => "__builtin_HEXAGON_V6_vtmpyb",
                    "V6.vtmpyb.128B" => "__builtin_HEXAGON_V6_vtmpyb_128B",
                    "V6.vtmpyb.acc" => "__builtin_HEXAGON_V6_vtmpyb_acc",
                    "V6.vtmpyb.acc.128B" => "__builtin_HEXAGON_V6_vtmpyb_acc_128B",
                    "V6.vtmpybus" => "__builtin_HEXAGON_V6_vtmpybus",
                    "V6.vtmpybus.128B" => "__builtin_HEXAGON_V6_vtmpybus_128B",
                    "V6.vtmpybus.acc" => "__builtin_HEXAGON_V6_vtmpybus_acc",
                    "V6.vtmpybus.acc.128B" => "__builtin_HEXAGON_V6_vtmpybus_acc_128B",
                    "V6.vtmpyhb" => "__builtin_HEXAGON_V6_vtmpyhb",
                    "V6.vtmpyhb.128B" => "__builtin_HEXAGON_V6_vtmpyhb_128B",
                    "V6.vtmpyhb.acc" => "__builtin_HEXAGON_V6_vtmpyhb_acc",
                    "V6.vtmpyhb.acc.128B" => "__builtin_HEXAGON_V6_vtmpyhb_acc_128B",
                    "V6.vunpackb" => "__builtin_HEXAGON_V6_vunpackb",
                    "V6.vunpackb.128B" => "__builtin_HEXAGON_V6_vunpackb_128B",
                    "V6.vunpackh" => "__builtin_HEXAGON_V6_vunpackh",
                    "V6.vunpackh.128B" => "__builtin_HEXAGON_V6_vunpackh_128B",
                    "V6.vunpackob" => "__builtin_HEXAGON_V6_vunpackob",
                    "V6.vunpackob.128B" => "__builtin_HEXAGON_V6_vunpackob_128B",
                    "V6.vunpackoh" => "__builtin_HEXAGON_V6_vunpackoh",
                    "V6.vunpackoh.128B" => "__builtin_HEXAGON_V6_vunpackoh_128B",
                    "V6.vunpackub" => "__builtin_HEXAGON_V6_vunpackub",
                    "V6.vunpackub.128B" => "__builtin_HEXAGON_V6_vunpackub_128B",
                    "V6.vunpackuh" => "__builtin_HEXAGON_V6_vunpackuh",
                    "V6.vunpackuh.128B" => "__builtin_HEXAGON_V6_vunpackuh_128B",
                    "V6.vxor" => "__builtin_HEXAGON_V6_vxor",
                    "V6.vxor.128B" => "__builtin_HEXAGON_V6_vxor_128B",
                    "V6.vzb" => "__builtin_HEXAGON_V6_vzb",
                    "V6.vzb.128B" => "__builtin_HEXAGON_V6_vzb_128B",
                    "V6.vzh" => "__builtin_HEXAGON_V6_vzh",
                    "V6.vzh.128B" => "__builtin_HEXAGON_V6_vzh_128B",
                    "Y2.dccleana" => "__builtin_HEXAGON_Y2_dccleana",
                    "Y2.dccleaninva" => "__builtin_HEXAGON_Y2_dccleaninva",
                    "Y2.dcfetch" => "__builtin_HEXAGON_Y2_dcfetch",
                    "Y2.dcinva" => "__builtin_HEXAGON_Y2_dcinva",
                    "Y2.dczeroa" => "__builtin_HEXAGON_Y2_dczeroa",
                    "Y4.l2fetch" => "__builtin_HEXAGON_Y4_l2fetch",
                    "Y5.l2fetch" => "__builtin_HEXAGON_Y5_l2fetch",
                    "Y6.dmlink" => "__builtin_HEXAGON_Y6_dmlink",
                    "Y6.dmpause" => "__builtin_HEXAGON_Y6_dmpause",
                    "Y6.dmpoll" => "__builtin_HEXAGON_Y6_dmpoll",
                    "Y6.dmresume" => "__builtin_HEXAGON_Y6_dmresume",
                    "Y6.dmstart" => "__builtin_HEXAGON_Y6_dmstart",
                    "Y6.dmwait" => "__builtin_HEXAGON_Y6_dmwait",
                    "brev.ldb" => "__builtin_brev_ldb",
                    "brev.ldd" => "__builtin_brev_ldd",
                    "brev.ldh" => "__builtin_brev_ldh",
                    "brev.ldub" => "__builtin_brev_ldub",
                    "brev.lduh" => "__builtin_brev_lduh",
                    "brev.ldw" => "__builtin_brev_ldw",
                    "brev.stb" => "__builtin_brev_stb",
                    "brev.std" => "__builtin_brev_std",
                    "brev.sth" => "__builtin_brev_sth",
                    "brev.sthhi" => "__builtin_brev_sthhi",
                    "brev.stw" => "__builtin_brev_stw",
                    "circ.ldb" => "__builtin_circ_ldb",
                    "circ.ldd" => "__builtin_circ_ldd",
                    "circ.ldh" => "__builtin_circ_ldh",
                    "circ.ldub" => "__builtin_circ_ldub",
                    "circ.lduh" => "__builtin_circ_lduh",
                    "circ.ldw" => "__builtin_circ_ldw",
                    "circ.stb" => "__builtin_circ_stb",
                    "circ.std" => "__builtin_circ_std",
                    "circ.sth" => "__builtin_circ_sth",
                    "circ.sthhi" => "__builtin_circ_sthhi",
                    "circ.stw" => "__builtin_circ_stw",
                    "mm256i.vaddw" => "__builtin__mm256i_vaddw",
                    "prefetch" => "__builtin_HEXAGON_prefetch",
                    "vmemcpy" => "__builtin_hexagon_vmemcpy",
                    "vmemset" => "__builtin_hexagon_vmemset",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            hexagon(name, full_name)
        }
        "loongarch" => {
            fn loongarch(name: &str, full_name: &str) -> &'static str {
                match name {
                    // loongarch
                    "asrtgt.d" => "__builtin_loongarch_asrtgt_d",
                    "asrtle.d" => "__builtin_loongarch_asrtle_d",
                    "break" => "__builtin_loongarch_break",
                    "cacop.d" => "__builtin_loongarch_cacop_d",
                    "cacop.w" => "__builtin_loongarch_cacop_w",
                    "cpucfg" => "__builtin_loongarch_cpucfg",
                    "crc.w.b.w" => "__builtin_loongarch_crc_w_b_w",
                    "crc.w.d.w" => "__builtin_loongarch_crc_w_d_w",
                    "crc.w.h.w" => "__builtin_loongarch_crc_w_h_w",
                    "crc.w.w.w" => "__builtin_loongarch_crc_w_w_w",
                    "crcc.w.b.w" => "__builtin_loongarch_crcc_w_b_w",
                    "crcc.w.d.w" => "__builtin_loongarch_crcc_w_d_w",
                    "crcc.w.h.w" => "__builtin_loongarch_crcc_w_h_w",
                    "crcc.w.w.w" => "__builtin_loongarch_crcc_w_w_w",
                    "csrrd.d" => "__builtin_loongarch_csrrd_d",
                    "csrrd.w" => "__builtin_loongarch_csrrd_w",
                    "csrwr.d" => "__builtin_loongarch_csrwr_d",
                    "csrwr.w" => "__builtin_loongarch_csrwr_w",
                    "csrxchg.d" => "__builtin_loongarch_csrxchg_d",
                    "csrxchg.w" => "__builtin_loongarch_csrxchg_w",
                    "dbar" => "__builtin_loongarch_dbar",
                    "frecipe.d" => "__builtin_loongarch_frecipe_d",
                    "frecipe.s" => "__builtin_loongarch_frecipe_s",
                    "frsqrte.d" => "__builtin_loongarch_frsqrte_d",
                    "frsqrte.s" => "__builtin_loongarch_frsqrte_s",
                    "ibar" => "__builtin_loongarch_ibar",
                    "iocsrrd.b" => "__builtin_loongarch_iocsrrd_b",
                    "iocsrrd.d" => "__builtin_loongarch_iocsrrd_d",
                    "iocsrrd.h" => "__builtin_loongarch_iocsrrd_h",
                    "iocsrrd.w" => "__builtin_loongarch_iocsrrd_w",
                    "iocsrwr.b" => "__builtin_loongarch_iocsrwr_b",
                    "iocsrwr.d" => "__builtin_loongarch_iocsrwr_d",
                    "iocsrwr.h" => "__builtin_loongarch_iocsrwr_h",
                    "iocsrwr.w" => "__builtin_loongarch_iocsrwr_w",
                    "lasx.cast.128" => "__builtin_lasx_cast_128",
                    "lasx.cast.128.d" => "__builtin_lasx_cast_128_d",
                    "lasx.cast.128.s" => "__builtin_lasx_cast_128_s",
                    "lasx.concat.128" => "__builtin_lasx_concat_128",
                    "lasx.concat.128.d" => "__builtin_lasx_concat_128_d",
                    "lasx.concat.128.s" => "__builtin_lasx_concat_128_s",
                    "lasx.extract.128.hi" => "__builtin_lasx_extract_128_hi",
                    "lasx.extract.128.hi.d" => "__builtin_lasx_extract_128_hi_d",
                    "lasx.extract.128.hi.s" => "__builtin_lasx_extract_128_hi_s",
                    "lasx.extract.128.lo" => "__builtin_lasx_extract_128_lo",
                    "lasx.extract.128.lo.d" => "__builtin_lasx_extract_128_lo_d",
                    "lasx.extract.128.lo.s" => "__builtin_lasx_extract_128_lo_s",
                    "lasx.insert.128.hi" => "__builtin_lasx_insert_128_hi",
                    "lasx.insert.128.hi.d" => "__builtin_lasx_insert_128_hi_d",
                    "lasx.insert.128.hi.s" => "__builtin_lasx_insert_128_hi_s",
                    "lasx.insert.128.lo" => "__builtin_lasx_insert_128_lo",
                    "lasx.insert.128.lo.d" => "__builtin_lasx_insert_128_lo_d",
                    "lasx.insert.128.lo.s" => "__builtin_lasx_insert_128_lo_s",
                    "lasx.vext2xv.d.b" => "__builtin_lasx_vext2xv_d_b",
                    "lasx.vext2xv.d.h" => "__builtin_lasx_vext2xv_d_h",
                    "lasx.vext2xv.d.w" => "__builtin_lasx_vext2xv_d_w",
                    "lasx.vext2xv.du.bu" => "__builtin_lasx_vext2xv_du_bu",
                    "lasx.vext2xv.du.hu" => "__builtin_lasx_vext2xv_du_hu",
                    "lasx.vext2xv.du.wu" => "__builtin_lasx_vext2xv_du_wu",
                    "lasx.vext2xv.h.b" => "__builtin_lasx_vext2xv_h_b",
                    "lasx.vext2xv.hu.bu" => "__builtin_lasx_vext2xv_hu_bu",
                    "lasx.vext2xv.w.b" => "__builtin_lasx_vext2xv_w_b",
                    "lasx.vext2xv.w.h" => "__builtin_lasx_vext2xv_w_h",
                    "lasx.vext2xv.wu.bu" => "__builtin_lasx_vext2xv_wu_bu",
                    "lasx.vext2xv.wu.hu" => "__builtin_lasx_vext2xv_wu_hu",
                    "lasx.xbnz.b" => "__builtin_lasx_xbnz_b",
                    "lasx.xbnz.d" => "__builtin_lasx_xbnz_d",
                    "lasx.xbnz.h" => "__builtin_lasx_xbnz_h",
                    "lasx.xbnz.v" => "__builtin_lasx_xbnz_v",
                    "lasx.xbnz.w" => "__builtin_lasx_xbnz_w",
                    "lasx.xbz.b" => "__builtin_lasx_xbz_b",
                    "lasx.xbz.d" => "__builtin_lasx_xbz_d",
                    "lasx.xbz.h" => "__builtin_lasx_xbz_h",
                    "lasx.xbz.v" => "__builtin_lasx_xbz_v",
                    "lasx.xbz.w" => "__builtin_lasx_xbz_w",
                    "lasx.xvabsd.b" => "__builtin_lasx_xvabsd_b",
                    "lasx.xvabsd.bu" => "__builtin_lasx_xvabsd_bu",
                    "lasx.xvabsd.d" => "__builtin_lasx_xvabsd_d",
                    "lasx.xvabsd.du" => "__builtin_lasx_xvabsd_du",
                    "lasx.xvabsd.h" => "__builtin_lasx_xvabsd_h",
                    "lasx.xvabsd.hu" => "__builtin_lasx_xvabsd_hu",
                    "lasx.xvabsd.w" => "__builtin_lasx_xvabsd_w",
                    "lasx.xvabsd.wu" => "__builtin_lasx_xvabsd_wu",
                    "lasx.xvadd.b" => "__builtin_lasx_xvadd_b",
                    "lasx.xvadd.d" => "__builtin_lasx_xvadd_d",
                    "lasx.xvadd.h" => "__builtin_lasx_xvadd_h",
                    "lasx.xvadd.q" => "__builtin_lasx_xvadd_q",
                    "lasx.xvadd.w" => "__builtin_lasx_xvadd_w",
                    "lasx.xvadda.b" => "__builtin_lasx_xvadda_b",
                    "lasx.xvadda.d" => "__builtin_lasx_xvadda_d",
                    "lasx.xvadda.h" => "__builtin_lasx_xvadda_h",
                    "lasx.xvadda.w" => "__builtin_lasx_xvadda_w",
                    "lasx.xvaddi.bu" => "__builtin_lasx_xvaddi_bu",
                    "lasx.xvaddi.du" => "__builtin_lasx_xvaddi_du",
                    "lasx.xvaddi.hu" => "__builtin_lasx_xvaddi_hu",
                    "lasx.xvaddi.wu" => "__builtin_lasx_xvaddi_wu",
                    "lasx.xvaddwev.d.w" => "__builtin_lasx_xvaddwev_d_w",
                    "lasx.xvaddwev.d.wu" => "__builtin_lasx_xvaddwev_d_wu",
                    "lasx.xvaddwev.d.wu.w" => "__builtin_lasx_xvaddwev_d_wu_w",
                    "lasx.xvaddwev.h.b" => "__builtin_lasx_xvaddwev_h_b",
                    "lasx.xvaddwev.h.bu" => "__builtin_lasx_xvaddwev_h_bu",
                    "lasx.xvaddwev.h.bu.b" => "__builtin_lasx_xvaddwev_h_bu_b",
                    "lasx.xvaddwev.q.d" => "__builtin_lasx_xvaddwev_q_d",
                    "lasx.xvaddwev.q.du" => "__builtin_lasx_xvaddwev_q_du",
                    "lasx.xvaddwev.q.du.d" => "__builtin_lasx_xvaddwev_q_du_d",
                    "lasx.xvaddwev.w.h" => "__builtin_lasx_xvaddwev_w_h",
                    "lasx.xvaddwev.w.hu" => "__builtin_lasx_xvaddwev_w_hu",
                    "lasx.xvaddwev.w.hu.h" => "__builtin_lasx_xvaddwev_w_hu_h",
                    "lasx.xvaddwod.d.w" => "__builtin_lasx_xvaddwod_d_w",
                    "lasx.xvaddwod.d.wu" => "__builtin_lasx_xvaddwod_d_wu",
                    "lasx.xvaddwod.d.wu.w" => "__builtin_lasx_xvaddwod_d_wu_w",
                    "lasx.xvaddwod.h.b" => "__builtin_lasx_xvaddwod_h_b",
                    "lasx.xvaddwod.h.bu" => "__builtin_lasx_xvaddwod_h_bu",
                    "lasx.xvaddwod.h.bu.b" => "__builtin_lasx_xvaddwod_h_bu_b",
                    "lasx.xvaddwod.q.d" => "__builtin_lasx_xvaddwod_q_d",
                    "lasx.xvaddwod.q.du" => "__builtin_lasx_xvaddwod_q_du",
                    "lasx.xvaddwod.q.du.d" => "__builtin_lasx_xvaddwod_q_du_d",
                    "lasx.xvaddwod.w.h" => "__builtin_lasx_xvaddwod_w_h",
                    "lasx.xvaddwod.w.hu" => "__builtin_lasx_xvaddwod_w_hu",
                    "lasx.xvaddwod.w.hu.h" => "__builtin_lasx_xvaddwod_w_hu_h",
                    "lasx.xvand.v" => "__builtin_lasx_xvand_v",
                    "lasx.xvandi.b" => "__builtin_lasx_xvandi_b",
                    "lasx.xvandn.v" => "__builtin_lasx_xvandn_v",
                    "lasx.xvavg.b" => "__builtin_lasx_xvavg_b",
                    "lasx.xvavg.bu" => "__builtin_lasx_xvavg_bu",
                    "lasx.xvavg.d" => "__builtin_lasx_xvavg_d",
                    "lasx.xvavg.du" => "__builtin_lasx_xvavg_du",
                    "lasx.xvavg.h" => "__builtin_lasx_xvavg_h",
                    "lasx.xvavg.hu" => "__builtin_lasx_xvavg_hu",
                    "lasx.xvavg.w" => "__builtin_lasx_xvavg_w",
                    "lasx.xvavg.wu" => "__builtin_lasx_xvavg_wu",
                    "lasx.xvavgr.b" => "__builtin_lasx_xvavgr_b",
                    "lasx.xvavgr.bu" => "__builtin_lasx_xvavgr_bu",
                    "lasx.xvavgr.d" => "__builtin_lasx_xvavgr_d",
                    "lasx.xvavgr.du" => "__builtin_lasx_xvavgr_du",
                    "lasx.xvavgr.h" => "__builtin_lasx_xvavgr_h",
                    "lasx.xvavgr.hu" => "__builtin_lasx_xvavgr_hu",
                    "lasx.xvavgr.w" => "__builtin_lasx_xvavgr_w",
                    "lasx.xvavgr.wu" => "__builtin_lasx_xvavgr_wu",
                    "lasx.xvbitclr.b" => "__builtin_lasx_xvbitclr_b",
                    "lasx.xvbitclr.d" => "__builtin_lasx_xvbitclr_d",
                    "lasx.xvbitclr.h" => "__builtin_lasx_xvbitclr_h",
                    "lasx.xvbitclr.w" => "__builtin_lasx_xvbitclr_w",
                    "lasx.xvbitclri.b" => "__builtin_lasx_xvbitclri_b",
                    "lasx.xvbitclri.d" => "__builtin_lasx_xvbitclri_d",
                    "lasx.xvbitclri.h" => "__builtin_lasx_xvbitclri_h",
                    "lasx.xvbitclri.w" => "__builtin_lasx_xvbitclri_w",
                    "lasx.xvbitrev.b" => "__builtin_lasx_xvbitrev_b",
                    "lasx.xvbitrev.d" => "__builtin_lasx_xvbitrev_d",
                    "lasx.xvbitrev.h" => "__builtin_lasx_xvbitrev_h",
                    "lasx.xvbitrev.w" => "__builtin_lasx_xvbitrev_w",
                    "lasx.xvbitrevi.b" => "__builtin_lasx_xvbitrevi_b",
                    "lasx.xvbitrevi.d" => "__builtin_lasx_xvbitrevi_d",
                    "lasx.xvbitrevi.h" => "__builtin_lasx_xvbitrevi_h",
                    "lasx.xvbitrevi.w" => "__builtin_lasx_xvbitrevi_w",
                    "lasx.xvbitsel.v" => "__builtin_lasx_xvbitsel_v",
                    "lasx.xvbitseli.b" => "__builtin_lasx_xvbitseli_b",
                    "lasx.xvbitset.b" => "__builtin_lasx_xvbitset_b",
                    "lasx.xvbitset.d" => "__builtin_lasx_xvbitset_d",
                    "lasx.xvbitset.h" => "__builtin_lasx_xvbitset_h",
                    "lasx.xvbitset.w" => "__builtin_lasx_xvbitset_w",
                    "lasx.xvbitseti.b" => "__builtin_lasx_xvbitseti_b",
                    "lasx.xvbitseti.d" => "__builtin_lasx_xvbitseti_d",
                    "lasx.xvbitseti.h" => "__builtin_lasx_xvbitseti_h",
                    "lasx.xvbitseti.w" => "__builtin_lasx_xvbitseti_w",
                    "lasx.xvbsll.v" => "__builtin_lasx_xvbsll_v",
                    "lasx.xvbsrl.v" => "__builtin_lasx_xvbsrl_v",
                    "lasx.xvclo.b" => "__builtin_lasx_xvclo_b",
                    "lasx.xvclo.d" => "__builtin_lasx_xvclo_d",
                    "lasx.xvclo.h" => "__builtin_lasx_xvclo_h",
                    "lasx.xvclo.w" => "__builtin_lasx_xvclo_w",
                    "lasx.xvclz.b" => "__builtin_lasx_xvclz_b",
                    "lasx.xvclz.d" => "__builtin_lasx_xvclz_d",
                    "lasx.xvclz.h" => "__builtin_lasx_xvclz_h",
                    "lasx.xvclz.w" => "__builtin_lasx_xvclz_w",
                    "lasx.xvdiv.b" => "__builtin_lasx_xvdiv_b",
                    "lasx.xvdiv.bu" => "__builtin_lasx_xvdiv_bu",
                    "lasx.xvdiv.d" => "__builtin_lasx_xvdiv_d",
                    "lasx.xvdiv.du" => "__builtin_lasx_xvdiv_du",
                    "lasx.xvdiv.h" => "__builtin_lasx_xvdiv_h",
                    "lasx.xvdiv.hu" => "__builtin_lasx_xvdiv_hu",
                    "lasx.xvdiv.w" => "__builtin_lasx_xvdiv_w",
                    "lasx.xvdiv.wu" => "__builtin_lasx_xvdiv_wu",
                    "lasx.xvexth.d.w" => "__builtin_lasx_xvexth_d_w",
                    "lasx.xvexth.du.wu" => "__builtin_lasx_xvexth_du_wu",
                    "lasx.xvexth.h.b" => "__builtin_lasx_xvexth_h_b",
                    "lasx.xvexth.hu.bu" => "__builtin_lasx_xvexth_hu_bu",
                    "lasx.xvexth.q.d" => "__builtin_lasx_xvexth_q_d",
                    "lasx.xvexth.qu.du" => "__builtin_lasx_xvexth_qu_du",
                    "lasx.xvexth.w.h" => "__builtin_lasx_xvexth_w_h",
                    "lasx.xvexth.wu.hu" => "__builtin_lasx_xvexth_wu_hu",
                    "lasx.xvextl.q.d" => "__builtin_lasx_xvextl_q_d",
                    "lasx.xvextl.qu.du" => "__builtin_lasx_xvextl_qu_du",
                    "lasx.xvextrins.b" => "__builtin_lasx_xvextrins_b",
                    "lasx.xvextrins.d" => "__builtin_lasx_xvextrins_d",
                    "lasx.xvextrins.h" => "__builtin_lasx_xvextrins_h",
                    "lasx.xvextrins.w" => "__builtin_lasx_xvextrins_w",
                    "lasx.xvfadd.d" => "__builtin_lasx_xvfadd_d",
                    "lasx.xvfadd.s" => "__builtin_lasx_xvfadd_s",
                    "lasx.xvfclass.d" => "__builtin_lasx_xvfclass_d",
                    "lasx.xvfclass.s" => "__builtin_lasx_xvfclass_s",
                    "lasx.xvfcmp.caf.d" => "__builtin_lasx_xvfcmp_caf_d",
                    "lasx.xvfcmp.caf.s" => "__builtin_lasx_xvfcmp_caf_s",
                    "lasx.xvfcmp.ceq.d" => "__builtin_lasx_xvfcmp_ceq_d",
                    "lasx.xvfcmp.ceq.s" => "__builtin_lasx_xvfcmp_ceq_s",
                    "lasx.xvfcmp.cle.d" => "__builtin_lasx_xvfcmp_cle_d",
                    "lasx.xvfcmp.cle.s" => "__builtin_lasx_xvfcmp_cle_s",
                    "lasx.xvfcmp.clt.d" => "__builtin_lasx_xvfcmp_clt_d",
                    "lasx.xvfcmp.clt.s" => "__builtin_lasx_xvfcmp_clt_s",
                    "lasx.xvfcmp.cne.d" => "__builtin_lasx_xvfcmp_cne_d",
                    "lasx.xvfcmp.cne.s" => "__builtin_lasx_xvfcmp_cne_s",
                    "lasx.xvfcmp.cor.d" => "__builtin_lasx_xvfcmp_cor_d",
                    "lasx.xvfcmp.cor.s" => "__builtin_lasx_xvfcmp_cor_s",
                    "lasx.xvfcmp.cueq.d" => "__builtin_lasx_xvfcmp_cueq_d",
                    "lasx.xvfcmp.cueq.s" => "__builtin_lasx_xvfcmp_cueq_s",
                    "lasx.xvfcmp.cule.d" => "__builtin_lasx_xvfcmp_cule_d",
                    "lasx.xvfcmp.cule.s" => "__builtin_lasx_xvfcmp_cule_s",
                    "lasx.xvfcmp.cult.d" => "__builtin_lasx_xvfcmp_cult_d",
                    "lasx.xvfcmp.cult.s" => "__builtin_lasx_xvfcmp_cult_s",
                    "lasx.xvfcmp.cun.d" => "__builtin_lasx_xvfcmp_cun_d",
                    "lasx.xvfcmp.cun.s" => "__builtin_lasx_xvfcmp_cun_s",
                    "lasx.xvfcmp.cune.d" => "__builtin_lasx_xvfcmp_cune_d",
                    "lasx.xvfcmp.cune.s" => "__builtin_lasx_xvfcmp_cune_s",
                    "lasx.xvfcmp.saf.d" => "__builtin_lasx_xvfcmp_saf_d",
                    "lasx.xvfcmp.saf.s" => "__builtin_lasx_xvfcmp_saf_s",
                    "lasx.xvfcmp.seq.d" => "__builtin_lasx_xvfcmp_seq_d",
                    "lasx.xvfcmp.seq.s" => "__builtin_lasx_xvfcmp_seq_s",
                    "lasx.xvfcmp.sle.d" => "__builtin_lasx_xvfcmp_sle_d",
                    "lasx.xvfcmp.sle.s" => "__builtin_lasx_xvfcmp_sle_s",
                    "lasx.xvfcmp.slt.d" => "__builtin_lasx_xvfcmp_slt_d",
                    "lasx.xvfcmp.slt.s" => "__builtin_lasx_xvfcmp_slt_s",
                    "lasx.xvfcmp.sne.d" => "__builtin_lasx_xvfcmp_sne_d",
                    "lasx.xvfcmp.sne.s" => "__builtin_lasx_xvfcmp_sne_s",
                    "lasx.xvfcmp.sor.d" => "__builtin_lasx_xvfcmp_sor_d",
                    "lasx.xvfcmp.sor.s" => "__builtin_lasx_xvfcmp_sor_s",
                    "lasx.xvfcmp.sueq.d" => "__builtin_lasx_xvfcmp_sueq_d",
                    "lasx.xvfcmp.sueq.s" => "__builtin_lasx_xvfcmp_sueq_s",
                    "lasx.xvfcmp.sule.d" => "__builtin_lasx_xvfcmp_sule_d",
                    "lasx.xvfcmp.sule.s" => "__builtin_lasx_xvfcmp_sule_s",
                    "lasx.xvfcmp.sult.d" => "__builtin_lasx_xvfcmp_sult_d",
                    "lasx.xvfcmp.sult.s" => "__builtin_lasx_xvfcmp_sult_s",
                    "lasx.xvfcmp.sun.d" => "__builtin_lasx_xvfcmp_sun_d",
                    "lasx.xvfcmp.sun.s" => "__builtin_lasx_xvfcmp_sun_s",
                    "lasx.xvfcmp.sune.d" => "__builtin_lasx_xvfcmp_sune_d",
                    "lasx.xvfcmp.sune.s" => "__builtin_lasx_xvfcmp_sune_s",
                    "lasx.xvfcvt.h.s" => "__builtin_lasx_xvfcvt_h_s",
                    "lasx.xvfcvt.s.d" => "__builtin_lasx_xvfcvt_s_d",
                    "lasx.xvfcvth.d.s" => "__builtin_lasx_xvfcvth_d_s",
                    "lasx.xvfcvth.s.h" => "__builtin_lasx_xvfcvth_s_h",
                    "lasx.xvfcvtl.d.s" => "__builtin_lasx_xvfcvtl_d_s",
                    "lasx.xvfcvtl.s.h" => "__builtin_lasx_xvfcvtl_s_h",
                    "lasx.xvfdiv.d" => "__builtin_lasx_xvfdiv_d",
                    "lasx.xvfdiv.s" => "__builtin_lasx_xvfdiv_s",
                    "lasx.xvffint.d.l" => "__builtin_lasx_xvffint_d_l",
                    "lasx.xvffint.d.lu" => "__builtin_lasx_xvffint_d_lu",
                    "lasx.xvffint.s.l" => "__builtin_lasx_xvffint_s_l",
                    "lasx.xvffint.s.w" => "__builtin_lasx_xvffint_s_w",
                    "lasx.xvffint.s.wu" => "__builtin_lasx_xvffint_s_wu",
                    "lasx.xvffinth.d.w" => "__builtin_lasx_xvffinth_d_w",
                    "lasx.xvffintl.d.w" => "__builtin_lasx_xvffintl_d_w",
                    "lasx.xvflogb.d" => "__builtin_lasx_xvflogb_d",
                    "lasx.xvflogb.s" => "__builtin_lasx_xvflogb_s",
                    "lasx.xvfmadd.d" => "__builtin_lasx_xvfmadd_d",
                    "lasx.xvfmadd.s" => "__builtin_lasx_xvfmadd_s",
                    "lasx.xvfmax.d" => "__builtin_lasx_xvfmax_d",
                    "lasx.xvfmax.s" => "__builtin_lasx_xvfmax_s",
                    "lasx.xvfmaxa.d" => "__builtin_lasx_xvfmaxa_d",
                    "lasx.xvfmaxa.s" => "__builtin_lasx_xvfmaxa_s",
                    "lasx.xvfmin.d" => "__builtin_lasx_xvfmin_d",
                    "lasx.xvfmin.s" => "__builtin_lasx_xvfmin_s",
                    "lasx.xvfmina.d" => "__builtin_lasx_xvfmina_d",
                    "lasx.xvfmina.s" => "__builtin_lasx_xvfmina_s",
                    "lasx.xvfmsub.d" => "__builtin_lasx_xvfmsub_d",
                    "lasx.xvfmsub.s" => "__builtin_lasx_xvfmsub_s",
                    "lasx.xvfmul.d" => "__builtin_lasx_xvfmul_d",
                    "lasx.xvfmul.s" => "__builtin_lasx_xvfmul_s",
                    "lasx.xvfnmadd.d" => "__builtin_lasx_xvfnmadd_d",
                    "lasx.xvfnmadd.s" => "__builtin_lasx_xvfnmadd_s",
                    "lasx.xvfnmsub.d" => "__builtin_lasx_xvfnmsub_d",
                    "lasx.xvfnmsub.s" => "__builtin_lasx_xvfnmsub_s",
                    "lasx.xvfrecip.d" => "__builtin_lasx_xvfrecip_d",
                    "lasx.xvfrecip.s" => "__builtin_lasx_xvfrecip_s",
                    "lasx.xvfrecipe.d" => "__builtin_lasx_xvfrecipe_d",
                    "lasx.xvfrecipe.s" => "__builtin_lasx_xvfrecipe_s",
                    "lasx.xvfrint.d" => "__builtin_lasx_xvfrint_d",
                    "lasx.xvfrint.s" => "__builtin_lasx_xvfrint_s",
                    "lasx.xvfrintrm.d" => "__builtin_lasx_xvfrintrm_d",
                    "lasx.xvfrintrm.s" => "__builtin_lasx_xvfrintrm_s",
                    "lasx.xvfrintrne.d" => "__builtin_lasx_xvfrintrne_d",
                    "lasx.xvfrintrne.s" => "__builtin_lasx_xvfrintrne_s",
                    "lasx.xvfrintrp.d" => "__builtin_lasx_xvfrintrp_d",
                    "lasx.xvfrintrp.s" => "__builtin_lasx_xvfrintrp_s",
                    "lasx.xvfrintrz.d" => "__builtin_lasx_xvfrintrz_d",
                    "lasx.xvfrintrz.s" => "__builtin_lasx_xvfrintrz_s",
                    "lasx.xvfrsqrt.d" => "__builtin_lasx_xvfrsqrt_d",
                    "lasx.xvfrsqrt.s" => "__builtin_lasx_xvfrsqrt_s",
                    "lasx.xvfrsqrte.d" => "__builtin_lasx_xvfrsqrte_d",
                    "lasx.xvfrsqrte.s" => "__builtin_lasx_xvfrsqrte_s",
                    "lasx.xvfrstp.b" => "__builtin_lasx_xvfrstp_b",
                    "lasx.xvfrstp.h" => "__builtin_lasx_xvfrstp_h",
                    "lasx.xvfrstpi.b" => "__builtin_lasx_xvfrstpi_b",
                    "lasx.xvfrstpi.h" => "__builtin_lasx_xvfrstpi_h",
                    "lasx.xvfsqrt.d" => "__builtin_lasx_xvfsqrt_d",
                    "lasx.xvfsqrt.s" => "__builtin_lasx_xvfsqrt_s",
                    "lasx.xvfsub.d" => "__builtin_lasx_xvfsub_d",
                    "lasx.xvfsub.s" => "__builtin_lasx_xvfsub_s",
                    "lasx.xvftint.l.d" => "__builtin_lasx_xvftint_l_d",
                    "lasx.xvftint.lu.d" => "__builtin_lasx_xvftint_lu_d",
                    "lasx.xvftint.w.d" => "__builtin_lasx_xvftint_w_d",
                    "lasx.xvftint.w.s" => "__builtin_lasx_xvftint_w_s",
                    "lasx.xvftint.wu.s" => "__builtin_lasx_xvftint_wu_s",
                    "lasx.xvftinth.l.s" => "__builtin_lasx_xvftinth_l_s",
                    "lasx.xvftintl.l.s" => "__builtin_lasx_xvftintl_l_s",
                    "lasx.xvftintrm.l.d" => "__builtin_lasx_xvftintrm_l_d",
                    "lasx.xvftintrm.w.d" => "__builtin_lasx_xvftintrm_w_d",
                    "lasx.xvftintrm.w.s" => "__builtin_lasx_xvftintrm_w_s",
                    "lasx.xvftintrmh.l.s" => "__builtin_lasx_xvftintrmh_l_s",
                    "lasx.xvftintrml.l.s" => "__builtin_lasx_xvftintrml_l_s",
                    "lasx.xvftintrne.l.d" => "__builtin_lasx_xvftintrne_l_d",
                    "lasx.xvftintrne.w.d" => "__builtin_lasx_xvftintrne_w_d",
                    "lasx.xvftintrne.w.s" => "__builtin_lasx_xvftintrne_w_s",
                    "lasx.xvftintrneh.l.s" => "__builtin_lasx_xvftintrneh_l_s",
                    "lasx.xvftintrnel.l.s" => "__builtin_lasx_xvftintrnel_l_s",
                    "lasx.xvftintrp.l.d" => "__builtin_lasx_xvftintrp_l_d",
                    "lasx.xvftintrp.w.d" => "__builtin_lasx_xvftintrp_w_d",
                    "lasx.xvftintrp.w.s" => "__builtin_lasx_xvftintrp_w_s",
                    "lasx.xvftintrph.l.s" => "__builtin_lasx_xvftintrph_l_s",
                    "lasx.xvftintrpl.l.s" => "__builtin_lasx_xvftintrpl_l_s",
                    "lasx.xvftintrz.l.d" => "__builtin_lasx_xvftintrz_l_d",
                    "lasx.xvftintrz.lu.d" => "__builtin_lasx_xvftintrz_lu_d",
                    "lasx.xvftintrz.w.d" => "__builtin_lasx_xvftintrz_w_d",
                    "lasx.xvftintrz.w.s" => "__builtin_lasx_xvftintrz_w_s",
                    "lasx.xvftintrz.wu.s" => "__builtin_lasx_xvftintrz_wu_s",
                    "lasx.xvftintrzh.l.s" => "__builtin_lasx_xvftintrzh_l_s",
                    "lasx.xvftintrzl.l.s" => "__builtin_lasx_xvftintrzl_l_s",
                    "lasx.xvhaddw.d.w" => "__builtin_lasx_xvhaddw_d_w",
                    "lasx.xvhaddw.du.wu" => "__builtin_lasx_xvhaddw_du_wu",
                    "lasx.xvhaddw.h.b" => "__builtin_lasx_xvhaddw_h_b",
                    "lasx.xvhaddw.hu.bu" => "__builtin_lasx_xvhaddw_hu_bu",
                    "lasx.xvhaddw.q.d" => "__builtin_lasx_xvhaddw_q_d",
                    "lasx.xvhaddw.qu.du" => "__builtin_lasx_xvhaddw_qu_du",
                    "lasx.xvhaddw.w.h" => "__builtin_lasx_xvhaddw_w_h",
                    "lasx.xvhaddw.wu.hu" => "__builtin_lasx_xvhaddw_wu_hu",
                    "lasx.xvhsubw.d.w" => "__builtin_lasx_xvhsubw_d_w",
                    "lasx.xvhsubw.du.wu" => "__builtin_lasx_xvhsubw_du_wu",
                    "lasx.xvhsubw.h.b" => "__builtin_lasx_xvhsubw_h_b",
                    "lasx.xvhsubw.hu.bu" => "__builtin_lasx_xvhsubw_hu_bu",
                    "lasx.xvhsubw.q.d" => "__builtin_lasx_xvhsubw_q_d",
                    "lasx.xvhsubw.qu.du" => "__builtin_lasx_xvhsubw_qu_du",
                    "lasx.xvhsubw.w.h" => "__builtin_lasx_xvhsubw_w_h",
                    "lasx.xvhsubw.wu.hu" => "__builtin_lasx_xvhsubw_wu_hu",
                    "lasx.xvilvh.b" => "__builtin_lasx_xvilvh_b",
                    "lasx.xvilvh.d" => "__builtin_lasx_xvilvh_d",
                    "lasx.xvilvh.h" => "__builtin_lasx_xvilvh_h",
                    "lasx.xvilvh.w" => "__builtin_lasx_xvilvh_w",
                    "lasx.xvilvl.b" => "__builtin_lasx_xvilvl_b",
                    "lasx.xvilvl.d" => "__builtin_lasx_xvilvl_d",
                    "lasx.xvilvl.h" => "__builtin_lasx_xvilvl_h",
                    "lasx.xvilvl.w" => "__builtin_lasx_xvilvl_w",
                    "lasx.xvinsgr2vr.d" => "__builtin_lasx_xvinsgr2vr_d",
                    "lasx.xvinsgr2vr.w" => "__builtin_lasx_xvinsgr2vr_w",
                    "lasx.xvinsve0.d" => "__builtin_lasx_xvinsve0_d",
                    "lasx.xvinsve0.w" => "__builtin_lasx_xvinsve0_w",
                    "lasx.xvld" => "__builtin_lasx_xvld",
                    "lasx.xvldi" => "__builtin_lasx_xvldi",
                    "lasx.xvldrepl.b" => "__builtin_lasx_xvldrepl_b",
                    "lasx.xvldrepl.d" => "__builtin_lasx_xvldrepl_d",
                    "lasx.xvldrepl.h" => "__builtin_lasx_xvldrepl_h",
                    "lasx.xvldrepl.w" => "__builtin_lasx_xvldrepl_w",
                    "lasx.xvldx" => "__builtin_lasx_xvldx",
                    "lasx.xvmadd.b" => "__builtin_lasx_xvmadd_b",
                    "lasx.xvmadd.d" => "__builtin_lasx_xvmadd_d",
                    "lasx.xvmadd.h" => "__builtin_lasx_xvmadd_h",
                    "lasx.xvmadd.w" => "__builtin_lasx_xvmadd_w",
                    "lasx.xvmaddwev.d.w" => "__builtin_lasx_xvmaddwev_d_w",
                    "lasx.xvmaddwev.d.wu" => "__builtin_lasx_xvmaddwev_d_wu",
                    "lasx.xvmaddwev.d.wu.w" => "__builtin_lasx_xvmaddwev_d_wu_w",
                    "lasx.xvmaddwev.h.b" => "__builtin_lasx_xvmaddwev_h_b",
                    "lasx.xvmaddwev.h.bu" => "__builtin_lasx_xvmaddwev_h_bu",
                    "lasx.xvmaddwev.h.bu.b" => "__builtin_lasx_xvmaddwev_h_bu_b",
                    "lasx.xvmaddwev.q.d" => "__builtin_lasx_xvmaddwev_q_d",
                    "lasx.xvmaddwev.q.du" => "__builtin_lasx_xvmaddwev_q_du",
                    "lasx.xvmaddwev.q.du.d" => "__builtin_lasx_xvmaddwev_q_du_d",
                    "lasx.xvmaddwev.w.h" => "__builtin_lasx_xvmaddwev_w_h",
                    "lasx.xvmaddwev.w.hu" => "__builtin_lasx_xvmaddwev_w_hu",
                    "lasx.xvmaddwev.w.hu.h" => "__builtin_lasx_xvmaddwev_w_hu_h",
                    "lasx.xvmaddwod.d.w" => "__builtin_lasx_xvmaddwod_d_w",
                    "lasx.xvmaddwod.d.wu" => "__builtin_lasx_xvmaddwod_d_wu",
                    "lasx.xvmaddwod.d.wu.w" => "__builtin_lasx_xvmaddwod_d_wu_w",
                    "lasx.xvmaddwod.h.b" => "__builtin_lasx_xvmaddwod_h_b",
                    "lasx.xvmaddwod.h.bu" => "__builtin_lasx_xvmaddwod_h_bu",
                    "lasx.xvmaddwod.h.bu.b" => "__builtin_lasx_xvmaddwod_h_bu_b",
                    "lasx.xvmaddwod.q.d" => "__builtin_lasx_xvmaddwod_q_d",
                    "lasx.xvmaddwod.q.du" => "__builtin_lasx_xvmaddwod_q_du",
                    "lasx.xvmaddwod.q.du.d" => "__builtin_lasx_xvmaddwod_q_du_d",
                    "lasx.xvmaddwod.w.h" => "__builtin_lasx_xvmaddwod_w_h",
                    "lasx.xvmaddwod.w.hu" => "__builtin_lasx_xvmaddwod_w_hu",
                    "lasx.xvmaddwod.w.hu.h" => "__builtin_lasx_xvmaddwod_w_hu_h",
                    "lasx.xvmax.b" => "__builtin_lasx_xvmax_b",
                    "lasx.xvmax.bu" => "__builtin_lasx_xvmax_bu",
                    "lasx.xvmax.d" => "__builtin_lasx_xvmax_d",
                    "lasx.xvmax.du" => "__builtin_lasx_xvmax_du",
                    "lasx.xvmax.h" => "__builtin_lasx_xvmax_h",
                    "lasx.xvmax.hu" => "__builtin_lasx_xvmax_hu",
                    "lasx.xvmax.w" => "__builtin_lasx_xvmax_w",
                    "lasx.xvmax.wu" => "__builtin_lasx_xvmax_wu",
                    "lasx.xvmaxi.b" => "__builtin_lasx_xvmaxi_b",
                    "lasx.xvmaxi.bu" => "__builtin_lasx_xvmaxi_bu",
                    "lasx.xvmaxi.d" => "__builtin_lasx_xvmaxi_d",
                    "lasx.xvmaxi.du" => "__builtin_lasx_xvmaxi_du",
                    "lasx.xvmaxi.h" => "__builtin_lasx_xvmaxi_h",
                    "lasx.xvmaxi.hu" => "__builtin_lasx_xvmaxi_hu",
                    "lasx.xvmaxi.w" => "__builtin_lasx_xvmaxi_w",
                    "lasx.xvmaxi.wu" => "__builtin_lasx_xvmaxi_wu",
                    "lasx.xvmin.b" => "__builtin_lasx_xvmin_b",
                    "lasx.xvmin.bu" => "__builtin_lasx_xvmin_bu",
                    "lasx.xvmin.d" => "__builtin_lasx_xvmin_d",
                    "lasx.xvmin.du" => "__builtin_lasx_xvmin_du",
                    "lasx.xvmin.h" => "__builtin_lasx_xvmin_h",
                    "lasx.xvmin.hu" => "__builtin_lasx_xvmin_hu",
                    "lasx.xvmin.w" => "__builtin_lasx_xvmin_w",
                    "lasx.xvmin.wu" => "__builtin_lasx_xvmin_wu",
                    "lasx.xvmini.b" => "__builtin_lasx_xvmini_b",
                    "lasx.xvmini.bu" => "__builtin_lasx_xvmini_bu",
                    "lasx.xvmini.d" => "__builtin_lasx_xvmini_d",
                    "lasx.xvmini.du" => "__builtin_lasx_xvmini_du",
                    "lasx.xvmini.h" => "__builtin_lasx_xvmini_h",
                    "lasx.xvmini.hu" => "__builtin_lasx_xvmini_hu",
                    "lasx.xvmini.w" => "__builtin_lasx_xvmini_w",
                    "lasx.xvmini.wu" => "__builtin_lasx_xvmini_wu",
                    "lasx.xvmod.b" => "__builtin_lasx_xvmod_b",
                    "lasx.xvmod.bu" => "__builtin_lasx_xvmod_bu",
                    "lasx.xvmod.d" => "__builtin_lasx_xvmod_d",
                    "lasx.xvmod.du" => "__builtin_lasx_xvmod_du",
                    "lasx.xvmod.h" => "__builtin_lasx_xvmod_h",
                    "lasx.xvmod.hu" => "__builtin_lasx_xvmod_hu",
                    "lasx.xvmod.w" => "__builtin_lasx_xvmod_w",
                    "lasx.xvmod.wu" => "__builtin_lasx_xvmod_wu",
                    "lasx.xvmskgez.b" => "__builtin_lasx_xvmskgez_b",
                    "lasx.xvmskltz.b" => "__builtin_lasx_xvmskltz_b",
                    "lasx.xvmskltz.d" => "__builtin_lasx_xvmskltz_d",
                    "lasx.xvmskltz.h" => "__builtin_lasx_xvmskltz_h",
                    "lasx.xvmskltz.w" => "__builtin_lasx_xvmskltz_w",
                    "lasx.xvmsknz.b" => "__builtin_lasx_xvmsknz_b",
                    "lasx.xvmsub.b" => "__builtin_lasx_xvmsub_b",
                    "lasx.xvmsub.d" => "__builtin_lasx_xvmsub_d",
                    "lasx.xvmsub.h" => "__builtin_lasx_xvmsub_h",
                    "lasx.xvmsub.w" => "__builtin_lasx_xvmsub_w",
                    "lasx.xvmuh.b" => "__builtin_lasx_xvmuh_b",
                    "lasx.xvmuh.bu" => "__builtin_lasx_xvmuh_bu",
                    "lasx.xvmuh.d" => "__builtin_lasx_xvmuh_d",
                    "lasx.xvmuh.du" => "__builtin_lasx_xvmuh_du",
                    "lasx.xvmuh.h" => "__builtin_lasx_xvmuh_h",
                    "lasx.xvmuh.hu" => "__builtin_lasx_xvmuh_hu",
                    "lasx.xvmuh.w" => "__builtin_lasx_xvmuh_w",
                    "lasx.xvmuh.wu" => "__builtin_lasx_xvmuh_wu",
                    "lasx.xvmul.b" => "__builtin_lasx_xvmul_b",
                    "lasx.xvmul.d" => "__builtin_lasx_xvmul_d",
                    "lasx.xvmul.h" => "__builtin_lasx_xvmul_h",
                    "lasx.xvmul.w" => "__builtin_lasx_xvmul_w",
                    "lasx.xvmulwev.d.w" => "__builtin_lasx_xvmulwev_d_w",
                    "lasx.xvmulwev.d.wu" => "__builtin_lasx_xvmulwev_d_wu",
                    "lasx.xvmulwev.d.wu.w" => "__builtin_lasx_xvmulwev_d_wu_w",
                    "lasx.xvmulwev.h.b" => "__builtin_lasx_xvmulwev_h_b",
                    "lasx.xvmulwev.h.bu" => "__builtin_lasx_xvmulwev_h_bu",
                    "lasx.xvmulwev.h.bu.b" => "__builtin_lasx_xvmulwev_h_bu_b",
                    "lasx.xvmulwev.q.d" => "__builtin_lasx_xvmulwev_q_d",
                    "lasx.xvmulwev.q.du" => "__builtin_lasx_xvmulwev_q_du",
                    "lasx.xvmulwev.q.du.d" => "__builtin_lasx_xvmulwev_q_du_d",
                    "lasx.xvmulwev.w.h" => "__builtin_lasx_xvmulwev_w_h",
                    "lasx.xvmulwev.w.hu" => "__builtin_lasx_xvmulwev_w_hu",
                    "lasx.xvmulwev.w.hu.h" => "__builtin_lasx_xvmulwev_w_hu_h",
                    "lasx.xvmulwod.d.w" => "__builtin_lasx_xvmulwod_d_w",
                    "lasx.xvmulwod.d.wu" => "__builtin_lasx_xvmulwod_d_wu",
                    "lasx.xvmulwod.d.wu.w" => "__builtin_lasx_xvmulwod_d_wu_w",
                    "lasx.xvmulwod.h.b" => "__builtin_lasx_xvmulwod_h_b",
                    "lasx.xvmulwod.h.bu" => "__builtin_lasx_xvmulwod_h_bu",
                    "lasx.xvmulwod.h.bu.b" => "__builtin_lasx_xvmulwod_h_bu_b",
                    "lasx.xvmulwod.q.d" => "__builtin_lasx_xvmulwod_q_d",
                    "lasx.xvmulwod.q.du" => "__builtin_lasx_xvmulwod_q_du",
                    "lasx.xvmulwod.q.du.d" => "__builtin_lasx_xvmulwod_q_du_d",
                    "lasx.xvmulwod.w.h" => "__builtin_lasx_xvmulwod_w_h",
                    "lasx.xvmulwod.w.hu" => "__builtin_lasx_xvmulwod_w_hu",
                    "lasx.xvmulwod.w.hu.h" => "__builtin_lasx_xvmulwod_w_hu_h",
                    "lasx.xvneg.b" => "__builtin_lasx_xvneg_b",
                    "lasx.xvneg.d" => "__builtin_lasx_xvneg_d",
                    "lasx.xvneg.h" => "__builtin_lasx_xvneg_h",
                    "lasx.xvneg.w" => "__builtin_lasx_xvneg_w",
                    "lasx.xvnor.v" => "__builtin_lasx_xvnor_v",
                    "lasx.xvnori.b" => "__builtin_lasx_xvnori_b",
                    "lasx.xvor.v" => "__builtin_lasx_xvor_v",
                    "lasx.xvori.b" => "__builtin_lasx_xvori_b",
                    "lasx.xvorn.v" => "__builtin_lasx_xvorn_v",
                    "lasx.xvpackev.b" => "__builtin_lasx_xvpackev_b",
                    "lasx.xvpackev.d" => "__builtin_lasx_xvpackev_d",
                    "lasx.xvpackev.h" => "__builtin_lasx_xvpackev_h",
                    "lasx.xvpackev.w" => "__builtin_lasx_xvpackev_w",
                    "lasx.xvpackod.b" => "__builtin_lasx_xvpackod_b",
                    "lasx.xvpackod.d" => "__builtin_lasx_xvpackod_d",
                    "lasx.xvpackod.h" => "__builtin_lasx_xvpackod_h",
                    "lasx.xvpackod.w" => "__builtin_lasx_xvpackod_w",
                    "lasx.xvpcnt.b" => "__builtin_lasx_xvpcnt_b",
                    "lasx.xvpcnt.d" => "__builtin_lasx_xvpcnt_d",
                    "lasx.xvpcnt.h" => "__builtin_lasx_xvpcnt_h",
                    "lasx.xvpcnt.w" => "__builtin_lasx_xvpcnt_w",
                    "lasx.xvperm.w" => "__builtin_lasx_xvperm_w",
                    "lasx.xvpermi.d" => "__builtin_lasx_xvpermi_d",
                    "lasx.xvpermi.q" => "__builtin_lasx_xvpermi_q",
                    "lasx.xvpermi.w" => "__builtin_lasx_xvpermi_w",
                    "lasx.xvpickev.b" => "__builtin_lasx_xvpickev_b",
                    "lasx.xvpickev.d" => "__builtin_lasx_xvpickev_d",
                    "lasx.xvpickev.h" => "__builtin_lasx_xvpickev_h",
                    "lasx.xvpickev.w" => "__builtin_lasx_xvpickev_w",
                    "lasx.xvpickod.b" => "__builtin_lasx_xvpickod_b",
                    "lasx.xvpickod.d" => "__builtin_lasx_xvpickod_d",
                    "lasx.xvpickod.h" => "__builtin_lasx_xvpickod_h",
                    "lasx.xvpickod.w" => "__builtin_lasx_xvpickod_w",
                    "lasx.xvpickve.d" => "__builtin_lasx_xvpickve_d",
                    "lasx.xvpickve.d.f" => "__builtin_lasx_xvpickve_d_f",
                    "lasx.xvpickve.w" => "__builtin_lasx_xvpickve_w",
                    "lasx.xvpickve.w.f" => "__builtin_lasx_xvpickve_w_f",
                    "lasx.xvpickve2gr.d" => "__builtin_lasx_xvpickve2gr_d",
                    "lasx.xvpickve2gr.du" => "__builtin_lasx_xvpickve2gr_du",
                    "lasx.xvpickve2gr.w" => "__builtin_lasx_xvpickve2gr_w",
                    "lasx.xvpickve2gr.wu" => "__builtin_lasx_xvpickve2gr_wu",
                    "lasx.xvrepl128vei.b" => "__builtin_lasx_xvrepl128vei_b",
                    "lasx.xvrepl128vei.d" => "__builtin_lasx_xvrepl128vei_d",
                    "lasx.xvrepl128vei.h" => "__builtin_lasx_xvrepl128vei_h",
                    "lasx.xvrepl128vei.w" => "__builtin_lasx_xvrepl128vei_w",
                    "lasx.xvreplgr2vr.b" => "__builtin_lasx_xvreplgr2vr_b",
                    "lasx.xvreplgr2vr.d" => "__builtin_lasx_xvreplgr2vr_d",
                    "lasx.xvreplgr2vr.h" => "__builtin_lasx_xvreplgr2vr_h",
                    "lasx.xvreplgr2vr.w" => "__builtin_lasx_xvreplgr2vr_w",
                    "lasx.xvrepli.b" => "__builtin_lasx_xvrepli_b",
                    "lasx.xvrepli.d" => "__builtin_lasx_xvrepli_d",
                    "lasx.xvrepli.h" => "__builtin_lasx_xvrepli_h",
                    "lasx.xvrepli.w" => "__builtin_lasx_xvrepli_w",
                    "lasx.xvreplve.b" => "__builtin_lasx_xvreplve_b",
                    "lasx.xvreplve.d" => "__builtin_lasx_xvreplve_d",
                    "lasx.xvreplve.h" => "__builtin_lasx_xvreplve_h",
                    "lasx.xvreplve.w" => "__builtin_lasx_xvreplve_w",
                    "lasx.xvreplve0.b" => "__builtin_lasx_xvreplve0_b",
                    "lasx.xvreplve0.d" => "__builtin_lasx_xvreplve0_d",
                    "lasx.xvreplve0.h" => "__builtin_lasx_xvreplve0_h",
                    "lasx.xvreplve0.q" => "__builtin_lasx_xvreplve0_q",
                    "lasx.xvreplve0.w" => "__builtin_lasx_xvreplve0_w",
                    "lasx.xvrotr.b" => "__builtin_lasx_xvrotr_b",
                    "lasx.xvrotr.d" => "__builtin_lasx_xvrotr_d",
                    "lasx.xvrotr.h" => "__builtin_lasx_xvrotr_h",
                    "lasx.xvrotr.w" => "__builtin_lasx_xvrotr_w",
                    "lasx.xvrotri.b" => "__builtin_lasx_xvrotri_b",
                    "lasx.xvrotri.d" => "__builtin_lasx_xvrotri_d",
                    "lasx.xvrotri.h" => "__builtin_lasx_xvrotri_h",
                    "lasx.xvrotri.w" => "__builtin_lasx_xvrotri_w",
                    "lasx.xvsadd.b" => "__builtin_lasx_xvsadd_b",
                    "lasx.xvsadd.bu" => "__builtin_lasx_xvsadd_bu",
                    "lasx.xvsadd.d" => "__builtin_lasx_xvsadd_d",
                    "lasx.xvsadd.du" => "__builtin_lasx_xvsadd_du",
                    "lasx.xvsadd.h" => "__builtin_lasx_xvsadd_h",
                    "lasx.xvsadd.hu" => "__builtin_lasx_xvsadd_hu",
                    "lasx.xvsadd.w" => "__builtin_lasx_xvsadd_w",
                    "lasx.xvsadd.wu" => "__builtin_lasx_xvsadd_wu",
                    "lasx.xvsat.b" => "__builtin_lasx_xvsat_b",
                    "lasx.xvsat.bu" => "__builtin_lasx_xvsat_bu",
                    "lasx.xvsat.d" => "__builtin_lasx_xvsat_d",
                    "lasx.xvsat.du" => "__builtin_lasx_xvsat_du",
                    "lasx.xvsat.h" => "__builtin_lasx_xvsat_h",
                    "lasx.xvsat.hu" => "__builtin_lasx_xvsat_hu",
                    "lasx.xvsat.w" => "__builtin_lasx_xvsat_w",
                    "lasx.xvsat.wu" => "__builtin_lasx_xvsat_wu",
                    "lasx.xvseq.b" => "__builtin_lasx_xvseq_b",
                    "lasx.xvseq.d" => "__builtin_lasx_xvseq_d",
                    "lasx.xvseq.h" => "__builtin_lasx_xvseq_h",
                    "lasx.xvseq.w" => "__builtin_lasx_xvseq_w",
                    "lasx.xvseqi.b" => "__builtin_lasx_xvseqi_b",
                    "lasx.xvseqi.d" => "__builtin_lasx_xvseqi_d",
                    "lasx.xvseqi.h" => "__builtin_lasx_xvseqi_h",
                    "lasx.xvseqi.w" => "__builtin_lasx_xvseqi_w",
                    "lasx.xvshuf.b" => "__builtin_lasx_xvshuf_b",
                    "lasx.xvshuf.d" => "__builtin_lasx_xvshuf_d",
                    "lasx.xvshuf.h" => "__builtin_lasx_xvshuf_h",
                    "lasx.xvshuf.w" => "__builtin_lasx_xvshuf_w",
                    "lasx.xvshuf4i.b" => "__builtin_lasx_xvshuf4i_b",
                    "lasx.xvshuf4i.d" => "__builtin_lasx_xvshuf4i_d",
                    "lasx.xvshuf4i.h" => "__builtin_lasx_xvshuf4i_h",
                    "lasx.xvshuf4i.w" => "__builtin_lasx_xvshuf4i_w",
                    "lasx.xvsigncov.b" => "__builtin_lasx_xvsigncov_b",
                    "lasx.xvsigncov.d" => "__builtin_lasx_xvsigncov_d",
                    "lasx.xvsigncov.h" => "__builtin_lasx_xvsigncov_h",
                    "lasx.xvsigncov.w" => "__builtin_lasx_xvsigncov_w",
                    "lasx.xvsle.b" => "__builtin_lasx_xvsle_b",
                    "lasx.xvsle.bu" => "__builtin_lasx_xvsle_bu",
                    "lasx.xvsle.d" => "__builtin_lasx_xvsle_d",
                    "lasx.xvsle.du" => "__builtin_lasx_xvsle_du",
                    "lasx.xvsle.h" => "__builtin_lasx_xvsle_h",
                    "lasx.xvsle.hu" => "__builtin_lasx_xvsle_hu",
                    "lasx.xvsle.w" => "__builtin_lasx_xvsle_w",
                    "lasx.xvsle.wu" => "__builtin_lasx_xvsle_wu",
                    "lasx.xvslei.b" => "__builtin_lasx_xvslei_b",
                    "lasx.xvslei.bu" => "__builtin_lasx_xvslei_bu",
                    "lasx.xvslei.d" => "__builtin_lasx_xvslei_d",
                    "lasx.xvslei.du" => "__builtin_lasx_xvslei_du",
                    "lasx.xvslei.h" => "__builtin_lasx_xvslei_h",
                    "lasx.xvslei.hu" => "__builtin_lasx_xvslei_hu",
                    "lasx.xvslei.w" => "__builtin_lasx_xvslei_w",
                    "lasx.xvslei.wu" => "__builtin_lasx_xvslei_wu",
                    "lasx.xvsll.b" => "__builtin_lasx_xvsll_b",
                    "lasx.xvsll.d" => "__builtin_lasx_xvsll_d",
                    "lasx.xvsll.h" => "__builtin_lasx_xvsll_h",
                    "lasx.xvsll.w" => "__builtin_lasx_xvsll_w",
                    "lasx.xvslli.b" => "__builtin_lasx_xvslli_b",
                    "lasx.xvslli.d" => "__builtin_lasx_xvslli_d",
                    "lasx.xvslli.h" => "__builtin_lasx_xvslli_h",
                    "lasx.xvslli.w" => "__builtin_lasx_xvslli_w",
                    "lasx.xvsllwil.d.w" => "__builtin_lasx_xvsllwil_d_w",
                    "lasx.xvsllwil.du.wu" => "__builtin_lasx_xvsllwil_du_wu",
                    "lasx.xvsllwil.h.b" => "__builtin_lasx_xvsllwil_h_b",
                    "lasx.xvsllwil.hu.bu" => "__builtin_lasx_xvsllwil_hu_bu",
                    "lasx.xvsllwil.w.h" => "__builtin_lasx_xvsllwil_w_h",
                    "lasx.xvsllwil.wu.hu" => "__builtin_lasx_xvsllwil_wu_hu",
                    "lasx.xvslt.b" => "__builtin_lasx_xvslt_b",
                    "lasx.xvslt.bu" => "__builtin_lasx_xvslt_bu",
                    "lasx.xvslt.d" => "__builtin_lasx_xvslt_d",
                    "lasx.xvslt.du" => "__builtin_lasx_xvslt_du",
                    "lasx.xvslt.h" => "__builtin_lasx_xvslt_h",
                    "lasx.xvslt.hu" => "__builtin_lasx_xvslt_hu",
                    "lasx.xvslt.w" => "__builtin_lasx_xvslt_w",
                    "lasx.xvslt.wu" => "__builtin_lasx_xvslt_wu",
                    "lasx.xvslti.b" => "__builtin_lasx_xvslti_b",
                    "lasx.xvslti.bu" => "__builtin_lasx_xvslti_bu",
                    "lasx.xvslti.d" => "__builtin_lasx_xvslti_d",
                    "lasx.xvslti.du" => "__builtin_lasx_xvslti_du",
                    "lasx.xvslti.h" => "__builtin_lasx_xvslti_h",
                    "lasx.xvslti.hu" => "__builtin_lasx_xvslti_hu",
                    "lasx.xvslti.w" => "__builtin_lasx_xvslti_w",
                    "lasx.xvslti.wu" => "__builtin_lasx_xvslti_wu",
                    "lasx.xvsra.b" => "__builtin_lasx_xvsra_b",
                    "lasx.xvsra.d" => "__builtin_lasx_xvsra_d",
                    "lasx.xvsra.h" => "__builtin_lasx_xvsra_h",
                    "lasx.xvsra.w" => "__builtin_lasx_xvsra_w",
                    "lasx.xvsrai.b" => "__builtin_lasx_xvsrai_b",
                    "lasx.xvsrai.d" => "__builtin_lasx_xvsrai_d",
                    "lasx.xvsrai.h" => "__builtin_lasx_xvsrai_h",
                    "lasx.xvsrai.w" => "__builtin_lasx_xvsrai_w",
                    "lasx.xvsran.b.h" => "__builtin_lasx_xvsran_b_h",
                    "lasx.xvsran.h.w" => "__builtin_lasx_xvsran_h_w",
                    "lasx.xvsran.w.d" => "__builtin_lasx_xvsran_w_d",
                    "lasx.xvsrani.b.h" => "__builtin_lasx_xvsrani_b_h",
                    "lasx.xvsrani.d.q" => "__builtin_lasx_xvsrani_d_q",
                    "lasx.xvsrani.h.w" => "__builtin_lasx_xvsrani_h_w",
                    "lasx.xvsrani.w.d" => "__builtin_lasx_xvsrani_w_d",
                    "lasx.xvsrar.b" => "__builtin_lasx_xvsrar_b",
                    "lasx.xvsrar.d" => "__builtin_lasx_xvsrar_d",
                    "lasx.xvsrar.h" => "__builtin_lasx_xvsrar_h",
                    "lasx.xvsrar.w" => "__builtin_lasx_xvsrar_w",
                    "lasx.xvsrari.b" => "__builtin_lasx_xvsrari_b",
                    "lasx.xvsrari.d" => "__builtin_lasx_xvsrari_d",
                    "lasx.xvsrari.h" => "__builtin_lasx_xvsrari_h",
                    "lasx.xvsrari.w" => "__builtin_lasx_xvsrari_w",
                    "lasx.xvsrarn.b.h" => "__builtin_lasx_xvsrarn_b_h",
                    "lasx.xvsrarn.h.w" => "__builtin_lasx_xvsrarn_h_w",
                    "lasx.xvsrarn.w.d" => "__builtin_lasx_xvsrarn_w_d",
                    "lasx.xvsrarni.b.h" => "__builtin_lasx_xvsrarni_b_h",
                    "lasx.xvsrarni.d.q" => "__builtin_lasx_xvsrarni_d_q",
                    "lasx.xvsrarni.h.w" => "__builtin_lasx_xvsrarni_h_w",
                    "lasx.xvsrarni.w.d" => "__builtin_lasx_xvsrarni_w_d",
                    "lasx.xvsrl.b" => "__builtin_lasx_xvsrl_b",
                    "lasx.xvsrl.d" => "__builtin_lasx_xvsrl_d",
                    "lasx.xvsrl.h" => "__builtin_lasx_xvsrl_h",
                    "lasx.xvsrl.w" => "__builtin_lasx_xvsrl_w",
                    "lasx.xvsrli.b" => "__builtin_lasx_xvsrli_b",
                    "lasx.xvsrli.d" => "__builtin_lasx_xvsrli_d",
                    "lasx.xvsrli.h" => "__builtin_lasx_xvsrli_h",
                    "lasx.xvsrli.w" => "__builtin_lasx_xvsrli_w",
                    "lasx.xvsrln.b.h" => "__builtin_lasx_xvsrln_b_h",
                    "lasx.xvsrln.h.w" => "__builtin_lasx_xvsrln_h_w",
                    "lasx.xvsrln.w.d" => "__builtin_lasx_xvsrln_w_d",
                    "lasx.xvsrlni.b.h" => "__builtin_lasx_xvsrlni_b_h",
                    "lasx.xvsrlni.d.q" => "__builtin_lasx_xvsrlni_d_q",
                    "lasx.xvsrlni.h.w" => "__builtin_lasx_xvsrlni_h_w",
                    "lasx.xvsrlni.w.d" => "__builtin_lasx_xvsrlni_w_d",
                    "lasx.xvsrlr.b" => "__builtin_lasx_xvsrlr_b",
                    "lasx.xvsrlr.d" => "__builtin_lasx_xvsrlr_d",
                    "lasx.xvsrlr.h" => "__builtin_lasx_xvsrlr_h",
                    "lasx.xvsrlr.w" => "__builtin_lasx_xvsrlr_w",
                    "lasx.xvsrlri.b" => "__builtin_lasx_xvsrlri_b",
                    "lasx.xvsrlri.d" => "__builtin_lasx_xvsrlri_d",
                    "lasx.xvsrlri.h" => "__builtin_lasx_xvsrlri_h",
                    "lasx.xvsrlri.w" => "__builtin_lasx_xvsrlri_w",
                    "lasx.xvsrlrn.b.h" => "__builtin_lasx_xvsrlrn_b_h",
                    "lasx.xvsrlrn.h.w" => "__builtin_lasx_xvsrlrn_h_w",
                    "lasx.xvsrlrn.w.d" => "__builtin_lasx_xvsrlrn_w_d",
                    "lasx.xvsrlrni.b.h" => "__builtin_lasx_xvsrlrni_b_h",
                    "lasx.xvsrlrni.d.q" => "__builtin_lasx_xvsrlrni_d_q",
                    "lasx.xvsrlrni.h.w" => "__builtin_lasx_xvsrlrni_h_w",
                    "lasx.xvsrlrni.w.d" => "__builtin_lasx_xvsrlrni_w_d",
                    "lasx.xvssran.b.h" => "__builtin_lasx_xvssran_b_h",
                    "lasx.xvssran.bu.h" => "__builtin_lasx_xvssran_bu_h",
                    "lasx.xvssran.h.w" => "__builtin_lasx_xvssran_h_w",
                    "lasx.xvssran.hu.w" => "__builtin_lasx_xvssran_hu_w",
                    "lasx.xvssran.w.d" => "__builtin_lasx_xvssran_w_d",
                    "lasx.xvssran.wu.d" => "__builtin_lasx_xvssran_wu_d",
                    "lasx.xvssrani.b.h" => "__builtin_lasx_xvssrani_b_h",
                    "lasx.xvssrani.bu.h" => "__builtin_lasx_xvssrani_bu_h",
                    "lasx.xvssrani.d.q" => "__builtin_lasx_xvssrani_d_q",
                    "lasx.xvssrani.du.q" => "__builtin_lasx_xvssrani_du_q",
                    "lasx.xvssrani.h.w" => "__builtin_lasx_xvssrani_h_w",
                    "lasx.xvssrani.hu.w" => "__builtin_lasx_xvssrani_hu_w",
                    "lasx.xvssrani.w.d" => "__builtin_lasx_xvssrani_w_d",
                    "lasx.xvssrani.wu.d" => "__builtin_lasx_xvssrani_wu_d",
                    "lasx.xvssrarn.b.h" => "__builtin_lasx_xvssrarn_b_h",
                    "lasx.xvssrarn.bu.h" => "__builtin_lasx_xvssrarn_bu_h",
                    "lasx.xvssrarn.h.w" => "__builtin_lasx_xvssrarn_h_w",
                    "lasx.xvssrarn.hu.w" => "__builtin_lasx_xvssrarn_hu_w",
                    "lasx.xvssrarn.w.d" => "__builtin_lasx_xvssrarn_w_d",
                    "lasx.xvssrarn.wu.d" => "__builtin_lasx_xvssrarn_wu_d",
                    "lasx.xvssrarni.b.h" => "__builtin_lasx_xvssrarni_b_h",
                    "lasx.xvssrarni.bu.h" => "__builtin_lasx_xvssrarni_bu_h",
                    "lasx.xvssrarni.d.q" => "__builtin_lasx_xvssrarni_d_q",
                    "lasx.xvssrarni.du.q" => "__builtin_lasx_xvssrarni_du_q",
                    "lasx.xvssrarni.h.w" => "__builtin_lasx_xvssrarni_h_w",
                    "lasx.xvssrarni.hu.w" => "__builtin_lasx_xvssrarni_hu_w",
                    "lasx.xvssrarni.w.d" => "__builtin_lasx_xvssrarni_w_d",
                    "lasx.xvssrarni.wu.d" => "__builtin_lasx_xvssrarni_wu_d",
                    "lasx.xvssrln.b.h" => "__builtin_lasx_xvssrln_b_h",
                    "lasx.xvssrln.bu.h" => "__builtin_lasx_xvssrln_bu_h",
                    "lasx.xvssrln.h.w" => "__builtin_lasx_xvssrln_h_w",
                    "lasx.xvssrln.hu.w" => "__builtin_lasx_xvssrln_hu_w",
                    "lasx.xvssrln.w.d" => "__builtin_lasx_xvssrln_w_d",
                    "lasx.xvssrln.wu.d" => "__builtin_lasx_xvssrln_wu_d",
                    "lasx.xvssrlni.b.h" => "__builtin_lasx_xvssrlni_b_h",
                    "lasx.xvssrlni.bu.h" => "__builtin_lasx_xvssrlni_bu_h",
                    "lasx.xvssrlni.d.q" => "__builtin_lasx_xvssrlni_d_q",
                    "lasx.xvssrlni.du.q" => "__builtin_lasx_xvssrlni_du_q",
                    "lasx.xvssrlni.h.w" => "__builtin_lasx_xvssrlni_h_w",
                    "lasx.xvssrlni.hu.w" => "__builtin_lasx_xvssrlni_hu_w",
                    "lasx.xvssrlni.w.d" => "__builtin_lasx_xvssrlni_w_d",
                    "lasx.xvssrlni.wu.d" => "__builtin_lasx_xvssrlni_wu_d",
                    "lasx.xvssrlrn.b.h" => "__builtin_lasx_xvssrlrn_b_h",
                    "lasx.xvssrlrn.bu.h" => "__builtin_lasx_xvssrlrn_bu_h",
                    "lasx.xvssrlrn.h.w" => "__builtin_lasx_xvssrlrn_h_w",
                    "lasx.xvssrlrn.hu.w" => "__builtin_lasx_xvssrlrn_hu_w",
                    "lasx.xvssrlrn.w.d" => "__builtin_lasx_xvssrlrn_w_d",
                    "lasx.xvssrlrn.wu.d" => "__builtin_lasx_xvssrlrn_wu_d",
                    "lasx.xvssrlrni.b.h" => "__builtin_lasx_xvssrlrni_b_h",
                    "lasx.xvssrlrni.bu.h" => "__builtin_lasx_xvssrlrni_bu_h",
                    "lasx.xvssrlrni.d.q" => "__builtin_lasx_xvssrlrni_d_q",
                    "lasx.xvssrlrni.du.q" => "__builtin_lasx_xvssrlrni_du_q",
                    "lasx.xvssrlrni.h.w" => "__builtin_lasx_xvssrlrni_h_w",
                    "lasx.xvssrlrni.hu.w" => "__builtin_lasx_xvssrlrni_hu_w",
                    "lasx.xvssrlrni.w.d" => "__builtin_lasx_xvssrlrni_w_d",
                    "lasx.xvssrlrni.wu.d" => "__builtin_lasx_xvssrlrni_wu_d",
                    "lasx.xvssub.b" => "__builtin_lasx_xvssub_b",
                    "lasx.xvssub.bu" => "__builtin_lasx_xvssub_bu",
                    "lasx.xvssub.d" => "__builtin_lasx_xvssub_d",
                    "lasx.xvssub.du" => "__builtin_lasx_xvssub_du",
                    "lasx.xvssub.h" => "__builtin_lasx_xvssub_h",
                    "lasx.xvssub.hu" => "__builtin_lasx_xvssub_hu",
                    "lasx.xvssub.w" => "__builtin_lasx_xvssub_w",
                    "lasx.xvssub.wu" => "__builtin_lasx_xvssub_wu",
                    "lasx.xvst" => "__builtin_lasx_xvst",
                    "lasx.xvstelm.b" => "__builtin_lasx_xvstelm_b",
                    "lasx.xvstelm.d" => "__builtin_lasx_xvstelm_d",
                    "lasx.xvstelm.h" => "__builtin_lasx_xvstelm_h",
                    "lasx.xvstelm.w" => "__builtin_lasx_xvstelm_w",
                    "lasx.xvstx" => "__builtin_lasx_xvstx",
                    "lasx.xvsub.b" => "__builtin_lasx_xvsub_b",
                    "lasx.xvsub.d" => "__builtin_lasx_xvsub_d",
                    "lasx.xvsub.h" => "__builtin_lasx_xvsub_h",
                    "lasx.xvsub.q" => "__builtin_lasx_xvsub_q",
                    "lasx.xvsub.w" => "__builtin_lasx_xvsub_w",
                    "lasx.xvsubi.bu" => "__builtin_lasx_xvsubi_bu",
                    "lasx.xvsubi.du" => "__builtin_lasx_xvsubi_du",
                    "lasx.xvsubi.hu" => "__builtin_lasx_xvsubi_hu",
                    "lasx.xvsubi.wu" => "__builtin_lasx_xvsubi_wu",
                    "lasx.xvsubwev.d.w" => "__builtin_lasx_xvsubwev_d_w",
                    "lasx.xvsubwev.d.wu" => "__builtin_lasx_xvsubwev_d_wu",
                    "lasx.xvsubwev.h.b" => "__builtin_lasx_xvsubwev_h_b",
                    "lasx.xvsubwev.h.bu" => "__builtin_lasx_xvsubwev_h_bu",
                    "lasx.xvsubwev.q.d" => "__builtin_lasx_xvsubwev_q_d",
                    "lasx.xvsubwev.q.du" => "__builtin_lasx_xvsubwev_q_du",
                    "lasx.xvsubwev.w.h" => "__builtin_lasx_xvsubwev_w_h",
                    "lasx.xvsubwev.w.hu" => "__builtin_lasx_xvsubwev_w_hu",
                    "lasx.xvsubwod.d.w" => "__builtin_lasx_xvsubwod_d_w",
                    "lasx.xvsubwod.d.wu" => "__builtin_lasx_xvsubwod_d_wu",
                    "lasx.xvsubwod.h.b" => "__builtin_lasx_xvsubwod_h_b",
                    "lasx.xvsubwod.h.bu" => "__builtin_lasx_xvsubwod_h_bu",
                    "lasx.xvsubwod.q.d" => "__builtin_lasx_xvsubwod_q_d",
                    "lasx.xvsubwod.q.du" => "__builtin_lasx_xvsubwod_q_du",
                    "lasx.xvsubwod.w.h" => "__builtin_lasx_xvsubwod_w_h",
                    "lasx.xvsubwod.w.hu" => "__builtin_lasx_xvsubwod_w_hu",
                    "lasx.xvxor.v" => "__builtin_lasx_xvxor_v",
                    "lasx.xvxori.b" => "__builtin_lasx_xvxori_b",
                    "lddir.d" => "__builtin_loongarch_lddir_d",
                    "ldpte.d" => "__builtin_loongarch_ldpte_d",
                    "lsx.bnz.b" => "__builtin_lsx_bnz_b",
                    "lsx.bnz.d" => "__builtin_lsx_bnz_d",
                    "lsx.bnz.h" => "__builtin_lsx_bnz_h",
                    "lsx.bnz.v" => "__builtin_lsx_bnz_v",
                    "lsx.bnz.w" => "__builtin_lsx_bnz_w",
                    "lsx.bz.b" => "__builtin_lsx_bz_b",
                    "lsx.bz.d" => "__builtin_lsx_bz_d",
                    "lsx.bz.h" => "__builtin_lsx_bz_h",
                    "lsx.bz.v" => "__builtin_lsx_bz_v",
                    "lsx.bz.w" => "__builtin_lsx_bz_w",
                    "lsx.vabsd.b" => "__builtin_lsx_vabsd_b",
                    "lsx.vabsd.bu" => "__builtin_lsx_vabsd_bu",
                    "lsx.vabsd.d" => "__builtin_lsx_vabsd_d",
                    "lsx.vabsd.du" => "__builtin_lsx_vabsd_du",
                    "lsx.vabsd.h" => "__builtin_lsx_vabsd_h",
                    "lsx.vabsd.hu" => "__builtin_lsx_vabsd_hu",
                    "lsx.vabsd.w" => "__builtin_lsx_vabsd_w",
                    "lsx.vabsd.wu" => "__builtin_lsx_vabsd_wu",
                    "lsx.vadd.b" => "__builtin_lsx_vadd_b",
                    "lsx.vadd.d" => "__builtin_lsx_vadd_d",
                    "lsx.vadd.h" => "__builtin_lsx_vadd_h",
                    "lsx.vadd.q" => "__builtin_lsx_vadd_q",
                    "lsx.vadd.w" => "__builtin_lsx_vadd_w",
                    "lsx.vadda.b" => "__builtin_lsx_vadda_b",
                    "lsx.vadda.d" => "__builtin_lsx_vadda_d",
                    "lsx.vadda.h" => "__builtin_lsx_vadda_h",
                    "lsx.vadda.w" => "__builtin_lsx_vadda_w",
                    "lsx.vaddi.bu" => "__builtin_lsx_vaddi_bu",
                    "lsx.vaddi.du" => "__builtin_lsx_vaddi_du",
                    "lsx.vaddi.hu" => "__builtin_lsx_vaddi_hu",
                    "lsx.vaddi.wu" => "__builtin_lsx_vaddi_wu",
                    "lsx.vaddwev.d.w" => "__builtin_lsx_vaddwev_d_w",
                    "lsx.vaddwev.d.wu" => "__builtin_lsx_vaddwev_d_wu",
                    "lsx.vaddwev.d.wu.w" => "__builtin_lsx_vaddwev_d_wu_w",
                    "lsx.vaddwev.h.b" => "__builtin_lsx_vaddwev_h_b",
                    "lsx.vaddwev.h.bu" => "__builtin_lsx_vaddwev_h_bu",
                    "lsx.vaddwev.h.bu.b" => "__builtin_lsx_vaddwev_h_bu_b",
                    "lsx.vaddwev.q.d" => "__builtin_lsx_vaddwev_q_d",
                    "lsx.vaddwev.q.du" => "__builtin_lsx_vaddwev_q_du",
                    "lsx.vaddwev.q.du.d" => "__builtin_lsx_vaddwev_q_du_d",
                    "lsx.vaddwev.w.h" => "__builtin_lsx_vaddwev_w_h",
                    "lsx.vaddwev.w.hu" => "__builtin_lsx_vaddwev_w_hu",
                    "lsx.vaddwev.w.hu.h" => "__builtin_lsx_vaddwev_w_hu_h",
                    "lsx.vaddwod.d.w" => "__builtin_lsx_vaddwod_d_w",
                    "lsx.vaddwod.d.wu" => "__builtin_lsx_vaddwod_d_wu",
                    "lsx.vaddwod.d.wu.w" => "__builtin_lsx_vaddwod_d_wu_w",
                    "lsx.vaddwod.h.b" => "__builtin_lsx_vaddwod_h_b",
                    "lsx.vaddwod.h.bu" => "__builtin_lsx_vaddwod_h_bu",
                    "lsx.vaddwod.h.bu.b" => "__builtin_lsx_vaddwod_h_bu_b",
                    "lsx.vaddwod.q.d" => "__builtin_lsx_vaddwod_q_d",
                    "lsx.vaddwod.q.du" => "__builtin_lsx_vaddwod_q_du",
                    "lsx.vaddwod.q.du.d" => "__builtin_lsx_vaddwod_q_du_d",
                    "lsx.vaddwod.w.h" => "__builtin_lsx_vaddwod_w_h",
                    "lsx.vaddwod.w.hu" => "__builtin_lsx_vaddwod_w_hu",
                    "lsx.vaddwod.w.hu.h" => "__builtin_lsx_vaddwod_w_hu_h",
                    "lsx.vand.v" => "__builtin_lsx_vand_v",
                    "lsx.vandi.b" => "__builtin_lsx_vandi_b",
                    "lsx.vandn.v" => "__builtin_lsx_vandn_v",
                    "lsx.vavg.b" => "__builtin_lsx_vavg_b",
                    "lsx.vavg.bu" => "__builtin_lsx_vavg_bu",
                    "lsx.vavg.d" => "__builtin_lsx_vavg_d",
                    "lsx.vavg.du" => "__builtin_lsx_vavg_du",
                    "lsx.vavg.h" => "__builtin_lsx_vavg_h",
                    "lsx.vavg.hu" => "__builtin_lsx_vavg_hu",
                    "lsx.vavg.w" => "__builtin_lsx_vavg_w",
                    "lsx.vavg.wu" => "__builtin_lsx_vavg_wu",
                    "lsx.vavgr.b" => "__builtin_lsx_vavgr_b",
                    "lsx.vavgr.bu" => "__builtin_lsx_vavgr_bu",
                    "lsx.vavgr.d" => "__builtin_lsx_vavgr_d",
                    "lsx.vavgr.du" => "__builtin_lsx_vavgr_du",
                    "lsx.vavgr.h" => "__builtin_lsx_vavgr_h",
                    "lsx.vavgr.hu" => "__builtin_lsx_vavgr_hu",
                    "lsx.vavgr.w" => "__builtin_lsx_vavgr_w",
                    "lsx.vavgr.wu" => "__builtin_lsx_vavgr_wu",
                    "lsx.vbitclr.b" => "__builtin_lsx_vbitclr_b",
                    "lsx.vbitclr.d" => "__builtin_lsx_vbitclr_d",
                    "lsx.vbitclr.h" => "__builtin_lsx_vbitclr_h",
                    "lsx.vbitclr.w" => "__builtin_lsx_vbitclr_w",
                    "lsx.vbitclri.b" => "__builtin_lsx_vbitclri_b",
                    "lsx.vbitclri.d" => "__builtin_lsx_vbitclri_d",
                    "lsx.vbitclri.h" => "__builtin_lsx_vbitclri_h",
                    "lsx.vbitclri.w" => "__builtin_lsx_vbitclri_w",
                    "lsx.vbitrev.b" => "__builtin_lsx_vbitrev_b",
                    "lsx.vbitrev.d" => "__builtin_lsx_vbitrev_d",
                    "lsx.vbitrev.h" => "__builtin_lsx_vbitrev_h",
                    "lsx.vbitrev.w" => "__builtin_lsx_vbitrev_w",
                    "lsx.vbitrevi.b" => "__builtin_lsx_vbitrevi_b",
                    "lsx.vbitrevi.d" => "__builtin_lsx_vbitrevi_d",
                    "lsx.vbitrevi.h" => "__builtin_lsx_vbitrevi_h",
                    "lsx.vbitrevi.w" => "__builtin_lsx_vbitrevi_w",
                    "lsx.vbitsel.v" => "__builtin_lsx_vbitsel_v",
                    "lsx.vbitseli.b" => "__builtin_lsx_vbitseli_b",
                    "lsx.vbitset.b" => "__builtin_lsx_vbitset_b",
                    "lsx.vbitset.d" => "__builtin_lsx_vbitset_d",
                    "lsx.vbitset.h" => "__builtin_lsx_vbitset_h",
                    "lsx.vbitset.w" => "__builtin_lsx_vbitset_w",
                    "lsx.vbitseti.b" => "__builtin_lsx_vbitseti_b",
                    "lsx.vbitseti.d" => "__builtin_lsx_vbitseti_d",
                    "lsx.vbitseti.h" => "__builtin_lsx_vbitseti_h",
                    "lsx.vbitseti.w" => "__builtin_lsx_vbitseti_w",
                    "lsx.vbsll.v" => "__builtin_lsx_vbsll_v",
                    "lsx.vbsrl.v" => "__builtin_lsx_vbsrl_v",
                    "lsx.vclo.b" => "__builtin_lsx_vclo_b",
                    "lsx.vclo.d" => "__builtin_lsx_vclo_d",
                    "lsx.vclo.h" => "__builtin_lsx_vclo_h",
                    "lsx.vclo.w" => "__builtin_lsx_vclo_w",
                    "lsx.vclz.b" => "__builtin_lsx_vclz_b",
                    "lsx.vclz.d" => "__builtin_lsx_vclz_d",
                    "lsx.vclz.h" => "__builtin_lsx_vclz_h",
                    "lsx.vclz.w" => "__builtin_lsx_vclz_w",
                    "lsx.vdiv.b" => "__builtin_lsx_vdiv_b",
                    "lsx.vdiv.bu" => "__builtin_lsx_vdiv_bu",
                    "lsx.vdiv.d" => "__builtin_lsx_vdiv_d",
                    "lsx.vdiv.du" => "__builtin_lsx_vdiv_du",
                    "lsx.vdiv.h" => "__builtin_lsx_vdiv_h",
                    "lsx.vdiv.hu" => "__builtin_lsx_vdiv_hu",
                    "lsx.vdiv.w" => "__builtin_lsx_vdiv_w",
                    "lsx.vdiv.wu" => "__builtin_lsx_vdiv_wu",
                    "lsx.vexth.d.w" => "__builtin_lsx_vexth_d_w",
                    "lsx.vexth.du.wu" => "__builtin_lsx_vexth_du_wu",
                    "lsx.vexth.h.b" => "__builtin_lsx_vexth_h_b",
                    "lsx.vexth.hu.bu" => "__builtin_lsx_vexth_hu_bu",
                    "lsx.vexth.q.d" => "__builtin_lsx_vexth_q_d",
                    "lsx.vexth.qu.du" => "__builtin_lsx_vexth_qu_du",
                    "lsx.vexth.w.h" => "__builtin_lsx_vexth_w_h",
                    "lsx.vexth.wu.hu" => "__builtin_lsx_vexth_wu_hu",
                    "lsx.vextl.q.d" => "__builtin_lsx_vextl_q_d",
                    "lsx.vextl.qu.du" => "__builtin_lsx_vextl_qu_du",
                    "lsx.vextrins.b" => "__builtin_lsx_vextrins_b",
                    "lsx.vextrins.d" => "__builtin_lsx_vextrins_d",
                    "lsx.vextrins.h" => "__builtin_lsx_vextrins_h",
                    "lsx.vextrins.w" => "__builtin_lsx_vextrins_w",
                    "lsx.vfadd.d" => "__builtin_lsx_vfadd_d",
                    "lsx.vfadd.s" => "__builtin_lsx_vfadd_s",
                    "lsx.vfclass.d" => "__builtin_lsx_vfclass_d",
                    "lsx.vfclass.s" => "__builtin_lsx_vfclass_s",
                    "lsx.vfcmp.caf.d" => "__builtin_lsx_vfcmp_caf_d",
                    "lsx.vfcmp.caf.s" => "__builtin_lsx_vfcmp_caf_s",
                    "lsx.vfcmp.ceq.d" => "__builtin_lsx_vfcmp_ceq_d",
                    "lsx.vfcmp.ceq.s" => "__builtin_lsx_vfcmp_ceq_s",
                    "lsx.vfcmp.cle.d" => "__builtin_lsx_vfcmp_cle_d",
                    "lsx.vfcmp.cle.s" => "__builtin_lsx_vfcmp_cle_s",
                    "lsx.vfcmp.clt.d" => "__builtin_lsx_vfcmp_clt_d",
                    "lsx.vfcmp.clt.s" => "__builtin_lsx_vfcmp_clt_s",
                    "lsx.vfcmp.cne.d" => "__builtin_lsx_vfcmp_cne_d",
                    "lsx.vfcmp.cne.s" => "__builtin_lsx_vfcmp_cne_s",
                    "lsx.vfcmp.cor.d" => "__builtin_lsx_vfcmp_cor_d",
                    "lsx.vfcmp.cor.s" => "__builtin_lsx_vfcmp_cor_s",
                    "lsx.vfcmp.cueq.d" => "__builtin_lsx_vfcmp_cueq_d",
                    "lsx.vfcmp.cueq.s" => "__builtin_lsx_vfcmp_cueq_s",
                    "lsx.vfcmp.cule.d" => "__builtin_lsx_vfcmp_cule_d",
                    "lsx.vfcmp.cule.s" => "__builtin_lsx_vfcmp_cule_s",
                    "lsx.vfcmp.cult.d" => "__builtin_lsx_vfcmp_cult_d",
                    "lsx.vfcmp.cult.s" => "__builtin_lsx_vfcmp_cult_s",
                    "lsx.vfcmp.cun.d" => "__builtin_lsx_vfcmp_cun_d",
                    "lsx.vfcmp.cun.s" => "__builtin_lsx_vfcmp_cun_s",
                    "lsx.vfcmp.cune.d" => "__builtin_lsx_vfcmp_cune_d",
                    "lsx.vfcmp.cune.s" => "__builtin_lsx_vfcmp_cune_s",
                    "lsx.vfcmp.saf.d" => "__builtin_lsx_vfcmp_saf_d",
                    "lsx.vfcmp.saf.s" => "__builtin_lsx_vfcmp_saf_s",
                    "lsx.vfcmp.seq.d" => "__builtin_lsx_vfcmp_seq_d",
                    "lsx.vfcmp.seq.s" => "__builtin_lsx_vfcmp_seq_s",
                    "lsx.vfcmp.sle.d" => "__builtin_lsx_vfcmp_sle_d",
                    "lsx.vfcmp.sle.s" => "__builtin_lsx_vfcmp_sle_s",
                    "lsx.vfcmp.slt.d" => "__builtin_lsx_vfcmp_slt_d",
                    "lsx.vfcmp.slt.s" => "__builtin_lsx_vfcmp_slt_s",
                    "lsx.vfcmp.sne.d" => "__builtin_lsx_vfcmp_sne_d",
                    "lsx.vfcmp.sne.s" => "__builtin_lsx_vfcmp_sne_s",
                    "lsx.vfcmp.sor.d" => "__builtin_lsx_vfcmp_sor_d",
                    "lsx.vfcmp.sor.s" => "__builtin_lsx_vfcmp_sor_s",
                    "lsx.vfcmp.sueq.d" => "__builtin_lsx_vfcmp_sueq_d",
                    "lsx.vfcmp.sueq.s" => "__builtin_lsx_vfcmp_sueq_s",
                    "lsx.vfcmp.sule.d" => "__builtin_lsx_vfcmp_sule_d",
                    "lsx.vfcmp.sule.s" => "__builtin_lsx_vfcmp_sule_s",
                    "lsx.vfcmp.sult.d" => "__builtin_lsx_vfcmp_sult_d",
                    "lsx.vfcmp.sult.s" => "__builtin_lsx_vfcmp_sult_s",
                    "lsx.vfcmp.sun.d" => "__builtin_lsx_vfcmp_sun_d",
                    "lsx.vfcmp.sun.s" => "__builtin_lsx_vfcmp_sun_s",
                    "lsx.vfcmp.sune.d" => "__builtin_lsx_vfcmp_sune_d",
                    "lsx.vfcmp.sune.s" => "__builtin_lsx_vfcmp_sune_s",
                    "lsx.vfcvt.h.s" => "__builtin_lsx_vfcvt_h_s",
                    "lsx.vfcvt.s.d" => "__builtin_lsx_vfcvt_s_d",
                    "lsx.vfcvth.d.s" => "__builtin_lsx_vfcvth_d_s",
                    "lsx.vfcvth.s.h" => "__builtin_lsx_vfcvth_s_h",
                    "lsx.vfcvtl.d.s" => "__builtin_lsx_vfcvtl_d_s",
                    "lsx.vfcvtl.s.h" => "__builtin_lsx_vfcvtl_s_h",
                    "lsx.vfdiv.d" => "__builtin_lsx_vfdiv_d",
                    "lsx.vfdiv.s" => "__builtin_lsx_vfdiv_s",
                    "lsx.vffint.d.l" => "__builtin_lsx_vffint_d_l",
                    "lsx.vffint.d.lu" => "__builtin_lsx_vffint_d_lu",
                    "lsx.vffint.s.l" => "__builtin_lsx_vffint_s_l",
                    "lsx.vffint.s.w" => "__builtin_lsx_vffint_s_w",
                    "lsx.vffint.s.wu" => "__builtin_lsx_vffint_s_wu",
                    "lsx.vffinth.d.w" => "__builtin_lsx_vffinth_d_w",
                    "lsx.vffintl.d.w" => "__builtin_lsx_vffintl_d_w",
                    "lsx.vflogb.d" => "__builtin_lsx_vflogb_d",
                    "lsx.vflogb.s" => "__builtin_lsx_vflogb_s",
                    "lsx.vfmadd.d" => "__builtin_lsx_vfmadd_d",
                    "lsx.vfmadd.s" => "__builtin_lsx_vfmadd_s",
                    "lsx.vfmax.d" => "__builtin_lsx_vfmax_d",
                    "lsx.vfmax.s" => "__builtin_lsx_vfmax_s",
                    "lsx.vfmaxa.d" => "__builtin_lsx_vfmaxa_d",
                    "lsx.vfmaxa.s" => "__builtin_lsx_vfmaxa_s",
                    "lsx.vfmin.d" => "__builtin_lsx_vfmin_d",
                    "lsx.vfmin.s" => "__builtin_lsx_vfmin_s",
                    "lsx.vfmina.d" => "__builtin_lsx_vfmina_d",
                    "lsx.vfmina.s" => "__builtin_lsx_vfmina_s",
                    "lsx.vfmsub.d" => "__builtin_lsx_vfmsub_d",
                    "lsx.vfmsub.s" => "__builtin_lsx_vfmsub_s",
                    "lsx.vfmul.d" => "__builtin_lsx_vfmul_d",
                    "lsx.vfmul.s" => "__builtin_lsx_vfmul_s",
                    "lsx.vfnmadd.d" => "__builtin_lsx_vfnmadd_d",
                    "lsx.vfnmadd.s" => "__builtin_lsx_vfnmadd_s",
                    "lsx.vfnmsub.d" => "__builtin_lsx_vfnmsub_d",
                    "lsx.vfnmsub.s" => "__builtin_lsx_vfnmsub_s",
                    "lsx.vfrecip.d" => "__builtin_lsx_vfrecip_d",
                    "lsx.vfrecip.s" => "__builtin_lsx_vfrecip_s",
                    "lsx.vfrecipe.d" => "__builtin_lsx_vfrecipe_d",
                    "lsx.vfrecipe.s" => "__builtin_lsx_vfrecipe_s",
                    "lsx.vfrint.d" => "__builtin_lsx_vfrint_d",
                    "lsx.vfrint.s" => "__builtin_lsx_vfrint_s",
                    "lsx.vfrintrm.d" => "__builtin_lsx_vfrintrm_d",
                    "lsx.vfrintrm.s" => "__builtin_lsx_vfrintrm_s",
                    "lsx.vfrintrne.d" => "__builtin_lsx_vfrintrne_d",
                    "lsx.vfrintrne.s" => "__builtin_lsx_vfrintrne_s",
                    "lsx.vfrintrp.d" => "__builtin_lsx_vfrintrp_d",
                    "lsx.vfrintrp.s" => "__builtin_lsx_vfrintrp_s",
                    "lsx.vfrintrz.d" => "__builtin_lsx_vfrintrz_d",
                    "lsx.vfrintrz.s" => "__builtin_lsx_vfrintrz_s",
                    "lsx.vfrsqrt.d" => "__builtin_lsx_vfrsqrt_d",
                    "lsx.vfrsqrt.s" => "__builtin_lsx_vfrsqrt_s",
                    "lsx.vfrsqrte.d" => "__builtin_lsx_vfrsqrte_d",
                    "lsx.vfrsqrte.s" => "__builtin_lsx_vfrsqrte_s",
                    "lsx.vfrstp.b" => "__builtin_lsx_vfrstp_b",
                    "lsx.vfrstp.h" => "__builtin_lsx_vfrstp_h",
                    "lsx.vfrstpi.b" => "__builtin_lsx_vfrstpi_b",
                    "lsx.vfrstpi.h" => "__builtin_lsx_vfrstpi_h",
                    "lsx.vfsqrt.d" => "__builtin_lsx_vfsqrt_d",
                    "lsx.vfsqrt.s" => "__builtin_lsx_vfsqrt_s",
                    "lsx.vfsub.d" => "__builtin_lsx_vfsub_d",
                    "lsx.vfsub.s" => "__builtin_lsx_vfsub_s",
                    "lsx.vftint.l.d" => "__builtin_lsx_vftint_l_d",
                    "lsx.vftint.lu.d" => "__builtin_lsx_vftint_lu_d",
                    "lsx.vftint.w.d" => "__builtin_lsx_vftint_w_d",
                    "lsx.vftint.w.s" => "__builtin_lsx_vftint_w_s",
                    "lsx.vftint.wu.s" => "__builtin_lsx_vftint_wu_s",
                    "lsx.vftinth.l.s" => "__builtin_lsx_vftinth_l_s",
                    "lsx.vftintl.l.s" => "__builtin_lsx_vftintl_l_s",
                    "lsx.vftintrm.l.d" => "__builtin_lsx_vftintrm_l_d",
                    "lsx.vftintrm.w.d" => "__builtin_lsx_vftintrm_w_d",
                    "lsx.vftintrm.w.s" => "__builtin_lsx_vftintrm_w_s",
                    "lsx.vftintrmh.l.s" => "__builtin_lsx_vftintrmh_l_s",
                    "lsx.vftintrml.l.s" => "__builtin_lsx_vftintrml_l_s",
                    "lsx.vftintrne.l.d" => "__builtin_lsx_vftintrne_l_d",
                    "lsx.vftintrne.w.d" => "__builtin_lsx_vftintrne_w_d",
                    "lsx.vftintrne.w.s" => "__builtin_lsx_vftintrne_w_s",
                    "lsx.vftintrneh.l.s" => "__builtin_lsx_vftintrneh_l_s",
                    "lsx.vftintrnel.l.s" => "__builtin_lsx_vftintrnel_l_s",
                    "lsx.vftintrp.l.d" => "__builtin_lsx_vftintrp_l_d",
                    "lsx.vftintrp.w.d" => "__builtin_lsx_vftintrp_w_d",
                    "lsx.vftintrp.w.s" => "__builtin_lsx_vftintrp_w_s",
                    "lsx.vftintrph.l.s" => "__builtin_lsx_vftintrph_l_s",
                    "lsx.vftintrpl.l.s" => "__builtin_lsx_vftintrpl_l_s",
                    "lsx.vftintrz.l.d" => "__builtin_lsx_vftintrz_l_d",
                    "lsx.vftintrz.lu.d" => "__builtin_lsx_vftintrz_lu_d",
                    "lsx.vftintrz.w.d" => "__builtin_lsx_vftintrz_w_d",
                    "lsx.vftintrz.w.s" => "__builtin_lsx_vftintrz_w_s",
                    "lsx.vftintrz.wu.s" => "__builtin_lsx_vftintrz_wu_s",
                    "lsx.vftintrzh.l.s" => "__builtin_lsx_vftintrzh_l_s",
                    "lsx.vftintrzl.l.s" => "__builtin_lsx_vftintrzl_l_s",
                    "lsx.vhaddw.d.w" => "__builtin_lsx_vhaddw_d_w",
                    "lsx.vhaddw.du.wu" => "__builtin_lsx_vhaddw_du_wu",
                    "lsx.vhaddw.h.b" => "__builtin_lsx_vhaddw_h_b",
                    "lsx.vhaddw.hu.bu" => "__builtin_lsx_vhaddw_hu_bu",
                    "lsx.vhaddw.q.d" => "__builtin_lsx_vhaddw_q_d",
                    "lsx.vhaddw.qu.du" => "__builtin_lsx_vhaddw_qu_du",
                    "lsx.vhaddw.w.h" => "__builtin_lsx_vhaddw_w_h",
                    "lsx.vhaddw.wu.hu" => "__builtin_lsx_vhaddw_wu_hu",
                    "lsx.vhsubw.d.w" => "__builtin_lsx_vhsubw_d_w",
                    "lsx.vhsubw.du.wu" => "__builtin_lsx_vhsubw_du_wu",
                    "lsx.vhsubw.h.b" => "__builtin_lsx_vhsubw_h_b",
                    "lsx.vhsubw.hu.bu" => "__builtin_lsx_vhsubw_hu_bu",
                    "lsx.vhsubw.q.d" => "__builtin_lsx_vhsubw_q_d",
                    "lsx.vhsubw.qu.du" => "__builtin_lsx_vhsubw_qu_du",
                    "lsx.vhsubw.w.h" => "__builtin_lsx_vhsubw_w_h",
                    "lsx.vhsubw.wu.hu" => "__builtin_lsx_vhsubw_wu_hu",
                    "lsx.vilvh.b" => "__builtin_lsx_vilvh_b",
                    "lsx.vilvh.d" => "__builtin_lsx_vilvh_d",
                    "lsx.vilvh.h" => "__builtin_lsx_vilvh_h",
                    "lsx.vilvh.w" => "__builtin_lsx_vilvh_w",
                    "lsx.vilvl.b" => "__builtin_lsx_vilvl_b",
                    "lsx.vilvl.d" => "__builtin_lsx_vilvl_d",
                    "lsx.vilvl.h" => "__builtin_lsx_vilvl_h",
                    "lsx.vilvl.w" => "__builtin_lsx_vilvl_w",
                    "lsx.vinsgr2vr.b" => "__builtin_lsx_vinsgr2vr_b",
                    "lsx.vinsgr2vr.d" => "__builtin_lsx_vinsgr2vr_d",
                    "lsx.vinsgr2vr.h" => "__builtin_lsx_vinsgr2vr_h",
                    "lsx.vinsgr2vr.w" => "__builtin_lsx_vinsgr2vr_w",
                    "lsx.vld" => "__builtin_lsx_vld",
                    "lsx.vldi" => "__builtin_lsx_vldi",
                    "lsx.vldrepl.b" => "__builtin_lsx_vldrepl_b",
                    "lsx.vldrepl.d" => "__builtin_lsx_vldrepl_d",
                    "lsx.vldrepl.h" => "__builtin_lsx_vldrepl_h",
                    "lsx.vldrepl.w" => "__builtin_lsx_vldrepl_w",
                    "lsx.vldx" => "__builtin_lsx_vldx",
                    "lsx.vmadd.b" => "__builtin_lsx_vmadd_b",
                    "lsx.vmadd.d" => "__builtin_lsx_vmadd_d",
                    "lsx.vmadd.h" => "__builtin_lsx_vmadd_h",
                    "lsx.vmadd.w" => "__builtin_lsx_vmadd_w",
                    "lsx.vmaddwev.d.w" => "__builtin_lsx_vmaddwev_d_w",
                    "lsx.vmaddwev.d.wu" => "__builtin_lsx_vmaddwev_d_wu",
                    "lsx.vmaddwev.d.wu.w" => "__builtin_lsx_vmaddwev_d_wu_w",
                    "lsx.vmaddwev.h.b" => "__builtin_lsx_vmaddwev_h_b",
                    "lsx.vmaddwev.h.bu" => "__builtin_lsx_vmaddwev_h_bu",
                    "lsx.vmaddwev.h.bu.b" => "__builtin_lsx_vmaddwev_h_bu_b",
                    "lsx.vmaddwev.q.d" => "__builtin_lsx_vmaddwev_q_d",
                    "lsx.vmaddwev.q.du" => "__builtin_lsx_vmaddwev_q_du",
                    "lsx.vmaddwev.q.du.d" => "__builtin_lsx_vmaddwev_q_du_d",
                    "lsx.vmaddwev.w.h" => "__builtin_lsx_vmaddwev_w_h",
                    "lsx.vmaddwev.w.hu" => "__builtin_lsx_vmaddwev_w_hu",
                    "lsx.vmaddwev.w.hu.h" => "__builtin_lsx_vmaddwev_w_hu_h",
                    "lsx.vmaddwod.d.w" => "__builtin_lsx_vmaddwod_d_w",
                    "lsx.vmaddwod.d.wu" => "__builtin_lsx_vmaddwod_d_wu",
                    "lsx.vmaddwod.d.wu.w" => "__builtin_lsx_vmaddwod_d_wu_w",
                    "lsx.vmaddwod.h.b" => "__builtin_lsx_vmaddwod_h_b",
                    "lsx.vmaddwod.h.bu" => "__builtin_lsx_vmaddwod_h_bu",
                    "lsx.vmaddwod.h.bu.b" => "__builtin_lsx_vmaddwod_h_bu_b",
                    "lsx.vmaddwod.q.d" => "__builtin_lsx_vmaddwod_q_d",
                    "lsx.vmaddwod.q.du" => "__builtin_lsx_vmaddwod_q_du",
                    "lsx.vmaddwod.q.du.d" => "__builtin_lsx_vmaddwod_q_du_d",
                    "lsx.vmaddwod.w.h" => "__builtin_lsx_vmaddwod_w_h",
                    "lsx.vmaddwod.w.hu" => "__builtin_lsx_vmaddwod_w_hu",
                    "lsx.vmaddwod.w.hu.h" => "__builtin_lsx_vmaddwod_w_hu_h",
                    "lsx.vmax.b" => "__builtin_lsx_vmax_b",
                    "lsx.vmax.bu" => "__builtin_lsx_vmax_bu",
                    "lsx.vmax.d" => "__builtin_lsx_vmax_d",
                    "lsx.vmax.du" => "__builtin_lsx_vmax_du",
                    "lsx.vmax.h" => "__builtin_lsx_vmax_h",
                    "lsx.vmax.hu" => "__builtin_lsx_vmax_hu",
                    "lsx.vmax.w" => "__builtin_lsx_vmax_w",
                    "lsx.vmax.wu" => "__builtin_lsx_vmax_wu",
                    "lsx.vmaxi.b" => "__builtin_lsx_vmaxi_b",
                    "lsx.vmaxi.bu" => "__builtin_lsx_vmaxi_bu",
                    "lsx.vmaxi.d" => "__builtin_lsx_vmaxi_d",
                    "lsx.vmaxi.du" => "__builtin_lsx_vmaxi_du",
                    "lsx.vmaxi.h" => "__builtin_lsx_vmaxi_h",
                    "lsx.vmaxi.hu" => "__builtin_lsx_vmaxi_hu",
                    "lsx.vmaxi.w" => "__builtin_lsx_vmaxi_w",
                    "lsx.vmaxi.wu" => "__builtin_lsx_vmaxi_wu",
                    "lsx.vmin.b" => "__builtin_lsx_vmin_b",
                    "lsx.vmin.bu" => "__builtin_lsx_vmin_bu",
                    "lsx.vmin.d" => "__builtin_lsx_vmin_d",
                    "lsx.vmin.du" => "__builtin_lsx_vmin_du",
                    "lsx.vmin.h" => "__builtin_lsx_vmin_h",
                    "lsx.vmin.hu" => "__builtin_lsx_vmin_hu",
                    "lsx.vmin.w" => "__builtin_lsx_vmin_w",
                    "lsx.vmin.wu" => "__builtin_lsx_vmin_wu",
                    "lsx.vmini.b" => "__builtin_lsx_vmini_b",
                    "lsx.vmini.bu" => "__builtin_lsx_vmini_bu",
                    "lsx.vmini.d" => "__builtin_lsx_vmini_d",
                    "lsx.vmini.du" => "__builtin_lsx_vmini_du",
                    "lsx.vmini.h" => "__builtin_lsx_vmini_h",
                    "lsx.vmini.hu" => "__builtin_lsx_vmini_hu",
                    "lsx.vmini.w" => "__builtin_lsx_vmini_w",
                    "lsx.vmini.wu" => "__builtin_lsx_vmini_wu",
                    "lsx.vmod.b" => "__builtin_lsx_vmod_b",
                    "lsx.vmod.bu" => "__builtin_lsx_vmod_bu",
                    "lsx.vmod.d" => "__builtin_lsx_vmod_d",
                    "lsx.vmod.du" => "__builtin_lsx_vmod_du",
                    "lsx.vmod.h" => "__builtin_lsx_vmod_h",
                    "lsx.vmod.hu" => "__builtin_lsx_vmod_hu",
                    "lsx.vmod.w" => "__builtin_lsx_vmod_w",
                    "lsx.vmod.wu" => "__builtin_lsx_vmod_wu",
                    "lsx.vmskgez.b" => "__builtin_lsx_vmskgez_b",
                    "lsx.vmskltz.b" => "__builtin_lsx_vmskltz_b",
                    "lsx.vmskltz.d" => "__builtin_lsx_vmskltz_d",
                    "lsx.vmskltz.h" => "__builtin_lsx_vmskltz_h",
                    "lsx.vmskltz.w" => "__builtin_lsx_vmskltz_w",
                    "lsx.vmsknz.b" => "__builtin_lsx_vmsknz_b",
                    "lsx.vmsub.b" => "__builtin_lsx_vmsub_b",
                    "lsx.vmsub.d" => "__builtin_lsx_vmsub_d",
                    "lsx.vmsub.h" => "__builtin_lsx_vmsub_h",
                    "lsx.vmsub.w" => "__builtin_lsx_vmsub_w",
                    "lsx.vmuh.b" => "__builtin_lsx_vmuh_b",
                    "lsx.vmuh.bu" => "__builtin_lsx_vmuh_bu",
                    "lsx.vmuh.d" => "__builtin_lsx_vmuh_d",
                    "lsx.vmuh.du" => "__builtin_lsx_vmuh_du",
                    "lsx.vmuh.h" => "__builtin_lsx_vmuh_h",
                    "lsx.vmuh.hu" => "__builtin_lsx_vmuh_hu",
                    "lsx.vmuh.w" => "__builtin_lsx_vmuh_w",
                    "lsx.vmuh.wu" => "__builtin_lsx_vmuh_wu",
                    "lsx.vmul.b" => "__builtin_lsx_vmul_b",
                    "lsx.vmul.d" => "__builtin_lsx_vmul_d",
                    "lsx.vmul.h" => "__builtin_lsx_vmul_h",
                    "lsx.vmul.w" => "__builtin_lsx_vmul_w",
                    "lsx.vmulwev.d.w" => "__builtin_lsx_vmulwev_d_w",
                    "lsx.vmulwev.d.wu" => "__builtin_lsx_vmulwev_d_wu",
                    "lsx.vmulwev.d.wu.w" => "__builtin_lsx_vmulwev_d_wu_w",
                    "lsx.vmulwev.h.b" => "__builtin_lsx_vmulwev_h_b",
                    "lsx.vmulwev.h.bu" => "__builtin_lsx_vmulwev_h_bu",
                    "lsx.vmulwev.h.bu.b" => "__builtin_lsx_vmulwev_h_bu_b",
                    "lsx.vmulwev.q.d" => "__builtin_lsx_vmulwev_q_d",
                    "lsx.vmulwev.q.du" => "__builtin_lsx_vmulwev_q_du",
                    "lsx.vmulwev.q.du.d" => "__builtin_lsx_vmulwev_q_du_d",
                    "lsx.vmulwev.w.h" => "__builtin_lsx_vmulwev_w_h",
                    "lsx.vmulwev.w.hu" => "__builtin_lsx_vmulwev_w_hu",
                    "lsx.vmulwev.w.hu.h" => "__builtin_lsx_vmulwev_w_hu_h",
                    "lsx.vmulwod.d.w" => "__builtin_lsx_vmulwod_d_w",
                    "lsx.vmulwod.d.wu" => "__builtin_lsx_vmulwod_d_wu",
                    "lsx.vmulwod.d.wu.w" => "__builtin_lsx_vmulwod_d_wu_w",
                    "lsx.vmulwod.h.b" => "__builtin_lsx_vmulwod_h_b",
                    "lsx.vmulwod.h.bu" => "__builtin_lsx_vmulwod_h_bu",
                    "lsx.vmulwod.h.bu.b" => "__builtin_lsx_vmulwod_h_bu_b",
                    "lsx.vmulwod.q.d" => "__builtin_lsx_vmulwod_q_d",
                    "lsx.vmulwod.q.du" => "__builtin_lsx_vmulwod_q_du",
                    "lsx.vmulwod.q.du.d" => "__builtin_lsx_vmulwod_q_du_d",
                    "lsx.vmulwod.w.h" => "__builtin_lsx_vmulwod_w_h",
                    "lsx.vmulwod.w.hu" => "__builtin_lsx_vmulwod_w_hu",
                    "lsx.vmulwod.w.hu.h" => "__builtin_lsx_vmulwod_w_hu_h",
                    "lsx.vneg.b" => "__builtin_lsx_vneg_b",
                    "lsx.vneg.d" => "__builtin_lsx_vneg_d",
                    "lsx.vneg.h" => "__builtin_lsx_vneg_h",
                    "lsx.vneg.w" => "__builtin_lsx_vneg_w",
                    "lsx.vnor.v" => "__builtin_lsx_vnor_v",
                    "lsx.vnori.b" => "__builtin_lsx_vnori_b",
                    "lsx.vor.v" => "__builtin_lsx_vor_v",
                    "lsx.vori.b" => "__builtin_lsx_vori_b",
                    "lsx.vorn.v" => "__builtin_lsx_vorn_v",
                    "lsx.vpackev.b" => "__builtin_lsx_vpackev_b",
                    "lsx.vpackev.d" => "__builtin_lsx_vpackev_d",
                    "lsx.vpackev.h" => "__builtin_lsx_vpackev_h",
                    "lsx.vpackev.w" => "__builtin_lsx_vpackev_w",
                    "lsx.vpackod.b" => "__builtin_lsx_vpackod_b",
                    "lsx.vpackod.d" => "__builtin_lsx_vpackod_d",
                    "lsx.vpackod.h" => "__builtin_lsx_vpackod_h",
                    "lsx.vpackod.w" => "__builtin_lsx_vpackod_w",
                    "lsx.vpcnt.b" => "__builtin_lsx_vpcnt_b",
                    "lsx.vpcnt.d" => "__builtin_lsx_vpcnt_d",
                    "lsx.vpcnt.h" => "__builtin_lsx_vpcnt_h",
                    "lsx.vpcnt.w" => "__builtin_lsx_vpcnt_w",
                    "lsx.vpermi.w" => "__builtin_lsx_vpermi_w",
                    "lsx.vpickev.b" => "__builtin_lsx_vpickev_b",
                    "lsx.vpickev.d" => "__builtin_lsx_vpickev_d",
                    "lsx.vpickev.h" => "__builtin_lsx_vpickev_h",
                    "lsx.vpickev.w" => "__builtin_lsx_vpickev_w",
                    "lsx.vpickod.b" => "__builtin_lsx_vpickod_b",
                    "lsx.vpickod.d" => "__builtin_lsx_vpickod_d",
                    "lsx.vpickod.h" => "__builtin_lsx_vpickod_h",
                    "lsx.vpickod.w" => "__builtin_lsx_vpickod_w",
                    "lsx.vpickve2gr.b" => "__builtin_lsx_vpickve2gr_b",
                    "lsx.vpickve2gr.bu" => "__builtin_lsx_vpickve2gr_bu",
                    "lsx.vpickve2gr.d" => "__builtin_lsx_vpickve2gr_d",
                    "lsx.vpickve2gr.du" => "__builtin_lsx_vpickve2gr_du",
                    "lsx.vpickve2gr.h" => "__builtin_lsx_vpickve2gr_h",
                    "lsx.vpickve2gr.hu" => "__builtin_lsx_vpickve2gr_hu",
                    "lsx.vpickve2gr.w" => "__builtin_lsx_vpickve2gr_w",
                    "lsx.vpickve2gr.wu" => "__builtin_lsx_vpickve2gr_wu",
                    "lsx.vreplgr2vr.b" => "__builtin_lsx_vreplgr2vr_b",
                    "lsx.vreplgr2vr.d" => "__builtin_lsx_vreplgr2vr_d",
                    "lsx.vreplgr2vr.h" => "__builtin_lsx_vreplgr2vr_h",
                    "lsx.vreplgr2vr.w" => "__builtin_lsx_vreplgr2vr_w",
                    "lsx.vrepli.b" => "__builtin_lsx_vrepli_b",
                    "lsx.vrepli.d" => "__builtin_lsx_vrepli_d",
                    "lsx.vrepli.h" => "__builtin_lsx_vrepli_h",
                    "lsx.vrepli.w" => "__builtin_lsx_vrepli_w",
                    "lsx.vreplve.b" => "__builtin_lsx_vreplve_b",
                    "lsx.vreplve.d" => "__builtin_lsx_vreplve_d",
                    "lsx.vreplve.h" => "__builtin_lsx_vreplve_h",
                    "lsx.vreplve.w" => "__builtin_lsx_vreplve_w",
                    "lsx.vreplvei.b" => "__builtin_lsx_vreplvei_b",
                    "lsx.vreplvei.d" => "__builtin_lsx_vreplvei_d",
                    "lsx.vreplvei.h" => "__builtin_lsx_vreplvei_h",
                    "lsx.vreplvei.w" => "__builtin_lsx_vreplvei_w",
                    "lsx.vrotr.b" => "__builtin_lsx_vrotr_b",
                    "lsx.vrotr.d" => "__builtin_lsx_vrotr_d",
                    "lsx.vrotr.h" => "__builtin_lsx_vrotr_h",
                    "lsx.vrotr.w" => "__builtin_lsx_vrotr_w",
                    "lsx.vrotri.b" => "__builtin_lsx_vrotri_b",
                    "lsx.vrotri.d" => "__builtin_lsx_vrotri_d",
                    "lsx.vrotri.h" => "__builtin_lsx_vrotri_h",
                    "lsx.vrotri.w" => "__builtin_lsx_vrotri_w",
                    "lsx.vsadd.b" => "__builtin_lsx_vsadd_b",
                    "lsx.vsadd.bu" => "__builtin_lsx_vsadd_bu",
                    "lsx.vsadd.d" => "__builtin_lsx_vsadd_d",
                    "lsx.vsadd.du" => "__builtin_lsx_vsadd_du",
                    "lsx.vsadd.h" => "__builtin_lsx_vsadd_h",
                    "lsx.vsadd.hu" => "__builtin_lsx_vsadd_hu",
                    "lsx.vsadd.w" => "__builtin_lsx_vsadd_w",
                    "lsx.vsadd.wu" => "__builtin_lsx_vsadd_wu",
                    "lsx.vsat.b" => "__builtin_lsx_vsat_b",
                    "lsx.vsat.bu" => "__builtin_lsx_vsat_bu",
                    "lsx.vsat.d" => "__builtin_lsx_vsat_d",
                    "lsx.vsat.du" => "__builtin_lsx_vsat_du",
                    "lsx.vsat.h" => "__builtin_lsx_vsat_h",
                    "lsx.vsat.hu" => "__builtin_lsx_vsat_hu",
                    "lsx.vsat.w" => "__builtin_lsx_vsat_w",
                    "lsx.vsat.wu" => "__builtin_lsx_vsat_wu",
                    "lsx.vseq.b" => "__builtin_lsx_vseq_b",
                    "lsx.vseq.d" => "__builtin_lsx_vseq_d",
                    "lsx.vseq.h" => "__builtin_lsx_vseq_h",
                    "lsx.vseq.w" => "__builtin_lsx_vseq_w",
                    "lsx.vseqi.b" => "__builtin_lsx_vseqi_b",
                    "lsx.vseqi.d" => "__builtin_lsx_vseqi_d",
                    "lsx.vseqi.h" => "__builtin_lsx_vseqi_h",
                    "lsx.vseqi.w" => "__builtin_lsx_vseqi_w",
                    "lsx.vshuf.b" => "__builtin_lsx_vshuf_b",
                    "lsx.vshuf.d" => "__builtin_lsx_vshuf_d",
                    "lsx.vshuf.h" => "__builtin_lsx_vshuf_h",
                    "lsx.vshuf.w" => "__builtin_lsx_vshuf_w",
                    "lsx.vshuf4i.b" => "__builtin_lsx_vshuf4i_b",
                    "lsx.vshuf4i.d" => "__builtin_lsx_vshuf4i_d",
                    "lsx.vshuf4i.h" => "__builtin_lsx_vshuf4i_h",
                    "lsx.vshuf4i.w" => "__builtin_lsx_vshuf4i_w",
                    "lsx.vsigncov.b" => "__builtin_lsx_vsigncov_b",
                    "lsx.vsigncov.d" => "__builtin_lsx_vsigncov_d",
                    "lsx.vsigncov.h" => "__builtin_lsx_vsigncov_h",
                    "lsx.vsigncov.w" => "__builtin_lsx_vsigncov_w",
                    "lsx.vsle.b" => "__builtin_lsx_vsle_b",
                    "lsx.vsle.bu" => "__builtin_lsx_vsle_bu",
                    "lsx.vsle.d" => "__builtin_lsx_vsle_d",
                    "lsx.vsle.du" => "__builtin_lsx_vsle_du",
                    "lsx.vsle.h" => "__builtin_lsx_vsle_h",
                    "lsx.vsle.hu" => "__builtin_lsx_vsle_hu",
                    "lsx.vsle.w" => "__builtin_lsx_vsle_w",
                    "lsx.vsle.wu" => "__builtin_lsx_vsle_wu",
                    "lsx.vslei.b" => "__builtin_lsx_vslei_b",
                    "lsx.vslei.bu" => "__builtin_lsx_vslei_bu",
                    "lsx.vslei.d" => "__builtin_lsx_vslei_d",
                    "lsx.vslei.du" => "__builtin_lsx_vslei_du",
                    "lsx.vslei.h" => "__builtin_lsx_vslei_h",
                    "lsx.vslei.hu" => "__builtin_lsx_vslei_hu",
                    "lsx.vslei.w" => "__builtin_lsx_vslei_w",
                    "lsx.vslei.wu" => "__builtin_lsx_vslei_wu",
                    "lsx.vsll.b" => "__builtin_lsx_vsll_b",
                    "lsx.vsll.d" => "__builtin_lsx_vsll_d",
                    "lsx.vsll.h" => "__builtin_lsx_vsll_h",
                    "lsx.vsll.w" => "__builtin_lsx_vsll_w",
                    "lsx.vslli.b" => "__builtin_lsx_vslli_b",
                    "lsx.vslli.d" => "__builtin_lsx_vslli_d",
                    "lsx.vslli.h" => "__builtin_lsx_vslli_h",
                    "lsx.vslli.w" => "__builtin_lsx_vslli_w",
                    "lsx.vsllwil.d.w" => "__builtin_lsx_vsllwil_d_w",
                    "lsx.vsllwil.du.wu" => "__builtin_lsx_vsllwil_du_wu",
                    "lsx.vsllwil.h.b" => "__builtin_lsx_vsllwil_h_b",
                    "lsx.vsllwil.hu.bu" => "__builtin_lsx_vsllwil_hu_bu",
                    "lsx.vsllwil.w.h" => "__builtin_lsx_vsllwil_w_h",
                    "lsx.vsllwil.wu.hu" => "__builtin_lsx_vsllwil_wu_hu",
                    "lsx.vslt.b" => "__builtin_lsx_vslt_b",
                    "lsx.vslt.bu" => "__builtin_lsx_vslt_bu",
                    "lsx.vslt.d" => "__builtin_lsx_vslt_d",
                    "lsx.vslt.du" => "__builtin_lsx_vslt_du",
                    "lsx.vslt.h" => "__builtin_lsx_vslt_h",
                    "lsx.vslt.hu" => "__builtin_lsx_vslt_hu",
                    "lsx.vslt.w" => "__builtin_lsx_vslt_w",
                    "lsx.vslt.wu" => "__builtin_lsx_vslt_wu",
                    "lsx.vslti.b" => "__builtin_lsx_vslti_b",
                    "lsx.vslti.bu" => "__builtin_lsx_vslti_bu",
                    "lsx.vslti.d" => "__builtin_lsx_vslti_d",
                    "lsx.vslti.du" => "__builtin_lsx_vslti_du",
                    "lsx.vslti.h" => "__builtin_lsx_vslti_h",
                    "lsx.vslti.hu" => "__builtin_lsx_vslti_hu",
                    "lsx.vslti.w" => "__builtin_lsx_vslti_w",
                    "lsx.vslti.wu" => "__builtin_lsx_vslti_wu",
                    "lsx.vsra.b" => "__builtin_lsx_vsra_b",
                    "lsx.vsra.d" => "__builtin_lsx_vsra_d",
                    "lsx.vsra.h" => "__builtin_lsx_vsra_h",
                    "lsx.vsra.w" => "__builtin_lsx_vsra_w",
                    "lsx.vsrai.b" => "__builtin_lsx_vsrai_b",
                    "lsx.vsrai.d" => "__builtin_lsx_vsrai_d",
                    "lsx.vsrai.h" => "__builtin_lsx_vsrai_h",
                    "lsx.vsrai.w" => "__builtin_lsx_vsrai_w",
                    "lsx.vsran.b.h" => "__builtin_lsx_vsran_b_h",
                    "lsx.vsran.h.w" => "__builtin_lsx_vsran_h_w",
                    "lsx.vsran.w.d" => "__builtin_lsx_vsran_w_d",
                    "lsx.vsrani.b.h" => "__builtin_lsx_vsrani_b_h",
                    "lsx.vsrani.d.q" => "__builtin_lsx_vsrani_d_q",
                    "lsx.vsrani.h.w" => "__builtin_lsx_vsrani_h_w",
                    "lsx.vsrani.w.d" => "__builtin_lsx_vsrani_w_d",
                    "lsx.vsrar.b" => "__builtin_lsx_vsrar_b",
                    "lsx.vsrar.d" => "__builtin_lsx_vsrar_d",
                    "lsx.vsrar.h" => "__builtin_lsx_vsrar_h",
                    "lsx.vsrar.w" => "__builtin_lsx_vsrar_w",
                    "lsx.vsrari.b" => "__builtin_lsx_vsrari_b",
                    "lsx.vsrari.d" => "__builtin_lsx_vsrari_d",
                    "lsx.vsrari.h" => "__builtin_lsx_vsrari_h",
                    "lsx.vsrari.w" => "__builtin_lsx_vsrari_w",
                    "lsx.vsrarn.b.h" => "__builtin_lsx_vsrarn_b_h",
                    "lsx.vsrarn.h.w" => "__builtin_lsx_vsrarn_h_w",
                    "lsx.vsrarn.w.d" => "__builtin_lsx_vsrarn_w_d",
                    "lsx.vsrarni.b.h" => "__builtin_lsx_vsrarni_b_h",
                    "lsx.vsrarni.d.q" => "__builtin_lsx_vsrarni_d_q",
                    "lsx.vsrarni.h.w" => "__builtin_lsx_vsrarni_h_w",
                    "lsx.vsrarni.w.d" => "__builtin_lsx_vsrarni_w_d",
                    "lsx.vsrl.b" => "__builtin_lsx_vsrl_b",
                    "lsx.vsrl.d" => "__builtin_lsx_vsrl_d",
                    "lsx.vsrl.h" => "__builtin_lsx_vsrl_h",
                    "lsx.vsrl.w" => "__builtin_lsx_vsrl_w",
                    "lsx.vsrli.b" => "__builtin_lsx_vsrli_b",
                    "lsx.vsrli.d" => "__builtin_lsx_vsrli_d",
                    "lsx.vsrli.h" => "__builtin_lsx_vsrli_h",
                    "lsx.vsrli.w" => "__builtin_lsx_vsrli_w",
                    "lsx.vsrln.b.h" => "__builtin_lsx_vsrln_b_h",
                    "lsx.vsrln.h.w" => "__builtin_lsx_vsrln_h_w",
                    "lsx.vsrln.w.d" => "__builtin_lsx_vsrln_w_d",
                    "lsx.vsrlni.b.h" => "__builtin_lsx_vsrlni_b_h",
                    "lsx.vsrlni.d.q" => "__builtin_lsx_vsrlni_d_q",
                    "lsx.vsrlni.h.w" => "__builtin_lsx_vsrlni_h_w",
                    "lsx.vsrlni.w.d" => "__builtin_lsx_vsrlni_w_d",
                    "lsx.vsrlr.b" => "__builtin_lsx_vsrlr_b",
                    "lsx.vsrlr.d" => "__builtin_lsx_vsrlr_d",
                    "lsx.vsrlr.h" => "__builtin_lsx_vsrlr_h",
                    "lsx.vsrlr.w" => "__builtin_lsx_vsrlr_w",
                    "lsx.vsrlri.b" => "__builtin_lsx_vsrlri_b",
                    "lsx.vsrlri.d" => "__builtin_lsx_vsrlri_d",
                    "lsx.vsrlri.h" => "__builtin_lsx_vsrlri_h",
                    "lsx.vsrlri.w" => "__builtin_lsx_vsrlri_w",
                    "lsx.vsrlrn.b.h" => "__builtin_lsx_vsrlrn_b_h",
                    "lsx.vsrlrn.h.w" => "__builtin_lsx_vsrlrn_h_w",
                    "lsx.vsrlrn.w.d" => "__builtin_lsx_vsrlrn_w_d",
                    "lsx.vsrlrni.b.h" => "__builtin_lsx_vsrlrni_b_h",
                    "lsx.vsrlrni.d.q" => "__builtin_lsx_vsrlrni_d_q",
                    "lsx.vsrlrni.h.w" => "__builtin_lsx_vsrlrni_h_w",
                    "lsx.vsrlrni.w.d" => "__builtin_lsx_vsrlrni_w_d",
                    "lsx.vssran.b.h" => "__builtin_lsx_vssran_b_h",
                    "lsx.vssran.bu.h" => "__builtin_lsx_vssran_bu_h",
                    "lsx.vssran.h.w" => "__builtin_lsx_vssran_h_w",
                    "lsx.vssran.hu.w" => "__builtin_lsx_vssran_hu_w",
                    "lsx.vssran.w.d" => "__builtin_lsx_vssran_w_d",
                    "lsx.vssran.wu.d" => "__builtin_lsx_vssran_wu_d",
                    "lsx.vssrani.b.h" => "__builtin_lsx_vssrani_b_h",
                    "lsx.vssrani.bu.h" => "__builtin_lsx_vssrani_bu_h",
                    "lsx.vssrani.d.q" => "__builtin_lsx_vssrani_d_q",
                    "lsx.vssrani.du.q" => "__builtin_lsx_vssrani_du_q",
                    "lsx.vssrani.h.w" => "__builtin_lsx_vssrani_h_w",
                    "lsx.vssrani.hu.w" => "__builtin_lsx_vssrani_hu_w",
                    "lsx.vssrani.w.d" => "__builtin_lsx_vssrani_w_d",
                    "lsx.vssrani.wu.d" => "__builtin_lsx_vssrani_wu_d",
                    "lsx.vssrarn.b.h" => "__builtin_lsx_vssrarn_b_h",
                    "lsx.vssrarn.bu.h" => "__builtin_lsx_vssrarn_bu_h",
                    "lsx.vssrarn.h.w" => "__builtin_lsx_vssrarn_h_w",
                    "lsx.vssrarn.hu.w" => "__builtin_lsx_vssrarn_hu_w",
                    "lsx.vssrarn.w.d" => "__builtin_lsx_vssrarn_w_d",
                    "lsx.vssrarn.wu.d" => "__builtin_lsx_vssrarn_wu_d",
                    "lsx.vssrarni.b.h" => "__builtin_lsx_vssrarni_b_h",
                    "lsx.vssrarni.bu.h" => "__builtin_lsx_vssrarni_bu_h",
                    "lsx.vssrarni.d.q" => "__builtin_lsx_vssrarni_d_q",
                    "lsx.vssrarni.du.q" => "__builtin_lsx_vssrarni_du_q",
                    "lsx.vssrarni.h.w" => "__builtin_lsx_vssrarni_h_w",
                    "lsx.vssrarni.hu.w" => "__builtin_lsx_vssrarni_hu_w",
                    "lsx.vssrarni.w.d" => "__builtin_lsx_vssrarni_w_d",
                    "lsx.vssrarni.wu.d" => "__builtin_lsx_vssrarni_wu_d",
                    "lsx.vssrln.b.h" => "__builtin_lsx_vssrln_b_h",
                    "lsx.vssrln.bu.h" => "__builtin_lsx_vssrln_bu_h",
                    "lsx.vssrln.h.w" => "__builtin_lsx_vssrln_h_w",
                    "lsx.vssrln.hu.w" => "__builtin_lsx_vssrln_hu_w",
                    "lsx.vssrln.w.d" => "__builtin_lsx_vssrln_w_d",
                    "lsx.vssrln.wu.d" => "__builtin_lsx_vssrln_wu_d",
                    "lsx.vssrlni.b.h" => "__builtin_lsx_vssrlni_b_h",
                    "lsx.vssrlni.bu.h" => "__builtin_lsx_vssrlni_bu_h",
                    "lsx.vssrlni.d.q" => "__builtin_lsx_vssrlni_d_q",
                    "lsx.vssrlni.du.q" => "__builtin_lsx_vssrlni_du_q",
                    "lsx.vssrlni.h.w" => "__builtin_lsx_vssrlni_h_w",
                    "lsx.vssrlni.hu.w" => "__builtin_lsx_vssrlni_hu_w",
                    "lsx.vssrlni.w.d" => "__builtin_lsx_vssrlni_w_d",
                    "lsx.vssrlni.wu.d" => "__builtin_lsx_vssrlni_wu_d",
                    "lsx.vssrlrn.b.h" => "__builtin_lsx_vssrlrn_b_h",
                    "lsx.vssrlrn.bu.h" => "__builtin_lsx_vssrlrn_bu_h",
                    "lsx.vssrlrn.h.w" => "__builtin_lsx_vssrlrn_h_w",
                    "lsx.vssrlrn.hu.w" => "__builtin_lsx_vssrlrn_hu_w",
                    "lsx.vssrlrn.w.d" => "__builtin_lsx_vssrlrn_w_d",
                    "lsx.vssrlrn.wu.d" => "__builtin_lsx_vssrlrn_wu_d",
                    "lsx.vssrlrni.b.h" => "__builtin_lsx_vssrlrni_b_h",
                    "lsx.vssrlrni.bu.h" => "__builtin_lsx_vssrlrni_bu_h",
                    "lsx.vssrlrni.d.q" => "__builtin_lsx_vssrlrni_d_q",
                    "lsx.vssrlrni.du.q" => "__builtin_lsx_vssrlrni_du_q",
                    "lsx.vssrlrni.h.w" => "__builtin_lsx_vssrlrni_h_w",
                    "lsx.vssrlrni.hu.w" => "__builtin_lsx_vssrlrni_hu_w",
                    "lsx.vssrlrni.w.d" => "__builtin_lsx_vssrlrni_w_d",
                    "lsx.vssrlrni.wu.d" => "__builtin_lsx_vssrlrni_wu_d",
                    "lsx.vssub.b" => "__builtin_lsx_vssub_b",
                    "lsx.vssub.bu" => "__builtin_lsx_vssub_bu",
                    "lsx.vssub.d" => "__builtin_lsx_vssub_d",
                    "lsx.vssub.du" => "__builtin_lsx_vssub_du",
                    "lsx.vssub.h" => "__builtin_lsx_vssub_h",
                    "lsx.vssub.hu" => "__builtin_lsx_vssub_hu",
                    "lsx.vssub.w" => "__builtin_lsx_vssub_w",
                    "lsx.vssub.wu" => "__builtin_lsx_vssub_wu",
                    "lsx.vst" => "__builtin_lsx_vst",
                    "lsx.vstelm.b" => "__builtin_lsx_vstelm_b",
                    "lsx.vstelm.d" => "__builtin_lsx_vstelm_d",
                    "lsx.vstelm.h" => "__builtin_lsx_vstelm_h",
                    "lsx.vstelm.w" => "__builtin_lsx_vstelm_w",
                    "lsx.vstx" => "__builtin_lsx_vstx",
                    "lsx.vsub.b" => "__builtin_lsx_vsub_b",
                    "lsx.vsub.d" => "__builtin_lsx_vsub_d",
                    "lsx.vsub.h" => "__builtin_lsx_vsub_h",
                    "lsx.vsub.q" => "__builtin_lsx_vsub_q",
                    "lsx.vsub.w" => "__builtin_lsx_vsub_w",
                    "lsx.vsubi.bu" => "__builtin_lsx_vsubi_bu",
                    "lsx.vsubi.du" => "__builtin_lsx_vsubi_du",
                    "lsx.vsubi.hu" => "__builtin_lsx_vsubi_hu",
                    "lsx.vsubi.wu" => "__builtin_lsx_vsubi_wu",
                    "lsx.vsubwev.d.w" => "__builtin_lsx_vsubwev_d_w",
                    "lsx.vsubwev.d.wu" => "__builtin_lsx_vsubwev_d_wu",
                    "lsx.vsubwev.h.b" => "__builtin_lsx_vsubwev_h_b",
                    "lsx.vsubwev.h.bu" => "__builtin_lsx_vsubwev_h_bu",
                    "lsx.vsubwev.q.d" => "__builtin_lsx_vsubwev_q_d",
                    "lsx.vsubwev.q.du" => "__builtin_lsx_vsubwev_q_du",
                    "lsx.vsubwev.w.h" => "__builtin_lsx_vsubwev_w_h",
                    "lsx.vsubwev.w.hu" => "__builtin_lsx_vsubwev_w_hu",
                    "lsx.vsubwod.d.w" => "__builtin_lsx_vsubwod_d_w",
                    "lsx.vsubwod.d.wu" => "__builtin_lsx_vsubwod_d_wu",
                    "lsx.vsubwod.h.b" => "__builtin_lsx_vsubwod_h_b",
                    "lsx.vsubwod.h.bu" => "__builtin_lsx_vsubwod_h_bu",
                    "lsx.vsubwod.q.d" => "__builtin_lsx_vsubwod_q_d",
                    "lsx.vsubwod.q.du" => "__builtin_lsx_vsubwod_q_du",
                    "lsx.vsubwod.w.h" => "__builtin_lsx_vsubwod_w_h",
                    "lsx.vsubwod.w.hu" => "__builtin_lsx_vsubwod_w_hu",
                    "lsx.vxor.v" => "__builtin_lsx_vxor_v",
                    "lsx.vxori.b" => "__builtin_lsx_vxori_b",
                    "movfcsr2gr" => "__builtin_loongarch_movfcsr2gr",
                    "movgr2fcsr" => "__builtin_loongarch_movgr2fcsr",
                    "syscall" => "__builtin_loongarch_syscall",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            loongarch(name, full_name)
        }
        "mips" => {
            fn mips(name: &str, full_name: &str) -> &'static str {
                match name {
                    // mips
                    "absq.s.ph" => "__builtin_mips_absq_s_ph",
                    "absq.s.qb" => "__builtin_mips_absq_s_qb",
                    "absq.s.w" => "__builtin_mips_absq_s_w",
                    "add.a.b" => "__builtin_msa_add_a_b",
                    "add.a.d" => "__builtin_msa_add_a_d",
                    "add.a.h" => "__builtin_msa_add_a_h",
                    "add.a.w" => "__builtin_msa_add_a_w",
                    "addq.ph" => "__builtin_mips_addq_ph",
                    "addq.s.ph" => "__builtin_mips_addq_s_ph",
                    "addq.s.w" => "__builtin_mips_addq_s_w",
                    "addqh.ph" => "__builtin_mips_addqh_ph",
                    "addqh.r.ph" => "__builtin_mips_addqh_r_ph",
                    "addqh.r.w" => "__builtin_mips_addqh_r_w",
                    "addqh.w" => "__builtin_mips_addqh_w",
                    "adds.a.b" => "__builtin_msa_adds_a_b",
                    "adds.a.d" => "__builtin_msa_adds_a_d",
                    "adds.a.h" => "__builtin_msa_adds_a_h",
                    "adds.a.w" => "__builtin_msa_adds_a_w",
                    "adds.s.b" => "__builtin_msa_adds_s_b",
                    "adds.s.d" => "__builtin_msa_adds_s_d",
                    "adds.s.h" => "__builtin_msa_adds_s_h",
                    "adds.s.w" => "__builtin_msa_adds_s_w",
                    "adds.u.b" => "__builtin_msa_adds_u_b",
                    "adds.u.d" => "__builtin_msa_adds_u_d",
                    "adds.u.h" => "__builtin_msa_adds_u_h",
                    "adds.u.w" => "__builtin_msa_adds_u_w",
                    "addsc" => "__builtin_mips_addsc",
                    "addu.ph" => "__builtin_mips_addu_ph",
                    "addu.qb" => "__builtin_mips_addu_qb",
                    "addu.s.ph" => "__builtin_mips_addu_s_ph",
                    "addu.s.qb" => "__builtin_mips_addu_s_qb",
                    "adduh.qb" => "__builtin_mips_adduh_qb",
                    "adduh.r.qb" => "__builtin_mips_adduh_r_qb",
                    "addv.b" => "__builtin_msa_addv_b",
                    "addv.d" => "__builtin_msa_addv_d",
                    "addv.h" => "__builtin_msa_addv_h",
                    "addv.w" => "__builtin_msa_addv_w",
                    "addvi.b" => "__builtin_msa_addvi_b",
                    "addvi.d" => "__builtin_msa_addvi_d",
                    "addvi.h" => "__builtin_msa_addvi_h",
                    "addvi.w" => "__builtin_msa_addvi_w",
                    "addwc" => "__builtin_mips_addwc",
                    "and.v" => "__builtin_msa_and_v",
                    "andi.b" => "__builtin_msa_andi_b",
                    "append" => "__builtin_mips_append",
                    "asub.s.b" => "__builtin_msa_asub_s_b",
                    "asub.s.d" => "__builtin_msa_asub_s_d",
                    "asub.s.h" => "__builtin_msa_asub_s_h",
                    "asub.s.w" => "__builtin_msa_asub_s_w",
                    "asub.u.b" => "__builtin_msa_asub_u_b",
                    "asub.u.d" => "__builtin_msa_asub_u_d",
                    "asub.u.h" => "__builtin_msa_asub_u_h",
                    "asub.u.w" => "__builtin_msa_asub_u_w",
                    "ave.s.b" => "__builtin_msa_ave_s_b",
                    "ave.s.d" => "__builtin_msa_ave_s_d",
                    "ave.s.h" => "__builtin_msa_ave_s_h",
                    "ave.s.w" => "__builtin_msa_ave_s_w",
                    "ave.u.b" => "__builtin_msa_ave_u_b",
                    "ave.u.d" => "__builtin_msa_ave_u_d",
                    "ave.u.h" => "__builtin_msa_ave_u_h",
                    "ave.u.w" => "__builtin_msa_ave_u_w",
                    "aver.s.b" => "__builtin_msa_aver_s_b",
                    "aver.s.d" => "__builtin_msa_aver_s_d",
                    "aver.s.h" => "__builtin_msa_aver_s_h",
                    "aver.s.w" => "__builtin_msa_aver_s_w",
                    "aver.u.b" => "__builtin_msa_aver_u_b",
                    "aver.u.d" => "__builtin_msa_aver_u_d",
                    "aver.u.h" => "__builtin_msa_aver_u_h",
                    "aver.u.w" => "__builtin_msa_aver_u_w",
                    "balign" => "__builtin_mips_balign",
                    "bclr.b" => "__builtin_msa_bclr_b",
                    "bclr.d" => "__builtin_msa_bclr_d",
                    "bclr.h" => "__builtin_msa_bclr_h",
                    "bclr.w" => "__builtin_msa_bclr_w",
                    "bclri.b" => "__builtin_msa_bclri_b",
                    "bclri.d" => "__builtin_msa_bclri_d",
                    "bclri.h" => "__builtin_msa_bclri_h",
                    "bclri.w" => "__builtin_msa_bclri_w",
                    "binsl.b" => "__builtin_msa_binsl_b",
                    "binsl.d" => "__builtin_msa_binsl_d",
                    "binsl.h" => "__builtin_msa_binsl_h",
                    "binsl.w" => "__builtin_msa_binsl_w",
                    "binsli.b" => "__builtin_msa_binsli_b",
                    "binsli.d" => "__builtin_msa_binsli_d",
                    "binsli.h" => "__builtin_msa_binsli_h",
                    "binsli.w" => "__builtin_msa_binsli_w",
                    "binsr.b" => "__builtin_msa_binsr_b",
                    "binsr.d" => "__builtin_msa_binsr_d",
                    "binsr.h" => "__builtin_msa_binsr_h",
                    "binsr.w" => "__builtin_msa_binsr_w",
                    "binsri.b" => "__builtin_msa_binsri_b",
                    "binsri.d" => "__builtin_msa_binsri_d",
                    "binsri.h" => "__builtin_msa_binsri_h",
                    "binsri.w" => "__builtin_msa_binsri_w",
                    "bitrev" => "__builtin_mips_bitrev",
                    "bmnz.v" => "__builtin_msa_bmnz_v",
                    "bmnzi.b" => "__builtin_msa_bmnzi_b",
                    "bmz.v" => "__builtin_msa_bmz_v",
                    "bmzi.b" => "__builtin_msa_bmzi_b",
                    "bneg.b" => "__builtin_msa_bneg_b",
                    "bneg.d" => "__builtin_msa_bneg_d",
                    "bneg.h" => "__builtin_msa_bneg_h",
                    "bneg.w" => "__builtin_msa_bneg_w",
                    "bnegi.b" => "__builtin_msa_bnegi_b",
                    "bnegi.d" => "__builtin_msa_bnegi_d",
                    "bnegi.h" => "__builtin_msa_bnegi_h",
                    "bnegi.w" => "__builtin_msa_bnegi_w",
                    "bnz.b" => "__builtin_msa_bnz_b",
                    "bnz.d" => "__builtin_msa_bnz_d",
                    "bnz.h" => "__builtin_msa_bnz_h",
                    "bnz.v" => "__builtin_msa_bnz_v",
                    "bnz.w" => "__builtin_msa_bnz_w",
                    "bposge32" => "__builtin_mips_bposge32",
                    "bsel.v" => "__builtin_msa_bsel_v",
                    "bseli.b" => "__builtin_msa_bseli_b",
                    "bset.b" => "__builtin_msa_bset_b",
                    "bset.d" => "__builtin_msa_bset_d",
                    "bset.h" => "__builtin_msa_bset_h",
                    "bset.w" => "__builtin_msa_bset_w",
                    "bseti.b" => "__builtin_msa_bseti_b",
                    "bseti.d" => "__builtin_msa_bseti_d",
                    "bseti.h" => "__builtin_msa_bseti_h",
                    "bseti.w" => "__builtin_msa_bseti_w",
                    "bz.b" => "__builtin_msa_bz_b",
                    "bz.d" => "__builtin_msa_bz_d",
                    "bz.h" => "__builtin_msa_bz_h",
                    "bz.v" => "__builtin_msa_bz_v",
                    "bz.w" => "__builtin_msa_bz_w",
                    "ceq.b" => "__builtin_msa_ceq_b",
                    "ceq.d" => "__builtin_msa_ceq_d",
                    "ceq.h" => "__builtin_msa_ceq_h",
                    "ceq.w" => "__builtin_msa_ceq_w",
                    "ceqi.b" => "__builtin_msa_ceqi_b",
                    "ceqi.d" => "__builtin_msa_ceqi_d",
                    "ceqi.h" => "__builtin_msa_ceqi_h",
                    "ceqi.w" => "__builtin_msa_ceqi_w",
                    "cfcmsa" => "__builtin_msa_cfcmsa",
                    "cle.s.b" => "__builtin_msa_cle_s_b",
                    "cle.s.d" => "__builtin_msa_cle_s_d",
                    "cle.s.h" => "__builtin_msa_cle_s_h",
                    "cle.s.w" => "__builtin_msa_cle_s_w",
                    "cle.u.b" => "__builtin_msa_cle_u_b",
                    "cle.u.d" => "__builtin_msa_cle_u_d",
                    "cle.u.h" => "__builtin_msa_cle_u_h",
                    "cle.u.w" => "__builtin_msa_cle_u_w",
                    "clei.s.b" => "__builtin_msa_clei_s_b",
                    "clei.s.d" => "__builtin_msa_clei_s_d",
                    "clei.s.h" => "__builtin_msa_clei_s_h",
                    "clei.s.w" => "__builtin_msa_clei_s_w",
                    "clei.u.b" => "__builtin_msa_clei_u_b",
                    "clei.u.d" => "__builtin_msa_clei_u_d",
                    "clei.u.h" => "__builtin_msa_clei_u_h",
                    "clei.u.w" => "__builtin_msa_clei_u_w",
                    "clt.s.b" => "__builtin_msa_clt_s_b",
                    "clt.s.d" => "__builtin_msa_clt_s_d",
                    "clt.s.h" => "__builtin_msa_clt_s_h",
                    "clt.s.w" => "__builtin_msa_clt_s_w",
                    "clt.u.b" => "__builtin_msa_clt_u_b",
                    "clt.u.d" => "__builtin_msa_clt_u_d",
                    "clt.u.h" => "__builtin_msa_clt_u_h",
                    "clt.u.w" => "__builtin_msa_clt_u_w",
                    "clti.s.b" => "__builtin_msa_clti_s_b",
                    "clti.s.d" => "__builtin_msa_clti_s_d",
                    "clti.s.h" => "__builtin_msa_clti_s_h",
                    "clti.s.w" => "__builtin_msa_clti_s_w",
                    "clti.u.b" => "__builtin_msa_clti_u_b",
                    "clti.u.d" => "__builtin_msa_clti_u_d",
                    "clti.u.h" => "__builtin_msa_clti_u_h",
                    "clti.u.w" => "__builtin_msa_clti_u_w",
                    "cmp.eq.ph" => "__builtin_mips_cmp_eq_ph",
                    "cmp.le.ph" => "__builtin_mips_cmp_le_ph",
                    "cmp.lt.ph" => "__builtin_mips_cmp_lt_ph",
                    "cmpgdu.eq.qb" => "__builtin_mips_cmpgdu_eq_qb",
                    "cmpgdu.le.qb" => "__builtin_mips_cmpgdu_le_qb",
                    "cmpgdu.lt.qb" => "__builtin_mips_cmpgdu_lt_qb",
                    "cmpgu.eq.qb" => "__builtin_mips_cmpgu_eq_qb",
                    "cmpgu.le.qb" => "__builtin_mips_cmpgu_le_qb",
                    "cmpgu.lt.qb" => "__builtin_mips_cmpgu_lt_qb",
                    "cmpu.eq.qb" => "__builtin_mips_cmpu_eq_qb",
                    "cmpu.le.qb" => "__builtin_mips_cmpu_le_qb",
                    "cmpu.lt.qb" => "__builtin_mips_cmpu_lt_qb",
                    "copy.s.b" => "__builtin_msa_copy_s_b",
                    "copy.s.d" => "__builtin_msa_copy_s_d",
                    "copy.s.h" => "__builtin_msa_copy_s_h",
                    "copy.s.w" => "__builtin_msa_copy_s_w",
                    "copy.u.b" => "__builtin_msa_copy_u_b",
                    "copy.u.d" => "__builtin_msa_copy_u_d",
                    "copy.u.h" => "__builtin_msa_copy_u_h",
                    "copy.u.w" => "__builtin_msa_copy_u_w",
                    "ctcmsa" => "__builtin_msa_ctcmsa",
                    "div.s.b" => "__builtin_msa_div_s_b",
                    "div.s.d" => "__builtin_msa_div_s_d",
                    "div.s.h" => "__builtin_msa_div_s_h",
                    "div.s.w" => "__builtin_msa_div_s_w",
                    "div.u.b" => "__builtin_msa_div_u_b",
                    "div.u.d" => "__builtin_msa_div_u_d",
                    "div.u.h" => "__builtin_msa_div_u_h",
                    "div.u.w" => "__builtin_msa_div_u_w",
                    "dlsa" => "__builtin_mips_dlsa",
                    "dotp.s.d" => "__builtin_msa_dotp_s_d",
                    "dotp.s.h" => "__builtin_msa_dotp_s_h",
                    "dotp.s.w" => "__builtin_msa_dotp_s_w",
                    "dotp.u.d" => "__builtin_msa_dotp_u_d",
                    "dotp.u.h" => "__builtin_msa_dotp_u_h",
                    "dotp.u.w" => "__builtin_msa_dotp_u_w",
                    "dpa.w.ph" => "__builtin_mips_dpa_w_ph",
                    "dpadd.s.d" => "__builtin_msa_dpadd_s_d",
                    "dpadd.s.h" => "__builtin_msa_dpadd_s_h",
                    "dpadd.s.w" => "__builtin_msa_dpadd_s_w",
                    "dpadd.u.d" => "__builtin_msa_dpadd_u_d",
                    "dpadd.u.h" => "__builtin_msa_dpadd_u_h",
                    "dpadd.u.w" => "__builtin_msa_dpadd_u_w",
                    "dpaq.s.w.ph" => "__builtin_mips_dpaq_s_w_ph",
                    "dpaq.sa.l.w" => "__builtin_mips_dpaq_sa_l_w",
                    "dpaqx.s.w.ph" => "__builtin_mips_dpaqx_s_w_ph",
                    "dpaqx.sa.w.ph" => "__builtin_mips_dpaqx_sa_w_ph",
                    "dpau.h.qbl" => "__builtin_mips_dpau_h_qbl",
                    "dpau.h.qbr" => "__builtin_mips_dpau_h_qbr",
                    "dpax.w.ph" => "__builtin_mips_dpax_w_ph",
                    "dps.w.ph" => "__builtin_mips_dps_w_ph",
                    "dpsq.s.w.ph" => "__builtin_mips_dpsq_s_w_ph",
                    "dpsq.sa.l.w" => "__builtin_mips_dpsq_sa_l_w",
                    "dpsqx.s.w.ph" => "__builtin_mips_dpsqx_s_w_ph",
                    "dpsqx.sa.w.ph" => "__builtin_mips_dpsqx_sa_w_ph",
                    "dpsu.h.qbl" => "__builtin_mips_dpsu_h_qbl",
                    "dpsu.h.qbr" => "__builtin_mips_dpsu_h_qbr",
                    "dpsub.s.d" => "__builtin_msa_dpsub_s_d",
                    "dpsub.s.h" => "__builtin_msa_dpsub_s_h",
                    "dpsub.s.w" => "__builtin_msa_dpsub_s_w",
                    "dpsub.u.d" => "__builtin_msa_dpsub_u_d",
                    "dpsub.u.h" => "__builtin_msa_dpsub_u_h",
                    "dpsub.u.w" => "__builtin_msa_dpsub_u_w",
                    "dpsx.w.ph" => "__builtin_mips_dpsx_w_ph",
                    "extp" => "__builtin_mips_extp",
                    "extpdp" => "__builtin_mips_extpdp",
                    "extr.r.w" => "__builtin_mips_extr_r_w",
                    "extr.rs.w" => "__builtin_mips_extr_rs_w",
                    "extr.s.h" => "__builtin_mips_extr_s_h",
                    "extr.w" => "__builtin_mips_extr_w",
                    "fadd.d" => "__builtin_msa_fadd_d",
                    "fadd.w" => "__builtin_msa_fadd_w",
                    "fcaf.d" => "__builtin_msa_fcaf_d",
                    "fcaf.w" => "__builtin_msa_fcaf_w",
                    "fceq.d" => "__builtin_msa_fceq_d",
                    "fceq.w" => "__builtin_msa_fceq_w",
                    "fclass.d" => "__builtin_msa_fclass_d",
                    "fclass.w" => "__builtin_msa_fclass_w",
                    "fcle.d" => "__builtin_msa_fcle_d",
                    "fcle.w" => "__builtin_msa_fcle_w",
                    "fclt.d" => "__builtin_msa_fclt_d",
                    "fclt.w" => "__builtin_msa_fclt_w",
                    "fcne.d" => "__builtin_msa_fcne_d",
                    "fcne.w" => "__builtin_msa_fcne_w",
                    "fcor.d" => "__builtin_msa_fcor_d",
                    "fcor.w" => "__builtin_msa_fcor_w",
                    "fcueq.d" => "__builtin_msa_fcueq_d",
                    "fcueq.w" => "__builtin_msa_fcueq_w",
                    "fcule.d" => "__builtin_msa_fcule_d",
                    "fcule.w" => "__builtin_msa_fcule_w",
                    "fcult.d" => "__builtin_msa_fcult_d",
                    "fcult.w" => "__builtin_msa_fcult_w",
                    "fcun.d" => "__builtin_msa_fcun_d",
                    "fcun.w" => "__builtin_msa_fcun_w",
                    "fcune.d" => "__builtin_msa_fcune_d",
                    "fcune.w" => "__builtin_msa_fcune_w",
                    "fdiv.d" => "__builtin_msa_fdiv_d",
                    "fdiv.w" => "__builtin_msa_fdiv_w",
                    "fexdo.h" => "__builtin_msa_fexdo_h",
                    "fexdo.w" => "__builtin_msa_fexdo_w",
                    "fexp2.d" => "__builtin_msa_fexp2_d",
                    "fexp2.w" => "__builtin_msa_fexp2_w",
                    "fexupl.d" => "__builtin_msa_fexupl_d",
                    "fexupl.w" => "__builtin_msa_fexupl_w",
                    "fexupr.d" => "__builtin_msa_fexupr_d",
                    "fexupr.w" => "__builtin_msa_fexupr_w",
                    "ffint.s.d" => "__builtin_msa_ffint_s_d",
                    "ffint.s.w" => "__builtin_msa_ffint_s_w",
                    "ffint.u.d" => "__builtin_msa_ffint_u_d",
                    "ffint.u.w" => "__builtin_msa_ffint_u_w",
                    "ffql.d" => "__builtin_msa_ffql_d",
                    "ffql.w" => "__builtin_msa_ffql_w",
                    "ffqr.d" => "__builtin_msa_ffqr_d",
                    "ffqr.w" => "__builtin_msa_ffqr_w",
                    "fill.b" => "__builtin_msa_fill_b",
                    "fill.d" => "__builtin_msa_fill_d",
                    "fill.h" => "__builtin_msa_fill_h",
                    "fill.w" => "__builtin_msa_fill_w",
                    "flog2.d" => "__builtin_msa_flog2_d",
                    "flog2.w" => "__builtin_msa_flog2_w",
                    "fmadd.d" => "__builtin_msa_fmadd_d",
                    "fmadd.w" => "__builtin_msa_fmadd_w",
                    "fmax.a.d" => "__builtin_msa_fmax_a_d",
                    "fmax.a.w" => "__builtin_msa_fmax_a_w",
                    "fmax.d" => "__builtin_msa_fmax_d",
                    "fmax.w" => "__builtin_msa_fmax_w",
                    "fmin.a.d" => "__builtin_msa_fmin_a_d",
                    "fmin.a.w" => "__builtin_msa_fmin_a_w",
                    "fmin.d" => "__builtin_msa_fmin_d",
                    "fmin.w" => "__builtin_msa_fmin_w",
                    "fmsub.d" => "__builtin_msa_fmsub_d",
                    "fmsub.w" => "__builtin_msa_fmsub_w",
                    "fmul.d" => "__builtin_msa_fmul_d",
                    "fmul.w" => "__builtin_msa_fmul_w",
                    "frcp.d" => "__builtin_msa_frcp_d",
                    "frcp.w" => "__builtin_msa_frcp_w",
                    "frint.d" => "__builtin_msa_frint_d",
                    "frint.w" => "__builtin_msa_frint_w",
                    "frsqrt.d" => "__builtin_msa_frsqrt_d",
                    "frsqrt.w" => "__builtin_msa_frsqrt_w",
                    "fsaf.d" => "__builtin_msa_fsaf_d",
                    "fsaf.w" => "__builtin_msa_fsaf_w",
                    "fseq.d" => "__builtin_msa_fseq_d",
                    "fseq.w" => "__builtin_msa_fseq_w",
                    "fsle.d" => "__builtin_msa_fsle_d",
                    "fsle.w" => "__builtin_msa_fsle_w",
                    "fslt.d" => "__builtin_msa_fslt_d",
                    "fslt.w" => "__builtin_msa_fslt_w",
                    "fsne.d" => "__builtin_msa_fsne_d",
                    "fsne.w" => "__builtin_msa_fsne_w",
                    "fsor.d" => "__builtin_msa_fsor_d",
                    "fsor.w" => "__builtin_msa_fsor_w",
                    "fsqrt.d" => "__builtin_msa_fsqrt_d",
                    "fsqrt.w" => "__builtin_msa_fsqrt_w",
                    "fsub.d" => "__builtin_msa_fsub_d",
                    "fsub.w" => "__builtin_msa_fsub_w",
                    "fsueq.d" => "__builtin_msa_fsueq_d",
                    "fsueq.w" => "__builtin_msa_fsueq_w",
                    "fsule.d" => "__builtin_msa_fsule_d",
                    "fsule.w" => "__builtin_msa_fsule_w",
                    "fsult.d" => "__builtin_msa_fsult_d",
                    "fsult.w" => "__builtin_msa_fsult_w",
                    "fsun.d" => "__builtin_msa_fsun_d",
                    "fsun.w" => "__builtin_msa_fsun_w",
                    "fsune.d" => "__builtin_msa_fsune_d",
                    "fsune.w" => "__builtin_msa_fsune_w",
                    "ftint.s.d" => "__builtin_msa_ftint_s_d",
                    "ftint.s.w" => "__builtin_msa_ftint_s_w",
                    "ftint.u.d" => "__builtin_msa_ftint_u_d",
                    "ftint.u.w" => "__builtin_msa_ftint_u_w",
                    "ftq.h" => "__builtin_msa_ftq_h",
                    "ftq.w" => "__builtin_msa_ftq_w",
                    "ftrunc.s.d" => "__builtin_msa_ftrunc_s_d",
                    "ftrunc.s.w" => "__builtin_msa_ftrunc_s_w",
                    "ftrunc.u.d" => "__builtin_msa_ftrunc_u_d",
                    "ftrunc.u.w" => "__builtin_msa_ftrunc_u_w",
                    "hadd.s.d" => "__builtin_msa_hadd_s_d",
                    "hadd.s.h" => "__builtin_msa_hadd_s_h",
                    "hadd.s.w" => "__builtin_msa_hadd_s_w",
                    "hadd.u.d" => "__builtin_msa_hadd_u_d",
                    "hadd.u.h" => "__builtin_msa_hadd_u_h",
                    "hadd.u.w" => "__builtin_msa_hadd_u_w",
                    "hsub.s.d" => "__builtin_msa_hsub_s_d",
                    "hsub.s.h" => "__builtin_msa_hsub_s_h",
                    "hsub.s.w" => "__builtin_msa_hsub_s_w",
                    "hsub.u.d" => "__builtin_msa_hsub_u_d",
                    "hsub.u.h" => "__builtin_msa_hsub_u_h",
                    "hsub.u.w" => "__builtin_msa_hsub_u_w",
                    "ilvev.b" => "__builtin_msa_ilvev_b",
                    "ilvev.d" => "__builtin_msa_ilvev_d",
                    "ilvev.h" => "__builtin_msa_ilvev_h",
                    "ilvev.w" => "__builtin_msa_ilvev_w",
                    "ilvl.b" => "__builtin_msa_ilvl_b",
                    "ilvl.d" => "__builtin_msa_ilvl_d",
                    "ilvl.h" => "__builtin_msa_ilvl_h",
                    "ilvl.w" => "__builtin_msa_ilvl_w",
                    "ilvod.b" => "__builtin_msa_ilvod_b",
                    "ilvod.d" => "__builtin_msa_ilvod_d",
                    "ilvod.h" => "__builtin_msa_ilvod_h",
                    "ilvod.w" => "__builtin_msa_ilvod_w",
                    "ilvr.b" => "__builtin_msa_ilvr_b",
                    "ilvr.d" => "__builtin_msa_ilvr_d",
                    "ilvr.h" => "__builtin_msa_ilvr_h",
                    "ilvr.w" => "__builtin_msa_ilvr_w",
                    "insert.b" => "__builtin_msa_insert_b",
                    "insert.d" => "__builtin_msa_insert_d",
                    "insert.h" => "__builtin_msa_insert_h",
                    "insert.w" => "__builtin_msa_insert_w",
                    "insv" => "__builtin_mips_insv",
                    "insve.b" => "__builtin_msa_insve_b",
                    "insve.d" => "__builtin_msa_insve_d",
                    "insve.h" => "__builtin_msa_insve_h",
                    "insve.w" => "__builtin_msa_insve_w",
                    "lbux" => "__builtin_mips_lbux",
                    "ld.b" => "__builtin_msa_ld_b",
                    "ld.d" => "__builtin_msa_ld_d",
                    "ld.h" => "__builtin_msa_ld_h",
                    "ld.w" => "__builtin_msa_ld_w",
                    "ldi.b" => "__builtin_msa_ldi_b",
                    "ldi.d" => "__builtin_msa_ldi_d",
                    "ldi.h" => "__builtin_msa_ldi_h",
                    "ldi.w" => "__builtin_msa_ldi_w",
                    "ldr.d" => "__builtin_msa_ldr_d",
                    "ldr.w" => "__builtin_msa_ldr_w",
                    "lhx" => "__builtin_mips_lhx",
                    "lsa" => "__builtin_mips_lsa",
                    "lwx" => "__builtin_mips_lwx",
                    "madd" => "__builtin_mips_madd",
                    "madd.q.h" => "__builtin_msa_madd_q_h",
                    "madd.q.w" => "__builtin_msa_madd_q_w",
                    "maddr.q.h" => "__builtin_msa_maddr_q_h",
                    "maddr.q.w" => "__builtin_msa_maddr_q_w",
                    "maddu" => "__builtin_mips_maddu",
                    "maddv.b" => "__builtin_msa_maddv_b",
                    "maddv.d" => "__builtin_msa_maddv_d",
                    "maddv.h" => "__builtin_msa_maddv_h",
                    "maddv.w" => "__builtin_msa_maddv_w",
                    "maq.s.w.phl" => "__builtin_mips_maq_s_w_phl",
                    "maq.s.w.phr" => "__builtin_mips_maq_s_w_phr",
                    "maq.sa.w.phl" => "__builtin_mips_maq_sa_w_phl",
                    "maq.sa.w.phr" => "__builtin_mips_maq_sa_w_phr",
                    "max.a.b" => "__builtin_msa_max_a_b",
                    "max.a.d" => "__builtin_msa_max_a_d",
                    "max.a.h" => "__builtin_msa_max_a_h",
                    "max.a.w" => "__builtin_msa_max_a_w",
                    "max.s.b" => "__builtin_msa_max_s_b",
                    "max.s.d" => "__builtin_msa_max_s_d",
                    "max.s.h" => "__builtin_msa_max_s_h",
                    "max.s.w" => "__builtin_msa_max_s_w",
                    "max.u.b" => "__builtin_msa_max_u_b",
                    "max.u.d" => "__builtin_msa_max_u_d",
                    "max.u.h" => "__builtin_msa_max_u_h",
                    "max.u.w" => "__builtin_msa_max_u_w",
                    "maxi.s.b" => "__builtin_msa_maxi_s_b",
                    "maxi.s.d" => "__builtin_msa_maxi_s_d",
                    "maxi.s.h" => "__builtin_msa_maxi_s_h",
                    "maxi.s.w" => "__builtin_msa_maxi_s_w",
                    "maxi.u.b" => "__builtin_msa_maxi_u_b",
                    "maxi.u.d" => "__builtin_msa_maxi_u_d",
                    "maxi.u.h" => "__builtin_msa_maxi_u_h",
                    "maxi.u.w" => "__builtin_msa_maxi_u_w",
                    "min.a.b" => "__builtin_msa_min_a_b",
                    "min.a.d" => "__builtin_msa_min_a_d",
                    "min.a.h" => "__builtin_msa_min_a_h",
                    "min.a.w" => "__builtin_msa_min_a_w",
                    "min.s.b" => "__builtin_msa_min_s_b",
                    "min.s.d" => "__builtin_msa_min_s_d",
                    "min.s.h" => "__builtin_msa_min_s_h",
                    "min.s.w" => "__builtin_msa_min_s_w",
                    "min.u.b" => "__builtin_msa_min_u_b",
                    "min.u.d" => "__builtin_msa_min_u_d",
                    "min.u.h" => "__builtin_msa_min_u_h",
                    "min.u.w" => "__builtin_msa_min_u_w",
                    "mini.s.b" => "__builtin_msa_mini_s_b",
                    "mini.s.d" => "__builtin_msa_mini_s_d",
                    "mini.s.h" => "__builtin_msa_mini_s_h",
                    "mini.s.w" => "__builtin_msa_mini_s_w",
                    "mini.u.b" => "__builtin_msa_mini_u_b",
                    "mini.u.d" => "__builtin_msa_mini_u_d",
                    "mini.u.h" => "__builtin_msa_mini_u_h",
                    "mini.u.w" => "__builtin_msa_mini_u_w",
                    "mod.s.b" => "__builtin_msa_mod_s_b",
                    "mod.s.d" => "__builtin_msa_mod_s_d",
                    "mod.s.h" => "__builtin_msa_mod_s_h",
                    "mod.s.w" => "__builtin_msa_mod_s_w",
                    "mod.u.b" => "__builtin_msa_mod_u_b",
                    "mod.u.d" => "__builtin_msa_mod_u_d",
                    "mod.u.h" => "__builtin_msa_mod_u_h",
                    "mod.u.w" => "__builtin_msa_mod_u_w",
                    "modsub" => "__builtin_mips_modsub",
                    "move.v" => "__builtin_msa_move_v",
                    "msub" => "__builtin_mips_msub",
                    "msub.q.h" => "__builtin_msa_msub_q_h",
                    "msub.q.w" => "__builtin_msa_msub_q_w",
                    "msubr.q.h" => "__builtin_msa_msubr_q_h",
                    "msubr.q.w" => "__builtin_msa_msubr_q_w",
                    "msubu" => "__builtin_mips_msubu",
                    "msubv.b" => "__builtin_msa_msubv_b",
                    "msubv.d" => "__builtin_msa_msubv_d",
                    "msubv.h" => "__builtin_msa_msubv_h",
                    "msubv.w" => "__builtin_msa_msubv_w",
                    "mthlip" => "__builtin_mips_mthlip",
                    "mul.ph" => "__builtin_mips_mul_ph",
                    "mul.q.h" => "__builtin_msa_mul_q_h",
                    "mul.q.w" => "__builtin_msa_mul_q_w",
                    "mul.s.ph" => "__builtin_mips_mul_s_ph",
                    "muleq.s.w.phl" => "__builtin_mips_muleq_s_w_phl",
                    "muleq.s.w.phr" => "__builtin_mips_muleq_s_w_phr",
                    "muleu.s.ph.qbl" => "__builtin_mips_muleu_s_ph_qbl",
                    "muleu.s.ph.qbr" => "__builtin_mips_muleu_s_ph_qbr",
                    "mulq.rs.ph" => "__builtin_mips_mulq_rs_ph",
                    "mulq.rs.w" => "__builtin_mips_mulq_rs_w",
                    "mulq.s.ph" => "__builtin_mips_mulq_s_ph",
                    "mulq.s.w" => "__builtin_mips_mulq_s_w",
                    "mulr.q.h" => "__builtin_msa_mulr_q_h",
                    "mulr.q.w" => "__builtin_msa_mulr_q_w",
                    "mulsa.w.ph" => "__builtin_mips_mulsa_w_ph",
                    "mulsaq.s.w.ph" => "__builtin_mips_mulsaq_s_w_ph",
                    "mult" => "__builtin_mips_mult",
                    "multu" => "__builtin_mips_multu",
                    "mulv.b" => "__builtin_msa_mulv_b",
                    "mulv.d" => "__builtin_msa_mulv_d",
                    "mulv.h" => "__builtin_msa_mulv_h",
                    "mulv.w" => "__builtin_msa_mulv_w",
                    "nloc.b" => "__builtin_msa_nloc_b",
                    "nloc.d" => "__builtin_msa_nloc_d",
                    "nloc.h" => "__builtin_msa_nloc_h",
                    "nloc.w" => "__builtin_msa_nloc_w",
                    "nlzc.b" => "__builtin_msa_nlzc_b",
                    "nlzc.d" => "__builtin_msa_nlzc_d",
                    "nlzc.h" => "__builtin_msa_nlzc_h",
                    "nlzc.w" => "__builtin_msa_nlzc_w",
                    "nor.v" => "__builtin_msa_nor_v",
                    "nori.b" => "__builtin_msa_nori_b",
                    "or.v" => "__builtin_msa_or_v",
                    "ori.b" => "__builtin_msa_ori_b",
                    "packrl.ph" => "__builtin_mips_packrl_ph",
                    "pckev.b" => "__builtin_msa_pckev_b",
                    "pckev.d" => "__builtin_msa_pckev_d",
                    "pckev.h" => "__builtin_msa_pckev_h",
                    "pckev.w" => "__builtin_msa_pckev_w",
                    "pckod.b" => "__builtin_msa_pckod_b",
                    "pckod.d" => "__builtin_msa_pckod_d",
                    "pckod.h" => "__builtin_msa_pckod_h",
                    "pckod.w" => "__builtin_msa_pckod_w",
                    "pcnt.b" => "__builtin_msa_pcnt_b",
                    "pcnt.d" => "__builtin_msa_pcnt_d",
                    "pcnt.h" => "__builtin_msa_pcnt_h",
                    "pcnt.w" => "__builtin_msa_pcnt_w",
                    "pick.ph" => "__builtin_mips_pick_ph",
                    "pick.qb" => "__builtin_mips_pick_qb",
                    "preceq.w.phl" => "__builtin_mips_preceq_w_phl",
                    "preceq.w.phr" => "__builtin_mips_preceq_w_phr",
                    "precequ.ph.qbl" => "__builtin_mips_precequ_ph_qbl",
                    "precequ.ph.qbla" => "__builtin_mips_precequ_ph_qbla",
                    "precequ.ph.qbr" => "__builtin_mips_precequ_ph_qbr",
                    "precequ.ph.qbra" => "__builtin_mips_precequ_ph_qbra",
                    "preceu.ph.qbl" => "__builtin_mips_preceu_ph_qbl",
                    "preceu.ph.qbla" => "__builtin_mips_preceu_ph_qbla",
                    "preceu.ph.qbr" => "__builtin_mips_preceu_ph_qbr",
                    "preceu.ph.qbra" => "__builtin_mips_preceu_ph_qbra",
                    "precr.qb.ph" => "__builtin_mips_precr_qb_ph",
                    "precr.sra.ph.w" => "__builtin_mips_precr_sra_ph_w",
                    "precr.sra.r.ph.w" => "__builtin_mips_precr_sra_r_ph_w",
                    "precrq.ph.w" => "__builtin_mips_precrq_ph_w",
                    "precrq.qb.ph" => "__builtin_mips_precrq_qb_ph",
                    "precrq.rs.ph.w" => "__builtin_mips_precrq_rs_ph_w",
                    "precrqu.s.qb.ph" => "__builtin_mips_precrqu_s_qb_ph",
                    "prepend" => "__builtin_mips_prepend",
                    "raddu.w.qb" => "__builtin_mips_raddu_w_qb",
                    "rddsp" => "__builtin_mips_rddsp",
                    "repl.ph" => "__builtin_mips_repl_ph",
                    "repl.qb" => "__builtin_mips_repl_qb",
                    "sat.s.b" => "__builtin_msa_sat_s_b",
                    "sat.s.d" => "__builtin_msa_sat_s_d",
                    "sat.s.h" => "__builtin_msa_sat_s_h",
                    "sat.s.w" => "__builtin_msa_sat_s_w",
                    "sat.u.b" => "__builtin_msa_sat_u_b",
                    "sat.u.d" => "__builtin_msa_sat_u_d",
                    "sat.u.h" => "__builtin_msa_sat_u_h",
                    "sat.u.w" => "__builtin_msa_sat_u_w",
                    "shf.b" => "__builtin_msa_shf_b",
                    "shf.h" => "__builtin_msa_shf_h",
                    "shf.w" => "__builtin_msa_shf_w",
                    "shilo" => "__builtin_mips_shilo",
                    "shll.ph" => "__builtin_mips_shll_ph",
                    "shll.qb" => "__builtin_mips_shll_qb",
                    "shll.s.ph" => "__builtin_mips_shll_s_ph",
                    "shll.s.w" => "__builtin_mips_shll_s_w",
                    "shra.ph" => "__builtin_mips_shra_ph",
                    "shra.qb" => "__builtin_mips_shra_qb",
                    "shra.r.ph" => "__builtin_mips_shra_r_ph",
                    "shra.r.qb" => "__builtin_mips_shra_r_qb",
                    "shra.r.w" => "__builtin_mips_shra_r_w",
                    "shrl.ph" => "__builtin_mips_shrl_ph",
                    "shrl.qb" => "__builtin_mips_shrl_qb",
                    "sld.b" => "__builtin_msa_sld_b",
                    "sld.d" => "__builtin_msa_sld_d",
                    "sld.h" => "__builtin_msa_sld_h",
                    "sld.w" => "__builtin_msa_sld_w",
                    "sldi.b" => "__builtin_msa_sldi_b",
                    "sldi.d" => "__builtin_msa_sldi_d",
                    "sldi.h" => "__builtin_msa_sldi_h",
                    "sldi.w" => "__builtin_msa_sldi_w",
                    "sll.b" => "__builtin_msa_sll_b",
                    "sll.d" => "__builtin_msa_sll_d",
                    "sll.h" => "__builtin_msa_sll_h",
                    "sll.w" => "__builtin_msa_sll_w",
                    "slli.b" => "__builtin_msa_slli_b",
                    "slli.d" => "__builtin_msa_slli_d",
                    "slli.h" => "__builtin_msa_slli_h",
                    "slli.w" => "__builtin_msa_slli_w",
                    "splat.b" => "__builtin_msa_splat_b",
                    "splat.d" => "__builtin_msa_splat_d",
                    "splat.h" => "__builtin_msa_splat_h",
                    "splat.w" => "__builtin_msa_splat_w",
                    "splati.b" => "__builtin_msa_splati_b",
                    "splati.d" => "__builtin_msa_splati_d",
                    "splati.h" => "__builtin_msa_splati_h",
                    "splati.w" => "__builtin_msa_splati_w",
                    "sra.b" => "__builtin_msa_sra_b",
                    "sra.d" => "__builtin_msa_sra_d",
                    "sra.h" => "__builtin_msa_sra_h",
                    "sra.w" => "__builtin_msa_sra_w",
                    "srai.b" => "__builtin_msa_srai_b",
                    "srai.d" => "__builtin_msa_srai_d",
                    "srai.h" => "__builtin_msa_srai_h",
                    "srai.w" => "__builtin_msa_srai_w",
                    "srar.b" => "__builtin_msa_srar_b",
                    "srar.d" => "__builtin_msa_srar_d",
                    "srar.h" => "__builtin_msa_srar_h",
                    "srar.w" => "__builtin_msa_srar_w",
                    "srari.b" => "__builtin_msa_srari_b",
                    "srari.d" => "__builtin_msa_srari_d",
                    "srari.h" => "__builtin_msa_srari_h",
                    "srari.w" => "__builtin_msa_srari_w",
                    "srl.b" => "__builtin_msa_srl_b",
                    "srl.d" => "__builtin_msa_srl_d",
                    "srl.h" => "__builtin_msa_srl_h",
                    "srl.w" => "__builtin_msa_srl_w",
                    "srli.b" => "__builtin_msa_srli_b",
                    "srli.d" => "__builtin_msa_srli_d",
                    "srli.h" => "__builtin_msa_srli_h",
                    "srli.w" => "__builtin_msa_srli_w",
                    "srlr.b" => "__builtin_msa_srlr_b",
                    "srlr.d" => "__builtin_msa_srlr_d",
                    "srlr.h" => "__builtin_msa_srlr_h",
                    "srlr.w" => "__builtin_msa_srlr_w",
                    "srlri.b" => "__builtin_msa_srlri_b",
                    "srlri.d" => "__builtin_msa_srlri_d",
                    "srlri.h" => "__builtin_msa_srlri_h",
                    "srlri.w" => "__builtin_msa_srlri_w",
                    "st.b" => "__builtin_msa_st_b",
                    "st.d" => "__builtin_msa_st_d",
                    "st.h" => "__builtin_msa_st_h",
                    "st.w" => "__builtin_msa_st_w",
                    "str.d" => "__builtin_msa_str_d",
                    "str.w" => "__builtin_msa_str_w",
                    "subq.ph" => "__builtin_mips_subq_ph",
                    "subq.s.ph" => "__builtin_mips_subq_s_ph",
                    "subq.s.w" => "__builtin_mips_subq_s_w",
                    "subqh.ph" => "__builtin_mips_subqh_ph",
                    "subqh.r.ph" => "__builtin_mips_subqh_r_ph",
                    "subqh.r.w" => "__builtin_mips_subqh_r_w",
                    "subqh.w" => "__builtin_mips_subqh_w",
                    "subs.s.b" => "__builtin_msa_subs_s_b",
                    "subs.s.d" => "__builtin_msa_subs_s_d",
                    "subs.s.h" => "__builtin_msa_subs_s_h",
                    "subs.s.w" => "__builtin_msa_subs_s_w",
                    "subs.u.b" => "__builtin_msa_subs_u_b",
                    "subs.u.d" => "__builtin_msa_subs_u_d",
                    "subs.u.h" => "__builtin_msa_subs_u_h",
                    "subs.u.w" => "__builtin_msa_subs_u_w",
                    "subsus.u.b" => "__builtin_msa_subsus_u_b",
                    "subsus.u.d" => "__builtin_msa_subsus_u_d",
                    "subsus.u.h" => "__builtin_msa_subsus_u_h",
                    "subsus.u.w" => "__builtin_msa_subsus_u_w",
                    "subsuu.s.b" => "__builtin_msa_subsuu_s_b",
                    "subsuu.s.d" => "__builtin_msa_subsuu_s_d",
                    "subsuu.s.h" => "__builtin_msa_subsuu_s_h",
                    "subsuu.s.w" => "__builtin_msa_subsuu_s_w",
                    "subu.ph" => "__builtin_mips_subu_ph",
                    "subu.qb" => "__builtin_mips_subu_qb",
                    "subu.s.ph" => "__builtin_mips_subu_s_ph",
                    "subu.s.qb" => "__builtin_mips_subu_s_qb",
                    "subuh.qb" => "__builtin_mips_subuh_qb",
                    "subuh.r.qb" => "__builtin_mips_subuh_r_qb",
                    "subv.b" => "__builtin_msa_subv_b",
                    "subv.d" => "__builtin_msa_subv_d",
                    "subv.h" => "__builtin_msa_subv_h",
                    "subv.w" => "__builtin_msa_subv_w",
                    "subvi.b" => "__builtin_msa_subvi_b",
                    "subvi.d" => "__builtin_msa_subvi_d",
                    "subvi.h" => "__builtin_msa_subvi_h",
                    "subvi.w" => "__builtin_msa_subvi_w",
                    "vshf.b" => "__builtin_msa_vshf_b",
                    "vshf.d" => "__builtin_msa_vshf_d",
                    "vshf.h" => "__builtin_msa_vshf_h",
                    "vshf.w" => "__builtin_msa_vshf_w",
                    "wrdsp" => "__builtin_mips_wrdsp",
                    "xor.v" => "__builtin_msa_xor_v",
                    "xori.b" => "__builtin_msa_xori_b",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            mips(name, full_name)
        }
        "nvvm" => {
            fn nvvm(name: &str, full_name: &str) -> &'static str {
                match name {
                    // nvvm
                    "abs.i" => "__nvvm_abs_i",
                    "abs.ll" => "__nvvm_abs_ll",
                    "activemask" => "__nvvm_activemask",
                    "add.rm.d" => "__nvvm_add_rm_d",
                    "add.rm.f" => "__nvvm_add_rm_f",
                    "add.rm.ftz.f" => "__nvvm_add_rm_ftz_f",
                    "add.rn.d" => "__nvvm_add_rn_d",
                    "add.rn.f" => "__nvvm_add_rn_f",
                    "add.rn.ftz.f" => "__nvvm_add_rn_ftz_f",
                    "add.rp.d" => "__nvvm_add_rp_d",
                    "add.rp.f" => "__nvvm_add_rp_f",
                    "add.rp.ftz.f" => "__nvvm_add_rp_ftz_f",
                    "add.rz.d" => "__nvvm_add_rz_d",
                    "add.rz.f" => "__nvvm_add_rz_f",
                    "add.rz.ftz.f" => "__nvvm_add_rz_ftz_f",
                    "bar.sync" => "__nvvm_bar_sync",
                    "bar.warp.sync" => "__nvvm_bar_warp_sync",
                    "barrier0" => "__nvvm_bar0",
                    // [DUPLICATE]: "barrier0" => "__syncthreads",
                    "barrier0.and" => "__nvvm_bar0_and",
                    "barrier0.or" => "__nvvm_bar0_or",
                    "barrier0.popc" => "__nvvm_bar0_popc",
                    "bf16x2.to.ue8m0x2.rp" => "__nvvm_bf16x2_to_ue8m0x2_rp",
                    "bf16x2.to.ue8m0x2.rp.satfinite" => "__nvvm_bf16x2_to_ue8m0x2_rp_satfinite",
                    "bf16x2.to.ue8m0x2.rz" => "__nvvm_bf16x2_to_ue8m0x2_rz",
                    "bf16x2.to.ue8m0x2.rz.satfinite" => "__nvvm_bf16x2_to_ue8m0x2_rz_satfinite",
                    "bf2h.rn" => "__nvvm_bf2h_rn",
                    "bf2h.rn.ftz" => "__nvvm_bf2h_rn_ftz",
                    "bitcast.d2ll" => "__nvvm_bitcast_d2ll",
                    "bitcast.f2i" => "__nvvm_bitcast_f2i",
                    "bitcast.i2f" => "__nvvm_bitcast_i2f",
                    "bitcast.ll2d" => "__nvvm_bitcast_ll2d",
                    "brev32" => "__nvvm_brev32",
                    "brev64" => "__nvvm_brev64",
                    "ceil.d" => "__nvvm_ceil_d",
                    "ceil.f" => "__nvvm_ceil_f",
                    "ceil.ftz.f" => "__nvvm_ceil_ftz_f",
                    "clz.i" => "__nvvm_clz_i",
                    "clz.ll" => "__nvvm_clz_ll",
                    "cos.approx.f" => "__nvvm_cos_approx_f",
                    "cos.approx.ftz.f" => "__nvvm_cos_approx_ftz_f",
                    "cp.async.commit.group" => "__nvvm_cp_async_commit_group",
                    "cp.async.mbarrier.arrive" => "__nvvm_cp_async_mbarrier_arrive",
                    "cp.async.mbarrier.arrive.noinc" => "__nvvm_cp_async_mbarrier_arrive_noinc",
                    "cp.async.mbarrier.arrive.noinc.shared" => {
                        "__nvvm_cp_async_mbarrier_arrive_noinc_shared"
                    }
                    "cp.async.mbarrier.arrive.shared" => "__nvvm_cp_async_mbarrier_arrive_shared",
                    "cp.async.wait.all" => "__nvvm_cp_async_wait_all",
                    "cp.async.wait.group" => "__nvvm_cp_async_wait_group",
                    "d2f.rm" => "__nvvm_d2f_rm",
                    "d2f.rm.ftz" => "__nvvm_d2f_rm_ftz",
                    "d2f.rn" => "__nvvm_d2f_rn",
                    "d2f.rn.ftz" => "__nvvm_d2f_rn_ftz",
                    "d2f.rp" => "__nvvm_d2f_rp",
                    "d2f.rp.ftz" => "__nvvm_d2f_rp_ftz",
                    "d2f.rz" => "__nvvm_d2f_rz",
                    "d2f.rz.ftz" => "__nvvm_d2f_rz_ftz",
                    "d2i.hi" => "__nvvm_d2i_hi",
                    "d2i.lo" => "__nvvm_d2i_lo",
                    "d2i.rm" => "__nvvm_d2i_rm",
                    "d2i.rn" => "__nvvm_d2i_rn",
                    "d2i.rp" => "__nvvm_d2i_rp",
                    "d2i.rz" => "__nvvm_d2i_rz",
                    "d2ll.rm" => "__nvvm_d2ll_rm",
                    "d2ll.rn" => "__nvvm_d2ll_rn",
                    "d2ll.rp" => "__nvvm_d2ll_rp",
                    "d2ll.rz" => "__nvvm_d2ll_rz",
                    "d2ui.rm" => "__nvvm_d2ui_rm",
                    "d2ui.rn" => "__nvvm_d2ui_rn",
                    "d2ui.rp" => "__nvvm_d2ui_rp",
                    "d2ui.rz" => "__nvvm_d2ui_rz",
                    "d2ull.rm" => "__nvvm_d2ull_rm",
                    "d2ull.rn" => "__nvvm_d2ull_rn",
                    "d2ull.rp" => "__nvvm_d2ull_rp",
                    "d2ull.rz" => "__nvvm_d2ull_rz",
                    "div.approx.f" => "__nvvm_div_approx_f",
                    "div.approx.ftz.f" => "__nvvm_div_approx_ftz_f",
                    "div.full" => "__nvvm_div_full",
                    "div.full.ftz" => "__nvvm_div_full_ftz",
                    "div.rm.d" => "__nvvm_div_rm_d",
                    "div.rm.f" => "__nvvm_div_rm_f",
                    "div.rm.ftz.f" => "__nvvm_div_rm_ftz_f",
                    "div.rn.d" => "__nvvm_div_rn_d",
                    "div.rn.f" => "__nvvm_div_rn_f",
                    "div.rn.ftz.f" => "__nvvm_div_rn_ftz_f",
                    "div.rp.d" => "__nvvm_div_rp_d",
                    "div.rp.f" => "__nvvm_div_rp_f",
                    "div.rp.ftz.f" => "__nvvm_div_rp_ftz_f",
                    "div.rz.d" => "__nvvm_div_rz_d",
                    "div.rz.f" => "__nvvm_div_rz_f",
                    "div.rz.ftz.f" => "__nvvm_div_rz_ftz_f",
                    "e2m1x2.to.f16x2.rn" => "__nvvm_e2m1x2_to_f16x2_rn",
                    "e2m1x2.to.f16x2.rn.relu" => "__nvvm_e2m1x2_to_f16x2_rn_relu",
                    "e2m3x2.to.f16x2.rn" => "__nvvm_e2m3x2_to_f16x2_rn",
                    "e2m3x2.to.f16x2.rn.relu" => "__nvvm_e2m3x2_to_f16x2_rn_relu",
                    "e3m2x2.to.f16x2.rn" => "__nvvm_e3m2x2_to_f16x2_rn",
                    "e3m2x2.to.f16x2.rn.relu" => "__nvvm_e3m2x2_to_f16x2_rn_relu",
                    "e4m3x2.to.f16x2.rn" => "__nvvm_e4m3x2_to_f16x2_rn",
                    "e4m3x2.to.f16x2.rn.relu" => "__nvvm_e4m3x2_to_f16x2_rn_relu",
                    "e5m2x2.to.f16x2.rn" => "__nvvm_e5m2x2_to_f16x2_rn",
                    "e5m2x2.to.f16x2.rn.relu" => "__nvvm_e5m2x2_to_f16x2_rn_relu",
                    "ex2.approx.d" => "__nvvm_ex2_approx_d",
                    "ex2.approx.f" => "__nvvm_ex2_approx_f",
                    "ex2.approx.ftz.f" => "__nvvm_ex2_approx_ftz_f",
                    "exit" => "__nvvm_exit",
                    "f16x2.to.e4m3x2.rn" => "__nvvm_f16x2_to_e4m3x2_rn",
                    "f16x2.to.e4m3x2.rn.relu" => "__nvvm_f16x2_to_e4m3x2_rn_relu",
                    "f16x2.to.e5m2x2.rn" => "__nvvm_f16x2_to_e5m2x2_rn",
                    "f16x2.to.e5m2x2.rn.relu" => "__nvvm_f16x2_to_e5m2x2_rn_relu",
                    "f2bf16.rn" => "__nvvm_f2bf16_rn",
                    "f2bf16.rn.relu" => "__nvvm_f2bf16_rn_relu",
                    "f2bf16.rn.relu.satfinite" => "__nvvm_f2bf16_rn_relu_satfinite",
                    "f2bf16.rn.satfinite" => "__nvvm_f2bf16_rn_satfinite",
                    "f2bf16.rz" => "__nvvm_f2bf16_rz",
                    "f2bf16.rz.relu" => "__nvvm_f2bf16_rz_relu",
                    "f2bf16.rz.relu.satfinite" => "__nvvm_f2bf16_rz_relu_satfinite",
                    "f2bf16.rz.satfinite" => "__nvvm_f2bf16_rz_satfinite",
                    "f2f16.rn" => "__nvvm_f2f16_rn",
                    "f2f16.rn.relu" => "__nvvm_f2f16_rn_relu",
                    "f2f16.rn.relu.satfinite" => "__nvvm_f2f16_rn_relu_satfinite",
                    "f2f16.rn.satfinite" => "__nvvm_f2f16_rn_satfinite",
                    "f2f16.rz" => "__nvvm_f2f16_rz",
                    "f2f16.rz.relu" => "__nvvm_f2f16_rz_relu",
                    "f2f16.rz.relu.satfinite" => "__nvvm_f2f16_rz_relu_satfinite",
                    "f2f16.rz.satfinite" => "__nvvm_f2f16_rz_satfinite",
                    "f2h.rn" => "__nvvm_f2h_rn",
                    "f2h.rn.ftz" => "__nvvm_f2h_rn_ftz",
                    "f2i.rm" => "__nvvm_f2i_rm",
                    "f2i.rm.ftz" => "__nvvm_f2i_rm_ftz",
                    "f2i.rn" => "__nvvm_f2i_rn",
                    "f2i.rn.ftz" => "__nvvm_f2i_rn_ftz",
                    "f2i.rp" => "__nvvm_f2i_rp",
                    "f2i.rp.ftz" => "__nvvm_f2i_rp_ftz",
                    "f2i.rz" => "__nvvm_f2i_rz",
                    "f2i.rz.ftz" => "__nvvm_f2i_rz_ftz",
                    "f2ll.rm" => "__nvvm_f2ll_rm",
                    "f2ll.rm.ftz" => "__nvvm_f2ll_rm_ftz",
                    "f2ll.rn" => "__nvvm_f2ll_rn",
                    "f2ll.rn.ftz" => "__nvvm_f2ll_rn_ftz",
                    "f2ll.rp" => "__nvvm_f2ll_rp",
                    "f2ll.rp.ftz" => "__nvvm_f2ll_rp_ftz",
                    "f2ll.rz" => "__nvvm_f2ll_rz",
                    "f2ll.rz.ftz" => "__nvvm_f2ll_rz_ftz",
                    "f2tf32.rn" => "__nvvm_f2tf32_rn",
                    "f2tf32.rn.relu" => "__nvvm_f2tf32_rn_relu",
                    "f2tf32.rn.relu.satfinite" => "__nvvm_f2tf32_rn_relu_satfinite",
                    "f2tf32.rn.satfinite" => "__nvvm_f2tf32_rn_satfinite",
                    "f2tf32.rna" => "__nvvm_f2tf32_rna",
                    "f2tf32.rna.satfinite" => "__nvvm_f2tf32_rna_satfinite",
                    "f2tf32.rz" => "__nvvm_f2tf32_rz",
                    "f2tf32.rz.relu" => "__nvvm_f2tf32_rz_relu",
                    "f2tf32.rz.relu.satfinite" => "__nvvm_f2tf32_rz_relu_satfinite",
                    "f2tf32.rz.satfinite" => "__nvvm_f2tf32_rz_satfinite",
                    "f2ui.rm" => "__nvvm_f2ui_rm",
                    "f2ui.rm.ftz" => "__nvvm_f2ui_rm_ftz",
                    "f2ui.rn" => "__nvvm_f2ui_rn",
                    "f2ui.rn.ftz" => "__nvvm_f2ui_rn_ftz",
                    "f2ui.rp" => "__nvvm_f2ui_rp",
                    "f2ui.rp.ftz" => "__nvvm_f2ui_rp_ftz",
                    "f2ui.rz" => "__nvvm_f2ui_rz",
                    "f2ui.rz.ftz" => "__nvvm_f2ui_rz_ftz",
                    "f2ull.rm" => "__nvvm_f2ull_rm",
                    "f2ull.rm.ftz" => "__nvvm_f2ull_rm_ftz",
                    "f2ull.rn" => "__nvvm_f2ull_rn",
                    "f2ull.rn.ftz" => "__nvvm_f2ull_rn_ftz",
                    "f2ull.rp" => "__nvvm_f2ull_rp",
                    "f2ull.rp.ftz" => "__nvvm_f2ull_rp_ftz",
                    "f2ull.rz" => "__nvvm_f2ull_rz",
                    "f2ull.rz.ftz" => "__nvvm_f2ull_rz_ftz",
                    "f32x4.to.e2m1x4.rs.relu.satfinite" => {
                        "__nvvm_f32x4_to_e2m1x4_rs_relu_satfinite"
                    }
                    "f32x4.to.e2m1x4.rs.satfinite" => "__nvvm_f32x4_to_e2m1x4_rs_satfinite",
                    "f32x4.to.e2m3x4.rs.relu.satfinite" => {
                        "__nvvm_f32x4_to_e2m3x4_rs_relu_satfinite"
                    }
                    "f32x4.to.e2m3x4.rs.satfinite" => "__nvvm_f32x4_to_e2m3x4_rs_satfinite",
                    "f32x4.to.e3m2x4.rs.relu.satfinite" => {
                        "__nvvm_f32x4_to_e3m2x4_rs_relu_satfinite"
                    }
                    "f32x4.to.e3m2x4.rs.satfinite" => "__nvvm_f32x4_to_e3m2x4_rs_satfinite",
                    "f32x4.to.e4m3x4.rs.relu.satfinite" => {
                        "__nvvm_f32x4_to_e4m3x4_rs_relu_satfinite"
                    }
                    "f32x4.to.e4m3x4.rs.satfinite" => "__nvvm_f32x4_to_e4m3x4_rs_satfinite",
                    "f32x4.to.e5m2x4.rs.relu.satfinite" => {
                        "__nvvm_f32x4_to_e5m2x4_rs_relu_satfinite"
                    }
                    "f32x4.to.e5m2x4.rs.satfinite" => "__nvvm_f32x4_to_e5m2x4_rs_satfinite",
                    "fabs.d" => "__nvvm_fabs_d",
                    "fabs.f" => "__nvvm_fabs_f",
                    "fabs.ftz.f" => "__nvvm_fabs_ftz_f",
                    "ff.to.e2m1x2.rn.relu.satfinite" => "__nvvm_ff_to_e2m1x2_rn_relu_satfinite",
                    "ff.to.e2m1x2.rn.satfinite" => "__nvvm_ff_to_e2m1x2_rn_satfinite",
                    "ff.to.e2m3x2.rn.relu.satfinite" => "__nvvm_ff_to_e2m3x2_rn_relu_satfinite",
                    "ff.to.e2m3x2.rn.satfinite" => "__nvvm_ff_to_e2m3x2_rn_satfinite",
                    "ff.to.e3m2x2.rn.relu.satfinite" => "__nvvm_ff_to_e3m2x2_rn_relu_satfinite",
                    "ff.to.e3m2x2.rn.satfinite" => "__nvvm_ff_to_e3m2x2_rn_satfinite",
                    "ff.to.e4m3x2.rn" => "__nvvm_ff_to_e4m3x2_rn",
                    "ff.to.e4m3x2.rn.relu" => "__nvvm_ff_to_e4m3x2_rn_relu",
                    "ff.to.e5m2x2.rn" => "__nvvm_ff_to_e5m2x2_rn",
                    "ff.to.e5m2x2.rn.relu" => "__nvvm_ff_to_e5m2x2_rn_relu",
                    "ff.to.ue8m0x2.rp" => "__nvvm_ff_to_ue8m0x2_rp",
                    "ff.to.ue8m0x2.rp.satfinite" => "__nvvm_ff_to_ue8m0x2_rp_satfinite",
                    "ff.to.ue8m0x2.rz" => "__nvvm_ff_to_ue8m0x2_rz",
                    "ff.to.ue8m0x2.rz.satfinite" => "__nvvm_ff_to_ue8m0x2_rz_satfinite",
                    "ff2bf16x2.rn" => "__nvvm_ff2bf16x2_rn",
                    "ff2bf16x2.rn.relu" => "__nvvm_ff2bf16x2_rn_relu",
                    "ff2bf16x2.rn.relu.satfinite" => "__nvvm_ff2bf16x2_rn_relu_satfinite",
                    "ff2bf16x2.rn.satfinite" => "__nvvm_ff2bf16x2_rn_satfinite",
                    "ff2bf16x2.rs" => "__nvvm_ff2bf16x2_rs",
                    "ff2bf16x2.rs.relu" => "__nvvm_ff2bf16x2_rs_relu",
                    "ff2bf16x2.rs.relu.satfinite" => "__nvvm_ff2bf16x2_rs_relu_satfinite",
                    "ff2bf16x2.rs.satfinite" => "__nvvm_ff2bf16x2_rs_satfinite",
                    "ff2bf16x2.rz" => "__nvvm_ff2bf16x2_rz",
                    "ff2bf16x2.rz.relu" => "__nvvm_ff2bf16x2_rz_relu",
                    "ff2bf16x2.rz.relu.satfinite" => "__nvvm_ff2bf16x2_rz_relu_satfinite",
                    "ff2bf16x2.rz.satfinite" => "__nvvm_ff2bf16x2_rz_satfinite",
                    "ff2f16x2.rn" => "__nvvm_ff2f16x2_rn",
                    "ff2f16x2.rn.relu" => "__nvvm_ff2f16x2_rn_relu",
                    "ff2f16x2.rn.relu.satfinite" => "__nvvm_ff2f16x2_rn_relu_satfinite",
                    "ff2f16x2.rn.satfinite" => "__nvvm_ff2f16x2_rn_satfinite",
                    "ff2f16x2.rs" => "__nvvm_ff2f16x2_rs",
                    "ff2f16x2.rs.relu" => "__nvvm_ff2f16x2_rs_relu",
                    "ff2f16x2.rs.relu.satfinite" => "__nvvm_ff2f16x2_rs_relu_satfinite",
                    "ff2f16x2.rs.satfinite" => "__nvvm_ff2f16x2_rs_satfinite",
                    "ff2f16x2.rz" => "__nvvm_ff2f16x2_rz",
                    "ff2f16x2.rz.relu" => "__nvvm_ff2f16x2_rz_relu",
                    "ff2f16x2.rz.relu.satfinite" => "__nvvm_ff2f16x2_rz_relu_satfinite",
                    "ff2f16x2.rz.satfinite" => "__nvvm_ff2f16x2_rz_satfinite",
                    "floor.d" => "__nvvm_floor_d",
                    "floor.f" => "__nvvm_floor_f",
                    "floor.ftz.f" => "__nvvm_floor_ftz_f",
                    "fma.rm.d" => "__nvvm_fma_rm_d",
                    "fma.rm.f" => "__nvvm_fma_rm_f",
                    "fma.rm.ftz.f" => "__nvvm_fma_rm_ftz_f",
                    "fma.rn.bf16" => "__nvvm_fma_rn_bf16",
                    "fma.rn.bf16x2" => "__nvvm_fma_rn_bf16x2",
                    "fma.rn.d" => "__nvvm_fma_rn_d",
                    "fma.rn.f" => "__nvvm_fma_rn_f",
                    "fma.rn.ftz.bf16" => "__nvvm_fma_rn_ftz_bf16",
                    "fma.rn.ftz.bf16x2" => "__nvvm_fma_rn_ftz_bf16x2",
                    "fma.rn.ftz.f" => "__nvvm_fma_rn_ftz_f",
                    "fma.rn.ftz.relu.bf16" => "__nvvm_fma_rn_ftz_relu_bf16",
                    "fma.rn.ftz.relu.bf16x2" => "__nvvm_fma_rn_ftz_relu_bf16x2",
                    "fma.rn.ftz.sat.bf16" => "__nvvm_fma_rn_ftz_sat_bf16",
                    "fma.rn.ftz.sat.bf16x2" => "__nvvm_fma_rn_ftz_sat_bf16x2",
                    "fma.rn.relu.bf16" => "__nvvm_fma_rn_relu_bf16",
                    "fma.rn.relu.bf16x2" => "__nvvm_fma_rn_relu_bf16x2",
                    "fma.rn.sat.bf16" => "__nvvm_fma_rn_sat_bf16",
                    "fma.rn.sat.bf16x2" => "__nvvm_fma_rn_sat_bf16x2",
                    "fma.rp.d" => "__nvvm_fma_rp_d",
                    "fma.rp.f" => "__nvvm_fma_rp_f",
                    "fma.rp.ftz.f" => "__nvvm_fma_rp_ftz_f",
                    "fma.rz.d" => "__nvvm_fma_rz_d",
                    "fma.rz.f" => "__nvvm_fma_rz_f",
                    "fma.rz.ftz.f" => "__nvvm_fma_rz_ftz_f",
                    "fmax.bf16" => "__nvvm_fmax_bf16",
                    "fmax.bf16x2" => "__nvvm_fmax_bf16x2",
                    "fmax.d" => "__nvvm_fmax_d",
                    "fmax.f" => "__nvvm_fmax_f",
                    "fmax.ftz.bf16" => "__nvvm_fmax_ftz_bf16",
                    "fmax.ftz.bf16x2" => "__nvvm_fmax_ftz_bf16x2",
                    "fmax.ftz.f" => "__nvvm_fmax_ftz_f",
                    "fmax.ftz.nan.bf16" => "__nvvm_fmax_ftz_nan_bf16",
                    "fmax.ftz.nan.bf16x2" => "__nvvm_fmax_ftz_nan_bf16x2",
                    "fmax.ftz.nan.f" => "__nvvm_fmax_ftz_nan_f",
                    "fmax.ftz.nan.xorsign.abs.bf16" => "__nvvm_fmax_ftz_nan_xorsign_abs_bf16",
                    "fmax.ftz.nan.xorsign.abs.bf16x2" => "__nvvm_fmax_ftz_nan_xorsign_abs_bf16x2",
                    "fmax.ftz.nan.xorsign.abs.f" => "__nvvm_fmax_ftz_nan_xorsign_abs_f",
                    "fmax.ftz.xorsign.abs.bf16" => "__nvvm_fmax_ftz_xorsign_abs_bf16",
                    "fmax.ftz.xorsign.abs.bf16x2" => "__nvvm_fmax_ftz_xorsign_abs_bf16x2",
                    "fmax.ftz.xorsign.abs.f" => "__nvvm_fmax_ftz_xorsign_abs_f",
                    "fmax.nan.bf16" => "__nvvm_fmax_nan_bf16",
                    "fmax.nan.bf16x2" => "__nvvm_fmax_nan_bf16x2",
                    "fmax.nan.f" => "__nvvm_fmax_nan_f",
                    "fmax.nan.xorsign.abs.bf16" => "__nvvm_fmax_nan_xorsign_abs_bf16",
                    "fmax.nan.xorsign.abs.bf16x2" => "__nvvm_fmax_nan_xorsign_abs_bf16x2",
                    "fmax.nan.xorsign.abs.f" => "__nvvm_fmax_nan_xorsign_abs_f",
                    "fmax.xorsign.abs.bf16" => "__nvvm_fmax_xorsign_abs_bf16",
                    "fmax.xorsign.abs.bf16x2" => "__nvvm_fmax_xorsign_abs_bf16x2",
                    "fmax.xorsign.abs.f" => "__nvvm_fmax_xorsign_abs_f",
                    "fmin.bf16" => "__nvvm_fmin_bf16",
                    "fmin.bf16x2" => "__nvvm_fmin_bf16x2",
                    "fmin.d" => "__nvvm_fmin_d",
                    "fmin.f" => "__nvvm_fmin_f",
                    "fmin.ftz.bf16" => "__nvvm_fmin_ftz_bf16",
                    "fmin.ftz.bf16x2" => "__nvvm_fmin_ftz_bf16x2",
                    "fmin.ftz.f" => "__nvvm_fmin_ftz_f",
                    "fmin.ftz.nan.bf16" => "__nvvm_fmin_ftz_nan_bf16",
                    "fmin.ftz.nan.bf16x2" => "__nvvm_fmin_ftz_nan_bf16x2",
                    "fmin.ftz.nan.f" => "__nvvm_fmin_ftz_nan_f",
                    "fmin.ftz.nan.xorsign.abs.bf16" => "__nvvm_fmin_ftz_nan_xorsign_abs_bf16",
                    "fmin.ftz.nan.xorsign.abs.bf16x2" => "__nvvm_fmin_ftz_nan_xorsign_abs_bf16x2",
                    "fmin.ftz.nan.xorsign.abs.f" => "__nvvm_fmin_ftz_nan_xorsign_abs_f",
                    "fmin.ftz.xorsign.abs.bf16" => "__nvvm_fmin_ftz_xorsign_abs_bf16",
                    "fmin.ftz.xorsign.abs.bf16x2" => "__nvvm_fmin_ftz_xorsign_abs_bf16x2",
                    "fmin.ftz.xorsign.abs.f" => "__nvvm_fmin_ftz_xorsign_abs_f",
                    "fmin.nan.bf16" => "__nvvm_fmin_nan_bf16",
                    "fmin.nan.bf16x2" => "__nvvm_fmin_nan_bf16x2",
                    "fmin.nan.f" => "__nvvm_fmin_nan_f",
                    "fmin.nan.xorsign.abs.bf16" => "__nvvm_fmin_nan_xorsign_abs_bf16",
                    "fmin.nan.xorsign.abs.bf16x2" => "__nvvm_fmin_nan_xorsign_abs_bf16x2",
                    "fmin.nan.xorsign.abs.f" => "__nvvm_fmin_nan_xorsign_abs_f",
                    "fmin.xorsign.abs.bf16" => "__nvvm_fmin_xorsign_abs_bf16",
                    "fmin.xorsign.abs.bf16x2" => "__nvvm_fmin_xorsign_abs_bf16x2",
                    "fmin.xorsign.abs.f" => "__nvvm_fmin_xorsign_abs_f",
                    "fns" => "__nvvm_fns",
                    "h2f" => "__nvvm_h2f",
                    "i2d.rm" => "__nvvm_i2d_rm",
                    "i2d.rn" => "__nvvm_i2d_rn",
                    "i2d.rp" => "__nvvm_i2d_rp",
                    "i2d.rz" => "__nvvm_i2d_rz",
                    "i2f.rm" => "__nvvm_i2f_rm",
                    "i2f.rn" => "__nvvm_i2f_rn",
                    "i2f.rp" => "__nvvm_i2f_rp",
                    "i2f.rz" => "__nvvm_i2f_rz",
                    "isspacep.const" => "__nvvm_isspacep_const",
                    "isspacep.global" => "__nvvm_isspacep_global",
                    "isspacep.local" => "__nvvm_isspacep_local",
                    "isspacep.shared" => "__nvvm_isspacep_shared",
                    "isspacep.shared.cluster" => "__nvvm_isspacep_shared_cluster",
                    "istypep.sampler" => "__nvvm_istypep_sampler",
                    "istypep.surface" => "__nvvm_istypep_surface",
                    "istypep.texture" => "__nvvm_istypep_texture",
                    "lg2.approx.d" => "__nvvm_lg2_approx_d",
                    "lg2.approx.f" => "__nvvm_lg2_approx_f",
                    "lg2.approx.ftz.f" => "__nvvm_lg2_approx_ftz_f",
                    "ll2d.rm" => "__nvvm_ll2d_rm",
                    "ll2d.rn" => "__nvvm_ll2d_rn",
                    "ll2d.rp" => "__nvvm_ll2d_rp",
                    "ll2d.rz" => "__nvvm_ll2d_rz",
                    "ll2f.rm" => "__nvvm_ll2f_rm",
                    "ll2f.rn" => "__nvvm_ll2f_rn",
                    "ll2f.rp" => "__nvvm_ll2f_rp",
                    "ll2f.rz" => "__nvvm_ll2f_rz",
                    "lohi.i2d" => "__nvvm_lohi_i2d",
                    "match.any.sync.i32" => "__nvvm_match_any_sync_i32",
                    "match.any.sync.i64" => "__nvvm_match_any_sync_i64",
                    "max.i" => "__nvvm_max_i",
                    "max.ll" => "__nvvm_max_ll",
                    "max.ui" => "__nvvm_max_ui",
                    "max.ull" => "__nvvm_max_ull",
                    "mbarrier.arrive" => "__nvvm_mbarrier_arrive",
                    "mbarrier.arrive.drop" => "__nvvm_mbarrier_arrive_drop",
                    "mbarrier.arrive.drop.noComplete" => "__nvvm_mbarrier_arrive_drop_noComplete",
                    "mbarrier.arrive.drop.noComplete.shared" => {
                        "__nvvm_mbarrier_arrive_drop_noComplete_shared"
                    }
                    "mbarrier.arrive.drop.shared" => "__nvvm_mbarrier_arrive_drop_shared",
                    "mbarrier.arrive.noComplete" => "__nvvm_mbarrier_arrive_noComplete",
                    "mbarrier.arrive.noComplete.shared" => {
                        "__nvvm_mbarrier_arrive_noComplete_shared"
                    }
                    "mbarrier.arrive.shared" => "__nvvm_mbarrier_arrive_shared",
                    "mbarrier.init" => "__nvvm_mbarrier_init",
                    "mbarrier.init.shared" => "__nvvm_mbarrier_init_shared",
                    "mbarrier.inval" => "__nvvm_mbarrier_inval",
                    "mbarrier.inval.shared" => "__nvvm_mbarrier_inval_shared",
                    "mbarrier.pending.count" => "__nvvm_mbarrier_pending_count",
                    "mbarrier.test.wait" => "__nvvm_mbarrier_test_wait",
                    "mbarrier.test.wait.shared" => "__nvvm_mbarrier_test_wait_shared",
                    "membar.cta" => "__nvvm_membar_cta",
                    "membar.gl" => "__nvvm_membar_gl",
                    "membar.sys" => "__nvvm_membar_sys",
                    "min.i" => "__nvvm_min_i",
                    "min.ll" => "__nvvm_min_ll",
                    "min.ui" => "__nvvm_min_ui",
                    "min.ull" => "__nvvm_min_ull",
                    "mul.rm.d" => "__nvvm_mul_rm_d",
                    "mul.rm.f" => "__nvvm_mul_rm_f",
                    "mul.rm.ftz.f" => "__nvvm_mul_rm_ftz_f",
                    "mul.rn.d" => "__nvvm_mul_rn_d",
                    "mul.rn.f" => "__nvvm_mul_rn_f",
                    "mul.rn.ftz.f" => "__nvvm_mul_rn_ftz_f",
                    "mul.rp.d" => "__nvvm_mul_rp_d",
                    "mul.rp.f" => "__nvvm_mul_rp_f",
                    "mul.rp.ftz.f" => "__nvvm_mul_rp_ftz_f",
                    "mul.rz.d" => "__nvvm_mul_rz_d",
                    "mul.rz.f" => "__nvvm_mul_rz_f",
                    "mul.rz.ftz.f" => "__nvvm_mul_rz_ftz_f",
                    "mul24.i" => "__nvvm_mul24_i",
                    "mul24.ui" => "__nvvm_mul24_ui",
                    "mulhi.i" => "__nvvm_mulhi_i",
                    "mulhi.ll" => "__nvvm_mulhi_ll",
                    "mulhi.s" => "__nvvm_mulhi_s",
                    "mulhi.ui" => "__nvvm_mulhi_ui",
                    "mulhi.ull" => "__nvvm_mulhi_ull",
                    "mulhi.us" => "__nvvm_mulhi_us",
                    "nanosleep" => "__nvvm_nanosleep",
                    "neg.bf16" => "__nvvm_neg_bf16",
                    "neg.bf16x2" => "__nvvm_neg_bf16x2",
                    "pm.event.mask" => "__nvvm_pm_event_mask",
                    "popc.i" => "__nvvm_popc_i",
                    "popc.ll" => "__nvvm_popc_ll",
                    "prmt" => "__nvvm_prmt",
                    "rcp.approx.ftz.d" => "__nvvm_rcp_approx_ftz_d",
                    "rcp.approx.ftz.f" => "__nvvm_rcp_approx_ftz_f",
                    "rcp.rm.d" => "__nvvm_rcp_rm_d",
                    "rcp.rm.f" => "__nvvm_rcp_rm_f",
                    "rcp.rm.ftz.f" => "__nvvm_rcp_rm_ftz_f",
                    "rcp.rn.d" => "__nvvm_rcp_rn_d",
                    "rcp.rn.f" => "__nvvm_rcp_rn_f",
                    "rcp.rn.ftz.f" => "__nvvm_rcp_rn_ftz_f",
                    "rcp.rp.d" => "__nvvm_rcp_rp_d",
                    "rcp.rp.f" => "__nvvm_rcp_rp_f",
                    "rcp.rp.ftz.f" => "__nvvm_rcp_rp_ftz_f",
                    "rcp.rz.d" => "__nvvm_rcp_rz_d",
                    "rcp.rz.f" => "__nvvm_rcp_rz_f",
                    "rcp.rz.ftz.f" => "__nvvm_rcp_rz_ftz_f",
                    "read.ptx.sreg.clock" => "__nvvm_read_ptx_sreg_clock",
                    // [DUPLICATE]: "read.ptx.sreg.clock" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.clock64" => "__nvvm_read_ptx_sreg_clock64",
                    // [DUPLICATE]: "read.ptx.sreg.clock64" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.ctaid.w" => "__nvvm_read_ptx_sreg_ctaid_w",
                    "read.ptx.sreg.ctaid.x" => "__nvvm_read_ptx_sreg_ctaid_x",
                    "read.ptx.sreg.ctaid.y" => "__nvvm_read_ptx_sreg_ctaid_y",
                    "read.ptx.sreg.ctaid.z" => "__nvvm_read_ptx_sreg_ctaid_z",
                    "read.ptx.sreg.envreg0" => "__nvvm_read_ptx_sreg_envreg0",
                    "read.ptx.sreg.envreg1" => "__nvvm_read_ptx_sreg_envreg1",
                    "read.ptx.sreg.envreg10" => "__nvvm_read_ptx_sreg_envreg10",
                    "read.ptx.sreg.envreg11" => "__nvvm_read_ptx_sreg_envreg11",
                    "read.ptx.sreg.envreg12" => "__nvvm_read_ptx_sreg_envreg12",
                    "read.ptx.sreg.envreg13" => "__nvvm_read_ptx_sreg_envreg13",
                    "read.ptx.sreg.envreg14" => "__nvvm_read_ptx_sreg_envreg14",
                    "read.ptx.sreg.envreg15" => "__nvvm_read_ptx_sreg_envreg15",
                    "read.ptx.sreg.envreg16" => "__nvvm_read_ptx_sreg_envreg16",
                    "read.ptx.sreg.envreg17" => "__nvvm_read_ptx_sreg_envreg17",
                    "read.ptx.sreg.envreg18" => "__nvvm_read_ptx_sreg_envreg18",
                    "read.ptx.sreg.envreg19" => "__nvvm_read_ptx_sreg_envreg19",
                    "read.ptx.sreg.envreg2" => "__nvvm_read_ptx_sreg_envreg2",
                    "read.ptx.sreg.envreg20" => "__nvvm_read_ptx_sreg_envreg20",
                    "read.ptx.sreg.envreg21" => "__nvvm_read_ptx_sreg_envreg21",
                    "read.ptx.sreg.envreg22" => "__nvvm_read_ptx_sreg_envreg22",
                    "read.ptx.sreg.envreg23" => "__nvvm_read_ptx_sreg_envreg23",
                    "read.ptx.sreg.envreg24" => "__nvvm_read_ptx_sreg_envreg24",
                    "read.ptx.sreg.envreg25" => "__nvvm_read_ptx_sreg_envreg25",
                    "read.ptx.sreg.envreg26" => "__nvvm_read_ptx_sreg_envreg26",
                    "read.ptx.sreg.envreg27" => "__nvvm_read_ptx_sreg_envreg27",
                    "read.ptx.sreg.envreg28" => "__nvvm_read_ptx_sreg_envreg28",
                    "read.ptx.sreg.envreg29" => "__nvvm_read_ptx_sreg_envreg29",
                    "read.ptx.sreg.envreg3" => "__nvvm_read_ptx_sreg_envreg3",
                    "read.ptx.sreg.envreg30" => "__nvvm_read_ptx_sreg_envreg30",
                    "read.ptx.sreg.envreg31" => "__nvvm_read_ptx_sreg_envreg31",
                    "read.ptx.sreg.envreg4" => "__nvvm_read_ptx_sreg_envreg4",
                    "read.ptx.sreg.envreg5" => "__nvvm_read_ptx_sreg_envreg5",
                    "read.ptx.sreg.envreg6" => "__nvvm_read_ptx_sreg_envreg6",
                    "read.ptx.sreg.envreg7" => "__nvvm_read_ptx_sreg_envreg7",
                    "read.ptx.sreg.envreg8" => "__nvvm_read_ptx_sreg_envreg8",
                    "read.ptx.sreg.envreg9" => "__nvvm_read_ptx_sreg_envreg9",
                    "read.ptx.sreg.globaltimer" => "__nvvm_read_ptx_sreg_globaltimer",
                    "read.ptx.sreg.globaltimer.lo" => "__nvvm_read_ptx_sreg_globaltimer_lo",
                    "read.ptx.sreg.gridid" => "__nvvm_read_ptx_sreg_gridid",
                    // [DUPLICATE]: "read.ptx.sreg.gridid" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.laneid" => "__nvvm_read_ptx_sreg_laneid",
                    // [DUPLICATE]: "read.ptx.sreg.laneid" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.lanemask.eq" => "__nvvm_read_ptx_sreg_lanemask_eq",
                    // [DUPLICATE]: "read.ptx.sreg.lanemask.eq" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.lanemask.ge" => "__nvvm_read_ptx_sreg_lanemask_ge",
                    // [DUPLICATE]: "read.ptx.sreg.lanemask.ge" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.lanemask.gt" => "__nvvm_read_ptx_sreg_lanemask_gt",
                    // [DUPLICATE]: "read.ptx.sreg.lanemask.gt" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.lanemask.le" => "__nvvm_read_ptx_sreg_lanemask_le",
                    // [DUPLICATE]: "read.ptx.sreg.lanemask.le" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.lanemask.lt" => "__nvvm_read_ptx_sreg_lanemask_lt",
                    // [DUPLICATE]: "read.ptx.sreg.lanemask.lt" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.nctaid.w" => "__nvvm_read_ptx_sreg_nctaid_w",
                    "read.ptx.sreg.nctaid.x" => "__nvvm_read_ptx_sreg_nctaid_x",
                    "read.ptx.sreg.nctaid.y" => "__nvvm_read_ptx_sreg_nctaid_y",
                    "read.ptx.sreg.nctaid.z" => "__nvvm_read_ptx_sreg_nctaid_z",
                    "read.ptx.sreg.nsmid" => "__nvvm_read_ptx_sreg_nsmid",
                    // [DUPLICATE]: "read.ptx.sreg.nsmid" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.ntid.w" => "__nvvm_read_ptx_sreg_ntid_w",
                    "read.ptx.sreg.ntid.x" => "__nvvm_read_ptx_sreg_ntid_x",
                    "read.ptx.sreg.ntid.y" => "__nvvm_read_ptx_sreg_ntid_y",
                    "read.ptx.sreg.ntid.z" => "__nvvm_read_ptx_sreg_ntid_z",
                    "read.ptx.sreg.nwarpid" => "__nvvm_read_ptx_sreg_nwarpid",
                    // [DUPLICATE]: "read.ptx.sreg.nwarpid" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.pm0" => "__nvvm_read_ptx_sreg_pm0",
                    // [DUPLICATE]: "read.ptx.sreg.pm0" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.pm1" => "__nvvm_read_ptx_sreg_pm1",
                    // [DUPLICATE]: "read.ptx.sreg.pm1" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.pm2" => "__nvvm_read_ptx_sreg_pm2",
                    // [DUPLICATE]: "read.ptx.sreg.pm2" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.pm3" => "__nvvm_read_ptx_sreg_pm3",
                    // [DUPLICATE]: "read.ptx.sreg.pm3" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.smid" => "__nvvm_read_ptx_sreg_smid",
                    // [DUPLICATE]: "read.ptx.sreg.smid" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.tid.w" => "__nvvm_read_ptx_sreg_tid_w",
                    "read.ptx.sreg.tid.x" => "__nvvm_read_ptx_sreg_tid_x",
                    "read.ptx.sreg.tid.y" => "__nvvm_read_ptx_sreg_tid_y",
                    "read.ptx.sreg.tid.z" => "__nvvm_read_ptx_sreg_tid_z",
                    "read.ptx.sreg.warpid" => "__nvvm_read_ptx_sreg_warpid",
                    // [DUPLICATE]: "read.ptx.sreg.warpid" => "__nvvm_read_ptx_sreg_",
                    "read.ptx.sreg.warpsize" => "__nvvm_read_ptx_sreg_warpsize",
                    // [DUPLICATE]: "read.ptx.sreg.warpsize" => "__nvvm_read_ptx_sreg_",
                    "redux.sync.add" => "__nvvm_redux_sync_add",
                    "redux.sync.and" => "__nvvm_redux_sync_and",
                    "redux.sync.fmax" => "__nvvm_redux_sync_fmax",
                    "redux.sync.fmax.NaN" => "__nvvm_redux_sync_fmax_NaN",
                    "redux.sync.fmax.abs" => "__nvvm_redux_sync_fmax_abs",
                    "redux.sync.fmax.abs.NaN" => "__nvvm_redux_sync_fmax_abs_NaN",
                    "redux.sync.fmin" => "__nvvm_redux_sync_fmin",
                    "redux.sync.fmin.NaN" => "__nvvm_redux_sync_fmin_NaN",
                    "redux.sync.fmin.abs" => "__nvvm_redux_sync_fmin_abs",
                    "redux.sync.fmin.abs.NaN" => "__nvvm_redux_sync_fmin_abs_NaN",
                    "redux.sync.max" => "__nvvm_redux_sync_max",
                    "redux.sync.min" => "__nvvm_redux_sync_min",
                    "redux.sync.or" => "__nvvm_redux_sync_or",
                    "redux.sync.umax" => "__nvvm_redux_sync_umax",
                    "redux.sync.umin" => "__nvvm_redux_sync_umin",
                    "redux.sync.xor" => "__nvvm_redux_sync_xor",
                    "reflect" => "__nvvm_reflect",
                    "rotate.b32" => "__nvvm_rotate_b32",
                    "rotate.b64" => "__nvvm_rotate_b64",
                    "rotate.right.b64" => "__nvvm_rotate_right_b64",
                    "round.d" => "__nvvm_round_d",
                    "round.f" => "__nvvm_round_f",
                    "round.ftz.f" => "__nvvm_round_ftz_f",
                    "rsqrt.approx.d" => "__nvvm_rsqrt_approx_d",
                    "rsqrt.approx.f" => "__nvvm_rsqrt_approx_f",
                    "rsqrt.approx.ftz.d" => "__nvvm_rsqrt_approx_ftz_d",
                    "rsqrt.approx.ftz.f" => "__nvvm_rsqrt_approx_ftz_f",
                    "sad.i" => "__nvvm_sad_i",
                    "sad.ll" => "__nvvm_sad_ll",
                    "sad.s" => "__nvvm_sad_s",
                    "sad.ui" => "__nvvm_sad_ui",
                    "sad.ull" => "__nvvm_sad_ull",
                    "sad.us" => "__nvvm_sad_us",
                    "saturate.d" => "__nvvm_saturate_d",
                    "saturate.f" => "__nvvm_saturate_f",
                    "saturate.ftz.f" => "__nvvm_saturate_ftz_f",
                    "shfl.bfly.f32" => "__nvvm_shfl_bfly_f32",
                    "shfl.bfly.i32" => "__nvvm_shfl_bfly_i32",
                    "shfl.down.f32" => "__nvvm_shfl_down_f32",
                    "shfl.down.i32" => "__nvvm_shfl_down_i32",
                    "shfl.idx.f32" => "__nvvm_shfl_idx_f32",
                    "shfl.idx.i32" => "__nvvm_shfl_idx_i32",
                    "shfl.sync.bfly.f32" => "__nvvm_shfl_sync_bfly_f32",
                    "shfl.sync.bfly.i32" => "__nvvm_shfl_sync_bfly_i32",
                    "shfl.sync.down.f32" => "__nvvm_shfl_sync_down_f32",
                    "shfl.sync.down.i32" => "__nvvm_shfl_sync_down_i32",
                    "shfl.sync.idx.f32" => "__nvvm_shfl_sync_idx_f32",
                    "shfl.sync.idx.i32" => "__nvvm_shfl_sync_idx_i32",
                    "shfl.sync.up.f32" => "__nvvm_shfl_sync_up_f32",
                    "shfl.sync.up.i32" => "__nvvm_shfl_sync_up_i32",
                    "shfl.up.f32" => "__nvvm_shfl_up_f32",
                    "shfl.up.i32" => "__nvvm_shfl_up_i32",
                    "sin.approx.f" => "__nvvm_sin_approx_f",
                    "sin.approx.ftz.f" => "__nvvm_sin_approx_ftz_f",
                    "sqrt.approx.f" => "__nvvm_sqrt_approx_f",
                    "sqrt.approx.ftz.f" => "__nvvm_sqrt_approx_ftz_f",
                    "sqrt.f" => "__nvvm_sqrt_f",
                    "sqrt.rm.d" => "__nvvm_sqrt_rm_d",
                    "sqrt.rm.f" => "__nvvm_sqrt_rm_f",
                    "sqrt.rm.ftz.f" => "__nvvm_sqrt_rm_ftz_f",
                    "sqrt.rn.d" => "__nvvm_sqrt_rn_d",
                    "sqrt.rn.f" => "__nvvm_sqrt_rn_f",
                    "sqrt.rn.ftz.f" => "__nvvm_sqrt_rn_ftz_f",
                    "sqrt.rp.d" => "__nvvm_sqrt_rp_d",
                    "sqrt.rp.f" => "__nvvm_sqrt_rp_f",
                    "sqrt.rp.ftz.f" => "__nvvm_sqrt_rp_ftz_f",
                    "sqrt.rz.d" => "__nvvm_sqrt_rz_d",
                    "sqrt.rz.f" => "__nvvm_sqrt_rz_f",
                    "sqrt.rz.ftz.f" => "__nvvm_sqrt_rz_ftz_f",
                    "suq.array.size" => "__nvvm_suq_array_size",
                    "suq.channel.data.type" => "__nvvm_suq_channel_data_type",
                    "suq.channel.order" => "__nvvm_suq_channel_order",
                    "suq.depth" => "__nvvm_suq_depth",
                    "suq.height" => "__nvvm_suq_height",
                    "suq.width" => "__nvvm_suq_width",
                    "sust.b.1d.array.i16.clamp" => "__nvvm_sust_b_1d_array_i16_clamp",
                    "sust.b.1d.array.i16.trap" => "__nvvm_sust_b_1d_array_i16_trap",
                    "sust.b.1d.array.i16.zero" => "__nvvm_sust_b_1d_array_i16_zero",
                    "sust.b.1d.array.i32.clamp" => "__nvvm_sust_b_1d_array_i32_clamp",
                    "sust.b.1d.array.i32.trap" => "__nvvm_sust_b_1d_array_i32_trap",
                    "sust.b.1d.array.i32.zero" => "__nvvm_sust_b_1d_array_i32_zero",
                    "sust.b.1d.array.i64.clamp" => "__nvvm_sust_b_1d_array_i64_clamp",
                    "sust.b.1d.array.i64.trap" => "__nvvm_sust_b_1d_array_i64_trap",
                    "sust.b.1d.array.i64.zero" => "__nvvm_sust_b_1d_array_i64_zero",
                    "sust.b.1d.array.i8.clamp" => "__nvvm_sust_b_1d_array_i8_clamp",
                    "sust.b.1d.array.i8.trap" => "__nvvm_sust_b_1d_array_i8_trap",
                    "sust.b.1d.array.i8.zero" => "__nvvm_sust_b_1d_array_i8_zero",
                    "sust.b.1d.array.v2i16.clamp" => "__nvvm_sust_b_1d_array_v2i16_clamp",
                    "sust.b.1d.array.v2i16.trap" => "__nvvm_sust_b_1d_array_v2i16_trap",
                    "sust.b.1d.array.v2i16.zero" => "__nvvm_sust_b_1d_array_v2i16_zero",
                    "sust.b.1d.array.v2i32.clamp" => "__nvvm_sust_b_1d_array_v2i32_clamp",
                    "sust.b.1d.array.v2i32.trap" => "__nvvm_sust_b_1d_array_v2i32_trap",
                    "sust.b.1d.array.v2i32.zero" => "__nvvm_sust_b_1d_array_v2i32_zero",
                    "sust.b.1d.array.v2i64.clamp" => "__nvvm_sust_b_1d_array_v2i64_clamp",
                    "sust.b.1d.array.v2i64.trap" => "__nvvm_sust_b_1d_array_v2i64_trap",
                    "sust.b.1d.array.v2i64.zero" => "__nvvm_sust_b_1d_array_v2i64_zero",
                    "sust.b.1d.array.v2i8.clamp" => "__nvvm_sust_b_1d_array_v2i8_clamp",
                    "sust.b.1d.array.v2i8.trap" => "__nvvm_sust_b_1d_array_v2i8_trap",
                    "sust.b.1d.array.v2i8.zero" => "__nvvm_sust_b_1d_array_v2i8_zero",
                    "sust.b.1d.array.v4i16.clamp" => "__nvvm_sust_b_1d_array_v4i16_clamp",
                    "sust.b.1d.array.v4i16.trap" => "__nvvm_sust_b_1d_array_v4i16_trap",
                    "sust.b.1d.array.v4i16.zero" => "__nvvm_sust_b_1d_array_v4i16_zero",
                    "sust.b.1d.array.v4i32.clamp" => "__nvvm_sust_b_1d_array_v4i32_clamp",
                    "sust.b.1d.array.v4i32.trap" => "__nvvm_sust_b_1d_array_v4i32_trap",
                    "sust.b.1d.array.v4i32.zero" => "__nvvm_sust_b_1d_array_v4i32_zero",
                    "sust.b.1d.array.v4i8.clamp" => "__nvvm_sust_b_1d_array_v4i8_clamp",
                    "sust.b.1d.array.v4i8.trap" => "__nvvm_sust_b_1d_array_v4i8_trap",
                    "sust.b.1d.array.v4i8.zero" => "__nvvm_sust_b_1d_array_v4i8_zero",
                    "sust.b.1d.i16.clamp" => "__nvvm_sust_b_1d_i16_clamp",
                    "sust.b.1d.i16.trap" => "__nvvm_sust_b_1d_i16_trap",
                    "sust.b.1d.i16.zero" => "__nvvm_sust_b_1d_i16_zero",
                    "sust.b.1d.i32.clamp" => "__nvvm_sust_b_1d_i32_clamp",
                    "sust.b.1d.i32.trap" => "__nvvm_sust_b_1d_i32_trap",
                    "sust.b.1d.i32.zero" => "__nvvm_sust_b_1d_i32_zero",
                    "sust.b.1d.i64.clamp" => "__nvvm_sust_b_1d_i64_clamp",
                    "sust.b.1d.i64.trap" => "__nvvm_sust_b_1d_i64_trap",
                    "sust.b.1d.i64.zero" => "__nvvm_sust_b_1d_i64_zero",
                    "sust.b.1d.i8.clamp" => "__nvvm_sust_b_1d_i8_clamp",
                    "sust.b.1d.i8.trap" => "__nvvm_sust_b_1d_i8_trap",
                    "sust.b.1d.i8.zero" => "__nvvm_sust_b_1d_i8_zero",
                    "sust.b.1d.v2i16.clamp" => "__nvvm_sust_b_1d_v2i16_clamp",
                    "sust.b.1d.v2i16.trap" => "__nvvm_sust_b_1d_v2i16_trap",
                    "sust.b.1d.v2i16.zero" => "__nvvm_sust_b_1d_v2i16_zero",
                    "sust.b.1d.v2i32.clamp" => "__nvvm_sust_b_1d_v2i32_clamp",
                    "sust.b.1d.v2i32.trap" => "__nvvm_sust_b_1d_v2i32_trap",
                    "sust.b.1d.v2i32.zero" => "__nvvm_sust_b_1d_v2i32_zero",
                    "sust.b.1d.v2i64.clamp" => "__nvvm_sust_b_1d_v2i64_clamp",
                    "sust.b.1d.v2i64.trap" => "__nvvm_sust_b_1d_v2i64_trap",
                    "sust.b.1d.v2i64.zero" => "__nvvm_sust_b_1d_v2i64_zero",
                    "sust.b.1d.v2i8.clamp" => "__nvvm_sust_b_1d_v2i8_clamp",
                    "sust.b.1d.v2i8.trap" => "__nvvm_sust_b_1d_v2i8_trap",
                    "sust.b.1d.v2i8.zero" => "__nvvm_sust_b_1d_v2i8_zero",
                    "sust.b.1d.v4i16.clamp" => "__nvvm_sust_b_1d_v4i16_clamp",
                    "sust.b.1d.v4i16.trap" => "__nvvm_sust_b_1d_v4i16_trap",
                    "sust.b.1d.v4i16.zero" => "__nvvm_sust_b_1d_v4i16_zero",
                    "sust.b.1d.v4i32.clamp" => "__nvvm_sust_b_1d_v4i32_clamp",
                    "sust.b.1d.v4i32.trap" => "__nvvm_sust_b_1d_v4i32_trap",
                    "sust.b.1d.v4i32.zero" => "__nvvm_sust_b_1d_v4i32_zero",
                    "sust.b.1d.v4i8.clamp" => "__nvvm_sust_b_1d_v4i8_clamp",
                    "sust.b.1d.v4i8.trap" => "__nvvm_sust_b_1d_v4i8_trap",
                    "sust.b.1d.v4i8.zero" => "__nvvm_sust_b_1d_v4i8_zero",
                    "sust.b.2d.array.i16.clamp" => "__nvvm_sust_b_2d_array_i16_clamp",
                    "sust.b.2d.array.i16.trap" => "__nvvm_sust_b_2d_array_i16_trap",
                    "sust.b.2d.array.i16.zero" => "__nvvm_sust_b_2d_array_i16_zero",
                    "sust.b.2d.array.i32.clamp" => "__nvvm_sust_b_2d_array_i32_clamp",
                    "sust.b.2d.array.i32.trap" => "__nvvm_sust_b_2d_array_i32_trap",
                    "sust.b.2d.array.i32.zero" => "__nvvm_sust_b_2d_array_i32_zero",
                    "sust.b.2d.array.i64.clamp" => "__nvvm_sust_b_2d_array_i64_clamp",
                    "sust.b.2d.array.i64.trap" => "__nvvm_sust_b_2d_array_i64_trap",
                    "sust.b.2d.array.i64.zero" => "__nvvm_sust_b_2d_array_i64_zero",
                    "sust.b.2d.array.i8.clamp" => "__nvvm_sust_b_2d_array_i8_clamp",
                    "sust.b.2d.array.i8.trap" => "__nvvm_sust_b_2d_array_i8_trap",
                    "sust.b.2d.array.i8.zero" => "__nvvm_sust_b_2d_array_i8_zero",
                    "sust.b.2d.array.v2i16.clamp" => "__nvvm_sust_b_2d_array_v2i16_clamp",
                    "sust.b.2d.array.v2i16.trap" => "__nvvm_sust_b_2d_array_v2i16_trap",
                    "sust.b.2d.array.v2i16.zero" => "__nvvm_sust_b_2d_array_v2i16_zero",
                    "sust.b.2d.array.v2i32.clamp" => "__nvvm_sust_b_2d_array_v2i32_clamp",
                    "sust.b.2d.array.v2i32.trap" => "__nvvm_sust_b_2d_array_v2i32_trap",
                    "sust.b.2d.array.v2i32.zero" => "__nvvm_sust_b_2d_array_v2i32_zero",
                    "sust.b.2d.array.v2i64.clamp" => "__nvvm_sust_b_2d_array_v2i64_clamp",
                    "sust.b.2d.array.v2i64.trap" => "__nvvm_sust_b_2d_array_v2i64_trap",
                    "sust.b.2d.array.v2i64.zero" => "__nvvm_sust_b_2d_array_v2i64_zero",
                    "sust.b.2d.array.v2i8.clamp" => "__nvvm_sust_b_2d_array_v2i8_clamp",
                    "sust.b.2d.array.v2i8.trap" => "__nvvm_sust_b_2d_array_v2i8_trap",
                    "sust.b.2d.array.v2i8.zero" => "__nvvm_sust_b_2d_array_v2i8_zero",
                    "sust.b.2d.array.v4i16.clamp" => "__nvvm_sust_b_2d_array_v4i16_clamp",
                    "sust.b.2d.array.v4i16.trap" => "__nvvm_sust_b_2d_array_v4i16_trap",
                    "sust.b.2d.array.v4i16.zero" => "__nvvm_sust_b_2d_array_v4i16_zero",
                    "sust.b.2d.array.v4i32.clamp" => "__nvvm_sust_b_2d_array_v4i32_clamp",
                    "sust.b.2d.array.v4i32.trap" => "__nvvm_sust_b_2d_array_v4i32_trap",
                    "sust.b.2d.array.v4i32.zero" => "__nvvm_sust_b_2d_array_v4i32_zero",
                    "sust.b.2d.array.v4i8.clamp" => "__nvvm_sust_b_2d_array_v4i8_clamp",
                    "sust.b.2d.array.v4i8.trap" => "__nvvm_sust_b_2d_array_v4i8_trap",
                    "sust.b.2d.array.v4i8.zero" => "__nvvm_sust_b_2d_array_v4i8_zero",
                    "sust.b.2d.i16.clamp" => "__nvvm_sust_b_2d_i16_clamp",
                    "sust.b.2d.i16.trap" => "__nvvm_sust_b_2d_i16_trap",
                    "sust.b.2d.i16.zero" => "__nvvm_sust_b_2d_i16_zero",
                    "sust.b.2d.i32.clamp" => "__nvvm_sust_b_2d_i32_clamp",
                    "sust.b.2d.i32.trap" => "__nvvm_sust_b_2d_i32_trap",
                    "sust.b.2d.i32.zero" => "__nvvm_sust_b_2d_i32_zero",
                    "sust.b.2d.i64.clamp" => "__nvvm_sust_b_2d_i64_clamp",
                    "sust.b.2d.i64.trap" => "__nvvm_sust_b_2d_i64_trap",
                    "sust.b.2d.i64.zero" => "__nvvm_sust_b_2d_i64_zero",
                    "sust.b.2d.i8.clamp" => "__nvvm_sust_b_2d_i8_clamp",
                    "sust.b.2d.i8.trap" => "__nvvm_sust_b_2d_i8_trap",
                    "sust.b.2d.i8.zero" => "__nvvm_sust_b_2d_i8_zero",
                    "sust.b.2d.v2i16.clamp" => "__nvvm_sust_b_2d_v2i16_clamp",
                    "sust.b.2d.v2i16.trap" => "__nvvm_sust_b_2d_v2i16_trap",
                    "sust.b.2d.v2i16.zero" => "__nvvm_sust_b_2d_v2i16_zero",
                    "sust.b.2d.v2i32.clamp" => "__nvvm_sust_b_2d_v2i32_clamp",
                    "sust.b.2d.v2i32.trap" => "__nvvm_sust_b_2d_v2i32_trap",
                    "sust.b.2d.v2i32.zero" => "__nvvm_sust_b_2d_v2i32_zero",
                    "sust.b.2d.v2i64.clamp" => "__nvvm_sust_b_2d_v2i64_clamp",
                    "sust.b.2d.v2i64.trap" => "__nvvm_sust_b_2d_v2i64_trap",
                    "sust.b.2d.v2i64.zero" => "__nvvm_sust_b_2d_v2i64_zero",
                    "sust.b.2d.v2i8.clamp" => "__nvvm_sust_b_2d_v2i8_clamp",
                    "sust.b.2d.v2i8.trap" => "__nvvm_sust_b_2d_v2i8_trap",
                    "sust.b.2d.v2i8.zero" => "__nvvm_sust_b_2d_v2i8_zero",
                    "sust.b.2d.v4i16.clamp" => "__nvvm_sust_b_2d_v4i16_clamp",
                    "sust.b.2d.v4i16.trap" => "__nvvm_sust_b_2d_v4i16_trap",
                    "sust.b.2d.v4i16.zero" => "__nvvm_sust_b_2d_v4i16_zero",
                    "sust.b.2d.v4i32.clamp" => "__nvvm_sust_b_2d_v4i32_clamp",
                    "sust.b.2d.v4i32.trap" => "__nvvm_sust_b_2d_v4i32_trap",
                    "sust.b.2d.v4i32.zero" => "__nvvm_sust_b_2d_v4i32_zero",
                    "sust.b.2d.v4i8.clamp" => "__nvvm_sust_b_2d_v4i8_clamp",
                    "sust.b.2d.v4i8.trap" => "__nvvm_sust_b_2d_v4i8_trap",
                    "sust.b.2d.v4i8.zero" => "__nvvm_sust_b_2d_v4i8_zero",
                    "sust.b.3d.i16.clamp" => "__nvvm_sust_b_3d_i16_clamp",
                    "sust.b.3d.i16.trap" => "__nvvm_sust_b_3d_i16_trap",
                    "sust.b.3d.i16.zero" => "__nvvm_sust_b_3d_i16_zero",
                    "sust.b.3d.i32.clamp" => "__nvvm_sust_b_3d_i32_clamp",
                    "sust.b.3d.i32.trap" => "__nvvm_sust_b_3d_i32_trap",
                    "sust.b.3d.i32.zero" => "__nvvm_sust_b_3d_i32_zero",
                    "sust.b.3d.i64.clamp" => "__nvvm_sust_b_3d_i64_clamp",
                    "sust.b.3d.i64.trap" => "__nvvm_sust_b_3d_i64_trap",
                    "sust.b.3d.i64.zero" => "__nvvm_sust_b_3d_i64_zero",
                    "sust.b.3d.i8.clamp" => "__nvvm_sust_b_3d_i8_clamp",
                    "sust.b.3d.i8.trap" => "__nvvm_sust_b_3d_i8_trap",
                    "sust.b.3d.i8.zero" => "__nvvm_sust_b_3d_i8_zero",
                    "sust.b.3d.v2i16.clamp" => "__nvvm_sust_b_3d_v2i16_clamp",
                    "sust.b.3d.v2i16.trap" => "__nvvm_sust_b_3d_v2i16_trap",
                    "sust.b.3d.v2i16.zero" => "__nvvm_sust_b_3d_v2i16_zero",
                    "sust.b.3d.v2i32.clamp" => "__nvvm_sust_b_3d_v2i32_clamp",
                    "sust.b.3d.v2i32.trap" => "__nvvm_sust_b_3d_v2i32_trap",
                    "sust.b.3d.v2i32.zero" => "__nvvm_sust_b_3d_v2i32_zero",
                    "sust.b.3d.v2i64.clamp" => "__nvvm_sust_b_3d_v2i64_clamp",
                    "sust.b.3d.v2i64.trap" => "__nvvm_sust_b_3d_v2i64_trap",
                    "sust.b.3d.v2i64.zero" => "__nvvm_sust_b_3d_v2i64_zero",
                    "sust.b.3d.v2i8.clamp" => "__nvvm_sust_b_3d_v2i8_clamp",
                    "sust.b.3d.v2i8.trap" => "__nvvm_sust_b_3d_v2i8_trap",
                    "sust.b.3d.v2i8.zero" => "__nvvm_sust_b_3d_v2i8_zero",
                    "sust.b.3d.v4i16.clamp" => "__nvvm_sust_b_3d_v4i16_clamp",
                    "sust.b.3d.v4i16.trap" => "__nvvm_sust_b_3d_v4i16_trap",
                    "sust.b.3d.v4i16.zero" => "__nvvm_sust_b_3d_v4i16_zero",
                    "sust.b.3d.v4i32.clamp" => "__nvvm_sust_b_3d_v4i32_clamp",
                    "sust.b.3d.v4i32.trap" => "__nvvm_sust_b_3d_v4i32_trap",
                    "sust.b.3d.v4i32.zero" => "__nvvm_sust_b_3d_v4i32_zero",
                    "sust.b.3d.v4i8.clamp" => "__nvvm_sust_b_3d_v4i8_clamp",
                    "sust.b.3d.v4i8.trap" => "__nvvm_sust_b_3d_v4i8_trap",
                    "sust.b.3d.v4i8.zero" => "__nvvm_sust_b_3d_v4i8_zero",
                    "sust.p.1d.array.i16.trap" => "__nvvm_sust_p_1d_array_i16_trap",
                    "sust.p.1d.array.i32.trap" => "__nvvm_sust_p_1d_array_i32_trap",
                    "sust.p.1d.array.i8.trap" => "__nvvm_sust_p_1d_array_i8_trap",
                    "sust.p.1d.array.v2i16.trap" => "__nvvm_sust_p_1d_array_v2i16_trap",
                    "sust.p.1d.array.v2i32.trap" => "__nvvm_sust_p_1d_array_v2i32_trap",
                    "sust.p.1d.array.v2i8.trap" => "__nvvm_sust_p_1d_array_v2i8_trap",
                    "sust.p.1d.array.v4i16.trap" => "__nvvm_sust_p_1d_array_v4i16_trap",
                    "sust.p.1d.array.v4i32.trap" => "__nvvm_sust_p_1d_array_v4i32_trap",
                    "sust.p.1d.array.v4i8.trap" => "__nvvm_sust_p_1d_array_v4i8_trap",
                    "sust.p.1d.i16.trap" => "__nvvm_sust_p_1d_i16_trap",
                    "sust.p.1d.i32.trap" => "__nvvm_sust_p_1d_i32_trap",
                    "sust.p.1d.i8.trap" => "__nvvm_sust_p_1d_i8_trap",
                    "sust.p.1d.v2i16.trap" => "__nvvm_sust_p_1d_v2i16_trap",
                    "sust.p.1d.v2i32.trap" => "__nvvm_sust_p_1d_v2i32_trap",
                    "sust.p.1d.v2i8.trap" => "__nvvm_sust_p_1d_v2i8_trap",
                    "sust.p.1d.v4i16.trap" => "__nvvm_sust_p_1d_v4i16_trap",
                    "sust.p.1d.v4i32.trap" => "__nvvm_sust_p_1d_v4i32_trap",
                    "sust.p.1d.v4i8.trap" => "__nvvm_sust_p_1d_v4i8_trap",
                    "sust.p.2d.array.i16.trap" => "__nvvm_sust_p_2d_array_i16_trap",
                    "sust.p.2d.array.i32.trap" => "__nvvm_sust_p_2d_array_i32_trap",
                    "sust.p.2d.array.i8.trap" => "__nvvm_sust_p_2d_array_i8_trap",
                    "sust.p.2d.array.v2i16.trap" => "__nvvm_sust_p_2d_array_v2i16_trap",
                    "sust.p.2d.array.v2i32.trap" => "__nvvm_sust_p_2d_array_v2i32_trap",
                    "sust.p.2d.array.v2i8.trap" => "__nvvm_sust_p_2d_array_v2i8_trap",
                    "sust.p.2d.array.v4i16.trap" => "__nvvm_sust_p_2d_array_v4i16_trap",
                    "sust.p.2d.array.v4i32.trap" => "__nvvm_sust_p_2d_array_v4i32_trap",
                    "sust.p.2d.array.v4i8.trap" => "__nvvm_sust_p_2d_array_v4i8_trap",
                    "sust.p.2d.i16.trap" => "__nvvm_sust_p_2d_i16_trap",
                    "sust.p.2d.i32.trap" => "__nvvm_sust_p_2d_i32_trap",
                    "sust.p.2d.i8.trap" => "__nvvm_sust_p_2d_i8_trap",
                    "sust.p.2d.v2i16.trap" => "__nvvm_sust_p_2d_v2i16_trap",
                    "sust.p.2d.v2i32.trap" => "__nvvm_sust_p_2d_v2i32_trap",
                    "sust.p.2d.v2i8.trap" => "__nvvm_sust_p_2d_v2i8_trap",
                    "sust.p.2d.v4i16.trap" => "__nvvm_sust_p_2d_v4i16_trap",
                    "sust.p.2d.v4i32.trap" => "__nvvm_sust_p_2d_v4i32_trap",
                    "sust.p.2d.v4i8.trap" => "__nvvm_sust_p_2d_v4i8_trap",
                    "sust.p.3d.i16.trap" => "__nvvm_sust_p_3d_i16_trap",
                    "sust.p.3d.i32.trap" => "__nvvm_sust_p_3d_i32_trap",
                    "sust.p.3d.i8.trap" => "__nvvm_sust_p_3d_i8_trap",
                    "sust.p.3d.v2i16.trap" => "__nvvm_sust_p_3d_v2i16_trap",
                    "sust.p.3d.v2i32.trap" => "__nvvm_sust_p_3d_v2i32_trap",
                    "sust.p.3d.v2i8.trap" => "__nvvm_sust_p_3d_v2i8_trap",
                    "sust.p.3d.v4i16.trap" => "__nvvm_sust_p_3d_v4i16_trap",
                    "sust.p.3d.v4i32.trap" => "__nvvm_sust_p_3d_v4i32_trap",
                    "sust.p.3d.v4i8.trap" => "__nvvm_sust_p_3d_v4i8_trap",
                    "swap.lo.hi.b64" => "__nvvm_swap_lo_hi_b64",
                    "trunc.d" => "__nvvm_trunc_d",
                    "trunc.f" => "__nvvm_trunc_f",
                    "trunc.ftz.f" => "__nvvm_trunc_ftz_f",
                    "txq.array.size" => "__nvvm_txq_array_size",
                    "txq.channel.data.type" => "__nvvm_txq_channel_data_type",
                    "txq.channel.order" => "__nvvm_txq_channel_order",
                    "txq.depth" => "__nvvm_txq_depth",
                    "txq.height" => "__nvvm_txq_height",
                    "txq.num.mipmap.levels" => "__nvvm_txq_num_mipmap_levels",
                    "txq.num.samples" => "__nvvm_txq_num_samples",
                    "txq.width" => "__nvvm_txq_width",
                    "ue8m0x2.to.bf16x2" => "__nvvm_ue8m0x2_to_bf16x2",
                    "ui2d.rm" => "__nvvm_ui2d_rm",
                    "ui2d.rn" => "__nvvm_ui2d_rn",
                    "ui2d.rp" => "__nvvm_ui2d_rp",
                    "ui2d.rz" => "__nvvm_ui2d_rz",
                    "ui2f.rm" => "__nvvm_ui2f_rm",
                    "ui2f.rn" => "__nvvm_ui2f_rn",
                    "ui2f.rp" => "__nvvm_ui2f_rp",
                    "ui2f.rz" => "__nvvm_ui2f_rz",
                    "ull2d.rm" => "__nvvm_ull2d_rm",
                    "ull2d.rn" => "__nvvm_ull2d_rn",
                    "ull2d.rp" => "__nvvm_ull2d_rp",
                    "ull2d.rz" => "__nvvm_ull2d_rz",
                    "ull2f.rm" => "__nvvm_ull2f_rm",
                    "ull2f.rn" => "__nvvm_ull2f_rn",
                    "ull2f.rp" => "__nvvm_ull2f_rp",
                    "ull2f.rz" => "__nvvm_ull2f_rz",
                    "vote.all" => "__nvvm_vote_all",
                    "vote.all.sync" => "__nvvm_vote_all_sync",
                    "vote.any" => "__nvvm_vote_any",
                    "vote.any.sync" => "__nvvm_vote_any_sync",
                    "vote.ballot" => "__nvvm_vote_ballot",
                    "vote.ballot.sync" => "__nvvm_vote_ballot_sync",
                    "vote.uni" => "__nvvm_vote_uni",
                    "vote.uni.sync" => "__nvvm_vote_uni_sync",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            nvvm(name, full_name)
        }
        "ppc" => {
            fn ppc(name: &str, full_name: &str) -> &'static str {
                match name {
                    // ppc
                    "addex" => "__builtin_ppc_addex",
                    "addf128.round.to.odd" => "__builtin_addf128_round_to_odd",
                    "addg6s" => "__builtin_addg6s",
                    "addg6sd" => "__builtin_ppc_addg6s",
                    "altivec.crypto.vcipher" => "__builtin_altivec_crypto_vcipher",
                    "altivec.crypto.vcipherlast" => "__builtin_altivec_crypto_vcipherlast",
                    "altivec.crypto.vncipher" => "__builtin_altivec_crypto_vncipher",
                    "altivec.crypto.vncipherlast" => "__builtin_altivec_crypto_vncipherlast",
                    "altivec.crypto.vpermxor" => "__builtin_altivec_crypto_vpermxor",
                    "altivec.crypto.vpermxor.be" => "__builtin_altivec_crypto_vpermxor_be",
                    "altivec.crypto.vpmsumb" => "__builtin_altivec_crypto_vpmsumb",
                    "altivec.crypto.vpmsumd" => "__builtin_altivec_crypto_vpmsumd",
                    "altivec.crypto.vpmsumh" => "__builtin_altivec_crypto_vpmsumh",
                    "altivec.crypto.vpmsumw" => "__builtin_altivec_crypto_vpmsumw",
                    "altivec.crypto.vsbox" => "__builtin_altivec_crypto_vsbox",
                    "altivec.crypto.vshasigmad" => "__builtin_altivec_crypto_vshasigmad",
                    "altivec.crypto.vshasigmaw" => "__builtin_altivec_crypto_vshasigmaw",
                    "altivec.dss" => "__builtin_altivec_dss",
                    "altivec.dssall" => "__builtin_altivec_dssall",
                    "altivec.dst" => "__builtin_altivec_dst",
                    "altivec.dstst" => "__builtin_altivec_dstst",
                    "altivec.dststt" => "__builtin_altivec_dststt",
                    "altivec.dstt" => "__builtin_altivec_dstt",
                    "altivec.mfvscr" => "__builtin_altivec_mfvscr",
                    "altivec.mtvscr" => "__builtin_altivec_mtvscr",
                    "altivec.mtvsrbm" => "__builtin_altivec_mtvsrbm",
                    "altivec.mtvsrdm" => "__builtin_altivec_mtvsrdm",
                    "altivec.mtvsrhm" => "__builtin_altivec_mtvsrhm",
                    "altivec.mtvsrqm" => "__builtin_altivec_mtvsrqm",
                    "altivec.mtvsrwm" => "__builtin_altivec_mtvsrwm",
                    "altivec.vabsdub" => "__builtin_altivec_vabsdub",
                    "altivec.vabsduh" => "__builtin_altivec_vabsduh",
                    "altivec.vabsduw" => "__builtin_altivec_vabsduw",
                    "altivec.vaddcuq" => "__builtin_altivec_vaddcuq",
                    "altivec.vaddcuw" => "__builtin_altivec_vaddcuw",
                    "altivec.vaddecuq" => "__builtin_altivec_vaddecuq",
                    "altivec.vaddeuqm" => "__builtin_altivec_vaddeuqm",
                    "altivec.vaddsbs" => "__builtin_altivec_vaddsbs",
                    "altivec.vaddshs" => "__builtin_altivec_vaddshs",
                    "altivec.vaddsws" => "__builtin_altivec_vaddsws",
                    "altivec.vaddubs" => "__builtin_altivec_vaddubs",
                    "altivec.vadduhs" => "__builtin_altivec_vadduhs",
                    "altivec.vadduws" => "__builtin_altivec_vadduws",
                    "altivec.vavgsb" => "__builtin_altivec_vavgsb",
                    "altivec.vavgsh" => "__builtin_altivec_vavgsh",
                    "altivec.vavgsw" => "__builtin_altivec_vavgsw",
                    "altivec.vavgub" => "__builtin_altivec_vavgub",
                    "altivec.vavguh" => "__builtin_altivec_vavguh",
                    "altivec.vavguw" => "__builtin_altivec_vavguw",
                    "altivec.vbpermd" => "__builtin_altivec_vbpermd",
                    "altivec.vbpermq" => "__builtin_altivec_vbpermq",
                    "altivec.vcfsx" => "__builtin_altivec_vcfsx",
                    "altivec.vcfuged" => "__builtin_altivec_vcfuged",
                    "altivec.vcfux" => "__builtin_altivec_vcfux",
                    "altivec.vclrlb" => "__builtin_altivec_vclrlb",
                    "altivec.vclrrb" => "__builtin_altivec_vclrrb",
                    "altivec.vclzdm" => "__builtin_altivec_vclzdm",
                    "altivec.vclzlsbb" => "__builtin_altivec_vclzlsbb",
                    "altivec.vcmpbfp" => "__builtin_altivec_vcmpbfp",
                    "altivec.vcmpbfp.p" => "__builtin_altivec_vcmpbfp_p",
                    "altivec.vcmpeqfp" => "__builtin_altivec_vcmpeqfp",
                    "altivec.vcmpeqfp.p" => "__builtin_altivec_vcmpeqfp_p",
                    "altivec.vcmpequb" => "__builtin_altivec_vcmpequb",
                    "altivec.vcmpequb.p" => "__builtin_altivec_vcmpequb_p",
                    "altivec.vcmpequd" => "__builtin_altivec_vcmpequd",
                    "altivec.vcmpequd.p" => "__builtin_altivec_vcmpequd_p",
                    "altivec.vcmpequh" => "__builtin_altivec_vcmpequh",
                    "altivec.vcmpequh.p" => "__builtin_altivec_vcmpequh_p",
                    "altivec.vcmpequq" => "__builtin_altivec_vcmpequq",
                    "altivec.vcmpequq.p" => "__builtin_altivec_vcmpequq_p",
                    "altivec.vcmpequw" => "__builtin_altivec_vcmpequw",
                    "altivec.vcmpequw.p" => "__builtin_altivec_vcmpequw_p",
                    "altivec.vcmpgefp" => "__builtin_altivec_vcmpgefp",
                    "altivec.vcmpgefp.p" => "__builtin_altivec_vcmpgefp_p",
                    "altivec.vcmpgtfp" => "__builtin_altivec_vcmpgtfp",
                    "altivec.vcmpgtfp.p" => "__builtin_altivec_vcmpgtfp_p",
                    "altivec.vcmpgtsb" => "__builtin_altivec_vcmpgtsb",
                    "altivec.vcmpgtsb.p" => "__builtin_altivec_vcmpgtsb_p",
                    "altivec.vcmpgtsd" => "__builtin_altivec_vcmpgtsd",
                    "altivec.vcmpgtsd.p" => "__builtin_altivec_vcmpgtsd_p",
                    "altivec.vcmpgtsh" => "__builtin_altivec_vcmpgtsh",
                    "altivec.vcmpgtsh.p" => "__builtin_altivec_vcmpgtsh_p",
                    "altivec.vcmpgtsq" => "__builtin_altivec_vcmpgtsq",
                    "altivec.vcmpgtsq.p" => "__builtin_altivec_vcmpgtsq_p",
                    "altivec.vcmpgtsw" => "__builtin_altivec_vcmpgtsw",
                    "altivec.vcmpgtsw.p" => "__builtin_altivec_vcmpgtsw_p",
                    "altivec.vcmpgtub" => "__builtin_altivec_vcmpgtub",
                    "altivec.vcmpgtub.p" => "__builtin_altivec_vcmpgtub_p",
                    "altivec.vcmpgtud" => "__builtin_altivec_vcmpgtud",
                    "altivec.vcmpgtud.p" => "__builtin_altivec_vcmpgtud_p",
                    "altivec.vcmpgtuh" => "__builtin_altivec_vcmpgtuh",
                    "altivec.vcmpgtuh.p" => "__builtin_altivec_vcmpgtuh_p",
                    "altivec.vcmpgtuq" => "__builtin_altivec_vcmpgtuq",
                    "altivec.vcmpgtuq.p" => "__builtin_altivec_vcmpgtuq_p",
                    "altivec.vcmpgtuw" => "__builtin_altivec_vcmpgtuw",
                    "altivec.vcmpgtuw.p" => "__builtin_altivec_vcmpgtuw_p",
                    "altivec.vcmpneb" => "__builtin_altivec_vcmpneb",
                    "altivec.vcmpneb.p" => "__builtin_altivec_vcmpneb_p",
                    "altivec.vcmpneh" => "__builtin_altivec_vcmpneh",
                    "altivec.vcmpneh.p" => "__builtin_altivec_vcmpneh_p",
                    "altivec.vcmpnew" => "__builtin_altivec_vcmpnew",
                    "altivec.vcmpnew.p" => "__builtin_altivec_vcmpnew_p",
                    "altivec.vcmpnezb" => "__builtin_altivec_vcmpnezb",
                    "altivec.vcmpnezb.p" => "__builtin_altivec_vcmpnezb_p",
                    "altivec.vcmpnezh" => "__builtin_altivec_vcmpnezh",
                    "altivec.vcmpnezh.p" => "__builtin_altivec_vcmpnezh_p",
                    "altivec.vcmpnezw" => "__builtin_altivec_vcmpnezw",
                    "altivec.vcmpnezw.p" => "__builtin_altivec_vcmpnezw_p",
                    "altivec.vcntmbb" => "__builtin_altivec_vcntmbb",
                    "altivec.vcntmbd" => "__builtin_altivec_vcntmbd",
                    "altivec.vcntmbh" => "__builtin_altivec_vcntmbh",
                    "altivec.vcntmbw" => "__builtin_altivec_vcntmbw",
                    "altivec.vctsxs" => "__builtin_altivec_vctsxs",
                    "altivec.vctuxs" => "__builtin_altivec_vctuxs",
                    "altivec.vctzdm" => "__builtin_altivec_vctzdm",
                    "altivec.vctzlsbb" => "__builtin_altivec_vctzlsbb",
                    "altivec.vdivesd" => "__builtin_altivec_vdivesd",
                    "altivec.vdivesq" => "__builtin_altivec_vdivesq",
                    "altivec.vdivesw" => "__builtin_altivec_vdivesw",
                    "altivec.vdiveud" => "__builtin_altivec_vdiveud",
                    "altivec.vdiveuq" => "__builtin_altivec_vdiveuq",
                    "altivec.vdiveuw" => "__builtin_altivec_vdiveuw",
                    "altivec.vexpandbm" => "__builtin_altivec_vexpandbm",
                    "altivec.vexpanddm" => "__builtin_altivec_vexpanddm",
                    "altivec.vexpandhm" => "__builtin_altivec_vexpandhm",
                    "altivec.vexpandqm" => "__builtin_altivec_vexpandqm",
                    "altivec.vexpandwm" => "__builtin_altivec_vexpandwm",
                    "altivec.vexptefp" => "__builtin_altivec_vexptefp",
                    "altivec.vextddvlx" => "__builtin_altivec_vextddvlx",
                    "altivec.vextddvrx" => "__builtin_altivec_vextddvrx",
                    "altivec.vextdubvlx" => "__builtin_altivec_vextdubvlx",
                    "altivec.vextdubvrx" => "__builtin_altivec_vextdubvrx",
                    "altivec.vextduhvlx" => "__builtin_altivec_vextduhvlx",
                    "altivec.vextduhvrx" => "__builtin_altivec_vextduhvrx",
                    "altivec.vextduwvlx" => "__builtin_altivec_vextduwvlx",
                    "altivec.vextduwvrx" => "__builtin_altivec_vextduwvrx",
                    "altivec.vextractbm" => "__builtin_altivec_vextractbm",
                    "altivec.vextractdm" => "__builtin_altivec_vextractdm",
                    "altivec.vextracthm" => "__builtin_altivec_vextracthm",
                    "altivec.vextractqm" => "__builtin_altivec_vextractqm",
                    "altivec.vextractwm" => "__builtin_altivec_vextractwm",
                    "altivec.vextsb2d" => "__builtin_altivec_vextsb2d",
                    "altivec.vextsb2w" => "__builtin_altivec_vextsb2w",
                    "altivec.vextsd2q" => "__builtin_altivec_vextsd2q",
                    "altivec.vextsh2d" => "__builtin_altivec_vextsh2d",
                    "altivec.vextsh2w" => "__builtin_altivec_vextsh2w",
                    "altivec.vextsw2d" => "__builtin_altivec_vextsw2d",
                    "altivec.vgbbd" => "__builtin_altivec_vgbbd",
                    "altivec.vgnb" => "__builtin_altivec_vgnb",
                    "altivec.vinsblx" => "__builtin_altivec_vinsblx",
                    "altivec.vinsbrx" => "__builtin_altivec_vinsbrx",
                    "altivec.vinsbvlx" => "__builtin_altivec_vinsbvlx",
                    "altivec.vinsbvrx" => "__builtin_altivec_vinsbvrx",
                    "altivec.vinsdlx" => "__builtin_altivec_vinsdlx",
                    "altivec.vinsdrx" => "__builtin_altivec_vinsdrx",
                    "altivec.vinshlx" => "__builtin_altivec_vinshlx",
                    "altivec.vinshrx" => "__builtin_altivec_vinshrx",
                    "altivec.vinshvlx" => "__builtin_altivec_vinshvlx",
                    "altivec.vinshvrx" => "__builtin_altivec_vinshvrx",
                    "altivec.vinswlx" => "__builtin_altivec_vinswlx",
                    "altivec.vinswrx" => "__builtin_altivec_vinswrx",
                    "altivec.vinswvlx" => "__builtin_altivec_vinswvlx",
                    "altivec.vinswvrx" => "__builtin_altivec_vinswvrx",
                    "altivec.vlogefp" => "__builtin_altivec_vlogefp",
                    "altivec.vmaddfp" => "__builtin_altivec_vmaddfp",
                    "altivec.vmaxfp" => "__builtin_altivec_vmaxfp",
                    "altivec.vmaxsb" => "__builtin_altivec_vmaxsb",
                    "altivec.vmaxsd" => "__builtin_altivec_vmaxsd",
                    "altivec.vmaxsh" => "__builtin_altivec_vmaxsh",
                    "altivec.vmaxsw" => "__builtin_altivec_vmaxsw",
                    "altivec.vmaxub" => "__builtin_altivec_vmaxub",
                    "altivec.vmaxud" => "__builtin_altivec_vmaxud",
                    "altivec.vmaxuh" => "__builtin_altivec_vmaxuh",
                    "altivec.vmaxuw" => "__builtin_altivec_vmaxuw",
                    "altivec.vmhaddshs" => "__builtin_altivec_vmhaddshs",
                    "altivec.vmhraddshs" => "__builtin_altivec_vmhraddshs",
                    "altivec.vminfp" => "__builtin_altivec_vminfp",
                    "altivec.vminsb" => "__builtin_altivec_vminsb",
                    "altivec.vminsd" => "__builtin_altivec_vminsd",
                    "altivec.vminsh" => "__builtin_altivec_vminsh",
                    "altivec.vminsw" => "__builtin_altivec_vminsw",
                    "altivec.vminub" => "__builtin_altivec_vminub",
                    "altivec.vminud" => "__builtin_altivec_vminud",
                    "altivec.vminuh" => "__builtin_altivec_vminuh",
                    "altivec.vminuw" => "__builtin_altivec_vminuw",
                    "altivec.vmladduhm" => "__builtin_altivec_vmladduhm",
                    "altivec.vmsumcud" => "__builtin_altivec_vmsumcud",
                    "altivec.vmsummbm" => "__builtin_altivec_vmsummbm",
                    "altivec.vmsumshm" => "__builtin_altivec_vmsumshm",
                    "altivec.vmsumshs" => "__builtin_altivec_vmsumshs",
                    "altivec.vmsumubm" => "__builtin_altivec_vmsumubm",
                    "altivec.vmsumudm" => "__builtin_altivec_vmsumudm",
                    "altivec.vmsumuhm" => "__builtin_altivec_vmsumuhm",
                    "altivec.vmsumuhs" => "__builtin_altivec_vmsumuhs",
                    "altivec.vmulesb" => "__builtin_altivec_vmulesb",
                    "altivec.vmulesd" => "__builtin_altivec_vmulesd",
                    "altivec.vmulesh" => "__builtin_altivec_vmulesh",
                    "altivec.vmulesw" => "__builtin_altivec_vmulesw",
                    "altivec.vmuleub" => "__builtin_altivec_vmuleub",
                    "altivec.vmuleud" => "__builtin_altivec_vmuleud",
                    "altivec.vmuleuh" => "__builtin_altivec_vmuleuh",
                    "altivec.vmuleuw" => "__builtin_altivec_vmuleuw",
                    "altivec.vmulhsd" => "__builtin_altivec_vmulhsd",
                    "altivec.vmulhsw" => "__builtin_altivec_vmulhsw",
                    "altivec.vmulhud" => "__builtin_altivec_vmulhud",
                    "altivec.vmulhuw" => "__builtin_altivec_vmulhuw",
                    "altivec.vmulosb" => "__builtin_altivec_vmulosb",
                    "altivec.vmulosd" => "__builtin_altivec_vmulosd",
                    "altivec.vmulosh" => "__builtin_altivec_vmulosh",
                    "altivec.vmulosw" => "__builtin_altivec_vmulosw",
                    "altivec.vmuloub" => "__builtin_altivec_vmuloub",
                    "altivec.vmuloud" => "__builtin_altivec_vmuloud",
                    "altivec.vmulouh" => "__builtin_altivec_vmulouh",
                    "altivec.vmulouw" => "__builtin_altivec_vmulouw",
                    "altivec.vnmsubfp" => "__builtin_altivec_vnmsubfp",
                    "altivec.vpdepd" => "__builtin_altivec_vpdepd",
                    "altivec.vperm" => "__builtin_altivec_vperm_4si",
                    "altivec.vpextd" => "__builtin_altivec_vpextd",
                    "altivec.vpkpx" => "__builtin_altivec_vpkpx",
                    "altivec.vpksdss" => "__builtin_altivec_vpksdss",
                    "altivec.vpksdus" => "__builtin_altivec_vpksdus",
                    "altivec.vpkshss" => "__builtin_altivec_vpkshss",
                    "altivec.vpkshus" => "__builtin_altivec_vpkshus",
                    "altivec.vpkswss" => "__builtin_altivec_vpkswss",
                    "altivec.vpkswus" => "__builtin_altivec_vpkswus",
                    "altivec.vpkudus" => "__builtin_altivec_vpkudus",
                    "altivec.vpkuhus" => "__builtin_altivec_vpkuhus",
                    "altivec.vpkuwus" => "__builtin_altivec_vpkuwus",
                    "altivec.vprtybd" => "__builtin_altivec_vprtybd",
                    "altivec.vprtybq" => "__builtin_altivec_vprtybq",
                    "altivec.vprtybw" => "__builtin_altivec_vprtybw",
                    "altivec.vrefp" => "__builtin_altivec_vrefp",
                    "altivec.vrfim" => "__builtin_altivec_vrfim",
                    "altivec.vrfin" => "__builtin_altivec_vrfin",
                    "altivec.vrfip" => "__builtin_altivec_vrfip",
                    "altivec.vrfiz" => "__builtin_altivec_vrfiz",
                    "altivec.vrlb" => "__builtin_altivec_vrlb",
                    "altivec.vrld" => "__builtin_altivec_vrld",
                    "altivec.vrldmi" => "__builtin_altivec_vrldmi",
                    "altivec.vrldnm" => "__builtin_altivec_vrldnm",
                    "altivec.vrlh" => "__builtin_altivec_vrlh",
                    "altivec.vrlqmi" => "__builtin_altivec_vrlqmi",
                    "altivec.vrlqnm" => "__builtin_altivec_vrlqnm",
                    "altivec.vrlw" => "__builtin_altivec_vrlw",
                    "altivec.vrlwmi" => "__builtin_altivec_vrlwmi",
                    "altivec.vrlwnm" => "__builtin_altivec_vrlwnm",
                    "altivec.vrsqrtefp" => "__builtin_altivec_vrsqrtefp",
                    "altivec.vsel" => "__builtin_altivec_vsel_4si",
                    "altivec.vsl" => "__builtin_altivec_vsl",
                    "altivec.vslb" => "__builtin_altivec_vslb",
                    "altivec.vsldbi" => "__builtin_altivec_vsldbi",
                    "altivec.vslh" => "__builtin_altivec_vslh",
                    "altivec.vslo" => "__builtin_altivec_vslo",
                    "altivec.vslv" => "__builtin_altivec_vslv",
                    "altivec.vslw" => "__builtin_altivec_vslw",
                    "altivec.vsr" => "__builtin_altivec_vsr",
                    "altivec.vsrab" => "__builtin_altivec_vsrab",
                    "altivec.vsrah" => "__builtin_altivec_vsrah",
                    "altivec.vsraw" => "__builtin_altivec_vsraw",
                    "altivec.vsrb" => "__builtin_altivec_vsrb",
                    "altivec.vsrdbi" => "__builtin_altivec_vsrdbi",
                    "altivec.vsrh" => "__builtin_altivec_vsrh",
                    "altivec.vsro" => "__builtin_altivec_vsro",
                    "altivec.vsrv" => "__builtin_altivec_vsrv",
                    "altivec.vsrw" => "__builtin_altivec_vsrw",
                    "altivec.vstribl" => "__builtin_altivec_vstribl",
                    "altivec.vstribl.p" => "__builtin_altivec_vstribl_p",
                    "altivec.vstribr" => "__builtin_altivec_vstribr",
                    "altivec.vstribr.p" => "__builtin_altivec_vstribr_p",
                    "altivec.vstrihl" => "__builtin_altivec_vstrihl",
                    "altivec.vstrihl.p" => "__builtin_altivec_vstrihl_p",
                    "altivec.vstrihr" => "__builtin_altivec_vstrihr",
                    "altivec.vstrihr.p" => "__builtin_altivec_vstrihr_p",
                    "altivec.vsubcuq" => "__builtin_altivec_vsubcuq",
                    "altivec.vsubcuw" => "__builtin_altivec_vsubcuw",
                    "altivec.vsubecuq" => "__builtin_altivec_vsubecuq",
                    "altivec.vsubeuqm" => "__builtin_altivec_vsubeuqm",
                    "altivec.vsubsbs" => "__builtin_altivec_vsubsbs",
                    "altivec.vsubshs" => "__builtin_altivec_vsubshs",
                    "altivec.vsubsws" => "__builtin_altivec_vsubsws",
                    "altivec.vsububs" => "__builtin_altivec_vsububs",
                    "altivec.vsubuhs" => "__builtin_altivec_vsubuhs",
                    "altivec.vsubuws" => "__builtin_altivec_vsubuws",
                    "altivec.vsum2sws" => "__builtin_altivec_vsum2sws",
                    "altivec.vsum4sbs" => "__builtin_altivec_vsum4sbs",
                    "altivec.vsum4shs" => "__builtin_altivec_vsum4shs",
                    "altivec.vsum4ubs" => "__builtin_altivec_vsum4ubs",
                    "altivec.vsumsws" => "__builtin_altivec_vsumsws",
                    "altivec.vupkhpx" => "__builtin_altivec_vupkhpx",
                    "altivec.vupkhsb" => "__builtin_altivec_vupkhsb",
                    "altivec.vupkhsh" => "__builtin_altivec_vupkhsh",
                    "altivec.vupkhsw" => "__builtin_altivec_vupkhsw",
                    "altivec.vupklpx" => "__builtin_altivec_vupklpx",
                    "altivec.vupklsb" => "__builtin_altivec_vupklsb",
                    "altivec.vupklsh" => "__builtin_altivec_vupklsh",
                    "altivec.vupklsw" => "__builtin_altivec_vupklsw",
                    "amo.ldat" => "__builtin_amo_ldat",
                    "amo.lwat" => "__builtin_amo_lwat",
                    "bcdadd" => "__builtin_ppc_bcdadd",
                    "bcdadd.p" => "__builtin_ppc_bcdadd_p",
                    "bcdcopysign" => "__builtin_ppc_bcdcopysign",
                    "bcdsetsign" => "__builtin_ppc_bcdsetsign",
                    "bcdsub" => "__builtin_ppc_bcdsub",
                    "bcdsub.p" => "__builtin_ppc_bcdsub_p",
                    "bpermd" => "__builtin_bpermd",
                    "cbcdtd" => "__builtin_cbcdtd",
                    "cbcdtdd" => "__builtin_ppc_cbcdtd",
                    "cdtbcd" => "__builtin_cdtbcd",
                    "cdtbcdd" => "__builtin_ppc_cdtbcd",
                    "cfuged" => "__builtin_cfuged",
                    "cmpeqb" => "__builtin_ppc_cmpeqb",
                    "cmprb" => "__builtin_ppc_cmprb",
                    "cntlzdm" => "__builtin_cntlzdm",
                    "cnttzdm" => "__builtin_cnttzdm",
                    "compare.exp.eq" => "__builtin_ppc_compare_exp_eq",
                    "compare.exp.gt" => "__builtin_ppc_compare_exp_gt",
                    "compare.exp.lt" => "__builtin_ppc_compare_exp_lt",
                    "compare.exp.uo" => "__builtin_ppc_compare_exp_uo",
                    "darn" => "__builtin_darn",
                    "darn32" => "__builtin_darn_32",
                    "darnraw" => "__builtin_darn_raw",
                    "dcbf" => "__builtin_dcbf",
                    "dcbfl" => "__builtin_ppc_dcbfl",
                    "dcbflp" => "__builtin_ppc_dcbflp",
                    "dcbst" => "__builtin_ppc_dcbst",
                    "dcbt" => "__builtin_ppc_dcbt",
                    "dcbtst" => "__builtin_ppc_dcbtst",
                    "dcbtstt" => "__builtin_ppc_dcbtstt",
                    "dcbtt" => "__builtin_ppc_dcbtt",
                    "dcbz" => "__builtin_ppc_dcbz",
                    "divde" => "__builtin_divde",
                    "divdeu" => "__builtin_divdeu",
                    "divf128.round.to.odd" => "__builtin_divf128_round_to_odd",
                    "divwe" => "__builtin_divwe",
                    "divweu" => "__builtin_divweu",
                    "eieio" => "__builtin_ppc_eieio",
                    "extract.exp" => "__builtin_ppc_extract_exp",
                    "extract.sig" => "__builtin_ppc_extract_sig",
                    "fcfid" => "__builtin_ppc_fcfid",
                    "fcfud" => "__builtin_ppc_fcfud",
                    "fctid" => "__builtin_ppc_fctid",
                    "fctidz" => "__builtin_ppc_fctidz",
                    "fctiw" => "__builtin_ppc_fctiw",
                    "fctiwz" => "__builtin_ppc_fctiwz",
                    "fctudz" => "__builtin_ppc_fctudz",
                    "fctuwz" => "__builtin_ppc_fctuwz",
                    "fence" => "__builtin_ppc_fence",
                    "fmaf128.round.to.odd" => "__builtin_fmaf128_round_to_odd",
                    "fmsub" => "__builtin_ppc_fmsub",
                    "fmsubs" => "__builtin_ppc_fmsubs",
                    "fnabs" => "__builtin_ppc_fnabs",
                    "fnabss" => "__builtin_ppc_fnabss",
                    "fnmadd" => "__builtin_ppc_fnmadd",
                    "fnmadds" => "__builtin_ppc_fnmadds",
                    "fre" => "__builtin_ppc_fre",
                    "fres" => "__builtin_ppc_fres",
                    "frsqrte" => "__builtin_ppc_frsqrte",
                    "frsqrtes" => "__builtin_ppc_frsqrtes",
                    "fsel" => "__builtin_ppc_fsel",
                    "fsels" => "__builtin_ppc_fsels",
                    "get.texasr" => "__builtin_get_texasr",
                    "get.texasru" => "__builtin_get_texasru",
                    "get.tfhar" => "__builtin_get_tfhar",
                    "get.tfiar" => "__builtin_get_tfiar",
                    "icbt" => "__builtin_ppc_icbt",
                    "insert.exp" => "__builtin_ppc_insert_exp",
                    "iospace.eieio" => "__builtin_ppc_iospace_eieio",
                    "iospace.lwsync" => "__builtin_ppc_iospace_lwsync",
                    "iospace.sync" => "__builtin_ppc_iospace_sync",
                    "isync" => "__builtin_ppc_isync",
                    "load4r" => "__builtin_ppc_load4r",
                    "load8r" => "__builtin_ppc_load8r",
                    "lwsync" => "__builtin_ppc_lwsync",
                    "maddhd" => "__builtin_ppc_maddhd",
                    "maddhdu" => "__builtin_ppc_maddhdu",
                    "maddld" => "__builtin_ppc_maddld",
                    "mffsl" => "__builtin_ppc_mffsl",
                    "mfmsr" => "__builtin_ppc_mfmsr",
                    "mftbu" => "__builtin_ppc_mftbu",
                    "mtfsb0" => "__builtin_ppc_mtfsb0",
                    "mtfsb1" => "__builtin_ppc_mtfsb1",
                    "mtfsfi" => "__builtin_ppc_mtfsfi",
                    "mtmsr" => "__builtin_ppc_mtmsr",
                    "mulf128.round.to.odd" => "__builtin_mulf128_round_to_odd",
                    "mulhd" => "__builtin_ppc_mulhd",
                    "mulhdu" => "__builtin_ppc_mulhdu",
                    "mulhw" => "__builtin_ppc_mulhw",
                    "mulhwu" => "__builtin_ppc_mulhwu",
                    "national2packed" => "__builtin_ppc_national2packed",
                    "pack.longdouble" => "__builtin_pack_longdouble",
                    "packed2national" => "__builtin_ppc_packed2national",
                    "packed2zoned" => "__builtin_ppc_packed2zoned",
                    "pdepd" => "__builtin_pdepd",
                    "pextd" => "__builtin_pextd",
                    "qpx.qvfabs" => "__builtin_qpx_qvfabs",
                    "qpx.qvfadd" => "__builtin_qpx_qvfadd",
                    "qpx.qvfadds" => "__builtin_qpx_qvfadds",
                    "qpx.qvfcfid" => "__builtin_qpx_qvfcfid",
                    "qpx.qvfcfids" => "__builtin_qpx_qvfcfids",
                    "qpx.qvfcfidu" => "__builtin_qpx_qvfcfidu",
                    "qpx.qvfcfidus" => "__builtin_qpx_qvfcfidus",
                    "qpx.qvfcmpeq" => "__builtin_qpx_qvfcmpeq",
                    "qpx.qvfcmpgt" => "__builtin_qpx_qvfcmpgt",
                    "qpx.qvfcmplt" => "__builtin_qpx_qvfcmplt",
                    "qpx.qvfcpsgn" => "__builtin_qpx_qvfcpsgn",
                    "qpx.qvfctid" => "__builtin_qpx_qvfctid",
                    "qpx.qvfctidu" => "__builtin_qpx_qvfctidu",
                    "qpx.qvfctiduz" => "__builtin_qpx_qvfctiduz",
                    "qpx.qvfctidz" => "__builtin_qpx_qvfctidz",
                    "qpx.qvfctiw" => "__builtin_qpx_qvfctiw",
                    "qpx.qvfctiwu" => "__builtin_qpx_qvfctiwu",
                    "qpx.qvfctiwuz" => "__builtin_qpx_qvfctiwuz",
                    "qpx.qvfctiwz" => "__builtin_qpx_qvfctiwz",
                    "qpx.qvflogical" => "__builtin_qpx_qvflogical",
                    "qpx.qvfmadd" => "__builtin_qpx_qvfmadd",
                    "qpx.qvfmadds" => "__builtin_qpx_qvfmadds",
                    "qpx.qvfmsub" => "__builtin_qpx_qvfmsub",
                    "qpx.qvfmsubs" => "__builtin_qpx_qvfmsubs",
                    "qpx.qvfmul" => "__builtin_qpx_qvfmul",
                    "qpx.qvfmuls" => "__builtin_qpx_qvfmuls",
                    "qpx.qvfnabs" => "__builtin_qpx_qvfnabs",
                    "qpx.qvfneg" => "__builtin_qpx_qvfneg",
                    "qpx.qvfnmadd" => "__builtin_qpx_qvfnmadd",
                    "qpx.qvfnmadds" => "__builtin_qpx_qvfnmadds",
                    "qpx.qvfnmsub" => "__builtin_qpx_qvfnmsub",
                    "qpx.qvfnmsubs" => "__builtin_qpx_qvfnmsubs",
                    "qpx.qvfperm" => "__builtin_qpx_qvfperm",
                    "qpx.qvfre" => "__builtin_qpx_qvfre",
                    "qpx.qvfres" => "__builtin_qpx_qvfres",
                    "qpx.qvfrim" => "__builtin_qpx_qvfrim",
                    "qpx.qvfrin" => "__builtin_qpx_qvfrin",
                    "qpx.qvfrip" => "__builtin_qpx_qvfrip",
                    "qpx.qvfriz" => "__builtin_qpx_qvfriz",
                    "qpx.qvfrsp" => "__builtin_qpx_qvfrsp",
                    "qpx.qvfrsqrte" => "__builtin_qpx_qvfrsqrte",
                    "qpx.qvfrsqrtes" => "__builtin_qpx_qvfrsqrtes",
                    "qpx.qvfsel" => "__builtin_qpx_qvfsel",
                    "qpx.qvfsub" => "__builtin_qpx_qvfsub",
                    "qpx.qvfsubs" => "__builtin_qpx_qvfsubs",
                    "qpx.qvftstnan" => "__builtin_qpx_qvftstnan",
                    "qpx.qvfxmadd" => "__builtin_qpx_qvfxmadd",
                    "qpx.qvfxmadds" => "__builtin_qpx_qvfxmadds",
                    "qpx.qvfxmul" => "__builtin_qpx_qvfxmul",
                    "qpx.qvfxmuls" => "__builtin_qpx_qvfxmuls",
                    "qpx.qvfxxcpnmadd" => "__builtin_qpx_qvfxxcpnmadd",
                    "qpx.qvfxxcpnmadds" => "__builtin_qpx_qvfxxcpnmadds",
                    "qpx.qvfxxmadd" => "__builtin_qpx_qvfxxmadd",
                    "qpx.qvfxxmadds" => "__builtin_qpx_qvfxxmadds",
                    "qpx.qvfxxnpmadd" => "__builtin_qpx_qvfxxnpmadd",
                    "qpx.qvfxxnpmadds" => "__builtin_qpx_qvfxxnpmadds",
                    "qpx.qvgpci" => "__builtin_qpx_qvgpci",
                    "qpx.qvlfcd" => "__builtin_qpx_qvlfcd",
                    "qpx.qvlfcda" => "__builtin_qpx_qvlfcda",
                    "qpx.qvlfcs" => "__builtin_qpx_qvlfcs",
                    "qpx.qvlfcsa" => "__builtin_qpx_qvlfcsa",
                    "qpx.qvlfd" => "__builtin_qpx_qvlfd",
                    "qpx.qvlfda" => "__builtin_qpx_qvlfda",
                    "qpx.qvlfiwa" => "__builtin_qpx_qvlfiwa",
                    "qpx.qvlfiwaa" => "__builtin_qpx_qvlfiwaa",
                    "qpx.qvlfiwz" => "__builtin_qpx_qvlfiwz",
                    "qpx.qvlfiwza" => "__builtin_qpx_qvlfiwza",
                    "qpx.qvlfs" => "__builtin_qpx_qvlfs",
                    "qpx.qvlfsa" => "__builtin_qpx_qvlfsa",
                    "qpx.qvlpcld" => "__builtin_qpx_qvlpcld",
                    "qpx.qvlpcls" => "__builtin_qpx_qvlpcls",
                    "qpx.qvlpcrd" => "__builtin_qpx_qvlpcrd",
                    "qpx.qvlpcrs" => "__builtin_qpx_qvlpcrs",
                    "qpx.qvstfcd" => "__builtin_qpx_qvstfcd",
                    "qpx.qvstfcda" => "__builtin_qpx_qvstfcda",
                    "qpx.qvstfcs" => "__builtin_qpx_qvstfcs",
                    "qpx.qvstfcsa" => "__builtin_qpx_qvstfcsa",
                    "qpx.qvstfd" => "__builtin_qpx_qvstfd",
                    "qpx.qvstfda" => "__builtin_qpx_qvstfda",
                    "qpx.qvstfiw" => "__builtin_qpx_qvstfiw",
                    "qpx.qvstfiwa" => "__builtin_qpx_qvstfiwa",
                    "qpx.qvstfs" => "__builtin_qpx_qvstfs",
                    "qpx.qvstfsa" => "__builtin_qpx_qvstfsa",
                    "readflm" => "__builtin_readflm",
                    "rlwimi" => "__builtin_ppc_rlwimi",
                    "rlwnm" => "__builtin_ppc_rlwnm",
                    "scalar.extract.expq" => "__builtin_vsx_scalar_extract_expq",
                    "scalar.insert.exp.qp" => "__builtin_vsx_scalar_insert_exp_qp",
                    "set.texasr" => "__builtin_set_texasr",
                    "set.texasru" => "__builtin_set_texasru",
                    "set.tfhar" => "__builtin_set_tfhar",
                    "set.tfiar" => "__builtin_set_tfiar",
                    "setb" => "__builtin_ppc_setb",
                    "setflm" => "__builtin_setflm",
                    "setrnd" => "__builtin_setrnd",
                    "sqrtf128.round.to.odd" => "__builtin_sqrtf128_round_to_odd",
                    "stbcx" => "__builtin_ppc_stbcx",
                    "stdcx" => "__builtin_ppc_stdcx",
                    "stfiw" => "__builtin_ppc_stfiw",
                    "store2r" => "__builtin_ppc_store2r",
                    "store4r" => "__builtin_ppc_store4r",
                    "store8r" => "__builtin_ppc_store8r",
                    "stwcx" => "__builtin_ppc_stwcx",
                    "subf128.round.to.odd" => "__builtin_subf128_round_to_odd",
                    "sync" => "__builtin_ppc_sync",
                    "tabort" => "__builtin_tabort",
                    "tabortdc" => "__builtin_tabortdc",
                    "tabortdci" => "__builtin_tabortdci",
                    "tabortwc" => "__builtin_tabortwc",
                    "tabortwci" => "__builtin_tabortwci",
                    "tbegin" => "__builtin_tbegin",
                    "tcheck" => "__builtin_tcheck",
                    "tdw" => "__builtin_ppc_tdw",
                    "tend" => "__builtin_tend",
                    "tendall" => "__builtin_tendall",
                    "trap" => "__builtin_ppc_trap",
                    "trapd" => "__builtin_ppc_trapd",
                    "trechkpt" => "__builtin_trechkpt",
                    "treclaim" => "__builtin_treclaim",
                    "tresume" => "__builtin_tresume",
                    "truncf128.round.to.odd" => "__builtin_truncf128_round_to_odd",
                    "tsr" => "__builtin_tsr",
                    "tsuspend" => "__builtin_tsuspend",
                    "ttest" => "__builtin_ttest",
                    "tw" => "__builtin_ppc_tw",
                    "unpack.longdouble" => "__builtin_unpack_longdouble",
                    "vsx.xsmaxdp" => "__builtin_vsx_xsmaxdp",
                    "vsx.xsmindp" => "__builtin_vsx_xsmindp",
                    "vsx.xvcmpeqdp" => "__builtin_vsx_xvcmpeqdp",
                    "vsx.xvcmpeqdp.p" => "__builtin_vsx_xvcmpeqdp_p",
                    "vsx.xvcmpeqsp" => "__builtin_vsx_xvcmpeqsp",
                    "vsx.xvcmpeqsp.p" => "__builtin_vsx_xvcmpeqsp_p",
                    "vsx.xvcmpgedp" => "__builtin_vsx_xvcmpgedp",
                    "vsx.xvcmpgedp.p" => "__builtin_vsx_xvcmpgedp_p",
                    "vsx.xvcmpgesp" => "__builtin_vsx_xvcmpgesp",
                    "vsx.xvcmpgesp.p" => "__builtin_vsx_xvcmpgesp_p",
                    "vsx.xvcmpgtdp" => "__builtin_vsx_xvcmpgtdp",
                    "vsx.xvcmpgtdp.p" => "__builtin_vsx_xvcmpgtdp_p",
                    "vsx.xvcmpgtsp" => "__builtin_vsx_xvcmpgtsp",
                    "vsx.xvcmpgtsp.p" => "__builtin_vsx_xvcmpgtsp_p",
                    "vsx.xvcvbf16spn" => "__builtin_vsx_xvcvbf16spn",
                    "vsx.xvcvdpsp" => "__builtin_vsx_xvcvdpsp",
                    "vsx.xvcvdpsxws" => "__builtin_vsx_xvcvdpsxws",
                    "vsx.xvcvdpuxws" => "__builtin_vsx_xvcvdpuxws",
                    "vsx.xvcvhpsp" => "__builtin_vsx_xvcvhpsp",
                    "vsx.xvcvspbf16" => "__builtin_vsx_xvcvspbf16",
                    "vsx.xvcvspdp" => "__builtin_vsx_xvcvspdp",
                    "vsx.xvcvsphp" => "__builtin_vsx_xvcvsphp",
                    "vsx.xvcvspsxds" => "__builtin_vsx_xvcvspsxds",
                    "vsx.xvcvspuxds" => "__builtin_vsx_xvcvspuxds",
                    "vsx.xvcvsxdsp" => "__builtin_vsx_xvcvsxdsp",
                    "vsx.xvcvsxwdp" => "__builtin_vsx_xvcvsxwdp",
                    "vsx.xvcvuxdsp" => "__builtin_vsx_xvcvuxdsp",
                    "vsx.xvcvuxwdp" => "__builtin_vsx_xvcvuxwdp",
                    "vsx.xvdivdp" => "__builtin_vsx_xvdivdp",
                    "vsx.xvdivsp" => "__builtin_vsx_xvdivsp",
                    "vsx.xviexpdp" => "__builtin_vsx_xviexpdp",
                    "vsx.xviexpsp" => "__builtin_vsx_xviexpsp",
                    "vsx.xvmaxdp" => "__builtin_vsx_xvmaxdp",
                    "vsx.xvmaxsp" => "__builtin_vsx_xvmaxsp",
                    "vsx.xvmindp" => "__builtin_vsx_xvmindp",
                    "vsx.xvminsp" => "__builtin_vsx_xvminsp",
                    "vsx.xvredp" => "__builtin_vsx_xvredp",
                    "vsx.xvresp" => "__builtin_vsx_xvresp",
                    "vsx.xvrlw" => "__builtin_vsx_xvrlw",
                    "vsx.xvrsqrtedp" => "__builtin_vsx_xvrsqrtedp",
                    "vsx.xvrsqrtesp" => "__builtin_vsx_xvrsqrtesp",
                    "vsx.xvtdivdp" => "__builtin_vsx_xvtdivdp",
                    "vsx.xvtdivsp" => "__builtin_vsx_xvtdivsp",
                    "vsx.xvtlsbb" => "__builtin_vsx_xvtlsbb",
                    "vsx.xvtsqrtdp" => "__builtin_vsx_xvtsqrtdp",
                    "vsx.xvtsqrtsp" => "__builtin_vsx_xvtsqrtsp",
                    "vsx.xvtstdcdp" => "__builtin_vsx_xvtstdcdp",
                    "vsx.xvtstdcsp" => "__builtin_vsx_xvtstdcsp",
                    "vsx.xvxexpdp" => "__builtin_vsx_xvxexpdp",
                    "vsx.xvxexpsp" => "__builtin_vsx_xvxexpsp",
                    "vsx.xvxsigdp" => "__builtin_vsx_xvxsigdp",
                    "vsx.xvxsigsp" => "__builtin_vsx_xvxsigsp",
                    "vsx.xxblendvb" => "__builtin_vsx_xxblendvb",
                    "vsx.xxblendvd" => "__builtin_vsx_xxblendvd",
                    "vsx.xxblendvh" => "__builtin_vsx_xxblendvh",
                    "vsx.xxblendvw" => "__builtin_vsx_xxblendvw",
                    "vsx.xxeval" => "__builtin_vsx_xxeval",
                    "vsx.xxextractuw" => "__builtin_vsx_xxextractuw",
                    "vsx.xxgenpcvbm" => "__builtin_vsx_xxgenpcvbm",
                    "vsx.xxgenpcvdm" => "__builtin_vsx_xxgenpcvdm",
                    "vsx.xxgenpcvhm" => "__builtin_vsx_xxgenpcvhm",
                    "vsx.xxgenpcvwm" => "__builtin_vsx_xxgenpcvwm",
                    "vsx.xxinsertw" => "__builtin_vsx_xxinsertw",
                    "vsx.xxleqv" => "__builtin_vsx_xxleqv",
                    "vsx.xxpermx" => "__builtin_vsx_xxpermx",
                    "zoned2packed" => "__builtin_ppc_zoned2packed",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            ppc(name, full_name)
        }
        "ptx" => {
            fn ptx(name: &str, full_name: &str) -> &'static str {
                match name {
                    // ptx
                    "bar.sync" => "__builtin_ptx_bar_sync",
                    "read.clock" => "__builtin_ptx_read_clock",
                    "read.clock64" => "__builtin_ptx_read_clock64",
                    "read.gridid" => "__builtin_ptx_read_gridid",
                    "read.laneid" => "__builtin_ptx_read_laneid",
                    "read.lanemask.eq" => "__builtin_ptx_read_lanemask_eq",
                    "read.lanemask.ge" => "__builtin_ptx_read_lanemask_ge",
                    "read.lanemask.gt" => "__builtin_ptx_read_lanemask_gt",
                    "read.lanemask.le" => "__builtin_ptx_read_lanemask_le",
                    "read.lanemask.lt" => "__builtin_ptx_read_lanemask_lt",
                    "read.nsmid" => "__builtin_ptx_read_nsmid",
                    "read.nwarpid" => "__builtin_ptx_read_nwarpid",
                    "read.pm0" => "__builtin_ptx_read_pm0",
                    "read.pm1" => "__builtin_ptx_read_pm1",
                    "read.pm2" => "__builtin_ptx_read_pm2",
                    "read.pm3" => "__builtin_ptx_read_pm3",
                    "read.smid" => "__builtin_ptx_read_smid",
                    "read.warpid" => "__builtin_ptx_read_warpid",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            ptx(name, full_name)
        }
        "r600" => {
            fn r600(name: &str, full_name: &str) -> &'static str {
                match name {
                    // r600
                    "group.barrier" => "__builtin_r600_group_barrier",
                    "implicitarg.ptr" => "__builtin_r600_implicitarg_ptr",
                    "rat.store.typed" => "__builtin_r600_rat_store_typed",
                    "read.global.size.x" => "__builtin_r600_read_global_size_x",
                    "read.global.size.y" => "__builtin_r600_read_global_size_y",
                    "read.global.size.z" => "__builtin_r600_read_global_size_z",
                    "read.ngroups.x" => "__builtin_r600_read_ngroups_x",
                    "read.ngroups.y" => "__builtin_r600_read_ngroups_y",
                    "read.ngroups.z" => "__builtin_r600_read_ngroups_z",
                    "read.tgid.x" => "__builtin_r600_read_tgid_x",
                    "read.tgid.y" => "__builtin_r600_read_tgid_y",
                    "read.tgid.z" => "__builtin_r600_read_tgid_z",
                    "read.tidig.x" => "__builtin_r600_read_tidig_x",
                    "read.tidig.y" => "__builtin_r600_read_tidig_y",
                    "read.tidig.z" => "__builtin_r600_read_tidig_z",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            r600(name, full_name)
        }
        "riscv" => {
            fn riscv(name: &str, full_name: &str) -> &'static str {
                match name {
                    // riscv
                    "aes32dsi" => "__builtin_riscv_aes32dsi",
                    "aes32dsmi" => "__builtin_riscv_aes32dsmi",
                    "aes32esi" => "__builtin_riscv_aes32esi",
                    "aes32esmi" => "__builtin_riscv_aes32esmi",
                    "aes64ds" => "__builtin_riscv_aes64ds",
                    "aes64dsm" => "__builtin_riscv_aes64dsm",
                    "aes64es" => "__builtin_riscv_aes64es",
                    "aes64esm" => "__builtin_riscv_aes64esm",
                    "aes64im" => "__builtin_riscv_aes64im",
                    "aes64ks1i" => "__builtin_riscv_aes64ks1i",
                    "aes64ks2" => "__builtin_riscv_aes64ks2",
                    "mips.ehb" => "__builtin_riscv_mips_ehb",
                    "mips.ihb" => "__builtin_riscv_mips_ihb",
                    "mips.pause" => "__builtin_riscv_mips_pause",
                    "sha512sig0" => "__builtin_riscv_sha512sig0",
                    "sha512sig0h" => "__builtin_riscv_sha512sig0h",
                    "sha512sig0l" => "__builtin_riscv_sha512sig0l",
                    "sha512sig1" => "__builtin_riscv_sha512sig1",
                    "sha512sig1h" => "__builtin_riscv_sha512sig1h",
                    "sha512sig1l" => "__builtin_riscv_sha512sig1l",
                    "sha512sum0" => "__builtin_riscv_sha512sum0",
                    "sha512sum0r" => "__builtin_riscv_sha512sum0r",
                    "sha512sum1" => "__builtin_riscv_sha512sum1",
                    "sha512sum1r" => "__builtin_riscv_sha512sum1r",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            riscv(name, full_name)
        }
        "s390" => {
            fn s390(name: &str, full_name: &str) -> &'static str {
                match name {
                    // s390
                    "bdepg" => "__builtin_s390_bdepg",
                    "bextg" => "__builtin_s390_bextg",
                    "efpc" => "__builtin_s390_efpc",
                    "etnd" => "__builtin_tx_nesting_depth",
                    "lcbb" => "__builtin_s390_lcbb",
                    "ppa.txassist" => "__builtin_tx_assist",
                    "sfpc" => "__builtin_s390_sfpc",
                    "tend" => "__builtin_tend",
                    "vaccb" => "__builtin_s390_vaccb",
                    "vacccq" => "__builtin_s390_vacccq",
                    "vaccf" => "__builtin_s390_vaccf",
                    "vaccg" => "__builtin_s390_vaccg",
                    "vacch" => "__builtin_s390_vacch",
                    "vaccq" => "__builtin_s390_vaccq",
                    "vacq" => "__builtin_s390_vacq",
                    "vaq" => "__builtin_s390_vaq",
                    "vavgb" => "__builtin_s390_vavgb",
                    "vavgf" => "__builtin_s390_vavgf",
                    "vavgg" => "__builtin_s390_vavgg",
                    "vavgh" => "__builtin_s390_vavgh",
                    "vavglb" => "__builtin_s390_vavglb",
                    "vavglf" => "__builtin_s390_vavglf",
                    "vavglg" => "__builtin_s390_vavglg",
                    "vavglh" => "__builtin_s390_vavglh",
                    "vavglq" => "__builtin_s390_vavglq",
                    "vavgq" => "__builtin_s390_vavgq",
                    "vbperm" => "__builtin_s390_vbperm",
                    "vcfn" => "__builtin_s390_vcfn",
                    "vcksm" => "__builtin_s390_vcksm",
                    "vclfnhs" => "__builtin_s390_vclfnhs",
                    "vclfnls" => "__builtin_s390_vclfnls",
                    "vcnf" => "__builtin_s390_vcnf",
                    "vcrnfs" => "__builtin_s390_vcrnfs",
                    "verimb" => "__builtin_s390_verimb",
                    "verimf" => "__builtin_s390_verimf",
                    "verimg" => "__builtin_s390_verimg",
                    "verimh" => "__builtin_s390_verimh",
                    "veval" => "__builtin_s390_veval",
                    "vfaeb" => "__builtin_s390_vfaeb",
                    "vfaef" => "__builtin_s390_vfaef",
                    "vfaeh" => "__builtin_s390_vfaeh",
                    "vfaezb" => "__builtin_s390_vfaezb",
                    "vfaezf" => "__builtin_s390_vfaezf",
                    "vfaezh" => "__builtin_s390_vfaezh",
                    "vfeeb" => "__builtin_s390_vfeeb",
                    "vfeef" => "__builtin_s390_vfeef",
                    "vfeeh" => "__builtin_s390_vfeeh",
                    "vfeezb" => "__builtin_s390_vfeezb",
                    "vfeezf" => "__builtin_s390_vfeezf",
                    "vfeezh" => "__builtin_s390_vfeezh",
                    "vfeneb" => "__builtin_s390_vfeneb",
                    "vfenef" => "__builtin_s390_vfenef",
                    "vfeneh" => "__builtin_s390_vfeneh",
                    "vfenezb" => "__builtin_s390_vfenezb",
                    "vfenezf" => "__builtin_s390_vfenezf",
                    "vfenezh" => "__builtin_s390_vfenezh",
                    "vgemb" => "__builtin_s390_vgemb",
                    "vgemf" => "__builtin_s390_vgemf",
                    "vgemg" => "__builtin_s390_vgemg",
                    "vgemh" => "__builtin_s390_vgemh",
                    "vgemq" => "__builtin_s390_vgemq",
                    "vgfmab" => "__builtin_s390_vgfmab",
                    "vgfmaf" => "__builtin_s390_vgfmaf",
                    "vgfmag" => "__builtin_s390_vgfmag",
                    "vgfmah" => "__builtin_s390_vgfmah",
                    "vgfmb" => "__builtin_s390_vgfmb",
                    "vgfmf" => "__builtin_s390_vgfmf",
                    "vgfmg" => "__builtin_s390_vgfmg",
                    "vgfmh" => "__builtin_s390_vgfmh",
                    "vistrb" => "__builtin_s390_vistrb",
                    "vistrf" => "__builtin_s390_vistrf",
                    "vistrh" => "__builtin_s390_vistrh",
                    "vlbb" => "__builtin_s390_vlbb",
                    "vll" => "__builtin_s390_vll",
                    "vlrl" => "__builtin_s390_vlrlr",
                    "vmaeb" => "__builtin_s390_vmaeb",
                    "vmaef" => "__builtin_s390_vmaef",
                    "vmaeg" => "__builtin_s390_vmaeg",
                    "vmaeh" => "__builtin_s390_vmaeh",
                    "vmahb" => "__builtin_s390_vmahb",
                    "vmahf" => "__builtin_s390_vmahf",
                    "vmahg" => "__builtin_s390_vmahg",
                    "vmahh" => "__builtin_s390_vmahh",
                    "vmahq" => "__builtin_s390_vmahq",
                    "vmaleb" => "__builtin_s390_vmaleb",
                    "vmalef" => "__builtin_s390_vmalef",
                    "vmaleg" => "__builtin_s390_vmaleg",
                    "vmaleh" => "__builtin_s390_vmaleh",
                    "vmalhb" => "__builtin_s390_vmalhb",
                    "vmalhf" => "__builtin_s390_vmalhf",
                    "vmalhg" => "__builtin_s390_vmalhg",
                    "vmalhh" => "__builtin_s390_vmalhh",
                    "vmalhq" => "__builtin_s390_vmalhq",
                    "vmalob" => "__builtin_s390_vmalob",
                    "vmalof" => "__builtin_s390_vmalof",
                    "vmalog" => "__builtin_s390_vmalog",
                    "vmaloh" => "__builtin_s390_vmaloh",
                    "vmaob" => "__builtin_s390_vmaob",
                    "vmaof" => "__builtin_s390_vmaof",
                    "vmaog" => "__builtin_s390_vmaog",
                    "vmaoh" => "__builtin_s390_vmaoh",
                    "vmeb" => "__builtin_s390_vmeb",
                    "vmef" => "__builtin_s390_vmef",
                    "vmeg" => "__builtin_s390_vmeg",
                    "vmeh" => "__builtin_s390_vmeh",
                    "vmhb" => "__builtin_s390_vmhb",
                    "vmhf" => "__builtin_s390_vmhf",
                    "vmhg" => "__builtin_s390_vmhg",
                    "vmhh" => "__builtin_s390_vmhh",
                    "vmhq" => "__builtin_s390_vmhq",
                    "vmleb" => "__builtin_s390_vmleb",
                    "vmlef" => "__builtin_s390_vmlef",
                    "vmleg" => "__builtin_s390_vmleg",
                    "vmleh" => "__builtin_s390_vmleh",
                    "vmlhb" => "__builtin_s390_vmlhb",
                    "vmlhf" => "__builtin_s390_vmlhf",
                    "vmlhg" => "__builtin_s390_vmlhg",
                    "vmlhh" => "__builtin_s390_vmlhh",
                    "vmlhq" => "__builtin_s390_vmlhq",
                    "vmlob" => "__builtin_s390_vmlob",
                    "vmlof" => "__builtin_s390_vmlof",
                    "vmlog" => "__builtin_s390_vmlog",
                    "vmloh" => "__builtin_s390_vmloh",
                    "vmob" => "__builtin_s390_vmob",
                    "vmof" => "__builtin_s390_vmof",
                    "vmog" => "__builtin_s390_vmog",
                    "vmoh" => "__builtin_s390_vmoh",
                    "vmslg" => "__builtin_s390_vmslg",
                    "vpdi" => "__builtin_s390_vpdi",
                    "vperm" => "__builtin_s390_vperm",
                    "vpklsf" => "__builtin_s390_vpklsf",
                    "vpklsg" => "__builtin_s390_vpklsg",
                    "vpklsh" => "__builtin_s390_vpklsh",
                    "vpksf" => "__builtin_s390_vpksf",
                    "vpksg" => "__builtin_s390_vpksg",
                    "vpksh" => "__builtin_s390_vpksh",
                    "vsbcbiq" => "__builtin_s390_vsbcbiq",
                    "vsbiq" => "__builtin_s390_vsbiq",
                    "vscbib" => "__builtin_s390_vscbib",
                    "vscbif" => "__builtin_s390_vscbif",
                    "vscbig" => "__builtin_s390_vscbig",
                    "vscbih" => "__builtin_s390_vscbih",
                    "vscbiq" => "__builtin_s390_vscbiq",
                    "vsl" => "__builtin_s390_vsl",
                    "vslb" => "__builtin_s390_vslb",
                    "vsld" => "__builtin_s390_vsld",
                    "vsldb" => "__builtin_s390_vsldb",
                    "vsq" => "__builtin_s390_vsq",
                    "vsra" => "__builtin_s390_vsra",
                    "vsrab" => "__builtin_s390_vsrab",
                    "vsrd" => "__builtin_s390_vsrd",
                    "vsrl" => "__builtin_s390_vsrl",
                    "vsrlb" => "__builtin_s390_vsrlb",
                    "vstl" => "__builtin_s390_vstl",
                    "vstrcb" => "__builtin_s390_vstrcb",
                    "vstrcf" => "__builtin_s390_vstrcf",
                    "vstrch" => "__builtin_s390_vstrch",
                    "vstrczb" => "__builtin_s390_vstrczb",
                    "vstrczf" => "__builtin_s390_vstrczf",
                    "vstrczh" => "__builtin_s390_vstrczh",
                    "vstrl" => "__builtin_s390_vstrlr",
                    "vsumb" => "__builtin_s390_vsumb",
                    "vsumgf" => "__builtin_s390_vsumgf",
                    "vsumgh" => "__builtin_s390_vsumgh",
                    "vsumh" => "__builtin_s390_vsumh",
                    "vsumqf" => "__builtin_s390_vsumqf",
                    "vsumqg" => "__builtin_s390_vsumqg",
                    "vtm" => "__builtin_s390_vtm",
                    "vuphb" => "__builtin_s390_vuphb",
                    "vuphf" => "__builtin_s390_vuphf",
                    "vuphg" => "__builtin_s390_vuphg",
                    "vuphh" => "__builtin_s390_vuphh",
                    "vuplb" => "__builtin_s390_vuplb",
                    "vuplf" => "__builtin_s390_vuplf",
                    "vuplg" => "__builtin_s390_vuplg",
                    "vuplhb" => "__builtin_s390_vuplhb",
                    "vuplhf" => "__builtin_s390_vuplhf",
                    "vuplhg" => "__builtin_s390_vuplhg",
                    "vuplhh" => "__builtin_s390_vuplhh",
                    "vuplhw" => "__builtin_s390_vuplhw",
                    "vupllb" => "__builtin_s390_vupllb",
                    "vupllf" => "__builtin_s390_vupllf",
                    "vupllg" => "__builtin_s390_vupllg",
                    "vupllh" => "__builtin_s390_vupllh",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            s390(name, full_name)
        }
        "spv" => {
            fn spv(name: &str, full_name: &str) -> &'static str {
                match name {
                    // spv
                    "num.subgroups" => "__builtin_spirv_num_subgroups",
                    "subgroup.id" => "__builtin_spirv_subgroup_id",
                    "subgroup.local.invocation.id" => {
                        "__builtin_spirv_subgroup_local_invocation_id"
                    }
                    "subgroup.max.size" => "__builtin_spirv_subgroup_max_size",
                    "subgroup.size" => "__builtin_spirv_subgroup_size",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            spv(name, full_name)
        }
        "ve" => {
            fn ve(name: &str, full_name: &str) -> &'static str {
                match name {
                    // ve
                    "vl.andm.MMM" => "__builtin_ve_vl_andm_MMM",
                    "vl.andm.mmm" => "__builtin_ve_vl_andm_mmm",
                    "vl.eqvm.MMM" => "__builtin_ve_vl_eqvm_MMM",
                    "vl.eqvm.mmm" => "__builtin_ve_vl_eqvm_mmm",
                    "vl.extract.vm512l" => "__builtin_ve_vl_extract_vm512l",
                    "vl.extract.vm512u" => "__builtin_ve_vl_extract_vm512u",
                    "vl.fencec.s" => "__builtin_ve_vl_fencec_s",
                    "vl.fencei" => "__builtin_ve_vl_fencei",
                    "vl.fencem.s" => "__builtin_ve_vl_fencem_s",
                    "vl.fidcr.sss" => "__builtin_ve_vl_fidcr_sss",
                    "vl.insert.vm512l" => "__builtin_ve_vl_insert_vm512l",
                    "vl.insert.vm512u" => "__builtin_ve_vl_insert_vm512u",
                    "vl.lcr.sss" => "__builtin_ve_vl_lcr_sss",
                    "vl.lsv.vvss" => "__builtin_ve_vl_lsv_vvss",
                    "vl.lvm.MMss" => "__builtin_ve_vl_lvm_MMss",
                    "vl.lvm.mmss" => "__builtin_ve_vl_lvm_mmss",
                    "vl.lvsd.svs" => "__builtin_ve_vl_lvsd_svs",
                    "vl.lvsl.svs" => "__builtin_ve_vl_lvsl_svs",
                    "vl.lvss.svs" => "__builtin_ve_vl_lvss_svs",
                    "vl.lzvm.sml" => "__builtin_ve_vl_lzvm_sml",
                    "vl.negm.MM" => "__builtin_ve_vl_negm_MM",
                    "vl.negm.mm" => "__builtin_ve_vl_negm_mm",
                    "vl.nndm.MMM" => "__builtin_ve_vl_nndm_MMM",
                    "vl.nndm.mmm" => "__builtin_ve_vl_nndm_mmm",
                    "vl.orm.MMM" => "__builtin_ve_vl_orm_MMM",
                    "vl.orm.mmm" => "__builtin_ve_vl_orm_mmm",
                    "vl.pack.f32a" => "__builtin_ve_vl_pack_f32a",
                    "vl.pack.f32p" => "__builtin_ve_vl_pack_f32p",
                    "vl.pcvm.sml" => "__builtin_ve_vl_pcvm_sml",
                    "vl.pfchv.ssl" => "__builtin_ve_vl_pfchv_ssl",
                    "vl.pfchvnc.ssl" => "__builtin_ve_vl_pfchvnc_ssl",
                    "vl.pvadds.vsvMvl" => "__builtin_ve_vl_pvadds_vsvMvl",
                    "vl.pvadds.vsvl" => "__builtin_ve_vl_pvadds_vsvl",
                    "vl.pvadds.vsvvl" => "__builtin_ve_vl_pvadds_vsvvl",
                    "vl.pvadds.vvvMvl" => "__builtin_ve_vl_pvadds_vvvMvl",
                    "vl.pvadds.vvvl" => "__builtin_ve_vl_pvadds_vvvl",
                    "vl.pvadds.vvvvl" => "__builtin_ve_vl_pvadds_vvvvl",
                    "vl.pvaddu.vsvMvl" => "__builtin_ve_vl_pvaddu_vsvMvl",
                    "vl.pvaddu.vsvl" => "__builtin_ve_vl_pvaddu_vsvl",
                    "vl.pvaddu.vsvvl" => "__builtin_ve_vl_pvaddu_vsvvl",
                    "vl.pvaddu.vvvMvl" => "__builtin_ve_vl_pvaddu_vvvMvl",
                    "vl.pvaddu.vvvl" => "__builtin_ve_vl_pvaddu_vvvl",
                    "vl.pvaddu.vvvvl" => "__builtin_ve_vl_pvaddu_vvvvl",
                    "vl.pvand.vsvMvl" => "__builtin_ve_vl_pvand_vsvMvl",
                    "vl.pvand.vsvl" => "__builtin_ve_vl_pvand_vsvl",
                    "vl.pvand.vsvvl" => "__builtin_ve_vl_pvand_vsvvl",
                    "vl.pvand.vvvMvl" => "__builtin_ve_vl_pvand_vvvMvl",
                    "vl.pvand.vvvl" => "__builtin_ve_vl_pvand_vvvl",
                    "vl.pvand.vvvvl" => "__builtin_ve_vl_pvand_vvvvl",
                    "vl.pvbrd.vsMvl" => "__builtin_ve_vl_pvbrd_vsMvl",
                    "vl.pvbrd.vsl" => "__builtin_ve_vl_pvbrd_vsl",
                    "vl.pvbrd.vsvl" => "__builtin_ve_vl_pvbrd_vsvl",
                    "vl.pvbrv.vvMvl" => "__builtin_ve_vl_pvbrv_vvMvl",
                    "vl.pvbrv.vvl" => "__builtin_ve_vl_pvbrv_vvl",
                    "vl.pvbrv.vvvl" => "__builtin_ve_vl_pvbrv_vvvl",
                    "vl.pvbrvlo.vvl" => "__builtin_ve_vl_pvbrvlo_vvl",
                    "vl.pvbrvlo.vvmvl" => "__builtin_ve_vl_pvbrvlo_vvmvl",
                    "vl.pvbrvlo.vvvl" => "__builtin_ve_vl_pvbrvlo_vvvl",
                    "vl.pvbrvup.vvl" => "__builtin_ve_vl_pvbrvup_vvl",
                    "vl.pvbrvup.vvmvl" => "__builtin_ve_vl_pvbrvup_vvmvl",
                    "vl.pvbrvup.vvvl" => "__builtin_ve_vl_pvbrvup_vvvl",
                    "vl.pvcmps.vsvMvl" => "__builtin_ve_vl_pvcmps_vsvMvl",
                    "vl.pvcmps.vsvl" => "__builtin_ve_vl_pvcmps_vsvl",
                    "vl.pvcmps.vsvvl" => "__builtin_ve_vl_pvcmps_vsvvl",
                    "vl.pvcmps.vvvMvl" => "__builtin_ve_vl_pvcmps_vvvMvl",
                    "vl.pvcmps.vvvl" => "__builtin_ve_vl_pvcmps_vvvl",
                    "vl.pvcmps.vvvvl" => "__builtin_ve_vl_pvcmps_vvvvl",
                    "vl.pvcmpu.vsvMvl" => "__builtin_ve_vl_pvcmpu_vsvMvl",
                    "vl.pvcmpu.vsvl" => "__builtin_ve_vl_pvcmpu_vsvl",
                    "vl.pvcmpu.vsvvl" => "__builtin_ve_vl_pvcmpu_vsvvl",
                    "vl.pvcmpu.vvvMvl" => "__builtin_ve_vl_pvcmpu_vvvMvl",
                    "vl.pvcmpu.vvvl" => "__builtin_ve_vl_pvcmpu_vvvl",
                    "vl.pvcmpu.vvvvl" => "__builtin_ve_vl_pvcmpu_vvvvl",
                    "vl.pvcvtsw.vvl" => "__builtin_ve_vl_pvcvtsw_vvl",
                    "vl.pvcvtsw.vvvl" => "__builtin_ve_vl_pvcvtsw_vvvl",
                    "vl.pvcvtws.vvMvl" => "__builtin_ve_vl_pvcvtws_vvMvl",
                    "vl.pvcvtws.vvl" => "__builtin_ve_vl_pvcvtws_vvl",
                    "vl.pvcvtws.vvvl" => "__builtin_ve_vl_pvcvtws_vvvl",
                    "vl.pvcvtwsrz.vvMvl" => "__builtin_ve_vl_pvcvtwsrz_vvMvl",
                    "vl.pvcvtwsrz.vvl" => "__builtin_ve_vl_pvcvtwsrz_vvl",
                    "vl.pvcvtwsrz.vvvl" => "__builtin_ve_vl_pvcvtwsrz_vvvl",
                    "vl.pveqv.vsvMvl" => "__builtin_ve_vl_pveqv_vsvMvl",
                    "vl.pveqv.vsvl" => "__builtin_ve_vl_pveqv_vsvl",
                    "vl.pveqv.vsvvl" => "__builtin_ve_vl_pveqv_vsvvl",
                    "vl.pveqv.vvvMvl" => "__builtin_ve_vl_pveqv_vvvMvl",
                    "vl.pveqv.vvvl" => "__builtin_ve_vl_pveqv_vvvl",
                    "vl.pveqv.vvvvl" => "__builtin_ve_vl_pveqv_vvvvl",
                    "vl.pvfadd.vsvMvl" => "__builtin_ve_vl_pvfadd_vsvMvl",
                    "vl.pvfadd.vsvl" => "__builtin_ve_vl_pvfadd_vsvl",
                    "vl.pvfadd.vsvvl" => "__builtin_ve_vl_pvfadd_vsvvl",
                    "vl.pvfadd.vvvMvl" => "__builtin_ve_vl_pvfadd_vvvMvl",
                    "vl.pvfadd.vvvl" => "__builtin_ve_vl_pvfadd_vvvl",
                    "vl.pvfadd.vvvvl" => "__builtin_ve_vl_pvfadd_vvvvl",
                    "vl.pvfcmp.vsvMvl" => "__builtin_ve_vl_pvfcmp_vsvMvl",
                    "vl.pvfcmp.vsvl" => "__builtin_ve_vl_pvfcmp_vsvl",
                    "vl.pvfcmp.vsvvl" => "__builtin_ve_vl_pvfcmp_vsvvl",
                    "vl.pvfcmp.vvvMvl" => "__builtin_ve_vl_pvfcmp_vvvMvl",
                    "vl.pvfcmp.vvvl" => "__builtin_ve_vl_pvfcmp_vvvl",
                    "vl.pvfcmp.vvvvl" => "__builtin_ve_vl_pvfcmp_vvvvl",
                    "vl.pvfmad.vsvvMvl" => "__builtin_ve_vl_pvfmad_vsvvMvl",
                    "vl.pvfmad.vsvvl" => "__builtin_ve_vl_pvfmad_vsvvl",
                    "vl.pvfmad.vsvvvl" => "__builtin_ve_vl_pvfmad_vsvvvl",
                    "vl.pvfmad.vvsvMvl" => "__builtin_ve_vl_pvfmad_vvsvMvl",
                    "vl.pvfmad.vvsvl" => "__builtin_ve_vl_pvfmad_vvsvl",
                    "vl.pvfmad.vvsvvl" => "__builtin_ve_vl_pvfmad_vvsvvl",
                    "vl.pvfmad.vvvvMvl" => "__builtin_ve_vl_pvfmad_vvvvMvl",
                    "vl.pvfmad.vvvvl" => "__builtin_ve_vl_pvfmad_vvvvl",
                    "vl.pvfmad.vvvvvl" => "__builtin_ve_vl_pvfmad_vvvvvl",
                    "vl.pvfmax.vsvMvl" => "__builtin_ve_vl_pvfmax_vsvMvl",
                    "vl.pvfmax.vsvl" => "__builtin_ve_vl_pvfmax_vsvl",
                    "vl.pvfmax.vsvvl" => "__builtin_ve_vl_pvfmax_vsvvl",
                    "vl.pvfmax.vvvMvl" => "__builtin_ve_vl_pvfmax_vvvMvl",
                    "vl.pvfmax.vvvl" => "__builtin_ve_vl_pvfmax_vvvl",
                    "vl.pvfmax.vvvvl" => "__builtin_ve_vl_pvfmax_vvvvl",
                    "vl.pvfmin.vsvMvl" => "__builtin_ve_vl_pvfmin_vsvMvl",
                    "vl.pvfmin.vsvl" => "__builtin_ve_vl_pvfmin_vsvl",
                    "vl.pvfmin.vsvvl" => "__builtin_ve_vl_pvfmin_vsvvl",
                    "vl.pvfmin.vvvMvl" => "__builtin_ve_vl_pvfmin_vvvMvl",
                    "vl.pvfmin.vvvl" => "__builtin_ve_vl_pvfmin_vvvl",
                    "vl.pvfmin.vvvvl" => "__builtin_ve_vl_pvfmin_vvvvl",
                    "vl.pvfmkaf.Ml" => "__builtin_ve_vl_pvfmkaf_Ml",
                    "vl.pvfmkat.Ml" => "__builtin_ve_vl_pvfmkat_Ml",
                    "vl.pvfmkseq.MvMl" => "__builtin_ve_vl_pvfmkseq_MvMl",
                    "vl.pvfmkseq.Mvl" => "__builtin_ve_vl_pvfmkseq_Mvl",
                    "vl.pvfmkseqnan.MvMl" => "__builtin_ve_vl_pvfmkseqnan_MvMl",
                    "vl.pvfmkseqnan.Mvl" => "__builtin_ve_vl_pvfmkseqnan_Mvl",
                    "vl.pvfmksge.MvMl" => "__builtin_ve_vl_pvfmksge_MvMl",
                    "vl.pvfmksge.Mvl" => "__builtin_ve_vl_pvfmksge_Mvl",
                    "vl.pvfmksgenan.MvMl" => "__builtin_ve_vl_pvfmksgenan_MvMl",
                    "vl.pvfmksgenan.Mvl" => "__builtin_ve_vl_pvfmksgenan_Mvl",
                    "vl.pvfmksgt.MvMl" => "__builtin_ve_vl_pvfmksgt_MvMl",
                    "vl.pvfmksgt.Mvl" => "__builtin_ve_vl_pvfmksgt_Mvl",
                    "vl.pvfmksgtnan.MvMl" => "__builtin_ve_vl_pvfmksgtnan_MvMl",
                    "vl.pvfmksgtnan.Mvl" => "__builtin_ve_vl_pvfmksgtnan_Mvl",
                    "vl.pvfmksle.MvMl" => "__builtin_ve_vl_pvfmksle_MvMl",
                    "vl.pvfmksle.Mvl" => "__builtin_ve_vl_pvfmksle_Mvl",
                    "vl.pvfmkslenan.MvMl" => "__builtin_ve_vl_pvfmkslenan_MvMl",
                    "vl.pvfmkslenan.Mvl" => "__builtin_ve_vl_pvfmkslenan_Mvl",
                    "vl.pvfmksloeq.mvl" => "__builtin_ve_vl_pvfmksloeq_mvl",
                    "vl.pvfmksloeq.mvml" => "__builtin_ve_vl_pvfmksloeq_mvml",
                    "vl.pvfmksloeqnan.mvl" => "__builtin_ve_vl_pvfmksloeqnan_mvl",
                    "vl.pvfmksloeqnan.mvml" => "__builtin_ve_vl_pvfmksloeqnan_mvml",
                    "vl.pvfmksloge.mvl" => "__builtin_ve_vl_pvfmksloge_mvl",
                    "vl.pvfmksloge.mvml" => "__builtin_ve_vl_pvfmksloge_mvml",
                    "vl.pvfmkslogenan.mvl" => "__builtin_ve_vl_pvfmkslogenan_mvl",
                    "vl.pvfmkslogenan.mvml" => "__builtin_ve_vl_pvfmkslogenan_mvml",
                    "vl.pvfmkslogt.mvl" => "__builtin_ve_vl_pvfmkslogt_mvl",
                    "vl.pvfmkslogt.mvml" => "__builtin_ve_vl_pvfmkslogt_mvml",
                    "vl.pvfmkslogtnan.mvl" => "__builtin_ve_vl_pvfmkslogtnan_mvl",
                    "vl.pvfmkslogtnan.mvml" => "__builtin_ve_vl_pvfmkslogtnan_mvml",
                    "vl.pvfmkslole.mvl" => "__builtin_ve_vl_pvfmkslole_mvl",
                    "vl.pvfmkslole.mvml" => "__builtin_ve_vl_pvfmkslole_mvml",
                    "vl.pvfmkslolenan.mvl" => "__builtin_ve_vl_pvfmkslolenan_mvl",
                    "vl.pvfmkslolenan.mvml" => "__builtin_ve_vl_pvfmkslolenan_mvml",
                    "vl.pvfmkslolt.mvl" => "__builtin_ve_vl_pvfmkslolt_mvl",
                    "vl.pvfmkslolt.mvml" => "__builtin_ve_vl_pvfmkslolt_mvml",
                    "vl.pvfmksloltnan.mvl" => "__builtin_ve_vl_pvfmksloltnan_mvl",
                    "vl.pvfmksloltnan.mvml" => "__builtin_ve_vl_pvfmksloltnan_mvml",
                    "vl.pvfmkslonan.mvl" => "__builtin_ve_vl_pvfmkslonan_mvl",
                    "vl.pvfmkslonan.mvml" => "__builtin_ve_vl_pvfmkslonan_mvml",
                    "vl.pvfmkslone.mvl" => "__builtin_ve_vl_pvfmkslone_mvl",
                    "vl.pvfmkslone.mvml" => "__builtin_ve_vl_pvfmkslone_mvml",
                    "vl.pvfmkslonenan.mvl" => "__builtin_ve_vl_pvfmkslonenan_mvl",
                    "vl.pvfmkslonenan.mvml" => "__builtin_ve_vl_pvfmkslonenan_mvml",
                    "vl.pvfmkslonum.mvl" => "__builtin_ve_vl_pvfmkslonum_mvl",
                    "vl.pvfmkslonum.mvml" => "__builtin_ve_vl_pvfmkslonum_mvml",
                    "vl.pvfmkslt.MvMl" => "__builtin_ve_vl_pvfmkslt_MvMl",
                    "vl.pvfmkslt.Mvl" => "__builtin_ve_vl_pvfmkslt_Mvl",
                    "vl.pvfmksltnan.MvMl" => "__builtin_ve_vl_pvfmksltnan_MvMl",
                    "vl.pvfmksltnan.Mvl" => "__builtin_ve_vl_pvfmksltnan_Mvl",
                    "vl.pvfmksnan.MvMl" => "__builtin_ve_vl_pvfmksnan_MvMl",
                    "vl.pvfmksnan.Mvl" => "__builtin_ve_vl_pvfmksnan_Mvl",
                    "vl.pvfmksne.MvMl" => "__builtin_ve_vl_pvfmksne_MvMl",
                    "vl.pvfmksne.Mvl" => "__builtin_ve_vl_pvfmksne_Mvl",
                    "vl.pvfmksnenan.MvMl" => "__builtin_ve_vl_pvfmksnenan_MvMl",
                    "vl.pvfmksnenan.Mvl" => "__builtin_ve_vl_pvfmksnenan_Mvl",
                    "vl.pvfmksnum.MvMl" => "__builtin_ve_vl_pvfmksnum_MvMl",
                    "vl.pvfmksnum.Mvl" => "__builtin_ve_vl_pvfmksnum_Mvl",
                    "vl.pvfmksupeq.mvl" => "__builtin_ve_vl_pvfmksupeq_mvl",
                    "vl.pvfmksupeq.mvml" => "__builtin_ve_vl_pvfmksupeq_mvml",
                    "vl.pvfmksupeqnan.mvl" => "__builtin_ve_vl_pvfmksupeqnan_mvl",
                    "vl.pvfmksupeqnan.mvml" => "__builtin_ve_vl_pvfmksupeqnan_mvml",
                    "vl.pvfmksupge.mvl" => "__builtin_ve_vl_pvfmksupge_mvl",
                    "vl.pvfmksupge.mvml" => "__builtin_ve_vl_pvfmksupge_mvml",
                    "vl.pvfmksupgenan.mvl" => "__builtin_ve_vl_pvfmksupgenan_mvl",
                    "vl.pvfmksupgenan.mvml" => "__builtin_ve_vl_pvfmksupgenan_mvml",
                    "vl.pvfmksupgt.mvl" => "__builtin_ve_vl_pvfmksupgt_mvl",
                    "vl.pvfmksupgt.mvml" => "__builtin_ve_vl_pvfmksupgt_mvml",
                    "vl.pvfmksupgtnan.mvl" => "__builtin_ve_vl_pvfmksupgtnan_mvl",
                    "vl.pvfmksupgtnan.mvml" => "__builtin_ve_vl_pvfmksupgtnan_mvml",
                    "vl.pvfmksuple.mvl" => "__builtin_ve_vl_pvfmksuple_mvl",
                    "vl.pvfmksuple.mvml" => "__builtin_ve_vl_pvfmksuple_mvml",
                    "vl.pvfmksuplenan.mvl" => "__builtin_ve_vl_pvfmksuplenan_mvl",
                    "vl.pvfmksuplenan.mvml" => "__builtin_ve_vl_pvfmksuplenan_mvml",
                    "vl.pvfmksuplt.mvl" => "__builtin_ve_vl_pvfmksuplt_mvl",
                    "vl.pvfmksuplt.mvml" => "__builtin_ve_vl_pvfmksuplt_mvml",
                    "vl.pvfmksupltnan.mvl" => "__builtin_ve_vl_pvfmksupltnan_mvl",
                    "vl.pvfmksupltnan.mvml" => "__builtin_ve_vl_pvfmksupltnan_mvml",
                    "vl.pvfmksupnan.mvl" => "__builtin_ve_vl_pvfmksupnan_mvl",
                    "vl.pvfmksupnan.mvml" => "__builtin_ve_vl_pvfmksupnan_mvml",
                    "vl.pvfmksupne.mvl" => "__builtin_ve_vl_pvfmksupne_mvl",
                    "vl.pvfmksupne.mvml" => "__builtin_ve_vl_pvfmksupne_mvml",
                    "vl.pvfmksupnenan.mvl" => "__builtin_ve_vl_pvfmksupnenan_mvl",
                    "vl.pvfmksupnenan.mvml" => "__builtin_ve_vl_pvfmksupnenan_mvml",
                    "vl.pvfmksupnum.mvl" => "__builtin_ve_vl_pvfmksupnum_mvl",
                    "vl.pvfmksupnum.mvml" => "__builtin_ve_vl_pvfmksupnum_mvml",
                    "vl.pvfmkweq.MvMl" => "__builtin_ve_vl_pvfmkweq_MvMl",
                    "vl.pvfmkweq.Mvl" => "__builtin_ve_vl_pvfmkweq_Mvl",
                    "vl.pvfmkweqnan.MvMl" => "__builtin_ve_vl_pvfmkweqnan_MvMl",
                    "vl.pvfmkweqnan.Mvl" => "__builtin_ve_vl_pvfmkweqnan_Mvl",
                    "vl.pvfmkwge.MvMl" => "__builtin_ve_vl_pvfmkwge_MvMl",
                    "vl.pvfmkwge.Mvl" => "__builtin_ve_vl_pvfmkwge_Mvl",
                    "vl.pvfmkwgenan.MvMl" => "__builtin_ve_vl_pvfmkwgenan_MvMl",
                    "vl.pvfmkwgenan.Mvl" => "__builtin_ve_vl_pvfmkwgenan_Mvl",
                    "vl.pvfmkwgt.MvMl" => "__builtin_ve_vl_pvfmkwgt_MvMl",
                    "vl.pvfmkwgt.Mvl" => "__builtin_ve_vl_pvfmkwgt_Mvl",
                    "vl.pvfmkwgtnan.MvMl" => "__builtin_ve_vl_pvfmkwgtnan_MvMl",
                    "vl.pvfmkwgtnan.Mvl" => "__builtin_ve_vl_pvfmkwgtnan_Mvl",
                    "vl.pvfmkwle.MvMl" => "__builtin_ve_vl_pvfmkwle_MvMl",
                    "vl.pvfmkwle.Mvl" => "__builtin_ve_vl_pvfmkwle_Mvl",
                    "vl.pvfmkwlenan.MvMl" => "__builtin_ve_vl_pvfmkwlenan_MvMl",
                    "vl.pvfmkwlenan.Mvl" => "__builtin_ve_vl_pvfmkwlenan_Mvl",
                    "vl.pvfmkwloeq.mvl" => "__builtin_ve_vl_pvfmkwloeq_mvl",
                    "vl.pvfmkwloeq.mvml" => "__builtin_ve_vl_pvfmkwloeq_mvml",
                    "vl.pvfmkwloeqnan.mvl" => "__builtin_ve_vl_pvfmkwloeqnan_mvl",
                    "vl.pvfmkwloeqnan.mvml" => "__builtin_ve_vl_pvfmkwloeqnan_mvml",
                    "vl.pvfmkwloge.mvl" => "__builtin_ve_vl_pvfmkwloge_mvl",
                    "vl.pvfmkwloge.mvml" => "__builtin_ve_vl_pvfmkwloge_mvml",
                    "vl.pvfmkwlogenan.mvl" => "__builtin_ve_vl_pvfmkwlogenan_mvl",
                    "vl.pvfmkwlogenan.mvml" => "__builtin_ve_vl_pvfmkwlogenan_mvml",
                    "vl.pvfmkwlogt.mvl" => "__builtin_ve_vl_pvfmkwlogt_mvl",
                    "vl.pvfmkwlogt.mvml" => "__builtin_ve_vl_pvfmkwlogt_mvml",
                    "vl.pvfmkwlogtnan.mvl" => "__builtin_ve_vl_pvfmkwlogtnan_mvl",
                    "vl.pvfmkwlogtnan.mvml" => "__builtin_ve_vl_pvfmkwlogtnan_mvml",
                    "vl.pvfmkwlole.mvl" => "__builtin_ve_vl_pvfmkwlole_mvl",
                    "vl.pvfmkwlole.mvml" => "__builtin_ve_vl_pvfmkwlole_mvml",
                    "vl.pvfmkwlolenan.mvl" => "__builtin_ve_vl_pvfmkwlolenan_mvl",
                    "vl.pvfmkwlolenan.mvml" => "__builtin_ve_vl_pvfmkwlolenan_mvml",
                    "vl.pvfmkwlolt.mvl" => "__builtin_ve_vl_pvfmkwlolt_mvl",
                    "vl.pvfmkwlolt.mvml" => "__builtin_ve_vl_pvfmkwlolt_mvml",
                    "vl.pvfmkwloltnan.mvl" => "__builtin_ve_vl_pvfmkwloltnan_mvl",
                    "vl.pvfmkwloltnan.mvml" => "__builtin_ve_vl_pvfmkwloltnan_mvml",
                    "vl.pvfmkwlonan.mvl" => "__builtin_ve_vl_pvfmkwlonan_mvl",
                    "vl.pvfmkwlonan.mvml" => "__builtin_ve_vl_pvfmkwlonan_mvml",
                    "vl.pvfmkwlone.mvl" => "__builtin_ve_vl_pvfmkwlone_mvl",
                    "vl.pvfmkwlone.mvml" => "__builtin_ve_vl_pvfmkwlone_mvml",
                    "vl.pvfmkwlonenan.mvl" => "__builtin_ve_vl_pvfmkwlonenan_mvl",
                    "vl.pvfmkwlonenan.mvml" => "__builtin_ve_vl_pvfmkwlonenan_mvml",
                    "vl.pvfmkwlonum.mvl" => "__builtin_ve_vl_pvfmkwlonum_mvl",
                    "vl.pvfmkwlonum.mvml" => "__builtin_ve_vl_pvfmkwlonum_mvml",
                    "vl.pvfmkwlt.MvMl" => "__builtin_ve_vl_pvfmkwlt_MvMl",
                    "vl.pvfmkwlt.Mvl" => "__builtin_ve_vl_pvfmkwlt_Mvl",
                    "vl.pvfmkwltnan.MvMl" => "__builtin_ve_vl_pvfmkwltnan_MvMl",
                    "vl.pvfmkwltnan.Mvl" => "__builtin_ve_vl_pvfmkwltnan_Mvl",
                    "vl.pvfmkwnan.MvMl" => "__builtin_ve_vl_pvfmkwnan_MvMl",
                    "vl.pvfmkwnan.Mvl" => "__builtin_ve_vl_pvfmkwnan_Mvl",
                    "vl.pvfmkwne.MvMl" => "__builtin_ve_vl_pvfmkwne_MvMl",
                    "vl.pvfmkwne.Mvl" => "__builtin_ve_vl_pvfmkwne_Mvl",
                    "vl.pvfmkwnenan.MvMl" => "__builtin_ve_vl_pvfmkwnenan_MvMl",
                    "vl.pvfmkwnenan.Mvl" => "__builtin_ve_vl_pvfmkwnenan_Mvl",
                    "vl.pvfmkwnum.MvMl" => "__builtin_ve_vl_pvfmkwnum_MvMl",
                    "vl.pvfmkwnum.Mvl" => "__builtin_ve_vl_pvfmkwnum_Mvl",
                    "vl.pvfmkwupeq.mvl" => "__builtin_ve_vl_pvfmkwupeq_mvl",
                    "vl.pvfmkwupeq.mvml" => "__builtin_ve_vl_pvfmkwupeq_mvml",
                    "vl.pvfmkwupeqnan.mvl" => "__builtin_ve_vl_pvfmkwupeqnan_mvl",
                    "vl.pvfmkwupeqnan.mvml" => "__builtin_ve_vl_pvfmkwupeqnan_mvml",
                    "vl.pvfmkwupge.mvl" => "__builtin_ve_vl_pvfmkwupge_mvl",
                    "vl.pvfmkwupge.mvml" => "__builtin_ve_vl_pvfmkwupge_mvml",
                    "vl.pvfmkwupgenan.mvl" => "__builtin_ve_vl_pvfmkwupgenan_mvl",
                    "vl.pvfmkwupgenan.mvml" => "__builtin_ve_vl_pvfmkwupgenan_mvml",
                    "vl.pvfmkwupgt.mvl" => "__builtin_ve_vl_pvfmkwupgt_mvl",
                    "vl.pvfmkwupgt.mvml" => "__builtin_ve_vl_pvfmkwupgt_mvml",
                    "vl.pvfmkwupgtnan.mvl" => "__builtin_ve_vl_pvfmkwupgtnan_mvl",
                    "vl.pvfmkwupgtnan.mvml" => "__builtin_ve_vl_pvfmkwupgtnan_mvml",
                    "vl.pvfmkwuple.mvl" => "__builtin_ve_vl_pvfmkwuple_mvl",
                    "vl.pvfmkwuple.mvml" => "__builtin_ve_vl_pvfmkwuple_mvml",
                    "vl.pvfmkwuplenan.mvl" => "__builtin_ve_vl_pvfmkwuplenan_mvl",
                    "vl.pvfmkwuplenan.mvml" => "__builtin_ve_vl_pvfmkwuplenan_mvml",
                    "vl.pvfmkwuplt.mvl" => "__builtin_ve_vl_pvfmkwuplt_mvl",
                    "vl.pvfmkwuplt.mvml" => "__builtin_ve_vl_pvfmkwuplt_mvml",
                    "vl.pvfmkwupltnan.mvl" => "__builtin_ve_vl_pvfmkwupltnan_mvl",
                    "vl.pvfmkwupltnan.mvml" => "__builtin_ve_vl_pvfmkwupltnan_mvml",
                    "vl.pvfmkwupnan.mvl" => "__builtin_ve_vl_pvfmkwupnan_mvl",
                    "vl.pvfmkwupnan.mvml" => "__builtin_ve_vl_pvfmkwupnan_mvml",
                    "vl.pvfmkwupne.mvl" => "__builtin_ve_vl_pvfmkwupne_mvl",
                    "vl.pvfmkwupne.mvml" => "__builtin_ve_vl_pvfmkwupne_mvml",
                    "vl.pvfmkwupnenan.mvl" => "__builtin_ve_vl_pvfmkwupnenan_mvl",
                    "vl.pvfmkwupnenan.mvml" => "__builtin_ve_vl_pvfmkwupnenan_mvml",
                    "vl.pvfmkwupnum.mvl" => "__builtin_ve_vl_pvfmkwupnum_mvl",
                    "vl.pvfmkwupnum.mvml" => "__builtin_ve_vl_pvfmkwupnum_mvml",
                    "vl.pvfmsb.vsvvMvl" => "__builtin_ve_vl_pvfmsb_vsvvMvl",
                    "vl.pvfmsb.vsvvl" => "__builtin_ve_vl_pvfmsb_vsvvl",
                    "vl.pvfmsb.vsvvvl" => "__builtin_ve_vl_pvfmsb_vsvvvl",
                    "vl.pvfmsb.vvsvMvl" => "__builtin_ve_vl_pvfmsb_vvsvMvl",
                    "vl.pvfmsb.vvsvl" => "__builtin_ve_vl_pvfmsb_vvsvl",
                    "vl.pvfmsb.vvsvvl" => "__builtin_ve_vl_pvfmsb_vvsvvl",
                    "vl.pvfmsb.vvvvMvl" => "__builtin_ve_vl_pvfmsb_vvvvMvl",
                    "vl.pvfmsb.vvvvl" => "__builtin_ve_vl_pvfmsb_vvvvl",
                    "vl.pvfmsb.vvvvvl" => "__builtin_ve_vl_pvfmsb_vvvvvl",
                    "vl.pvfmul.vsvMvl" => "__builtin_ve_vl_pvfmul_vsvMvl",
                    "vl.pvfmul.vsvl" => "__builtin_ve_vl_pvfmul_vsvl",
                    "vl.pvfmul.vsvvl" => "__builtin_ve_vl_pvfmul_vsvvl",
                    "vl.pvfmul.vvvMvl" => "__builtin_ve_vl_pvfmul_vvvMvl",
                    "vl.pvfmul.vvvl" => "__builtin_ve_vl_pvfmul_vvvl",
                    "vl.pvfmul.vvvvl" => "__builtin_ve_vl_pvfmul_vvvvl",
                    "vl.pvfnmad.vsvvMvl" => "__builtin_ve_vl_pvfnmad_vsvvMvl",
                    "vl.pvfnmad.vsvvl" => "__builtin_ve_vl_pvfnmad_vsvvl",
                    "vl.pvfnmad.vsvvvl" => "__builtin_ve_vl_pvfnmad_vsvvvl",
                    "vl.pvfnmad.vvsvMvl" => "__builtin_ve_vl_pvfnmad_vvsvMvl",
                    "vl.pvfnmad.vvsvl" => "__builtin_ve_vl_pvfnmad_vvsvl",
                    "vl.pvfnmad.vvsvvl" => "__builtin_ve_vl_pvfnmad_vvsvvl",
                    "vl.pvfnmad.vvvvMvl" => "__builtin_ve_vl_pvfnmad_vvvvMvl",
                    "vl.pvfnmad.vvvvl" => "__builtin_ve_vl_pvfnmad_vvvvl",
                    "vl.pvfnmad.vvvvvl" => "__builtin_ve_vl_pvfnmad_vvvvvl",
                    "vl.pvfnmsb.vsvvMvl" => "__builtin_ve_vl_pvfnmsb_vsvvMvl",
                    "vl.pvfnmsb.vsvvl" => "__builtin_ve_vl_pvfnmsb_vsvvl",
                    "vl.pvfnmsb.vsvvvl" => "__builtin_ve_vl_pvfnmsb_vsvvvl",
                    "vl.pvfnmsb.vvsvMvl" => "__builtin_ve_vl_pvfnmsb_vvsvMvl",
                    "vl.pvfnmsb.vvsvl" => "__builtin_ve_vl_pvfnmsb_vvsvl",
                    "vl.pvfnmsb.vvsvvl" => "__builtin_ve_vl_pvfnmsb_vvsvvl",
                    "vl.pvfnmsb.vvvvMvl" => "__builtin_ve_vl_pvfnmsb_vvvvMvl",
                    "vl.pvfnmsb.vvvvl" => "__builtin_ve_vl_pvfnmsb_vvvvl",
                    "vl.pvfnmsb.vvvvvl" => "__builtin_ve_vl_pvfnmsb_vvvvvl",
                    "vl.pvfsub.vsvMvl" => "__builtin_ve_vl_pvfsub_vsvMvl",
                    "vl.pvfsub.vsvl" => "__builtin_ve_vl_pvfsub_vsvl",
                    "vl.pvfsub.vsvvl" => "__builtin_ve_vl_pvfsub_vsvvl",
                    "vl.pvfsub.vvvMvl" => "__builtin_ve_vl_pvfsub_vvvMvl",
                    "vl.pvfsub.vvvl" => "__builtin_ve_vl_pvfsub_vvvl",
                    "vl.pvfsub.vvvvl" => "__builtin_ve_vl_pvfsub_vvvvl",
                    "vl.pvldz.vvMvl" => "__builtin_ve_vl_pvldz_vvMvl",
                    "vl.pvldz.vvl" => "__builtin_ve_vl_pvldz_vvl",
                    "vl.pvldz.vvvl" => "__builtin_ve_vl_pvldz_vvvl",
                    "vl.pvldzlo.vvl" => "__builtin_ve_vl_pvldzlo_vvl",
                    "vl.pvldzlo.vvmvl" => "__builtin_ve_vl_pvldzlo_vvmvl",
                    "vl.pvldzlo.vvvl" => "__builtin_ve_vl_pvldzlo_vvvl",
                    "vl.pvldzup.vvl" => "__builtin_ve_vl_pvldzup_vvl",
                    "vl.pvldzup.vvmvl" => "__builtin_ve_vl_pvldzup_vvmvl",
                    "vl.pvldzup.vvvl" => "__builtin_ve_vl_pvldzup_vvvl",
                    "vl.pvmaxs.vsvMvl" => "__builtin_ve_vl_pvmaxs_vsvMvl",
                    "vl.pvmaxs.vsvl" => "__builtin_ve_vl_pvmaxs_vsvl",
                    "vl.pvmaxs.vsvvl" => "__builtin_ve_vl_pvmaxs_vsvvl",
                    "vl.pvmaxs.vvvMvl" => "__builtin_ve_vl_pvmaxs_vvvMvl",
                    "vl.pvmaxs.vvvl" => "__builtin_ve_vl_pvmaxs_vvvl",
                    "vl.pvmaxs.vvvvl" => "__builtin_ve_vl_pvmaxs_vvvvl",
                    "vl.pvmins.vsvMvl" => "__builtin_ve_vl_pvmins_vsvMvl",
                    "vl.pvmins.vsvl" => "__builtin_ve_vl_pvmins_vsvl",
                    "vl.pvmins.vsvvl" => "__builtin_ve_vl_pvmins_vsvvl",
                    "vl.pvmins.vvvMvl" => "__builtin_ve_vl_pvmins_vvvMvl",
                    "vl.pvmins.vvvl" => "__builtin_ve_vl_pvmins_vvvl",
                    "vl.pvmins.vvvvl" => "__builtin_ve_vl_pvmins_vvvvl",
                    "vl.pvor.vsvMvl" => "__builtin_ve_vl_pvor_vsvMvl",
                    "vl.pvor.vsvl" => "__builtin_ve_vl_pvor_vsvl",
                    "vl.pvor.vsvvl" => "__builtin_ve_vl_pvor_vsvvl",
                    "vl.pvor.vvvMvl" => "__builtin_ve_vl_pvor_vvvMvl",
                    "vl.pvor.vvvl" => "__builtin_ve_vl_pvor_vvvl",
                    "vl.pvor.vvvvl" => "__builtin_ve_vl_pvor_vvvvl",
                    "vl.pvpcnt.vvMvl" => "__builtin_ve_vl_pvpcnt_vvMvl",
                    "vl.pvpcnt.vvl" => "__builtin_ve_vl_pvpcnt_vvl",
                    "vl.pvpcnt.vvvl" => "__builtin_ve_vl_pvpcnt_vvvl",
                    "vl.pvpcntlo.vvl" => "__builtin_ve_vl_pvpcntlo_vvl",
                    "vl.pvpcntlo.vvmvl" => "__builtin_ve_vl_pvpcntlo_vvmvl",
                    "vl.pvpcntlo.vvvl" => "__builtin_ve_vl_pvpcntlo_vvvl",
                    "vl.pvpcntup.vvl" => "__builtin_ve_vl_pvpcntup_vvl",
                    "vl.pvpcntup.vvmvl" => "__builtin_ve_vl_pvpcntup_vvmvl",
                    "vl.pvpcntup.vvvl" => "__builtin_ve_vl_pvpcntup_vvvl",
                    "vl.pvrcp.vvl" => "__builtin_ve_vl_pvrcp_vvl",
                    "vl.pvrcp.vvvl" => "__builtin_ve_vl_pvrcp_vvvl",
                    "vl.pvrsqrt.vvl" => "__builtin_ve_vl_pvrsqrt_vvl",
                    "vl.pvrsqrt.vvvl" => "__builtin_ve_vl_pvrsqrt_vvvl",
                    "vl.pvrsqrtnex.vvl" => "__builtin_ve_vl_pvrsqrtnex_vvl",
                    "vl.pvrsqrtnex.vvvl" => "__builtin_ve_vl_pvrsqrtnex_vvvl",
                    "vl.pvseq.vl" => "__builtin_ve_vl_pvseq_vl",
                    "vl.pvseq.vvl" => "__builtin_ve_vl_pvseq_vvl",
                    "vl.pvseqlo.vl" => "__builtin_ve_vl_pvseqlo_vl",
                    "vl.pvseqlo.vvl" => "__builtin_ve_vl_pvseqlo_vvl",
                    "vl.pvsequp.vl" => "__builtin_ve_vl_pvsequp_vl",
                    "vl.pvsequp.vvl" => "__builtin_ve_vl_pvsequp_vvl",
                    "vl.pvsla.vvsMvl" => "__builtin_ve_vl_pvsla_vvsMvl",
                    "vl.pvsla.vvsl" => "__builtin_ve_vl_pvsla_vvsl",
                    "vl.pvsla.vvsvl" => "__builtin_ve_vl_pvsla_vvsvl",
                    "vl.pvsla.vvvMvl" => "__builtin_ve_vl_pvsla_vvvMvl",
                    "vl.pvsla.vvvl" => "__builtin_ve_vl_pvsla_vvvl",
                    "vl.pvsla.vvvvl" => "__builtin_ve_vl_pvsla_vvvvl",
                    "vl.pvsll.vvsMvl" => "__builtin_ve_vl_pvsll_vvsMvl",
                    "vl.pvsll.vvsl" => "__builtin_ve_vl_pvsll_vvsl",
                    "vl.pvsll.vvsvl" => "__builtin_ve_vl_pvsll_vvsvl",
                    "vl.pvsll.vvvMvl" => "__builtin_ve_vl_pvsll_vvvMvl",
                    "vl.pvsll.vvvl" => "__builtin_ve_vl_pvsll_vvvl",
                    "vl.pvsll.vvvvl" => "__builtin_ve_vl_pvsll_vvvvl",
                    "vl.pvsra.vvsMvl" => "__builtin_ve_vl_pvsra_vvsMvl",
                    "vl.pvsra.vvsl" => "__builtin_ve_vl_pvsra_vvsl",
                    "vl.pvsra.vvsvl" => "__builtin_ve_vl_pvsra_vvsvl",
                    "vl.pvsra.vvvMvl" => "__builtin_ve_vl_pvsra_vvvMvl",
                    "vl.pvsra.vvvl" => "__builtin_ve_vl_pvsra_vvvl",
                    "vl.pvsra.vvvvl" => "__builtin_ve_vl_pvsra_vvvvl",
                    "vl.pvsrl.vvsMvl" => "__builtin_ve_vl_pvsrl_vvsMvl",
                    "vl.pvsrl.vvsl" => "__builtin_ve_vl_pvsrl_vvsl",
                    "vl.pvsrl.vvsvl" => "__builtin_ve_vl_pvsrl_vvsvl",
                    "vl.pvsrl.vvvMvl" => "__builtin_ve_vl_pvsrl_vvvMvl",
                    "vl.pvsrl.vvvl" => "__builtin_ve_vl_pvsrl_vvvl",
                    "vl.pvsrl.vvvvl" => "__builtin_ve_vl_pvsrl_vvvvl",
                    "vl.pvsubs.vsvMvl" => "__builtin_ve_vl_pvsubs_vsvMvl",
                    "vl.pvsubs.vsvl" => "__builtin_ve_vl_pvsubs_vsvl",
                    "vl.pvsubs.vsvvl" => "__builtin_ve_vl_pvsubs_vsvvl",
                    "vl.pvsubs.vvvMvl" => "__builtin_ve_vl_pvsubs_vvvMvl",
                    "vl.pvsubs.vvvl" => "__builtin_ve_vl_pvsubs_vvvl",
                    "vl.pvsubs.vvvvl" => "__builtin_ve_vl_pvsubs_vvvvl",
                    "vl.pvsubu.vsvMvl" => "__builtin_ve_vl_pvsubu_vsvMvl",
                    "vl.pvsubu.vsvl" => "__builtin_ve_vl_pvsubu_vsvl",
                    "vl.pvsubu.vsvvl" => "__builtin_ve_vl_pvsubu_vsvvl",
                    "vl.pvsubu.vvvMvl" => "__builtin_ve_vl_pvsubu_vvvMvl",
                    "vl.pvsubu.vvvl" => "__builtin_ve_vl_pvsubu_vvvl",
                    "vl.pvsubu.vvvvl" => "__builtin_ve_vl_pvsubu_vvvvl",
                    "vl.pvxor.vsvMvl" => "__builtin_ve_vl_pvxor_vsvMvl",
                    "vl.pvxor.vsvl" => "__builtin_ve_vl_pvxor_vsvl",
                    "vl.pvxor.vsvvl" => "__builtin_ve_vl_pvxor_vsvvl",
                    "vl.pvxor.vvvMvl" => "__builtin_ve_vl_pvxor_vvvMvl",
                    "vl.pvxor.vvvl" => "__builtin_ve_vl_pvxor_vvvl",
                    "vl.pvxor.vvvvl" => "__builtin_ve_vl_pvxor_vvvvl",
                    "vl.scr.sss" => "__builtin_ve_vl_scr_sss",
                    "vl.svm.sMs" => "__builtin_ve_vl_svm_sMs",
                    "vl.svm.sms" => "__builtin_ve_vl_svm_sms",
                    "vl.svob" => "__builtin_ve_vl_svob",
                    "vl.tovm.sml" => "__builtin_ve_vl_tovm_sml",
                    "vl.tscr.ssss" => "__builtin_ve_vl_tscr_ssss",
                    "vl.vaddsl.vsvl" => "__builtin_ve_vl_vaddsl_vsvl",
                    "vl.vaddsl.vsvmvl" => "__builtin_ve_vl_vaddsl_vsvmvl",
                    "vl.vaddsl.vsvvl" => "__builtin_ve_vl_vaddsl_vsvvl",
                    "vl.vaddsl.vvvl" => "__builtin_ve_vl_vaddsl_vvvl",
                    "vl.vaddsl.vvvmvl" => "__builtin_ve_vl_vaddsl_vvvmvl",
                    "vl.vaddsl.vvvvl" => "__builtin_ve_vl_vaddsl_vvvvl",
                    "vl.vaddswsx.vsvl" => "__builtin_ve_vl_vaddswsx_vsvl",
                    "vl.vaddswsx.vsvmvl" => "__builtin_ve_vl_vaddswsx_vsvmvl",
                    "vl.vaddswsx.vsvvl" => "__builtin_ve_vl_vaddswsx_vsvvl",
                    "vl.vaddswsx.vvvl" => "__builtin_ve_vl_vaddswsx_vvvl",
                    "vl.vaddswsx.vvvmvl" => "__builtin_ve_vl_vaddswsx_vvvmvl",
                    "vl.vaddswsx.vvvvl" => "__builtin_ve_vl_vaddswsx_vvvvl",
                    "vl.vaddswzx.vsvl" => "__builtin_ve_vl_vaddswzx_vsvl",
                    "vl.vaddswzx.vsvmvl" => "__builtin_ve_vl_vaddswzx_vsvmvl",
                    "vl.vaddswzx.vsvvl" => "__builtin_ve_vl_vaddswzx_vsvvl",
                    "vl.vaddswzx.vvvl" => "__builtin_ve_vl_vaddswzx_vvvl",
                    "vl.vaddswzx.vvvmvl" => "__builtin_ve_vl_vaddswzx_vvvmvl",
                    "vl.vaddswzx.vvvvl" => "__builtin_ve_vl_vaddswzx_vvvvl",
                    "vl.vaddul.vsvl" => "__builtin_ve_vl_vaddul_vsvl",
                    "vl.vaddul.vsvmvl" => "__builtin_ve_vl_vaddul_vsvmvl",
                    "vl.vaddul.vsvvl" => "__builtin_ve_vl_vaddul_vsvvl",
                    "vl.vaddul.vvvl" => "__builtin_ve_vl_vaddul_vvvl",
                    "vl.vaddul.vvvmvl" => "__builtin_ve_vl_vaddul_vvvmvl",
                    "vl.vaddul.vvvvl" => "__builtin_ve_vl_vaddul_vvvvl",
                    "vl.vadduw.vsvl" => "__builtin_ve_vl_vadduw_vsvl",
                    "vl.vadduw.vsvmvl" => "__builtin_ve_vl_vadduw_vsvmvl",
                    "vl.vadduw.vsvvl" => "__builtin_ve_vl_vadduw_vsvvl",
                    "vl.vadduw.vvvl" => "__builtin_ve_vl_vadduw_vvvl",
                    "vl.vadduw.vvvmvl" => "__builtin_ve_vl_vadduw_vvvmvl",
                    "vl.vadduw.vvvvl" => "__builtin_ve_vl_vadduw_vvvvl",
                    "vl.vand.vsvl" => "__builtin_ve_vl_vand_vsvl",
                    "vl.vand.vsvmvl" => "__builtin_ve_vl_vand_vsvmvl",
                    "vl.vand.vsvvl" => "__builtin_ve_vl_vand_vsvvl",
                    "vl.vand.vvvl" => "__builtin_ve_vl_vand_vvvl",
                    "vl.vand.vvvmvl" => "__builtin_ve_vl_vand_vvvmvl",
                    "vl.vand.vvvvl" => "__builtin_ve_vl_vand_vvvvl",
                    "vl.vbrdd.vsl" => "__builtin_ve_vl_vbrdd_vsl",
                    "vl.vbrdd.vsmvl" => "__builtin_ve_vl_vbrdd_vsmvl",
                    "vl.vbrdd.vsvl" => "__builtin_ve_vl_vbrdd_vsvl",
                    "vl.vbrdl.vsl" => "__builtin_ve_vl_vbrdl_vsl",
                    "vl.vbrdl.vsmvl" => "__builtin_ve_vl_vbrdl_vsmvl",
                    "vl.vbrdl.vsvl" => "__builtin_ve_vl_vbrdl_vsvl",
                    "vl.vbrds.vsl" => "__builtin_ve_vl_vbrds_vsl",
                    "vl.vbrds.vsmvl" => "__builtin_ve_vl_vbrds_vsmvl",
                    "vl.vbrds.vsvl" => "__builtin_ve_vl_vbrds_vsvl",
                    "vl.vbrdw.vsl" => "__builtin_ve_vl_vbrdw_vsl",
                    "vl.vbrdw.vsmvl" => "__builtin_ve_vl_vbrdw_vsmvl",
                    "vl.vbrdw.vsvl" => "__builtin_ve_vl_vbrdw_vsvl",
                    "vl.vbrv.vvl" => "__builtin_ve_vl_vbrv_vvl",
                    "vl.vbrv.vvmvl" => "__builtin_ve_vl_vbrv_vvmvl",
                    "vl.vbrv.vvvl" => "__builtin_ve_vl_vbrv_vvvl",
                    "vl.vcmpsl.vsvl" => "__builtin_ve_vl_vcmpsl_vsvl",
                    "vl.vcmpsl.vsvmvl" => "__builtin_ve_vl_vcmpsl_vsvmvl",
                    "vl.vcmpsl.vsvvl" => "__builtin_ve_vl_vcmpsl_vsvvl",
                    "vl.vcmpsl.vvvl" => "__builtin_ve_vl_vcmpsl_vvvl",
                    "vl.vcmpsl.vvvmvl" => "__builtin_ve_vl_vcmpsl_vvvmvl",
                    "vl.vcmpsl.vvvvl" => "__builtin_ve_vl_vcmpsl_vvvvl",
                    "vl.vcmpswsx.vsvl" => "__builtin_ve_vl_vcmpswsx_vsvl",
                    "vl.vcmpswsx.vsvmvl" => "__builtin_ve_vl_vcmpswsx_vsvmvl",
                    "vl.vcmpswsx.vsvvl" => "__builtin_ve_vl_vcmpswsx_vsvvl",
                    "vl.vcmpswsx.vvvl" => "__builtin_ve_vl_vcmpswsx_vvvl",
                    "vl.vcmpswsx.vvvmvl" => "__builtin_ve_vl_vcmpswsx_vvvmvl",
                    "vl.vcmpswsx.vvvvl" => "__builtin_ve_vl_vcmpswsx_vvvvl",
                    "vl.vcmpswzx.vsvl" => "__builtin_ve_vl_vcmpswzx_vsvl",
                    "vl.vcmpswzx.vsvmvl" => "__builtin_ve_vl_vcmpswzx_vsvmvl",
                    "vl.vcmpswzx.vsvvl" => "__builtin_ve_vl_vcmpswzx_vsvvl",
                    "vl.vcmpswzx.vvvl" => "__builtin_ve_vl_vcmpswzx_vvvl",
                    "vl.vcmpswzx.vvvmvl" => "__builtin_ve_vl_vcmpswzx_vvvmvl",
                    "vl.vcmpswzx.vvvvl" => "__builtin_ve_vl_vcmpswzx_vvvvl",
                    "vl.vcmpul.vsvl" => "__builtin_ve_vl_vcmpul_vsvl",
                    "vl.vcmpul.vsvmvl" => "__builtin_ve_vl_vcmpul_vsvmvl",
                    "vl.vcmpul.vsvvl" => "__builtin_ve_vl_vcmpul_vsvvl",
                    "vl.vcmpul.vvvl" => "__builtin_ve_vl_vcmpul_vvvl",
                    "vl.vcmpul.vvvmvl" => "__builtin_ve_vl_vcmpul_vvvmvl",
                    "vl.vcmpul.vvvvl" => "__builtin_ve_vl_vcmpul_vvvvl",
                    "vl.vcmpuw.vsvl" => "__builtin_ve_vl_vcmpuw_vsvl",
                    "vl.vcmpuw.vsvmvl" => "__builtin_ve_vl_vcmpuw_vsvmvl",
                    "vl.vcmpuw.vsvvl" => "__builtin_ve_vl_vcmpuw_vsvvl",
                    "vl.vcmpuw.vvvl" => "__builtin_ve_vl_vcmpuw_vvvl",
                    "vl.vcmpuw.vvvmvl" => "__builtin_ve_vl_vcmpuw_vvvmvl",
                    "vl.vcmpuw.vvvvl" => "__builtin_ve_vl_vcmpuw_vvvvl",
                    "vl.vcp.vvmvl" => "__builtin_ve_vl_vcp_vvmvl",
                    "vl.vcvtdl.vvl" => "__builtin_ve_vl_vcvtdl_vvl",
                    "vl.vcvtdl.vvvl" => "__builtin_ve_vl_vcvtdl_vvvl",
                    "vl.vcvtds.vvl" => "__builtin_ve_vl_vcvtds_vvl",
                    "vl.vcvtds.vvvl" => "__builtin_ve_vl_vcvtds_vvvl",
                    "vl.vcvtdw.vvl" => "__builtin_ve_vl_vcvtdw_vvl",
                    "vl.vcvtdw.vvvl" => "__builtin_ve_vl_vcvtdw_vvvl",
                    "vl.vcvtld.vvl" => "__builtin_ve_vl_vcvtld_vvl",
                    "vl.vcvtld.vvmvl" => "__builtin_ve_vl_vcvtld_vvmvl",
                    "vl.vcvtld.vvvl" => "__builtin_ve_vl_vcvtld_vvvl",
                    "vl.vcvtldrz.vvl" => "__builtin_ve_vl_vcvtldrz_vvl",
                    "vl.vcvtldrz.vvmvl" => "__builtin_ve_vl_vcvtldrz_vvmvl",
                    "vl.vcvtldrz.vvvl" => "__builtin_ve_vl_vcvtldrz_vvvl",
                    "vl.vcvtsd.vvl" => "__builtin_ve_vl_vcvtsd_vvl",
                    "vl.vcvtsd.vvvl" => "__builtin_ve_vl_vcvtsd_vvvl",
                    "vl.vcvtsw.vvl" => "__builtin_ve_vl_vcvtsw_vvl",
                    "vl.vcvtsw.vvvl" => "__builtin_ve_vl_vcvtsw_vvvl",
                    "vl.vcvtwdsx.vvl" => "__builtin_ve_vl_vcvtwdsx_vvl",
                    "vl.vcvtwdsx.vvmvl" => "__builtin_ve_vl_vcvtwdsx_vvmvl",
                    "vl.vcvtwdsx.vvvl" => "__builtin_ve_vl_vcvtwdsx_vvvl",
                    "vl.vcvtwdsxrz.vvl" => "__builtin_ve_vl_vcvtwdsxrz_vvl",
                    "vl.vcvtwdsxrz.vvmvl" => "__builtin_ve_vl_vcvtwdsxrz_vvmvl",
                    "vl.vcvtwdsxrz.vvvl" => "__builtin_ve_vl_vcvtwdsxrz_vvvl",
                    "vl.vcvtwdzx.vvl" => "__builtin_ve_vl_vcvtwdzx_vvl",
                    "vl.vcvtwdzx.vvmvl" => "__builtin_ve_vl_vcvtwdzx_vvmvl",
                    "vl.vcvtwdzx.vvvl" => "__builtin_ve_vl_vcvtwdzx_vvvl",
                    "vl.vcvtwdzxrz.vvl" => "__builtin_ve_vl_vcvtwdzxrz_vvl",
                    "vl.vcvtwdzxrz.vvmvl" => "__builtin_ve_vl_vcvtwdzxrz_vvmvl",
                    "vl.vcvtwdzxrz.vvvl" => "__builtin_ve_vl_vcvtwdzxrz_vvvl",
                    "vl.vcvtwssx.vvl" => "__builtin_ve_vl_vcvtwssx_vvl",
                    "vl.vcvtwssx.vvmvl" => "__builtin_ve_vl_vcvtwssx_vvmvl",
                    "vl.vcvtwssx.vvvl" => "__builtin_ve_vl_vcvtwssx_vvvl",
                    "vl.vcvtwssxrz.vvl" => "__builtin_ve_vl_vcvtwssxrz_vvl",
                    "vl.vcvtwssxrz.vvmvl" => "__builtin_ve_vl_vcvtwssxrz_vvmvl",
                    "vl.vcvtwssxrz.vvvl" => "__builtin_ve_vl_vcvtwssxrz_vvvl",
                    "vl.vcvtwszx.vvl" => "__builtin_ve_vl_vcvtwszx_vvl",
                    "vl.vcvtwszx.vvmvl" => "__builtin_ve_vl_vcvtwszx_vvmvl",
                    "vl.vcvtwszx.vvvl" => "__builtin_ve_vl_vcvtwszx_vvvl",
                    "vl.vcvtwszxrz.vvl" => "__builtin_ve_vl_vcvtwszxrz_vvl",
                    "vl.vcvtwszxrz.vvmvl" => "__builtin_ve_vl_vcvtwszxrz_vvmvl",
                    "vl.vcvtwszxrz.vvvl" => "__builtin_ve_vl_vcvtwszxrz_vvvl",
                    "vl.vdivsl.vsvl" => "__builtin_ve_vl_vdivsl_vsvl",
                    "vl.vdivsl.vsvmvl" => "__builtin_ve_vl_vdivsl_vsvmvl",
                    "vl.vdivsl.vsvvl" => "__builtin_ve_vl_vdivsl_vsvvl",
                    "vl.vdivsl.vvsl" => "__builtin_ve_vl_vdivsl_vvsl",
                    "vl.vdivsl.vvsmvl" => "__builtin_ve_vl_vdivsl_vvsmvl",
                    "vl.vdivsl.vvsvl" => "__builtin_ve_vl_vdivsl_vvsvl",
                    "vl.vdivsl.vvvl" => "__builtin_ve_vl_vdivsl_vvvl",
                    "vl.vdivsl.vvvmvl" => "__builtin_ve_vl_vdivsl_vvvmvl",
                    "vl.vdivsl.vvvvl" => "__builtin_ve_vl_vdivsl_vvvvl",
                    "vl.vdivswsx.vsvl" => "__builtin_ve_vl_vdivswsx_vsvl",
                    "vl.vdivswsx.vsvmvl" => "__builtin_ve_vl_vdivswsx_vsvmvl",
                    "vl.vdivswsx.vsvvl" => "__builtin_ve_vl_vdivswsx_vsvvl",
                    "vl.vdivswsx.vvsl" => "__builtin_ve_vl_vdivswsx_vvsl",
                    "vl.vdivswsx.vvsmvl" => "__builtin_ve_vl_vdivswsx_vvsmvl",
                    "vl.vdivswsx.vvsvl" => "__builtin_ve_vl_vdivswsx_vvsvl",
                    "vl.vdivswsx.vvvl" => "__builtin_ve_vl_vdivswsx_vvvl",
                    "vl.vdivswsx.vvvmvl" => "__builtin_ve_vl_vdivswsx_vvvmvl",
                    "vl.vdivswsx.vvvvl" => "__builtin_ve_vl_vdivswsx_vvvvl",
                    "vl.vdivswzx.vsvl" => "__builtin_ve_vl_vdivswzx_vsvl",
                    "vl.vdivswzx.vsvmvl" => "__builtin_ve_vl_vdivswzx_vsvmvl",
                    "vl.vdivswzx.vsvvl" => "__builtin_ve_vl_vdivswzx_vsvvl",
                    "vl.vdivswzx.vvsl" => "__builtin_ve_vl_vdivswzx_vvsl",
                    "vl.vdivswzx.vvsmvl" => "__builtin_ve_vl_vdivswzx_vvsmvl",
                    "vl.vdivswzx.vvsvl" => "__builtin_ve_vl_vdivswzx_vvsvl",
                    "vl.vdivswzx.vvvl" => "__builtin_ve_vl_vdivswzx_vvvl",
                    "vl.vdivswzx.vvvmvl" => "__builtin_ve_vl_vdivswzx_vvvmvl",
                    "vl.vdivswzx.vvvvl" => "__builtin_ve_vl_vdivswzx_vvvvl",
                    "vl.vdivul.vsvl" => "__builtin_ve_vl_vdivul_vsvl",
                    "vl.vdivul.vsvmvl" => "__builtin_ve_vl_vdivul_vsvmvl",
                    "vl.vdivul.vsvvl" => "__builtin_ve_vl_vdivul_vsvvl",
                    "vl.vdivul.vvsl" => "__builtin_ve_vl_vdivul_vvsl",
                    "vl.vdivul.vvsmvl" => "__builtin_ve_vl_vdivul_vvsmvl",
                    "vl.vdivul.vvsvl" => "__builtin_ve_vl_vdivul_vvsvl",
                    "vl.vdivul.vvvl" => "__builtin_ve_vl_vdivul_vvvl",
                    "vl.vdivul.vvvmvl" => "__builtin_ve_vl_vdivul_vvvmvl",
                    "vl.vdivul.vvvvl" => "__builtin_ve_vl_vdivul_vvvvl",
                    "vl.vdivuw.vsvl" => "__builtin_ve_vl_vdivuw_vsvl",
                    "vl.vdivuw.vsvmvl" => "__builtin_ve_vl_vdivuw_vsvmvl",
                    "vl.vdivuw.vsvvl" => "__builtin_ve_vl_vdivuw_vsvvl",
                    "vl.vdivuw.vvsl" => "__builtin_ve_vl_vdivuw_vvsl",
                    "vl.vdivuw.vvsmvl" => "__builtin_ve_vl_vdivuw_vvsmvl",
                    "vl.vdivuw.vvsvl" => "__builtin_ve_vl_vdivuw_vvsvl",
                    "vl.vdivuw.vvvl" => "__builtin_ve_vl_vdivuw_vvvl",
                    "vl.vdivuw.vvvmvl" => "__builtin_ve_vl_vdivuw_vvvmvl",
                    "vl.vdivuw.vvvvl" => "__builtin_ve_vl_vdivuw_vvvvl",
                    "vl.veqv.vsvl" => "__builtin_ve_vl_veqv_vsvl",
                    "vl.veqv.vsvmvl" => "__builtin_ve_vl_veqv_vsvmvl",
                    "vl.veqv.vsvvl" => "__builtin_ve_vl_veqv_vsvvl",
                    "vl.veqv.vvvl" => "__builtin_ve_vl_veqv_vvvl",
                    "vl.veqv.vvvmvl" => "__builtin_ve_vl_veqv_vvvmvl",
                    "vl.veqv.vvvvl" => "__builtin_ve_vl_veqv_vvvvl",
                    "vl.vex.vvmvl" => "__builtin_ve_vl_vex_vvmvl",
                    "vl.vfaddd.vsvl" => "__builtin_ve_vl_vfaddd_vsvl",
                    "vl.vfaddd.vsvmvl" => "__builtin_ve_vl_vfaddd_vsvmvl",
                    "vl.vfaddd.vsvvl" => "__builtin_ve_vl_vfaddd_vsvvl",
                    "vl.vfaddd.vvvl" => "__builtin_ve_vl_vfaddd_vvvl",
                    "vl.vfaddd.vvvmvl" => "__builtin_ve_vl_vfaddd_vvvmvl",
                    "vl.vfaddd.vvvvl" => "__builtin_ve_vl_vfaddd_vvvvl",
                    "vl.vfadds.vsvl" => "__builtin_ve_vl_vfadds_vsvl",
                    "vl.vfadds.vsvmvl" => "__builtin_ve_vl_vfadds_vsvmvl",
                    "vl.vfadds.vsvvl" => "__builtin_ve_vl_vfadds_vsvvl",
                    "vl.vfadds.vvvl" => "__builtin_ve_vl_vfadds_vvvl",
                    "vl.vfadds.vvvmvl" => "__builtin_ve_vl_vfadds_vvvmvl",
                    "vl.vfadds.vvvvl" => "__builtin_ve_vl_vfadds_vvvvl",
                    "vl.vfcmpd.vsvl" => "__builtin_ve_vl_vfcmpd_vsvl",
                    "vl.vfcmpd.vsvmvl" => "__builtin_ve_vl_vfcmpd_vsvmvl",
                    "vl.vfcmpd.vsvvl" => "__builtin_ve_vl_vfcmpd_vsvvl",
                    "vl.vfcmpd.vvvl" => "__builtin_ve_vl_vfcmpd_vvvl",
                    "vl.vfcmpd.vvvmvl" => "__builtin_ve_vl_vfcmpd_vvvmvl",
                    "vl.vfcmpd.vvvvl" => "__builtin_ve_vl_vfcmpd_vvvvl",
                    "vl.vfcmps.vsvl" => "__builtin_ve_vl_vfcmps_vsvl",
                    "vl.vfcmps.vsvmvl" => "__builtin_ve_vl_vfcmps_vsvmvl",
                    "vl.vfcmps.vsvvl" => "__builtin_ve_vl_vfcmps_vsvvl",
                    "vl.vfcmps.vvvl" => "__builtin_ve_vl_vfcmps_vvvl",
                    "vl.vfcmps.vvvmvl" => "__builtin_ve_vl_vfcmps_vvvmvl",
                    "vl.vfcmps.vvvvl" => "__builtin_ve_vl_vfcmps_vvvvl",
                    "vl.vfdivd.vsvl" => "__builtin_ve_vl_vfdivd_vsvl",
                    "vl.vfdivd.vsvmvl" => "__builtin_ve_vl_vfdivd_vsvmvl",
                    "vl.vfdivd.vsvvl" => "__builtin_ve_vl_vfdivd_vsvvl",
                    "vl.vfdivd.vvvl" => "__builtin_ve_vl_vfdivd_vvvl",
                    "vl.vfdivd.vvvmvl" => "__builtin_ve_vl_vfdivd_vvvmvl",
                    "vl.vfdivd.vvvvl" => "__builtin_ve_vl_vfdivd_vvvvl",
                    "vl.vfdivs.vsvl" => "__builtin_ve_vl_vfdivs_vsvl",
                    "vl.vfdivs.vsvmvl" => "__builtin_ve_vl_vfdivs_vsvmvl",
                    "vl.vfdivs.vsvvl" => "__builtin_ve_vl_vfdivs_vsvvl",
                    "vl.vfdivs.vvvl" => "__builtin_ve_vl_vfdivs_vvvl",
                    "vl.vfdivs.vvvmvl" => "__builtin_ve_vl_vfdivs_vvvmvl",
                    "vl.vfdivs.vvvvl" => "__builtin_ve_vl_vfdivs_vvvvl",
                    "vl.vfmadd.vsvvl" => "__builtin_ve_vl_vfmadd_vsvvl",
                    "vl.vfmadd.vsvvmvl" => "__builtin_ve_vl_vfmadd_vsvvmvl",
                    "vl.vfmadd.vsvvvl" => "__builtin_ve_vl_vfmadd_vsvvvl",
                    "vl.vfmadd.vvsvl" => "__builtin_ve_vl_vfmadd_vvsvl",
                    "vl.vfmadd.vvsvmvl" => "__builtin_ve_vl_vfmadd_vvsvmvl",
                    "vl.vfmadd.vvsvvl" => "__builtin_ve_vl_vfmadd_vvsvvl",
                    "vl.vfmadd.vvvvl" => "__builtin_ve_vl_vfmadd_vvvvl",
                    "vl.vfmadd.vvvvmvl" => "__builtin_ve_vl_vfmadd_vvvvmvl",
                    "vl.vfmadd.vvvvvl" => "__builtin_ve_vl_vfmadd_vvvvvl",
                    "vl.vfmads.vsvvl" => "__builtin_ve_vl_vfmads_vsvvl",
                    "vl.vfmads.vsvvmvl" => "__builtin_ve_vl_vfmads_vsvvmvl",
                    "vl.vfmads.vsvvvl" => "__builtin_ve_vl_vfmads_vsvvvl",
                    "vl.vfmads.vvsvl" => "__builtin_ve_vl_vfmads_vvsvl",
                    "vl.vfmads.vvsvmvl" => "__builtin_ve_vl_vfmads_vvsvmvl",
                    "vl.vfmads.vvsvvl" => "__builtin_ve_vl_vfmads_vvsvvl",
                    "vl.vfmads.vvvvl" => "__builtin_ve_vl_vfmads_vvvvl",
                    "vl.vfmads.vvvvmvl" => "__builtin_ve_vl_vfmads_vvvvmvl",
                    "vl.vfmads.vvvvvl" => "__builtin_ve_vl_vfmads_vvvvvl",
                    "vl.vfmaxd.vsvl" => "__builtin_ve_vl_vfmaxd_vsvl",
                    "vl.vfmaxd.vsvmvl" => "__builtin_ve_vl_vfmaxd_vsvmvl",
                    "vl.vfmaxd.vsvvl" => "__builtin_ve_vl_vfmaxd_vsvvl",
                    "vl.vfmaxd.vvvl" => "__builtin_ve_vl_vfmaxd_vvvl",
                    "vl.vfmaxd.vvvmvl" => "__builtin_ve_vl_vfmaxd_vvvmvl",
                    "vl.vfmaxd.vvvvl" => "__builtin_ve_vl_vfmaxd_vvvvl",
                    "vl.vfmaxs.vsvl" => "__builtin_ve_vl_vfmaxs_vsvl",
                    "vl.vfmaxs.vsvmvl" => "__builtin_ve_vl_vfmaxs_vsvmvl",
                    "vl.vfmaxs.vsvvl" => "__builtin_ve_vl_vfmaxs_vsvvl",
                    "vl.vfmaxs.vvvl" => "__builtin_ve_vl_vfmaxs_vvvl",
                    "vl.vfmaxs.vvvmvl" => "__builtin_ve_vl_vfmaxs_vvvmvl",
                    "vl.vfmaxs.vvvvl" => "__builtin_ve_vl_vfmaxs_vvvvl",
                    "vl.vfmind.vsvl" => "__builtin_ve_vl_vfmind_vsvl",
                    "vl.vfmind.vsvmvl" => "__builtin_ve_vl_vfmind_vsvmvl",
                    "vl.vfmind.vsvvl" => "__builtin_ve_vl_vfmind_vsvvl",
                    "vl.vfmind.vvvl" => "__builtin_ve_vl_vfmind_vvvl",
                    "vl.vfmind.vvvmvl" => "__builtin_ve_vl_vfmind_vvvmvl",
                    "vl.vfmind.vvvvl" => "__builtin_ve_vl_vfmind_vvvvl",
                    "vl.vfmins.vsvl" => "__builtin_ve_vl_vfmins_vsvl",
                    "vl.vfmins.vsvmvl" => "__builtin_ve_vl_vfmins_vsvmvl",
                    "vl.vfmins.vsvvl" => "__builtin_ve_vl_vfmins_vsvvl",
                    "vl.vfmins.vvvl" => "__builtin_ve_vl_vfmins_vvvl",
                    "vl.vfmins.vvvmvl" => "__builtin_ve_vl_vfmins_vvvmvl",
                    "vl.vfmins.vvvvl" => "__builtin_ve_vl_vfmins_vvvvl",
                    "vl.vfmkdeq.mvl" => "__builtin_ve_vl_vfmkdeq_mvl",
                    "vl.vfmkdeq.mvml" => "__builtin_ve_vl_vfmkdeq_mvml",
                    "vl.vfmkdeqnan.mvl" => "__builtin_ve_vl_vfmkdeqnan_mvl",
                    "vl.vfmkdeqnan.mvml" => "__builtin_ve_vl_vfmkdeqnan_mvml",
                    "vl.vfmkdge.mvl" => "__builtin_ve_vl_vfmkdge_mvl",
                    "vl.vfmkdge.mvml" => "__builtin_ve_vl_vfmkdge_mvml",
                    "vl.vfmkdgenan.mvl" => "__builtin_ve_vl_vfmkdgenan_mvl",
                    "vl.vfmkdgenan.mvml" => "__builtin_ve_vl_vfmkdgenan_mvml",
                    "vl.vfmkdgt.mvl" => "__builtin_ve_vl_vfmkdgt_mvl",
                    "vl.vfmkdgt.mvml" => "__builtin_ve_vl_vfmkdgt_mvml",
                    "vl.vfmkdgtnan.mvl" => "__builtin_ve_vl_vfmkdgtnan_mvl",
                    "vl.vfmkdgtnan.mvml" => "__builtin_ve_vl_vfmkdgtnan_mvml",
                    "vl.vfmkdle.mvl" => "__builtin_ve_vl_vfmkdle_mvl",
                    "vl.vfmkdle.mvml" => "__builtin_ve_vl_vfmkdle_mvml",
                    "vl.vfmkdlenan.mvl" => "__builtin_ve_vl_vfmkdlenan_mvl",
                    "vl.vfmkdlenan.mvml" => "__builtin_ve_vl_vfmkdlenan_mvml",
                    "vl.vfmkdlt.mvl" => "__builtin_ve_vl_vfmkdlt_mvl",
                    "vl.vfmkdlt.mvml" => "__builtin_ve_vl_vfmkdlt_mvml",
                    "vl.vfmkdltnan.mvl" => "__builtin_ve_vl_vfmkdltnan_mvl",
                    "vl.vfmkdltnan.mvml" => "__builtin_ve_vl_vfmkdltnan_mvml",
                    "vl.vfmkdnan.mvl" => "__builtin_ve_vl_vfmkdnan_mvl",
                    "vl.vfmkdnan.mvml" => "__builtin_ve_vl_vfmkdnan_mvml",
                    "vl.vfmkdne.mvl" => "__builtin_ve_vl_vfmkdne_mvl",
                    "vl.vfmkdne.mvml" => "__builtin_ve_vl_vfmkdne_mvml",
                    "vl.vfmkdnenan.mvl" => "__builtin_ve_vl_vfmkdnenan_mvl",
                    "vl.vfmkdnenan.mvml" => "__builtin_ve_vl_vfmkdnenan_mvml",
                    "vl.vfmkdnum.mvl" => "__builtin_ve_vl_vfmkdnum_mvl",
                    "vl.vfmkdnum.mvml" => "__builtin_ve_vl_vfmkdnum_mvml",
                    "vl.vfmklaf.ml" => "__builtin_ve_vl_vfmklaf_ml",
                    "vl.vfmklat.ml" => "__builtin_ve_vl_vfmklat_ml",
                    "vl.vfmkleq.mvl" => "__builtin_ve_vl_vfmkleq_mvl",
                    "vl.vfmkleq.mvml" => "__builtin_ve_vl_vfmkleq_mvml",
                    "vl.vfmkleqnan.mvl" => "__builtin_ve_vl_vfmkleqnan_mvl",
                    "vl.vfmkleqnan.mvml" => "__builtin_ve_vl_vfmkleqnan_mvml",
                    "vl.vfmklge.mvl" => "__builtin_ve_vl_vfmklge_mvl",
                    "vl.vfmklge.mvml" => "__builtin_ve_vl_vfmklge_mvml",
                    "vl.vfmklgenan.mvl" => "__builtin_ve_vl_vfmklgenan_mvl",
                    "vl.vfmklgenan.mvml" => "__builtin_ve_vl_vfmklgenan_mvml",
                    "vl.vfmklgt.mvl" => "__builtin_ve_vl_vfmklgt_mvl",
                    "vl.vfmklgt.mvml" => "__builtin_ve_vl_vfmklgt_mvml",
                    "vl.vfmklgtnan.mvl" => "__builtin_ve_vl_vfmklgtnan_mvl",
                    "vl.vfmklgtnan.mvml" => "__builtin_ve_vl_vfmklgtnan_mvml",
                    "vl.vfmklle.mvl" => "__builtin_ve_vl_vfmklle_mvl",
                    "vl.vfmklle.mvml" => "__builtin_ve_vl_vfmklle_mvml",
                    "vl.vfmkllenan.mvl" => "__builtin_ve_vl_vfmkllenan_mvl",
                    "vl.vfmkllenan.mvml" => "__builtin_ve_vl_vfmkllenan_mvml",
                    "vl.vfmkllt.mvl" => "__builtin_ve_vl_vfmkllt_mvl",
                    "vl.vfmkllt.mvml" => "__builtin_ve_vl_vfmkllt_mvml",
                    "vl.vfmklltnan.mvl" => "__builtin_ve_vl_vfmklltnan_mvl",
                    "vl.vfmklltnan.mvml" => "__builtin_ve_vl_vfmklltnan_mvml",
                    "vl.vfmklnan.mvl" => "__builtin_ve_vl_vfmklnan_mvl",
                    "vl.vfmklnan.mvml" => "__builtin_ve_vl_vfmklnan_mvml",
                    "vl.vfmklne.mvl" => "__builtin_ve_vl_vfmklne_mvl",
                    "vl.vfmklne.mvml" => "__builtin_ve_vl_vfmklne_mvml",
                    "vl.vfmklnenan.mvl" => "__builtin_ve_vl_vfmklnenan_mvl",
                    "vl.vfmklnenan.mvml" => "__builtin_ve_vl_vfmklnenan_mvml",
                    "vl.vfmklnum.mvl" => "__builtin_ve_vl_vfmklnum_mvl",
                    "vl.vfmklnum.mvml" => "__builtin_ve_vl_vfmklnum_mvml",
                    "vl.vfmkseq.mvl" => "__builtin_ve_vl_vfmkseq_mvl",
                    "vl.vfmkseq.mvml" => "__builtin_ve_vl_vfmkseq_mvml",
                    "vl.vfmkseqnan.mvl" => "__builtin_ve_vl_vfmkseqnan_mvl",
                    "vl.vfmkseqnan.mvml" => "__builtin_ve_vl_vfmkseqnan_mvml",
                    "vl.vfmksge.mvl" => "__builtin_ve_vl_vfmksge_mvl",
                    "vl.vfmksge.mvml" => "__builtin_ve_vl_vfmksge_mvml",
                    "vl.vfmksgenan.mvl" => "__builtin_ve_vl_vfmksgenan_mvl",
                    "vl.vfmksgenan.mvml" => "__builtin_ve_vl_vfmksgenan_mvml",
                    "vl.vfmksgt.mvl" => "__builtin_ve_vl_vfmksgt_mvl",
                    "vl.vfmksgt.mvml" => "__builtin_ve_vl_vfmksgt_mvml",
                    "vl.vfmksgtnan.mvl" => "__builtin_ve_vl_vfmksgtnan_mvl",
                    "vl.vfmksgtnan.mvml" => "__builtin_ve_vl_vfmksgtnan_mvml",
                    "vl.vfmksle.mvl" => "__builtin_ve_vl_vfmksle_mvl",
                    "vl.vfmksle.mvml" => "__builtin_ve_vl_vfmksle_mvml",
                    "vl.vfmkslenan.mvl" => "__builtin_ve_vl_vfmkslenan_mvl",
                    "vl.vfmkslenan.mvml" => "__builtin_ve_vl_vfmkslenan_mvml",
                    "vl.vfmkslt.mvl" => "__builtin_ve_vl_vfmkslt_mvl",
                    "vl.vfmkslt.mvml" => "__builtin_ve_vl_vfmkslt_mvml",
                    "vl.vfmksltnan.mvl" => "__builtin_ve_vl_vfmksltnan_mvl",
                    "vl.vfmksltnan.mvml" => "__builtin_ve_vl_vfmksltnan_mvml",
                    "vl.vfmksnan.mvl" => "__builtin_ve_vl_vfmksnan_mvl",
                    "vl.vfmksnan.mvml" => "__builtin_ve_vl_vfmksnan_mvml",
                    "vl.vfmksne.mvl" => "__builtin_ve_vl_vfmksne_mvl",
                    "vl.vfmksne.mvml" => "__builtin_ve_vl_vfmksne_mvml",
                    "vl.vfmksnenan.mvl" => "__builtin_ve_vl_vfmksnenan_mvl",
                    "vl.vfmksnenan.mvml" => "__builtin_ve_vl_vfmksnenan_mvml",
                    "vl.vfmksnum.mvl" => "__builtin_ve_vl_vfmksnum_mvl",
                    "vl.vfmksnum.mvml" => "__builtin_ve_vl_vfmksnum_mvml",
                    "vl.vfmkweq.mvl" => "__builtin_ve_vl_vfmkweq_mvl",
                    "vl.vfmkweq.mvml" => "__builtin_ve_vl_vfmkweq_mvml",
                    "vl.vfmkweqnan.mvl" => "__builtin_ve_vl_vfmkweqnan_mvl",
                    "vl.vfmkweqnan.mvml" => "__builtin_ve_vl_vfmkweqnan_mvml",
                    "vl.vfmkwge.mvl" => "__builtin_ve_vl_vfmkwge_mvl",
                    "vl.vfmkwge.mvml" => "__builtin_ve_vl_vfmkwge_mvml",
                    "vl.vfmkwgenan.mvl" => "__builtin_ve_vl_vfmkwgenan_mvl",
                    "vl.vfmkwgenan.mvml" => "__builtin_ve_vl_vfmkwgenan_mvml",
                    "vl.vfmkwgt.mvl" => "__builtin_ve_vl_vfmkwgt_mvl",
                    "vl.vfmkwgt.mvml" => "__builtin_ve_vl_vfmkwgt_mvml",
                    "vl.vfmkwgtnan.mvl" => "__builtin_ve_vl_vfmkwgtnan_mvl",
                    "vl.vfmkwgtnan.mvml" => "__builtin_ve_vl_vfmkwgtnan_mvml",
                    "vl.vfmkwle.mvl" => "__builtin_ve_vl_vfmkwle_mvl",
                    "vl.vfmkwle.mvml" => "__builtin_ve_vl_vfmkwle_mvml",
                    "vl.vfmkwlenan.mvl" => "__builtin_ve_vl_vfmkwlenan_mvl",
                    "vl.vfmkwlenan.mvml" => "__builtin_ve_vl_vfmkwlenan_mvml",
                    "vl.vfmkwlt.mvl" => "__builtin_ve_vl_vfmkwlt_mvl",
                    "vl.vfmkwlt.mvml" => "__builtin_ve_vl_vfmkwlt_mvml",
                    "vl.vfmkwltnan.mvl" => "__builtin_ve_vl_vfmkwltnan_mvl",
                    "vl.vfmkwltnan.mvml" => "__builtin_ve_vl_vfmkwltnan_mvml",
                    "vl.vfmkwnan.mvl" => "__builtin_ve_vl_vfmkwnan_mvl",
                    "vl.vfmkwnan.mvml" => "__builtin_ve_vl_vfmkwnan_mvml",
                    "vl.vfmkwne.mvl" => "__builtin_ve_vl_vfmkwne_mvl",
                    "vl.vfmkwne.mvml" => "__builtin_ve_vl_vfmkwne_mvml",
                    "vl.vfmkwnenan.mvl" => "__builtin_ve_vl_vfmkwnenan_mvl",
                    "vl.vfmkwnenan.mvml" => "__builtin_ve_vl_vfmkwnenan_mvml",
                    "vl.vfmkwnum.mvl" => "__builtin_ve_vl_vfmkwnum_mvl",
                    "vl.vfmkwnum.mvml" => "__builtin_ve_vl_vfmkwnum_mvml",
                    "vl.vfmsbd.vsvvl" => "__builtin_ve_vl_vfmsbd_vsvvl",
                    "vl.vfmsbd.vsvvmvl" => "__builtin_ve_vl_vfmsbd_vsvvmvl",
                    "vl.vfmsbd.vsvvvl" => "__builtin_ve_vl_vfmsbd_vsvvvl",
                    "vl.vfmsbd.vvsvl" => "__builtin_ve_vl_vfmsbd_vvsvl",
                    "vl.vfmsbd.vvsvmvl" => "__builtin_ve_vl_vfmsbd_vvsvmvl",
                    "vl.vfmsbd.vvsvvl" => "__builtin_ve_vl_vfmsbd_vvsvvl",
                    "vl.vfmsbd.vvvvl" => "__builtin_ve_vl_vfmsbd_vvvvl",
                    "vl.vfmsbd.vvvvmvl" => "__builtin_ve_vl_vfmsbd_vvvvmvl",
                    "vl.vfmsbd.vvvvvl" => "__builtin_ve_vl_vfmsbd_vvvvvl",
                    "vl.vfmsbs.vsvvl" => "__builtin_ve_vl_vfmsbs_vsvvl",
                    "vl.vfmsbs.vsvvmvl" => "__builtin_ve_vl_vfmsbs_vsvvmvl",
                    "vl.vfmsbs.vsvvvl" => "__builtin_ve_vl_vfmsbs_vsvvvl",
                    "vl.vfmsbs.vvsvl" => "__builtin_ve_vl_vfmsbs_vvsvl",
                    "vl.vfmsbs.vvsvmvl" => "__builtin_ve_vl_vfmsbs_vvsvmvl",
                    "vl.vfmsbs.vvsvvl" => "__builtin_ve_vl_vfmsbs_vvsvvl",
                    "vl.vfmsbs.vvvvl" => "__builtin_ve_vl_vfmsbs_vvvvl",
                    "vl.vfmsbs.vvvvmvl" => "__builtin_ve_vl_vfmsbs_vvvvmvl",
                    "vl.vfmsbs.vvvvvl" => "__builtin_ve_vl_vfmsbs_vvvvvl",
                    "vl.vfmuld.vsvl" => "__builtin_ve_vl_vfmuld_vsvl",
                    "vl.vfmuld.vsvmvl" => "__builtin_ve_vl_vfmuld_vsvmvl",
                    "vl.vfmuld.vsvvl" => "__builtin_ve_vl_vfmuld_vsvvl",
                    "vl.vfmuld.vvvl" => "__builtin_ve_vl_vfmuld_vvvl",
                    "vl.vfmuld.vvvmvl" => "__builtin_ve_vl_vfmuld_vvvmvl",
                    "vl.vfmuld.vvvvl" => "__builtin_ve_vl_vfmuld_vvvvl",
                    "vl.vfmuls.vsvl" => "__builtin_ve_vl_vfmuls_vsvl",
                    "vl.vfmuls.vsvmvl" => "__builtin_ve_vl_vfmuls_vsvmvl",
                    "vl.vfmuls.vsvvl" => "__builtin_ve_vl_vfmuls_vsvvl",
                    "vl.vfmuls.vvvl" => "__builtin_ve_vl_vfmuls_vvvl",
                    "vl.vfmuls.vvvmvl" => "__builtin_ve_vl_vfmuls_vvvmvl",
                    "vl.vfmuls.vvvvl" => "__builtin_ve_vl_vfmuls_vvvvl",
                    "vl.vfnmadd.vsvvl" => "__builtin_ve_vl_vfnmadd_vsvvl",
                    "vl.vfnmadd.vsvvmvl" => "__builtin_ve_vl_vfnmadd_vsvvmvl",
                    "vl.vfnmadd.vsvvvl" => "__builtin_ve_vl_vfnmadd_vsvvvl",
                    "vl.vfnmadd.vvsvl" => "__builtin_ve_vl_vfnmadd_vvsvl",
                    "vl.vfnmadd.vvsvmvl" => "__builtin_ve_vl_vfnmadd_vvsvmvl",
                    "vl.vfnmadd.vvsvvl" => "__builtin_ve_vl_vfnmadd_vvsvvl",
                    "vl.vfnmadd.vvvvl" => "__builtin_ve_vl_vfnmadd_vvvvl",
                    "vl.vfnmadd.vvvvmvl" => "__builtin_ve_vl_vfnmadd_vvvvmvl",
                    "vl.vfnmadd.vvvvvl" => "__builtin_ve_vl_vfnmadd_vvvvvl",
                    "vl.vfnmads.vsvvl" => "__builtin_ve_vl_vfnmads_vsvvl",
                    "vl.vfnmads.vsvvmvl" => "__builtin_ve_vl_vfnmads_vsvvmvl",
                    "vl.vfnmads.vsvvvl" => "__builtin_ve_vl_vfnmads_vsvvvl",
                    "vl.vfnmads.vvsvl" => "__builtin_ve_vl_vfnmads_vvsvl",
                    "vl.vfnmads.vvsvmvl" => "__builtin_ve_vl_vfnmads_vvsvmvl",
                    "vl.vfnmads.vvsvvl" => "__builtin_ve_vl_vfnmads_vvsvvl",
                    "vl.vfnmads.vvvvl" => "__builtin_ve_vl_vfnmads_vvvvl",
                    "vl.vfnmads.vvvvmvl" => "__builtin_ve_vl_vfnmads_vvvvmvl",
                    "vl.vfnmads.vvvvvl" => "__builtin_ve_vl_vfnmads_vvvvvl",
                    "vl.vfnmsbd.vsvvl" => "__builtin_ve_vl_vfnmsbd_vsvvl",
                    "vl.vfnmsbd.vsvvmvl" => "__builtin_ve_vl_vfnmsbd_vsvvmvl",
                    "vl.vfnmsbd.vsvvvl" => "__builtin_ve_vl_vfnmsbd_vsvvvl",
                    "vl.vfnmsbd.vvsvl" => "__builtin_ve_vl_vfnmsbd_vvsvl",
                    "vl.vfnmsbd.vvsvmvl" => "__builtin_ve_vl_vfnmsbd_vvsvmvl",
                    "vl.vfnmsbd.vvsvvl" => "__builtin_ve_vl_vfnmsbd_vvsvvl",
                    "vl.vfnmsbd.vvvvl" => "__builtin_ve_vl_vfnmsbd_vvvvl",
                    "vl.vfnmsbd.vvvvmvl" => "__builtin_ve_vl_vfnmsbd_vvvvmvl",
                    "vl.vfnmsbd.vvvvvl" => "__builtin_ve_vl_vfnmsbd_vvvvvl",
                    "vl.vfnmsbs.vsvvl" => "__builtin_ve_vl_vfnmsbs_vsvvl",
                    "vl.vfnmsbs.vsvvmvl" => "__builtin_ve_vl_vfnmsbs_vsvvmvl",
                    "vl.vfnmsbs.vsvvvl" => "__builtin_ve_vl_vfnmsbs_vsvvvl",
                    "vl.vfnmsbs.vvsvl" => "__builtin_ve_vl_vfnmsbs_vvsvl",
                    "vl.vfnmsbs.vvsvmvl" => "__builtin_ve_vl_vfnmsbs_vvsvmvl",
                    "vl.vfnmsbs.vvsvvl" => "__builtin_ve_vl_vfnmsbs_vvsvvl",
                    "vl.vfnmsbs.vvvvl" => "__builtin_ve_vl_vfnmsbs_vvvvl",
                    "vl.vfnmsbs.vvvvmvl" => "__builtin_ve_vl_vfnmsbs_vvvvmvl",
                    "vl.vfnmsbs.vvvvvl" => "__builtin_ve_vl_vfnmsbs_vvvvvl",
                    "vl.vfrmaxdfst.vvl" => "__builtin_ve_vl_vfrmaxdfst_vvl",
                    "vl.vfrmaxdfst.vvvl" => "__builtin_ve_vl_vfrmaxdfst_vvvl",
                    "vl.vfrmaxdlst.vvl" => "__builtin_ve_vl_vfrmaxdlst_vvl",
                    "vl.vfrmaxdlst.vvvl" => "__builtin_ve_vl_vfrmaxdlst_vvvl",
                    "vl.vfrmaxsfst.vvl" => "__builtin_ve_vl_vfrmaxsfst_vvl",
                    "vl.vfrmaxsfst.vvvl" => "__builtin_ve_vl_vfrmaxsfst_vvvl",
                    "vl.vfrmaxslst.vvl" => "__builtin_ve_vl_vfrmaxslst_vvl",
                    "vl.vfrmaxslst.vvvl" => "__builtin_ve_vl_vfrmaxslst_vvvl",
                    "vl.vfrmindfst.vvl" => "__builtin_ve_vl_vfrmindfst_vvl",
                    "vl.vfrmindfst.vvvl" => "__builtin_ve_vl_vfrmindfst_vvvl",
                    "vl.vfrmindlst.vvl" => "__builtin_ve_vl_vfrmindlst_vvl",
                    "vl.vfrmindlst.vvvl" => "__builtin_ve_vl_vfrmindlst_vvvl",
                    "vl.vfrminsfst.vvl" => "__builtin_ve_vl_vfrminsfst_vvl",
                    "vl.vfrminsfst.vvvl" => "__builtin_ve_vl_vfrminsfst_vvvl",
                    "vl.vfrminslst.vvl" => "__builtin_ve_vl_vfrminslst_vvl",
                    "vl.vfrminslst.vvvl" => "__builtin_ve_vl_vfrminslst_vvvl",
                    "vl.vfsqrtd.vvl" => "__builtin_ve_vl_vfsqrtd_vvl",
                    "vl.vfsqrtd.vvvl" => "__builtin_ve_vl_vfsqrtd_vvvl",
                    "vl.vfsqrts.vvl" => "__builtin_ve_vl_vfsqrts_vvl",
                    "vl.vfsqrts.vvvl" => "__builtin_ve_vl_vfsqrts_vvvl",
                    "vl.vfsubd.vsvl" => "__builtin_ve_vl_vfsubd_vsvl",
                    "vl.vfsubd.vsvmvl" => "__builtin_ve_vl_vfsubd_vsvmvl",
                    "vl.vfsubd.vsvvl" => "__builtin_ve_vl_vfsubd_vsvvl",
                    "vl.vfsubd.vvvl" => "__builtin_ve_vl_vfsubd_vvvl",
                    "vl.vfsubd.vvvmvl" => "__builtin_ve_vl_vfsubd_vvvmvl",
                    "vl.vfsubd.vvvvl" => "__builtin_ve_vl_vfsubd_vvvvl",
                    "vl.vfsubs.vsvl" => "__builtin_ve_vl_vfsubs_vsvl",
                    "vl.vfsubs.vsvmvl" => "__builtin_ve_vl_vfsubs_vsvmvl",
                    "vl.vfsubs.vsvvl" => "__builtin_ve_vl_vfsubs_vsvvl",
                    "vl.vfsubs.vvvl" => "__builtin_ve_vl_vfsubs_vvvl",
                    "vl.vfsubs.vvvmvl" => "__builtin_ve_vl_vfsubs_vvvmvl",
                    "vl.vfsubs.vvvvl" => "__builtin_ve_vl_vfsubs_vvvvl",
                    "vl.vfsumd.vvl" => "__builtin_ve_vl_vfsumd_vvl",
                    "vl.vfsumd.vvml" => "__builtin_ve_vl_vfsumd_vvml",
                    "vl.vfsums.vvl" => "__builtin_ve_vl_vfsums_vvl",
                    "vl.vfsums.vvml" => "__builtin_ve_vl_vfsums_vvml",
                    "vl.vgt.vvssl" => "__builtin_ve_vl_vgt_vvssl",
                    "vl.vgt.vvssml" => "__builtin_ve_vl_vgt_vvssml",
                    "vl.vgt.vvssmvl" => "__builtin_ve_vl_vgt_vvssmvl",
                    "vl.vgt.vvssvl" => "__builtin_ve_vl_vgt_vvssvl",
                    "vl.vgtlsx.vvssl" => "__builtin_ve_vl_vgtlsx_vvssl",
                    "vl.vgtlsx.vvssml" => "__builtin_ve_vl_vgtlsx_vvssml",
                    "vl.vgtlsx.vvssmvl" => "__builtin_ve_vl_vgtlsx_vvssmvl",
                    "vl.vgtlsx.vvssvl" => "__builtin_ve_vl_vgtlsx_vvssvl",
                    "vl.vgtlsxnc.vvssl" => "__builtin_ve_vl_vgtlsxnc_vvssl",
                    "vl.vgtlsxnc.vvssml" => "__builtin_ve_vl_vgtlsxnc_vvssml",
                    "vl.vgtlsxnc.vvssmvl" => "__builtin_ve_vl_vgtlsxnc_vvssmvl",
                    "vl.vgtlsxnc.vvssvl" => "__builtin_ve_vl_vgtlsxnc_vvssvl",
                    "vl.vgtlzx.vvssl" => "__builtin_ve_vl_vgtlzx_vvssl",
                    "vl.vgtlzx.vvssml" => "__builtin_ve_vl_vgtlzx_vvssml",
                    "vl.vgtlzx.vvssmvl" => "__builtin_ve_vl_vgtlzx_vvssmvl",
                    "vl.vgtlzx.vvssvl" => "__builtin_ve_vl_vgtlzx_vvssvl",
                    "vl.vgtlzxnc.vvssl" => "__builtin_ve_vl_vgtlzxnc_vvssl",
                    "vl.vgtlzxnc.vvssml" => "__builtin_ve_vl_vgtlzxnc_vvssml",
                    "vl.vgtlzxnc.vvssmvl" => "__builtin_ve_vl_vgtlzxnc_vvssmvl",
                    "vl.vgtlzxnc.vvssvl" => "__builtin_ve_vl_vgtlzxnc_vvssvl",
                    "vl.vgtnc.vvssl" => "__builtin_ve_vl_vgtnc_vvssl",
                    "vl.vgtnc.vvssml" => "__builtin_ve_vl_vgtnc_vvssml",
                    "vl.vgtnc.vvssmvl" => "__builtin_ve_vl_vgtnc_vvssmvl",
                    "vl.vgtnc.vvssvl" => "__builtin_ve_vl_vgtnc_vvssvl",
                    "vl.vgtu.vvssl" => "__builtin_ve_vl_vgtu_vvssl",
                    "vl.vgtu.vvssml" => "__builtin_ve_vl_vgtu_vvssml",
                    "vl.vgtu.vvssmvl" => "__builtin_ve_vl_vgtu_vvssmvl",
                    "vl.vgtu.vvssvl" => "__builtin_ve_vl_vgtu_vvssvl",
                    "vl.vgtunc.vvssl" => "__builtin_ve_vl_vgtunc_vvssl",
                    "vl.vgtunc.vvssml" => "__builtin_ve_vl_vgtunc_vvssml",
                    "vl.vgtunc.vvssmvl" => "__builtin_ve_vl_vgtunc_vvssmvl",
                    "vl.vgtunc.vvssvl" => "__builtin_ve_vl_vgtunc_vvssvl",
                    "vl.vld.vssl" => "__builtin_ve_vl_vld_vssl",
                    "vl.vld.vssvl" => "__builtin_ve_vl_vld_vssvl",
                    "vl.vld2d.vssl" => "__builtin_ve_vl_vld2d_vssl",
                    "vl.vld2d.vssvl" => "__builtin_ve_vl_vld2d_vssvl",
                    "vl.vld2dnc.vssl" => "__builtin_ve_vl_vld2dnc_vssl",
                    "vl.vld2dnc.vssvl" => "__builtin_ve_vl_vld2dnc_vssvl",
                    "vl.vldl2dsx.vssl" => "__builtin_ve_vl_vldl2dsx_vssl",
                    "vl.vldl2dsx.vssvl" => "__builtin_ve_vl_vldl2dsx_vssvl",
                    "vl.vldl2dsxnc.vssl" => "__builtin_ve_vl_vldl2dsxnc_vssl",
                    "vl.vldl2dsxnc.vssvl" => "__builtin_ve_vl_vldl2dsxnc_vssvl",
                    "vl.vldl2dzx.vssl" => "__builtin_ve_vl_vldl2dzx_vssl",
                    "vl.vldl2dzx.vssvl" => "__builtin_ve_vl_vldl2dzx_vssvl",
                    "vl.vldl2dzxnc.vssl" => "__builtin_ve_vl_vldl2dzxnc_vssl",
                    "vl.vldl2dzxnc.vssvl" => "__builtin_ve_vl_vldl2dzxnc_vssvl",
                    "vl.vldlsx.vssl" => "__builtin_ve_vl_vldlsx_vssl",
                    "vl.vldlsx.vssvl" => "__builtin_ve_vl_vldlsx_vssvl",
                    "vl.vldlsxnc.vssl" => "__builtin_ve_vl_vldlsxnc_vssl",
                    "vl.vldlsxnc.vssvl" => "__builtin_ve_vl_vldlsxnc_vssvl",
                    "vl.vldlzx.vssl" => "__builtin_ve_vl_vldlzx_vssl",
                    "vl.vldlzx.vssvl" => "__builtin_ve_vl_vldlzx_vssvl",
                    "vl.vldlzxnc.vssl" => "__builtin_ve_vl_vldlzxnc_vssl",
                    "vl.vldlzxnc.vssvl" => "__builtin_ve_vl_vldlzxnc_vssvl",
                    "vl.vldnc.vssl" => "__builtin_ve_vl_vldnc_vssl",
                    "vl.vldnc.vssvl" => "__builtin_ve_vl_vldnc_vssvl",
                    "vl.vldu.vssl" => "__builtin_ve_vl_vldu_vssl",
                    "vl.vldu.vssvl" => "__builtin_ve_vl_vldu_vssvl",
                    "vl.vldu2d.vssl" => "__builtin_ve_vl_vldu2d_vssl",
                    "vl.vldu2d.vssvl" => "__builtin_ve_vl_vldu2d_vssvl",
                    "vl.vldu2dnc.vssl" => "__builtin_ve_vl_vldu2dnc_vssl",
                    "vl.vldu2dnc.vssvl" => "__builtin_ve_vl_vldu2dnc_vssvl",
                    "vl.vldunc.vssl" => "__builtin_ve_vl_vldunc_vssl",
                    "vl.vldunc.vssvl" => "__builtin_ve_vl_vldunc_vssvl",
                    "vl.vldz.vvl" => "__builtin_ve_vl_vldz_vvl",
                    "vl.vldz.vvmvl" => "__builtin_ve_vl_vldz_vvmvl",
                    "vl.vldz.vvvl" => "__builtin_ve_vl_vldz_vvvl",
                    "vl.vmaxsl.vsvl" => "__builtin_ve_vl_vmaxsl_vsvl",
                    "vl.vmaxsl.vsvmvl" => "__builtin_ve_vl_vmaxsl_vsvmvl",
                    "vl.vmaxsl.vsvvl" => "__builtin_ve_vl_vmaxsl_vsvvl",
                    "vl.vmaxsl.vvvl" => "__builtin_ve_vl_vmaxsl_vvvl",
                    "vl.vmaxsl.vvvmvl" => "__builtin_ve_vl_vmaxsl_vvvmvl",
                    "vl.vmaxsl.vvvvl" => "__builtin_ve_vl_vmaxsl_vvvvl",
                    "vl.vmaxswsx.vsvl" => "__builtin_ve_vl_vmaxswsx_vsvl",
                    "vl.vmaxswsx.vsvmvl" => "__builtin_ve_vl_vmaxswsx_vsvmvl",
                    "vl.vmaxswsx.vsvvl" => "__builtin_ve_vl_vmaxswsx_vsvvl",
                    "vl.vmaxswsx.vvvl" => "__builtin_ve_vl_vmaxswsx_vvvl",
                    "vl.vmaxswsx.vvvmvl" => "__builtin_ve_vl_vmaxswsx_vvvmvl",
                    "vl.vmaxswsx.vvvvl" => "__builtin_ve_vl_vmaxswsx_vvvvl",
                    "vl.vmaxswzx.vsvl" => "__builtin_ve_vl_vmaxswzx_vsvl",
                    "vl.vmaxswzx.vsvmvl" => "__builtin_ve_vl_vmaxswzx_vsvmvl",
                    "vl.vmaxswzx.vsvvl" => "__builtin_ve_vl_vmaxswzx_vsvvl",
                    "vl.vmaxswzx.vvvl" => "__builtin_ve_vl_vmaxswzx_vvvl",
                    "vl.vmaxswzx.vvvmvl" => "__builtin_ve_vl_vmaxswzx_vvvmvl",
                    "vl.vmaxswzx.vvvvl" => "__builtin_ve_vl_vmaxswzx_vvvvl",
                    "vl.vminsl.vsvl" => "__builtin_ve_vl_vminsl_vsvl",
                    "vl.vminsl.vsvmvl" => "__builtin_ve_vl_vminsl_vsvmvl",
                    "vl.vminsl.vsvvl" => "__builtin_ve_vl_vminsl_vsvvl",
                    "vl.vminsl.vvvl" => "__builtin_ve_vl_vminsl_vvvl",
                    "vl.vminsl.vvvmvl" => "__builtin_ve_vl_vminsl_vvvmvl",
                    "vl.vminsl.vvvvl" => "__builtin_ve_vl_vminsl_vvvvl",
                    "vl.vminswsx.vsvl" => "__builtin_ve_vl_vminswsx_vsvl",
                    "vl.vminswsx.vsvmvl" => "__builtin_ve_vl_vminswsx_vsvmvl",
                    "vl.vminswsx.vsvvl" => "__builtin_ve_vl_vminswsx_vsvvl",
                    "vl.vminswsx.vvvl" => "__builtin_ve_vl_vminswsx_vvvl",
                    "vl.vminswsx.vvvmvl" => "__builtin_ve_vl_vminswsx_vvvmvl",
                    "vl.vminswsx.vvvvl" => "__builtin_ve_vl_vminswsx_vvvvl",
                    "vl.vminswzx.vsvl" => "__builtin_ve_vl_vminswzx_vsvl",
                    "vl.vminswzx.vsvmvl" => "__builtin_ve_vl_vminswzx_vsvmvl",
                    "vl.vminswzx.vsvvl" => "__builtin_ve_vl_vminswzx_vsvvl",
                    "vl.vminswzx.vvvl" => "__builtin_ve_vl_vminswzx_vvvl",
                    "vl.vminswzx.vvvmvl" => "__builtin_ve_vl_vminswzx_vvvmvl",
                    "vl.vminswzx.vvvvl" => "__builtin_ve_vl_vminswzx_vvvvl",
                    "vl.vmrg.vsvml" => "__builtin_ve_vl_vmrg_vsvml",
                    "vl.vmrg.vsvmvl" => "__builtin_ve_vl_vmrg_vsvmvl",
                    "vl.vmrg.vvvml" => "__builtin_ve_vl_vmrg_vvvml",
                    "vl.vmrg.vvvmvl" => "__builtin_ve_vl_vmrg_vvvmvl",
                    "vl.vmrgw.vsvMl" => "__builtin_ve_vl_vmrgw_vsvMl",
                    "vl.vmrgw.vsvMvl" => "__builtin_ve_vl_vmrgw_vsvMvl",
                    "vl.vmrgw.vvvMl" => "__builtin_ve_vl_vmrgw_vvvMl",
                    "vl.vmrgw.vvvMvl" => "__builtin_ve_vl_vmrgw_vvvMvl",
                    "vl.vmulsl.vsvl" => "__builtin_ve_vl_vmulsl_vsvl",
                    "vl.vmulsl.vsvmvl" => "__builtin_ve_vl_vmulsl_vsvmvl",
                    "vl.vmulsl.vsvvl" => "__builtin_ve_vl_vmulsl_vsvvl",
                    "vl.vmulsl.vvvl" => "__builtin_ve_vl_vmulsl_vvvl",
                    "vl.vmulsl.vvvmvl" => "__builtin_ve_vl_vmulsl_vvvmvl",
                    "vl.vmulsl.vvvvl" => "__builtin_ve_vl_vmulsl_vvvvl",
                    "vl.vmulslw.vsvl" => "__builtin_ve_vl_vmulslw_vsvl",
                    "vl.vmulslw.vsvvl" => "__builtin_ve_vl_vmulslw_vsvvl",
                    "vl.vmulslw.vvvl" => "__builtin_ve_vl_vmulslw_vvvl",
                    "vl.vmulslw.vvvvl" => "__builtin_ve_vl_vmulslw_vvvvl",
                    "vl.vmulswsx.vsvl" => "__builtin_ve_vl_vmulswsx_vsvl",
                    "vl.vmulswsx.vsvmvl" => "__builtin_ve_vl_vmulswsx_vsvmvl",
                    "vl.vmulswsx.vsvvl" => "__builtin_ve_vl_vmulswsx_vsvvl",
                    "vl.vmulswsx.vvvl" => "__builtin_ve_vl_vmulswsx_vvvl",
                    "vl.vmulswsx.vvvmvl" => "__builtin_ve_vl_vmulswsx_vvvmvl",
                    "vl.vmulswsx.vvvvl" => "__builtin_ve_vl_vmulswsx_vvvvl",
                    "vl.vmulswzx.vsvl" => "__builtin_ve_vl_vmulswzx_vsvl",
                    "vl.vmulswzx.vsvmvl" => "__builtin_ve_vl_vmulswzx_vsvmvl",
                    "vl.vmulswzx.vsvvl" => "__builtin_ve_vl_vmulswzx_vsvvl",
                    "vl.vmulswzx.vvvl" => "__builtin_ve_vl_vmulswzx_vvvl",
                    "vl.vmulswzx.vvvmvl" => "__builtin_ve_vl_vmulswzx_vvvmvl",
                    "vl.vmulswzx.vvvvl" => "__builtin_ve_vl_vmulswzx_vvvvl",
                    "vl.vmulul.vsvl" => "__builtin_ve_vl_vmulul_vsvl",
                    "vl.vmulul.vsvmvl" => "__builtin_ve_vl_vmulul_vsvmvl",
                    "vl.vmulul.vsvvl" => "__builtin_ve_vl_vmulul_vsvvl",
                    "vl.vmulul.vvvl" => "__builtin_ve_vl_vmulul_vvvl",
                    "vl.vmulul.vvvmvl" => "__builtin_ve_vl_vmulul_vvvmvl",
                    "vl.vmulul.vvvvl" => "__builtin_ve_vl_vmulul_vvvvl",
                    "vl.vmuluw.vsvl" => "__builtin_ve_vl_vmuluw_vsvl",
                    "vl.vmuluw.vsvmvl" => "__builtin_ve_vl_vmuluw_vsvmvl",
                    "vl.vmuluw.vsvvl" => "__builtin_ve_vl_vmuluw_vsvvl",
                    "vl.vmuluw.vvvl" => "__builtin_ve_vl_vmuluw_vvvl",
                    "vl.vmuluw.vvvmvl" => "__builtin_ve_vl_vmuluw_vvvmvl",
                    "vl.vmuluw.vvvvl" => "__builtin_ve_vl_vmuluw_vvvvl",
                    "vl.vmv.vsvl" => "__builtin_ve_vl_vmv_vsvl",
                    "vl.vmv.vsvmvl" => "__builtin_ve_vl_vmv_vsvmvl",
                    "vl.vmv.vsvvl" => "__builtin_ve_vl_vmv_vsvvl",
                    "vl.vor.vsvl" => "__builtin_ve_vl_vor_vsvl",
                    "vl.vor.vsvmvl" => "__builtin_ve_vl_vor_vsvmvl",
                    "vl.vor.vsvvl" => "__builtin_ve_vl_vor_vsvvl",
                    "vl.vor.vvvl" => "__builtin_ve_vl_vor_vvvl",
                    "vl.vor.vvvmvl" => "__builtin_ve_vl_vor_vvvmvl",
                    "vl.vor.vvvvl" => "__builtin_ve_vl_vor_vvvvl",
                    "vl.vpcnt.vvl" => "__builtin_ve_vl_vpcnt_vvl",
                    "vl.vpcnt.vvmvl" => "__builtin_ve_vl_vpcnt_vvmvl",
                    "vl.vpcnt.vvvl" => "__builtin_ve_vl_vpcnt_vvvl",
                    "vl.vrand.vvl" => "__builtin_ve_vl_vrand_vvl",
                    "vl.vrand.vvml" => "__builtin_ve_vl_vrand_vvml",
                    "vl.vrcpd.vvl" => "__builtin_ve_vl_vrcpd_vvl",
                    "vl.vrcpd.vvvl" => "__builtin_ve_vl_vrcpd_vvvl",
                    "vl.vrcps.vvl" => "__builtin_ve_vl_vrcps_vvl",
                    "vl.vrcps.vvvl" => "__builtin_ve_vl_vrcps_vvvl",
                    "vl.vrmaxslfst.vvl" => "__builtin_ve_vl_vrmaxslfst_vvl",
                    "vl.vrmaxslfst.vvvl" => "__builtin_ve_vl_vrmaxslfst_vvvl",
                    "vl.vrmaxsllst.vvl" => "__builtin_ve_vl_vrmaxsllst_vvl",
                    "vl.vrmaxsllst.vvvl" => "__builtin_ve_vl_vrmaxsllst_vvvl",
                    "vl.vrmaxswfstsx.vvl" => "__builtin_ve_vl_vrmaxswfstsx_vvl",
                    "vl.vrmaxswfstsx.vvvl" => "__builtin_ve_vl_vrmaxswfstsx_vvvl",
                    "vl.vrmaxswfstzx.vvl" => "__builtin_ve_vl_vrmaxswfstzx_vvl",
                    "vl.vrmaxswfstzx.vvvl" => "__builtin_ve_vl_vrmaxswfstzx_vvvl",
                    "vl.vrmaxswlstsx.vvl" => "__builtin_ve_vl_vrmaxswlstsx_vvl",
                    "vl.vrmaxswlstsx.vvvl" => "__builtin_ve_vl_vrmaxswlstsx_vvvl",
                    "vl.vrmaxswlstzx.vvl" => "__builtin_ve_vl_vrmaxswlstzx_vvl",
                    "vl.vrmaxswlstzx.vvvl" => "__builtin_ve_vl_vrmaxswlstzx_vvvl",
                    "vl.vrminslfst.vvl" => "__builtin_ve_vl_vrminslfst_vvl",
                    "vl.vrminslfst.vvvl" => "__builtin_ve_vl_vrminslfst_vvvl",
                    "vl.vrminsllst.vvl" => "__builtin_ve_vl_vrminsllst_vvl",
                    "vl.vrminsllst.vvvl" => "__builtin_ve_vl_vrminsllst_vvvl",
                    "vl.vrminswfstsx.vvl" => "__builtin_ve_vl_vrminswfstsx_vvl",
                    "vl.vrminswfstsx.vvvl" => "__builtin_ve_vl_vrminswfstsx_vvvl",
                    "vl.vrminswfstzx.vvl" => "__builtin_ve_vl_vrminswfstzx_vvl",
                    "vl.vrminswfstzx.vvvl" => "__builtin_ve_vl_vrminswfstzx_vvvl",
                    "vl.vrminswlstsx.vvl" => "__builtin_ve_vl_vrminswlstsx_vvl",
                    "vl.vrminswlstsx.vvvl" => "__builtin_ve_vl_vrminswlstsx_vvvl",
                    "vl.vrminswlstzx.vvl" => "__builtin_ve_vl_vrminswlstzx_vvl",
                    "vl.vrminswlstzx.vvvl" => "__builtin_ve_vl_vrminswlstzx_vvvl",
                    "vl.vror.vvl" => "__builtin_ve_vl_vror_vvl",
                    "vl.vror.vvml" => "__builtin_ve_vl_vror_vvml",
                    "vl.vrsqrtd.vvl" => "__builtin_ve_vl_vrsqrtd_vvl",
                    "vl.vrsqrtd.vvvl" => "__builtin_ve_vl_vrsqrtd_vvvl",
                    "vl.vrsqrtdnex.vvl" => "__builtin_ve_vl_vrsqrtdnex_vvl",
                    "vl.vrsqrtdnex.vvvl" => "__builtin_ve_vl_vrsqrtdnex_vvvl",
                    "vl.vrsqrts.vvl" => "__builtin_ve_vl_vrsqrts_vvl",
                    "vl.vrsqrts.vvvl" => "__builtin_ve_vl_vrsqrts_vvvl",
                    "vl.vrsqrtsnex.vvl" => "__builtin_ve_vl_vrsqrtsnex_vvl",
                    "vl.vrsqrtsnex.vvvl" => "__builtin_ve_vl_vrsqrtsnex_vvvl",
                    "vl.vrxor.vvl" => "__builtin_ve_vl_vrxor_vvl",
                    "vl.vrxor.vvml" => "__builtin_ve_vl_vrxor_vvml",
                    "vl.vsc.vvssl" => "__builtin_ve_vl_vsc_vvssl",
                    "vl.vsc.vvssml" => "__builtin_ve_vl_vsc_vvssml",
                    "vl.vscl.vvssl" => "__builtin_ve_vl_vscl_vvssl",
                    "vl.vscl.vvssml" => "__builtin_ve_vl_vscl_vvssml",
                    "vl.vsclnc.vvssl" => "__builtin_ve_vl_vsclnc_vvssl",
                    "vl.vsclnc.vvssml" => "__builtin_ve_vl_vsclnc_vvssml",
                    "vl.vsclncot.vvssl" => "__builtin_ve_vl_vsclncot_vvssl",
                    "vl.vsclncot.vvssml" => "__builtin_ve_vl_vsclncot_vvssml",
                    "vl.vsclot.vvssl" => "__builtin_ve_vl_vsclot_vvssl",
                    "vl.vsclot.vvssml" => "__builtin_ve_vl_vsclot_vvssml",
                    "vl.vscnc.vvssl" => "__builtin_ve_vl_vscnc_vvssl",
                    "vl.vscnc.vvssml" => "__builtin_ve_vl_vscnc_vvssml",
                    "vl.vscncot.vvssl" => "__builtin_ve_vl_vscncot_vvssl",
                    "vl.vscncot.vvssml" => "__builtin_ve_vl_vscncot_vvssml",
                    "vl.vscot.vvssl" => "__builtin_ve_vl_vscot_vvssl",
                    "vl.vscot.vvssml" => "__builtin_ve_vl_vscot_vvssml",
                    "vl.vscu.vvssl" => "__builtin_ve_vl_vscu_vvssl",
                    "vl.vscu.vvssml" => "__builtin_ve_vl_vscu_vvssml",
                    "vl.vscunc.vvssl" => "__builtin_ve_vl_vscunc_vvssl",
                    "vl.vscunc.vvssml" => "__builtin_ve_vl_vscunc_vvssml",
                    "vl.vscuncot.vvssl" => "__builtin_ve_vl_vscuncot_vvssl",
                    "vl.vscuncot.vvssml" => "__builtin_ve_vl_vscuncot_vvssml",
                    "vl.vscuot.vvssl" => "__builtin_ve_vl_vscuot_vvssl",
                    "vl.vscuot.vvssml" => "__builtin_ve_vl_vscuot_vvssml",
                    "vl.vseq.vl" => "__builtin_ve_vl_vseq_vl",
                    "vl.vseq.vvl" => "__builtin_ve_vl_vseq_vvl",
                    "vl.vsfa.vvssl" => "__builtin_ve_vl_vsfa_vvssl",
                    "vl.vsfa.vvssmvl" => "__builtin_ve_vl_vsfa_vvssmvl",
                    "vl.vsfa.vvssvl" => "__builtin_ve_vl_vsfa_vvssvl",
                    "vl.vshf.vvvsl" => "__builtin_ve_vl_vshf_vvvsl",
                    "vl.vshf.vvvsvl" => "__builtin_ve_vl_vshf_vvvsvl",
                    "vl.vslal.vvsl" => "__builtin_ve_vl_vslal_vvsl",
                    "vl.vslal.vvsmvl" => "__builtin_ve_vl_vslal_vvsmvl",
                    "vl.vslal.vvsvl" => "__builtin_ve_vl_vslal_vvsvl",
                    "vl.vslal.vvvl" => "__builtin_ve_vl_vslal_vvvl",
                    "vl.vslal.vvvmvl" => "__builtin_ve_vl_vslal_vvvmvl",
                    "vl.vslal.vvvvl" => "__builtin_ve_vl_vslal_vvvvl",
                    "vl.vslawsx.vvsl" => "__builtin_ve_vl_vslawsx_vvsl",
                    "vl.vslawsx.vvsmvl" => "__builtin_ve_vl_vslawsx_vvsmvl",
                    "vl.vslawsx.vvsvl" => "__builtin_ve_vl_vslawsx_vvsvl",
                    "vl.vslawsx.vvvl" => "__builtin_ve_vl_vslawsx_vvvl",
                    "vl.vslawsx.vvvmvl" => "__builtin_ve_vl_vslawsx_vvvmvl",
                    "vl.vslawsx.vvvvl" => "__builtin_ve_vl_vslawsx_vvvvl",
                    "vl.vslawzx.vvsl" => "__builtin_ve_vl_vslawzx_vvsl",
                    "vl.vslawzx.vvsmvl" => "__builtin_ve_vl_vslawzx_vvsmvl",
                    "vl.vslawzx.vvsvl" => "__builtin_ve_vl_vslawzx_vvsvl",
                    "vl.vslawzx.vvvl" => "__builtin_ve_vl_vslawzx_vvvl",
                    "vl.vslawzx.vvvmvl" => "__builtin_ve_vl_vslawzx_vvvmvl",
                    "vl.vslawzx.vvvvl" => "__builtin_ve_vl_vslawzx_vvvvl",
                    "vl.vsll.vvsl" => "__builtin_ve_vl_vsll_vvsl",
                    "vl.vsll.vvsmvl" => "__builtin_ve_vl_vsll_vvsmvl",
                    "vl.vsll.vvsvl" => "__builtin_ve_vl_vsll_vvsvl",
                    "vl.vsll.vvvl" => "__builtin_ve_vl_vsll_vvvl",
                    "vl.vsll.vvvmvl" => "__builtin_ve_vl_vsll_vvvmvl",
                    "vl.vsll.vvvvl" => "__builtin_ve_vl_vsll_vvvvl",
                    "vl.vsral.vvsl" => "__builtin_ve_vl_vsral_vvsl",
                    "vl.vsral.vvsmvl" => "__builtin_ve_vl_vsral_vvsmvl",
                    "vl.vsral.vvsvl" => "__builtin_ve_vl_vsral_vvsvl",
                    "vl.vsral.vvvl" => "__builtin_ve_vl_vsral_vvvl",
                    "vl.vsral.vvvmvl" => "__builtin_ve_vl_vsral_vvvmvl",
                    "vl.vsral.vvvvl" => "__builtin_ve_vl_vsral_vvvvl",
                    "vl.vsrawsx.vvsl" => "__builtin_ve_vl_vsrawsx_vvsl",
                    "vl.vsrawsx.vvsmvl" => "__builtin_ve_vl_vsrawsx_vvsmvl",
                    "vl.vsrawsx.vvsvl" => "__builtin_ve_vl_vsrawsx_vvsvl",
                    "vl.vsrawsx.vvvl" => "__builtin_ve_vl_vsrawsx_vvvl",
                    "vl.vsrawsx.vvvmvl" => "__builtin_ve_vl_vsrawsx_vvvmvl",
                    "vl.vsrawsx.vvvvl" => "__builtin_ve_vl_vsrawsx_vvvvl",
                    "vl.vsrawzx.vvsl" => "__builtin_ve_vl_vsrawzx_vvsl",
                    "vl.vsrawzx.vvsmvl" => "__builtin_ve_vl_vsrawzx_vvsmvl",
                    "vl.vsrawzx.vvsvl" => "__builtin_ve_vl_vsrawzx_vvsvl",
                    "vl.vsrawzx.vvvl" => "__builtin_ve_vl_vsrawzx_vvvl",
                    "vl.vsrawzx.vvvmvl" => "__builtin_ve_vl_vsrawzx_vvvmvl",
                    "vl.vsrawzx.vvvvl" => "__builtin_ve_vl_vsrawzx_vvvvl",
                    "vl.vsrl.vvsl" => "__builtin_ve_vl_vsrl_vvsl",
                    "vl.vsrl.vvsmvl" => "__builtin_ve_vl_vsrl_vvsmvl",
                    "vl.vsrl.vvsvl" => "__builtin_ve_vl_vsrl_vvsvl",
                    "vl.vsrl.vvvl" => "__builtin_ve_vl_vsrl_vvvl",
                    "vl.vsrl.vvvmvl" => "__builtin_ve_vl_vsrl_vvvmvl",
                    "vl.vsrl.vvvvl" => "__builtin_ve_vl_vsrl_vvvvl",
                    "vl.vst.vssl" => "__builtin_ve_vl_vst_vssl",
                    "vl.vst.vssml" => "__builtin_ve_vl_vst_vssml",
                    "vl.vst2d.vssl" => "__builtin_ve_vl_vst2d_vssl",
                    "vl.vst2d.vssml" => "__builtin_ve_vl_vst2d_vssml",
                    "vl.vst2dnc.vssl" => "__builtin_ve_vl_vst2dnc_vssl",
                    "vl.vst2dnc.vssml" => "__builtin_ve_vl_vst2dnc_vssml",
                    "vl.vst2dncot.vssl" => "__builtin_ve_vl_vst2dncot_vssl",
                    "vl.vst2dncot.vssml" => "__builtin_ve_vl_vst2dncot_vssml",
                    "vl.vst2dot.vssl" => "__builtin_ve_vl_vst2dot_vssl",
                    "vl.vst2dot.vssml" => "__builtin_ve_vl_vst2dot_vssml",
                    "vl.vstl.vssl" => "__builtin_ve_vl_vstl_vssl",
                    "vl.vstl.vssml" => "__builtin_ve_vl_vstl_vssml",
                    "vl.vstl2d.vssl" => "__builtin_ve_vl_vstl2d_vssl",
                    "vl.vstl2d.vssml" => "__builtin_ve_vl_vstl2d_vssml",
                    "vl.vstl2dnc.vssl" => "__builtin_ve_vl_vstl2dnc_vssl",
                    "vl.vstl2dnc.vssml" => "__builtin_ve_vl_vstl2dnc_vssml",
                    "vl.vstl2dncot.vssl" => "__builtin_ve_vl_vstl2dncot_vssl",
                    "vl.vstl2dncot.vssml" => "__builtin_ve_vl_vstl2dncot_vssml",
                    "vl.vstl2dot.vssl" => "__builtin_ve_vl_vstl2dot_vssl",
                    "vl.vstl2dot.vssml" => "__builtin_ve_vl_vstl2dot_vssml",
                    "vl.vstlnc.vssl" => "__builtin_ve_vl_vstlnc_vssl",
                    "vl.vstlnc.vssml" => "__builtin_ve_vl_vstlnc_vssml",
                    "vl.vstlncot.vssl" => "__builtin_ve_vl_vstlncot_vssl",
                    "vl.vstlncot.vssml" => "__builtin_ve_vl_vstlncot_vssml",
                    "vl.vstlot.vssl" => "__builtin_ve_vl_vstlot_vssl",
                    "vl.vstlot.vssml" => "__builtin_ve_vl_vstlot_vssml",
                    "vl.vstnc.vssl" => "__builtin_ve_vl_vstnc_vssl",
                    "vl.vstnc.vssml" => "__builtin_ve_vl_vstnc_vssml",
                    "vl.vstncot.vssl" => "__builtin_ve_vl_vstncot_vssl",
                    "vl.vstncot.vssml" => "__builtin_ve_vl_vstncot_vssml",
                    "vl.vstot.vssl" => "__builtin_ve_vl_vstot_vssl",
                    "vl.vstot.vssml" => "__builtin_ve_vl_vstot_vssml",
                    "vl.vstu.vssl" => "__builtin_ve_vl_vstu_vssl",
                    "vl.vstu.vssml" => "__builtin_ve_vl_vstu_vssml",
                    "vl.vstu2d.vssl" => "__builtin_ve_vl_vstu2d_vssl",
                    "vl.vstu2d.vssml" => "__builtin_ve_vl_vstu2d_vssml",
                    "vl.vstu2dnc.vssl" => "__builtin_ve_vl_vstu2dnc_vssl",
                    "vl.vstu2dnc.vssml" => "__builtin_ve_vl_vstu2dnc_vssml",
                    "vl.vstu2dncot.vssl" => "__builtin_ve_vl_vstu2dncot_vssl",
                    "vl.vstu2dncot.vssml" => "__builtin_ve_vl_vstu2dncot_vssml",
                    "vl.vstu2dot.vssl" => "__builtin_ve_vl_vstu2dot_vssl",
                    "vl.vstu2dot.vssml" => "__builtin_ve_vl_vstu2dot_vssml",
                    "vl.vstunc.vssl" => "__builtin_ve_vl_vstunc_vssl",
                    "vl.vstunc.vssml" => "__builtin_ve_vl_vstunc_vssml",
                    "vl.vstuncot.vssl" => "__builtin_ve_vl_vstuncot_vssl",
                    "vl.vstuncot.vssml" => "__builtin_ve_vl_vstuncot_vssml",
                    "vl.vstuot.vssl" => "__builtin_ve_vl_vstuot_vssl",
                    "vl.vstuot.vssml" => "__builtin_ve_vl_vstuot_vssml",
                    "vl.vsubsl.vsvl" => "__builtin_ve_vl_vsubsl_vsvl",
                    "vl.vsubsl.vsvmvl" => "__builtin_ve_vl_vsubsl_vsvmvl",
                    "vl.vsubsl.vsvvl" => "__builtin_ve_vl_vsubsl_vsvvl",
                    "vl.vsubsl.vvvl" => "__builtin_ve_vl_vsubsl_vvvl",
                    "vl.vsubsl.vvvmvl" => "__builtin_ve_vl_vsubsl_vvvmvl",
                    "vl.vsubsl.vvvvl" => "__builtin_ve_vl_vsubsl_vvvvl",
                    "vl.vsubswsx.vsvl" => "__builtin_ve_vl_vsubswsx_vsvl",
                    "vl.vsubswsx.vsvmvl" => "__builtin_ve_vl_vsubswsx_vsvmvl",
                    "vl.vsubswsx.vsvvl" => "__builtin_ve_vl_vsubswsx_vsvvl",
                    "vl.vsubswsx.vvvl" => "__builtin_ve_vl_vsubswsx_vvvl",
                    "vl.vsubswsx.vvvmvl" => "__builtin_ve_vl_vsubswsx_vvvmvl",
                    "vl.vsubswsx.vvvvl" => "__builtin_ve_vl_vsubswsx_vvvvl",
                    "vl.vsubswzx.vsvl" => "__builtin_ve_vl_vsubswzx_vsvl",
                    "vl.vsubswzx.vsvmvl" => "__builtin_ve_vl_vsubswzx_vsvmvl",
                    "vl.vsubswzx.vsvvl" => "__builtin_ve_vl_vsubswzx_vsvvl",
                    "vl.vsubswzx.vvvl" => "__builtin_ve_vl_vsubswzx_vvvl",
                    "vl.vsubswzx.vvvmvl" => "__builtin_ve_vl_vsubswzx_vvvmvl",
                    "vl.vsubswzx.vvvvl" => "__builtin_ve_vl_vsubswzx_vvvvl",
                    "vl.vsubul.vsvl" => "__builtin_ve_vl_vsubul_vsvl",
                    "vl.vsubul.vsvmvl" => "__builtin_ve_vl_vsubul_vsvmvl",
                    "vl.vsubul.vsvvl" => "__builtin_ve_vl_vsubul_vsvvl",
                    "vl.vsubul.vvvl" => "__builtin_ve_vl_vsubul_vvvl",
                    "vl.vsubul.vvvmvl" => "__builtin_ve_vl_vsubul_vvvmvl",
                    "vl.vsubul.vvvvl" => "__builtin_ve_vl_vsubul_vvvvl",
                    "vl.vsubuw.vsvl" => "__builtin_ve_vl_vsubuw_vsvl",
                    "vl.vsubuw.vsvmvl" => "__builtin_ve_vl_vsubuw_vsvmvl",
                    "vl.vsubuw.vsvvl" => "__builtin_ve_vl_vsubuw_vsvvl",
                    "vl.vsubuw.vvvl" => "__builtin_ve_vl_vsubuw_vvvl",
                    "vl.vsubuw.vvvmvl" => "__builtin_ve_vl_vsubuw_vvvmvl",
                    "vl.vsubuw.vvvvl" => "__builtin_ve_vl_vsubuw_vvvvl",
                    "vl.vsuml.vvl" => "__builtin_ve_vl_vsuml_vvl",
                    "vl.vsuml.vvml" => "__builtin_ve_vl_vsuml_vvml",
                    "vl.vsumwsx.vvl" => "__builtin_ve_vl_vsumwsx_vvl",
                    "vl.vsumwsx.vvml" => "__builtin_ve_vl_vsumwsx_vvml",
                    "vl.vsumwzx.vvl" => "__builtin_ve_vl_vsumwzx_vvl",
                    "vl.vsumwzx.vvml" => "__builtin_ve_vl_vsumwzx_vvml",
                    "vl.vxor.vsvl" => "__builtin_ve_vl_vxor_vsvl",
                    "vl.vxor.vsvmvl" => "__builtin_ve_vl_vxor_vsvmvl",
                    "vl.vxor.vsvvl" => "__builtin_ve_vl_vxor_vsvvl",
                    "vl.vxor.vvvl" => "__builtin_ve_vl_vxor_vvvl",
                    "vl.vxor.vvvmvl" => "__builtin_ve_vl_vxor_vvvmvl",
                    "vl.vxor.vvvvl" => "__builtin_ve_vl_vxor_vvvvl",
                    "vl.xorm.MMM" => "__builtin_ve_vl_xorm_MMM",
                    "vl.xorm.mmm" => "__builtin_ve_vl_xorm_mmm",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            ve(name, full_name)
        }
        "x86" => {
            fn x86(name: &str, full_name: &str) -> &'static str {
                match name {
                    // x86
                    "aadd32" => "__builtin_ia32_aadd32",
                    "aadd64" => "__builtin_ia32_aadd64",
                    "aand32" => "__builtin_ia32_aand32",
                    "aand64" => "__builtin_ia32_aand64",
                    "addcarry.u32" => "__builtin_ia32_addcarry_u32",
                    "addcarry.u64" => "__builtin_ia32_addcarry_u64",
                    "addcarryx.u32" => "__builtin_ia32_addcarryx_u32",
                    "addcarryx.u64" => "__builtin_ia32_addcarryx_u64",
                    "aesni.aesdec" => "__builtin_ia32_aesdec128",
                    "aesni.aesdec.256" => "__builtin_ia32_aesdec256",
                    "aesni.aesdec.512" => "__builtin_ia32_aesdec512",
                    "aesni.aesdeclast" => "__builtin_ia32_aesdeclast128",
                    "aesni.aesdeclast.256" => "__builtin_ia32_aesdeclast256",
                    "aesni.aesdeclast.512" => "__builtin_ia32_aesdeclast512",
                    "aesni.aesenc" => "__builtin_ia32_aesenc128",
                    "aesni.aesenc.256" => "__builtin_ia32_aesenc256",
                    "aesni.aesenc.512" => "__builtin_ia32_aesenc512",
                    "aesni.aesenclast" => "__builtin_ia32_aesenclast128",
                    "aesni.aesenclast.256" => "__builtin_ia32_aesenclast256",
                    "aesni.aesenclast.512" => "__builtin_ia32_aesenclast512",
                    "aesni.aesimc" => "__builtin_ia32_aesimc128",
                    "aesni.aeskeygenassist" => "__builtin_ia32_aeskeygenassist128",
                    "aor32" => "__builtin_ia32_aor32",
                    "aor64" => "__builtin_ia32_aor64",
                    "avx.addsub.pd.256" => "__builtin_ia32_addsubpd256",
                    "avx.addsub.ps.256" => "__builtin_ia32_addsubps256",
                    "avx.blend.pd.256" => "__builtin_ia32_blendpd256",
                    "avx.blend.ps.256" => "__builtin_ia32_blendps256",
                    "avx.blendv.pd.256" => "__builtin_ia32_blendvpd256",
                    "avx.blendv.ps.256" => "__builtin_ia32_blendvps256",
                    "avx.cmp.pd.256" => "__builtin_ia32_cmppd256",
                    "avx.cmp.ps.256" => "__builtin_ia32_cmpps256",
                    "avx.cvt.pd2.ps.256" => "__builtin_ia32_cvtpd2ps256",
                    "avx.cvt.pd2dq.256" => "__builtin_ia32_cvtpd2dq256",
                    "avx.cvt.ps2.pd.256" => "__builtin_ia32_cvtps2pd256",
                    "avx.cvt.ps2dq.256" => "__builtin_ia32_cvtps2dq256",
                    "avx.cvtdq2.pd.256" => "__builtin_ia32_cvtdq2pd256",
                    "avx.cvtdq2.ps.256" => "__builtin_ia32_cvtdq2ps256",
                    "avx.cvtt.pd2dq.256" => "__builtin_ia32_cvttpd2dq256",
                    "avx.cvtt.ps2dq.256" => "__builtin_ia32_cvttps2dq256",
                    "avx.dp.ps.256" => "__builtin_ia32_dpps256",
                    "avx.hadd.pd.256" => "__builtin_ia32_haddpd256",
                    "avx.hadd.ps.256" => "__builtin_ia32_haddps256",
                    "avx.hsub.pd.256" => "__builtin_ia32_hsubpd256",
                    "avx.hsub.ps.256" => "__builtin_ia32_hsubps256",
                    "avx.ldu.dq.256" => "__builtin_ia32_lddqu256",
                    "avx.maskload.pd" => "__builtin_ia32_maskloadpd",
                    "avx.maskload.pd.256" => "__builtin_ia32_maskloadpd256",
                    "avx.maskload.ps" => "__builtin_ia32_maskloadps",
                    "avx.maskload.ps.256" => "__builtin_ia32_maskloadps256",
                    "avx.maskstore.pd" => "__builtin_ia32_maskstorepd",
                    "avx.maskstore.pd.256" => "__builtin_ia32_maskstorepd256",
                    "avx.maskstore.ps" => "__builtin_ia32_maskstoreps",
                    "avx.maskstore.ps.256" => "__builtin_ia32_maskstoreps256",
                    "avx.max.pd.256" => "__builtin_ia32_maxpd256",
                    "avx.max.ps.256" => "__builtin_ia32_maxps256",
                    "avx.min.pd.256" => "__builtin_ia32_minpd256",
                    "avx.min.ps.256" => "__builtin_ia32_minps256",
                    "avx.movmsk.pd.256" => "__builtin_ia32_movmskpd256",
                    "avx.movmsk.ps.256" => "__builtin_ia32_movmskps256",
                    "avx.ptestc.256" => "__builtin_ia32_ptestc256",
                    "avx.ptestnzc.256" => "__builtin_ia32_ptestnzc256",
                    "avx.ptestz.256" => "__builtin_ia32_ptestz256",
                    "avx.rcp.ps.256" => "__builtin_ia32_rcpps256",
                    "avx.round.pd.256" => "__builtin_ia32_roundpd256",
                    "avx.round.ps.256" => "__builtin_ia32_roundps256",
                    "avx.rsqrt.ps.256" => "__builtin_ia32_rsqrtps256",
                    "avx.sqrt.pd.256" => "__builtin_ia32_sqrtpd256",
                    "avx.sqrt.ps.256" => "__builtin_ia32_sqrtps256",
                    "avx.storeu.dq.256" => "__builtin_ia32_storedqu256",
                    "avx.storeu.pd.256" => "__builtin_ia32_storeupd256",
                    "avx.storeu.ps.256" => "__builtin_ia32_storeups256",
                    "avx.vbroadcastf128.pd.256" => "__builtin_ia32_vbroadcastf128_pd256",
                    "avx.vbroadcastf128.ps.256" => "__builtin_ia32_vbroadcastf128_ps256",
                    "avx.vextractf128.pd.256" => "__builtin_ia32_vextractf128_pd256",
                    "avx.vextractf128.ps.256" => "__builtin_ia32_vextractf128_ps256",
                    "avx.vextractf128.si.256" => "__builtin_ia32_vextractf128_si256",
                    "avx.vinsertf128.pd.256" => "__builtin_ia32_vinsertf128_pd256",
                    "avx.vinsertf128.ps.256" => "__builtin_ia32_vinsertf128_ps256",
                    "avx.vinsertf128.si.256" => "__builtin_ia32_vinsertf128_si256",
                    "avx.vperm2f128.pd.256" => "__builtin_ia32_vperm2f128_pd256",
                    "avx.vperm2f128.ps.256" => "__builtin_ia32_vperm2f128_ps256",
                    "avx.vperm2f128.si.256" => "__builtin_ia32_vperm2f128_si256",
                    "avx.vpermilvar.pd" => "__builtin_ia32_vpermilvarpd",
                    "avx.vpermilvar.pd.256" => "__builtin_ia32_vpermilvarpd256",
                    "avx.vpermilvar.ps" => "__builtin_ia32_vpermilvarps",
                    "avx.vpermilvar.ps.256" => "__builtin_ia32_vpermilvarps256",
                    "avx.vtestc.pd" => "__builtin_ia32_vtestcpd",
                    "avx.vtestc.pd.256" => "__builtin_ia32_vtestcpd256",
                    "avx.vtestc.ps" => "__builtin_ia32_vtestcps",
                    "avx.vtestc.ps.256" => "__builtin_ia32_vtestcps256",
                    "avx.vtestnzc.pd" => "__builtin_ia32_vtestnzcpd",
                    "avx.vtestnzc.pd.256" => "__builtin_ia32_vtestnzcpd256",
                    "avx.vtestnzc.ps" => "__builtin_ia32_vtestnzcps",
                    "avx.vtestnzc.ps.256" => "__builtin_ia32_vtestnzcps256",
                    "avx.vtestz.pd" => "__builtin_ia32_vtestzpd",
                    "avx.vtestz.pd.256" => "__builtin_ia32_vtestzpd256",
                    "avx.vtestz.ps" => "__builtin_ia32_vtestzps",
                    "avx.vtestz.ps.256" => "__builtin_ia32_vtestzps256",
                    "avx.vzeroall" => "__builtin_ia32_vzeroall",
                    "avx.vzeroupper" => "__builtin_ia32_vzeroupper",
                    "avx10.mask.getexp.bf16.128" => "__builtin_ia32_vgetexpbf16128_mask",
                    "avx10.mask.getexp.bf16.256" => "__builtin_ia32_vgetexpbf16256_mask",
                    "avx10.mask.getexp.bf16.512" => "__builtin_ia32_vgetexpbf16512_mask",
                    "avx10.mask.getmant.bf16.128" => "__builtin_ia32_vgetmantbf16128_mask",
                    "avx10.mask.getmant.bf16.256" => "__builtin_ia32_vgetmantbf16256_mask",
                    "avx10.mask.getmant.bf16.512" => "__builtin_ia32_vgetmantbf16512_mask",
                    "avx10.mask.rcp.bf16.128" => "__builtin_ia32_vrcpbf16128_mask",
                    "avx10.mask.rcp.bf16.256" => "__builtin_ia32_vrcpbf16256_mask",
                    "avx10.mask.rcp.bf16.512" => "__builtin_ia32_vrcpbf16512_mask",
                    "avx10.mask.reduce.bf16.128" => "__builtin_ia32_vreducebf16128_mask",
                    "avx10.mask.reduce.bf16.256" => "__builtin_ia32_vreducebf16256_mask",
                    "avx10.mask.reduce.bf16.512" => "__builtin_ia32_vreducebf16512_mask",
                    "avx10.mask.rndscale.bf16.128" => "__builtin_ia32_vrndscalebf16_128_mask",
                    "avx10.mask.rndscale.bf16.256" => "__builtin_ia32_vrndscalebf16_256_mask",
                    "avx10.mask.rndscale.bf16.512" => "__builtin_ia32_vrndscalebf16_mask",
                    "avx10.mask.rsqrt.bf16.128" => "__builtin_ia32_vrsqrtbf16128_mask",
                    "avx10.mask.rsqrt.bf16.256" => "__builtin_ia32_vrsqrtbf16256_mask",
                    "avx10.mask.rsqrt.bf16.512" => "__builtin_ia32_vrsqrtbf16512_mask",
                    "avx10.mask.scalef.bf16.128" => "__builtin_ia32_vscalefbf16128_mask",
                    "avx10.mask.scalef.bf16.256" => "__builtin_ia32_vscalefbf16256_mask",
                    "avx10.mask.scalef.bf16.512" => "__builtin_ia32_vscalefbf16512_mask",
                    "avx10.mask.vcvt2ps2phx.128" => "__builtin_ia32_vcvt2ps2phx128_mask",
                    "avx10.mask.vcvt2ps2phx.256" => "__builtin_ia32_vcvt2ps2phx256_mask",
                    "avx10.mask.vcvt2ps2phx.512" => "__builtin_ia32_vcvt2ps2phx512_mask",
                    "avx10.mask.vcvtbiasph2bf8128" => "__builtin_ia32_vcvtbiasph2bf8_128_mask",
                    "avx10.mask.vcvtbiasph2bf8256" => "__builtin_ia32_vcvtbiasph2bf8_256_mask",
                    "avx10.mask.vcvtbiasph2bf8512" => "__builtin_ia32_vcvtbiasph2bf8_512_mask",
                    "avx10.mask.vcvtbiasph2bf8s128" => "__builtin_ia32_vcvtbiasph2bf8s_128_mask",
                    "avx10.mask.vcvtbiasph2bf8s256" => "__builtin_ia32_vcvtbiasph2bf8s_256_mask",
                    "avx10.mask.vcvtbiasph2bf8s512" => "__builtin_ia32_vcvtbiasph2bf8s_512_mask",
                    "avx10.mask.vcvtbiasph2hf8128" => "__builtin_ia32_vcvtbiasph2hf8_128_mask",
                    "avx10.mask.vcvtbiasph2hf8256" => "__builtin_ia32_vcvtbiasph2hf8_256_mask",
                    "avx10.mask.vcvtbiasph2hf8512" => "__builtin_ia32_vcvtbiasph2hf8_512_mask",
                    "avx10.mask.vcvtbiasph2hf8s128" => "__builtin_ia32_vcvtbiasph2hf8s_128_mask",
                    "avx10.mask.vcvtbiasph2hf8s256" => "__builtin_ia32_vcvtbiasph2hf8s_256_mask",
                    "avx10.mask.vcvtbiasph2hf8s512" => "__builtin_ia32_vcvtbiasph2hf8s_512_mask",
                    "avx10.mask.vcvthf82ph128" => "__builtin_ia32_vcvthf8_2ph128_mask",
                    "avx10.mask.vcvthf82ph256" => "__builtin_ia32_vcvthf8_2ph256_mask",
                    "avx10.mask.vcvthf82ph512" => "__builtin_ia32_vcvthf8_2ph512_mask",
                    "avx10.mask.vcvtph2bf8128" => "__builtin_ia32_vcvtph2bf8_128_mask",
                    "avx10.mask.vcvtph2bf8256" => "__builtin_ia32_vcvtph2bf8_256_mask",
                    "avx10.mask.vcvtph2bf8512" => "__builtin_ia32_vcvtph2bf8_512_mask",
                    "avx10.mask.vcvtph2bf8s128" => "__builtin_ia32_vcvtph2bf8s_128_mask",
                    "avx10.mask.vcvtph2bf8s256" => "__builtin_ia32_vcvtph2bf8s_256_mask",
                    "avx10.mask.vcvtph2bf8s512" => "__builtin_ia32_vcvtph2bf8s_512_mask",
                    "avx10.mask.vcvtph2hf8128" => "__builtin_ia32_vcvtph2hf8_128_mask",
                    "avx10.mask.vcvtph2hf8256" => "__builtin_ia32_vcvtph2hf8_256_mask",
                    "avx10.mask.vcvtph2hf8512" => "__builtin_ia32_vcvtph2hf8_512_mask",
                    "avx10.mask.vcvtph2hf8s128" => "__builtin_ia32_vcvtph2hf8s_128_mask",
                    "avx10.mask.vcvtph2hf8s256" => "__builtin_ia32_vcvtph2hf8s_256_mask",
                    "avx10.mask.vcvtph2hf8s512" => "__builtin_ia32_vcvtph2hf8s_512_mask",
                    "avx10.mask.vcvtph2ibs128" => "__builtin_ia32_vcvtph2ibs128_mask",
                    "avx10.mask.vcvtph2ibs256" => "__builtin_ia32_vcvtph2ibs256_mask",
                    "avx10.mask.vcvtph2ibs512" => "__builtin_ia32_vcvtph2ibs512_mask",
                    "avx10.mask.vcvtph2iubs128" => "__builtin_ia32_vcvtph2iubs128_mask",
                    "avx10.mask.vcvtph2iubs256" => "__builtin_ia32_vcvtph2iubs256_mask",
                    "avx10.mask.vcvtph2iubs512" => "__builtin_ia32_vcvtph2iubs512_mask",
                    "avx10.mask.vcvtps2ibs128" => "__builtin_ia32_vcvtps2ibs128_mask",
                    "avx10.mask.vcvtps2ibs256" => "__builtin_ia32_vcvtps2ibs256_mask",
                    "avx10.mask.vcvtps2ibs512" => "__builtin_ia32_vcvtps2ibs512_mask",
                    "avx10.mask.vcvtps2iubs128" => "__builtin_ia32_vcvtps2iubs128_mask",
                    "avx10.mask.vcvtps2iubs256" => "__builtin_ia32_vcvtps2iubs256_mask",
                    "avx10.mask.vcvtps2iubs512" => "__builtin_ia32_vcvtps2iubs512_mask",
                    "avx10.mask.vcvttpd2dqs.128" => "__builtin_ia32_vcvttpd2dqs128_mask",
                    "avx10.mask.vcvttpd2dqs.256" => "__builtin_ia32_vcvttpd2dqs256_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vcvttpd2dqs.round.512" => "__builtin_ia32_vcvttpd2dqs512_round_mask",
                    "avx10.mask.vcvttpd2qqs.128" => "__builtin_ia32_vcvttpd2qqs128_mask",
                    "avx10.mask.vcvttpd2qqs.256" => "__builtin_ia32_vcvttpd2qqs256_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vcvttpd2qqs.round.512" => "__builtin_ia32_vcvttpd2qqs512_round_mask",
                    "avx10.mask.vcvttpd2udqs.128" => "__builtin_ia32_vcvttpd2udqs128_mask",
                    "avx10.mask.vcvttpd2udqs.256" => "__builtin_ia32_vcvttpd2udqs256_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vcvttpd2udqs.round.512" => "__builtin_ia32_vcvttpd2udqs512_round_mask",
                    "avx10.mask.vcvttpd2uqqs.128" => "__builtin_ia32_vcvttpd2uqqs128_mask",
                    "avx10.mask.vcvttpd2uqqs.256" => "__builtin_ia32_vcvttpd2uqqs256_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vcvttpd2uqqs.round.512" => "__builtin_ia32_vcvttpd2uqqs512_round_mask",
                    "avx10.mask.vcvttph2ibs128" => "__builtin_ia32_vcvttph2ibs128_mask",
                    "avx10.mask.vcvttph2ibs256" => "__builtin_ia32_vcvttph2ibs256_mask",
                    "avx10.mask.vcvttph2ibs512" => "__builtin_ia32_vcvttph2ibs512_mask",
                    "avx10.mask.vcvttph2iubs128" => "__builtin_ia32_vcvttph2iubs128_mask",
                    "avx10.mask.vcvttph2iubs256" => "__builtin_ia32_vcvttph2iubs256_mask",
                    "avx10.mask.vcvttph2iubs512" => "__builtin_ia32_vcvttph2iubs512_mask",
                    "avx10.mask.vcvttps2dqs.128" => "__builtin_ia32_vcvttps2dqs128_mask",
                    "avx10.mask.vcvttps2dqs.256" => "__builtin_ia32_vcvttps2dqs256_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vcvttps2dqs.round.512" => "__builtin_ia32_vcvttps2dqs512_round_mask",
                    "avx10.mask.vcvttps2ibs128" => "__builtin_ia32_vcvttps2ibs128_mask",
                    "avx10.mask.vcvttps2ibs256" => "__builtin_ia32_vcvttps2ibs256_mask",
                    "avx10.mask.vcvttps2ibs512" => "__builtin_ia32_vcvttps2ibs512_mask",
                    "avx10.mask.vcvttps2iubs128" => "__builtin_ia32_vcvttps2iubs128_mask",
                    "avx10.mask.vcvttps2iubs256" => "__builtin_ia32_vcvttps2iubs256_mask",
                    "avx10.mask.vcvttps2iubs512" => "__builtin_ia32_vcvttps2iubs512_mask",
                    "avx10.mask.vcvttps2qqs.128" => "__builtin_ia32_vcvttps2qqs128_mask",
                    "avx10.mask.vcvttps2qqs.256" => "__builtin_ia32_vcvttps2qqs256_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vcvttps2qqs.round.512" => "__builtin_ia32_vcvttps2qqs512_round_mask",
                    "avx10.mask.vcvttps2udqs.128" => "__builtin_ia32_vcvttps2udqs128_mask",
                    "avx10.mask.vcvttps2udqs.256" => "__builtin_ia32_vcvttps2udqs256_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vcvttps2udqs.round.512" => "__builtin_ia32_vcvttps2udqs512_round_mask",
                    "avx10.mask.vcvttps2uqqs.128" => "__builtin_ia32_vcvttps2uqqs128_mask",
                    "avx10.mask.vcvttps2uqqs.256" => "__builtin_ia32_vcvttps2uqqs256_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vcvttps2uqqs.round.512" => "__builtin_ia32_vcvttps2uqqs512_round_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vminmaxpd.round" => "__builtin_ia32_vminmaxpd512_round_mask",
                    "avx10.mask.vminmaxpd128" => "__builtin_ia32_vminmaxpd128_mask",
                    "avx10.mask.vminmaxpd256" => "__builtin_ia32_vminmaxpd256_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vminmaxph.round" => "__builtin_ia32_vminmaxph512_round_mask",
                    "avx10.mask.vminmaxph128" => "__builtin_ia32_vminmaxph128_mask",
                    "avx10.mask.vminmaxph256" => "__builtin_ia32_vminmaxph256_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vminmaxps.round" => "__builtin_ia32_vminmaxps512_round_mask",
                    "avx10.mask.vminmaxps128" => "__builtin_ia32_vminmaxps128_mask",
                    "avx10.mask.vminmaxps256" => "__builtin_ia32_vminmaxps256_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vminmaxsd.round" => "__builtin_ia32_vminmaxsd_round_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vminmaxsh.round" => "__builtin_ia32_vminmaxsh_round_mask",
                    // [INVALID CONVERSION]: "avx10.mask.vminmaxss.round" => "__builtin_ia32_vminmaxss_round_mask",
                    "avx10.vaddbf16128" => "__builtin_ia32_vaddbf16128",
                    "avx10.vaddbf16256" => "__builtin_ia32_vaddbf16256",
                    "avx10.vaddbf16512" => "__builtin_ia32_vaddbf16512",
                    "avx10.vaddpd256" => "__builtin_ia32_vaddpd256_round",
                    "avx10.vaddph256" => "__builtin_ia32_vaddph256_round",
                    "avx10.vaddps256" => "__builtin_ia32_vaddps256_round",
                    "avx10.vcomisbf16eq" => "__builtin_ia32_vcomisbf16eq",
                    "avx10.vcomisbf16ge" => "__builtin_ia32_vcomisbf16ge",
                    "avx10.vcomisbf16gt" => "__builtin_ia32_vcomisbf16gt",
                    "avx10.vcomisbf16le" => "__builtin_ia32_vcomisbf16le",
                    "avx10.vcomisbf16lt" => "__builtin_ia32_vcomisbf16lt",
                    "avx10.vcomisbf16neq" => "__builtin_ia32_vcomisbf16neq",
                    "avx10.vcvt2ph2bf8128" => "__builtin_ia32_vcvt2ph2bf8_128",
                    "avx10.vcvt2ph2bf8256" => "__builtin_ia32_vcvt2ph2bf8_256",
                    "avx10.vcvt2ph2bf8512" => "__builtin_ia32_vcvt2ph2bf8_512",
                    "avx10.vcvt2ph2bf8s128" => "__builtin_ia32_vcvt2ph2bf8s_128",
                    "avx10.vcvt2ph2bf8s256" => "__builtin_ia32_vcvt2ph2bf8s_256",
                    "avx10.vcvt2ph2bf8s512" => "__builtin_ia32_vcvt2ph2bf8s_512",
                    "avx10.vcvt2ph2hf8128" => "__builtin_ia32_vcvt2ph2hf8_128",
                    "avx10.vcvt2ph2hf8256" => "__builtin_ia32_vcvt2ph2hf8_256",
                    "avx10.vcvt2ph2hf8512" => "__builtin_ia32_vcvt2ph2hf8_512",
                    "avx10.vcvt2ph2hf8s128" => "__builtin_ia32_vcvt2ph2hf8s_128",
                    "avx10.vcvt2ph2hf8s256" => "__builtin_ia32_vcvt2ph2hf8s_256",
                    "avx10.vcvt2ph2hf8s512" => "__builtin_ia32_vcvt2ph2hf8s_512",
                    "avx10.vcvtbf162ibs128" => "__builtin_ia32_vcvtbf162ibs128",
                    "avx10.vcvtbf162ibs256" => "__builtin_ia32_vcvtbf162ibs256",
                    "avx10.vcvtbf162ibs512" => "__builtin_ia32_vcvtbf162ibs512",
                    "avx10.vcvtbf162iubs128" => "__builtin_ia32_vcvtbf162iubs128",
                    "avx10.vcvtbf162iubs256" => "__builtin_ia32_vcvtbf162iubs256",
                    "avx10.vcvtbf162iubs512" => "__builtin_ia32_vcvtbf162iubs512",
                    "avx10.vcvttbf162ibs128" => "__builtin_ia32_vcvttbf162ibs128",
                    "avx10.vcvttbf162ibs256" => "__builtin_ia32_vcvttbf162ibs256",
                    "avx10.vcvttbf162ibs512" => "__builtin_ia32_vcvttbf162ibs512",
                    "avx10.vcvttbf162iubs128" => "__builtin_ia32_vcvttbf162iubs128",
                    "avx10.vcvttbf162iubs256" => "__builtin_ia32_vcvttbf162iubs256",
                    "avx10.vcvttbf162iubs512" => "__builtin_ia32_vcvttbf162iubs512",
                    "avx10.vcvttsd2sis" => "__builtin_ia32_vcvttsd2sis32",
                    "avx10.vcvttsd2sis64" => "__builtin_ia32_vcvttsd2sis64",
                    "avx10.vcvttsd2usis" => "__builtin_ia32_vcvttsd2usis32",
                    "avx10.vcvttsd2usis64" => "__builtin_ia32_vcvttsd2usis64",
                    "avx10.vcvttss2sis" => "__builtin_ia32_vcvttss2sis32",
                    "avx10.vcvttss2sis64" => "__builtin_ia32_vcvttss2sis64",
                    "avx10.vcvttss2usis" => "__builtin_ia32_vcvttss2usis32",
                    "avx10.vcvttss2usis64" => "__builtin_ia32_vcvttss2usis64",
                    "avx10.vdivbf16128" => "__builtin_ia32_vdivbf16128",
                    "avx10.vdivbf16256" => "__builtin_ia32_vdivbf16256",
                    "avx10.vdivbf16512" => "__builtin_ia32_vdivbf16512",
                    "avx10.vdpphps.128" => "__builtin_ia32_vdpphps128",
                    "avx10.vdpphps.256" => "__builtin_ia32_vdpphps256",
                    "avx10.vdpphps.512" => "__builtin_ia32_vdpphps512",
                    "avx10.vfmadd132bf16128" => "__builtin_ia32_vfmadd132bf16128",
                    "avx10.vfmadd132bf16256" => "__builtin_ia32_vfmadd132bf16256",
                    "avx10.vfmadd132bf16512" => "__builtin_ia32_vfmadd132bf16512",
                    "avx10.vfmadd213bf16128" => "__builtin_ia32_vfmadd213bf16128",
                    "avx10.vfmadd213bf16256" => "__builtin_ia32_vfmadd213bf16256",
                    "avx10.vfmadd231bf16128" => "__builtin_ia32_vfmadd231bf16128",
                    "avx10.vfmadd231bf16256" => "__builtin_ia32_vfmadd231bf16256",
                    "avx10.vfmadd231bf16512" => "__builtin_ia32_vfmadd231bf16512",
                    "avx10.vfmsub132bf16128" => "__builtin_ia32_vfmsub132bf16128",
                    "avx10.vfmsub132bf16256" => "__builtin_ia32_vfmsub132bf16256",
                    "avx10.vfmsub132bf16512" => "__builtin_ia32_vfmsub132bf16512",
                    "avx10.vfmsub213bf16128" => "__builtin_ia32_vfmsub213bf16128",
                    "avx10.vfmsub213bf16256" => "__builtin_ia32_vfmsub213bf16256",
                    "avx10.vfmsub213bf16512" => "__builtin_ia32_vfmsub213bf16512",
                    "avx10.vfmsub231bf16128" => "__builtin_ia32_vfmsub231bf16128",
                    "avx10.vfmsub231bf16256" => "__builtin_ia32_vfmsub231bf16256",
                    "avx10.vfmsub231bf16512" => "__builtin_ia32_vfmsub231bf16512",
                    "avx10.vfnmadd132bf16128" => "__builtin_ia32_vfnmadd132bf16128",
                    "avx10.vfnmadd132bf16256" => "__builtin_ia32_vfnmadd132bf16256",
                    "avx10.vfnmadd132bf16512" => "__builtin_ia32_vfnmadd132bf16512",
                    "avx10.vfnmadd213bf16128" => "__builtin_ia32_vfnmadd213bf16128",
                    "avx10.vfnmadd213bf16256" => "__builtin_ia32_vfnmadd213bf16256",
                    "avx10.vfnmadd213bf16512" => "__builtin_ia32_vfnmadd213bf16512",
                    "avx10.vfnmadd231bf16128" => "__builtin_ia32_vfnmadd231bf16128",
                    "avx10.vfnmadd231bf16256" => "__builtin_ia32_vfnmadd231bf16256",
                    "avx10.vfnmadd231bf16512" => "__builtin_ia32_vfnmadd231bf16512",
                    "avx10.vfnmsub132bf16128" => "__builtin_ia32_vfnmsub132bf16128",
                    "avx10.vfnmsub132bf16256" => "__builtin_ia32_vfnmsub132bf16256",
                    "avx10.vfnmsub132bf16512" => "__builtin_ia32_vfnmsub132bf16512",
                    "avx10.vfnmsub213bf16128" => "__builtin_ia32_vfnmsub213bf16128",
                    "avx10.vfnmsub213bf16256" => "__builtin_ia32_vfnmsub213bf16256",
                    "avx10.vfnmsub213bf16512" => "__builtin_ia32_vfnmsub213bf16512",
                    "avx10.vfnmsub231bf16128" => "__builtin_ia32_vfnmsub231bf16128",
                    "avx10.vfnmsub231bf16256" => "__builtin_ia32_vfnmsub231bf16256",
                    "avx10.vfnmsub231bf16512" => "__builtin_ia32_vfnmsub231bf16512",
                    "avx10.vmaxbf16128" => "__builtin_ia32_vmaxbf16128",
                    "avx10.vmaxbf16256" => "__builtin_ia32_vmaxbf16256",
                    "avx10.vmaxbf16512" => "__builtin_ia32_vmaxbf16512",
                    "avx10.vminbf16128" => "__builtin_ia32_vminbf16128",
                    "avx10.vminbf16256" => "__builtin_ia32_vminbf16256",
                    "avx10.vminbf16512" => "__builtin_ia32_vminbf16512",
                    "avx10.vminmaxbf16128" => "__builtin_ia32_vminmaxbf16128",
                    "avx10.vminmaxbf16256" => "__builtin_ia32_vminmaxbf16256",
                    "avx10.vminmaxbf16512" => "__builtin_ia32_vminmaxbf16512",
                    "avx10.vminmaxpd128" => "__builtin_ia32_vminmaxpd128",
                    "avx10.vminmaxpd256" => "__builtin_ia32_vminmaxpd256",
                    "avx10.vminmaxph128" => "__builtin_ia32_vminmaxph128",
                    "avx10.vminmaxph256" => "__builtin_ia32_vminmaxph256",
                    "avx10.vminmaxps128" => "__builtin_ia32_vminmaxps128",
                    "avx10.vminmaxps256" => "__builtin_ia32_vminmaxps256",
                    "avx10.vmovrsb128" => "__builtin_ia32_vmovrsb128",
                    "avx10.vmovrsb256" => "__builtin_ia32_vmovrsb256",
                    "avx10.vmovrsb512" => "__builtin_ia32_vmovrsb512",
                    "avx10.vmovrsd128" => "__builtin_ia32_vmovrsd128",
                    "avx10.vmovrsd256" => "__builtin_ia32_vmovrsd256",
                    "avx10.vmovrsd512" => "__builtin_ia32_vmovrsd512",
                    "avx10.vmovrsq128" => "__builtin_ia32_vmovrsq128",
                    "avx10.vmovrsq256" => "__builtin_ia32_vmovrsq256",
                    "avx10.vmovrsq512" => "__builtin_ia32_vmovrsq512",
                    "avx10.vmovrsw128" => "__builtin_ia32_vmovrsw128",
                    "avx10.vmovrsw256" => "__builtin_ia32_vmovrsw256",
                    "avx10.vmovrsw512" => "__builtin_ia32_vmovrsw512",
                    "avx10.vmpsadbw.512" => "__builtin_ia32_mpsadbw512",
                    "avx10.vmulbf16128" => "__builtin_ia32_vmulbf16128",
                    "avx10.vmulbf16256" => "__builtin_ia32_vmulbf16256",
                    "avx10.vmulbf16512" => "__builtin_ia32_vmulbf16512",
                    "avx10.vpdpbssd.512" => "__builtin_ia32_vpdpbssd512",
                    "avx10.vpdpbssds.512" => "__builtin_ia32_vpdpbssds512",
                    "avx10.vpdpbsud.512" => "__builtin_ia32_vpdpbsud512",
                    "avx10.vpdpbsuds.512" => "__builtin_ia32_vpdpbsuds512",
                    "avx10.vpdpbuud.512" => "__builtin_ia32_vpdpbuud512",
                    "avx10.vpdpbuuds.512" => "__builtin_ia32_vpdpbuuds512",
                    "avx10.vpdpwsud.512" => "__builtin_ia32_vpdpwsud512",
                    "avx10.vpdpwsuds.512" => "__builtin_ia32_vpdpwsuds512",
                    "avx10.vpdpwusd.512" => "__builtin_ia32_vpdpwusd512",
                    "avx10.vpdpwusds.512" => "__builtin_ia32_vpdpwusds512",
                    "avx10.vpdpwuud.512" => "__builtin_ia32_vpdpwuud512",
                    "avx10.vpdpwuuds.512" => "__builtin_ia32_vpdpwuuds512",
                    "avx10.vsubbf16128" => "__builtin_ia32_vsubbf16128",
                    "avx10.vsubbf16256" => "__builtin_ia32_vsubbf16256",
                    "avx10.vsubbf16512" => "__builtin_ia32_vsubbf16512",
                    "avx2.gather.d.d" => "__builtin_ia32_gatherd_d",
                    "avx2.gather.d.d.256" => "__builtin_ia32_gatherd_d256",
                    "avx2.gather.d.pd" => "__builtin_ia32_gatherd_pd",
                    "avx2.gather.d.pd.256" => "__builtin_ia32_gatherd_pd256",
                    "avx2.gather.d.ps" => "__builtin_ia32_gatherd_ps",
                    "avx2.gather.d.ps.256" => "__builtin_ia32_gatherd_ps256",
                    "avx2.gather.d.q" => "__builtin_ia32_gatherd_q",
                    "avx2.gather.d.q.256" => "__builtin_ia32_gatherd_q256",
                    "avx2.gather.q.d" => "__builtin_ia32_gatherq_d",
                    "avx2.gather.q.d.256" => "__builtin_ia32_gatherq_d256",
                    "avx2.gather.q.pd" => "__builtin_ia32_gatherq_pd",
                    "avx2.gather.q.pd.256" => "__builtin_ia32_gatherq_pd256",
                    "avx2.gather.q.ps" => "__builtin_ia32_gatherq_ps",
                    "avx2.gather.q.ps.256" => "__builtin_ia32_gatherq_ps256",
                    "avx2.gather.q.q" => "__builtin_ia32_gatherq_q",
                    "avx2.gather.q.q.256" => "__builtin_ia32_gatherq_q256",
                    "avx2.maskload.d" => "__builtin_ia32_maskloadd",
                    "avx2.maskload.d.256" => "__builtin_ia32_maskloadd256",
                    "avx2.maskload.q" => "__builtin_ia32_maskloadq",
                    "avx2.maskload.q.256" => "__builtin_ia32_maskloadq256",
                    "avx2.maskstore.d" => "__builtin_ia32_maskstored",
                    "avx2.maskstore.d.256" => "__builtin_ia32_maskstored256",
                    "avx2.maskstore.q" => "__builtin_ia32_maskstoreq",
                    "avx2.maskstore.q.256" => "__builtin_ia32_maskstoreq256",
                    "avx2.movntdqa" => "__builtin_ia32_movntdqa256",
                    "avx2.mpsadbw" => "__builtin_ia32_mpsadbw256",
                    "avx2.pabs.b" => "__builtin_ia32_pabsb256",
                    "avx2.pabs.d" => "__builtin_ia32_pabsd256",
                    "avx2.pabs.w" => "__builtin_ia32_pabsw256",
                    "avx2.packssdw" => "__builtin_ia32_packssdw256",
                    "avx2.packsswb" => "__builtin_ia32_packsswb256",
                    "avx2.packusdw" => "__builtin_ia32_packusdw256",
                    "avx2.packuswb" => "__builtin_ia32_packuswb256",
                    "avx2.padds.b" => "__builtin_ia32_paddsb256",
                    "avx2.padds.w" => "__builtin_ia32_paddsw256",
                    "avx2.paddus.b" => "__builtin_ia32_paddusb256",
                    "avx2.paddus.w" => "__builtin_ia32_paddusw256",
                    "avx2.pavg.b" => "__builtin_ia32_pavgb256",
                    "avx2.pavg.w" => "__builtin_ia32_pavgw256",
                    "avx2.pblendd.128" => "__builtin_ia32_pblendd128",
                    "avx2.pblendd.256" => "__builtin_ia32_pblendd256",
                    "avx2.pblendvb" => "__builtin_ia32_pblendvb256",
                    "avx2.pblendw" => "__builtin_ia32_pblendw256",
                    "avx2.pbroadcastb.128" => "__builtin_ia32_pbroadcastb128",
                    "avx2.pbroadcastb.256" => "__builtin_ia32_pbroadcastb256",
                    "avx2.pbroadcastd.128" => "__builtin_ia32_pbroadcastd128",
                    "avx2.pbroadcastd.256" => "__builtin_ia32_pbroadcastd256",
                    "avx2.pbroadcastq.128" => "__builtin_ia32_pbroadcastq128",
                    "avx2.pbroadcastq.256" => "__builtin_ia32_pbroadcastq256",
                    "avx2.pbroadcastw.128" => "__builtin_ia32_pbroadcastw128",
                    "avx2.pbroadcastw.256" => "__builtin_ia32_pbroadcastw256",
                    "avx2.permd" => "__builtin_ia32_permvarsi256",
                    "avx2.permps" => "__builtin_ia32_permvarsf256",
                    "avx2.phadd.d" => "__builtin_ia32_phaddd256",
                    "avx2.phadd.sw" => "__builtin_ia32_phaddsw256",
                    "avx2.phadd.w" => "__builtin_ia32_phaddw256",
                    "avx2.phsub.d" => "__builtin_ia32_phsubd256",
                    "avx2.phsub.sw" => "__builtin_ia32_phsubsw256",
                    "avx2.phsub.w" => "__builtin_ia32_phsubw256",
                    "avx2.pmadd.ub.sw" => "__builtin_ia32_pmaddubsw256",
                    "avx2.pmadd.wd" => "__builtin_ia32_pmaddwd256",
                    "avx2.pmaxs.b" => "__builtin_ia32_pmaxsb256",
                    "avx2.pmaxs.d" => "__builtin_ia32_pmaxsd256",
                    "avx2.pmaxs.w" => "__builtin_ia32_pmaxsw256",
                    "avx2.pmaxu.b" => "__builtin_ia32_pmaxub256",
                    "avx2.pmaxu.d" => "__builtin_ia32_pmaxud256",
                    "avx2.pmaxu.w" => "__builtin_ia32_pmaxuw256",
                    "avx2.pmins.b" => "__builtin_ia32_pminsb256",
                    "avx2.pmins.d" => "__builtin_ia32_pminsd256",
                    "avx2.pmins.w" => "__builtin_ia32_pminsw256",
                    "avx2.pminu.b" => "__builtin_ia32_pminub256",
                    "avx2.pminu.d" => "__builtin_ia32_pminud256",
                    "avx2.pminu.w" => "__builtin_ia32_pminuw256",
                    "avx2.pmovmskb" => "__builtin_ia32_pmovmskb256",
                    "avx2.pmovsxbd" => "__builtin_ia32_pmovsxbd256",
                    "avx2.pmovsxbq" => "__builtin_ia32_pmovsxbq256",
                    "avx2.pmovsxbw" => "__builtin_ia32_pmovsxbw256",
                    "avx2.pmovsxdq" => "__builtin_ia32_pmovsxdq256",
                    "avx2.pmovsxwd" => "__builtin_ia32_pmovsxwd256",
                    "avx2.pmovsxwq" => "__builtin_ia32_pmovsxwq256",
                    "avx2.pmovzxbd" => "__builtin_ia32_pmovzxbd256",
                    "avx2.pmovzxbq" => "__builtin_ia32_pmovzxbq256",
                    "avx2.pmovzxbw" => "__builtin_ia32_pmovzxbw256",
                    "avx2.pmovzxdq" => "__builtin_ia32_pmovzxdq256",
                    "avx2.pmovzxwd" => "__builtin_ia32_pmovzxwd256",
                    "avx2.pmovzxwq" => "__builtin_ia32_pmovzxwq256",
                    "avx2.pmul.dq" => "__builtin_ia32_pmuldq256",
                    "avx2.pmul.hr.sw" => "__builtin_ia32_pmulhrsw256",
                    "avx2.pmulh.w" => "__builtin_ia32_pmulhw256",
                    "avx2.pmulhu.w" => "__builtin_ia32_pmulhuw256",
                    "avx2.pmulu.dq" => "__builtin_ia32_pmuludq256",
                    "avx2.psad.bw" => "__builtin_ia32_psadbw256",
                    "avx2.pshuf.b" => "__builtin_ia32_pshufb256",
                    "avx2.psign.b" => "__builtin_ia32_psignb256",
                    "avx2.psign.d" => "__builtin_ia32_psignd256",
                    "avx2.psign.w" => "__builtin_ia32_psignw256",
                    "avx2.psll.d" => "__builtin_ia32_pslld256",
                    "avx2.psll.dq" => "__builtin_ia32_pslldqi256",
                    "avx2.psll.dq.bs" => "__builtin_ia32_pslldqi256_byteshift",
                    "avx2.psll.q" => "__builtin_ia32_psllq256",
                    "avx2.psll.w" => "__builtin_ia32_psllw256",
                    "avx2.pslli.d" => "__builtin_ia32_pslldi256",
                    "avx2.pslli.q" => "__builtin_ia32_psllqi256",
                    "avx2.pslli.w" => "__builtin_ia32_psllwi256",
                    "avx2.psllv.d" => "__builtin_ia32_psllv4si",
                    "avx2.psllv.d.256" => "__builtin_ia32_psllv8si",
                    "avx2.psllv.q" => "__builtin_ia32_psllv2di",
                    "avx2.psllv.q.256" => "__builtin_ia32_psllv4di",
                    "avx2.psra.d" => "__builtin_ia32_psrad256",
                    "avx2.psra.w" => "__builtin_ia32_psraw256",
                    "avx2.psrai.d" => "__builtin_ia32_psradi256",
                    "avx2.psrai.w" => "__builtin_ia32_psrawi256",
                    "avx2.psrav.d" => "__builtin_ia32_psrav4si",
                    "avx2.psrav.d.256" => "__builtin_ia32_psrav8si",
                    "avx2.psrl.d" => "__builtin_ia32_psrld256",
                    "avx2.psrl.dq" => "__builtin_ia32_psrldqi256",
                    "avx2.psrl.dq.bs" => "__builtin_ia32_psrldqi256_byteshift",
                    "avx2.psrl.q" => "__builtin_ia32_psrlq256",
                    "avx2.psrl.w" => "__builtin_ia32_psrlw256",
                    "avx2.psrli.d" => "__builtin_ia32_psrldi256",
                    "avx2.psrli.q" => "__builtin_ia32_psrlqi256",
                    "avx2.psrli.w" => "__builtin_ia32_psrlwi256",
                    "avx2.psrlv.d" => "__builtin_ia32_psrlv4si",
                    "avx2.psrlv.d.256" => "__builtin_ia32_psrlv8si",
                    "avx2.psrlv.q" => "__builtin_ia32_psrlv2di",
                    "avx2.psrlv.q.256" => "__builtin_ia32_psrlv4di",
                    "avx2.psubs.b" => "__builtin_ia32_psubsb256",
                    "avx2.psubs.w" => "__builtin_ia32_psubsw256",
                    "avx2.psubus.b" => "__builtin_ia32_psubusb256",
                    "avx2.psubus.w" => "__builtin_ia32_psubusw256",
                    "avx2.vbroadcast.sd.pd.256" => "__builtin_ia32_vbroadcastsd_pd256",
                    "avx2.vbroadcast.ss.ps" => "__builtin_ia32_vbroadcastss_ps",
                    "avx2.vbroadcast.ss.ps.256" => "__builtin_ia32_vbroadcastss_ps256",
                    "avx2.vextracti128" => "__builtin_ia32_extract128i256",
                    "avx2.vinserti128" => "__builtin_ia32_insert128i256",
                    "avx2.vpdpbssd.128" => "__builtin_ia32_vpdpbssd128",
                    "avx2.vpdpbssd.256" => "__builtin_ia32_vpdpbssd256",
                    "avx2.vpdpbssds.128" => "__builtin_ia32_vpdpbssds128",
                    "avx2.vpdpbssds.256" => "__builtin_ia32_vpdpbssds256",
                    "avx2.vpdpbsud.128" => "__builtin_ia32_vpdpbsud128",
                    "avx2.vpdpbsud.256" => "__builtin_ia32_vpdpbsud256",
                    "avx2.vpdpbsuds.128" => "__builtin_ia32_vpdpbsuds128",
                    "avx2.vpdpbsuds.256" => "__builtin_ia32_vpdpbsuds256",
                    "avx2.vpdpbuud.128" => "__builtin_ia32_vpdpbuud128",
                    "avx2.vpdpbuud.256" => "__builtin_ia32_vpdpbuud256",
                    "avx2.vpdpbuuds.128" => "__builtin_ia32_vpdpbuuds128",
                    "avx2.vpdpbuuds.256" => "__builtin_ia32_vpdpbuuds256",
                    "avx2.vpdpwsud.128" => "__builtin_ia32_vpdpwsud128",
                    "avx2.vpdpwsud.256" => "__builtin_ia32_vpdpwsud256",
                    "avx2.vpdpwsuds.128" => "__builtin_ia32_vpdpwsuds128",
                    "avx2.vpdpwsuds.256" => "__builtin_ia32_vpdpwsuds256",
                    "avx2.vpdpwusd.128" => "__builtin_ia32_vpdpwusd128",
                    "avx2.vpdpwusd.256" => "__builtin_ia32_vpdpwusd256",
                    "avx2.vpdpwusds.128" => "__builtin_ia32_vpdpwusds128",
                    "avx2.vpdpwusds.256" => "__builtin_ia32_vpdpwusds256",
                    "avx2.vpdpwuud.128" => "__builtin_ia32_vpdpwuud128",
                    "avx2.vpdpwuud.256" => "__builtin_ia32_vpdpwuud256",
                    "avx2.vpdpwuuds.128" => "__builtin_ia32_vpdpwuuds128",
                    "avx2.vpdpwuuds.256" => "__builtin_ia32_vpdpwuuds256",
                    "avx2.vperm2i128" => "__builtin_ia32_permti256",
                    "avx512.add.pd.512" => "__builtin_ia32_addpd512",
                    "avx512.add.ps.512" => "__builtin_ia32_addps512",
                    "avx512.broadcastmb.128" => "__builtin_ia32_broadcastmb128",
                    "avx512.broadcastmb.256" => "__builtin_ia32_broadcastmb256",
                    "avx512.broadcastmb.512" => "__builtin_ia32_broadcastmb512",
                    "avx512.broadcastmw.128" => "__builtin_ia32_broadcastmw128",
                    "avx512.broadcastmw.256" => "__builtin_ia32_broadcastmw256",
                    "avx512.broadcastmw.512" => "__builtin_ia32_broadcastmw512",
                    "avx512.conflict.d.128" => "__builtin_ia32_vpconflictsi_128",
                    "avx512.conflict.d.256" => "__builtin_ia32_vpconflictsi_256",
                    "avx512.conflict.d.512" => "__builtin_ia32_vpconflictsi_512",
                    "avx512.conflict.q.128" => "__builtin_ia32_vpconflictdi_128",
                    "avx512.conflict.q.256" => "__builtin_ia32_vpconflictdi_256",
                    "avx512.conflict.q.512" => "__builtin_ia32_vpconflictdi_512",
                    "avx512.cvtb2mask.128" => "__builtin_ia32_cvtb2mask128",
                    "avx512.cvtb2mask.256" => "__builtin_ia32_cvtb2mask256",
                    "avx512.cvtb2mask.512" => "__builtin_ia32_cvtb2mask512",
                    "avx512.cvtd2mask.128" => "__builtin_ia32_cvtd2mask128",
                    "avx512.cvtd2mask.256" => "__builtin_ia32_cvtd2mask256",
                    "avx512.cvtd2mask.512" => "__builtin_ia32_cvtd2mask512",
                    "avx512.cvtmask2b.128" => "__builtin_ia32_cvtmask2b128",
                    "avx512.cvtmask2b.256" => "__builtin_ia32_cvtmask2b256",
                    "avx512.cvtmask2b.512" => "__builtin_ia32_cvtmask2b512",
                    "avx512.cvtmask2d.128" => "__builtin_ia32_cvtmask2d128",
                    "avx512.cvtmask2d.256" => "__builtin_ia32_cvtmask2d256",
                    "avx512.cvtmask2d.512" => "__builtin_ia32_cvtmask2d512",
                    "avx512.cvtmask2q.128" => "__builtin_ia32_cvtmask2q128",
                    "avx512.cvtmask2q.256" => "__builtin_ia32_cvtmask2q256",
                    "avx512.cvtmask2q.512" => "__builtin_ia32_cvtmask2q512",
                    "avx512.cvtmask2w.128" => "__builtin_ia32_cvtmask2w128",
                    "avx512.cvtmask2w.256" => "__builtin_ia32_cvtmask2w256",
                    "avx512.cvtmask2w.512" => "__builtin_ia32_cvtmask2w512",
                    "avx512.cvtq2mask.128" => "__builtin_ia32_cvtq2mask128",
                    "avx512.cvtq2mask.256" => "__builtin_ia32_cvtq2mask256",
                    "avx512.cvtq2mask.512" => "__builtin_ia32_cvtq2mask512",
                    "avx512.cvtsd2usi" => "__builtin_ia32_cvtsd2usi",
                    "avx512.cvtsd2usi64" => "__builtin_ia32_cvtsd2usi64",
                    "avx512.cvtsi2sd32" => "__builtin_ia32_cvtsi2sd32",
                    "avx512.cvtsi2sd64" => "__builtin_ia32_cvtsi2sd64",
                    "avx512.cvtsi2ss32" => "__builtin_ia32_cvtsi2ss32",
                    "avx512.cvtsi2ss64" => "__builtin_ia32_cvtsi2ss64",
                    "avx512.cvtss2usi" => "__builtin_ia32_cvtss2usi",
                    "avx512.cvtss2usi64" => "__builtin_ia32_cvtss2usi64",
                    "avx512.cvttsd2si" => "__builtin_ia32_vcvttsd2si32",
                    "avx512.cvttsd2si64" => "__builtin_ia32_vcvttsd2si64",
                    "avx512.cvttsd2usi" => "__builtin_ia32_vcvttsd2usi32",
                    // [DUPLICATE]: "avx512.cvttsd2usi" => "__builtin_ia32_cvttsd2usi",
                    "avx512.cvttsd2usi64" => "__builtin_ia32_vcvttsd2usi64",
                    // [DUPLICATE]: "avx512.cvttsd2usi64" => "__builtin_ia32_cvttsd2usi64",
                    "avx512.cvttss2si" => "__builtin_ia32_vcvttss2si32",
                    "avx512.cvttss2si64" => "__builtin_ia32_vcvttss2si64",
                    "avx512.cvttss2usi" => "__builtin_ia32_vcvttss2usi32",
                    // [DUPLICATE]: "avx512.cvttss2usi" => "__builtin_ia32_cvttss2usi",
                    "avx512.cvttss2usi64" => "__builtin_ia32_vcvttss2usi64",
                    // [DUPLICATE]: "avx512.cvttss2usi64" => "__builtin_ia32_cvttss2usi64",
                    "avx512.cvtusi2sd" => "__builtin_ia32_cvtusi2sd",
                    // [DUPLICATE]: "avx512.cvtusi2sd" => "__builtin_ia32_cvtusi2sd32",
                    "avx512.cvtusi2ss" => "__builtin_ia32_cvtusi2ss32",
                    // [DUPLICATE]: "avx512.cvtusi2ss" => "__builtin_ia32_cvtusi2ss",
                    "avx512.cvtusi642sd" => "__builtin_ia32_cvtusi2sd64",
                    // [DUPLICATE]: "avx512.cvtusi642sd" => "__builtin_ia32_cvtusi642sd",
                    "avx512.cvtusi642ss" => "__builtin_ia32_cvtusi2ss64",
                    // [DUPLICATE]: "avx512.cvtusi642ss" => "__builtin_ia32_cvtusi642ss",
                    "avx512.cvtw2mask.128" => "__builtin_ia32_cvtw2mask128",
                    "avx512.cvtw2mask.256" => "__builtin_ia32_cvtw2mask256",
                    "avx512.cvtw2mask.512" => "__builtin_ia32_cvtw2mask512",
                    "avx512.dbpsadbw.128" => "__builtin_ia32_dbpsadbw128",
                    "avx512.dbpsadbw.256" => "__builtin_ia32_dbpsadbw256",
                    "avx512.dbpsadbw.512" => "__builtin_ia32_dbpsadbw512",
                    "avx512.div.pd.512" => "__builtin_ia32_divpd512",
                    "avx512.div.ps.512" => "__builtin_ia32_divps512",
                    "avx512.exp2.pd" => "__builtin_ia32_exp2pd_mask",
                    "avx512.exp2.ps" => "__builtin_ia32_exp2ps_mask",
                    "avx512.gather.dpd.512" => "__builtin_ia32_gathersiv8df",
                    "avx512.gather.dpi.512" => "__builtin_ia32_gathersiv16si",
                    "avx512.gather.dpq.512" => "__builtin_ia32_gathersiv8di",
                    "avx512.gather.dps.512" => "__builtin_ia32_gathersiv16sf",
                    "avx512.gather.qpd.512" => "__builtin_ia32_gatherdiv8df",
                    "avx512.gather.qpi.512" => "__builtin_ia32_gatherdiv16si",
                    "avx512.gather.qpq.512" => "__builtin_ia32_gatherdiv8di",
                    "avx512.gather.qps.512" => "__builtin_ia32_gatherdiv16sf",
                    "avx512.gather3div2.df" => "__builtin_ia32_gather3div2df",
                    "avx512.gather3div2.di" => "__builtin_ia32_gather3div2di",
                    "avx512.gather3div4.df" => "__builtin_ia32_gather3div4df",
                    "avx512.gather3div4.di" => "__builtin_ia32_gather3div4di",
                    "avx512.gather3div4.sf" => "__builtin_ia32_gather3div4sf",
                    "avx512.gather3div4.si" => "__builtin_ia32_gather3div4si",
                    "avx512.gather3div8.sf" => "__builtin_ia32_gather3div8sf",
                    "avx512.gather3div8.si" => "__builtin_ia32_gather3div8si",
                    "avx512.gather3siv2.df" => "__builtin_ia32_gather3siv2df",
                    "avx512.gather3siv2.di" => "__builtin_ia32_gather3siv2di",
                    "avx512.gather3siv4.df" => "__builtin_ia32_gather3siv4df",
                    "avx512.gather3siv4.di" => "__builtin_ia32_gather3siv4di",
                    "avx512.gather3siv4.sf" => "__builtin_ia32_gather3siv4sf",
                    "avx512.gather3siv4.si" => "__builtin_ia32_gather3siv4si",
                    "avx512.gather3siv8.sf" => "__builtin_ia32_gather3siv8sf",
                    "avx512.gather3siv8.si" => "__builtin_ia32_gather3siv8si",
                    "avx512.gatherpf.dpd.512" => "__builtin_ia32_gatherpfdpd",
                    "avx512.gatherpf.dps.512" => "__builtin_ia32_gatherpfdps",
                    "avx512.gatherpf.qpd.512" => "__builtin_ia32_gatherpfqpd",
                    "avx512.gatherpf.qps.512" => "__builtin_ia32_gatherpfqps",
                    "avx512.kand.w" => "__builtin_ia32_kandhi",
                    "avx512.kandn.w" => "__builtin_ia32_kandnhi",
                    "avx512.knot.w" => "__builtin_ia32_knothi",
                    "avx512.kor.w" => "__builtin_ia32_korhi",
                    "avx512.kortestc.w" => "__builtin_ia32_kortestchi",
                    "avx512.kortestz.w" => "__builtin_ia32_kortestzhi",
                    "avx512.kunpck.bw" => "__builtin_ia32_kunpckhi",
                    "avx512.kunpck.dq" => "__builtin_ia32_kunpckdi",
                    "avx512.kunpck.wd" => "__builtin_ia32_kunpcksi",
                    "avx512.kxnor.w" => "__builtin_ia32_kxnorhi",
                    "avx512.kxor.w" => "__builtin_ia32_kxorhi",
                    "avx512.mask.add.pd.128" => "__builtin_ia32_addpd128_mask",
                    "avx512.mask.add.pd.256" => "__builtin_ia32_addpd256_mask",
                    "avx512.mask.add.pd.512" => "__builtin_ia32_addpd512_mask",
                    "avx512.mask.add.ps.128" => "__builtin_ia32_addps128_mask",
                    "avx512.mask.add.ps.256" => "__builtin_ia32_addps256_mask",
                    "avx512.mask.add.ps.512" => "__builtin_ia32_addps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.add.sd.round" => "__builtin_ia32_addsd_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.add.ss.round" => "__builtin_ia32_addss_round_mask",
                    "avx512.mask.and.pd.128" => "__builtin_ia32_andpd128_mask",
                    "avx512.mask.and.pd.256" => "__builtin_ia32_andpd256_mask",
                    "avx512.mask.and.pd.512" => "__builtin_ia32_andpd512_mask",
                    "avx512.mask.and.ps.128" => "__builtin_ia32_andps128_mask",
                    "avx512.mask.and.ps.256" => "__builtin_ia32_andps256_mask",
                    "avx512.mask.and.ps.512" => "__builtin_ia32_andps512_mask",
                    "avx512.mask.andn.pd.128" => "__builtin_ia32_andnpd128_mask",
                    "avx512.mask.andn.pd.256" => "__builtin_ia32_andnpd256_mask",
                    "avx512.mask.andn.pd.512" => "__builtin_ia32_andnpd512_mask",
                    "avx512.mask.andn.ps.128" => "__builtin_ia32_andnps128_mask",
                    "avx512.mask.andn.ps.256" => "__builtin_ia32_andnps256_mask",
                    "avx512.mask.andn.ps.512" => "__builtin_ia32_andnps512_mask",
                    "avx512.mask.blend.d.512" => "__builtin_ia32_blendmd_512_mask",
                    "avx512.mask.blend.pd.512" => "__builtin_ia32_blendmpd_512_mask",
                    "avx512.mask.blend.ps.512" => "__builtin_ia32_blendmps_512_mask",
                    "avx512.mask.blend.q.512" => "__builtin_ia32_blendmq_512_mask",
                    "avx512.mask.broadcastf32x2.256" => "__builtin_ia32_broadcastf32x2_256_mask",
                    "avx512.mask.broadcastf32x2.512" => "__builtin_ia32_broadcastf32x2_512_mask",
                    "avx512.mask.broadcastf32x4.256" => "__builtin_ia32_broadcastf32x4_256_mask",
                    "avx512.mask.broadcastf32x4.512" => "__builtin_ia32_broadcastf32x4_512",
                    "avx512.mask.broadcastf32x8.512" => "__builtin_ia32_broadcastf32x8_512_mask",
                    "avx512.mask.broadcastf64x2.256" => "__builtin_ia32_broadcastf64x2_256_mask",
                    "avx512.mask.broadcastf64x2.512" => "__builtin_ia32_broadcastf64x2_512_mask",
                    "avx512.mask.broadcastf64x4.512" => "__builtin_ia32_broadcastf64x4_512",
                    "avx512.mask.broadcasti32x2.128" => "__builtin_ia32_broadcasti32x2_128_mask",
                    "avx512.mask.broadcasti32x2.256" => "__builtin_ia32_broadcasti32x2_256_mask",
                    "avx512.mask.broadcasti32x2.512" => "__builtin_ia32_broadcasti32x2_512_mask",
                    "avx512.mask.broadcasti32x4.256" => "__builtin_ia32_broadcasti32x4_256_mask",
                    "avx512.mask.broadcasti32x4.512" => "__builtin_ia32_broadcasti32x4_512",
                    "avx512.mask.broadcasti32x8.512" => "__builtin_ia32_broadcasti32x8_512_mask",
                    "avx512.mask.broadcasti64x2.256" => "__builtin_ia32_broadcasti64x2_256_mask",
                    "avx512.mask.broadcasti64x2.512" => "__builtin_ia32_broadcasti64x2_512_mask",
                    "avx512.mask.broadcasti64x4.512" => "__builtin_ia32_broadcasti64x4_512",
                    "avx512.mask.cmp.pd.128" => "__builtin_ia32_cmppd128_mask",
                    "avx512.mask.cmp.pd.256" => "__builtin_ia32_cmppd256_mask",
                    "avx512.mask.cmp.pd.512" => "__builtin_ia32_cmppd512_mask",
                    "avx512.mask.cmp.ps.128" => "__builtin_ia32_cmpps128_mask",
                    "avx512.mask.cmp.ps.256" => "__builtin_ia32_cmpps256_mask",
                    "avx512.mask.cmp.ps.512" => "__builtin_ia32_cmpps512_mask",
                    "avx512.mask.cmp.sd" => "__builtin_ia32_cmpsd_mask",
                    "avx512.mask.cmp.ss" => "__builtin_ia32_cmpss_mask",
                    "avx512.mask.compress.d.128" => "__builtin_ia32_compresssi128_mask",
                    "avx512.mask.compress.d.256" => "__builtin_ia32_compresssi256_mask",
                    "avx512.mask.compress.d.512" => "__builtin_ia32_compresssi512_mask",
                    "avx512.mask.compress.pd.128" => "__builtin_ia32_compressdf128_mask",
                    "avx512.mask.compress.pd.256" => "__builtin_ia32_compressdf256_mask",
                    "avx512.mask.compress.pd.512" => "__builtin_ia32_compressdf512_mask",
                    "avx512.mask.compress.ps.128" => "__builtin_ia32_compresssf128_mask",
                    "avx512.mask.compress.ps.256" => "__builtin_ia32_compresssf256_mask",
                    "avx512.mask.compress.ps.512" => "__builtin_ia32_compresssf512_mask",
                    "avx512.mask.compress.q.128" => "__builtin_ia32_compressdi128_mask",
                    "avx512.mask.compress.q.256" => "__builtin_ia32_compressdi256_mask",
                    "avx512.mask.compress.q.512" => "__builtin_ia32_compressdi512_mask",
                    "avx512.mask.compress.store.d.128" => "__builtin_ia32_compressstoresi128_mask",
                    "avx512.mask.compress.store.d.256" => "__builtin_ia32_compressstoresi256_mask",
                    "avx512.mask.compress.store.d.512" => "__builtin_ia32_compressstoresi512_mask",
                    "avx512.mask.compress.store.pd.128" => "__builtin_ia32_compressstoredf128_mask",
                    "avx512.mask.compress.store.pd.256" => "__builtin_ia32_compressstoredf256_mask",
                    "avx512.mask.compress.store.pd.512" => "__builtin_ia32_compressstoredf512_mask",
                    "avx512.mask.compress.store.ps.128" => "__builtin_ia32_compressstoresf128_mask",
                    "avx512.mask.compress.store.ps.256" => "__builtin_ia32_compressstoresf256_mask",
                    "avx512.mask.compress.store.ps.512" => "__builtin_ia32_compressstoresf512_mask",
                    "avx512.mask.compress.store.q.128" => "__builtin_ia32_compressstoredi128_mask",
                    "avx512.mask.compress.store.q.256" => "__builtin_ia32_compressstoredi256_mask",
                    "avx512.mask.compress.store.q.512" => "__builtin_ia32_compressstoredi512_mask",
                    "avx512.mask.conflict.d.128" => "__builtin_ia32_vpconflictsi_128_mask",
                    "avx512.mask.conflict.d.256" => "__builtin_ia32_vpconflictsi_256_mask",
                    "avx512.mask.conflict.d.512" => "__builtin_ia32_vpconflictsi_512_mask",
                    "avx512.mask.conflict.q.128" => "__builtin_ia32_vpconflictdi_128_mask",
                    "avx512.mask.conflict.q.256" => "__builtin_ia32_vpconflictdi_256_mask",
                    "avx512.mask.conflict.q.512" => "__builtin_ia32_vpconflictdi_512_mask",
                    "avx512.mask.cvtdq2pd.128" => "__builtin_ia32_cvtdq2pd128_mask",
                    "avx512.mask.cvtdq2pd.256" => "__builtin_ia32_cvtdq2pd256_mask",
                    "avx512.mask.cvtdq2pd.512" => "__builtin_ia32_cvtdq2pd512_mask",
                    "avx512.mask.cvtdq2ps.128" => "__builtin_ia32_cvtdq2ps128_mask",
                    "avx512.mask.cvtdq2ps.256" => "__builtin_ia32_cvtdq2ps256_mask",
                    "avx512.mask.cvtdq2ps.512" => "__builtin_ia32_cvtdq2ps512_mask",
                    "avx512.mask.cvtpd2dq.128" => "__builtin_ia32_cvtpd2dq128_mask",
                    "avx512.mask.cvtpd2dq.256" => "__builtin_ia32_cvtpd2dq256_mask",
                    "avx512.mask.cvtpd2dq.512" => "__builtin_ia32_cvtpd2dq512_mask",
                    "avx512.mask.cvtpd2ps" => "__builtin_ia32_cvtpd2ps_mask",
                    "avx512.mask.cvtpd2ps.256" => "__builtin_ia32_cvtpd2ps256_mask",
                    "avx512.mask.cvtpd2ps.512" => "__builtin_ia32_cvtpd2ps512_mask",
                    "avx512.mask.cvtpd2qq.128" => "__builtin_ia32_cvtpd2qq128_mask",
                    "avx512.mask.cvtpd2qq.256" => "__builtin_ia32_cvtpd2qq256_mask",
                    "avx512.mask.cvtpd2qq.512" => "__builtin_ia32_cvtpd2qq512_mask",
                    "avx512.mask.cvtpd2udq.128" => "__builtin_ia32_cvtpd2udq128_mask",
                    "avx512.mask.cvtpd2udq.256" => "__builtin_ia32_cvtpd2udq256_mask",
                    "avx512.mask.cvtpd2udq.512" => "__builtin_ia32_cvtpd2udq512_mask",
                    "avx512.mask.cvtpd2uqq.128" => "__builtin_ia32_cvtpd2uqq128_mask",
                    "avx512.mask.cvtpd2uqq.256" => "__builtin_ia32_cvtpd2uqq256_mask",
                    "avx512.mask.cvtpd2uqq.512" => "__builtin_ia32_cvtpd2uqq512_mask",
                    "avx512.mask.cvtps2dq.128" => "__builtin_ia32_cvtps2dq128_mask",
                    "avx512.mask.cvtps2dq.256" => "__builtin_ia32_cvtps2dq256_mask",
                    "avx512.mask.cvtps2dq.512" => "__builtin_ia32_cvtps2dq512_mask",
                    "avx512.mask.cvtps2pd.128" => "__builtin_ia32_cvtps2pd128_mask",
                    "avx512.mask.cvtps2pd.256" => "__builtin_ia32_cvtps2pd256_mask",
                    "avx512.mask.cvtps2pd.512" => "__builtin_ia32_cvtps2pd512_mask",
                    "avx512.mask.cvtps2qq.128" => "__builtin_ia32_cvtps2qq128_mask",
                    "avx512.mask.cvtps2qq.256" => "__builtin_ia32_cvtps2qq256_mask",
                    "avx512.mask.cvtps2qq.512" => "__builtin_ia32_cvtps2qq512_mask",
                    "avx512.mask.cvtps2udq.128" => "__builtin_ia32_cvtps2udq128_mask",
                    "avx512.mask.cvtps2udq.256" => "__builtin_ia32_cvtps2udq256_mask",
                    "avx512.mask.cvtps2udq.512" => "__builtin_ia32_cvtps2udq512_mask",
                    "avx512.mask.cvtps2uqq.128" => "__builtin_ia32_cvtps2uqq128_mask",
                    "avx512.mask.cvtps2uqq.256" => "__builtin_ia32_cvtps2uqq256_mask",
                    "avx512.mask.cvtps2uqq.512" => "__builtin_ia32_cvtps2uqq512_mask",
                    "avx512.mask.cvtqq2pd.128" => "__builtin_ia32_cvtqq2pd128_mask",
                    "avx512.mask.cvtqq2pd.256" => "__builtin_ia32_cvtqq2pd256_mask",
                    "avx512.mask.cvtqq2pd.512" => "__builtin_ia32_cvtqq2pd512_mask",
                    "avx512.mask.cvtqq2ps.128" => "__builtin_ia32_cvtqq2ps128_mask",
                    "avx512.mask.cvtqq2ps.256" => "__builtin_ia32_cvtqq2ps256_mask",
                    "avx512.mask.cvtqq2ps.512" => "__builtin_ia32_cvtqq2ps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.cvtsd2ss.round" => "__builtin_ia32_cvtsd2ss_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.cvtss2sd.round" => "__builtin_ia32_cvtss2sd_round_mask",
                    "avx512.mask.cvttpd2dq.128" => "__builtin_ia32_cvttpd2dq128_mask",
                    "avx512.mask.cvttpd2dq.256" => "__builtin_ia32_cvttpd2dq256_mask",
                    "avx512.mask.cvttpd2dq.512" => "__builtin_ia32_cvttpd2dq512_mask",
                    "avx512.mask.cvttpd2qq.128" => "__builtin_ia32_cvttpd2qq128_mask",
                    "avx512.mask.cvttpd2qq.256" => "__builtin_ia32_cvttpd2qq256_mask",
                    "avx512.mask.cvttpd2qq.512" => "__builtin_ia32_cvttpd2qq512_mask",
                    "avx512.mask.cvttpd2udq.128" => "__builtin_ia32_cvttpd2udq128_mask",
                    "avx512.mask.cvttpd2udq.256" => "__builtin_ia32_cvttpd2udq256_mask",
                    "avx512.mask.cvttpd2udq.512" => "__builtin_ia32_cvttpd2udq512_mask",
                    "avx512.mask.cvttpd2uqq.128" => "__builtin_ia32_cvttpd2uqq128_mask",
                    "avx512.mask.cvttpd2uqq.256" => "__builtin_ia32_cvttpd2uqq256_mask",
                    "avx512.mask.cvttpd2uqq.512" => "__builtin_ia32_cvttpd2uqq512_mask",
                    "avx512.mask.cvttps2dq.128" => "__builtin_ia32_cvttps2dq128_mask",
                    "avx512.mask.cvttps2dq.256" => "__builtin_ia32_cvttps2dq256_mask",
                    "avx512.mask.cvttps2dq.512" => "__builtin_ia32_cvttps2dq512_mask",
                    "avx512.mask.cvttps2qq.128" => "__builtin_ia32_cvttps2qq128_mask",
                    "avx512.mask.cvttps2qq.256" => "__builtin_ia32_cvttps2qq256_mask",
                    "avx512.mask.cvttps2qq.512" => "__builtin_ia32_cvttps2qq512_mask",
                    "avx512.mask.cvttps2udq.128" => "__builtin_ia32_cvttps2udq128_mask",
                    "avx512.mask.cvttps2udq.256" => "__builtin_ia32_cvttps2udq256_mask",
                    "avx512.mask.cvttps2udq.512" => "__builtin_ia32_cvttps2udq512_mask",
                    "avx512.mask.cvttps2uqq.128" => "__builtin_ia32_cvttps2uqq128_mask",
                    "avx512.mask.cvttps2uqq.256" => "__builtin_ia32_cvttps2uqq256_mask",
                    "avx512.mask.cvttps2uqq.512" => "__builtin_ia32_cvttps2uqq512_mask",
                    "avx512.mask.cvtudq2pd.128" => "__builtin_ia32_cvtudq2pd128_mask",
                    "avx512.mask.cvtudq2pd.256" => "__builtin_ia32_cvtudq2pd256_mask",
                    "avx512.mask.cvtudq2pd.512" => "__builtin_ia32_cvtudq2pd512_mask",
                    "avx512.mask.cvtudq2ps.128" => "__builtin_ia32_cvtudq2ps128_mask",
                    "avx512.mask.cvtudq2ps.256" => "__builtin_ia32_cvtudq2ps256_mask",
                    "avx512.mask.cvtudq2ps.512" => "__builtin_ia32_cvtudq2ps512_mask",
                    "avx512.mask.cvtuqq2pd.128" => "__builtin_ia32_cvtuqq2pd128_mask",
                    "avx512.mask.cvtuqq2pd.256" => "__builtin_ia32_cvtuqq2pd256_mask",
                    "avx512.mask.cvtuqq2pd.512" => "__builtin_ia32_cvtuqq2pd512_mask",
                    "avx512.mask.cvtuqq2ps.128" => "__builtin_ia32_cvtuqq2ps128_mask",
                    "avx512.mask.cvtuqq2ps.256" => "__builtin_ia32_cvtuqq2ps256_mask",
                    "avx512.mask.cvtuqq2ps.512" => "__builtin_ia32_cvtuqq2ps512_mask",
                    "avx512.mask.dbpsadbw.128" => "__builtin_ia32_dbpsadbw128_mask",
                    "avx512.mask.dbpsadbw.256" => "__builtin_ia32_dbpsadbw256_mask",
                    "avx512.mask.dbpsadbw.512" => "__builtin_ia32_dbpsadbw512_mask",
                    "avx512.mask.div.pd.128" => "__builtin_ia32_divpd_mask",
                    "avx512.mask.div.pd.256" => "__builtin_ia32_divpd256_mask",
                    "avx512.mask.div.pd.512" => "__builtin_ia32_divpd512_mask",
                    "avx512.mask.div.ps.128" => "__builtin_ia32_divps_mask",
                    "avx512.mask.div.ps.256" => "__builtin_ia32_divps256_mask",
                    "avx512.mask.div.ps.512" => "__builtin_ia32_divps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.div.sd.round" => "__builtin_ia32_divsd_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.div.ss.round" => "__builtin_ia32_divss_round_mask",
                    "avx512.mask.expand.d.128" => "__builtin_ia32_expandsi128_mask",
                    "avx512.mask.expand.d.256" => "__builtin_ia32_expandsi256_mask",
                    "avx512.mask.expand.d.512" => "__builtin_ia32_expandsi512_mask",
                    "avx512.mask.expand.load.d.128" => "__builtin_ia32_expandloadsi128_mask",
                    "avx512.mask.expand.load.d.256" => "__builtin_ia32_expandloadsi256_mask",
                    "avx512.mask.expand.load.d.512" => "__builtin_ia32_expandloadsi512_mask",
                    "avx512.mask.expand.load.pd.128" => "__builtin_ia32_expandloaddf128_mask",
                    "avx512.mask.expand.load.pd.256" => "__builtin_ia32_expandloaddf256_mask",
                    "avx512.mask.expand.load.pd.512" => "__builtin_ia32_expandloaddf512_mask",
                    "avx512.mask.expand.load.ps.128" => "__builtin_ia32_expandloadsf128_mask",
                    "avx512.mask.expand.load.ps.256" => "__builtin_ia32_expandloadsf256_mask",
                    "avx512.mask.expand.load.ps.512" => "__builtin_ia32_expandloadsf512_mask",
                    "avx512.mask.expand.load.q.128" => "__builtin_ia32_expandloaddi128_mask",
                    "avx512.mask.expand.load.q.256" => "__builtin_ia32_expandloaddi256_mask",
                    "avx512.mask.expand.load.q.512" => "__builtin_ia32_expandloaddi512_mask",
                    "avx512.mask.expand.pd.128" => "__builtin_ia32_expanddf128_mask",
                    "avx512.mask.expand.pd.256" => "__builtin_ia32_expanddf256_mask",
                    "avx512.mask.expand.pd.512" => "__builtin_ia32_expanddf512_mask",
                    "avx512.mask.expand.ps.128" => "__builtin_ia32_expandsf128_mask",
                    "avx512.mask.expand.ps.256" => "__builtin_ia32_expandsf256_mask",
                    "avx512.mask.expand.ps.512" => "__builtin_ia32_expandsf512_mask",
                    "avx512.mask.expand.q.128" => "__builtin_ia32_expanddi128_mask",
                    "avx512.mask.expand.q.256" => "__builtin_ia32_expanddi256_mask",
                    "avx512.mask.expand.q.512" => "__builtin_ia32_expanddi512_mask",
                    "avx512.mask.fixupimm.pd.128" => "__builtin_ia32_fixupimmpd128_mask",
                    "avx512.mask.fixupimm.pd.256" => "__builtin_ia32_fixupimmpd256_mask",
                    "avx512.mask.fixupimm.pd.512" => "__builtin_ia32_fixupimmpd512_mask",
                    "avx512.mask.fixupimm.ps.128" => "__builtin_ia32_fixupimmps128_mask",
                    "avx512.mask.fixupimm.ps.256" => "__builtin_ia32_fixupimmps256_mask",
                    "avx512.mask.fixupimm.ps.512" => "__builtin_ia32_fixupimmps512_mask",
                    "avx512.mask.fixupimm.sd" => "__builtin_ia32_fixupimmsd_mask",
                    "avx512.mask.fixupimm.ss" => "__builtin_ia32_fixupimmss_mask",
                    "avx512.mask.fpclass.pd.128" => "__builtin_ia32_fpclasspd128_mask",
                    "avx512.mask.fpclass.pd.256" => "__builtin_ia32_fpclasspd256_mask",
                    "avx512.mask.fpclass.pd.512" => "__builtin_ia32_fpclasspd512_mask",
                    "avx512.mask.fpclass.ps.128" => "__builtin_ia32_fpclassps128_mask",
                    "avx512.mask.fpclass.ps.256" => "__builtin_ia32_fpclassps256_mask",
                    "avx512.mask.fpclass.ps.512" => "__builtin_ia32_fpclassps512_mask",
                    "avx512.mask.fpclass.sd" => "__builtin_ia32_fpclasssd_mask",
                    "avx512.mask.fpclass.ss" => "__builtin_ia32_fpclassss_mask",
                    "avx512.mask.getexp.pd.128" => "__builtin_ia32_getexppd128_mask",
                    "avx512.mask.getexp.pd.256" => "__builtin_ia32_getexppd256_mask",
                    "avx512.mask.getexp.pd.512" => "__builtin_ia32_getexppd512_mask",
                    "avx512.mask.getexp.ps.128" => "__builtin_ia32_getexpps128_mask",
                    "avx512.mask.getexp.ps.256" => "__builtin_ia32_getexpps256_mask",
                    "avx512.mask.getexp.ps.512" => "__builtin_ia32_getexpps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.getexp.sd" => "__builtin_ia32_getexpsd128_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.getexp.ss" => "__builtin_ia32_getexpss128_round_mask",
                    "avx512.mask.getmant.pd.128" => "__builtin_ia32_getmantpd128_mask",
                    "avx512.mask.getmant.pd.256" => "__builtin_ia32_getmantpd256_mask",
                    "avx512.mask.getmant.pd.512" => "__builtin_ia32_getmantpd512_mask",
                    "avx512.mask.getmant.ps.128" => "__builtin_ia32_getmantps128_mask",
                    "avx512.mask.getmant.ps.256" => "__builtin_ia32_getmantps256_mask",
                    "avx512.mask.getmant.ps.512" => "__builtin_ia32_getmantps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.getmant.sd" => "__builtin_ia32_getmantsd_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.getmant.ss" => "__builtin_ia32_getmantss_round_mask",
                    "avx512.mask.insertf32x4.256" => "__builtin_ia32_insertf32x4_256_mask",
                    "avx512.mask.insertf32x4.512" => "__builtin_ia32_insertf32x4_mask",
                    "avx512.mask.insertf32x8.512" => "__builtin_ia32_insertf32x8_mask",
                    "avx512.mask.insertf64x2.256" => "__builtin_ia32_insertf64x2_256_mask",
                    "avx512.mask.insertf64x2.512" => "__builtin_ia32_insertf64x2_512_mask",
                    "avx512.mask.insertf64x4.512" => "__builtin_ia32_insertf64x4_mask",
                    "avx512.mask.inserti32x4.256" => "__builtin_ia32_inserti32x4_256_mask",
                    "avx512.mask.inserti32x4.512" => "__builtin_ia32_inserti32x4_mask",
                    "avx512.mask.inserti32x8.512" => "__builtin_ia32_inserti32x8_mask",
                    "avx512.mask.inserti64x2.256" => "__builtin_ia32_inserti64x2_256_mask",
                    "avx512.mask.inserti64x2.512" => "__builtin_ia32_inserti64x2_512_mask",
                    "avx512.mask.inserti64x4.512" => "__builtin_ia32_inserti64x4_mask",
                    "avx512.mask.loadu.d.512" => "__builtin_ia32_loaddqusi512_mask",
                    "avx512.mask.loadu.pd.512" => "__builtin_ia32_loadupd512_mask",
                    "avx512.mask.loadu.ps.512" => "__builtin_ia32_loadups512_mask",
                    "avx512.mask.loadu.q.512" => "__builtin_ia32_loaddqudi512_mask",
                    "avx512.mask.lzcnt.d.512" => "__builtin_ia32_vplzcntd_512_mask",
                    "avx512.mask.lzcnt.q.512" => "__builtin_ia32_vplzcntq_512_mask",
                    "avx512.mask.max.pd.128" => "__builtin_ia32_maxpd_mask",
                    "avx512.mask.max.pd.256" => "__builtin_ia32_maxpd256_mask",
                    "avx512.mask.max.pd.512" => "__builtin_ia32_maxpd512_mask",
                    "avx512.mask.max.ps.128" => "__builtin_ia32_maxps_mask",
                    "avx512.mask.max.ps.256" => "__builtin_ia32_maxps256_mask",
                    "avx512.mask.max.ps.512" => "__builtin_ia32_maxps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.max.sd.round" => "__builtin_ia32_maxsd_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.max.ss.round" => "__builtin_ia32_maxss_round_mask",
                    "avx512.mask.min.pd.128" => "__builtin_ia32_minpd_mask",
                    "avx512.mask.min.pd.256" => "__builtin_ia32_minpd256_mask",
                    "avx512.mask.min.pd.512" => "__builtin_ia32_minpd512_mask",
                    "avx512.mask.min.ps.128" => "__builtin_ia32_minps_mask",
                    "avx512.mask.min.ps.256" => "__builtin_ia32_minps256_mask",
                    "avx512.mask.min.ps.512" => "__builtin_ia32_minps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.min.sd.round" => "__builtin_ia32_minsd_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.min.ss.round" => "__builtin_ia32_minss_round_mask",
                    "avx512.mask.move.sd" => "__builtin_ia32_movsd_mask",
                    "avx512.mask.move.ss" => "__builtin_ia32_movss_mask",
                    "avx512.mask.mul.pd.128" => "__builtin_ia32_mulpd_mask",
                    "avx512.mask.mul.pd.256" => "__builtin_ia32_mulpd256_mask",
                    "avx512.mask.mul.pd.512" => "__builtin_ia32_mulpd512_mask",
                    "avx512.mask.mul.ps.128" => "__builtin_ia32_mulps_mask",
                    "avx512.mask.mul.ps.256" => "__builtin_ia32_mulps256_mask",
                    "avx512.mask.mul.ps.512" => "__builtin_ia32_mulps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.mul.sd.round" => "__builtin_ia32_mulsd_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.mul.ss.round" => "__builtin_ia32_mulss_round_mask",
                    "avx512.mask.or.pd.128" => "__builtin_ia32_orpd128_mask",
                    "avx512.mask.or.pd.256" => "__builtin_ia32_orpd256_mask",
                    "avx512.mask.or.pd.512" => "__builtin_ia32_orpd512_mask",
                    "avx512.mask.or.ps.128" => "__builtin_ia32_orps128_mask",
                    "avx512.mask.or.ps.256" => "__builtin_ia32_orps256_mask",
                    "avx512.mask.or.ps.512" => "__builtin_ia32_orps512_mask",
                    "avx512.mask.pabs.b.128" => "__builtin_ia32_pabsb128_mask",
                    "avx512.mask.pabs.b.256" => "__builtin_ia32_pabsb256_mask",
                    "avx512.mask.pabs.b.512" => "__builtin_ia32_pabsb512_mask",
                    "avx512.mask.pabs.d.128" => "__builtin_ia32_pabsd128_mask",
                    "avx512.mask.pabs.d.256" => "__builtin_ia32_pabsd256_mask",
                    "avx512.mask.pabs.d.512" => "__builtin_ia32_pabsd512_mask",
                    "avx512.mask.pabs.q.128" => "__builtin_ia32_pabsq128_mask",
                    "avx512.mask.pabs.q.256" => "__builtin_ia32_pabsq256_mask",
                    "avx512.mask.pabs.q.512" => "__builtin_ia32_pabsq512_mask",
                    "avx512.mask.pabs.w.128" => "__builtin_ia32_pabsw128_mask",
                    "avx512.mask.pabs.w.256" => "__builtin_ia32_pabsw256_mask",
                    "avx512.mask.pabs.w.512" => "__builtin_ia32_pabsw512_mask",
                    "avx512.mask.packssdw.128" => "__builtin_ia32_packssdw128_mask",
                    "avx512.mask.packssdw.256" => "__builtin_ia32_packssdw256_mask",
                    "avx512.mask.packssdw.512" => "__builtin_ia32_packssdw512_mask",
                    "avx512.mask.packsswb.128" => "__builtin_ia32_packsswb128_mask",
                    "avx512.mask.packsswb.256" => "__builtin_ia32_packsswb256_mask",
                    "avx512.mask.packsswb.512" => "__builtin_ia32_packsswb512_mask",
                    "avx512.mask.packusdw.128" => "__builtin_ia32_packusdw128_mask",
                    "avx512.mask.packusdw.256" => "__builtin_ia32_packusdw256_mask",
                    "avx512.mask.packusdw.512" => "__builtin_ia32_packusdw512_mask",
                    "avx512.mask.packuswb.128" => "__builtin_ia32_packuswb128_mask",
                    "avx512.mask.packuswb.256" => "__builtin_ia32_packuswb256_mask",
                    "avx512.mask.packuswb.512" => "__builtin_ia32_packuswb512_mask",
                    "avx512.mask.padd.b.128" => "__builtin_ia32_paddb128_mask",
                    "avx512.mask.padd.b.256" => "__builtin_ia32_paddb256_mask",
                    "avx512.mask.padd.b.512" => "__builtin_ia32_paddb512_mask",
                    "avx512.mask.padd.d.128" => "__builtin_ia32_paddd128_mask",
                    "avx512.mask.padd.d.256" => "__builtin_ia32_paddd256_mask",
                    "avx512.mask.padd.d.512" => "__builtin_ia32_paddd512_mask",
                    "avx512.mask.padd.q.128" => "__builtin_ia32_paddq128_mask",
                    "avx512.mask.padd.q.256" => "__builtin_ia32_paddq256_mask",
                    "avx512.mask.padd.q.512" => "__builtin_ia32_paddq512_mask",
                    "avx512.mask.padd.w.128" => "__builtin_ia32_paddw128_mask",
                    "avx512.mask.padd.w.256" => "__builtin_ia32_paddw256_mask",
                    "avx512.mask.padd.w.512" => "__builtin_ia32_paddw512_mask",
                    "avx512.mask.padds.b.128" => "__builtin_ia32_paddsb128_mask",
                    "avx512.mask.padds.b.256" => "__builtin_ia32_paddsb256_mask",
                    "avx512.mask.padds.b.512" => "__builtin_ia32_paddsb512_mask",
                    "avx512.mask.padds.w.128" => "__builtin_ia32_paddsw128_mask",
                    "avx512.mask.padds.w.256" => "__builtin_ia32_paddsw256_mask",
                    "avx512.mask.padds.w.512" => "__builtin_ia32_paddsw512_mask",
                    "avx512.mask.paddus.b.128" => "__builtin_ia32_paddusb128_mask",
                    "avx512.mask.paddus.b.256" => "__builtin_ia32_paddusb256_mask",
                    "avx512.mask.paddus.b.512" => "__builtin_ia32_paddusb512_mask",
                    "avx512.mask.paddus.w.128" => "__builtin_ia32_paddusw128_mask",
                    "avx512.mask.paddus.w.256" => "__builtin_ia32_paddusw256_mask",
                    "avx512.mask.paddus.w.512" => "__builtin_ia32_paddusw512_mask",
                    "avx512.mask.pand.d.512" => "__builtin_ia32_pandd512_mask",
                    "avx512.mask.pand.q.512" => "__builtin_ia32_pandq512_mask",
                    "avx512.mask.pavg.b.128" => "__builtin_ia32_pavgb128_mask",
                    "avx512.mask.pavg.b.256" => "__builtin_ia32_pavgb256_mask",
                    "avx512.mask.pavg.b.512" => "__builtin_ia32_pavgb512_mask",
                    "avx512.mask.pavg.w.128" => "__builtin_ia32_pavgw128_mask",
                    "avx512.mask.pavg.w.256" => "__builtin_ia32_pavgw256_mask",
                    "avx512.mask.pavg.w.512" => "__builtin_ia32_pavgw512_mask",
                    "avx512.mask.pbroadcast.b.gpr.128" => "__builtin_ia32_pbroadcastb128_gpr_mask",
                    "avx512.mask.pbroadcast.b.gpr.256" => "__builtin_ia32_pbroadcastb256_gpr_mask",
                    "avx512.mask.pbroadcast.b.gpr.512" => "__builtin_ia32_pbroadcastb512_gpr_mask",
                    "avx512.mask.pbroadcast.d.gpr.128" => "__builtin_ia32_pbroadcastd128_gpr_mask",
                    "avx512.mask.pbroadcast.d.gpr.256" => "__builtin_ia32_pbroadcastd256_gpr_mask",
                    "avx512.mask.pbroadcast.d.gpr.512" => "__builtin_ia32_pbroadcastd512_gpr_mask",
                    "avx512.mask.pbroadcast.q.gpr.128" => "__builtin_ia32_pbroadcastq128_gpr_mask",
                    "avx512.mask.pbroadcast.q.gpr.256" => "__builtin_ia32_pbroadcastq256_gpr_mask",
                    "avx512.mask.pbroadcast.q.gpr.512" => "__builtin_ia32_pbroadcastq512_gpr_mask",
                    "avx512.mask.pbroadcast.q.mem.512" => "__builtin_ia32_pbroadcastq512_mem_mask",
                    "avx512.mask.pbroadcast.w.gpr.128" => "__builtin_ia32_pbroadcastw128_gpr_mask",
                    "avx512.mask.pbroadcast.w.gpr.256" => "__builtin_ia32_pbroadcastw256_gpr_mask",
                    "avx512.mask.pbroadcast.w.gpr.512" => "__builtin_ia32_pbroadcastw512_gpr_mask",
                    "avx512.mask.pcmpeq.b.128" => "__builtin_ia32_pcmpeqb128_mask",
                    "avx512.mask.pcmpeq.b.256" => "__builtin_ia32_pcmpeqb256_mask",
                    "avx512.mask.pcmpeq.b.512" => "__builtin_ia32_pcmpeqb512_mask",
                    "avx512.mask.pcmpeq.d.128" => "__builtin_ia32_pcmpeqd128_mask",
                    "avx512.mask.pcmpeq.d.256" => "__builtin_ia32_pcmpeqd256_mask",
                    "avx512.mask.pcmpeq.d.512" => "__builtin_ia32_pcmpeqd512_mask",
                    "avx512.mask.pcmpeq.q.128" => "__builtin_ia32_pcmpeqq128_mask",
                    "avx512.mask.pcmpeq.q.256" => "__builtin_ia32_pcmpeqq256_mask",
                    "avx512.mask.pcmpeq.q.512" => "__builtin_ia32_pcmpeqq512_mask",
                    "avx512.mask.pcmpeq.w.128" => "__builtin_ia32_pcmpeqw128_mask",
                    "avx512.mask.pcmpeq.w.256" => "__builtin_ia32_pcmpeqw256_mask",
                    "avx512.mask.pcmpeq.w.512" => "__builtin_ia32_pcmpeqw512_mask",
                    "avx512.mask.pcmpgt.b.128" => "__builtin_ia32_pcmpgtb128_mask",
                    "avx512.mask.pcmpgt.b.256" => "__builtin_ia32_pcmpgtb256_mask",
                    "avx512.mask.pcmpgt.b.512" => "__builtin_ia32_pcmpgtb512_mask",
                    "avx512.mask.pcmpgt.d.128" => "__builtin_ia32_pcmpgtd128_mask",
                    "avx512.mask.pcmpgt.d.256" => "__builtin_ia32_pcmpgtd256_mask",
                    "avx512.mask.pcmpgt.d.512" => "__builtin_ia32_pcmpgtd512_mask",
                    "avx512.mask.pcmpgt.q.128" => "__builtin_ia32_pcmpgtq128_mask",
                    "avx512.mask.pcmpgt.q.256" => "__builtin_ia32_pcmpgtq256_mask",
                    "avx512.mask.pcmpgt.q.512" => "__builtin_ia32_pcmpgtq512_mask",
                    "avx512.mask.pcmpgt.w.128" => "__builtin_ia32_pcmpgtw128_mask",
                    "avx512.mask.pcmpgt.w.256" => "__builtin_ia32_pcmpgtw256_mask",
                    "avx512.mask.pcmpgt.w.512" => "__builtin_ia32_pcmpgtw512_mask",
                    "avx512.mask.permvar.df.256" => "__builtin_ia32_permvardf256_mask",
                    "avx512.mask.permvar.df.512" => "__builtin_ia32_permvardf512_mask",
                    "avx512.mask.permvar.di.256" => "__builtin_ia32_permvardi256_mask",
                    "avx512.mask.permvar.di.512" => "__builtin_ia32_permvardi512_mask",
                    "avx512.mask.permvar.hi.128" => "__builtin_ia32_permvarhi128_mask",
                    "avx512.mask.permvar.hi.256" => "__builtin_ia32_permvarhi256_mask",
                    "avx512.mask.permvar.hi.512" => "__builtin_ia32_permvarhi512_mask",
                    "avx512.mask.permvar.qi.128" => "__builtin_ia32_permvarqi128_mask",
                    "avx512.mask.permvar.qi.256" => "__builtin_ia32_permvarqi256_mask",
                    "avx512.mask.permvar.qi.512" => "__builtin_ia32_permvarqi512_mask",
                    "avx512.mask.permvar.sf.256" => "__builtin_ia32_permvarsf256_mask",
                    "avx512.mask.permvar.sf.512" => "__builtin_ia32_permvarsf512_mask",
                    "avx512.mask.permvar.si.256" => "__builtin_ia32_permvarsi256_mask",
                    "avx512.mask.permvar.si.512" => "__builtin_ia32_permvarsi512_mask",
                    "avx512.mask.pmaddubs.w.128" => "__builtin_ia32_pmaddubsw128_mask",
                    "avx512.mask.pmaddubs.w.256" => "__builtin_ia32_pmaddubsw256_mask",
                    "avx512.mask.pmaddubs.w.512" => "__builtin_ia32_pmaddubsw512_mask",
                    "avx512.mask.pmaddw.d.128" => "__builtin_ia32_pmaddwd128_mask",
                    "avx512.mask.pmaddw.d.256" => "__builtin_ia32_pmaddwd256_mask",
                    "avx512.mask.pmaddw.d.512" => "__builtin_ia32_pmaddwd512_mask",
                    "avx512.mask.pmaxs.b.128" => "__builtin_ia32_pmaxsb128_mask",
                    "avx512.mask.pmaxs.b.256" => "__builtin_ia32_pmaxsb256_mask",
                    "avx512.mask.pmaxs.b.512" => "__builtin_ia32_pmaxsb512_mask",
                    "avx512.mask.pmaxs.d.128" => "__builtin_ia32_pmaxsd128_mask",
                    "avx512.mask.pmaxs.d.256" => "__builtin_ia32_pmaxsd256_mask",
                    "avx512.mask.pmaxs.d.512" => "__builtin_ia32_pmaxsd512_mask",
                    "avx512.mask.pmaxs.q.128" => "__builtin_ia32_pmaxsq128_mask",
                    "avx512.mask.pmaxs.q.256" => "__builtin_ia32_pmaxsq256_mask",
                    "avx512.mask.pmaxs.q.512" => "__builtin_ia32_pmaxsq512_mask",
                    "avx512.mask.pmaxs.w.128" => "__builtin_ia32_pmaxsw128_mask",
                    "avx512.mask.pmaxs.w.256" => "__builtin_ia32_pmaxsw256_mask",
                    "avx512.mask.pmaxs.w.512" => "__builtin_ia32_pmaxsw512_mask",
                    "avx512.mask.pmaxu.b.128" => "__builtin_ia32_pmaxub128_mask",
                    "avx512.mask.pmaxu.b.256" => "__builtin_ia32_pmaxub256_mask",
                    "avx512.mask.pmaxu.b.512" => "__builtin_ia32_pmaxub512_mask",
                    "avx512.mask.pmaxu.d.128" => "__builtin_ia32_pmaxud128_mask",
                    "avx512.mask.pmaxu.d.256" => "__builtin_ia32_pmaxud256_mask",
                    "avx512.mask.pmaxu.d.512" => "__builtin_ia32_pmaxud512_mask",
                    "avx512.mask.pmaxu.q.128" => "__builtin_ia32_pmaxuq128_mask",
                    "avx512.mask.pmaxu.q.256" => "__builtin_ia32_pmaxuq256_mask",
                    "avx512.mask.pmaxu.q.512" => "__builtin_ia32_pmaxuq512_mask",
                    "avx512.mask.pmaxu.w.128" => "__builtin_ia32_pmaxuw128_mask",
                    "avx512.mask.pmaxu.w.256" => "__builtin_ia32_pmaxuw256_mask",
                    "avx512.mask.pmaxu.w.512" => "__builtin_ia32_pmaxuw512_mask",
                    "avx512.mask.pmins.b.128" => "__builtin_ia32_pminsb128_mask",
                    "avx512.mask.pmins.b.256" => "__builtin_ia32_pminsb256_mask",
                    "avx512.mask.pmins.b.512" => "__builtin_ia32_pminsb512_mask",
                    "avx512.mask.pmins.d.128" => "__builtin_ia32_pminsd128_mask",
                    "avx512.mask.pmins.d.256" => "__builtin_ia32_pminsd256_mask",
                    "avx512.mask.pmins.d.512" => "__builtin_ia32_pminsd512_mask",
                    "avx512.mask.pmins.q.128" => "__builtin_ia32_pminsq128_mask",
                    "avx512.mask.pmins.q.256" => "__builtin_ia32_pminsq256_mask",
                    "avx512.mask.pmins.q.512" => "__builtin_ia32_pminsq512_mask",
                    "avx512.mask.pmins.w.128" => "__builtin_ia32_pminsw128_mask",
                    "avx512.mask.pmins.w.256" => "__builtin_ia32_pminsw256_mask",
                    "avx512.mask.pmins.w.512" => "__builtin_ia32_pminsw512_mask",
                    "avx512.mask.pminu.b.128" => "__builtin_ia32_pminub128_mask",
                    "avx512.mask.pminu.b.256" => "__builtin_ia32_pminub256_mask",
                    "avx512.mask.pminu.b.512" => "__builtin_ia32_pminub512_mask",
                    "avx512.mask.pminu.d.128" => "__builtin_ia32_pminud128_mask",
                    "avx512.mask.pminu.d.256" => "__builtin_ia32_pminud256_mask",
                    "avx512.mask.pminu.d.512" => "__builtin_ia32_pminud512_mask",
                    "avx512.mask.pminu.q.128" => "__builtin_ia32_pminuq128_mask",
                    "avx512.mask.pminu.q.256" => "__builtin_ia32_pminuq256_mask",
                    "avx512.mask.pminu.q.512" => "__builtin_ia32_pminuq512_mask",
                    "avx512.mask.pminu.w.128" => "__builtin_ia32_pminuw128_mask",
                    "avx512.mask.pminu.w.256" => "__builtin_ia32_pminuw256_mask",
                    "avx512.mask.pminu.w.512" => "__builtin_ia32_pminuw512_mask",
                    "avx512.mask.pmov.db.128" => "__builtin_ia32_pmovdb128_mask",
                    "avx512.mask.pmov.db.256" => "__builtin_ia32_pmovdb256_mask",
                    "avx512.mask.pmov.db.512" => "__builtin_ia32_pmovdb512_mask",
                    "avx512.mask.pmov.db.mem.128" => "__builtin_ia32_pmovdb128mem_mask",
                    "avx512.mask.pmov.db.mem.256" => "__builtin_ia32_pmovdb256mem_mask",
                    "avx512.mask.pmov.db.mem.512" => "__builtin_ia32_pmovdb512mem_mask",
                    "avx512.mask.pmov.dw.128" => "__builtin_ia32_pmovdw128_mask",
                    "avx512.mask.pmov.dw.256" => "__builtin_ia32_pmovdw256_mask",
                    "avx512.mask.pmov.dw.512" => "__builtin_ia32_pmovdw512_mask",
                    "avx512.mask.pmov.dw.mem.128" => "__builtin_ia32_pmovdw128mem_mask",
                    "avx512.mask.pmov.dw.mem.256" => "__builtin_ia32_pmovdw256mem_mask",
                    "avx512.mask.pmov.dw.mem.512" => "__builtin_ia32_pmovdw512mem_mask",
                    "avx512.mask.pmov.qb.128" => "__builtin_ia32_pmovqb128_mask",
                    "avx512.mask.pmov.qb.256" => "__builtin_ia32_pmovqb256_mask",
                    "avx512.mask.pmov.qb.512" => "__builtin_ia32_pmovqb512_mask",
                    "avx512.mask.pmov.qb.mem.128" => "__builtin_ia32_pmovqb128mem_mask",
                    "avx512.mask.pmov.qb.mem.256" => "__builtin_ia32_pmovqb256mem_mask",
                    "avx512.mask.pmov.qb.mem.512" => "__builtin_ia32_pmovqb512mem_mask",
                    "avx512.mask.pmov.qd.128" => "__builtin_ia32_pmovqd128_mask",
                    "avx512.mask.pmov.qd.256" => "__builtin_ia32_pmovqd256_mask",
                    "avx512.mask.pmov.qd.512" => "__builtin_ia32_pmovqd512_mask",
                    "avx512.mask.pmov.qd.mem.128" => "__builtin_ia32_pmovqd128mem_mask",
                    "avx512.mask.pmov.qd.mem.256" => "__builtin_ia32_pmovqd256mem_mask",
                    "avx512.mask.pmov.qd.mem.512" => "__builtin_ia32_pmovqd512mem_mask",
                    "avx512.mask.pmov.qw.128" => "__builtin_ia32_pmovqw128_mask",
                    "avx512.mask.pmov.qw.256" => "__builtin_ia32_pmovqw256_mask",
                    "avx512.mask.pmov.qw.512" => "__builtin_ia32_pmovqw512_mask",
                    "avx512.mask.pmov.qw.mem.128" => "__builtin_ia32_pmovqw128mem_mask",
                    "avx512.mask.pmov.qw.mem.256" => "__builtin_ia32_pmovqw256mem_mask",
                    "avx512.mask.pmov.qw.mem.512" => "__builtin_ia32_pmovqw512mem_mask",
                    "avx512.mask.pmov.wb.128" => "__builtin_ia32_pmovwb128_mask",
                    "avx512.mask.pmov.wb.256" => "__builtin_ia32_pmovwb256_mask",
                    "avx512.mask.pmov.wb.512" => "__builtin_ia32_pmovwb512_mask",
                    "avx512.mask.pmov.wb.mem.128" => "__builtin_ia32_pmovwb128mem_mask",
                    "avx512.mask.pmov.wb.mem.256" => "__builtin_ia32_pmovwb256mem_mask",
                    "avx512.mask.pmov.wb.mem.512" => "__builtin_ia32_pmovwb512mem_mask",
                    "avx512.mask.pmovs.db.128" => "__builtin_ia32_pmovsdb128_mask",
                    "avx512.mask.pmovs.db.256" => "__builtin_ia32_pmovsdb256_mask",
                    "avx512.mask.pmovs.db.512" => "__builtin_ia32_pmovsdb512_mask",
                    "avx512.mask.pmovs.db.mem.128" => "__builtin_ia32_pmovsdb128mem_mask",
                    "avx512.mask.pmovs.db.mem.256" => "__builtin_ia32_pmovsdb256mem_mask",
                    "avx512.mask.pmovs.db.mem.512" => "__builtin_ia32_pmovsdb512mem_mask",
                    "avx512.mask.pmovs.dw.128" => "__builtin_ia32_pmovsdw128_mask",
                    "avx512.mask.pmovs.dw.256" => "__builtin_ia32_pmovsdw256_mask",
                    "avx512.mask.pmovs.dw.512" => "__builtin_ia32_pmovsdw512_mask",
                    "avx512.mask.pmovs.dw.mem.128" => "__builtin_ia32_pmovsdw128mem_mask",
                    "avx512.mask.pmovs.dw.mem.256" => "__builtin_ia32_pmovsdw256mem_mask",
                    "avx512.mask.pmovs.dw.mem.512" => "__builtin_ia32_pmovsdw512mem_mask",
                    "avx512.mask.pmovs.qb.128" => "__builtin_ia32_pmovsqb128_mask",
                    "avx512.mask.pmovs.qb.256" => "__builtin_ia32_pmovsqb256_mask",
                    "avx512.mask.pmovs.qb.512" => "__builtin_ia32_pmovsqb512_mask",
                    "avx512.mask.pmovs.qb.mem.128" => "__builtin_ia32_pmovsqb128mem_mask",
                    "avx512.mask.pmovs.qb.mem.256" => "__builtin_ia32_pmovsqb256mem_mask",
                    "avx512.mask.pmovs.qb.mem.512" => "__builtin_ia32_pmovsqb512mem_mask",
                    "avx512.mask.pmovs.qd.128" => "__builtin_ia32_pmovsqd128_mask",
                    "avx512.mask.pmovs.qd.256" => "__builtin_ia32_pmovsqd256_mask",
                    "avx512.mask.pmovs.qd.512" => "__builtin_ia32_pmovsqd512_mask",
                    "avx512.mask.pmovs.qd.mem.128" => "__builtin_ia32_pmovsqd128mem_mask",
                    "avx512.mask.pmovs.qd.mem.256" => "__builtin_ia32_pmovsqd256mem_mask",
                    "avx512.mask.pmovs.qd.mem.512" => "__builtin_ia32_pmovsqd512mem_mask",
                    "avx512.mask.pmovs.qw.128" => "__builtin_ia32_pmovsqw128_mask",
                    "avx512.mask.pmovs.qw.256" => "__builtin_ia32_pmovsqw256_mask",
                    "avx512.mask.pmovs.qw.512" => "__builtin_ia32_pmovsqw512_mask",
                    "avx512.mask.pmovs.qw.mem.128" => "__builtin_ia32_pmovsqw128mem_mask",
                    "avx512.mask.pmovs.qw.mem.256" => "__builtin_ia32_pmovsqw256mem_mask",
                    "avx512.mask.pmovs.qw.mem.512" => "__builtin_ia32_pmovsqw512mem_mask",
                    "avx512.mask.pmovs.wb.128" => "__builtin_ia32_pmovswb128_mask",
                    "avx512.mask.pmovs.wb.256" => "__builtin_ia32_pmovswb256_mask",
                    "avx512.mask.pmovs.wb.512" => "__builtin_ia32_pmovswb512_mask",
                    "avx512.mask.pmovs.wb.mem.128" => "__builtin_ia32_pmovswb128mem_mask",
                    "avx512.mask.pmovs.wb.mem.256" => "__builtin_ia32_pmovswb256mem_mask",
                    "avx512.mask.pmovs.wb.mem.512" => "__builtin_ia32_pmovswb512mem_mask",
                    "avx512.mask.pmovsxb.d.128" => "__builtin_ia32_pmovsxbd128_mask",
                    "avx512.mask.pmovsxb.d.256" => "__builtin_ia32_pmovsxbd256_mask",
                    "avx512.mask.pmovsxb.d.512" => "__builtin_ia32_pmovsxbd512_mask",
                    "avx512.mask.pmovsxb.q.128" => "__builtin_ia32_pmovsxbq128_mask",
                    "avx512.mask.pmovsxb.q.256" => "__builtin_ia32_pmovsxbq256_mask",
                    "avx512.mask.pmovsxb.q.512" => "__builtin_ia32_pmovsxbq512_mask",
                    "avx512.mask.pmovsxb.w.128" => "__builtin_ia32_pmovsxbw128_mask",
                    "avx512.mask.pmovsxb.w.256" => "__builtin_ia32_pmovsxbw256_mask",
                    "avx512.mask.pmovsxb.w.512" => "__builtin_ia32_pmovsxbw512_mask",
                    "avx512.mask.pmovsxd.q.128" => "__builtin_ia32_pmovsxdq128_mask",
                    "avx512.mask.pmovsxd.q.256" => "__builtin_ia32_pmovsxdq256_mask",
                    "avx512.mask.pmovsxd.q.512" => "__builtin_ia32_pmovsxdq512_mask",
                    "avx512.mask.pmovsxw.d.128" => "__builtin_ia32_pmovsxwd128_mask",
                    "avx512.mask.pmovsxw.d.256" => "__builtin_ia32_pmovsxwd256_mask",
                    "avx512.mask.pmovsxw.d.512" => "__builtin_ia32_pmovsxwd512_mask",
                    "avx512.mask.pmovsxw.q.128" => "__builtin_ia32_pmovsxwq128_mask",
                    "avx512.mask.pmovsxw.q.256" => "__builtin_ia32_pmovsxwq256_mask",
                    "avx512.mask.pmovsxw.q.512" => "__builtin_ia32_pmovsxwq512_mask",
                    "avx512.mask.pmovus.db.128" => "__builtin_ia32_pmovusdb128_mask",
                    "avx512.mask.pmovus.db.256" => "__builtin_ia32_pmovusdb256_mask",
                    "avx512.mask.pmovus.db.512" => "__builtin_ia32_pmovusdb512_mask",
                    "avx512.mask.pmovus.db.mem.128" => "__builtin_ia32_pmovusdb128mem_mask",
                    "avx512.mask.pmovus.db.mem.256" => "__builtin_ia32_pmovusdb256mem_mask",
                    "avx512.mask.pmovus.db.mem.512" => "__builtin_ia32_pmovusdb512mem_mask",
                    "avx512.mask.pmovus.dw.128" => "__builtin_ia32_pmovusdw128_mask",
                    "avx512.mask.pmovus.dw.256" => "__builtin_ia32_pmovusdw256_mask",
                    "avx512.mask.pmovus.dw.512" => "__builtin_ia32_pmovusdw512_mask",
                    "avx512.mask.pmovus.dw.mem.128" => "__builtin_ia32_pmovusdw128mem_mask",
                    "avx512.mask.pmovus.dw.mem.256" => "__builtin_ia32_pmovusdw256mem_mask",
                    "avx512.mask.pmovus.dw.mem.512" => "__builtin_ia32_pmovusdw512mem_mask",
                    "avx512.mask.pmovus.qb.128" => "__builtin_ia32_pmovusqb128_mask",
                    "avx512.mask.pmovus.qb.256" => "__builtin_ia32_pmovusqb256_mask",
                    "avx512.mask.pmovus.qb.512" => "__builtin_ia32_pmovusqb512_mask",
                    "avx512.mask.pmovus.qb.mem.128" => "__builtin_ia32_pmovusqb128mem_mask",
                    "avx512.mask.pmovus.qb.mem.256" => "__builtin_ia32_pmovusqb256mem_mask",
                    "avx512.mask.pmovus.qb.mem.512" => "__builtin_ia32_pmovusqb512mem_mask",
                    "avx512.mask.pmovus.qd.128" => "__builtin_ia32_pmovusqd128_mask",
                    "avx512.mask.pmovus.qd.256" => "__builtin_ia32_pmovusqd256_mask",
                    "avx512.mask.pmovus.qd.512" => "__builtin_ia32_pmovusqd512_mask",
                    "avx512.mask.pmovus.qd.mem.128" => "__builtin_ia32_pmovusqd128mem_mask",
                    "avx512.mask.pmovus.qd.mem.256" => "__builtin_ia32_pmovusqd256mem_mask",
                    "avx512.mask.pmovus.qd.mem.512" => "__builtin_ia32_pmovusqd512mem_mask",
                    "avx512.mask.pmovus.qw.128" => "__builtin_ia32_pmovusqw128_mask",
                    "avx512.mask.pmovus.qw.256" => "__builtin_ia32_pmovusqw256_mask",
                    "avx512.mask.pmovus.qw.512" => "__builtin_ia32_pmovusqw512_mask",
                    "avx512.mask.pmovus.qw.mem.128" => "__builtin_ia32_pmovusqw128mem_mask",
                    "avx512.mask.pmovus.qw.mem.256" => "__builtin_ia32_pmovusqw256mem_mask",
                    "avx512.mask.pmovus.qw.mem.512" => "__builtin_ia32_pmovusqw512mem_mask",
                    "avx512.mask.pmovus.wb.128" => "__builtin_ia32_pmovuswb128_mask",
                    "avx512.mask.pmovus.wb.256" => "__builtin_ia32_pmovuswb256_mask",
                    "avx512.mask.pmovus.wb.512" => "__builtin_ia32_pmovuswb512_mask",
                    "avx512.mask.pmovus.wb.mem.128" => "__builtin_ia32_pmovuswb128mem_mask",
                    "avx512.mask.pmovus.wb.mem.256" => "__builtin_ia32_pmovuswb256mem_mask",
                    "avx512.mask.pmovus.wb.mem.512" => "__builtin_ia32_pmovuswb512mem_mask",
                    "avx512.mask.pmovzxb.d.128" => "__builtin_ia32_pmovzxbd128_mask",
                    "avx512.mask.pmovzxb.d.256" => "__builtin_ia32_pmovzxbd256_mask",
                    "avx512.mask.pmovzxb.d.512" => "__builtin_ia32_pmovzxbd512_mask",
                    "avx512.mask.pmovzxb.q.128" => "__builtin_ia32_pmovzxbq128_mask",
                    "avx512.mask.pmovzxb.q.256" => "__builtin_ia32_pmovzxbq256_mask",
                    "avx512.mask.pmovzxb.q.512" => "__builtin_ia32_pmovzxbq512_mask",
                    "avx512.mask.pmovzxb.w.128" => "__builtin_ia32_pmovzxbw128_mask",
                    "avx512.mask.pmovzxb.w.256" => "__builtin_ia32_pmovzxbw256_mask",
                    "avx512.mask.pmovzxb.w.512" => "__builtin_ia32_pmovzxbw512_mask",
                    "avx512.mask.pmovzxd.q.128" => "__builtin_ia32_pmovzxdq128_mask",
                    "avx512.mask.pmovzxd.q.256" => "__builtin_ia32_pmovzxdq256_mask",
                    "avx512.mask.pmovzxd.q.512" => "__builtin_ia32_pmovzxdq512_mask",
                    "avx512.mask.pmovzxw.d.128" => "__builtin_ia32_pmovzxwd128_mask",
                    "avx512.mask.pmovzxw.d.256" => "__builtin_ia32_pmovzxwd256_mask",
                    "avx512.mask.pmovzxw.d.512" => "__builtin_ia32_pmovzxwd512_mask",
                    "avx512.mask.pmovzxw.q.128" => "__builtin_ia32_pmovzxwq128_mask",
                    "avx512.mask.pmovzxw.q.256" => "__builtin_ia32_pmovzxwq256_mask",
                    "avx512.mask.pmovzxw.q.512" => "__builtin_ia32_pmovzxwq512_mask",
                    "avx512.mask.pmul.dq.128" => "__builtin_ia32_pmuldq128_mask",
                    "avx512.mask.pmul.dq.256" => "__builtin_ia32_pmuldq256_mask",
                    "avx512.mask.pmul.dq.512" => "__builtin_ia32_pmuldq512_mask",
                    "avx512.mask.pmul.hr.sw.128" => "__builtin_ia32_pmulhrsw128_mask",
                    "avx512.mask.pmul.hr.sw.256" => "__builtin_ia32_pmulhrsw256_mask",
                    "avx512.mask.pmul.hr.sw.512" => "__builtin_ia32_pmulhrsw512_mask",
                    "avx512.mask.pmulh.w.128" => "__builtin_ia32_pmulhw128_mask",
                    "avx512.mask.pmulh.w.256" => "__builtin_ia32_pmulhw256_mask",
                    "avx512.mask.pmulh.w.512" => "__builtin_ia32_pmulhw512_mask",
                    "avx512.mask.pmulhu.w.128" => "__builtin_ia32_pmulhuw128_mask",
                    "avx512.mask.pmulhu.w.256" => "__builtin_ia32_pmulhuw256_mask",
                    "avx512.mask.pmulhu.w.512" => "__builtin_ia32_pmulhuw512_mask",
                    "avx512.mask.pmull.d.128" => "__builtin_ia32_pmulld128_mask",
                    "avx512.mask.pmull.d.256" => "__builtin_ia32_pmulld256_mask",
                    "avx512.mask.pmull.d.512" => "__builtin_ia32_pmulld512_mask",
                    "avx512.mask.pmull.q.128" => "__builtin_ia32_pmullq128_mask",
                    "avx512.mask.pmull.q.256" => "__builtin_ia32_pmullq256_mask",
                    "avx512.mask.pmull.q.512" => "__builtin_ia32_pmullq512_mask",
                    "avx512.mask.pmull.w.128" => "__builtin_ia32_pmullw128_mask",
                    "avx512.mask.pmull.w.256" => "__builtin_ia32_pmullw256_mask",
                    "avx512.mask.pmull.w.512" => "__builtin_ia32_pmullw512_mask",
                    "avx512.mask.pmultishift.qb.128" => "__builtin_ia32_vpmultishiftqb128_mask",
                    "avx512.mask.pmultishift.qb.256" => "__builtin_ia32_vpmultishiftqb256_mask",
                    "avx512.mask.pmultishift.qb.512" => "__builtin_ia32_vpmultishiftqb512_mask",
                    "avx512.mask.pmulu.dq.128" => "__builtin_ia32_pmuludq128_mask",
                    "avx512.mask.pmulu.dq.256" => "__builtin_ia32_pmuludq256_mask",
                    "avx512.mask.pmulu.dq.512" => "__builtin_ia32_pmuludq512_mask",
                    "avx512.mask.prol.d.128" => "__builtin_ia32_prold128_mask",
                    "avx512.mask.prol.d.256" => "__builtin_ia32_prold256_mask",
                    "avx512.mask.prol.d.512" => "__builtin_ia32_prold512_mask",
                    "avx512.mask.prol.q.128" => "__builtin_ia32_prolq128_mask",
                    "avx512.mask.prol.q.256" => "__builtin_ia32_prolq256_mask",
                    "avx512.mask.prol.q.512" => "__builtin_ia32_prolq512_mask",
                    "avx512.mask.prolv.d.128" => "__builtin_ia32_prolvd128_mask",
                    "avx512.mask.prolv.d.256" => "__builtin_ia32_prolvd256_mask",
                    "avx512.mask.prolv.d.512" => "__builtin_ia32_prolvd512_mask",
                    "avx512.mask.prolv.q.128" => "__builtin_ia32_prolvq128_mask",
                    "avx512.mask.prolv.q.256" => "__builtin_ia32_prolvq256_mask",
                    "avx512.mask.prolv.q.512" => "__builtin_ia32_prolvq512_mask",
                    "avx512.mask.pror.d.128" => "__builtin_ia32_prord128_mask",
                    "avx512.mask.pror.d.256" => "__builtin_ia32_prord256_mask",
                    "avx512.mask.pror.d.512" => "__builtin_ia32_prord512_mask",
                    "avx512.mask.pror.q.128" => "__builtin_ia32_prorq128_mask",
                    "avx512.mask.pror.q.256" => "__builtin_ia32_prorq256_mask",
                    "avx512.mask.pror.q.512" => "__builtin_ia32_prorq512_mask",
                    "avx512.mask.prorv.d.128" => "__builtin_ia32_prorvd128_mask",
                    "avx512.mask.prorv.d.256" => "__builtin_ia32_prorvd256_mask",
                    "avx512.mask.prorv.d.512" => "__builtin_ia32_prorvd512_mask",
                    "avx512.mask.prorv.q.128" => "__builtin_ia32_prorvq128_mask",
                    "avx512.mask.prorv.q.256" => "__builtin_ia32_prorvq256_mask",
                    "avx512.mask.prorv.q.512" => "__builtin_ia32_prorvq512_mask",
                    "avx512.mask.pshuf.b.128" => "__builtin_ia32_pshufb128_mask",
                    "avx512.mask.pshuf.b.256" => "__builtin_ia32_pshufb256_mask",
                    "avx512.mask.pshuf.b.512" => "__builtin_ia32_pshufb512_mask",
                    "avx512.mask.psll.d" => "__builtin_ia32_pslld512_mask",
                    "avx512.mask.psll.d.128" => "__builtin_ia32_pslld128_mask",
                    "avx512.mask.psll.d.256" => "__builtin_ia32_pslld256_mask",
                    "avx512.mask.psll.di.128" => "__builtin_ia32_pslldi128_mask",
                    "avx512.mask.psll.di.256" => "__builtin_ia32_pslldi256_mask",
                    "avx512.mask.psll.di.512" => "__builtin_ia32_pslldi512_mask",
                    "avx512.mask.psll.q" => "__builtin_ia32_psllq512_mask",
                    "avx512.mask.psll.q.128" => "__builtin_ia32_psllq128_mask",
                    "avx512.mask.psll.q.256" => "__builtin_ia32_psllq256_mask",
                    "avx512.mask.psll.qi.128" => "__builtin_ia32_psllqi128_mask",
                    "avx512.mask.psll.qi.256" => "__builtin_ia32_psllqi256_mask",
                    "avx512.mask.psll.qi.512" => "__builtin_ia32_psllqi512_mask",
                    "avx512.mask.psll.w.128" => "__builtin_ia32_psllw128_mask",
                    "avx512.mask.psll.w.256" => "__builtin_ia32_psllw256_mask",
                    "avx512.mask.psll.w.512" => "__builtin_ia32_psllw512_mask",
                    "avx512.mask.psll.wi.128" => "__builtin_ia32_psllwi128_mask",
                    "avx512.mask.psll.wi.256" => "__builtin_ia32_psllwi256_mask",
                    "avx512.mask.psll.wi.512" => "__builtin_ia32_psllwi512_mask",
                    "avx512.mask.psllv.d" => "__builtin_ia32_psllv16si_mask",
                    "avx512.mask.psllv.q" => "__builtin_ia32_psllv8di_mask",
                    "avx512.mask.psllv16.hi" => "__builtin_ia32_psllv16hi_mask",
                    "avx512.mask.psllv2.di" => "__builtin_ia32_psllv2di_mask",
                    "avx512.mask.psllv32hi" => "__builtin_ia32_psllv32hi_mask",
                    "avx512.mask.psllv4.di" => "__builtin_ia32_psllv4di_mask",
                    "avx512.mask.psllv4.si" => "__builtin_ia32_psllv4si_mask",
                    "avx512.mask.psllv8.hi" => "__builtin_ia32_psllv8hi_mask",
                    "avx512.mask.psllv8.si" => "__builtin_ia32_psllv8si_mask",
                    "avx512.mask.psra.d" => "__builtin_ia32_psrad512_mask",
                    "avx512.mask.psra.d.128" => "__builtin_ia32_psrad128_mask",
                    "avx512.mask.psra.d.256" => "__builtin_ia32_psrad256_mask",
                    "avx512.mask.psra.di.128" => "__builtin_ia32_psradi128_mask",
                    "avx512.mask.psra.di.256" => "__builtin_ia32_psradi256_mask",
                    "avx512.mask.psra.di.512" => "__builtin_ia32_psradi512_mask",
                    "avx512.mask.psra.q" => "__builtin_ia32_psraq512_mask",
                    "avx512.mask.psra.q.128" => "__builtin_ia32_psraq128_mask",
                    "avx512.mask.psra.q.256" => "__builtin_ia32_psraq256_mask",
                    "avx512.mask.psra.qi.128" => "__builtin_ia32_psraqi128_mask",
                    "avx512.mask.psra.qi.256" => "__builtin_ia32_psraqi256_mask",
                    "avx512.mask.psra.qi.512" => "__builtin_ia32_psraqi512_mask",
                    "avx512.mask.psra.w.128" => "__builtin_ia32_psraw128_mask",
                    "avx512.mask.psra.w.256" => "__builtin_ia32_psraw256_mask",
                    "avx512.mask.psra.w.512" => "__builtin_ia32_psraw512_mask",
                    "avx512.mask.psra.wi.128" => "__builtin_ia32_psrawi128_mask",
                    "avx512.mask.psra.wi.256" => "__builtin_ia32_psrawi256_mask",
                    "avx512.mask.psra.wi.512" => "__builtin_ia32_psrawi512_mask",
                    "avx512.mask.psrav.d" => "__builtin_ia32_psrav16si_mask",
                    "avx512.mask.psrav.q" => "__builtin_ia32_psrav8di_mask",
                    "avx512.mask.psrav.q.128" => "__builtin_ia32_psravq128_mask",
                    "avx512.mask.psrav.q.256" => "__builtin_ia32_psravq256_mask",
                    "avx512.mask.psrav16.hi" => "__builtin_ia32_psrav16hi_mask",
                    "avx512.mask.psrav32.hi" => "__builtin_ia32_psrav32hi_mask",
                    "avx512.mask.psrav4.si" => "__builtin_ia32_psrav4si_mask",
                    "avx512.mask.psrav8.hi" => "__builtin_ia32_psrav8hi_mask",
                    "avx512.mask.psrav8.si" => "__builtin_ia32_psrav8si_mask",
                    "avx512.mask.psrl.d" => "__builtin_ia32_psrld512_mask",
                    "avx512.mask.psrl.d.128" => "__builtin_ia32_psrld128_mask",
                    "avx512.mask.psrl.d.256" => "__builtin_ia32_psrld256_mask",
                    "avx512.mask.psrl.di.128" => "__builtin_ia32_psrldi128_mask",
                    "avx512.mask.psrl.di.256" => "__builtin_ia32_psrldi256_mask",
                    "avx512.mask.psrl.di.512" => "__builtin_ia32_psrldi512_mask",
                    "avx512.mask.psrl.q" => "__builtin_ia32_psrlq512_mask",
                    "avx512.mask.psrl.q.128" => "__builtin_ia32_psrlq128_mask",
                    "avx512.mask.psrl.q.256" => "__builtin_ia32_psrlq256_mask",
                    "avx512.mask.psrl.qi.128" => "__builtin_ia32_psrlqi128_mask",
                    "avx512.mask.psrl.qi.256" => "__builtin_ia32_psrlqi256_mask",
                    "avx512.mask.psrl.qi.512" => "__builtin_ia32_psrlqi512_mask",
                    "avx512.mask.psrl.w.128" => "__builtin_ia32_psrlw128_mask",
                    "avx512.mask.psrl.w.256" => "__builtin_ia32_psrlw256_mask",
                    "avx512.mask.psrl.w.512" => "__builtin_ia32_psrlw512_mask",
                    "avx512.mask.psrl.wi.128" => "__builtin_ia32_psrlwi128_mask",
                    "avx512.mask.psrl.wi.256" => "__builtin_ia32_psrlwi256_mask",
                    "avx512.mask.psrl.wi.512" => "__builtin_ia32_psrlwi512_mask",
                    "avx512.mask.psrlv.d" => "__builtin_ia32_psrlv16si_mask",
                    "avx512.mask.psrlv.q" => "__builtin_ia32_psrlv8di_mask",
                    "avx512.mask.psrlv16.hi" => "__builtin_ia32_psrlv16hi_mask",
                    "avx512.mask.psrlv2.di" => "__builtin_ia32_psrlv2di_mask",
                    "avx512.mask.psrlv32hi" => "__builtin_ia32_psrlv32hi_mask",
                    "avx512.mask.psrlv4.di" => "__builtin_ia32_psrlv4di_mask",
                    "avx512.mask.psrlv4.si" => "__builtin_ia32_psrlv4si_mask",
                    "avx512.mask.psrlv8.hi" => "__builtin_ia32_psrlv8hi_mask",
                    "avx512.mask.psrlv8.si" => "__builtin_ia32_psrlv8si_mask",
                    "avx512.mask.psub.b.128" => "__builtin_ia32_psubb128_mask",
                    "avx512.mask.psub.b.256" => "__builtin_ia32_psubb256_mask",
                    "avx512.mask.psub.b.512" => "__builtin_ia32_psubb512_mask",
                    "avx512.mask.psub.d.128" => "__builtin_ia32_psubd128_mask",
                    "avx512.mask.psub.d.256" => "__builtin_ia32_psubd256_mask",
                    "avx512.mask.psub.d.512" => "__builtin_ia32_psubd512_mask",
                    "avx512.mask.psub.q.128" => "__builtin_ia32_psubq128_mask",
                    "avx512.mask.psub.q.256" => "__builtin_ia32_psubq256_mask",
                    "avx512.mask.psub.q.512" => "__builtin_ia32_psubq512_mask",
                    "avx512.mask.psub.w.128" => "__builtin_ia32_psubw128_mask",
                    "avx512.mask.psub.w.256" => "__builtin_ia32_psubw256_mask",
                    "avx512.mask.psub.w.512" => "__builtin_ia32_psubw512_mask",
                    "avx512.mask.psubs.b.128" => "__builtin_ia32_psubsb128_mask",
                    "avx512.mask.psubs.b.256" => "__builtin_ia32_psubsb256_mask",
                    "avx512.mask.psubs.b.512" => "__builtin_ia32_psubsb512_mask",
                    "avx512.mask.psubs.w.128" => "__builtin_ia32_psubsw128_mask",
                    "avx512.mask.psubs.w.256" => "__builtin_ia32_psubsw256_mask",
                    "avx512.mask.psubs.w.512" => "__builtin_ia32_psubsw512_mask",
                    "avx512.mask.psubus.b.128" => "__builtin_ia32_psubusb128_mask",
                    "avx512.mask.psubus.b.256" => "__builtin_ia32_psubusb256_mask",
                    "avx512.mask.psubus.b.512" => "__builtin_ia32_psubusb512_mask",
                    "avx512.mask.psubus.w.128" => "__builtin_ia32_psubusw128_mask",
                    "avx512.mask.psubus.w.256" => "__builtin_ia32_psubusw256_mask",
                    "avx512.mask.psubus.w.512" => "__builtin_ia32_psubusw512_mask",
                    "avx512.mask.pternlog.d.128" => "__builtin_ia32_pternlogd128_mask",
                    "avx512.mask.pternlog.d.256" => "__builtin_ia32_pternlogd256_mask",
                    "avx512.mask.pternlog.d.512" => "__builtin_ia32_pternlogd512_mask",
                    "avx512.mask.pternlog.q.128" => "__builtin_ia32_pternlogq128_mask",
                    "avx512.mask.pternlog.q.256" => "__builtin_ia32_pternlogq256_mask",
                    "avx512.mask.pternlog.q.512" => "__builtin_ia32_pternlogq512_mask",
                    "avx512.mask.ptestm.d.512" => "__builtin_ia32_ptestmd512",
                    "avx512.mask.ptestm.q.512" => "__builtin_ia32_ptestmq512",
                    "avx512.mask.range.pd.128" => "__builtin_ia32_rangepd128_mask",
                    "avx512.mask.range.pd.256" => "__builtin_ia32_rangepd256_mask",
                    "avx512.mask.range.pd.512" => "__builtin_ia32_rangepd512_mask",
                    "avx512.mask.range.ps.128" => "__builtin_ia32_rangeps128_mask",
                    "avx512.mask.range.ps.256" => "__builtin_ia32_rangeps256_mask",
                    "avx512.mask.range.ps.512" => "__builtin_ia32_rangeps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.range.sd" => "__builtin_ia32_rangesd128_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.range.ss" => "__builtin_ia32_rangess128_round_mask",
                    "avx512.mask.reduce.pd.128" => "__builtin_ia32_reducepd128_mask",
                    "avx512.mask.reduce.pd.256" => "__builtin_ia32_reducepd256_mask",
                    "avx512.mask.reduce.pd.512" => "__builtin_ia32_reducepd512_mask",
                    "avx512.mask.reduce.ps.128" => "__builtin_ia32_reduceps128_mask",
                    "avx512.mask.reduce.ps.256" => "__builtin_ia32_reduceps256_mask",
                    "avx512.mask.reduce.ps.512" => "__builtin_ia32_reduceps512_mask",
                    "avx512.mask.reduce.sd" => "__builtin_ia32_reducesd_mask",
                    "avx512.mask.reduce.ss" => "__builtin_ia32_reducess_mask",
                    "avx512.mask.rndscale.pd.128" => "__builtin_ia32_rndscalepd_128_mask",
                    "avx512.mask.rndscale.pd.256" => "__builtin_ia32_rndscalepd_256_mask",
                    "avx512.mask.rndscale.pd.512" => "__builtin_ia32_rndscalepd_mask",
                    "avx512.mask.rndscale.ps.128" => "__builtin_ia32_rndscaleps_128_mask",
                    "avx512.mask.rndscale.ps.256" => "__builtin_ia32_rndscaleps_256_mask",
                    "avx512.mask.rndscale.ps.512" => "__builtin_ia32_rndscaleps_mask",
                    // [INVALID CONVERSION]: "avx512.mask.rndscale.sd" => "__builtin_ia32_rndscalesd_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.rndscale.ss" => "__builtin_ia32_rndscaless_round_mask",
                    "avx512.mask.scalef.pd.128" => "__builtin_ia32_scalefpd128_mask",
                    "avx512.mask.scalef.pd.256" => "__builtin_ia32_scalefpd256_mask",
                    "avx512.mask.scalef.pd.512" => "__builtin_ia32_scalefpd512_mask",
                    "avx512.mask.scalef.ps.128" => "__builtin_ia32_scalefps128_mask",
                    "avx512.mask.scalef.ps.256" => "__builtin_ia32_scalefps256_mask",
                    "avx512.mask.scalef.ps.512" => "__builtin_ia32_scalefps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.scalef.sd" => "__builtin_ia32_scalefsd_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.scalef.ss" => "__builtin_ia32_scalefss_round_mask",
                    "avx512.mask.shuf.f32x4" => "__builtin_ia32_shuf_f32x4_mask",
                    "avx512.mask.shuf.f32x4.256" => "__builtin_ia32_shuf_f32x4_256_mask",
                    "avx512.mask.shuf.f64x2" => "__builtin_ia32_shuf_f64x2_mask",
                    "avx512.mask.shuf.f64x2.256" => "__builtin_ia32_shuf_f64x2_256_mask",
                    "avx512.mask.shuf.i32x4" => "__builtin_ia32_shuf_i32x4_mask",
                    "avx512.mask.shuf.i32x4.256" => "__builtin_ia32_shuf_i32x4_256_mask",
                    "avx512.mask.shuf.i64x2" => "__builtin_ia32_shuf_i64x2_mask",
                    "avx512.mask.shuf.i64x2.256" => "__builtin_ia32_shuf_i64x2_256_mask",
                    "avx512.mask.shuf.pd.128" => "__builtin_ia32_shufpd128_mask",
                    "avx512.mask.shuf.pd.256" => "__builtin_ia32_shufpd256_mask",
                    "avx512.mask.shuf.pd.512" => "__builtin_ia32_shufpd512_mask",
                    "avx512.mask.shuf.ps.128" => "__builtin_ia32_shufps128_mask",
                    "avx512.mask.shuf.ps.256" => "__builtin_ia32_shufps256_mask",
                    "avx512.mask.shuf.ps.512" => "__builtin_ia32_shufps512_mask",
                    "avx512.mask.sqrt.pd.128" => "__builtin_ia32_sqrtpd128_mask",
                    "avx512.mask.sqrt.pd.256" => "__builtin_ia32_sqrtpd256_mask",
                    "avx512.mask.sqrt.pd.512" => "__builtin_ia32_sqrtpd512_mask",
                    "avx512.mask.sqrt.ps.128" => "__builtin_ia32_sqrtps128_mask",
                    "avx512.mask.sqrt.ps.256" => "__builtin_ia32_sqrtps256_mask",
                    "avx512.mask.sqrt.ps.512" => "__builtin_ia32_sqrtps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.sqrt.sd" => "__builtin_ia32_sqrtsd_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.sqrt.ss" => "__builtin_ia32_sqrtss_round_mask",
                    "avx512.mask.store.ss" => "__builtin_ia32_storess_mask",
                    "avx512.mask.storeu.d.512" => "__builtin_ia32_storedqusi512_mask",
                    "avx512.mask.storeu.pd.512" => "__builtin_ia32_storeupd512_mask",
                    "avx512.mask.storeu.ps.512" => "__builtin_ia32_storeups512_mask",
                    "avx512.mask.storeu.q.512" => "__builtin_ia32_storedqudi512_mask",
                    "avx512.mask.sub.pd.128" => "__builtin_ia32_subpd128_mask",
                    "avx512.mask.sub.pd.256" => "__builtin_ia32_subpd256_mask",
                    "avx512.mask.sub.pd.512" => "__builtin_ia32_subpd512_mask",
                    "avx512.mask.sub.ps.128" => "__builtin_ia32_subps128_mask",
                    "avx512.mask.sub.ps.256" => "__builtin_ia32_subps256_mask",
                    "avx512.mask.sub.ps.512" => "__builtin_ia32_subps512_mask",
                    // [INVALID CONVERSION]: "avx512.mask.sub.sd.round" => "__builtin_ia32_subsd_round_mask",
                    // [INVALID CONVERSION]: "avx512.mask.sub.ss.round" => "__builtin_ia32_subss_round_mask",
                    "avx512.mask.valign.d.128" => "__builtin_ia32_alignd128_mask",
                    "avx512.mask.valign.d.256" => "__builtin_ia32_alignd256_mask",
                    "avx512.mask.valign.d.512" => "__builtin_ia32_alignd512_mask",
                    "avx512.mask.valign.q.128" => "__builtin_ia32_alignq128_mask",
                    "avx512.mask.valign.q.256" => "__builtin_ia32_alignq256_mask",
                    "avx512.mask.valign.q.512" => "__builtin_ia32_alignq512_mask",
                    "avx512.mask.vcvtph2ps.128" => "__builtin_ia32_vcvtph2ps_mask",
                    "avx512.mask.vcvtph2ps.256" => "__builtin_ia32_vcvtph2ps256_mask",
                    "avx512.mask.vcvtph2ps.512" => "__builtin_ia32_vcvtph2ps512_mask",
                    "avx512.mask.vcvtps2ph.128" => "__builtin_ia32_vcvtps2ph_mask",
                    "avx512.mask.vcvtps2ph.256" => "__builtin_ia32_vcvtps2ph256_mask",
                    "avx512.mask.vcvtps2ph.512" => "__builtin_ia32_vcvtps2ph512_mask",
                    "avx512.mask.vextractf32x4.256" => "__builtin_ia32_extractf32x4_256_mask",
                    "avx512.mask.vextractf32x4.512" => "__builtin_ia32_extractf32x4_mask",
                    "avx512.mask.vextractf32x8.512" => "__builtin_ia32_extractf32x8_mask",
                    "avx512.mask.vextractf64x2.256" => "__builtin_ia32_extractf64x2_256_mask",
                    "avx512.mask.vextractf64x2.512" => "__builtin_ia32_extractf64x2_512_mask",
                    "avx512.mask.vextractf64x4.512" => "__builtin_ia32_extractf64x4_mask",
                    "avx512.mask.vextracti32x4.256" => "__builtin_ia32_extracti32x4_256_mask",
                    "avx512.mask.vextracti32x4.512" => "__builtin_ia32_extracti32x4_mask",
                    "avx512.mask.vextracti32x8.512" => "__builtin_ia32_extracti32x8_mask",
                    "avx512.mask.vextracti64x2.256" => "__builtin_ia32_extracti64x2_256_mask",
                    "avx512.mask.vextracti64x2.512" => "__builtin_ia32_extracti64x2_512_mask",
                    "avx512.mask.vextracti64x4.512" => "__builtin_ia32_extracti64x4_mask",
                    "avx512.mask.vfmadd.pd.128" => "__builtin_ia32_vfmaddpd128_mask",
                    "avx512.mask.vfmadd.pd.256" => "__builtin_ia32_vfmaddpd256_mask",
                    "avx512.mask.vfmadd.pd.512" => "__builtin_ia32_vfmaddpd512_mask",
                    "avx512.mask.vfmadd.ps.128" => "__builtin_ia32_vfmaddps128_mask",
                    "avx512.mask.vfmadd.ps.256" => "__builtin_ia32_vfmaddps256_mask",
                    "avx512.mask.vfmadd.ps.512" => "__builtin_ia32_vfmaddps512_mask",
                    "avx512.mask.vfmadd.sd" => "__builtin_ia32_vfmaddsd3_mask",
                    "avx512.mask.vfmadd.ss" => "__builtin_ia32_vfmaddss3_mask",
                    "avx512.mask.vfmaddsub.pd.128" => "__builtin_ia32_vfmaddsubpd128_mask",
                    "avx512.mask.vfmaddsub.pd.256" => "__builtin_ia32_vfmaddsubpd256_mask",
                    "avx512.mask.vfmaddsub.pd.512" => "__builtin_ia32_vfmaddsubpd512_mask",
                    "avx512.mask.vfmaddsub.ps.128" => "__builtin_ia32_vfmaddsubps128_mask",
                    "avx512.mask.vfmaddsub.ps.256" => "__builtin_ia32_vfmaddsubps256_mask",
                    "avx512.mask.vfmaddsub.ps.512" => "__builtin_ia32_vfmaddsubps512_mask",
                    "avx512.mask.vfnmadd.pd.128" => "__builtin_ia32_vfnmaddpd128_mask",
                    "avx512.mask.vfnmadd.pd.256" => "__builtin_ia32_vfnmaddpd256_mask",
                    "avx512.mask.vfnmadd.pd.512" => "__builtin_ia32_vfnmaddpd512_mask",
                    "avx512.mask.vfnmadd.ps.128" => "__builtin_ia32_vfnmaddps128_mask",
                    "avx512.mask.vfnmadd.ps.256" => "__builtin_ia32_vfnmaddps256_mask",
                    "avx512.mask.vfnmadd.ps.512" => "__builtin_ia32_vfnmaddps512_mask",
                    "avx512.mask.vfnmsub.pd.128" => "__builtin_ia32_vfnmsubpd128_mask",
                    "avx512.mask.vfnmsub.pd.256" => "__builtin_ia32_vfnmsubpd256_mask",
                    "avx512.mask.vfnmsub.pd.512" => "__builtin_ia32_vfnmsubpd512_mask",
                    "avx512.mask.vfnmsub.ps.128" => "__builtin_ia32_vfnmsubps128_mask",
                    "avx512.mask.vfnmsub.ps.256" => "__builtin_ia32_vfnmsubps256_mask",
                    "avx512.mask.vfnmsub.ps.512" => "__builtin_ia32_vfnmsubps512_mask",
                    "avx512.mask.vpermi2var.d.128" => "__builtin_ia32_vpermi2vard128_mask",
                    "avx512.mask.vpermi2var.d.256" => "__builtin_ia32_vpermi2vard256_mask",
                    "avx512.mask.vpermi2var.d.512" => "__builtin_ia32_vpermi2vard512_mask",
                    "avx512.mask.vpermi2var.hi.128" => "__builtin_ia32_vpermi2varhi128_mask",
                    "avx512.mask.vpermi2var.hi.256" => "__builtin_ia32_vpermi2varhi256_mask",
                    "avx512.mask.vpermi2var.hi.512" => "__builtin_ia32_vpermi2varhi512_mask",
                    "avx512.mask.vpermi2var.pd.128" => "__builtin_ia32_vpermi2varpd128_mask",
                    "avx512.mask.vpermi2var.pd.256" => "__builtin_ia32_vpermi2varpd256_mask",
                    "avx512.mask.vpermi2var.pd.512" => "__builtin_ia32_vpermi2varpd512_mask",
                    "avx512.mask.vpermi2var.ps.128" => "__builtin_ia32_vpermi2varps128_mask",
                    "avx512.mask.vpermi2var.ps.256" => "__builtin_ia32_vpermi2varps256_mask",
                    "avx512.mask.vpermi2var.ps.512" => "__builtin_ia32_vpermi2varps512_mask",
                    "avx512.mask.vpermi2var.q.128" => "__builtin_ia32_vpermi2varq128_mask",
                    "avx512.mask.vpermi2var.q.256" => "__builtin_ia32_vpermi2varq256_mask",
                    "avx512.mask.vpermi2var.q.512" => "__builtin_ia32_vpermi2varq512_mask",
                    "avx512.mask.vpermi2var.qi.128" => "__builtin_ia32_vpermi2varqi128_mask",
                    "avx512.mask.vpermi2var.qi.256" => "__builtin_ia32_vpermi2varqi256_mask",
                    "avx512.mask.vpermi2var.qi.512" => "__builtin_ia32_vpermi2varqi512_mask",
                    "avx512.mask.vpermilvar.pd.128" => "__builtin_ia32_vpermilvarpd_mask",
                    "avx512.mask.vpermilvar.pd.256" => "__builtin_ia32_vpermilvarpd256_mask",
                    "avx512.mask.vpermilvar.pd.512" => "__builtin_ia32_vpermilvarpd512_mask",
                    "avx512.mask.vpermilvar.ps.128" => "__builtin_ia32_vpermilvarps_mask",
                    "avx512.mask.vpermilvar.ps.256" => "__builtin_ia32_vpermilvarps256_mask",
                    "avx512.mask.vpermilvar.ps.512" => "__builtin_ia32_vpermilvarps512_mask",
                    "avx512.mask.vpermt.d.512" => "__builtin_ia32_vpermt2vard512_mask",
                    "avx512.mask.vpermt.pd.512" => "__builtin_ia32_vpermt2varpd512_mask",
                    "avx512.mask.vpermt.ps.512" => "__builtin_ia32_vpermt2varps512_mask",
                    "avx512.mask.vpermt.q.512" => "__builtin_ia32_vpermt2varq512_mask",
                    "avx512.mask.vpermt2var.d.128" => "__builtin_ia32_vpermt2vard128_mask",
                    "avx512.mask.vpermt2var.d.256" => "__builtin_ia32_vpermt2vard256_mask",
                    "avx512.mask.vpermt2var.d.512" => "__builtin_ia32_vpermt2vard512_mask",
                    "avx512.mask.vpermt2var.hi.128" => "__builtin_ia32_vpermt2varhi128_mask",
                    "avx512.mask.vpermt2var.hi.256" => "__builtin_ia32_vpermt2varhi256_mask",
                    "avx512.mask.vpermt2var.hi.512" => "__builtin_ia32_vpermt2varhi512_mask",
                    "avx512.mask.vpermt2var.pd.128" => "__builtin_ia32_vpermt2varpd128_mask",
                    "avx512.mask.vpermt2var.pd.256" => "__builtin_ia32_vpermt2varpd256_mask",
                    "avx512.mask.vpermt2var.pd.512" => "__builtin_ia32_vpermt2varpd512_mask",
                    "avx512.mask.vpermt2var.ps.128" => "__builtin_ia32_vpermt2varps128_mask",
                    "avx512.mask.vpermt2var.ps.256" => "__builtin_ia32_vpermt2varps256_mask",
                    "avx512.mask.vpermt2var.ps.512" => "__builtin_ia32_vpermt2varps512_mask",
                    "avx512.mask.vpermt2var.q.128" => "__builtin_ia32_vpermt2varq128_mask",
                    "avx512.mask.vpermt2var.q.256" => "__builtin_ia32_vpermt2varq256_mask",
                    "avx512.mask.vpermt2var.q.512" => "__builtin_ia32_vpermt2varq512_mask",
                    "avx512.mask.vpermt2var.qi.128" => "__builtin_ia32_vpermt2varqi128_mask",
                    "avx512.mask.vpermt2var.qi.256" => "__builtin_ia32_vpermt2varqi256_mask",
                    "avx512.mask.vpermt2var.qi.512" => "__builtin_ia32_vpermt2varqi512_mask",
                    "avx512.mask.vpmadd52h.uq.128" => "__builtin_ia32_vpmadd52huq128_mask",
                    "avx512.mask.vpmadd52h.uq.256" => "__builtin_ia32_vpmadd52huq256_mask",
                    "avx512.mask.vpmadd52h.uq.512" => "__builtin_ia32_vpmadd52huq512_mask",
                    "avx512.mask.vpmadd52l.uq.128" => "__builtin_ia32_vpmadd52luq128_mask",
                    "avx512.mask.vpmadd52l.uq.256" => "__builtin_ia32_vpmadd52luq256_mask",
                    "avx512.mask.vpmadd52l.uq.512" => "__builtin_ia32_vpmadd52luq512_mask",
                    "avx512.mask.xor.pd.128" => "__builtin_ia32_xorpd128_mask",
                    "avx512.mask.xor.pd.256" => "__builtin_ia32_xorpd256_mask",
                    "avx512.mask.xor.pd.512" => "__builtin_ia32_xorpd512_mask",
                    "avx512.mask.xor.ps.128" => "__builtin_ia32_xorps128_mask",
                    "avx512.mask.xor.ps.256" => "__builtin_ia32_xorps256_mask",
                    "avx512.mask.xor.ps.512" => "__builtin_ia32_xorps512_mask",
                    "avx512.mask3.vfmadd.pd.128" => "__builtin_ia32_vfmaddpd128_mask3",
                    "avx512.mask3.vfmadd.pd.256" => "__builtin_ia32_vfmaddpd256_mask3",
                    "avx512.mask3.vfmadd.pd.512" => "__builtin_ia32_vfmaddpd512_mask3",
                    "avx512.mask3.vfmadd.ps.128" => "__builtin_ia32_vfmaddps128_mask3",
                    "avx512.mask3.vfmadd.ps.256" => "__builtin_ia32_vfmaddps256_mask3",
                    "avx512.mask3.vfmadd.ps.512" => "__builtin_ia32_vfmaddps512_mask3",
                    "avx512.mask3.vfmadd.sd" => "__builtin_ia32_vfmaddsd3_mask3",
                    "avx512.mask3.vfmadd.ss" => "__builtin_ia32_vfmaddss3_mask3",
                    "avx512.mask3.vfmaddsub.pd.128" => "__builtin_ia32_vfmaddsubpd128_mask3",
                    "avx512.mask3.vfmaddsub.pd.256" => "__builtin_ia32_vfmaddsubpd256_mask3",
                    "avx512.mask3.vfmaddsub.pd.512" => "__builtin_ia32_vfmaddsubpd512_mask3",
                    "avx512.mask3.vfmaddsub.ps.128" => "__builtin_ia32_vfmaddsubps128_mask3",
                    "avx512.mask3.vfmaddsub.ps.256" => "__builtin_ia32_vfmaddsubps256_mask3",
                    "avx512.mask3.vfmaddsub.ps.512" => "__builtin_ia32_vfmaddsubps512_mask3",
                    "avx512.mask3.vfmsub.pd.128" => "__builtin_ia32_vfmsubpd128_mask3",
                    "avx512.mask3.vfmsub.pd.256" => "__builtin_ia32_vfmsubpd256_mask3",
                    "avx512.mask3.vfmsub.pd.512" => "__builtin_ia32_vfmsubpd512_mask3",
                    "avx512.mask3.vfmsub.ps.128" => "__builtin_ia32_vfmsubps128_mask3",
                    "avx512.mask3.vfmsub.ps.256" => "__builtin_ia32_vfmsubps256_mask3",
                    "avx512.mask3.vfmsub.ps.512" => "__builtin_ia32_vfmsubps512_mask3",
                    "avx512.mask3.vfmsubadd.pd.128" => "__builtin_ia32_vfmsubaddpd128_mask3",
                    "avx512.mask3.vfmsubadd.pd.256" => "__builtin_ia32_vfmsubaddpd256_mask3",
                    "avx512.mask3.vfmsubadd.pd.512" => "__builtin_ia32_vfmsubaddpd512_mask3",
                    "avx512.mask3.vfmsubadd.ps.128" => "__builtin_ia32_vfmsubaddps128_mask3",
                    "avx512.mask3.vfmsubadd.ps.256" => "__builtin_ia32_vfmsubaddps256_mask3",
                    "avx512.mask3.vfmsubadd.ps.512" => "__builtin_ia32_vfmsubaddps512_mask3",
                    "avx512.mask3.vfnmsub.pd.128" => "__builtin_ia32_vfnmsubpd128_mask3",
                    "avx512.mask3.vfnmsub.pd.256" => "__builtin_ia32_vfnmsubpd256_mask3",
                    "avx512.mask3.vfnmsub.pd.512" => "__builtin_ia32_vfnmsubpd512_mask3",
                    "avx512.mask3.vfnmsub.ps.128" => "__builtin_ia32_vfnmsubps128_mask3",
                    "avx512.mask3.vfnmsub.ps.256" => "__builtin_ia32_vfnmsubps256_mask3",
                    "avx512.mask3.vfnmsub.ps.512" => "__builtin_ia32_vfnmsubps512_mask3",
                    "avx512.maskz.fixupimm.pd.128" => "__builtin_ia32_fixupimmpd128_maskz",
                    "avx512.maskz.fixupimm.pd.256" => "__builtin_ia32_fixupimmpd256_maskz",
                    "avx512.maskz.fixupimm.pd.512" => "__builtin_ia32_fixupimmpd512_maskz",
                    "avx512.maskz.fixupimm.ps.128" => "__builtin_ia32_fixupimmps128_maskz",
                    "avx512.maskz.fixupimm.ps.256" => "__builtin_ia32_fixupimmps256_maskz",
                    "avx512.maskz.fixupimm.ps.512" => "__builtin_ia32_fixupimmps512_maskz",
                    "avx512.maskz.fixupimm.sd" => "__builtin_ia32_fixupimmsd_maskz",
                    "avx512.maskz.fixupimm.ss" => "__builtin_ia32_fixupimmss_maskz",
                    "avx512.maskz.pternlog.d.128" => "__builtin_ia32_pternlogd128_maskz",
                    "avx512.maskz.pternlog.d.256" => "__builtin_ia32_pternlogd256_maskz",
                    "avx512.maskz.pternlog.d.512" => "__builtin_ia32_pternlogd512_maskz",
                    "avx512.maskz.pternlog.q.128" => "__builtin_ia32_pternlogq128_maskz",
                    "avx512.maskz.pternlog.q.256" => "__builtin_ia32_pternlogq256_maskz",
                    "avx512.maskz.pternlog.q.512" => "__builtin_ia32_pternlogq512_maskz",
                    "avx512.maskz.vfmadd.pd.128" => "__builtin_ia32_vfmaddpd128_maskz",
                    "avx512.maskz.vfmadd.pd.256" => "__builtin_ia32_vfmaddpd256_maskz",
                    "avx512.maskz.vfmadd.pd.512" => "__builtin_ia32_vfmaddpd512_maskz",
                    "avx512.maskz.vfmadd.ps.128" => "__builtin_ia32_vfmaddps128_maskz",
                    "avx512.maskz.vfmadd.ps.256" => "__builtin_ia32_vfmaddps256_maskz",
                    "avx512.maskz.vfmadd.ps.512" => "__builtin_ia32_vfmaddps512_maskz",
                    "avx512.maskz.vfmadd.sd" => "__builtin_ia32_vfmaddsd3_maskz",
                    "avx512.maskz.vfmadd.ss" => "__builtin_ia32_vfmaddss3_maskz",
                    "avx512.maskz.vfmaddsub.pd.128" => "__builtin_ia32_vfmaddsubpd128_maskz",
                    "avx512.maskz.vfmaddsub.pd.256" => "__builtin_ia32_vfmaddsubpd256_maskz",
                    "avx512.maskz.vfmaddsub.pd.512" => "__builtin_ia32_vfmaddsubpd512_maskz",
                    "avx512.maskz.vfmaddsub.ps.128" => "__builtin_ia32_vfmaddsubps128_maskz",
                    "avx512.maskz.vfmaddsub.ps.256" => "__builtin_ia32_vfmaddsubps256_maskz",
                    "avx512.maskz.vfmaddsub.ps.512" => "__builtin_ia32_vfmaddsubps512_maskz",
                    "avx512.maskz.vpermt2var.d.128" => "__builtin_ia32_vpermt2vard128_maskz",
                    "avx512.maskz.vpermt2var.d.256" => "__builtin_ia32_vpermt2vard256_maskz",
                    "avx512.maskz.vpermt2var.d.512" => "__builtin_ia32_vpermt2vard512_maskz",
                    "avx512.maskz.vpermt2var.hi.128" => "__builtin_ia32_vpermt2varhi128_maskz",
                    "avx512.maskz.vpermt2var.hi.256" => "__builtin_ia32_vpermt2varhi256_maskz",
                    "avx512.maskz.vpermt2var.hi.512" => "__builtin_ia32_vpermt2varhi512_maskz",
                    "avx512.maskz.vpermt2var.pd.128" => "__builtin_ia32_vpermt2varpd128_maskz",
                    "avx512.maskz.vpermt2var.pd.256" => "__builtin_ia32_vpermt2varpd256_maskz",
                    "avx512.maskz.vpermt2var.pd.512" => "__builtin_ia32_vpermt2varpd512_maskz",
                    "avx512.maskz.vpermt2var.ps.128" => "__builtin_ia32_vpermt2varps128_maskz",
                    "avx512.maskz.vpermt2var.ps.256" => "__builtin_ia32_vpermt2varps256_maskz",
                    "avx512.maskz.vpermt2var.ps.512" => "__builtin_ia32_vpermt2varps512_maskz",
                    "avx512.maskz.vpermt2var.q.128" => "__builtin_ia32_vpermt2varq128_maskz",
                    "avx512.maskz.vpermt2var.q.256" => "__builtin_ia32_vpermt2varq256_maskz",
                    "avx512.maskz.vpermt2var.q.512" => "__builtin_ia32_vpermt2varq512_maskz",
                    "avx512.maskz.vpermt2var.qi.128" => "__builtin_ia32_vpermt2varqi128_maskz",
                    "avx512.maskz.vpermt2var.qi.256" => "__builtin_ia32_vpermt2varqi256_maskz",
                    "avx512.maskz.vpermt2var.qi.512" => "__builtin_ia32_vpermt2varqi512_maskz",
                    "avx512.maskz.vpmadd52h.uq.128" => "__builtin_ia32_vpmadd52huq128_maskz",
                    "avx512.maskz.vpmadd52h.uq.256" => "__builtin_ia32_vpmadd52huq256_maskz",
                    "avx512.maskz.vpmadd52h.uq.512" => "__builtin_ia32_vpmadd52huq512_maskz",
                    "avx512.maskz.vpmadd52l.uq.128" => "__builtin_ia32_vpmadd52luq128_maskz",
                    "avx512.maskz.vpmadd52l.uq.256" => "__builtin_ia32_vpmadd52luq256_maskz",
                    "avx512.maskz.vpmadd52l.uq.512" => "__builtin_ia32_vpmadd52luq512_maskz",
                    "avx512.max.pd.512" => "__builtin_ia32_maxpd512",
                    "avx512.max.ps.512" => "__builtin_ia32_maxps512",
                    "avx512.min.pd.512" => "__builtin_ia32_minpd512",
                    "avx512.min.ps.512" => "__builtin_ia32_minps512",
                    "avx512.movntdqa" => "__builtin_ia32_movntdqa512",
                    "avx512.mul.pd.512" => "__builtin_ia32_mulpd512",
                    "avx512.mul.ps.512" => "__builtin_ia32_mulps512",
                    "avx512.packssdw.512" => "__builtin_ia32_packssdw512",
                    "avx512.packsswb.512" => "__builtin_ia32_packsswb512",
                    "avx512.packusdw.512" => "__builtin_ia32_packusdw512",
                    "avx512.packuswb.512" => "__builtin_ia32_packuswb512",
                    "avx512.pavg.b.512" => "__builtin_ia32_pavgb512",
                    "avx512.pavg.w.512" => "__builtin_ia32_pavgw512",
                    "avx512.pbroadcastd.512" => "__builtin_ia32_pbroadcastd512",
                    "avx512.pbroadcastq.512" => "__builtin_ia32_pbroadcastq512",
                    "avx512.permvar.df.256" => "__builtin_ia32_permvardf256",
                    "avx512.permvar.df.512" => "__builtin_ia32_permvardf512",
                    "avx512.permvar.di.256" => "__builtin_ia32_permvardi256",
                    "avx512.permvar.di.512" => "__builtin_ia32_permvardi512",
                    "avx512.permvar.hi.128" => "__builtin_ia32_permvarhi128",
                    "avx512.permvar.hi.256" => "__builtin_ia32_permvarhi256",
                    "avx512.permvar.hi.512" => "__builtin_ia32_permvarhi512",
                    "avx512.permvar.qi.128" => "__builtin_ia32_permvarqi128",
                    "avx512.permvar.qi.256" => "__builtin_ia32_permvarqi256",
                    "avx512.permvar.qi.512" => "__builtin_ia32_permvarqi512",
                    "avx512.permvar.sf.512" => "__builtin_ia32_permvarsf512",
                    "avx512.permvar.si.512" => "__builtin_ia32_permvarsi512",
                    "avx512.pmaddubs.w.512" => "__builtin_ia32_pmaddubsw512",
                    "avx512.pmaddw.d.512" => "__builtin_ia32_pmaddwd512",
                    "avx512.pmovzxbd" => "__builtin_ia32_pmovzxbd512",
                    "avx512.pmovzxbq" => "__builtin_ia32_pmovzxbq512",
                    "avx512.pmovzxdq" => "__builtin_ia32_pmovzxdq512",
                    "avx512.pmovzxwd" => "__builtin_ia32_pmovzxwd512",
                    "avx512.pmovzxwq" => "__builtin_ia32_pmovzxwq512",
                    "avx512.pmul.hr.sw.512" => "__builtin_ia32_pmulhrsw512",
                    "avx512.pmulh.w.512" => "__builtin_ia32_pmulhw512",
                    "avx512.pmulhu.w.512" => "__builtin_ia32_pmulhuw512",
                    "avx512.pmultishift.qb.128" => "__builtin_ia32_vpmultishiftqb128",
                    "avx512.pmultishift.qb.256" => "__builtin_ia32_vpmultishiftqb256",
                    "avx512.pmultishift.qb.512" => "__builtin_ia32_vpmultishiftqb512",
                    "avx512.psad.bw.512" => "__builtin_ia32_psadbw512",
                    "avx512.pshuf.b.512" => "__builtin_ia32_pshufb512",
                    "avx512.psll.d.512" => "__builtin_ia32_pslld512",
                    "avx512.psll.dq" => "__builtin_ia32_pslldqi512",
                    "avx512.psll.dq.bs" => "__builtin_ia32_pslldqi512_byteshift",
                    "avx512.psll.q.512" => "__builtin_ia32_psllq512",
                    "avx512.psll.w.512" => "__builtin_ia32_psllw512",
                    "avx512.pslli.d.512" => "__builtin_ia32_pslldi512",
                    "avx512.pslli.q.512" => "__builtin_ia32_psllqi512",
                    "avx512.pslli.w.512" => "__builtin_ia32_psllwi512",
                    "avx512.psllv.d.512" => "__builtin_ia32_psllv16si",
                    "avx512.psllv.q.512" => "__builtin_ia32_psllv8di",
                    "avx512.psllv.w.128" => "__builtin_ia32_psllv8hi",
                    "avx512.psllv.w.256" => "__builtin_ia32_psllv16hi",
                    "avx512.psllv.w.512" => "__builtin_ia32_psllv32hi",
                    "avx512.psra.d.512" => "__builtin_ia32_psrad512",
                    "avx512.psra.q.128" => "__builtin_ia32_psraq128",
                    "avx512.psra.q.256" => "__builtin_ia32_psraq256",
                    "avx512.psra.q.512" => "__builtin_ia32_psraq512",
                    "avx512.psra.w.512" => "__builtin_ia32_psraw512",
                    "avx512.psrai.d.512" => "__builtin_ia32_psradi512",
                    "avx512.psrai.q.128" => "__builtin_ia32_psraqi128",
                    "avx512.psrai.q.256" => "__builtin_ia32_psraqi256",
                    "avx512.psrai.q.512" => "__builtin_ia32_psraqi512",
                    "avx512.psrai.w.512" => "__builtin_ia32_psrawi512",
                    "avx512.psrav.d.512" => "__builtin_ia32_psrav16si",
                    "avx512.psrav.q.128" => "__builtin_ia32_psravq128",
                    "avx512.psrav.q.256" => "__builtin_ia32_psravq256",
                    "avx512.psrav.q.512" => "__builtin_ia32_psrav8di",
                    "avx512.psrav.w.128" => "__builtin_ia32_psrav8hi",
                    "avx512.psrav.w.256" => "__builtin_ia32_psrav16hi",
                    "avx512.psrav.w.512" => "__builtin_ia32_psrav32hi",
                    "avx512.psrl.d.512" => "__builtin_ia32_psrld512",
                    "avx512.psrl.dq" => "__builtin_ia32_psrldqi512",
                    "avx512.psrl.dq.bs" => "__builtin_ia32_psrldqi512_byteshift",
                    "avx512.psrl.q.512" => "__builtin_ia32_psrlq512",
                    "avx512.psrl.w.512" => "__builtin_ia32_psrlw512",
                    "avx512.psrli.d.512" => "__builtin_ia32_psrldi512",
                    "avx512.psrli.q.512" => "__builtin_ia32_psrlqi512",
                    "avx512.psrli.w.512" => "__builtin_ia32_psrlwi512",
                    "avx512.psrlv.d.512" => "__builtin_ia32_psrlv16si",
                    "avx512.psrlv.q.512" => "__builtin_ia32_psrlv8di",
                    "avx512.psrlv.w.128" => "__builtin_ia32_psrlv8hi",
                    "avx512.psrlv.w.256" => "__builtin_ia32_psrlv16hi",
                    "avx512.psrlv.w.512" => "__builtin_ia32_psrlv32hi",
                    "avx512.pternlog.d.128" => "__builtin_ia32_pternlogd128",
                    "avx512.pternlog.d.256" => "__builtin_ia32_pternlogd256",
                    "avx512.pternlog.d.512" => "__builtin_ia32_pternlogd512",
                    "avx512.pternlog.q.128" => "__builtin_ia32_pternlogq128",
                    "avx512.pternlog.q.256" => "__builtin_ia32_pternlogq256",
                    "avx512.pternlog.q.512" => "__builtin_ia32_pternlogq512",
                    "avx512.ptestm.b.128" => "__builtin_ia32_ptestmb128",
                    "avx512.ptestm.b.256" => "__builtin_ia32_ptestmb256",
                    "avx512.ptestm.b.512" => "__builtin_ia32_ptestmb512",
                    "avx512.ptestm.d.128" => "__builtin_ia32_ptestmd128",
                    "avx512.ptestm.d.256" => "__builtin_ia32_ptestmd256",
                    "avx512.ptestm.d.512" => "__builtin_ia32_ptestmd512",
                    "avx512.ptestm.q.128" => "__builtin_ia32_ptestmq128",
                    "avx512.ptestm.q.256" => "__builtin_ia32_ptestmq256",
                    "avx512.ptestm.q.512" => "__builtin_ia32_ptestmq512",
                    "avx512.ptestm.w.128" => "__builtin_ia32_ptestmw128",
                    "avx512.ptestm.w.256" => "__builtin_ia32_ptestmw256",
                    "avx512.ptestm.w.512" => "__builtin_ia32_ptestmw512",
                    "avx512.ptestnm.b.128" => "__builtin_ia32_ptestnmb128",
                    "avx512.ptestnm.b.256" => "__builtin_ia32_ptestnmb256",
                    "avx512.ptestnm.b.512" => "__builtin_ia32_ptestnmb512",
                    "avx512.ptestnm.d.128" => "__builtin_ia32_ptestnmd128",
                    "avx512.ptestnm.d.256" => "__builtin_ia32_ptestnmd256",
                    "avx512.ptestnm.d.512" => "__builtin_ia32_ptestnmd512",
                    "avx512.ptestnm.q.128" => "__builtin_ia32_ptestnmq128",
                    "avx512.ptestnm.q.256" => "__builtin_ia32_ptestnmq256",
                    "avx512.ptestnm.q.512" => "__builtin_ia32_ptestnmq512",
                    "avx512.ptestnm.w.128" => "__builtin_ia32_ptestnmw128",
                    "avx512.ptestnm.w.256" => "__builtin_ia32_ptestnmw256",
                    "avx512.ptestnm.w.512" => "__builtin_ia32_ptestnmw512",
                    "avx512.rcp14.pd.128" => "__builtin_ia32_rcp14pd128_mask",
                    "avx512.rcp14.pd.256" => "__builtin_ia32_rcp14pd256_mask",
                    "avx512.rcp14.pd.512" => "__builtin_ia32_rcp14pd512_mask",
                    "avx512.rcp14.ps.128" => "__builtin_ia32_rcp14ps128_mask",
                    "avx512.rcp14.ps.256" => "__builtin_ia32_rcp14ps256_mask",
                    "avx512.rcp14.ps.512" => "__builtin_ia32_rcp14ps512_mask",
                    "avx512.rcp14.sd" => "__builtin_ia32_rcp14sd_mask",
                    "avx512.rcp14.ss" => "__builtin_ia32_rcp14ss_mask",
                    "avx512.rcp28.pd" => "__builtin_ia32_rcp28pd_mask",
                    "avx512.rcp28.ps" => "__builtin_ia32_rcp28ps_mask",
                    "avx512.rcp28.sd" => "__builtin_ia32_rcp28sd_mask",
                    // [DUPLICATE]: "avx512.rcp28.sd" => "__builtin_ia32_rcp28sd_round_mask",
                    "avx512.rcp28.ss" => "__builtin_ia32_rcp28ss_mask",
                    // [DUPLICATE]: "avx512.rcp28.ss" => "__builtin_ia32_rcp28ss_round_mask",
                    "avx512.rndscale.sd" => "__builtin_ia32_rndscalesd",
                    "avx512.rndscale.ss" => "__builtin_ia32_rndscaless",
                    "avx512.rsqrt14.pd.128" => "__builtin_ia32_rsqrt14pd128_mask",
                    "avx512.rsqrt14.pd.256" => "__builtin_ia32_rsqrt14pd256_mask",
                    "avx512.rsqrt14.pd.512" => "__builtin_ia32_rsqrt14pd512_mask",
                    "avx512.rsqrt14.ps.128" => "__builtin_ia32_rsqrt14ps128_mask",
                    "avx512.rsqrt14.ps.256" => "__builtin_ia32_rsqrt14ps256_mask",
                    "avx512.rsqrt14.ps.512" => "__builtin_ia32_rsqrt14ps512_mask",
                    "avx512.rsqrt14.sd" => "__builtin_ia32_rsqrt14sd_mask",
                    "avx512.rsqrt14.ss" => "__builtin_ia32_rsqrt14ss_mask",
                    "avx512.rsqrt28.pd" => "__builtin_ia32_rsqrt28pd_mask",
                    "avx512.rsqrt28.ps" => "__builtin_ia32_rsqrt28ps_mask",
                    "avx512.rsqrt28.sd" => "__builtin_ia32_rsqrt28sd_mask",
                    // [DUPLICATE]: "avx512.rsqrt28.sd" => "__builtin_ia32_rsqrt28sd_round_mask",
                    "avx512.rsqrt28.ss" => "__builtin_ia32_rsqrt28ss_mask",
                    // [DUPLICATE]: "avx512.rsqrt28.ss" => "__builtin_ia32_rsqrt28ss_round_mask",
                    "avx512.scatter.dpd.512" => "__builtin_ia32_scattersiv8df",
                    "avx512.scatter.dpi.512" => "__builtin_ia32_scattersiv16si",
                    "avx512.scatter.dpq.512" => "__builtin_ia32_scattersiv8di",
                    "avx512.scatter.dps.512" => "__builtin_ia32_scattersiv16sf",
                    "avx512.scatter.qpd.512" => "__builtin_ia32_scatterdiv8df",
                    "avx512.scatter.qpi.512" => "__builtin_ia32_scatterdiv16si",
                    "avx512.scatter.qpq.512" => "__builtin_ia32_scatterdiv8di",
                    "avx512.scatter.qps.512" => "__builtin_ia32_scatterdiv16sf",
                    "avx512.scatterdiv2.df" => "__builtin_ia32_scatterdiv2df",
                    "avx512.scatterdiv2.di" => "__builtin_ia32_scatterdiv2di",
                    "avx512.scatterdiv4.df" => "__builtin_ia32_scatterdiv4df",
                    "avx512.scatterdiv4.di" => "__builtin_ia32_scatterdiv4di",
                    "avx512.scatterdiv4.sf" => "__builtin_ia32_scatterdiv4sf",
                    "avx512.scatterdiv4.si" => "__builtin_ia32_scatterdiv4si",
                    "avx512.scatterdiv8.sf" => "__builtin_ia32_scatterdiv8sf",
                    "avx512.scatterdiv8.si" => "__builtin_ia32_scatterdiv8si",
                    "avx512.scatterpf.dpd.512" => "__builtin_ia32_scatterpfdpd",
                    "avx512.scatterpf.dps.512" => "__builtin_ia32_scatterpfdps",
                    "avx512.scatterpf.qpd.512" => "__builtin_ia32_scatterpfqpd",
                    "avx512.scatterpf.qps.512" => "__builtin_ia32_scatterpfqps",
                    "avx512.scattersiv2.df" => "__builtin_ia32_scattersiv2df",
                    "avx512.scattersiv2.di" => "__builtin_ia32_scattersiv2di",
                    "avx512.scattersiv4.df" => "__builtin_ia32_scattersiv4df",
                    "avx512.scattersiv4.di" => "__builtin_ia32_scattersiv4di",
                    "avx512.scattersiv4.sf" => "__builtin_ia32_scattersiv4sf",
                    "avx512.scattersiv4.si" => "__builtin_ia32_scattersiv4si",
                    "avx512.scattersiv8.sf" => "__builtin_ia32_scattersiv8sf",
                    "avx512.scattersiv8.si" => "__builtin_ia32_scattersiv8si",
                    "avx512.sqrt.pd.512" => "__builtin_ia32_sqrtpd512_mask",
                    "avx512.sqrt.ps.512" => "__builtin_ia32_sqrtps512_mask",
                    "avx512.sqrt.sd" => "__builtin_ia32_sqrtrndsd",
                    "avx512.sqrt.ss" => "__builtin_ia32_sqrtrndss",
                    "avx512.sub.pd.512" => "__builtin_ia32_subpd512",
                    "avx512.sub.ps.512" => "__builtin_ia32_subps512",
                    "avx512.vbroadcast.sd.512" => "__builtin_ia32_vbroadcastsd512",
                    "avx512.vbroadcast.sd.pd.512" => "__builtin_ia32_vbroadcastsd_pd512",
                    "avx512.vbroadcast.ss.512" => "__builtin_ia32_vbroadcastss512",
                    "avx512.vbroadcast.ss.ps.512" => "__builtin_ia32_vbroadcastss_ps512",
                    "avx512.vcomi.sd" => "__builtin_ia32_vcomisd",
                    "avx512.vcomi.ss" => "__builtin_ia32_vcomiss",
                    "avx512.vcvtsd2si32" => "__builtin_ia32_vcvtsd2si32",
                    "avx512.vcvtsd2si64" => "__builtin_ia32_vcvtsd2si64",
                    "avx512.vcvtsd2usi32" => "__builtin_ia32_vcvtsd2usi32",
                    "avx512.vcvtsd2usi64" => "__builtin_ia32_vcvtsd2usi64",
                    "avx512.vcvtss2si32" => "__builtin_ia32_vcvtss2si32",
                    "avx512.vcvtss2si64" => "__builtin_ia32_vcvtss2si64",
                    "avx512.vcvtss2usi32" => "__builtin_ia32_vcvtss2usi32",
                    "avx512.vcvtss2usi64" => "__builtin_ia32_vcvtss2usi64",
                    "avx512.vpdpbusd.128" => "__builtin_ia32_vpdpbusd128",
                    "avx512.vpdpbusd.256" => "__builtin_ia32_vpdpbusd256",
                    "avx512.vpdpbusd.512" => "__builtin_ia32_vpdpbusd512",
                    "avx512.vpdpbusds.128" => "__builtin_ia32_vpdpbusds128",
                    "avx512.vpdpbusds.256" => "__builtin_ia32_vpdpbusds256",
                    "avx512.vpdpbusds.512" => "__builtin_ia32_vpdpbusds512",
                    "avx512.vpdpwssd.128" => "__builtin_ia32_vpdpwssd128",
                    "avx512.vpdpwssd.256" => "__builtin_ia32_vpdpwssd256",
                    "avx512.vpdpwssd.512" => "__builtin_ia32_vpdpwssd512",
                    "avx512.vpdpwssds.128" => "__builtin_ia32_vpdpwssds128",
                    "avx512.vpdpwssds.256" => "__builtin_ia32_vpdpwssds256",
                    "avx512.vpdpwssds.512" => "__builtin_ia32_vpdpwssds512",
                    "avx512.vpermi2var.d.128" => "__builtin_ia32_vpermi2vard128",
                    "avx512.vpermi2var.d.256" => "__builtin_ia32_vpermi2vard256",
                    "avx512.vpermi2var.d.512" => "__builtin_ia32_vpermi2vard512",
                    "avx512.vpermi2var.hi.128" => "__builtin_ia32_vpermi2varhi128",
                    "avx512.vpermi2var.hi.256" => "__builtin_ia32_vpermi2varhi256",
                    "avx512.vpermi2var.hi.512" => "__builtin_ia32_vpermi2varhi512",
                    "avx512.vpermi2var.pd.128" => "__builtin_ia32_vpermi2varpd128",
                    "avx512.vpermi2var.pd.256" => "__builtin_ia32_vpermi2varpd256",
                    "avx512.vpermi2var.pd.512" => "__builtin_ia32_vpermi2varpd512",
                    "avx512.vpermi2var.ps.128" => "__builtin_ia32_vpermi2varps128",
                    "avx512.vpermi2var.ps.256" => "__builtin_ia32_vpermi2varps256",
                    "avx512.vpermi2var.ps.512" => "__builtin_ia32_vpermi2varps512",
                    "avx512.vpermi2var.q.128" => "__builtin_ia32_vpermi2varq128",
                    "avx512.vpermi2var.q.256" => "__builtin_ia32_vpermi2varq256",
                    "avx512.vpermi2var.q.512" => "__builtin_ia32_vpermi2varq512",
                    "avx512.vpermi2var.qi.128" => "__builtin_ia32_vpermi2varqi128",
                    "avx512.vpermi2var.qi.256" => "__builtin_ia32_vpermi2varqi256",
                    "avx512.vpermi2var.qi.512" => "__builtin_ia32_vpermi2varqi512",
                    "avx512.vpermilvar.pd.512" => "__builtin_ia32_vpermilvarpd512",
                    "avx512.vpermilvar.ps.512" => "__builtin_ia32_vpermilvarps512",
                    "avx512.vpmadd52h.uq.128" => "__builtin_ia32_vpmadd52huq128",
                    "avx512.vpmadd52h.uq.256" => "__builtin_ia32_vpmadd52huq256",
                    "avx512.vpmadd52h.uq.512" => "__builtin_ia32_vpmadd52huq512",
                    "avx512.vpmadd52l.uq.128" => "__builtin_ia32_vpmadd52luq128",
                    "avx512.vpmadd52l.uq.256" => "__builtin_ia32_vpmadd52luq256",
                    "avx512.vpmadd52l.uq.512" => "__builtin_ia32_vpmadd52luq512",
                    "avx512bf16.cvtne2ps2bf16.128" => "__builtin_ia32_cvtne2ps2bf16_128",
                    "avx512bf16.cvtne2ps2bf16.256" => "__builtin_ia32_cvtne2ps2bf16_256",
                    "avx512bf16.cvtne2ps2bf16.512" => "__builtin_ia32_cvtne2ps2bf16_512",
                    "avx512bf16.cvtneps2bf16.256" => "__builtin_ia32_cvtneps2bf16_256",
                    "avx512bf16.cvtneps2bf16.512" => "__builtin_ia32_cvtneps2bf16_512",
                    "avx512bf16.dpbf16ps.128" => "__builtin_ia32_dpbf16ps_128",
                    "avx512bf16.dpbf16ps.256" => "__builtin_ia32_dpbf16ps_256",
                    "avx512bf16.dpbf16ps.512" => "__builtin_ia32_dpbf16ps_512",
                    "avx512fp16.add.ph.512" => "__builtin_ia32_addph512",
                    "avx512fp16.div.ph.512" => "__builtin_ia32_divph512",
                    // [INVALID CONVERSION]: "avx512fp16.mask.add.sh.round" => "__builtin_ia32_addsh_round_mask",
                    "avx512fp16.mask.cmp.sh" => "__builtin_ia32_cmpsh_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.div.sh.round" => "__builtin_ia32_divsh_round_mask",
                    "avx512fp16.mask.fpclass.sh" => "__builtin_ia32_fpclasssh_mask",
                    "avx512fp16.mask.getexp.ph.128" => "__builtin_ia32_getexpph128_mask",
                    "avx512fp16.mask.getexp.ph.256" => "__builtin_ia32_getexpph256_mask",
                    "avx512fp16.mask.getexp.ph.512" => "__builtin_ia32_getexpph512_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.getexp.sh" => "__builtin_ia32_getexpsh128_round_mask",
                    "avx512fp16.mask.getmant.ph.128" => "__builtin_ia32_getmantph128_mask",
                    "avx512fp16.mask.getmant.ph.256" => "__builtin_ia32_getmantph256_mask",
                    "avx512fp16.mask.getmant.ph.512" => "__builtin_ia32_getmantph512_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.getmant.sh" => "__builtin_ia32_getmantsh_round_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.max.sh.round" => "__builtin_ia32_maxsh_round_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.min.sh.round" => "__builtin_ia32_minsh_round_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.mul.sh.round" => "__builtin_ia32_mulsh_round_mask",
                    "avx512fp16.mask.rcp.ph.128" => "__builtin_ia32_rcpph128_mask",
                    "avx512fp16.mask.rcp.ph.256" => "__builtin_ia32_rcpph256_mask",
                    "avx512fp16.mask.rcp.ph.512" => "__builtin_ia32_rcpph512_mask",
                    "avx512fp16.mask.rcp.sh" => "__builtin_ia32_rcpsh_mask",
                    "avx512fp16.mask.reduce.ph.128" => "__builtin_ia32_reduceph128_mask",
                    "avx512fp16.mask.reduce.ph.256" => "__builtin_ia32_reduceph256_mask",
                    "avx512fp16.mask.reduce.ph.512" => "__builtin_ia32_reduceph512_mask",
                    "avx512fp16.mask.reduce.sh" => "__builtin_ia32_reducesh_mask",
                    "avx512fp16.mask.rndscale.ph.128" => "__builtin_ia32_rndscaleph_128_mask",
                    "avx512fp16.mask.rndscale.ph.256" => "__builtin_ia32_rndscaleph_256_mask",
                    "avx512fp16.mask.rndscale.ph.512" => "__builtin_ia32_rndscaleph_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.rndscale.sh" => "__builtin_ia32_rndscalesh_round_mask",
                    "avx512fp16.mask.rsqrt.ph.128" => "__builtin_ia32_rsqrtph128_mask",
                    "avx512fp16.mask.rsqrt.ph.256" => "__builtin_ia32_rsqrtph256_mask",
                    "avx512fp16.mask.rsqrt.ph.512" => "__builtin_ia32_rsqrtph512_mask",
                    "avx512fp16.mask.rsqrt.sh" => "__builtin_ia32_rsqrtsh_mask",
                    "avx512fp16.mask.scalef.ph.128" => "__builtin_ia32_scalefph128_mask",
                    "avx512fp16.mask.scalef.ph.256" => "__builtin_ia32_scalefph256_mask",
                    "avx512fp16.mask.scalef.ph.512" => "__builtin_ia32_scalefph512_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.scalef.sh" => "__builtin_ia32_scalefsh_round_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.sub.sh.round" => "__builtin_ia32_subsh_round_mask",
                    "avx512fp16.mask.vcvtdq2ph.128" => "__builtin_ia32_vcvtdq2ph128_mask",
                    "avx512fp16.mask.vcvtpd2ph.128" => "__builtin_ia32_vcvtpd2ph128_mask",
                    "avx512fp16.mask.vcvtpd2ph.256" => "__builtin_ia32_vcvtpd2ph256_mask",
                    "avx512fp16.mask.vcvtpd2ph.512" => "__builtin_ia32_vcvtpd2ph512_mask",
                    "avx512fp16.mask.vcvtph2dq.128" => "__builtin_ia32_vcvtph2dq128_mask",
                    "avx512fp16.mask.vcvtph2dq.256" => "__builtin_ia32_vcvtph2dq256_mask",
                    "avx512fp16.mask.vcvtph2dq.512" => "__builtin_ia32_vcvtph2dq512_mask",
                    "avx512fp16.mask.vcvtph2pd.128" => "__builtin_ia32_vcvtph2pd128_mask",
                    "avx512fp16.mask.vcvtph2pd.256" => "__builtin_ia32_vcvtph2pd256_mask",
                    "avx512fp16.mask.vcvtph2pd.512" => "__builtin_ia32_vcvtph2pd512_mask",
                    "avx512fp16.mask.vcvtph2psx.128" => "__builtin_ia32_vcvtph2psx128_mask",
                    "avx512fp16.mask.vcvtph2psx.256" => "__builtin_ia32_vcvtph2psx256_mask",
                    "avx512fp16.mask.vcvtph2psx.512" => "__builtin_ia32_vcvtph2psx512_mask",
                    "avx512fp16.mask.vcvtph2qq.128" => "__builtin_ia32_vcvtph2qq128_mask",
                    "avx512fp16.mask.vcvtph2qq.256" => "__builtin_ia32_vcvtph2qq256_mask",
                    "avx512fp16.mask.vcvtph2qq.512" => "__builtin_ia32_vcvtph2qq512_mask",
                    "avx512fp16.mask.vcvtph2udq.128" => "__builtin_ia32_vcvtph2udq128_mask",
                    "avx512fp16.mask.vcvtph2udq.256" => "__builtin_ia32_vcvtph2udq256_mask",
                    "avx512fp16.mask.vcvtph2udq.512" => "__builtin_ia32_vcvtph2udq512_mask",
                    "avx512fp16.mask.vcvtph2uqq.128" => "__builtin_ia32_vcvtph2uqq128_mask",
                    "avx512fp16.mask.vcvtph2uqq.256" => "__builtin_ia32_vcvtph2uqq256_mask",
                    "avx512fp16.mask.vcvtph2uqq.512" => "__builtin_ia32_vcvtph2uqq512_mask",
                    "avx512fp16.mask.vcvtph2uw.128" => "__builtin_ia32_vcvtph2uw128_mask",
                    "avx512fp16.mask.vcvtph2uw.256" => "__builtin_ia32_vcvtph2uw256_mask",
                    "avx512fp16.mask.vcvtph2uw.512" => "__builtin_ia32_vcvtph2uw512_mask",
                    "avx512fp16.mask.vcvtph2w.128" => "__builtin_ia32_vcvtph2w128_mask",
                    "avx512fp16.mask.vcvtph2w.256" => "__builtin_ia32_vcvtph2w256_mask",
                    "avx512fp16.mask.vcvtph2w.512" => "__builtin_ia32_vcvtph2w512_mask",
                    "avx512fp16.mask.vcvtps2phx.128" => "__builtin_ia32_vcvtps2phx128_mask",
                    "avx512fp16.mask.vcvtps2phx.256" => "__builtin_ia32_vcvtps2phx256_mask",
                    "avx512fp16.mask.vcvtps2phx.512" => "__builtin_ia32_vcvtps2phx512_mask",
                    "avx512fp16.mask.vcvtqq2ph.128" => "__builtin_ia32_vcvtqq2ph128_mask",
                    "avx512fp16.mask.vcvtqq2ph.256" => "__builtin_ia32_vcvtqq2ph256_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.vcvtsd2sh.round" => "__builtin_ia32_vcvtsd2sh_round_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.vcvtsh2sd.round" => "__builtin_ia32_vcvtsh2sd_round_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.vcvtsh2ss.round" => "__builtin_ia32_vcvtsh2ss_round_mask",
                    // [INVALID CONVERSION]: "avx512fp16.mask.vcvtss2sh.round" => "__builtin_ia32_vcvtss2sh_round_mask",
                    "avx512fp16.mask.vcvttph2dq.128" => "__builtin_ia32_vcvttph2dq128_mask",
                    "avx512fp16.mask.vcvttph2dq.256" => "__builtin_ia32_vcvttph2dq256_mask",
                    "avx512fp16.mask.vcvttph2dq.512" => "__builtin_ia32_vcvttph2dq512_mask",
                    "avx512fp16.mask.vcvttph2qq.128" => "__builtin_ia32_vcvttph2qq128_mask",
                    "avx512fp16.mask.vcvttph2qq.256" => "__builtin_ia32_vcvttph2qq256_mask",
                    "avx512fp16.mask.vcvttph2qq.512" => "__builtin_ia32_vcvttph2qq512_mask",
                    "avx512fp16.mask.vcvttph2udq.128" => "__builtin_ia32_vcvttph2udq128_mask",
                    "avx512fp16.mask.vcvttph2udq.256" => "__builtin_ia32_vcvttph2udq256_mask",
                    "avx512fp16.mask.vcvttph2udq.512" => "__builtin_ia32_vcvttph2udq512_mask",
                    "avx512fp16.mask.vcvttph2uqq.128" => "__builtin_ia32_vcvttph2uqq128_mask",
                    "avx512fp16.mask.vcvttph2uqq.256" => "__builtin_ia32_vcvttph2uqq256_mask",
                    "avx512fp16.mask.vcvttph2uqq.512" => "__builtin_ia32_vcvttph2uqq512_mask",
                    "avx512fp16.mask.vcvttph2uw.128" => "__builtin_ia32_vcvttph2uw128_mask",
                    "avx512fp16.mask.vcvttph2uw.256" => "__builtin_ia32_vcvttph2uw256_mask",
                    "avx512fp16.mask.vcvttph2uw.512" => "__builtin_ia32_vcvttph2uw512_mask",
                    "avx512fp16.mask.vcvttph2w.128" => "__builtin_ia32_vcvttph2w128_mask",
                    "avx512fp16.mask.vcvttph2w.256" => "__builtin_ia32_vcvttph2w256_mask",
                    "avx512fp16.mask.vcvttph2w.512" => "__builtin_ia32_vcvttph2w512_mask",
                    "avx512fp16.mask.vcvtudq2ph.128" => "__builtin_ia32_vcvtudq2ph128_mask",
                    "avx512fp16.mask.vcvtuqq2ph.128" => "__builtin_ia32_vcvtuqq2ph128_mask",
                    "avx512fp16.mask.vcvtuqq2ph.256" => "__builtin_ia32_vcvtuqq2ph256_mask",
                    "avx512fp16.mask.vfcmadd.cph.128" => "__builtin_ia32_vfcmaddcph128_mask",
                    "avx512fp16.mask.vfcmadd.cph.256" => "__builtin_ia32_vfcmaddcph256_mask",
                    "avx512fp16.mask.vfcmadd.cph.512" => "__builtin_ia32_vfcmaddcph512_mask3",
                    "avx512fp16.mask.vfcmadd.csh" => "__builtin_ia32_vfcmaddcsh_mask",
                    "avx512fp16.mask.vfcmul.cph.128" => "__builtin_ia32_vfcmulcph128_mask",
                    "avx512fp16.mask.vfcmul.cph.256" => "__builtin_ia32_vfcmulcph256_mask",
                    "avx512fp16.mask.vfcmul.cph.512" => "__builtin_ia32_vfcmulcph512_mask",
                    "avx512fp16.mask.vfcmul.csh" => "__builtin_ia32_vfcmulcsh_mask",
                    "avx512fp16.mask.vfmadd.cph.128" => "__builtin_ia32_vfmaddcph128_mask",
                    "avx512fp16.mask.vfmadd.cph.256" => "__builtin_ia32_vfmaddcph256_mask",
                    "avx512fp16.mask.vfmadd.cph.512" => "__builtin_ia32_vfmaddcph512_mask3",
                    "avx512fp16.mask.vfmadd.csh" => "__builtin_ia32_vfmaddcsh_mask",
                    "avx512fp16.mask.vfmul.cph.128" => "__builtin_ia32_vfmulcph128_mask",
                    "avx512fp16.mask.vfmul.cph.256" => "__builtin_ia32_vfmulcph256_mask",
                    "avx512fp16.mask.vfmul.cph.512" => "__builtin_ia32_vfmulcph512_mask",
                    "avx512fp16.mask.vfmul.csh" => "__builtin_ia32_vfmulcsh_mask",
                    "avx512fp16.maskz.vfcmadd.cph.128" => "__builtin_ia32_vfcmaddcph128_maskz",
                    "avx512fp16.maskz.vfcmadd.cph.256" => "__builtin_ia32_vfcmaddcph256_maskz",
                    "avx512fp16.maskz.vfcmadd.cph.512" => "__builtin_ia32_vfcmaddcph512_maskz",
                    "avx512fp16.maskz.vfcmadd.csh" => "__builtin_ia32_vfcmaddcsh_maskz",
                    "avx512fp16.maskz.vfmadd.cph.128" => "__builtin_ia32_vfmaddcph128_maskz",
                    "avx512fp16.maskz.vfmadd.cph.256" => "__builtin_ia32_vfmaddcph256_maskz",
                    "avx512fp16.maskz.vfmadd.cph.512" => "__builtin_ia32_vfmaddcph512_maskz",
                    "avx512fp16.maskz.vfmadd.csh" => "__builtin_ia32_vfmaddcsh_maskz",
                    "avx512fp16.max.ph.128" => "__builtin_ia32_maxph128",
                    "avx512fp16.max.ph.256" => "__builtin_ia32_maxph256",
                    "avx512fp16.max.ph.512" => "__builtin_ia32_maxph512",
                    "avx512fp16.min.ph.128" => "__builtin_ia32_minph128",
                    "avx512fp16.min.ph.256" => "__builtin_ia32_minph256",
                    "avx512fp16.min.ph.512" => "__builtin_ia32_minph512",
                    "avx512fp16.mul.ph.512" => "__builtin_ia32_mulph512",
                    "avx512fp16.sub.ph.512" => "__builtin_ia32_subph512",
                    "avx512fp16.vcomi.sh" => "__builtin_ia32_vcomish",
                    "avx512fp16.vcvtsh2si32" => "__builtin_ia32_vcvtsh2si32",
                    "avx512fp16.vcvtsh2si64" => "__builtin_ia32_vcvtsh2si64",
                    "avx512fp16.vcvtsh2usi32" => "__builtin_ia32_vcvtsh2usi32",
                    "avx512fp16.vcvtsh2usi64" => "__builtin_ia32_vcvtsh2usi64",
                    "avx512fp16.vcvtsi2sh" => "__builtin_ia32_vcvtsi2sh",
                    "avx512fp16.vcvtsi642sh" => "__builtin_ia32_vcvtsi642sh",
                    "avx512fp16.vcvttsh2si32" => "__builtin_ia32_vcvttsh2si32",
                    "avx512fp16.vcvttsh2si64" => "__builtin_ia32_vcvttsh2si64",
                    "avx512fp16.vcvttsh2usi32" => "__builtin_ia32_vcvttsh2usi32",
                    "avx512fp16.vcvttsh2usi64" => "__builtin_ia32_vcvttsh2usi64",
                    "avx512fp16.vcvtusi2sh" => "__builtin_ia32_vcvtusi2sh",
                    "avx512fp16.vcvtusi642sh" => "__builtin_ia32_vcvtusi642sh",
                    "avx512fp16.vfmaddsub.ph.128" => "__builtin_ia32_vfmaddsubph",
                    "avx512fp16.vfmaddsub.ph.256" => "__builtin_ia32_vfmaddsubph256",
                    "axor32" => "__builtin_ia32_axor32",
                    "axor64" => "__builtin_ia32_axor64",
                    "bmi.bextr.32" => "__builtin_ia32_bextr_u32",
                    "bmi.bextr.64" => "__builtin_ia32_bextr_u64",
                    "bmi.bzhi.32" => "__builtin_ia32_bzhi_si",
                    "bmi.bzhi.64" => "__builtin_ia32_bzhi_di",
                    "bmi.pdep.32" => "__builtin_ia32_pdep_si",
                    "bmi.pdep.64" => "__builtin_ia32_pdep_di",
                    "bmi.pext.32" => "__builtin_ia32_pext_si",
                    "bmi.pext.64" => "__builtin_ia32_pext_di",
                    "cldemote" => "__builtin_ia32_cldemote",
                    "clflushopt" => "__builtin_ia32_clflushopt",
                    "clrssbsy" => "__builtin_ia32_clrssbsy",
                    "clui" => "__builtin_ia32_clui",
                    "clwb" => "__builtin_ia32_clwb",
                    "clzero" => "__builtin_ia32_clzero",
                    "cmpccxadd32" => "__builtin_ia32_cmpccxadd32",
                    "cmpccxadd64" => "__builtin_ia32_cmpccxadd64",
                    "directstore32" => "__builtin_ia32_directstore_u32",
                    "directstore64" => "__builtin_ia32_directstore_u64",
                    "enqcmd" => "__builtin_ia32_enqcmd",
                    "enqcmds" => "__builtin_ia32_enqcmds",
                    "flags.read.u32" => "__builtin_ia32_readeflags_u32",
                    "flags.read.u64" => "__builtin_ia32_readeflags_u64",
                    "flags.write.u32" => "__builtin_ia32_writeeflags_u32",
                    "flags.write.u64" => "__builtin_ia32_writeeflags_u64",
                    "fma.mask.vfmadd.pd.512" => "__builtin_ia32_vfmaddpd512_mask",
                    "fma.mask.vfmadd.ps.512" => "__builtin_ia32_vfmaddps512_mask",
                    "fma.mask.vfmaddsub.pd.512" => "__builtin_ia32_vfmaddsubpd512_mask",
                    "fma.mask.vfmaddsub.ps.512" => "__builtin_ia32_vfmaddsubps512_mask",
                    "fma.mask.vfmsub.pd.512" => "__builtin_ia32_vfmsubpd512_mask",
                    "fma.mask.vfmsub.ps.512" => "__builtin_ia32_vfmsubps512_mask",
                    "fma.mask.vfmsubadd.pd.512" => "__builtin_ia32_vfmsubaddpd512_mask",
                    "fma.mask.vfmsubadd.ps.512" => "__builtin_ia32_vfmsubaddps512_mask",
                    "fma.mask.vfnmadd.pd.512" => "__builtin_ia32_vfnmaddpd512_mask",
                    "fma.mask.vfnmadd.ps.512" => "__builtin_ia32_vfnmaddps512_mask",
                    "fma.mask.vfnmsub.pd.512" => "__builtin_ia32_vfnmsubpd512_mask",
                    "fma.mask.vfnmsub.ps.512" => "__builtin_ia32_vfnmsubps512_mask",
                    "fma.vfmadd.pd" => "__builtin_ia32_vfmaddpd",
                    "fma.vfmadd.pd.256" => "__builtin_ia32_vfmaddpd256",
                    "fma.vfmadd.ps" => "__builtin_ia32_vfmaddps",
                    "fma.vfmadd.ps.256" => "__builtin_ia32_vfmaddps256",
                    "fma.vfmadd.sd" => "__builtin_ia32_vfmaddsd",
                    "fma.vfmadd.ss" => "__builtin_ia32_vfmaddss",
                    "fma.vfmaddsub.pd" => "__builtin_ia32_vfmaddsubpd",
                    "fma.vfmaddsub.pd.256" => "__builtin_ia32_vfmaddsubpd256",
                    "fma.vfmaddsub.ps" => "__builtin_ia32_vfmaddsubps",
                    "fma.vfmaddsub.ps.256" => "__builtin_ia32_vfmaddsubps256",
                    "fma.vfmsub.pd" => "__builtin_ia32_vfmsubpd",
                    "fma.vfmsub.pd.256" => "__builtin_ia32_vfmsubpd256",
                    "fma.vfmsub.ps" => "__builtin_ia32_vfmsubps",
                    "fma.vfmsub.ps.256" => "__builtin_ia32_vfmsubps256",
                    "fma.vfmsub.sd" => "__builtin_ia32_vfmsubsd",
                    "fma.vfmsub.ss" => "__builtin_ia32_vfmsubss",
                    "fma.vfmsubadd.pd" => "__builtin_ia32_vfmsubaddpd",
                    "fma.vfmsubadd.pd.256" => "__builtin_ia32_vfmsubaddpd256",
                    "fma.vfmsubadd.ps" => "__builtin_ia32_vfmsubaddps",
                    "fma.vfmsubadd.ps.256" => "__builtin_ia32_vfmsubaddps256",
                    "fma.vfnmadd.pd" => "__builtin_ia32_vfnmaddpd",
                    "fma.vfnmadd.pd.256" => "__builtin_ia32_vfnmaddpd256",
                    "fma.vfnmadd.ps" => "__builtin_ia32_vfnmaddps",
                    "fma.vfnmadd.ps.256" => "__builtin_ia32_vfnmaddps256",
                    "fma.vfnmadd.sd" => "__builtin_ia32_vfnmaddsd",
                    "fma.vfnmadd.ss" => "__builtin_ia32_vfnmaddss",
                    "fma.vfnmsub.pd" => "__builtin_ia32_vfnmsubpd",
                    "fma.vfnmsub.pd.256" => "__builtin_ia32_vfnmsubpd256",
                    "fma.vfnmsub.ps" => "__builtin_ia32_vfnmsubps",
                    "fma.vfnmsub.ps.256" => "__builtin_ia32_vfnmsubps256",
                    "fma.vfnmsub.sd" => "__builtin_ia32_vfnmsubsd",
                    "fma.vfnmsub.ss" => "__builtin_ia32_vfnmsubss",
                    "fxrstor" => "__builtin_ia32_fxrstor",
                    "fxrstor64" => "__builtin_ia32_fxrstor64",
                    "fxsave" => "__builtin_ia32_fxsave",
                    "fxsave64" => "__builtin_ia32_fxsave64",
                    "incsspd" => "__builtin_ia32_incsspd",
                    "incsspq" => "__builtin_ia32_incsspq",
                    "invpcid" => "__builtin_ia32_invpcid",
                    "ldtilecfg" => "__builtin_ia32_tile_loadconfig",
                    "ldtilecfg.internal" => "__builtin_ia32_tile_loadconfig_internal",
                    "llwpcb" => "__builtin_ia32_llwpcb",
                    "loadiwkey" => "__builtin_ia32_loadiwkey",
                    "lwpins32" => "__builtin_ia32_lwpins32",
                    "lwpins64" => "__builtin_ia32_lwpins64",
                    "lwpval32" => "__builtin_ia32_lwpval32",
                    "lwpval64" => "__builtin_ia32_lwpval64",
                    "mmx.emms" => "__builtin_ia32_emms",
                    "mmx.femms" => "__builtin_ia32_femms",
                    "monitorx" => "__builtin_ia32_monitorx",
                    "movdir64b" => "__builtin_ia32_movdir64b",
                    "movrsdi" => "__builtin_ia32_movrsdi",
                    "movrshi" => "__builtin_ia32_movrshi",
                    "movrsqi" => "__builtin_ia32_movrsqi",
                    "movrssi" => "__builtin_ia32_movrssi",
                    "mwaitx" => "__builtin_ia32_mwaitx",
                    "pclmulqdq" => "__builtin_ia32_pclmulqdq128",
                    "pclmulqdq.256" => "__builtin_ia32_pclmulqdq256",
                    "pclmulqdq.512" => "__builtin_ia32_pclmulqdq512",
                    "prefetchrs" => "__builtin_ia32_prefetchrs",
                    "ptwrite32" => "__builtin_ia32_ptwrite32",
                    "ptwrite64" => "__builtin_ia32_ptwrite64",
                    "rdfsbase.32" => "__builtin_ia32_rdfsbase32",
                    "rdfsbase.64" => "__builtin_ia32_rdfsbase64",
                    "rdgsbase.32" => "__builtin_ia32_rdgsbase32",
                    "rdgsbase.64" => "__builtin_ia32_rdgsbase64",
                    "rdpid" => "__builtin_ia32_rdpid",
                    "rdpkru" => "__builtin_ia32_rdpkru",
                    "rdpmc" => "__builtin_ia32_rdpmc",
                    "rdpru" => "__builtin_ia32_rdpru",
                    "rdsspd" => "__builtin_ia32_rdsspd",
                    "rdsspq" => "__builtin_ia32_rdsspq",
                    "rdtsc" => "__builtin_ia32_rdtsc",
                    "rdtscp" => "__builtin_ia32_rdtscp",
                    "rstorssp" => "__builtin_ia32_rstorssp",
                    "saveprevssp" => "__builtin_ia32_saveprevssp",
                    "senduipi" => "__builtin_ia32_senduipi",
                    "serialize" => "__builtin_ia32_serialize",
                    "setssbsy" => "__builtin_ia32_setssbsy",
                    "sha1msg1" => "__builtin_ia32_sha1msg1",
                    "sha1msg2" => "__builtin_ia32_sha1msg2",
                    "sha1nexte" => "__builtin_ia32_sha1nexte",
                    "sha1rnds4" => "__builtin_ia32_sha1rnds4",
                    "sha256msg1" => "__builtin_ia32_sha256msg1",
                    "sha256msg2" => "__builtin_ia32_sha256msg2",
                    "sha256rnds2" => "__builtin_ia32_sha256rnds2",
                    "slwpcb" => "__builtin_ia32_slwpcb",
                    "sse.add.ss" => "__builtin_ia32_addss",
                    "sse.cmp.ps" => "__builtin_ia32_cmpps",
                    "sse.cmp.ss" => "__builtin_ia32_cmpss",
                    "sse.comieq.ss" => "__builtin_ia32_comieq",
                    "sse.comige.ss" => "__builtin_ia32_comige",
                    "sse.comigt.ss" => "__builtin_ia32_comigt",
                    "sse.comile.ss" => "__builtin_ia32_comile",
                    "sse.comilt.ss" => "__builtin_ia32_comilt",
                    "sse.comineq.ss" => "__builtin_ia32_comineq",
                    "sse.cvtsi2ss" => "__builtin_ia32_cvtsi2ss",
                    "sse.cvtsi642ss" => "__builtin_ia32_cvtsi642ss",
                    "sse.cvtss2si" => "__builtin_ia32_cvtss2si",
                    "sse.cvtss2si64" => "__builtin_ia32_cvtss2si64",
                    "sse.cvttss2si" => "__builtin_ia32_cvttss2si",
                    "sse.cvttss2si64" => "__builtin_ia32_cvttss2si64",
                    "sse.div.ss" => "__builtin_ia32_divss",
                    "sse.max.ps" => "__builtin_ia32_maxps",
                    "sse.max.ss" => "__builtin_ia32_maxss",
                    "sse.min.ps" => "__builtin_ia32_minps",
                    "sse.min.ss" => "__builtin_ia32_minss",
                    "sse.movmsk.ps" => "__builtin_ia32_movmskps",
                    "sse.mul.ss" => "__builtin_ia32_mulss",
                    "sse.rcp.ps" => "__builtin_ia32_rcpps",
                    "sse.rcp.ss" => "__builtin_ia32_rcpss",
                    "sse.rsqrt.ps" => "__builtin_ia32_rsqrtps",
                    "sse.rsqrt.ss" => "__builtin_ia32_rsqrtss",
                    "sse.sfence" => "__builtin_ia32_sfence",
                    "sse.sqrt.ps" => "__builtin_ia32_sqrtps",
                    "sse.sqrt.ss" => "__builtin_ia32_sqrtss",
                    "sse.storeu.ps" => "__builtin_ia32_storeups",
                    "sse.sub.ss" => "__builtin_ia32_subss",
                    "sse.ucomieq.ss" => "__builtin_ia32_ucomieq",
                    "sse.ucomige.ss" => "__builtin_ia32_ucomige",
                    "sse.ucomigt.ss" => "__builtin_ia32_ucomigt",
                    "sse.ucomile.ss" => "__builtin_ia32_ucomile",
                    "sse.ucomilt.ss" => "__builtin_ia32_ucomilt",
                    "sse.ucomineq.ss" => "__builtin_ia32_ucomineq",
                    "sse2.add.sd" => "__builtin_ia32_addsd",
                    "sse2.clflush" => "__builtin_ia32_clflush",
                    "sse2.cmp.pd" => "__builtin_ia32_cmppd",
                    "sse2.cmp.sd" => "__builtin_ia32_cmpsd",
                    "sse2.comieq.sd" => "__builtin_ia32_comisdeq",
                    "sse2.comige.sd" => "__builtin_ia32_comisdge",
                    "sse2.comigt.sd" => "__builtin_ia32_comisdgt",
                    "sse2.comile.sd" => "__builtin_ia32_comisdle",
                    "sse2.comilt.sd" => "__builtin_ia32_comisdlt",
                    "sse2.comineq.sd" => "__builtin_ia32_comisdneq",
                    "sse2.cvtdq2pd" => "__builtin_ia32_cvtdq2pd",
                    "sse2.cvtdq2ps" => "__builtin_ia32_cvtdq2ps",
                    "sse2.cvtpd2dq" => "__builtin_ia32_cvtpd2dq",
                    "sse2.cvtpd2ps" => "__builtin_ia32_cvtpd2ps",
                    "sse2.cvtps2dq" => "__builtin_ia32_cvtps2dq",
                    "sse2.cvtps2pd" => "__builtin_ia32_cvtps2pd",
                    "sse2.cvtsd2si" => "__builtin_ia32_cvtsd2si",
                    "sse2.cvtsd2si64" => "__builtin_ia32_cvtsd2si64",
                    "sse2.cvtsd2ss" => "__builtin_ia32_cvtsd2ss",
                    "sse2.cvtsi2sd" => "__builtin_ia32_cvtsi2sd",
                    "sse2.cvtsi642sd" => "__builtin_ia32_cvtsi642sd",
                    "sse2.cvtss2sd" => "__builtin_ia32_cvtss2sd",
                    "sse2.cvttpd2dq" => "__builtin_ia32_cvttpd2dq",
                    "sse2.cvttps2dq" => "__builtin_ia32_cvttps2dq",
                    "sse2.cvttsd2si" => "__builtin_ia32_cvttsd2si",
                    "sse2.cvttsd2si64" => "__builtin_ia32_cvttsd2si64",
                    "sse2.div.sd" => "__builtin_ia32_divsd",
                    "sse2.lfence" => "__builtin_ia32_lfence",
                    "sse2.maskmov.dqu" => "__builtin_ia32_maskmovdqu",
                    "sse2.max.pd" => "__builtin_ia32_maxpd",
                    "sse2.max.sd" => "__builtin_ia32_maxsd",
                    "sse2.mfence" => "__builtin_ia32_mfence",
                    "sse2.min.pd" => "__builtin_ia32_minpd",
                    "sse2.min.sd" => "__builtin_ia32_minsd",
                    "sse2.movmsk.pd" => "__builtin_ia32_movmskpd",
                    "sse2.mul.sd" => "__builtin_ia32_mulsd",
                    "sse2.packssdw.128" => "__builtin_ia32_packssdw128",
                    "sse2.packsswb.128" => "__builtin_ia32_packsswb128",
                    "sse2.packuswb.128" => "__builtin_ia32_packuswb128",
                    "sse2.padds.b" => "__builtin_ia32_paddsb128",
                    "sse2.padds.w" => "__builtin_ia32_paddsw128",
                    "sse2.paddus.b" => "__builtin_ia32_paddusb128",
                    "sse2.paddus.w" => "__builtin_ia32_paddusw128",
                    "sse2.pause" => "__builtin_ia32_pause",
                    "sse2.pavg.b" => "__builtin_ia32_pavgb128",
                    "sse2.pavg.w" => "__builtin_ia32_pavgw128",
                    "sse2.pmadd.wd" => "__builtin_ia32_pmaddwd128",
                    "sse2.pmaxs.w" => "__builtin_ia32_pmaxsw128",
                    "sse2.pmaxu.b" => "__builtin_ia32_pmaxub128",
                    "sse2.pmins.w" => "__builtin_ia32_pminsw128",
                    "sse2.pminu.b" => "__builtin_ia32_pminub128",
                    "sse2.pmovmskb.128" => "__builtin_ia32_pmovmskb128",
                    "sse2.pmulh.w" => "__builtin_ia32_pmulhw128",
                    "sse2.pmulhu.w" => "__builtin_ia32_pmulhuw128",
                    "sse2.pmulu.dq" => "__builtin_ia32_pmuludq128",
                    "sse2.psad.bw" => "__builtin_ia32_psadbw128",
                    "sse2.pshuf.d" => "__builtin_ia32_pshufd",
                    "sse2.pshufh.w" => "__builtin_ia32_pshufhw",
                    "sse2.pshufl.w" => "__builtin_ia32_pshuflw",
                    "sse2.psll.d" => "__builtin_ia32_pslld128",
                    "sse2.psll.dq" => "__builtin_ia32_pslldqi128",
                    "sse2.psll.dq.bs" => "__builtin_ia32_pslldqi128_byteshift",
                    "sse2.psll.q" => "__builtin_ia32_psllq128",
                    "sse2.psll.w" => "__builtin_ia32_psllw128",
                    "sse2.pslli.d" => "__builtin_ia32_pslldi128",
                    "sse2.pslli.q" => "__builtin_ia32_psllqi128",
                    "sse2.pslli.w" => "__builtin_ia32_psllwi128",
                    "sse2.psra.d" => "__builtin_ia32_psrad128",
                    "sse2.psra.w" => "__builtin_ia32_psraw128",
                    "sse2.psrai.d" => "__builtin_ia32_psradi128",
                    "sse2.psrai.w" => "__builtin_ia32_psrawi128",
                    "sse2.psrl.d" => "__builtin_ia32_psrld128",
                    "sse2.psrl.dq" => "__builtin_ia32_psrldqi128",
                    "sse2.psrl.dq.bs" => "__builtin_ia32_psrldqi128_byteshift",
                    "sse2.psrl.q" => "__builtin_ia32_psrlq128",
                    "sse2.psrl.w" => "__builtin_ia32_psrlw128",
                    "sse2.psrli.d" => "__builtin_ia32_psrldi128",
                    "sse2.psrli.q" => "__builtin_ia32_psrlqi128",
                    "sse2.psrli.w" => "__builtin_ia32_psrlwi128",
                    "sse2.psubs.b" => "__builtin_ia32_psubsb128",
                    "sse2.psubs.w" => "__builtin_ia32_psubsw128",
                    "sse2.psubus.b" => "__builtin_ia32_psubusb128",
                    "sse2.psubus.w" => "__builtin_ia32_psubusw128",
                    "sse2.sqrt.pd" => "__builtin_ia32_sqrtpd",
                    "sse2.sqrt.sd" => "__builtin_ia32_sqrtsd",
                    "sse2.storel.dq" => "__builtin_ia32_storelv4si",
                    "sse2.storeu.dq" => "__builtin_ia32_storedqu",
                    "sse2.storeu.pd" => "__builtin_ia32_storeupd",
                    "sse2.sub.sd" => "__builtin_ia32_subsd",
                    "sse2.ucomieq.sd" => "__builtin_ia32_ucomisdeq",
                    "sse2.ucomige.sd" => "__builtin_ia32_ucomisdge",
                    "sse2.ucomigt.sd" => "__builtin_ia32_ucomisdgt",
                    "sse2.ucomile.sd" => "__builtin_ia32_ucomisdle",
                    "sse2.ucomilt.sd" => "__builtin_ia32_ucomisdlt",
                    "sse2.ucomineq.sd" => "__builtin_ia32_ucomisdneq",
                    "sse3.addsub.pd" => "__builtin_ia32_addsubpd",
                    "sse3.addsub.ps" => "__builtin_ia32_addsubps",
                    "sse3.hadd.pd" => "__builtin_ia32_haddpd",
                    "sse3.hadd.ps" => "__builtin_ia32_haddps",
                    "sse3.hsub.pd" => "__builtin_ia32_hsubpd",
                    "sse3.hsub.ps" => "__builtin_ia32_hsubps",
                    "sse3.ldu.dq" => "__builtin_ia32_lddqu",
                    "sse3.monitor" => "__builtin_ia32_monitor",
                    "sse3.mwait" => "__builtin_ia32_mwait",
                    "sse41.blendpd" => "__builtin_ia32_blendpd",
                    "sse41.blendps" => "__builtin_ia32_blendps",
                    "sse41.blendvpd" => "__builtin_ia32_blendvpd",
                    "sse41.blendvps" => "__builtin_ia32_blendvps",
                    "sse41.dppd" => "__builtin_ia32_dppd",
                    "sse41.dpps" => "__builtin_ia32_dpps",
                    "sse41.extractps" => "__builtin_ia32_extractps128",
                    "sse41.insertps" => "__builtin_ia32_insertps128",
                    "sse41.movntdqa" => "__builtin_ia32_movntdqa",
                    "sse41.mpsadbw" => "__builtin_ia32_mpsadbw128",
                    "sse41.packusdw" => "__builtin_ia32_packusdw128",
                    "sse41.pblendvb" => "__builtin_ia32_pblendvb128",
                    "sse41.pblendw" => "__builtin_ia32_pblendw128",
                    "sse41.phminposuw" => "__builtin_ia32_phminposuw128",
                    "sse41.pmaxsb" => "__builtin_ia32_pmaxsb128",
                    "sse41.pmaxsd" => "__builtin_ia32_pmaxsd128",
                    "sse41.pmaxud" => "__builtin_ia32_pmaxud128",
                    "sse41.pmaxuw" => "__builtin_ia32_pmaxuw128",
                    "sse41.pminsb" => "__builtin_ia32_pminsb128",
                    "sse41.pminsd" => "__builtin_ia32_pminsd128",
                    "sse41.pminud" => "__builtin_ia32_pminud128",
                    "sse41.pminuw" => "__builtin_ia32_pminuw128",
                    "sse41.pmovsxbd" => "__builtin_ia32_pmovsxbd128",
                    "sse41.pmovsxbq" => "__builtin_ia32_pmovsxbq128",
                    "sse41.pmovsxbw" => "__builtin_ia32_pmovsxbw128",
                    "sse41.pmovsxdq" => "__builtin_ia32_pmovsxdq128",
                    "sse41.pmovsxwd" => "__builtin_ia32_pmovsxwd128",
                    "sse41.pmovsxwq" => "__builtin_ia32_pmovsxwq128",
                    "sse41.pmovzxbd" => "__builtin_ia32_pmovzxbd128",
                    "sse41.pmovzxbq" => "__builtin_ia32_pmovzxbq128",
                    "sse41.pmovzxbw" => "__builtin_ia32_pmovzxbw128",
                    "sse41.pmovzxdq" => "__builtin_ia32_pmovzxdq128",
                    "sse41.pmovzxwd" => "__builtin_ia32_pmovzxwd128",
                    "sse41.pmovzxwq" => "__builtin_ia32_pmovzxwq128",
                    "sse41.pmuldq" => "__builtin_ia32_pmuldq128",
                    "sse41.ptestc" => "__builtin_ia32_ptestc128",
                    "sse41.ptestnzc" => "__builtin_ia32_ptestnzc128",
                    "sse41.ptestz" => "__builtin_ia32_ptestz128",
                    "sse41.round.pd" => "__builtin_ia32_roundpd",
                    "sse41.round.ps" => "__builtin_ia32_roundps",
                    "sse41.round.sd" => "__builtin_ia32_roundsd",
                    "sse41.round.ss" => "__builtin_ia32_roundss",
                    "sse42.crc32.32.16" => "__builtin_ia32_crc32hi",
                    "sse42.crc32.32.32" => "__builtin_ia32_crc32si",
                    "sse42.crc32.32.8" => "__builtin_ia32_crc32qi",
                    "sse42.crc32.64.64" => "__builtin_ia32_crc32di",
                    "sse42.pcmpestri128" => "__builtin_ia32_pcmpestri128",
                    "sse42.pcmpestria128" => "__builtin_ia32_pcmpestria128",
                    "sse42.pcmpestric128" => "__builtin_ia32_pcmpestric128",
                    "sse42.pcmpestrio128" => "__builtin_ia32_pcmpestrio128",
                    "sse42.pcmpestris128" => "__builtin_ia32_pcmpestris128",
                    "sse42.pcmpestriz128" => "__builtin_ia32_pcmpestriz128",
                    "sse42.pcmpestrm128" => "__builtin_ia32_pcmpestrm128",
                    "sse42.pcmpistri128" => "__builtin_ia32_pcmpistri128",
                    "sse42.pcmpistria128" => "__builtin_ia32_pcmpistria128",
                    "sse42.pcmpistric128" => "__builtin_ia32_pcmpistric128",
                    "sse42.pcmpistrio128" => "__builtin_ia32_pcmpistrio128",
                    "sse42.pcmpistris128" => "__builtin_ia32_pcmpistris128",
                    "sse42.pcmpistriz128" => "__builtin_ia32_pcmpistriz128",
                    "sse42.pcmpistrm128" => "__builtin_ia32_pcmpistrm128",
                    "sse4a.extrq" => "__builtin_ia32_extrq",
                    "sse4a.extrqi" => "__builtin_ia32_extrqi",
                    "sse4a.insertq" => "__builtin_ia32_insertq",
                    "sse4a.insertqi" => "__builtin_ia32_insertqi",
                    "sse4a.movnt.sd" => "__builtin_ia32_movntsd",
                    "sse4a.movnt.ss" => "__builtin_ia32_movntss",
                    "ssse3.pabs.b.128" => "__builtin_ia32_pabsb128",
                    "ssse3.pabs.d.128" => "__builtin_ia32_pabsd128",
                    "ssse3.pabs.w.128" => "__builtin_ia32_pabsw128",
                    "ssse3.phadd.d.128" => "__builtin_ia32_phaddd128",
                    "ssse3.phadd.sw.128" => "__builtin_ia32_phaddsw128",
                    "ssse3.phadd.w.128" => "__builtin_ia32_phaddw128",
                    "ssse3.phsub.d.128" => "__builtin_ia32_phsubd128",
                    "ssse3.phsub.sw.128" => "__builtin_ia32_phsubsw128",
                    "ssse3.phsub.w.128" => "__builtin_ia32_phsubw128",
                    "ssse3.pmadd.ub.sw.128" => "__builtin_ia32_pmaddubsw128",
                    "ssse3.pmul.hr.sw.128" => "__builtin_ia32_pmulhrsw128",
                    "ssse3.pshuf.b.128" => "__builtin_ia32_pshufb128",
                    "ssse3.psign.b.128" => "__builtin_ia32_psignb128",
                    "ssse3.psign.d.128" => "__builtin_ia32_psignd128",
                    "ssse3.psign.w.128" => "__builtin_ia32_psignw128",
                    "sttilecfg" => "__builtin_ia32_tile_storeconfig",
                    "stui" => "__builtin_ia32_stui",
                    "subborrow.u32" => "__builtin_ia32_subborrow_u32",
                    "subborrow.u64" => "__builtin_ia32_subborrow_u64",
                    "t2rpntlvwz0rs" => "__builtin_ia32_t2rpntlvwz0rs",
                    "t2rpntlvwz0rst1" => "__builtin_ia32_t2rpntlvwz0rst1",
                    "t2rpntlvwz1rs" => "__builtin_ia32_t2rpntlvwz1rs",
                    "t2rpntlvwz1rst1" => "__builtin_ia32_t2rpntlvwz1rst1",
                    "tbm.bextri.u32" => "__builtin_ia32_bextri_u32",
                    "tbm.bextri.u64" => "__builtin_ia32_bextri_u64",
                    "tcmmimfp16ps" => "__builtin_ia32_tcmmimfp16ps",
                    "tcmmimfp16ps.internal" => "__builtin_ia32_tcmmimfp16ps_internal",
                    "tcmmrlfp16ps" => "__builtin_ia32_tcmmrlfp16ps",
                    "tcmmrlfp16ps.internal" => "__builtin_ia32_tcmmrlfp16ps_internal",
                    "tcvtrowd2ps" => "__builtin_ia32_tcvtrowd2ps",
                    "tcvtrowd2ps.internal" => "__builtin_ia32_tcvtrowd2ps_internal",
                    "tcvtrowps2bf16h" => "__builtin_ia32_tcvtrowps2bf16h",
                    "tcvtrowps2bf16h.internal" => "__builtin_ia32_tcvtrowps2bf16h_internal",
                    "tcvtrowps2bf16l" => "__builtin_ia32_tcvtrowps2bf16l",
                    "tcvtrowps2bf16l.internal" => "__builtin_ia32_tcvtrowps2bf16l_internal",
                    "tcvtrowps2phh" => "__builtin_ia32_tcvtrowps2phh",
                    "tcvtrowps2phh.internal" => "__builtin_ia32_tcvtrowps2phh_internal",
                    "tcvtrowps2phl" => "__builtin_ia32_tcvtrowps2phl",
                    "tcvtrowps2phl.internal" => "__builtin_ia32_tcvtrowps2phl_internal",
                    "tdpbf16ps" => "__builtin_ia32_tdpbf16ps",
                    "tdpbf16ps.internal" => "__builtin_ia32_tdpbf16ps_internal",
                    "tdpbf8ps" => "__builtin_ia32_tdpbf8ps",
                    "tdpbf8ps.internal" => "__builtin_ia32_tdpbf8ps_internal",
                    "tdpbhf8ps" => "__builtin_ia32_tdpbhf8ps",
                    "tdpbhf8ps.internal" => "__builtin_ia32_tdpbhf8ps_internal",
                    "tdpbssd" => "__builtin_ia32_tdpbssd",
                    "tdpbssd.internal" => "__builtin_ia32_tdpbssd_internal",
                    "tdpbsud" => "__builtin_ia32_tdpbsud",
                    "tdpbsud.internal" => "__builtin_ia32_tdpbsud_internal",
                    "tdpbusd" => "__builtin_ia32_tdpbusd",
                    "tdpbusd.internal" => "__builtin_ia32_tdpbusd_internal",
                    "tdpbuud" => "__builtin_ia32_tdpbuud",
                    "tdpbuud.internal" => "__builtin_ia32_tdpbuud_internal",
                    "tdpfp16ps" => "__builtin_ia32_tdpfp16ps",
                    "tdpfp16ps.internal" => "__builtin_ia32_tdpfp16ps_internal",
                    "tdphbf8ps" => "__builtin_ia32_tdphbf8ps",
                    "tdphbf8ps.internal" => "__builtin_ia32_tdphbf8ps_internal",
                    "tdphf8ps" => "__builtin_ia32_tdphf8ps",
                    "tdphf8ps.internal" => "__builtin_ia32_tdphf8ps_internal",
                    "testui" => "__builtin_ia32_testui",
                    "tileloadd64" => "__builtin_ia32_tileloadd64",
                    "tileloadd64.internal" => "__builtin_ia32_tileloadd64_internal",
                    "tileloaddrs64" => "__builtin_ia32_tileloaddrs64",
                    "tileloaddrs64.internal" => "__builtin_ia32_tileloaddrs64_internal",
                    "tileloaddrst164" => "__builtin_ia32_tileloaddrst164",
                    "tileloaddrst164.internal" => "__builtin_ia32_tileloaddrst164_internal",
                    "tileloaddt164" => "__builtin_ia32_tileloaddt164",
                    "tileloaddt164.internal" => "__builtin_ia32_tileloaddt164_internal",
                    "tilemovrow" => "__builtin_ia32_tilemovrow",
                    "tilemovrow.internal" => "__builtin_ia32_tilemovrow_internal",
                    "tilerelease" => "__builtin_ia32_tilerelease",
                    "tilestored64" => "__builtin_ia32_tilestored64",
                    "tilestored64.internal" => "__builtin_ia32_tilestored64_internal",
                    "tilezero" => "__builtin_ia32_tilezero",
                    "tilezero.internal" => "__builtin_ia32_tilezero_internal",
                    "tmmultf32ps" => "__builtin_ia32_tmmultf32ps",
                    "tmmultf32ps.internal" => "__builtin_ia32_tmmultf32ps_internal",
                    "tpause" => "__builtin_ia32_tpause",
                    "umonitor" => "__builtin_ia32_umonitor",
                    "umwait" => "__builtin_ia32_umwait",
                    "urdmsr" => "__builtin_ia32_urdmsr",
                    "uwrmsr" => "__builtin_ia32_uwrmsr",
                    "vbcstnebf162ps128" => "__builtin_ia32_vbcstnebf162ps128",
                    "vbcstnebf162ps256" => "__builtin_ia32_vbcstnebf162ps256",
                    "vbcstnesh2ps128" => "__builtin_ia32_vbcstnesh2ps128",
                    "vbcstnesh2ps256" => "__builtin_ia32_vbcstnesh2ps256",
                    "vcvtneebf162ps128" => "__builtin_ia32_vcvtneebf162ps128",
                    "vcvtneebf162ps256" => "__builtin_ia32_vcvtneebf162ps256",
                    "vcvtneeph2ps128" => "__builtin_ia32_vcvtneeph2ps128",
                    "vcvtneeph2ps256" => "__builtin_ia32_vcvtneeph2ps256",
                    "vcvtneobf162ps128" => "__builtin_ia32_vcvtneobf162ps128",
                    "vcvtneobf162ps256" => "__builtin_ia32_vcvtneobf162ps256",
                    "vcvtneoph2ps128" => "__builtin_ia32_vcvtneoph2ps128",
                    "vcvtneoph2ps256" => "__builtin_ia32_vcvtneoph2ps256",
                    "vcvtneps2bf16128" => "__builtin_ia32_vcvtneps2bf16128",
                    "vcvtneps2bf16256" => "__builtin_ia32_vcvtneps2bf16256",
                    "vcvtph2ps.128" => "__builtin_ia32_vcvtph2ps",
                    "vcvtph2ps.256" => "__builtin_ia32_vcvtph2ps256",
                    "vcvtps2ph.128" => "__builtin_ia32_vcvtps2ph",
                    "vcvtps2ph.256" => "__builtin_ia32_vcvtps2ph256",
                    "vgf2p8affineinvqb.128" => "__builtin_ia32_vgf2p8affineinvqb_v16qi",
                    "vgf2p8affineinvqb.256" => "__builtin_ia32_vgf2p8affineinvqb_v32qi",
                    "vgf2p8affineinvqb.512" => "__builtin_ia32_vgf2p8affineinvqb_v64qi",
                    "vgf2p8affineqb.128" => "__builtin_ia32_vgf2p8affineqb_v16qi",
                    "vgf2p8affineqb.256" => "__builtin_ia32_vgf2p8affineqb_v32qi",
                    "vgf2p8affineqb.512" => "__builtin_ia32_vgf2p8affineqb_v64qi",
                    "vgf2p8mulb.128" => "__builtin_ia32_vgf2p8mulb_v16qi",
                    "vgf2p8mulb.256" => "__builtin_ia32_vgf2p8mulb_v32qi",
                    "vgf2p8mulb.512" => "__builtin_ia32_vgf2p8mulb_v64qi",
                    "vsha512msg1" => "__builtin_ia32_vsha512msg1",
                    "vsha512msg2" => "__builtin_ia32_vsha512msg2",
                    "vsha512rnds2" => "__builtin_ia32_vsha512rnds2",
                    "vsm3msg1" => "__builtin_ia32_vsm3msg1",
                    "vsm3msg2" => "__builtin_ia32_vsm3msg2",
                    "vsm3rnds2" => "__builtin_ia32_vsm3rnds2",
                    "vsm4key4128" => "__builtin_ia32_vsm4key4128",
                    "vsm4key4256" => "__builtin_ia32_vsm4key4256",
                    "vsm4key4512" => "__builtin_ia32_vsm4key4512",
                    "vsm4rnds4128" => "__builtin_ia32_vsm4rnds4128",
                    "vsm4rnds4256" => "__builtin_ia32_vsm4rnds4256",
                    "vsm4rnds4512" => "__builtin_ia32_vsm4rnds4512",
                    "wbinvd" => "__builtin_ia32_wbinvd",
                    "wbnoinvd" => "__builtin_ia32_wbnoinvd",
                    "wrfsbase.32" => "__builtin_ia32_wrfsbase32",
                    "wrfsbase.64" => "__builtin_ia32_wrfsbase64",
                    "wrgsbase.32" => "__builtin_ia32_wrgsbase32",
                    "wrgsbase.64" => "__builtin_ia32_wrgsbase64",
                    "wrpkru" => "__builtin_ia32_wrpkru",
                    "wrssd" => "__builtin_ia32_wrssd",
                    "wrssq" => "__builtin_ia32_wrssq",
                    "wrussd" => "__builtin_ia32_wrussd",
                    "wrussq" => "__builtin_ia32_wrussq",
                    "xabort" => "__builtin_ia32_xabort",
                    "xbegin" => "__builtin_ia32_xbegin",
                    "xend" => "__builtin_ia32_xend",
                    "xop.vfrcz.pd" => "__builtin_ia32_vfrczpd",
                    "xop.vfrcz.pd.256" => "__builtin_ia32_vfrczpd256",
                    "xop.vfrcz.ps" => "__builtin_ia32_vfrczps",
                    "xop.vfrcz.ps.256" => "__builtin_ia32_vfrczps256",
                    "xop.vfrcz.sd" => "__builtin_ia32_vfrczsd",
                    "xop.vfrcz.ss" => "__builtin_ia32_vfrczss",
                    "xop.vpcmov" => "__builtin_ia32_vpcmov",
                    "xop.vpcmov.256" => "__builtin_ia32_vpcmov_256",
                    "xop.vpcomb" => "__builtin_ia32_vpcomb",
                    "xop.vpcomd" => "__builtin_ia32_vpcomd",
                    "xop.vpcomq" => "__builtin_ia32_vpcomq",
                    "xop.vpcomub" => "__builtin_ia32_vpcomub",
                    "xop.vpcomud" => "__builtin_ia32_vpcomud",
                    "xop.vpcomuq" => "__builtin_ia32_vpcomuq",
                    "xop.vpcomuw" => "__builtin_ia32_vpcomuw",
                    "xop.vpcomw" => "__builtin_ia32_vpcomw",
                    "xop.vpermil2pd" => "__builtin_ia32_vpermil2pd",
                    "xop.vpermil2pd.256" => "__builtin_ia32_vpermil2pd256",
                    "xop.vpermil2ps" => "__builtin_ia32_vpermil2ps",
                    "xop.vpermil2ps.256" => "__builtin_ia32_vpermil2ps256",
                    "xop.vphaddbd" => "__builtin_ia32_vphaddbd",
                    "xop.vphaddbq" => "__builtin_ia32_vphaddbq",
                    "xop.vphaddbw" => "__builtin_ia32_vphaddbw",
                    "xop.vphadddq" => "__builtin_ia32_vphadddq",
                    "xop.vphaddubd" => "__builtin_ia32_vphaddubd",
                    "xop.vphaddubq" => "__builtin_ia32_vphaddubq",
                    "xop.vphaddubw" => "__builtin_ia32_vphaddubw",
                    "xop.vphaddudq" => "__builtin_ia32_vphaddudq",
                    "xop.vphadduwd" => "__builtin_ia32_vphadduwd",
                    "xop.vphadduwq" => "__builtin_ia32_vphadduwq",
                    "xop.vphaddwd" => "__builtin_ia32_vphaddwd",
                    "xop.vphaddwq" => "__builtin_ia32_vphaddwq",
                    "xop.vphsubbw" => "__builtin_ia32_vphsubbw",
                    "xop.vphsubdq" => "__builtin_ia32_vphsubdq",
                    "xop.vphsubwd" => "__builtin_ia32_vphsubwd",
                    "xop.vpmacsdd" => "__builtin_ia32_vpmacsdd",
                    "xop.vpmacsdqh" => "__builtin_ia32_vpmacsdqh",
                    "xop.vpmacsdql" => "__builtin_ia32_vpmacsdql",
                    "xop.vpmacssdd" => "__builtin_ia32_vpmacssdd",
                    "xop.vpmacssdqh" => "__builtin_ia32_vpmacssdqh",
                    "xop.vpmacssdql" => "__builtin_ia32_vpmacssdql",
                    "xop.vpmacsswd" => "__builtin_ia32_vpmacsswd",
                    "xop.vpmacssww" => "__builtin_ia32_vpmacssww",
                    "xop.vpmacswd" => "__builtin_ia32_vpmacswd",
                    "xop.vpmacsww" => "__builtin_ia32_vpmacsww",
                    "xop.vpmadcsswd" => "__builtin_ia32_vpmadcsswd",
                    "xop.vpmadcswd" => "__builtin_ia32_vpmadcswd",
                    "xop.vpperm" => "__builtin_ia32_vpperm",
                    "xop.vprotb" => "__builtin_ia32_vprotb",
                    "xop.vprotbi" => "__builtin_ia32_vprotbi",
                    "xop.vprotd" => "__builtin_ia32_vprotd",
                    "xop.vprotdi" => "__builtin_ia32_vprotdi",
                    "xop.vprotq" => "__builtin_ia32_vprotq",
                    "xop.vprotqi" => "__builtin_ia32_vprotqi",
                    "xop.vprotw" => "__builtin_ia32_vprotw",
                    "xop.vprotwi" => "__builtin_ia32_vprotwi",
                    "xop.vpshab" => "__builtin_ia32_vpshab",
                    "xop.vpshad" => "__builtin_ia32_vpshad",
                    "xop.vpshaq" => "__builtin_ia32_vpshaq",
                    "xop.vpshaw" => "__builtin_ia32_vpshaw",
                    "xop.vpshlb" => "__builtin_ia32_vpshlb",
                    "xop.vpshld" => "__builtin_ia32_vpshld",
                    "xop.vpshlq" => "__builtin_ia32_vpshlq",
                    "xop.vpshlw" => "__builtin_ia32_vpshlw",
                    "xresldtrk" => "__builtin_ia32_xresldtrk",
                    "xsusldtrk" => "__builtin_ia32_xsusldtrk",
                    "xtest" => "__builtin_ia32_xtest",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            x86(name, full_name)
        }
        "xcore" => {
            fn xcore(name: &str, full_name: &str) -> &'static str {
                match name {
                    // xcore
                    "bitrev" => "__builtin_bitrev",
                    "getid" => "__builtin_getid",
                    "getps" => "__builtin_getps",
                    "setps" => "__builtin_setps",
                    _ => unimplemented!("***** unsupported LLVM intrinsic {full_name}"),
                }
            }
            xcore(name, full_name)
        }
        _ => unimplemented!("***** unsupported LLVM architecture {arch}, intrinsic:{full_name}"),
    }
}
