// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) TypeSpec Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

#pragma once

#include "certificates_models.hpp"
#include "key_vault_client_options.hpp"
#include "key_vault_client_paged_responses.hpp"

#include <azure/core/context.hpp>
#include <azure/core/credentials/credentials.hpp>
#include <azure/core/datetime.hpp>
#include <azure/core/internal/extendable_enumeration.hpp>
#include <azure/core/internal/http/pipeline.hpp>
#include <azure/core/nullable.hpp>
#include <azure/core/paged_response.hpp>
#include <azure/core/response.hpp>
#include <azure/core/url.hpp>

#include <cstdint>
#include <map>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace Azure { namespace Security { namespace KeyVault { namespace Certificates {
  namespace _detail {
    /**
     * @brief The key vault client performs cryptographic key operations and vault operations
     * against the Key Vault service.
     *
     */
    class KeyVaultClient final {
    public:
      /**
       * @brief Constructs the KeyVaultClient.
       * @param url The URL address where the client will send the requests to.
       * @param credential Credential to authenticate with the service.
       * @param options Optional parameters.
       *
       */
      explicit KeyVaultClient(
          const std::string& url,
          const std::shared_ptr<const Core::Credentials::TokenCredential>& credential,
          const KeyVaultClientOptions& options = {});

      /**
       * @brief Gets the KeyVaultClient URL endpoint.
       * @return The KeyVaultClient's URL endpoint.
       *
       */
      std::string GetUrl() const;

      /**
       * @brief The GetCertificates operation returns the set of certificates resources in the
       * specified key vault. This operation requires the certificates/list permission.
       * @param options Optional parameters.
       * @param context The context for the operation can be used for request cancellation.
       * @return The certificate list result.
       *
       */
      GetCertificatesPagedResponse GetCertificates(
          const KeyVaultClientGetCertificatesOptions& options = {},
          const Core::Context& context = {}) const;

      /**
       * @brief Deletes all versions of a certificate object along with its associated policy.
       * Delete certificate cannot be used to remove individual versions of a certificate object.
       * This operation requires the certificates/delete permission.
       * @param certificateName The name of the certificate.
       * @param context The context for the operation can be used for request cancellation.
       * @return A Deleted Certificate consisting of its previous id, attributes and its tags, as
       * well as information on when it will be purged.
       *
       */
      Response<Models::DeletedCertificateBundle> DeleteCertificate(
          const std::string& certificateName,
          const Core::Context& context = {}) const;

      /**
       * @brief Sets the certificate contacts for the specified key vault. This operation requires
       * the certificates/managecontacts permission.
       * @param contacts The contacts for the key vault certificate.
       * @param context The context for the operation can be used for request cancellation.
       * @return The contacts for the vault certificates.
       *
       */
      Response<Models::Contacts> SetCertificateContacts(
          const Models::Contacts& contacts,
          const Core::Context& context = {}) const;

      /**
       * @brief The GetCertificateContacts operation returns the set of certificate contact
       * resources in the specified key vault. This operation requires the
       * certificates/managecontacts permission.
       * @param context The context for the operation can be used for request cancellation.
       * @return The contacts for the vault certificates.
       *
       */
      Response<Models::Contacts> GetCertificateContacts(const Core::Context& context = {}) const;

      /**
       * @brief Deletes the certificate contacts for a specified key vault certificate. This
       * operation requires the certificates/managecontacts permission.
       * @param context The context for the operation can be used for request cancellation.
       * @return The contacts for the vault certificates.
       *
       */
      Response<Models::Contacts> DeleteCertificateContacts(const Core::Context& context = {}) const;

      /**
       * @brief The GetCertificateIssuers operation returns the set of certificate issuer resources
       * in the specified key vault. This operation requires the
       * certificates/manageissuers/getissuers permission.
       * @param options Optional parameters.
       * @param context The context for the operation can be used for request cancellation.
       * @return The certificate issuer list result.
       *
       */
      GetCertificateIssuersPagedResponse GetCertificateIssuers(
          const KeyVaultClientGetCertificateIssuersOptions& options = {},
          const Core::Context& context = {}) const;

      /**
       * @brief The SetCertificateIssuer operation adds or updates the specified certificate issuer.
       * This operation requires the certificates/setissuers permission.
       * @param issuerName The name of the issuer. The value you provide may be copied globally for
       * the purpose of running the service. The value provided should not include personally
       * identifiable or sensitive information.
       * @param parameter Certificate issuer set parameter.
       * @param context The context for the operation can be used for request cancellation.
       * @return The issuer for Key Vault certificate.
       *
       */
      Response<Models::IssuerBundle> SetCertificateIssuer(
          const std::string& issuerName,
          const Models::CertificateIssuerSetParameters& parameter,
          const Core::Context& context = {}) const;

      /**
       * @brief The UpdateCertificateIssuer operation performs an update on the specified
       * certificate issuer entity. This operation requires the certificates/setissuers permission.
       * @param issuerName The name of the issuer.
       * @param parameter Certificate issuer update parameter.
       * @param context The context for the operation can be used for request cancellation.
       * @return The issuer for Key Vault certificate.
       *
       */
      Response<Models::IssuerBundle> UpdateCertificateIssuer(
          const std::string& issuerName,
          const Models::CertificateIssuerUpdateParameters& parameter,
          const Core::Context& context = {}) const;

      /**
       * @brief The GetCertificateIssuer operation returns the specified certificate issuer
       * resources in the specified key vault. This operation requires the
       * certificates/manageissuers/getissuers permission.
       * @param issuerName The name of the issuer.
       * @param context The context for the operation can be used for request cancellation.
       * @return The issuer for Key Vault certificate.
       *
       */
      Response<Models::IssuerBundle> GetCertificateIssuer(
          const std::string& issuerName,
          const Core::Context& context = {}) const;

      /**
       * @brief The DeleteCertificateIssuer operation permanently removes the specified certificate
       * issuer from the vault. This operation requires the certificates/manageissuers/deleteissuers
       * permission.
       * @param issuerName The name of the issuer.
       * @param context The context for the operation can be used for request cancellation.
       * @return The issuer for Key Vault certificate.
       *
       */
      Response<Models::IssuerBundle> DeleteCertificateIssuer(
          const std::string& issuerName,
          const Core::Context& context = {}) const;

      /**
       * @brief If this is the first version, the certificate resource is created. This operation
       * requires the certificates/create permission.
       * @param certificateName The name of the certificate. The value you provide may be copied
       * globally for the purpose of running the service. The value provided should not include
       * personally identifiable or sensitive information.
       * @param parameters The parameters to create a certificate.
       * @param context The context for the operation can be used for request cancellation.
       * @return A certificate operation is returned in case of asynchronous requests.
       *
       */
      Response<Models::CertificateOperation> CreateCertificate(
          const std::string& certificateName,
          const Models::CertificateCreateParameters& parameters,
          const Core::Context& context = {}) const;

      /**
       * @brief Imports an existing valid certificate, containing a private key, into Azure Key
       * Vault. This operation requires the certificates/import permission. The certificate to be
       * imported can be in either PFX or PEM format. If the certificate is in PEM format the PEM
       * file must contain the key as well as x509 certificates. Key Vault will only accept a key in
       * PKCS#8 format.
       * @param certificateName The name of the certificate. The value you provide may be copied
       * globally for the purpose of running the service. The value provided should not include
       * personally identifiable or sensitive information.
       * @param parameters The parameters to import the certificate.
       * @param context The context for the operation can be used for request cancellation.
       * @return A certificate bundle consists of a certificate (X509) plus its attributes.
       *
       */
      Response<Models::CertificateBundle> ImportCertificate(
          const std::string& certificateName,
          const Models::CertificateImportParameters& parameters,
          const Core::Context& context = {}) const;

      /**
       * @brief The GetCertificateVersions operation returns the versions of a certificate in the
       * specified key vault. This operation requires the certificates/list permission.
       * @param certificateName The name of the certificate.
       * @param options Optional parameters.
       * @param context The context for the operation can be used for request cancellation.
       * @return The certificate list result.
       *
       */
      GetCertificateVersionsPagedResponse GetCertificateVersions(
          const std::string& certificateName,
          const KeyVaultClientGetCertificateVersionsOptions& options = {},
          const Core::Context& context = {}) const;

      /**
       * @brief The GetCertificatePolicy operation returns the specified certificate policy
       * resources in the specified key vault. This operation requires the certificates/get
       * permission.
       * @param certificateName The name of the certificate in a given key vault.
       * @param context The context for the operation can be used for request cancellation.
       * @return Management policy for a certificate.
       *
       */
      Response<Models::CertificatePolicy> GetCertificatePolicy(
          const std::string& certificateName,
          const Core::Context& context = {}) const;

      /**
       * @brief Set specified members in the certificate policy. Leave others as null. This
       * operation requires the certificates/update permission.
       * @param certificateName The name of the certificate in the given vault.
       * @param certificatePolicy The policy for the certificate.
       * @param context The context for the operation can be used for request cancellation.
       * @return Management policy for a certificate.
       *
       */
      Response<Models::CertificatePolicy> UpdateCertificatePolicy(
          const std::string& certificateName,
          const Models::CertificatePolicy& certificatePolicy,
          const Core::Context& context = {}) const;

      /**
       * @brief The UpdateCertificate operation applies the specified update on the given
       * certificate; the only elements updated are the certificate's attributes. This operation
       * requires the certificates/update permission.
       * @param certificateName The name of the certificate in the given key vault.
       * @param certificateVersion The version of the certificate.
       * @param parameters The parameters for certificate update.
       * @param context The context for the operation can be used for request cancellation.
       * @return A certificate bundle consists of a certificate (X509) plus its attributes.
       *
       */
      Response<Models::CertificateBundle> UpdateCertificate(
          const std::string& certificateName,
          const std::string& certificateVersion,
          const Models::CertificateUpdateParameters& parameters,
          const Core::Context& context = {}) const;

      /**
       * @brief Gets information about a specific certificate. This operation requires the
       * certificates/get permission.
       * @param certificateName The name of the certificate in the given vault.
       * @param certificateVersion The version of the certificate. This URI fragment is optional. If
       * not specified, the latest version of the certificate is returned.
       * @param context The context for the operation can be used for request cancellation.
       * @return A certificate bundle consists of a certificate (X509) plus its attributes.
       *
       */
      Response<Models::CertificateBundle> GetCertificate(
          const std::string& certificateName,
          const std::string& certificateVersion,
          const Core::Context& context = {}) const;

      /**
       * @brief Updates a certificate creation operation that is already in progress. This operation
       * requires the certificates/update permission.
       * @param certificateName The name of the certificate.
       * @param certificateOperation The certificate operation response.
       * @param context The context for the operation can be used for request cancellation.
       * @return A certificate operation is returned in case of asynchronous requests.
       *
       */
      Response<Models::CertificateOperation> UpdateCertificateOperation(
          const std::string& certificateName,
          const Models::CertificateOperationUpdateParameter& certificateOperation,
          const Core::Context& context = {}) const;

      /**
       * @brief Gets the creation operation associated with a specified certificate. This operation
       * requires the certificates/get permission.
       * @param certificateName The name of the certificate.
       * @param context The context for the operation can be used for request cancellation.
       * @return A certificate operation is returned in case of asynchronous requests.
       *
       */
      Response<Models::CertificateOperation> GetCertificateOperation(
          const std::string& certificateName,
          const Core::Context& context = {}) const;

      /**
       * @brief Deletes the creation operation for a specified certificate that is in the process of
       * being created. The certificate is no longer created. This operation requires the
       * certificates/update permission.
       * @param certificateName The name of the certificate.
       * @param context The context for the operation can be used for request cancellation.
       * @return A certificate operation is returned in case of asynchronous requests.
       *
       */
      Response<Models::CertificateOperation> DeleteCertificateOperation(
          const std::string& certificateName,
          const Core::Context& context = {}) const;

      /**
       * @brief The MergeCertificate operation performs the merging of a certificate or certificate
       * chain with a key pair currently available in the service. This operation requires the
       * certificates/create permission.
       * @param certificateName The name of the certificate.
       * @param parameters The parameters to merge certificate.
       * @param context The context for the operation can be used for request cancellation.
       * @return A certificate bundle consists of a certificate (X509) plus its attributes.
       *
       */
      Response<Models::CertificateBundle> MergeCertificate(
          const std::string& certificateName,
          const Models::CertificateMergeParameters& parameters,
          const Core::Context& context = {}) const;

      /**
       * @brief Requests that a backup of the specified certificate be downloaded to the client. All
       * versions of the certificate will be downloaded. This operation requires the
       * certificates/backup permission.
       * @param certificateName The name of the certificate.
       * @param context The context for the operation can be used for request cancellation.
       * @return The backup certificate result, containing the backup blob.
       *
       */
      Response<Models::BackupCertificateResult> BackupCertificate(
          const std::string& certificateName,
          const Core::Context& context = {}) const;

      /**
       * @brief Restores a backed up certificate, and all its versions, to a vault. This operation
       * requires the certificates/restore permission.
       * @param parameters The parameters to restore the certificate.
       * @param context The context for the operation can be used for request cancellation.
       * @return A certificate bundle consists of a certificate (X509) plus its attributes.
       *
       */
      Response<Models::CertificateBundle> RestoreCertificate(
          const Models::CertificateRestoreParameters& parameters,
          const Core::Context& context = {}) const;

      /**
       * @brief The GetDeletedCertificates operation retrieves the certificates in the current vault
       * which are in a deleted state and ready for recovery or purging. This operation includes
       * deletion-specific information. This operation requires the certificates/get/list
       * permission. This operation can only be enabled on soft-delete enabled vaults.
       * @param options Optional parameters.
       * @param context The context for the operation can be used for request cancellation.
       * @return A list of certificates that have been deleted in this vault.
       *
       */
      GetDeletedCertificatesPagedResponse GetDeletedCertificates(
          const KeyVaultClientGetDeletedCertificatesOptions& options = {},
          const Core::Context& context = {}) const;

      /**
       * @brief The GetDeletedCertificate operation retrieves the deleted certificate information
       * plus its attributes, such as retention interval, scheduled permanent deletion and the
       * current deletion recovery level. This operation requires the certificates/get permission.
       * @param certificateName The name of the certificate
       * @param context The context for the operation can be used for request cancellation.
       * @return A Deleted Certificate consisting of its previous id, attributes and its tags, as
       * well as information on when it will be purged.
       *
       */
      Response<Models::DeletedCertificateBundle> GetDeletedCertificate(
          const std::string& certificateName,
          const Core::Context& context = {}) const;

      /**
       * @brief The PurgeDeletedCertificate operation performs an irreversible deletion of the
       * specified certificate, without possibility for recovery. The operation is not available if
       * the recovery level does not specify 'Purgeable'. This operation requires the
       * certificate/purge permission.
       * @param certificateName The name of the certificate
       * @param context The context for the operation can be used for request cancellation.
       * @return Operation result.
       *
       */
      Response<Models::PurgeDeletedCertificateResult> PurgeDeletedCertificate(
          const std::string& certificateName,
          const Core::Context& context = {}) const;

      /**
       * @brief The RecoverDeletedCertificate operation performs the reversal of the Delete
       * operation. The operation is applicable in vaults enabled for soft-delete, and must be
       * issued during the retention interval (available in the deleted certificate's attributes).
       * This operation requires the certificates/recover permission.
       * @param certificateName The name of the deleted certificate
       * @param context The context for the operation can be used for request cancellation.
       * @return A certificate bundle consists of a certificate (X509) plus its attributes.
       *
       */
      Response<Models::CertificateBundle> RecoverDeletedCertificate(
          const std::string& certificateName,
          const Core::Context& context = {}) const;

    private:
      std::shared_ptr<Core::Http::_internal::HttpPipeline> m_pipeline;
      Core::Url m_url;
      std::string m_apiVersion;
    };
}}}}} // namespace Azure::Security::KeyVault::Certificates::_detail
