/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ckb extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "\u0641\u06cc\u062c\u06cc";
        final String metaValue_NR = "\u0646\u0627\u0626\u0648\u0631\u0648\u0648";
        final String metaValue_TV = "\u062a\u0648\u0648\u06a4\u0627\u0644\u0648\u0648";
        final String metaValue_ar = "\u0639\u06d5\u0631\u06d5\u0628\u06cc";
        final String metaValue_hy = "\u0626\u06d5\u0631\u0645\u06d5\u0646\u06cc";
        final String metaValue_el = "\u06cc\u06c6\u0646\u0627\u0646\u06cc";
        final String metaValue_he = "\u0639\u06cc\u0628\u0631\u06cc";
        final String metaValue_ja = "\u0698\u0627\u067e\u06c6\u0646\u06cc";
        final String metaValue_km = "\u062e\u0645\u06ce\u0631";
        final String metaValue_kn = "\u06a9\u0627\u0646\u0646\u0627\u062f\u0627";
        final String metaValue_la = "\u0644\u0627\u062a\u06cc\u0646\u06cc";
        final String metaValue_ml = "\u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0627\u0645";
        final String metaValue_mn = "\u0645\u06d5\u0646\u06af\u06c6\u0644\u06cc";
        final String metaValue_MM = "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631";
        final String metaValue_or = "\u0626\u06c6\u062f\u06cc\u0627";
        final String metaValue_ta = "\u062a\u0627\u0645\u06cc\u0644\u06cc";
        final String metaValue_te = "\u062a\u06ce\u0644\u0648\u0648\u06af\u0648\u0648";
        final String metaValue_th = "\u062a\u0627\u06cc\u0644\u06d5\u0646\u062f\u06cc";
        final String metaValue_bo = "\u062a\u06d5\u0628\u06d5\u062a\u06cc";
        final Object[][] data = new Object[][] {
            { "001", "\u062c\u06cc\u0647\u0627\u0646" },
            { "002", "\u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "003", "\u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "005", "\u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "009", "\u0626\u06c6\u0642\u06cc\u0627\u0646\u0648\u0648\u0633\u06cc\u0627" },
            { "011", "\u0695\u06c6\u0698\u0627\u0648\u0627\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "013", "\u0626\u06d5\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0646\u0627\u0648\u06d5\u0695\u0627\u0633\u062a" },
            { "014", "\u0695\u06c6\u0698\u06be\u06d5\u06b5\u0627\u062a\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "015", "\u0628\u0627\u06a9\u0648\u0648\u0631\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "017", "\u0646\u0627\u0648\u06d5\u0695\u0627\u0633\u062a\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "018", "\u0628\u0627\u0634\u0648\u0648\u0631\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627" },
            { "019", "\u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631 \u0648 \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "021", "\u0626\u06d5\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "029", "\u06a9\u0627\u0631\u06cc\u0628\u06cc" },
            { "030", "\u0695\u06c6\u0698\u0647\u06d5\u06b5\u0627\u062a\u06cc \u0626\u0627\u0633\u06cc\u0627" },
            { "034", "\u0628\u0627\u0634\u0648\u0648\u0631\u06cc \u0626\u0627\u0633\u06cc\u0627" },
            { "035", "\u0628\u0627\u0634\u0648\u0648\u0631\u06cc \u0695\u06c6\u0698\u06be\u06d5\u06b5\u0627\u062a\u06cc \u0626\u0627\u0633\u06cc\u0627" },
            { "039", "\u0628\u0627\u0634\u0648\u0648\u0631\u06cc \u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "053", "\u0626\u06c6\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "054", "\u0645\u06cc\u0644\u0627\u0646\u06ce\u0632\u06cc\u0627" },
            { "057", "\u0646\u0627\u0648\u0686\u06d5\u06cc \u0645\u0627\u06cc\u06a9\u0631\u06c6\u0646\u06cc\u0632\u06cc\u0627" },
            { "061", "\u067e\u06c6\u0644\u06cc\u0646\u06cc\u0632\u06cc\u0627" },
            { "142", "\u0626\u0627\u0633\u06cc\u0627" },
            { "143", "\u0646\u0627\u0648\u06d5\u0695\u0627\u0633\u062a\u06cc \u0626\u0627\u0633\u06cc\u0627" },
            { "145", "\u0695\u06c6\u0698\u0627\u0648\u0627\u06cc \u0626\u0627\u0633\u06cc\u0627" },
            { "150", "\u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "151", "\u0695\u06c6\u0698\u0647\u06d5\u06b5\u0627\u062a\u06cc \u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "154", "\u0628\u0627\u06a9\u0648\u0648\u0631\u06cc \u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "155", "\u0695\u06c6\u0698\u0627\u0648\u0627\u06cc \u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "202", "\u0626\u06d5\u0641\u0631\u06cc\u0642\u0627\u06cc \u0698\u06ce\u0631 \u0633\u06d5\u062d\u0631\u0627" },
            { "419", "\u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc \u0644\u0627\u062a\u06cc\u0646" },
            { "AC", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u0626\u0627\u0633\u06cc\u0646\u0633\u06cc\u06c6\u0646" },
            { "AD", "\u0626\u0627\u0646\u062f\u06c6\u0631\u0627" },
            { "AE", "\u0645\u06cc\u0631\u0646\u0634\u06cc\u0646\u06d5 \u06cc\u06d5\u06a9\u06af\u0631\u062a\u0648\u0648\u06d5 \u0639\u06d5\u0631\u06d5\u0628\u06cc\u06cc\u06d5\u06a9\u0627\u0646" },
            { "AF", "\u0626\u06d5\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "AG", "\u0626\u0627\u0646\u062a\u06cc\u06af\u0648\u0627 \u0648 \u0628\u0627\u0631\u0628\u0648\u062f\u0627" },
            { "AI", "\u0626\u0627\u0646\u06af\u0648\u06cc\u0644\u0627" },
            { "AL", "\u0626\u06d5\u06b5\u0628\u0627\u0646\u06cc\u0627" },
            { "AM", "\u0626\u06d5\u0631\u0645\u06d5\u0646\u0633\u062a\u0627\u0646" },
            { "AO", "\u0626\u06d5\u0646\u06af\u06c6\u0644\u0627" },
            { "AQ", "\u0626\u0627\u0646\u062a\u0627\u0631\u06a9\u062a\u06cc\u06a9\u0627" },
            { "AR", "\u0626\u06d5\u0631\u0698\u06d5\u0646\u062a\u06cc\u0646" },
            { "AS", "\u0633\u0627\u0645\u0648\u0627\u06cc \u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc\u06cc" },
            { "AT", "\u0646\u06d5\u0645\u0633\u0627" },
            { "AU", "\u0626\u0648\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "AW", "\u0626\u0627\u0631\u0648\u0648\u0628\u0627" },
            { "AX", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0626\u0627\u0644\u0627\u0646\u062f" },
            { "AZ", "\u0626\u0627\u0632\u06d5\u0631\u0628\u0627\u06cc\u062c\u0627\u0646" },
            { "BA", "\u0628\u06c6\u0633\u0646\u06cc\u0627 \u0648 \u06be\u06d5\u0631\u0632\u06d5\u06af\u06c6\u06a4\u06cc\u0646\u0627" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u062f\u06c6\u0633" },
            { "BD", "\u0628\u06d5\u0646\u06af\u0644\u0627\u062f\u06cc\u0634" },
            { "BE", "\u0628\u06d5\u0644\u0698\u06cc\u06a9" },
            { "BF", "\u0628\u0648\u0631\u06a9\u06cc\u0646\u0627\u0641\u0627\u0633\u06c6" },
            { "BG", "\u0628\u0648\u0644\u06af\u0627\u0631\u06cc\u0627" },
            { "BH", "\u0628\u06d5\u062d\u0631\u06d5\u06cc\u0646" },
            { "BI", "\u0628\u0648\u0631\u0648\u0646\u062f\u06cc" },
            { "BJ", "\u0628\u06ce\u0646\u06cc\u0646" },
            { "BL", "\u0633\u06d5\u0646 \u0628\u0627\u0631\u062a\u06ce\u0644\u06ce\u0645\u06cc" },
            { "BM", "\u0628\u06ce\u0631\u0645\u0648\u0648\u062f\u0627" },
            { "BN", "\u0628\u0631\u0648\u0648\u0646\u0627\u06cc" },
            { "BO", "\u0628\u06c6\u0644\u06cc\u06a4\u06cc\u0627" },
            { "BQ", "\u062f\u0648\u0648\u0631\u06af\u06d5 \u06a9\u0627\u0631\u06cc\u0628\u06cc\u06d5\u06a9\u0627\u0646\u06cc \u0647\u06c6\u06b5\u06d5\u0646\u062f\u0627" },
            { "BR", "\u0628\u0631\u0627\u0632\u06cc\u0644" },
            { "BS", "\u0628\u06d5\u06be\u0627\u0645\u0627" },
            { "BT", "\u0628\u0648\u0648\u062a\u0627\u0646" },
            { "BV", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u0628\u0648\u0648\u06a4\u06ce" },
            { "BW", "\u0628\u06c6\u062a\u0633\u0648\u0627\u0646\u0627" },
            { "BY", "\u0628\u06cc\u0644\u0627\u0695\u0648\u0648\u0633" },
            { "BZ", "\u0628\u06d5\u0644\u06cc\u0632" },
            { "CA", "\u06a9\u06d5\u0646\u06d5\u062f\u0627" },
            { "CC", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a9\u06cc\u0644\u06cc\u0646\u06af" },
            { "CD", "\u06a9\u06c6\u0646\u06af\u06c6 \u06a9\u06cc\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u06a9\u06c6\u0645\u0627\u0631\u06cc \u0626\u06d5\u0641\u0631\u06cc\u0642\u0627\u06cc \u0646\u0627\u0648\u06d5\u0695\u0627\u0633\u062a" },
            { "CG", "\u06a9\u06c6\u0646\u06af\u06c6 \u0628\u0631\u0627\u0632\u0627\u06a4\u06cc\u0644" },
            { "CH", "\u0633\u0648\u06cc\u0633\u0695\u0627" },
            { "CI", "\u06a9\u06c6\u062a\u062f\u06cc\u06a4\u0648\u0627\u0631" },
            { "CK", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a9\u0648\u06a9" },
            { "CL", "\u0686\u06cc\u0644\u06cc" },
            { "CM", "\u06a9\u0627\u0645\u06cc\u0631\u06c6\u0646" },
            { "CN", "\u0686\u06cc\u0646" },
            { "CO", "\u06a9\u06c6\u0644\u06c6\u0645\u0628\u06cc\u0627" },
            { "CP", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u06a9\u0644\u06cc\u067e\u06ce\u0631\u062a\u06c6\u0646" },
            { "CR", "\u06a9\u06c6\u0633\u062a\u0627\u0631\u06cc\u06a9\u0627" },
            { "CU", "\u06a9\u0648\u0648\u0628\u0627" },
            { "CV", "\u06a9\u06d5\u06cc\u067e\u06a4\u06d5\u0631\u062f" },
            { "CW", "\u06a9\u0648\u0631\u0627\u0686\u0627\u0648" },
            { "CX", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u06a9\u0631\u06cc\u0633\u0645\u0633" },
            { "CY", "\u0642\u06cc\u0628\u0631\u0633" },
            { "CZ", "\u06a9\u06c6\u0645\u0627\u0631\u06cc \u0686\u06cc\u06a9" },
            { "DE", "\u0626\u06d5\u06b5\u0645\u0627\u0646\u06cc\u0627" },
            { "DG", "\u062f\u06cc\u06d5\u06af\u06c6 \u06af\u0627\u0631\u0633\u06cc\u0627" },
            { "DJ", "\u062c\u06cc\u0628\u0648\u0648\u062a\u06cc" },
            { "DK", "\u062f\u0627\u0646\u0645\u0627\u0631\u06a9" },
            { "DM", "\u062f\u06c6\u0645\u06cc\u0646\u06cc\u06a9\u0627" },
            { "DO", "\u06a9\u06c6\u0645\u0627\u0631\u06cc \u062f\u06c6\u0645\u06cc\u0646\u06cc\u06a9\u0627" },
            { "DZ", "\u062c\u06d5\u0632\u0627\u06cc\u0631" },
            { "EA", "\u0633\u06ce\u0626\u0648\u0648\u062a\u0627 \u0648 \u0645\u06ce\u0644\u06cc\u06cc\u0627" },
            { "EC", "\u0626\u06cc\u06a9\u0648\u0627\u062f\u06c6\u0631" },
            { "EE", "\u0626\u06cc\u0633\u062a\u06c6\u0646\u06cc\u0627" },
            { "EG", "\u0645\u06cc\u0633\u0631" },
            { "EH", "\u0633\u06d5\u062d\u0631\u0627\u06cc \u0695\u06c6\u0698\u0627\u0648\u0627" },
            { "ER", "\u0626\u06d5\u0631\u06cc\u062a\u0631\u06cc\u0627" },
            { "ES", "\u0626\u06cc\u0633\u067e\u0627\u0646\u06cc\u0627" },
            { "ET", "\u0626\u06d5\u062a\u06cc\u06c6\u067e\u06cc\u0627" },
            { "EU", "\u06cc\u06d5\u06a9\u06ce\u062a\u06cc\u06cc \u0626\u06d5\u0648\u0631\u0648\u0648\u067e\u0627" },
            { "EZ", "\u0646\u0627\u0648\u0686\u06d5\u06cc \u06cc\u06c6\u0631\u06c6" },
            { "FI", "\u0641\u06cc\u0646\u0644\u0627\u0646\u062f" },
            { "FJ", metaValue_FJ },
            { "FK", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0645\u0627\u0644\u06a4\u06cc\u0646\u0627\u0633 (\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0641\u0627\u06b5\u06a9\u0644\u0627\u0646\u062f)" },
            { "FM", "\u0645\u0627\u06cc\u06a9\u0631\u06c6\u0646\u06cc\u0632\u06cc\u0627" },
            { "FO", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0641\u0627\u0631\u06d5\u0648" },
            { "FR", "\u0641\u06d5\u0695\u06d5\u0646\u0633\u0627" },
            { "GA", "\u06af\u0627\u0628\u06c6\u0646" },
            { "GB", "\u0634\u0627\u0646\u0634\u06cc\u0646\u06cc \u06cc\u06d5\u06a9\u06af\u0631\u062a\u0648\u0648" },
            { "GD", "\u06af\u0631\u06cc\u0646\u0627\u062f\u0627" },
            { "GE", "\u06af\u0648\u0631\u062c\u0633\u062a\u0627\u0646" },
            { "GF", "\u06af\u06cc\u0627\u0646\u0627\u06cc \u0641\u06d5\u0631\u06d5\u0646\u0633\u0627" },
            { "GG", "\u06af\u06ce\u0631\u0646\u0632\u06cc" },
            { "GH", "\u063a\u06d5\u0646\u0627" },
            { "GI", "\u06af\u06cc\u0628\u0631\u0627\u0644\u062a\u0627\u0631" },
            { "GL", "\u06af\u0631\u06cc\u0646\u0644\u0627\u0646\u062f" },
            { "GM", "\u06af\u0627\u0645\u0628\u06cc\u0627" },
            { "GN", "\u06af\u06cc\u0646\u06ce" },
            { "GP", "\u06af\u0648\u0627\u062f\u06ce\u0644\u06c6\u067e" },
            { "GQ", "\u06af\u06cc\u0646\u06ce\u06cc \u0626\u06cc\u0633\u062a\u0648\u0627\u06cc\u06cc" },
            { "GR", "\u06cc\u06c6\u0646\u0627\u0646" },
            { "GS", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u062c\u06c6\u0631\u062c\u06cc\u0627 \u0648 \u0633\u0627\u0646\u062f\u0648\u06cc\u0686\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "GT", "\u06af\u0648\u0627\u062a\u06cc\u0645\u0627\u0644\u0627" },
            { "GU", "\u06af\u0648\u0627\u0645" },
            { "GW", "\u06af\u06cc\u0646\u06ce \u0628\u06cc\u0633\u0627\u0648" },
            { "GY", "\u06af\u0648\u06cc\u0627\u0646\u0627" },
            { "HK", "\u0647\u06c6\u0646\u06af \u06a9\u06c6\u0646\u06af" },
            { "HM", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0647\u06ce\u0631\u062f \u0648 \u0645\u06d5\u06a9\u062f\u0627\u0646\u06b5\u062f" },
            { "HN", "\u06be\u06c6\u0646\u062f\u0648\u0648\u0631\u0627\u0633" },
            { "HR", "\u06a9\u0631\u06c6\u0648\u0627\u062a\u06cc\u0627" },
            { "HT", "\u06be\u0627\u06cc\u062a\u06cc" },
            { "HU", "\u0647\u06d5\u0646\u06af\u0627\u0631\u06cc\u0627" },
            { "IC", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a9\u06d5\u0646\u0627\u0631\u06cc" },
            { "ID", "\u0626\u06cc\u0646\u062f\u06c6\u0646\u06cc\u0632\u06cc\u0627" },
            { "IE", "\u0626\u06cc\u0631\u0644\u06d5\u0646\u062f" },
            { "IL", "\u0626\u06cc\u0633\u0631\u0627\u0626\u06cc\u0644" },
            { "IM", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u0645\u0627\u0646" },
            { "IN", "\u06be\u06cc\u0646\u062f\u0633\u062a\u0627\u0646" },
            { "IQ", "\u0639\u06ce\u0631\u0627\u0642" },
            { "IR", "\u0626\u06ce\u0631\u0627\u0646" },
            { "IS", "\u0626\u0627\u06cc\u0633\u0644\u06d5\u0646\u062f" },
            { "IT", "\u0626\u06cc\u062a\u0627\u0644\u06cc\u0627" },
            { "JE", "\u062c\u06ce\u0631\u0633\u06cc" },
            { "JM", "\u062c\u0627\u0645\u0627\u06cc\u06a9\u0627" },
            { "JO", "\u0626\u0648\u0631\u062f\u0646" },
            { "JP", "\u0698\u0627\u067e\u06c6\u0646" },
            { "KE", "\u06a9\u06cc\u0646\u06cc\u0627" },
            { "KG", "\u06a9\u0631\u06af\u06cc\u0632\u0633\u062a\u0627\u0646" },
            { "KH", "\u06a9\u06d5\u0645\u0628\u06c6\u062f\u06cc\u0627" },
            { "KI", "\u06a9\u06cc\u0631\u06cc\u0628\u0627\u0633" },
            { "KM", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a9\u06c6\u0645\u06c6\u0631" },
            { "KN", "\u0633\u06d5\u0646 \u06a9\u06cc\u062a\u0633 \u0648 \u0646\u06cc\u06a4\u06cc\u0633" },
            { "KP", "\u06a9\u06c6\u0631\u06cc\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "KR", "\u06a9\u06c6\u0631\u06cc\u0627\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "KW", "\u06a9\u0648\u06d5\u06cc\u062a" },
            { "KY", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a9\u0627\u06cc\u0645\u0627\u0646" },
            { "KZ", "\u06a9\u0627\u0632\u0627\u062e\u0633\u062a\u0627\u0646" },
            { "LA", "\u0644\u0627\u0648\u0633" },
            { "LB", "\u0644\u0648\u0628\u0646\u0627\u0646" },
            { "LC", "\u0633\u06d5\u0646 \u0644\u0648\u0648\u0633\u06cc\u0627" },
            { "LI", "\u0644\u06cc\u062e\u062a\u0646\u0634\u062a\u0627\u06cc\u0646" },
            { "LK", "\u0633\u0631\u06cc\u0644\u0627\u0646\u06a9\u0627" },
            { "LR", "\u0644\u06cc\u0628\u06d5\u0631\u06cc\u0627" },
            { "LS", "\u0644\u06d5\u0633\u06c6\u062a\u06c6" },
            { "LT", "\u0644\u06cc\u062a\u0648\u0627\u0646\u0627\u06cc\u0627" },
            { "LU", "\u0644\u0648\u06a9\u0633\u06d5\u0645\u0628\u0648\u0631\u06af" },
            { "LV", "\u0644\u0627\u062a\u06a4\u06cc\u0627" },
            { "LY", "\u0644\u06cc\u0628\u06cc\u0627" },
            { "MA", "\u0645\u06d5\u063a\u0631\u06cc\u0628" },
            { "MC", "\u0645\u06c6\u0646\u0627\u06a9\u06c6" },
            { "MD", "\u0645\u06c6\u0644\u062f\u06c6\u06a4\u0627" },
            { "ME", "\u0645\u06c6\u0646\u062a\u06cc\u0646\u06cc\u06af\u0631\u06c6" },
            { "MF", "\u0633\u06d5\u0646 \u0645\u0627\u0631\u062a\u06cc\u0646" },
            { "MG", "\u0645\u0627\u062f\u0627\u06af\u0627\u0633\u06a9\u0627\u0631" },
            { "MH", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0645\u0627\u0631\u0634\u0627\u06b5" },
            { "MK", "\u0645\u06d5\u06a9\u062f\u06c6\u0646\u06cc\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "ML", "\u0645\u0627\u0644\u06cc" },
            { "MM", metaValue_MM },
            { "MN", "\u0645\u06d5\u0646\u06af\u06c6\u0644\u06cc\u0627" },
            { "MO", "\u0645\u0627\u06a9\u0627\u0626\u06c6" },
            { "MP", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0645\u0627\u0631\u06cc\u0627\u0646\u0627\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "MQ", "\u0645\u0627\u0631\u062a\u06cc\u0646\u06cc\u06a9" },
            { "MR", "\u0645\u06c6\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "MS", "\u0645\u06c6\u0646\u062a\u0633\u06ce\u0631\u0627\u062a" },
            { "MT", "\u0645\u0627\u06b5\u062a\u0627" },
            { "MU", "\u0645\u0648\u0648\u0631\u06cc\u062a\u06cc\u0648\u0648\u0633" },
            { "MV", "\u0645\u0627\u0644\u062f\u06cc\u06a4" },
            { "MW", "\u0645\u0627\u0644\u0627\u0648\u06cc" },
            { "MX", "\u0645\u06d5\u06a9\u0633\u06cc\u06a9" },
            { "MY", "\u0645\u0627\u0644\u06cc\u0632\u06cc\u0627" },
            { "MZ", "\u0645\u06c6\u0632\u0627\u0645\u0628\u06cc\u06a9" },
            { "NA", "\u0646\u0627\u0645\u06cc\u0628\u06cc\u0627" },
            { "NC", "\u0646\u06cc\u0648\u0648\u06a9\u0627\u0644\u06ce\u062f\u06c6\u0646\u06cc\u0627" },
            { "NE", "\u0646\u06cc\u062c\u06d5\u0631" },
            { "NF", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06cc \u0646\u06c6\u0631\u0641\u06c6\u06b5\u06a9" },
            { "NG", "\u0646\u06cc\u062c\u0631\u06cc\u0627" },
            { "NI", "\u0646\u06cc\u06a9\u0627\u0631\u0627\u06af\u0648\u0627" },
            { "NL", "\u06be\u06c6\u06b5\u06d5\u0646\u062f\u0627" },
            { "NO", "\u0646\u06c6\u0631\u0648\u06cc\u0698" },
            { "NP", "\u0646\u06cc\u067e\u0627\u0644" },
            { "NR", metaValue_NR },
            { "NU", "\u0646\u06cc\u0648\u0648\u0626\u06cc" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u06cc\u0644\u0627\u0646\u062f" },
            { "OM", "\u0639\u0648\u0645\u0627\u0646" },
            { "PA", "\u067e\u0627\u0646\u0627\u0645\u0627" },
            { "PE", "\u067e\u06ce\u0631\u0648\u0648" },
            { "PF", "\u067e\u06c6\u0644\u06cc\u0646\u06cc\u0633\u06cc\u0627\u06cc \u0641\u06d5\u0631\u06d5\u0646\u0633\u0627" },
            { "PG", "\u067e\u0627\u067e\u0648\u0627 \u06af\u06cc\u0646\u06ce\u06cc \u0646\u0648\u06ce" },
            { "PH", "\u0641\u0644\u06cc\u067e\u06cc\u0646" },
            { "PK", "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u06c6\u06b5\u06d5\u0646\u062f\u0627" },
            { "PM", "\u0633\u06d5\u0646 \u067e\u06cc\u06ce\u0631 \u0648 \u0645\u06cc\u06a9\u06ce\u0644\u06c6\u0646" },
            { "PN", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u067e\u06cc\u062a\u06a9\u06d5\u0631\u0646" },
            { "PR", "\u067e\u06c6\u0631\u062a\u06c6\u0695\u06cc\u06a9\u06c6" },
            { "PS", "\u0646\u0627\u0648\u0686\u06d5 \u0641\u06d5\u0644\u06d5\u0633\u062a\u06cc\u0646\u06cc\u06d5\u06a9\u0627\u0646" },
            { "PT", "\u067e\u0648\u0631\u062a\u0648\u06af\u0627\u0644" },
            { "PW", "\u067e\u0627\u0644\u0627\u0648" },
            { "PY", "\u067e\u0627\u0631\u0627\u06af\u0648\u0627\u06cc" },
            { "QA", "\u0642\u06d5\u062a\u06d5\u0631" },
            { "QO", "\u062f\u06d5\u0631\u06d5\u0648\u06d5\u06cc \u0626\u06c6\u0642\u06cc\u0627\u0646\u0648\u0648\u0633\u06cc\u0627" },
            { "RE", "\u0695\u06cc\u06cc\u0648\u0648\u0646\u06cc\u06d5\u0646" },
            { "RO", "\u0695\u06c6\u0645\u0627\u0646\u06cc\u0627" },
            { "RS", "\u0633\u0631\u0628\u06cc\u0627" },
            { "RU", "\u0695\u0648\u0648\u0633\u06cc\u0627" },
            { "RW", "\u0695\u0648\u0627\u0646\u062f\u0627" },
            { "SA", "\u0639\u06d5\u0631\u06d5\u0628\u0633\u062a\u0627\u0646\u06cc \u0633\u06d5\u0639\u0648\u0648\u062f\u06cc" },
            { "SB", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u0633\u0644\u06ce\u0645\u0627\u0646" },
            { "SC", "\u0633\u06cc\u0634\u06ce\u0644" },
            { "SD", "\u0633\u0648\u0648\u062f\u0627\u0646" },
            { "SE", "\u0633\u0648\u06cc\u062f" },
            { "SG", "\u0633\u06cc\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "SH", "\u0633\u06d5\u0646 \u0647\u06ce\u0644\u06ce\u0646\u0627" },
            { "SI", "\u0633\u0644\u06c6\u06a4\u06ce\u0646\u06cc\u0627" },
            { "SJ", "\u0633\u06a4\u0627\u0644\u0628\u0627\u0631\u062f \u0648 \u06cc\u0627\u0646 \u0645\u0627\u06cc\u06d5\u0646" },
            { "SK", "\u0633\u0644\u06c6\u06a4\u0627\u06a9\u06cc\u0627" },
            { "SL", "\u0633\u06cc\u06d5\u0631\u0627\u0644\u06cc\u06c6\u0646" },
            { "SM", "\u0633\u0627\u0646 \u0645\u0627\u0631\u06cc\u0646\u06c6" },
            { "SN", "\u0633\u06ce\u0646\u06ce\u06af\u0627\u06b5" },
            { "SO", "\u0633\u06c6\u0645\u0627\u0644\u06cc\u0627" },
            { "SR", "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645" },
            { "SS", "\u0633\u0648\u0648\u062f\u0627\u0646\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "ST", "\u0633\u0627\u0648\u062a\u06c6\u0645\u06ce \u0648 \u067e\u0631\u06cc\u0646\u0633\u06cc\u067e\u06cc" },
            { "SV", "\u0626\u06ce\u0644\u0633\u0627\u0644\u06a4\u0627\u062f\u06c6\u0631" },
            { "SX", "\u0633\u06cc\u0646\u062a \u0645\u0627\u0631\u062a\u0646" },
            { "SY", "\u0633\u0648\u0648\u0631\u06cc\u0627" },
            { "SZ", "\u0633\u0648\u0627\u0632\u06cc\u0644\u0627\u0646\u062f" },
            { "TA", "\u062a\u0631\u06cc\u0633\u062a\u06ce\u0646 \u062f\u0627 \u06a9\u0648\u0648\u0646\u0627" },
            { "TC", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u062a\u0648\u0631\u06a9\u0633 \u0648 \u06a9\u0627\u06cc\u06a9\u06c6\u0633" },
            { "TD", "\u0686\u0627\u062f" },
            { "TF", "\u0647\u06d5\u0631\u06ce\u0645\u06d5 \u0628\u0627\u0634\u0648\u0648\u0631\u06cc\u06d5\u06a9\u0627\u0646\u06cc \u0641\u06d5\u0631\u06d5\u0646\u0633\u0627" },
            { "TG", "\u062a\u06c6\u06af\u06c6" },
            { "TH", "\u062a\u0627\u06cc\u0644\u06d5\u0646\u062f" },
            { "TJ", "\u062a\u0627\u062c\u06cc\u06a9\u0633\u062a\u0627\u0646" },
            { "TK", "\u062a\u06c6\u06a9\u06ce\u0644\u0627\u0648" },
            { "TL", "\u062a\u06cc\u0645\u06c6\u0631\u06cc \u0695\u06c6\u0698\u06be\u06d5\u06b5\u0627\u062a" },
            { "TM", "\u062a\u0648\u0631\u06a9\u0645\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u0648\u0648\u0646\u0633" },
            { "TO", "\u062a\u06c6\u0646\u06af\u0627" },
            { "TR", "\u062a\u0648\u0631\u06a9\u06cc\u0627" },
            { "TT", "\u062a\u0631\u06cc\u0646\u06cc\u062f\u0627\u062f \u0648 \u062a\u06c6\u0628\u0627\u06af\u0648" },
            { "TV", metaValue_TV },
            { "TW", "\u062a\u0627\u06cc\u0648\u0627\u0646" },
            { "TZ", "\u062a\u0627\u0646\u0632\u0627\u0646\u06cc\u0627" },
            { "UA", "\u0626\u06c6\u06a9\u0631\u0627\u0646\u06cc\u0627" },
            { "UG", "\u0626\u0648\u06af\u0627\u0646\u062f\u0627" },
            { "UM", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u062f\u06d5\u0631\u06d5\u0648\u06d5\u06cc \u0626\u06d5\u0645\u0631\u06cc\u06a9\u0627" },
            { "UN", "\u0646\u06d5\u062a\u06d5\u0648\u06d5 \u06cc\u06d5\u06a9\u06af\u0631\u062a\u0648\u0648\u06d5\u06a9\u0627\u0646" },
            { "US", "\u0648\u06cc\u0644\u0627\u06cc\u06d5\u062a\u06d5 \u06cc\u06d5\u06a9\u06af\u0631\u062a\u0648\u0648\u06d5\u06a9\u0627\u0646" },
            { "UY", "\u0626\u0648\u0631\u0648\u06af\u0648\u0627\u06cc" },
            { "UZ", "\u0626\u0648\u0632\u0628\u06d5\u06a9\u0633\u062a\u0627\u0646" },
            { "VA", "\u06a4\u0627\u062a\u06cc\u06a9\u0627\u0646" },
            { "VC", "\u0633\u06d5\u06cc\u0646\u062a \u06a4\u06cc\u0646\u0633\u06d5\u0646\u062a \u0648 \u06af\u0631\u06cc\u0646\u0627\u062f\u06cc\u0646\u0632" },
            { "VE", "\u06a4\u06d5\u0646\u0632\u0648\u06ce\u0644\u0627" },
            { "VG", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a4\u06cc\u0631\u062c\u0646\u06cc \u0628\u06d5\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "VI", "\u062f\u0648\u0648\u0631\u06af\u06d5\u06a9\u0627\u0646\u06cc \u06a4\u06cc\u0631\u062c\u0646\u06cc \u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627" },
            { "VN", "\u06a4\u06cc\u06d5\u062a\u0646\u0627\u0645" },
            { "VU", "\u06a4\u0627\u0646\u0648\u0648\u0627\u062a\u0648\u0648" },
            { "WF", "\u0648\u0627\u0644\u06cc\u0633 \u0648 \u0641\u0648\u062a\u0648\u0646\u0627" },
            { "WS", "\u0633\u0627\u0645\u0648\u0627" },
            { "XK", "\u06a9\u06c6\u0633\u06c6\u06a4\u06c6" },
            { "YE", "\u06cc\u06d5\u0645\u06d5\u0646" },
            { "YT", "\u0645\u0627\u06cc\u06c6\u062a" },
            { "ZA", "\u0626\u06d5\u0641\u0631\u06cc\u0642\u0627\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "ZM", "\u0632\u0627\u0645\u0628\u06cc\u0627" },
            { "ZW", "\u0632\u06cc\u0645\u0628\u0627\u0628\u0648\u06cc" },
            { "ZZ", "\u0646\u0627\u0648\u0686\u06d5\u06cc \u0646\u06d5\u0646\u0627\u0633\u0631\u0627\u0648" },
            { "aa", "\u0626\u06d5\u0641\u0627\u0631" },
            { "ab", "\u0626\u06d5\u0628\u062e\u0627\u0632\u06cc" },
            { "af", "\u0626\u06d5\u0641\u0631\u06cc\u06a9\u0627\u0646\u0633" },
            { "ak", "\u0626\u0627\u06a9\u0627\u0646" },
            { "am", "\u0626\u06d5\u0645\u06be\u06d5\u0631\u06cc" },
            { "an", "\u0626\u0627\u0631\u0627\u06af\u06c6\u0646\u06cc" },
            { "ar", metaValue_ar },
            { "as", "\u0626\u0627\u0633\u0627\u0645\u06cc" },
            { "av", "\u0626\u06d5\u06a4\u0627\u0631\u06cc" },
            { "ay", "\u0626\u0627\u06cc\u0645\u0627\u0631\u0627" },
            { "az", "\u0626\u0627\u0632\u06d5\u0631\u0628\u0627\u06cc\u062c\u0627\u0646\u06cc" },
            { "ba", "\u0628\u0627\u0634\u06a9\u06cc\u06d5\u0631" },
            { "be", "\u0628\u06cc\u0644\u0627\u0695\u0648\u0648\u0633\u06cc" },
            { "bg", "\u0628\u06c6\u0644\u06af\u0627\u0631\u06cc" },
            { "bi", "\u0628\u06cc\u0633\u0644\u0627\u0645\u0627" },
            { "bm", "\u0628\u0627\u0645\u0628\u0627\u0631\u0627" },
            { "bn", "\u0628\u06d5\u0646\u06af\u0644\u0627\u062f\u06ce\u0634\u06cc" },
            { "bo", metaValue_bo },
            { "br", "\u0628\u0631\u06ce\u062a\u0648\u0646\u06cc" },
            { "bs", "\u0628\u06c6\u0633\u0646\u06cc" },
            { "ca", "\u0643\u0627\u062a\u0627\u0644\u06c6\u0646\u06cc" },
            { "ce", "\u0686\u06cc\u0686\u0627\u0646\u06cc" },
            { "ch", "\u0686\u0627\u0645\u06c6\u0631\u06c6" },
            { "co", "\u06a9\u06c6\u0631\u0633\u06cc\u06a9\u06cc" },
            { "cs", "\u0686\u06ce\u06a9\u06cc" },
            { "cu", "\u0633\u0644\u0627\u0648\u06cc\u06cc \u06a9\u0644\u06cc\u0633\u06d5\u06cc\u06cc" },
            { "cv", "\u0686\u0648\u0648\u06a4\u0627\u0634\u06cc" },
            { "cy", "\u0648\u06ce\u0644\u0632\u06cc" },
            { "da", "\u062f\u0627\u0646\u0645\u0627\u0631\u0643\u06cc" },
            { "de", "\u0626\u06d5\u06b5\u0645\u0627\u0646\u06cc" },
            { "dv", "\u062f\u06cc\u06a4\u06ce\u0647\u06cc" },
            { "dz", "\u062f\u0632\u0648\u0648\u0646\u06af\u062e\u0627" },
            { "ee", "\u0626\u06ce\u0648\u06ce\u06cc\u06cc" },
            { "el", metaValue_el },
            { "en", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc" },
            { "eo", "\u0626\u06ce\u0633\u067e\u06cc\u0631\u0627\u0646\u062a\u06c6" },
            { "es", "\u0626\u06cc\u0633\u067e\u0627\u0646\u06cc" },
            { "et", "\u0626\u06cc\u0633\u062a\u06c6\u0646\u06cc" },
            { "eu", "\u0628\u0627\u0633\u06a9\u06cc" },
            { "fa", "\u0641\u0627\u0631\u0633\u06cc" },
            { "ff", "\u0641\u0648\u0648\u0644\u0627\u06cc\u06cc" },
            { "fi", "\u0641\u06cc\u0646\u0644\u06d5\u0646\u062f\u06cc" },
            { "fj", metaValue_FJ },
            { "fo", "\u0641\u06d5\u0631\u06c6\u06cc\u06cc" },
            { "fr", "\u0641\u06d5\u0631\u06d5\u0646\u0633\u06cc" },
            { "fy", "\u0641\u0631\u06cc\u0633\u06cc\u06cc \u0695\u06c6\u0698\u0627\u0648\u0627" },
            { "ga", "\u0626\u06cc\u0631\u0644\u06d5\u0646\u062f\u06cc" },
            { "gd", "\u06af\u0647\u200c\u0644\u06cc\u0643\u06cc \u0633\u0643\u06c6\u062a\u0644\u0647\u200c\u0646\u062f\u06cc" },
            { "gl", "\u06af\u0627\u0644\u06cc\u0633\u06cc" },
            { "gn", "\u06af\u0648\u0648\u0627\u0631\u0627\u0646\u06cc" },
            { "gu", "\u06af\u0648\u062c\u0627\u0631\u0627\u062a\u06cc" },
            { "gv", "\u0645\u0627\u0646\u06a9\u06cc" },
            { "ha", "\u0647\u0627\u0626\u0648\u0648\u0633\u0627" },
            { "he", metaValue_he },
            { "hi", "\u0647\u06cc\u0646\u062f\u06cc" },
            { "hr", "\u0643\u0631\u0648\u0627\u062a\u06cc" },
            { "ht", "\u06a9\u0631\u06cc\u0648\u0644\u06cc \u0647\u0627\u0626\u06cc\u062a\u06cc" },
            { "hu", "\u0647\u06d5\u0646\u06af\u0627\u0631\u06cc" },
            { "hy", metaValue_hy },
            { "hz", "\u0647\u06ce\u0631\u06ce\u0631\u06c6" },
            { "ia", "\u0626\u06cc\u0646\u062a\u0631\u0644\u06cc\u0646\u06af\u0648\u0648\u0627" },
            { "id", "\u0626\u06cc\u0646\u062f\u06c6\u0646\u06cc\u0632\u06cc" },
            { "ig", "\u0626\u06cc\u06af\u0628\u06c6" },
            { "ii", "\u0633\u06cc\u0686\u0648\u0627\u0646 \u06cc\u06cc" },
            { "io", "\u0626\u06cc\u062f\u06c6" },
            { "is", "\u0626\u06cc\u0633\u0644\u06d5\u0646\u062f\u06cc" },
            { "it", "\u0626\u06cc\u062a\u0627\u0644\u06cc" },
            { "iu", "\u0626\u06cc\u0646\u0648\u06a9\u062a\u06cc\u062a\u0648\u062a" },
            { "ja", metaValue_ja },
            { "jv", "\u062c\u0627\u06a4\u0627\u06cc\u06cc" },
            { "ka", "\u06af\u06c6\u0631\u062c\u0633\u062a\u0627\u0646\u06cc" },
            { "ki", "\u06a9\u06cc\u06a9\u0648\u0648\u06cc\u0648\u0648" },
            { "kj", "\u06a9\u0648\u0627\u0646\u06cc\u0627\u0645\u0627" },
            { "kk", "\u06a9\u0627\u0632\u0627\u062e\u06cc" },
            { "kl", "\u06a9\u0627\u0644\u0627\u0644\u06cc\u0633\u0648\u0648\u062a" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", "\u0643\u06c6\u0631\u06cc" },
            { "kr", "\u06a9\u0627\u0646\u0648\u0648\u0631\u06cc" },
            { "ks", "\u06a9\u06d5\u0634\u0645\u06cc\u0631\u06cc" },
            { "ku", "\u06a9\u0648\u0631\u062f\u06cc" },
            { "kv", "\u06a9\u06c6\u0645\u06cc" },
            { "kw", "\u06a9\u06c6\u0695\u0646\u06cc" },
            { "ky", "\u0643\u0631\u06af\u06cc\u0632\u06cc" },
            { "la", metaValue_la },
            { "lb", "\u0644\u0648\u06a9\u0633\u06d5\u0645\u0628\u0648\u0631\u06af\u06cc" },
            { "lg", "\u06af\u0627\u0646\u062f\u0627" },
            { "li", "\u0644\u06cc\u0645\u0628\u0648\u0631\u06af\u06cc" },
            { "ln", "\u0644\u064a\u0646\u06af\u0627\u0644\u0627" },
            { "lo", "\u0644\u0627\u0626\u06c6\u06cc\u06cc" },
            { "lt", "\u0644\u06cc\u062a\u0648\u0627\u0646\u06cc" },
            { "lu", "\u0644\u0648\u0648\u0628\u0627 \u06a9\u0627\u062a\u0627\u0646\u06af\u0627" },
            { "lv", "\u0644\u06ce\u062a\u06c6\u0646\u06cc" },
            { "mg", "\u0645\u0627\u0644\u0627\u06af\u0627\u0633\u06cc" },
            { "mh", "\u0645\u0627\u0631\u0634\u0627\u06b5\u06cc" },
            { "mi", "\u0645\u0627\u0626\u06c6\u0631\u06cc" },
            { "mk", "\u0645\u0627\u0643\u06ce\u062f\u06c6\u0646\u06cc" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u0645\u0627\u0631\u0627\u062a\u06cc" },
            { "ms", "\u0645\u0627\u0644\u06cc\u0632\u06cc" },
            { "mt", "\u0645\u0627\u06b5\u062a\u06cc" },
            { "my", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631\u06cc" },
            { "na", metaValue_NR },
            { "nb", "\u0646\u06d5\u0631\u0648\u06cc\u0698\u06cc\u06cc \u0628\u06c6\u06a9\u0645\u0627\u0644" },
            { "nd", "\u0626\u0646\u062f\u06ce\u0628\u06ce\u0644\u06ce\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "ne", "\u0646\u06cc\u067e\u0627\u0644\u06cc" },
            { "ng", "\u0646\u062f\u06c6\u0646\u06af\u0627" },
            { "nl", "\u0647\u06c6\u06b5\u06d5\u0646\u062f\u06cc" },
            { "nn", "\u0646\u06d5\u0631\u0648\u06cc\u0698\u06cc\u06cc \u0646\u06cc\u0646\u06c6\u0631\u0633\u06a9" },
            { "no", "\u0646\u06c6\u0631\u0648\u06ce\u0698\u06cc" },
            { "nr", "\u0626\u0646\u062f\u06ce\u0628\u06ce\u0644\u06ce\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "nv", "\u0646\u0627\u06a4\u0627\u062c\u06c6" },
            { "ny", "\u0646\u06cc\u0627\u0646\u062c\u0627" },
            { "oc", "\u0626\u06c6\u06a9\u0633\u06cc\u062a\u0627\u0646\u06cc" },
            { "om", "\u0626\u06c6\u0631\u06c6\u0645\u06c6" },
            { "or", metaValue_or },
            { "os", "\u0626\u06c6\u0633\u06ce\u062a\u06cc" },
            { "pa", "\u067e\u06d5\u0646\u062c\u0627\u0628\u06cc" },
            { "pl", "\u067e\u06c6\u06b5\u06d5\u0646\u062f\u06cc" },
            { "ps", "\u067e\u06d5\u0634\u062a\u0648\u0648" },
            { "pt", "\u067e\u0648\u0631\u062a\u0648\u06af\u0627\u0644\u06cc" },
            { "qu", "\u06a9\u06ce\u0686\u0648\u0627" },
            { "rm", "\u0695\u06c6\u0645\u0627\u0646\u0634" },
            { "rn", "\u0695\u0648\u0648\u0646\u062f\u06cc" },
            { "ro", "\u0695\u06c6\u0645\u0627\u0646\u06cc" },
            { "ru", "\u0695\u0648\u0648\u0633\u06cc" },
            { "rw", "\u06a9\u06cc\u0646\u06cc\u0627\u0631\u0648\u0627\u0646\u062f\u0627" },
            { "sa", "\u0633\u0627\u0646\u0633\u06a9\u0631\u064a\u062a" },
            { "sc", "\u0633\u0627\u0631\u062f\u06cc\u0646\u06cc" },
            { "sd", "\u0633\u064a\u0646\u062f\u06cc" },
            { "se", "\u0633\u0627\u0645\u06cc\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "sg", "\u0633\u0627\u0646\u06af\u06c6" },
            { "si", "\u0633\u06cc\u0646\u0647\u0627\u0644\u06cc" },
            { "sk", "\u0633\u0644\u06c6\u06a4\u0627\u0643\u06cc" },
            { "sl", "\u0633\u0644\u06c6\u06a4\u06ce\u0646\u06cc" },
            { "sm", "\u0633\u0627\u0645\u06c6\u06cc\u06cc" },
            { "sn", "\u0634\u06c6\u0646\u0627" },
            { "so", "\u0633\u06c6\u0645\u0627\u0644\u06cc" },
            { "sq", "\u0626\u06d5\u06b5\u0628\u0627\u0646\u06cc" },
            { "sr", "\u0633\u0631\u0628\u06cc" },
            { "ss", "\u0633\u0648\u0627\u062a\u06cc" },
            { "st", "\u0633\u06c6\u062a\u06c6\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "su", "\u0633\u0648\u0646\u062f\u0627\u0646\u06cc" },
            { "sv", "\u0633\u0648\u06cc\u062f\u06cc" },
            { "sw", "\u0633\u0648\u0627\u0647\u06cc\u0644\u06cc" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u062a\u0627\u062c\u06cc\u06a9\u06cc" },
            { "th", metaValue_th },
            { "ti", "\u062a\u06cc\u06af\u0631\u06cc\u0646\u06cc\u0627" },
            { "tk", "\u062a\u0648\u0631\u06a9\u0645\u0627\u0646\u06cc" },
            { "tn", "\u062a\u0633\u0648\u0627\u0646\u0627" },
            { "to", "\u062a\u06c6\u0646\u06af\u0627\u0646" },
            { "tr", "\u062a\u0648\u0631\u06a9\u06cc" },
            { "ts", "\u062a\u0633\u06c6\u0646\u06af\u0627" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631\u06cc" },
            { "ty", "\u062a\u0627\u0647\u06cc\u062a\u06cc" },
            { "ug", "\u0626\u06c6\u06cc\u062e\u06c6\u0631\u06cc" },
            { "uk", "\u0626\u06c6\u0643\u0631\u0627\u06cc\u0646\u06cc" },
            { "ur", "\u0626\u06c6\u0631\u062f\u0648\u0648" },
            { "uz", "\u0626\u0648\u0632\u0628\u06d5\u06a9\u06cc" },
            { "ve", "\u06a4\u06ce\u0646\u062f\u0627" },
            { "vi", "\u06a4\u06cc\u06d5\u062a\u0646\u0627\u0645\u06cc" },
            { "vo", "\u06a4\u06c6\u0644\u0627\u067e\u0648\u0648\u06a9" },
            { "wa", "\u0648\u0627\u0644\u0648\u0648\u0646" },
            { "wo", "\u0648\u06c6\u0644\u06c6\u0641" },
            { "xh", "\u0633\u0633\u0648\u0633\u0627" },
            { "yi", "\u06cc\u06cc\u062f\u06cc\u0634" },
            { "yo", "\u06cc\u06c6\u0631\u0648\u0648\u0628\u0627" },
            { "zh", "\u0686\u06cc\u0646\u06cc" },
            { "zu", "\u0632\u0648\u0648\u0644\u0648\u0648" },
            { "ace", "\u0626\u0627\u0686\u06d5\u06cc\u06cc" },
            { "ada", "\u062f\u0627\u0646\u06af\u0645\u06ce" },
            { "ady", "\u0626\u0627\u062f\u06cc\u06af\u06cc" },
            { "agq", "\u0626\u0627\u06af\u06ce\u0645" },
            { "ain", "\u0626\u0627\u06cc\u0646\u0648\u0648" },
            { "ale", "\u0626\u0627\u0644\u06cc\u0648\u062a" },
            { "alt", "\u0626\u0627\u06b5\u062a\u0627\u06cc\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "anp", "\u0626\u06d5\u0646\u06af\u06cc\u06a9\u0627" },
            { "arn", "\u0645\u0627\u067e\u0648\u0648\u0686\u06d5" },
            { "arp", "\u0626\u0627\u0631\u0627\u067e\u0627\u0647\u06c6" },
            { "asa", "\u0626\u0627\u0633\u0648\u0648" },
            { "ast", "\u0626\u0627\u0633\u062a\u06c6\u0631\u06cc" },
            { "awa", "\u0626\u0627\u0648\u0627\u062f\u0647\u06cc" },
            { "ban", "\u0628\u0627\u0644\u06cc" },
            { "bas", "\u0628\u0627\u0633\u0627" },
            { "bem", "\u0628\u06ce\u0645\u0628\u0627" },
            { "bez", "\u0628\u06ce\u0646\u0627" },
            { "bho", "\u0628\u0648\u062c\u067e\u0648\u0648\u0631\u06cc" },
            { "bin", "\u0628\u06cc\u0646\u06cc" },
            { "bla", "\u0633\u06cc\u06a9\u0633\u06cc\u06a9\u0627" },
            { "brx", "\u0628\u06c6\u062f\u06c6" },
            { "bug", "\u0628\u0648\u0648\u06af\u06cc" },
            { "byn", "\u0628\u0644\u06cc\u0646" },
            { "ceb", "\u0633\u06ce\u0628\u0648\u0627\u0646\u06c6" },
            { "cgg", "\u06a9\u06cc\u06af\u0627" },
            { "chk", "\u0686\u0648\u0648\u06a9\u06cc" },
            { "chm", "\u0645\u0627\u0631\u06cc" },
            { "cho", "\u0686\u06c6\u06a9\u062a\u0627\u0648" },
            { "chr", "\u0686\u06ce\u0631\u06c6\u06a9\u06cc" },
            { "chy", "\u0634\u0627\u06cc\u0627\u0646" },
            { "ckb", "\u06a9\u0648\u0631\u062f\u06cc\u06cc \u0646\u0627\u0648\u06d5\u0646\u062f\u06cc" },
            { "crs", "\u0641\u06d5\u0631\u06d5\u0646\u0633\u06cc\u06cc \u0633\u06cc\u0634\u06ce\u0644\u06cc" },
            { "dak", "\u062f\u0627\u06a9\u06c6\u062a\u0627\u06cc\u06cc" },
            { "dar", "\u062f\u0627\u0631\u06af\u06cc\u0646\u06cc" },
            { "dav", "\u062a\u0627\u06cc\u062a\u0627" },
            { "dgr", "\u062f\u06c6\u06af\u0631\u06cc\u0628" },
            { "dje", "\u0632\u0627\u0631\u0645\u0627" },
            { "dsb", "\u0633\u0631\u0628\u06cc\u06cc \u062e\u0648\u0627\u0631\u06cc\u0646" },
            { "dua", "\u062f\u0648\u0648\u0627\u0644\u0627" },
            { "dyo", "\u062c\u06c6\u0644\u0627\u0641\u06c6\u0646\u06cc" },
            { "dzg", "\u062f\u0627\u0632\u0627" },
            { "ebu", "\u0626\u06ce\u0645\u0628\u0648\u0648" },
            { "efi", "\u0626\u06ce\u0641\u06cc\u06a9" },
            { "eka", "\u0626\u06ce\u06a9\u0627\u062c\u0648\u0648\u06a9" },
            { "ewo", "\u0626\u06ce\u0648\u06c6\u0646\u062f\u06c6" },
            { "fil", "\u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646\u06cc" },
            { "fon", "\u0641\u06c6\u0646\u06cc" },
            { "fur", "\u0641\u0631\u06cc\u0626\u0648\u0648\u0644\u06cc" },
            { "gaa", "\u06af\u0627\u06cc\u06cc" },
            { "gez", "\u06af\u06cc\u0632\u06cc" },
            { "gil", "\u06af\u06cc\u0644\u0628\u06ce\u0631\u062a\u06cc" },
            { "gor", "\u06af\u06c6\u0631\u06c6\u0646\u062a\u0627\u0644\u06cc" },
            { "gsw", "\u0626\u06d5\u06b5\u0645\u0627\u0646\u06cc\u06cc \u0633\u0648\u06cc\u0633\u0695\u0627" },
            { "guz", "\u06af\u0648\u0648\u0633\u06cc" },
            { "gwi", "\u06af\u0648\u06cc\u0686\u06cc\u0646" },
            { "haw", "\u0647\u0627\u0648\u0627\u06cc\u06cc" },
            { "hil", "\u0647\u06cc\u0644\u06cc\u06af\u0627\u06cc\u0646\u06c6\u0646" },
            { "hmn", "\u0647\u0645\u06c6\u0646\u06af" },
            { "hsb", "\u0633\u0631\u0628\u06cc\u06cc \u0633\u06d5\u0631\u0648\u0648" },
            { "hup", "\u0647\u0648\u0648\u067e\u0627" },
            { "iba", "\u0626\u06cc\u0628\u0627\u0646" },
            { "ibb", "\u0626\u06cc\u0628\u06cc\u0628\u06c6" },
            { "ilo", "\u0626\u06cc\u0644\u06c6\u06a9\u06c6" },
            { "inh", "\u0626\u06cc\u0646\u06af\u0648\u0648\u0634" },
            { "jbo", "\u0644\u06c6\u0698\u0628\u0627\u0646" },
            { "jgo", "\u0646\u06af\u06c6\u0645\u0628\u0627" },
            { "jmc", "\u0645\u0627\u0686\u0627\u0645\u06ce" },
            { "kab", "\u06a9\u0628\u0627\u0626\u06cc\u0644\u06cc" },
            { "kac", "\u06a9\u0627\u0686\u06cc\u0646" },
            { "kaj", "\u06a9\u06cc\u062c\u0648\u0648" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627" },
            { "kbd", "\u06a9\u0627\u0628\u0627\u0631\u062f\u06cc" },
            { "kcg", "\u062a\u06cc\u0627\u067e" },
            { "kde", "\u0645\u0627\u06a9\u06c6\u0646\u062f\u06d5" },
            { "kea", "\u06a9\u0627\u0628\u0648\u0648\u06a4\u06ce\u0631\u062f\u06cc\u0627\u0646\u06c6" },
            { "kfo", "\u06a9\u06c6\u0631\u06c6" },
            { "kha", "\u06a9\u0647\u0627\u0633\u06cc" },
            { "khq", "\u06a9\u06c6\u06cc\u0631\u0627 \u0686\u06cc\u0646\u06cc" },
            { "kkj", "\u06a9\u0627\u06a9\u06c6" },
            { "kln", "\u06a9\u0627\u0644\u06ce\u0646\u062c\u06cc\u0646" },
            { "kmb", "\u06a9\u06cc\u0645\u0628\u0648\u0648\u0646\u062f\u0648\u0648" },
            { "kok", "\u06a9\u06c6\u0646\u06a9\u0627\u0646\u06cc" },
            { "kpe", "\u06a9\u067e\u06ce\u0644\u06ce" },
            { "krc", "\u06a9\u0627\u0631\u0627\u0686\u0627\u06cc \u0628\u0627\u0644\u06a9\u0627\u0631" },
            { "krl", "\u06a9\u0627\u0631\u06ce\u0644\u06cc" },
            { "kru", "\u06a9\u0648\u0648\u0631\u0648\u0648\u062e" },
            { "ksb", "\u0634\u0627\u0645\u0627\u0628\u0627\u0644\u0627" },
            { "ksf", "\u0628\u0627\u0641\u06cc\u0627" },
            { "ksh", "\u06a9\u06c6\u0644\u06c6\u0646\u06cc" },
            { "kum", "\u06a9\u0648\u0648\u0645\u06cc\u06a9" },
            { "lad", "\u0644\u0627\u062f\u06cc\u0646\u06c6" },
            { "lag", "\u0644\u0627\u0646\u06af\u06cc" },
            { "lez", "\u0644\u06d5\u0632\u06af\u06cc" },
            { "lkt", "\u0644\u0627\u06a9\u06c6\u062a\u0627" },
            { "loz", "\u0644\u06c6\u0632\u06cc" },
            { "lrc", "\u0644\u0648\u0695\u06cc\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "lua", "\u0644\u0648\u0648\u0628\u0627 \u0644\u0648\u0648\u0644\u0648\u0648\u0627" },
            { "lun", "\u0644\u0648\u0648\u0646\u062f\u0627" },
            { "luo", "\u0644\u0648\u0648\u0626\u06c6" },
            { "lus", "\u0645\u06cc\u0632\u06c6" },
            { "luy", "\u0644\u0648\u0648\u06cc\u0627" },
            { "mad", "\u0645\u0627\u062f\u0648\u0648\u0631\u06cc" },
            { "mag", "\u0645\u0627\u06af\u0627\u0647\u06cc" },
            { "mai", "\u0645\u0627\u0626\u06cc\u062a\u06cc\u0644\u06cc" },
            { "mak", "\u0645\u0627\u06a9\u0627\u0633\u0627\u0631" },
            { "mas", "\u0645\u0627\u0633\u0627\u06cc\u06cc" },
            { "mdf", "\u0645\u06c6\u06a9\u0634\u0627" },
            { "men", "\u0645\u06ce\u0646\u062f\u06ce" },
            { "mer", "\u0645\u06ce\u0631\u0648\u0648" },
            { "mfe", "\u0645\u06c6\u0631\u06cc\u0633\u06cc" },
            { "mgh", "\u0645\u0627\u062e\u0648\u0627\u0645\u06cc\u062a\u06c6" },
            { "mgo", "\u0645\u06ce\u062a\u06d5" },
            { "mic", "\u0645\u06cc\u06a9\u0645\u0627\u06a9" },
            { "min", "\u0645\u06cc\u0646\u0627\u0646\u06a9\u0627\u0628\u0627\u0648" },
            { "mni", "\u0645\u0627\u0646\u06cc\u067e\u0648\u0648\u0631\u06cc" },
            { "moh", "\u0645\u06c6\u0647\u0627\u0648\u06a9" },
            { "mos", "\u0645\u06c6\u0633\u06cc" },
            { "mua", "\u0645\u0648\u0646\u062f\u0627\u0646\u06af" },
            { "mul", "\u0686\u06d5\u0646\u062f \u0632\u0645\u0627\u0646" },
            { "mus", "\u06a9\u0631\u06cc\u06a9" },
            { "mwl", "\u0645\u06cc\u0631\u0627\u0646\u062f\u06cc" },
            { "myv", "\u0626\u06ce\u0631\u0632\u06cc\u0627" },
            { "mzn", "\u0645\u0627\u0632\u06d5\u0646\u062f\u06d5\u0631\u0627\u0646\u06cc" },
            { "nap", "\u0646\u0627\u067e\u06c6\u0644\u06cc" },
            { "naq", "\u0646\u0627\u0645\u0627" },
            { "new", "\u0646\u06ce\u0648\u0627\u0631\u06cc" },
            { "nia", "\u0646\u06cc\u0627\u0633" },
            { "niu", "\u0646\u06cc\u0626\u0648\u0648\u06cc\u06cc" },
            { "nmg", "\u06a9\u0648\u0627\u0633\u06cc\u06c6" },
            { "nnh", "\u0646\u06af\u06cc\u0645\u0628\u0648\u0648\u0646" },
            { "nog", "\u0646\u06c6\u06af\u0627\u06cc" },
            { "nqo", "\u0646\u06a9\u06c6" },
            { "nso", "\u0633\u06c6\u062a\u06c6\u06cc \u0628\u0627\u06a9\u0648\u0648\u0631" },
            { "nus", "\u0646\u0648\u06ce\u0631" },
            { "nyn", "\u0646\u06cc\u0627\u0646\u06a9\u06c6\u0644\u06ce" },
            { "pag", "\u067e\u0627\u0646\u06af\u0627\u0633\u06cc\u0646\u0627\u0646" },
            { "pam", "\u067e\u0627\u0645\u067e\u0627\u0646\u06af\u0627" },
            { "pap", "\u067e\u0627\u067e\u06cc\u0627\u0645\u06ce\u0646\u062a\u06c6" },
            { "pau", "\u067e\u0627\u0644\u0627\u0626\u0648\u0648\u06cc\u06cc" },
            { "pcm", "\u067e\u06cc\u062c\u06cc\u0646\u06cc \u0646\u06cc\u062c\u0631\u06cc\u0627" },
            { "prg", "\u067e\u0695\u0648\u0648\u0633\u06cc" },
            { "quc", "\u06a9\u06cc\u0686\u06d5\u06cc\u06cc" },
            { "rap", "\u0695\u0627\u067e\u0627\u0646\u0648\u0648\u06cc\u06cc" },
            { "rar", "\u0695\u0627\u0695\u06c6\u062a\u06c6\u0646\u06af\u0627\u0646" },
            { "rof", "\u0695\u06c6\u0645\u0628\u06c6" },
            { "rup", "\u0626\u0627\u0631\u0645\u06c6\u0645\u0627\u0646\u06cc" },
            { "rwk", "\u0695\u0648\u0627" },
            { "sad", "\u0633\u0627\u0646\u062f\u0627\u0648\u06ce" },
            { "sah", "\u0633\u0627\u062e\u0627" },
            { "saq", "\u0633\u0627\u0645\u0628\u0648\u0648\u0631\u0648\u0648" },
            { "sat", "\u0633\u0627\u0646\u062a\u0627\u0644\u06cc" },
            { "sba", "\u0646\u06af\u0627\u0645\u0628\u0627\u06cc" },
            { "sbp", "\u0633\u0627\u0646\u06af\u0648\u0648" },
            { "scn", "\u0633\u06cc\u0633\u06cc\u0644\u06cc" },
            { "sco", "\u0633\u06a9\u06c6\u062a\u0633" },
            { "sdh", "\u06a9\u0648\u0631\u062f\u06cc\u06cc \u0628\u0627\u0634\u0648\u0648\u0631\u06cc" },
            { "seh", "\u0633\u06ce\u0646\u0627" },
            { "ses", "\u06a9\u06c6\u06cc\u0631\u0627\u0628\u06c6\u0631\u06c6 \u0633\u06ce\u0646\u06cc" },
            { "shi", "\u0634\u06cc\u0644\u0647\u0627" },
            { "shn", "\u0634\u0627\u0646" },
            { "sma", "\u0633\u0627\u0645\u06cc\u06cc \u0628\u0627\u0634\u0648\u0648\u0631" },
            { "smj", "\u0644\u0648\u0648\u0644\u06ce \u0633\u0627\u0645\u06cc" },
            { "smn", "\u0626\u06cc\u0646\u0627\u0631\u06cc \u0633\u0627\u0645\u06cc" },
            { "sms", "\u0633\u0627\u0645\u06cc\u06cc \u0633\u06a9\u06c6\u06b5\u062a" },
            { "snk", "\u0633\u06c6\u0646\u06cc\u0646\u06a9\u06ce" },
            { "srn", "\u0633\u0631\u0627\u0646\u0627\u0646 \u062a\u06c6\u0646\u06af\u06c6" },
            { "ssy", "\u0633\u0627\u0647\u06c6" },
            { "suk", "\u0633\u0648\u0648\u06a9\u0648\u0648\u0645\u0627" },
            { "swb", "\u06a9\u06c6\u0645\u06c6\u0631\u06cc" },
            { "syr", "\u0633\u0631\u06cc\u0627\u0646\u06cc" },
            { "tem", "\u062a\u06cc\u0645\u0646\u06ce" },
            { "teo", "\u062a\u06ce\u0633\u0648\u0648" },
            { "tet", "\u062a\u06ce\u062a\u0648\u0648\u0645" },
            { "tig", "\u062a\u06cc\u06af\u0631\u06ce" },
            { "tlh", "\u0643\u0644\u06cc\u0646\u06af\u06c6\u0646" },
            { "tpi", "\u062a\u06c6\u06a9\u067e\u06cc\u0633\u06cc\u0646" },
            { "trv", "\u062a\u0627\u0631\u06c6\u06a9\u06c6" },
            { "tum", "\u062a\u0648\u0645\u0628\u0648\u0648\u06a9\u0627" },
            { "tvl", metaValue_TV },
            { "twq", "\u062a\u0627\u0633\u0627\u0648\u0627\u06a9" },
            { "tyv", "\u062a\u0648\u0648\u06a4\u06cc\u0646\u06cc" },
            { "tzm", "\u0626\u06d5\u0645\u0627\u0632\u06cc\u063a\u06cc \u0646\u0627\u0648\u06d5\u0695\u0627\u0633\u062a" },
            { "udm", "\u0626\u0648\u0648\u062f\u0645\u0648\u0648\u0631\u062a" },
            { "umb", "\u0626\u0648\u0645\u0628\u0648\u0648\u0646\u062f\u0648\u0648" },
            { "und", "\u0632\u0645\u0627\u0646\u06cc \u0646\u06d5\u0646\u0627\u0633\u0631\u0627\u0648" },
            { "vai", "\u06a4\u0627\u06cc\u06cc" },
            { "vun", "\u06a4\u0648\u0648\u0646\u062c\u0648\u0648" },
            { "wae", "\u0648\u0627\u0644\u0633\u06ce\u0631" },
            { "wal", "\u0648\u06c6\u0644\u0627\u06cc\u062a\u0627" },
            { "war", "\u0648\u0627\u0631\u0627\u06cc" },
            { "xal", "\u06a9\u0627\u0644\u0645\u06cc\u06a9" },
            { "xog", "\u0633\u06c6\u06af\u0627" },
            { "yav", "\u06cc\u0627\u0646\u06af\u0628\u06ce\u0646" },
            { "ybb", "\u06cc\u06ce\u0645\u0628\u0627" },
            { "yue", "\u06a9\u0627\u0646\u062a\u06c6\u0646\u06cc" },
            { "zgh", "\u0626\u06d5\u0645\u0627\u0632\u06cc\u063a\u06cc\u06cc \u0645\u06d5\u063a\u0631\u06cc\u0628" },
            { "zun", "\u0632\u0648\u0648\u0646\u06cc" },
            { "zxx", "\u0647\u06cc\u0686 \u0646\u0627\u0648\u06d5\u0631\u06c6\u06a9\u06cc \u0632\u0645\u0627\u0646\u06cc \u0646\u06cc\u06d5" },
            { "zza", "\u0632\u0627\u0632\u0627" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Beng", "\u0628\u06d5\u0646\u06af\u0627\u0644\u06cc" },
            { "Bopo", "\u0628\u06c6\u067e\u06c6\u0645\u06c6\u0641\u06c6" },
            { "Brai", "\u0628\u0631\u06d5\u06cc\u0644" },
            { "Cyrl", "\u0633\u0631\u06cc\u0644\u06cc\u06a9" },
            { "Deva", "\u062f\u06d5\u06a4\u06d5\u0646\u0627\u06af\u06d5\u0631\u06cc" },
            { "Ethi", "\u0626\u06d5\u062a\u06cc\u06c6\u067e\u06cc\u06a9" },
            { "Geor", "\u06af\u0648\u0631\u062c\u06cc" },
            { "Grek", metaValue_el },
            { "Gujr", "\u06af\u0648\u062c\u06d5\u0631\u0627\u062a\u06cc" },
            { "Guru", "\u06af\u0648\u0631\u0645\u0648\u06a9\u06be\u06cc" },
            { "Hanb", "\u0647\u0627\u0646 \u0644\u06d5\u06af\u06d5\u06b5 \u0628\u06c6\u067e\u06c6\u0645\u06c6\u0641\u06c6" },
            { "Hang", "\u06be\u0627\u0646\u06af\u0648\u0644" },
            { "Hani", "\u06be\u0627\u0646" },
            { "Hans", "\u0626\u0627\u0633\u0627\u0646\u06a9\u0631\u0627\u0648" },
            { "Hant", "\u062f\u06ce\u0631\u06cc\u0646" },
            { "Hebr", metaValue_he },
            { "Hira", "\u06be\u06cc\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "Hrkt", "\u0698\u0627\u067e\u06c6\u0646\u06cc\u06cc \u0628\u0695\u06af\u06d5\u06cc\u06cc" },
            { "Jamo", "\u062c\u0627\u0645\u06c6" },
            { "Jpan", metaValue_ja },
            { "Kana", "\u06a9\u0627\u062a\u0627\u06a9\u0627\u0646\u0627" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", "\u06a9\u06c6\u0631\u06cc" },
            { "Laoo", "\u0644\u0627\u0626\u06c6" },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mymr", metaValue_MM },
            { "Orya", metaValue_or },
            { "Sinh", "\u0633\u06cc\u0646\u06be\u0627\u0644\u0627" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "\u062a\u0627\u0646\u0627" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Zmth", "\u0646\u06cc\u0634\u0627\u0646\u06d5\u06cc \u0628\u06cc\u0631\u06a9\u0627\u0631\u06cc" },
            { "Zsye", "\u0626\u06cc\u0645\u06c6\u062c\u06cc" },
            { "Zsym", "\u0647\u06ce\u0645\u0627\u06a9\u0627\u0646" },
            { "Zxxx", "\u0646\u06d5\u0646\u0648\u0648\u0633\u0631\u0627\u0648" },
            { "Zyyy", "\u0628\u0627\u0648" },
            { "Zzzz", "\u062e\u06d5\u062a\u06cc \u0646\u06d5\u0646\u0627\u0633\u0631\u0627\u0648" },
            { "en_AU", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u0626\u06c6\u0633\u062a\u0631\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "en_CA", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u06a9\u06d5\u0646\u06d5\u062f\u0627\u06cc\u06cc" },
            { "en_GB", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "en_US", "\u0626\u06cc\u0646\u06af\u0644\u06cc\u0632\u06cc\u06cc \u0626\u06d5\u0645\u06d5\u0631\u06cc\u06a9\u0627\u06cc\u06cc" },
            { "nl_BE", "\u0641\u0644\u06ce\u0645\u06cc" },
            { "ro_MD", "\u0645\u06c6\u06b5\u062f\u0627\u06a4\u06cc" },
            { "sw_CD", "\u0633\u0648\u0627\u0647\u06cc\u0644\u06cc\u06cc \u06a9\u06c6\u0646\u06af\u06c6" },
            { "ar_001", "\u0639\u06d5\u0631\u06d5\u0628\u06cc\u06cc \u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f" },
            { "az_Arab", "\u0626\u0627\u0632\u06d5\u0631\u0628\u0627\u06cc\u062c\u0627\u0646\u06cc \u0628\u0627\u0634\u0648\u0648\u0631\u06cc" },
            { "zh_Hans", "\u0686\u06cc\u0646\u06cc (\u0686\u06cc\u0646\u06cc\u06cc \u0626\u0627\u0633\u0627\u0646\u06a9\u0631\u0627\u0648)" },
            { "zh_Hant", "\u0686\u06cc\u0646\u06cc (\u0686\u06cc\u0646\u06cc\u06cc \u062f\u06ce\u0631\u06cc\u0646)" },
            { "ListCompositionPattern", "{0}\u060c {1}" },
        };
        return data;
    }
}
