/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.Value;
import io.vavr.collection.AbstractIterator;
import io.vavr.collection.Comparators;
import io.vavr.collection.Foldable;
import io.vavr.collection.Iterator;
import io.vavr.control.Option;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public interface Traversable<T>
extends Value<T>,
Foldable<T> {
    default public boolean containsAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        for (T element : elements) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    public Traversable<T> filter(Predicate<? super T> var1);

    default public Option<T> find(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (Object a2 : this) {
            if (!predicate.test(a2)) continue;
            return Option.some(a2);
        }
        return Option.none();
    }

    default public <U> U foldLeft(U zero, BiFunction<? super U, ? super T, ? extends U> f2) {
        Objects.requireNonNull(f2, "f is null");
        U xs = zero;
        for (Object x2 : this) {
            xs = f2.apply(xs, x2);
        }
        return xs;
    }

    @Override
    default public T get() {
        return this.head();
    }

    public boolean hasDefiniteSize();

    public T head();

    default public boolean isDistinct() {
        return false;
    }

    @Override
    default public boolean isEmpty() {
        return this.length() == 0;
    }

    default public boolean isOrdered() {
        return false;
    }

    default public boolean isSequential() {
        return false;
    }

    @Override
    default public boolean isSingleValued() {
        return false;
    }

    public boolean isTraversableAgain();

    @Override
    default public Iterator<T> iterator() {
        final Traversable that = this;
        return new AbstractIterator<T>(){
            Traversable<T> traversable;
            {
                this.traversable = that;
            }

            @Override
            public boolean hasNext() {
                return !this.traversable.isEmpty();
            }

            @Override
            public T getNext() {
                Object result2 = this.traversable.head();
                this.traversable = this.traversable.tail();
                return result2;
            }
        };
    }

    public T last();

    public int length();

    default public Option<T> max() {
        return this.maxBy(Comparators.naturalComparator());
    }

    default public Option<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        if (this.isEmpty()) {
            return Option.none();
        }
        Object value2 = this.reduce((t1, t2) -> comparator.compare(t1, t2) >= 0 ? t1 : t2);
        return Option.some(value2);
    }

    default public String mkString(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        StringBuilder builder = new StringBuilder(prefix);
        this.iterator().map(String::valueOf).intersperse(String.valueOf(delimiter)).forEach(builder::append);
        return builder.append(suffix).toString();
    }

    @Override
    default public T reduceLeft(BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op, "op is null");
        return this.iterator().reduceLeft(op);
    }

    default public int size() {
        return this.length();
    }

    @Override
    default public Spliterator<T> spliterator() {
        int characteristics = 1024;
        if (this.isDistinct()) {
            characteristics |= 1;
        }
        if (this.isOrdered()) {
            characteristics |= 0x14;
        }
        if (this.isSequential()) {
            characteristics |= 0x10;
        }
        if (this.hasDefiniteSize()) {
            return Spliterators.spliterator(this.iterator(), (long)this.length(), characteristics |= 0x4040);
        }
        return Spliterators.spliteratorUnknownSize(this.iterator(), characteristics);
    }

    public Traversable<T> tail();
}

