/*
 * Decompiled with CFR 0.152.
 */
package io.bazel.kotlin.builder.guava.cache;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.bazel.kotlin.builder.guava.annotations.GwtIncompatible;
import io.bazel.kotlin.builder.guava.cache.AbstractCache;
import io.bazel.kotlin.builder.guava.cache.ElementTypesAreNonnullByDefault;
import io.bazel.kotlin.builder.guava.cache.LoadingCache;
import io.bazel.kotlin.builder.guava.collect.ImmutableMap;
import io.bazel.kotlin.builder.guava.collect.Maps;
import io.bazel.kotlin.builder.guava.util.concurrent.UncheckedExecutionException;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    @CanIgnoreReturnValue
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys2) throws ExecutionException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (K key : keys2) {
            if (result.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

