// tidy-alphabetical-start
#![allow(internal_features)]
#![feature(decl_macro)]
#![feature(error_iter)]
#![feature(file_buffered)]
#![feature(gen_blocks)]
#![feature(if_let_guard)]
#![feature(macro_metavar_expr)]
#![feature(min_specialization)]
#![feature(never_type)]
#![feature(proc_macro_internals)]
#![feature(result_option_map_or_default)]
#![feature(strip_circumfix)]
#![feature(trusted_len)]
// tidy-alphabetical-end

pub use rmeta::provide;

mod dependency_format;
mod eii;
mod foreign_modules;
mod native_libs;
mod rmeta;

pub mod creader;
pub mod errors;
pub mod fs;
pub mod locator;

pub use creader::{DylibError, load_symbol_from_dylib};
pub use fs::{METADATA_FILENAME, emit_wrapper_file};
pub use native_libs::{
    NativeLibSearchFallback, find_native_static_library, try_find_native_dynamic_library,
    try_find_native_static_library, walk_native_lib_search_dirs,
};
pub use rmeta::{EncodedMetadata, METADATA_HEADER, encode_metadata, rendered_const};
