/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuBarUI;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUIAccessor;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class WindowsMenuUI
extends BasicMenuUI {
    protected Integer menuBarHeight;
    protected boolean hotTrackingOn;
    final WindowsMenuItemUIAccessor accessor = new WindowsMenuItemUIAccessor(){

        @Override
        public JMenuItem getMenuItem() {
            return WindowsMenuUI.this.menuItem;
        }

        @Override
        public TMSchema.State getState(JMenuItem jMenuItem) {
            TMSchema.State state = jMenuItem.isEnabled() ? TMSchema.State.NORMAL : TMSchema.State.DISABLED;
            ButtonModel buttonModel = jMenuItem.getModel();
            if (buttonModel.isArmed() || buttonModel.isSelected()) {
                state = jMenuItem.isEnabled() ? TMSchema.State.PUSHED : TMSchema.State.DISABLEDPUSHED;
            } else if (buttonModel.isRollover() && ((JMenu)jMenuItem).isTopLevelMenu()) {
                TMSchema.State state2 = state;
                state = jMenuItem.isEnabled() ? TMSchema.State.HOT : TMSchema.State.DISABLEDHOT;
                for (MenuElement menuElement : ((JMenuBar)jMenuItem.getParent()).getSubElements()) {
                    if (!((JMenuItem)menuElement).isSelected()) continue;
                    state = state2;
                    break;
                }
            }
            if (!((JMenu)jMenuItem).isTopLevelMenu()) {
                if (state == TMSchema.State.PUSHED) {
                    state = TMSchema.State.HOT;
                } else if (state == TMSchema.State.DISABLEDPUSHED) {
                    state = TMSchema.State.DISABLEDHOT;
                }
            }
            if (((JMenu)jMenuItem).isTopLevelMenu() && WindowsMenuItemUI.isVistaPainting() && !WindowsMenuBarUI.isActive(jMenuItem)) {
                state = TMSchema.State.DISABLED;
            }
            return state;
        }

        @Override
        public TMSchema.Part getPart(JMenuItem jMenuItem) {
            return ((JMenu)jMenuItem).isTopLevelMenu() ? TMSchema.Part.MP_BARITEM : TMSchema.Part.MP_POPUPITEM;
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsMenuUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (!WindowsLookAndFeel.isClassicWindows()) {
            this.menuItem.setRolloverEnabled(true);
        }
        this.menuBarHeight = UIManager.getInt("MenuBar.height");
        Object object = UIManager.get("MenuBar.rolloverEnabled");
        this.hotTrackingOn = object instanceof Boolean ? (Boolean)object : true;
    }

    @Override
    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintMenuItem(this.accessor, graphics, jComponent, icon, icon2, color, color2, this.disabledForeground, this.acceleratorSelectionForeground, this.acceleratorForeground, n, this.menuItem, this.getPropertyPrefix());
            return;
        }
        super.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n);
    }

    @Override
    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintBackground(this.accessor, graphics, jMenuItem, color);
            return;
        }
        JMenu jMenu = (JMenu)jMenuItem;
        ButtonModel buttonModel = jMenu.getModel();
        if (WindowsLookAndFeel.isClassicWindows() || !jMenu.isTopLevelMenu() || XPStyle.getXP() != null && (buttonModel.isArmed() || buttonModel.isSelected())) {
            super.paintBackground(graphics, jMenu, color);
            return;
        }
        Color color2 = graphics.getColor();
        int n = jMenu.getWidth();
        int n2 = jMenu.getHeight();
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Color color3 = uIDefaults.getColor("controlLtHighlight");
        Color color4 = uIDefaults.getColor("controlShadow");
        graphics.setColor(jMenu.getBackground());
        graphics.fillRect(0, 0, n, n2);
        if (jMenu.isOpaque()) {
            if (buttonModel.isArmed() || buttonModel.isSelected()) {
                graphics.setColor(color4);
                graphics.drawLine(0, 0, n - 1, 0);
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.setColor(color3);
                graphics.drawLine(n - 1, 0, n - 1, n2 - 2);
                graphics.drawLine(0, n2 - 2, n - 1, n2 - 2);
            } else if (buttonModel.isRollover() && buttonModel.isEnabled()) {
                boolean bl = false;
                MenuElement[] menuElementArray = ((JMenuBar)jMenu.getParent()).getSubElements();
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (!((JMenuItem)menuElementArray[i]).isSelected()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (XPStyle.getXP() != null) {
                        graphics.setColor(this.selectionBackground);
                        graphics.fillRect(0, 0, n, n2);
                    } else {
                        graphics.setColor(color3);
                        graphics.drawLine(0, 0, n - 1, 0);
                        graphics.drawLine(0, 0, 0, n2 - 2);
                        graphics.setColor(color4);
                        graphics.drawLine(n - 1, 0, n - 1, n2 - 2);
                        graphics.drawLine(0, n2 - 2, n - 1, n2 - 2);
                    }
                }
            }
        }
        graphics.setColor(color2);
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintText(this.accessor, graphics, jMenuItem, rectangle, string);
            return;
        }
        JMenu jMenu = (JMenu)jMenuItem;
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color = graphics.getColor();
        boolean bl = buttonModel.isRollover();
        if (bl && jMenu.isTopLevelMenu()) {
            MenuElement[] menuElementArray = ((JMenuBar)jMenu.getParent()).getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                if (!((JMenuItem)menuElementArray[i]).isSelected()) continue;
                bl = false;
                break;
            }
        }
        if (buttonModel.isSelected() && (WindowsLookAndFeel.isClassicWindows() || !jMenu.isTopLevelMenu()) || XPStyle.getXP() != null && (bl || buttonModel.isArmed() || buttonModel.isSelected())) {
            graphics.setColor(this.selectionForeground);
        }
        WindowsGraphicsUtils.paintText(graphics, jMenuItem, rectangle, string, 0);
        graphics.setColor(color);
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new WindowsMouseInputHandler();
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        Dimension dimension = super.getPreferredMenuItemSize(jComponent, icon, icon2, n);
        if (jComponent instanceof JMenu && ((JMenu)jComponent).isTopLevelMenu() && this.menuBarHeight != null && dimension.height < this.menuBarHeight) {
            dimension.height = this.menuBarHeight;
        }
        return dimension;
    }

    protected class WindowsMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected WindowsMouseInputHandler() {
            super(WindowsMenuUI.this);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            JMenu jMenu = (JMenu)mouseEvent.getSource();
            if (WindowsMenuUI.this.hotTrackingOn && jMenu.isTopLevelMenu() && jMenu.isRolloverEnabled()) {
                jMenu.getModel().setRollover(true);
                WindowsMenuUI.this.menuItem.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            JMenu jMenu = (JMenu)mouseEvent.getSource();
            ButtonModel buttonModel = jMenu.getModel();
            if (jMenu.isRolloverEnabled()) {
                buttonModel.setRollover(false);
                WindowsMenuUI.this.menuItem.repaint();
            }
        }
    }
}

