# Announce: Rakudo Perl 6 compiler, Release #119 (2018.01)

On behalf of the Rakudo development team, I’m very happy to announce the
January 2018 release of Rakudo Perl 6 #119. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo.

Upcoming releases in 2018 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2018.01:
  + Fixes:
    + Fixed IO::CatHandle.read switching handles too soon [dc800d89]
    + Ensured &await can handle flattenable Iterables [1a4df4e1]
    + Made Array.gist limit output to 100 elements [08539c43]
    + Fixed .[count|bool]-only of combinations/permutations [5eed2b00]
        [cda4a4d7][2c27eeaa][d4f53ed5][19604c2d]
    + Made sure subclasses of List create consistent .WHICH [18557da9]
    + Fixed Range.pick/roll in light of degenerate Ranges [5c228333][55cb8f3d]
    + Fixed Whatever.ACCEPTS with Mu:U [89d85baa]
    + Fixed signatures that had Int when Int:D was meant [3e044dc7]
    + Guarded subbuf against negative ranges [24f4609e]
    + Fixed some export issues [38897d19]
    + Fixed Slip wrapping of quoteword with one word [ad684de3]
    + Fixed ±Inf/NaN Num to Rat conversions [042cb741][c91bcc2a]
    + Fixed USAGE with subsets/where and variables with quotes [27fbd7ab]
    + Fixed .gist dumping too much output in some cases [de21da30][53a85080]
    + Fixed crash in `eqv` with conted Versions [72ee58e2]
    + Fixed issues with smiley-ed coercers [a177fa99][8dcf9dac][3947a4c1][354a3848]
    + Made sure Rat calculation does not use type objects [9910b393][9adc58c3]
    + Fixed handling of type objects in Date.new [1d034df8][dfaa2282][038b1ea7]
    + Fixed CURFS/CURI .perl output [9cf2f998]
    + Made sure hashes are not interpolated in regexes [f719a471]
    + Fixed explosions when hypering over Buf [7ba50d86]
    + Made &dd more resilient to low-level stuff [99923747][d0be53a1]
    + Fixed .head/.tail to take any Callable [b4007070]
    + Fixed .skip with WhateverCode [d034cb58]
    + Fixed operator chaining with negated operators [ba111cfe][14c2cdb3]
    + Disallowed binding into a List [eed54cae]
    + Fixed `--optimize` flag propagation in EVAL code [e509c1a9]
    + Fixed RatStr .succ/.pred explosion [631875fc]
    + Fixed silent failure when binding to map keys [6a3db334]
    + Fixed R::I::Rotor calling .pull-one too many times [4a82b4b6]
    + Fixed `need` with versions [7537f899][0cdd82a2][0a73f19a][4d5e097a]
    + Fixed the lookup of many core symbols [efdbfeca]
    + Made .range consistently a Str in OutOfRange exceptions [90246e65]
    + Fixed superfluous parsing of ∞ [626991e0]
    + Fixed many POD issues [14c28cae]
    + Various fixes for the JVM backend [4945dc40][4909430c][333efa0b]
        [00b7832a][70c57c3a][1e8c9762]
    + Various improvements to useless use warnings [d30e5b1e][c6b7012a]
        [64803b0a][ef2dc1b8][99da4a5a][00188757][e9c9dc46]
    + Various improvements to other produced messages [a04c6164][548dcf46]
        [6d65cf4f][51e0aa09][82dbada3][e543c890][0444a2c3][e5b4f37f][900c1b59]
        [96a3582c][5571d7f7][34160bf0][01ffd0f9][6a6470f9][e91159c5][5f7fdfdd]
        [f02606ce][cad66b72][79600d69][2dc93ac3][4ec5936c][ad60b947][732a25c3]
        [f8953ee8][ddbf07e8][fa136be2]
  + Additions:
    + Added Str.uniparse as an alias to Str.parse-names [2a8287cf]
    + Added Cool candidate for .is-prime [f01c50f1][23701966][b2b39bad][893d09ff]
    + Added compile time error for misplaced whenever in v6.d.PREVIEW [7672e34c]
        [0ec8e088]
  + Removals:
    + Removed deprecation fudge for native type instantiations [e0af68a0]
    + Removed :$CWD param in IO::Path.dir [b3e73b64]
    + Removed :$buffer param in IO::Handle.open [f415d61e]
    + Removed MONKEY BUSINESS env var [ac2e50c8]
    + Removed UInt64 (not to be confused with uint64) [cf154355]
  + Build system:
    + Fetch tags too to avoid potential missing tags [d93f8053]
  + Efficiency:
    + Made adding integers to Rats 22% faster [418fc068]
    + Made Blob.subbuf 1.8x faster [5f48c069]
    + Made `else`-less `if`/`with` blocks 3.4x faster in some cases [1815c368]
    + Made DateTime creation about 1.6x faster [36d71a39]
    + Made Date.new about 1.6x faster [b7170f83]
    + Made use of faster typechecks (7.5x faster) [4c9b84f8][8f71b0e0][10cd405f]
    + Made operator chains up to 2.4x faster [b77d8756]
    + Made `infix:<x>` with bools up to 2x faster [f99943d3]
    + Made `infix:<xx>` with bools up to 16x faster [ca4fcaca]
    + Made |(1,2,3) xx 42 about 3x faster [014f1712]
    + Slightly speeded up adding of `whenever`s [7230b765]
    + Slightly optimized Array.ASSIGN-POS [6e13bfa2][86d91f2d]
    + Made `$a ~= "b"` 70% faster [5dd9ed10]
    + Made constraint checks Num/Int/Str literals 1.1x-10x faster [65d4876d]
    + Micro-opted exit_handler [0415bb5f][b5b6e23b][421504bd][21bc5916]
    + Performatized MetaAssign with MetaReverse [858b659f]
    + Made .sum on 2-element Lists about 30% faster [0af3f4d1]
    + Optimized `supply emit <arg>` [81fe7b82]
    + Optimized Supply internals [32fbefab][9086f4c4][2548c2c5]
    + Improved first touch of Array/Hash variables [eeb3cc72]
    + Optimized more cases of private method calls [b6a236b9]
    + Tuned Lock::Async code stucture [f36a1f4e]
    + Special-cased one top-level whenever supply/react [e5f412d6][2192ddd1]
        [2dbc2bcb][e072474e]
    + Made Promise construction slightly faster [2ac1ceaa]
    + Assorted internal improvements to CPU/memory use [00797d07][2130c097]
        [7a3d9ce6][9c0db1cd][fbf432f9][4804003a][229b03fd][163f275b]
        [83a619ec][64de571b][773d2b9e][0dc4f731][cdb53afa]
  + Internal:
    + Introduced ValueObjAt, the .WHICH for value types [202459ce][4790587f]
    + Introduced Proc!set-status [7a4743be]


The following people contributed to this release:

Zoffix Znet, Luca Ferrari, Elizabeth Mattijsen, Tom Browder,
Christian Bartolomäus, Aleks-Daniel Jakimenko-Aleksejev,
Jonathan Worthington, Pawel Murias, Will "Coke" Coleda, Itsuki Toyota,
Jeremy Studer, Alex Chen, JJ Merelo, Moritz Lenz, Jan-Olof Hendig,
Timo Paulssen, Samantha McVey, Wenzel P. P. Peppmeyer, Daniel Green,
David M. Cawthon, David Warring, Marcel Timmerman, Juan Julián Merelo Guervós,
Nick Logan, Brad Gilbert, Dan Zwell, Ben Davies

as well as

Bart Wiegmans, Daniel Dehennin, Paweł Murias, Stefan Seifert, Will Coleda

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#120), is tentatively scheduled for 2018-02-17.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
