// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// ReadRegistryReader is a Reader for the ReadRegistry structure.
type ReadRegistryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ReadRegistryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewReadRegistryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewReadRegistryDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewReadRegistryOK creates a ReadRegistryOK with default headers values
func NewReadRegistryOK() *ReadRegistryOK {
	return &ReadRegistryOK{}
}

/*
ReadRegistryOK describes a response with status code 200, with default header values.

A successful response.
*/
type ReadRegistryOK struct {
	Payload *models.HashicorpCloudVagrant20220930ReadRegistryResponse
}

// IsSuccess returns true when this read registry o k response has a 2xx status code
func (o *ReadRegistryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this read registry o k response has a 3xx status code
func (o *ReadRegistryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this read registry o k response has a 4xx status code
func (o *ReadRegistryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this read registry o k response has a 5xx status code
func (o *ReadRegistryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this read registry o k response a status code equal to that given
func (o *ReadRegistryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the read registry o k response
func (o *ReadRegistryOK) Code() int {
	return 200
}

func (o *ReadRegistryOK) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}][%d] readRegistryOK  %+v", 200, o.Payload)
}

func (o *ReadRegistryOK) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}][%d] readRegistryOK  %+v", 200, o.Payload)
}

func (o *ReadRegistryOK) GetPayload() *models.HashicorpCloudVagrant20220930ReadRegistryResponse {
	return o.Payload
}

func (o *ReadRegistryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930ReadRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReadRegistryDefault creates a ReadRegistryDefault with default headers values
func NewReadRegistryDefault(code int) *ReadRegistryDefault {
	return &ReadRegistryDefault{
		_statusCode: code,
	}
}

/*
ReadRegistryDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ReadRegistryDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this read registry default response has a 2xx status code
func (o *ReadRegistryDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this read registry default response has a 3xx status code
func (o *ReadRegistryDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this read registry default response has a 4xx status code
func (o *ReadRegistryDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this read registry default response has a 5xx status code
func (o *ReadRegistryDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this read registry default response a status code equal to that given
func (o *ReadRegistryDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the read registry default response
func (o *ReadRegistryDefault) Code() int {
	return o._statusCode
}

func (o *ReadRegistryDefault) Error() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}][%d] ReadRegistry default  %+v", o._statusCode, o.Payload)
}

func (o *ReadRegistryDefault) String() string {
	return fmt.Sprintf("[GET /vagrant/2022-09-30/registry/{registry}][%d] ReadRegistry default  %+v", o._statusCode, o.Payload)
}

func (o *ReadRegistryDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ReadRegistryDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
