// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// CreateBoxReader is a Reader for the CreateBox structure.
type CreateBoxReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateBoxReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateBoxOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateBoxDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateBoxOK creates a CreateBoxOK with default headers values
func NewCreateBoxOK() *CreateBoxOK {
	return &CreateBoxOK{}
}

/*
CreateBoxOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateBoxOK struct {
	Payload *models.HashicorpCloudVagrant20220930CreateBoxResponse
}

// IsSuccess returns true when this create box o k response has a 2xx status code
func (o *CreateBoxOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create box o k response has a 3xx status code
func (o *CreateBoxOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create box o k response has a 4xx status code
func (o *CreateBoxOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create box o k response has a 5xx status code
func (o *CreateBoxOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create box o k response a status code equal to that given
func (o *CreateBoxOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create box o k response
func (o *CreateBoxOK) Code() int {
	return 200
}

func (o *CreateBoxOK) Error() string {
	return fmt.Sprintf("[POST /vagrant/2022-09-30/registry/{registry}/boxes][%d] createBoxOK  %+v", 200, o.Payload)
}

func (o *CreateBoxOK) String() string {
	return fmt.Sprintf("[POST /vagrant/2022-09-30/registry/{registry}/boxes][%d] createBoxOK  %+v", 200, o.Payload)
}

func (o *CreateBoxOK) GetPayload() *models.HashicorpCloudVagrant20220930CreateBoxResponse {
	return o.Payload
}

func (o *CreateBoxOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930CreateBoxResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateBoxDefault creates a CreateBoxDefault with default headers values
func NewCreateBoxDefault(code int) *CreateBoxDefault {
	return &CreateBoxDefault{
		_statusCode: code,
	}
}

/*
CreateBoxDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateBoxDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this create box default response has a 2xx status code
func (o *CreateBoxDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create box default response has a 3xx status code
func (o *CreateBoxDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create box default response has a 4xx status code
func (o *CreateBoxDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create box default response has a 5xx status code
func (o *CreateBoxDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create box default response a status code equal to that given
func (o *CreateBoxDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create box default response
func (o *CreateBoxDefault) Code() int {
	return o._statusCode
}

func (o *CreateBoxDefault) Error() string {
	return fmt.Sprintf("[POST /vagrant/2022-09-30/registry/{registry}/boxes][%d] CreateBox default  %+v", o._statusCode, o.Payload)
}

func (o *CreateBoxDefault) String() string {
	return fmt.Sprintf("[POST /vagrant/2022-09-30/registry/{registry}/boxes][%d] CreateBox default  %+v", o._statusCode, o.Payload)
}

func (o *CreateBoxDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *CreateBoxDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
