// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewPackerServiceGetSbomParams creates a new PackerServiceGetSbomParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPackerServiceGetSbomParams() *PackerServiceGetSbomParams {
	return &PackerServiceGetSbomParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPackerServiceGetSbomParamsWithTimeout creates a new PackerServiceGetSbomParams object
// with the ability to set a timeout on a request.
func NewPackerServiceGetSbomParamsWithTimeout(timeout time.Duration) *PackerServiceGetSbomParams {
	return &PackerServiceGetSbomParams{
		timeout: timeout,
	}
}

// NewPackerServiceGetSbomParamsWithContext creates a new PackerServiceGetSbomParams object
// with the ability to set a context for a request.
func NewPackerServiceGetSbomParamsWithContext(ctx context.Context) *PackerServiceGetSbomParams {
	return &PackerServiceGetSbomParams{
		Context: ctx,
	}
}

// NewPackerServiceGetSbomParamsWithHTTPClient creates a new PackerServiceGetSbomParams object
// with the ability to set a custom HTTPClient for a request.
func NewPackerServiceGetSbomParamsWithHTTPClient(client *http.Client) *PackerServiceGetSbomParams {
	return &PackerServiceGetSbomParams{
		HTTPClient: client,
	}
}

/*
PackerServiceGetSbomParams contains all the parameters to send to the API endpoint

	for the packer service get sbom operation.

	Typically these are written to a http.Request.
*/
type PackerServiceGetSbomParams struct {

	// BucketName.
	BucketName string

	// BuildID.
	BuildID string

	// Fingerprint.
	Fingerprint string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	// SbomName.
	SbomName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the packer service get sbom params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetSbomParams) WithDefaults() *PackerServiceGetSbomParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the packer service get sbom params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetSbomParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the packer service get sbom params
func (o *PackerServiceGetSbomParams) WithTimeout(timeout time.Duration) *PackerServiceGetSbomParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the packer service get sbom params
func (o *PackerServiceGetSbomParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the packer service get sbom params
func (o *PackerServiceGetSbomParams) WithContext(ctx context.Context) *PackerServiceGetSbomParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the packer service get sbom params
func (o *PackerServiceGetSbomParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the packer service get sbom params
func (o *PackerServiceGetSbomParams) WithHTTPClient(client *http.Client) *PackerServiceGetSbomParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the packer service get sbom params
func (o *PackerServiceGetSbomParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBucketName adds the bucketName to the packer service get sbom params
func (o *PackerServiceGetSbomParams) WithBucketName(bucketName string) *PackerServiceGetSbomParams {
	o.SetBucketName(bucketName)
	return o
}

// SetBucketName adds the bucketName to the packer service get sbom params
func (o *PackerServiceGetSbomParams) SetBucketName(bucketName string) {
	o.BucketName = bucketName
}

// WithBuildID adds the buildID to the packer service get sbom params
func (o *PackerServiceGetSbomParams) WithBuildID(buildID string) *PackerServiceGetSbomParams {
	o.SetBuildID(buildID)
	return o
}

// SetBuildID adds the buildId to the packer service get sbom params
func (o *PackerServiceGetSbomParams) SetBuildID(buildID string) {
	o.BuildID = buildID
}

// WithFingerprint adds the fingerprint to the packer service get sbom params
func (o *PackerServiceGetSbomParams) WithFingerprint(fingerprint string) *PackerServiceGetSbomParams {
	o.SetFingerprint(fingerprint)
	return o
}

// SetFingerprint adds the fingerprint to the packer service get sbom params
func (o *PackerServiceGetSbomParams) SetFingerprint(fingerprint string) {
	o.Fingerprint = fingerprint
}

// WithLocationOrganizationID adds the locationOrganizationID to the packer service get sbom params
func (o *PackerServiceGetSbomParams) WithLocationOrganizationID(locationOrganizationID string) *PackerServiceGetSbomParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the packer service get sbom params
func (o *PackerServiceGetSbomParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the packer service get sbom params
func (o *PackerServiceGetSbomParams) WithLocationProjectID(locationProjectID string) *PackerServiceGetSbomParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the packer service get sbom params
func (o *PackerServiceGetSbomParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the packer service get sbom params
func (o *PackerServiceGetSbomParams) WithLocationRegionProvider(locationRegionProvider *string) *PackerServiceGetSbomParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the packer service get sbom params
func (o *PackerServiceGetSbomParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the packer service get sbom params
func (o *PackerServiceGetSbomParams) WithLocationRegionRegion(locationRegionRegion *string) *PackerServiceGetSbomParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the packer service get sbom params
func (o *PackerServiceGetSbomParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithSbomName adds the sbomName to the packer service get sbom params
func (o *PackerServiceGetSbomParams) WithSbomName(sbomName string) *PackerServiceGetSbomParams {
	o.SetSbomName(sbomName)
	return o
}

// SetSbomName adds the sbomName to the packer service get sbom params
func (o *PackerServiceGetSbomParams) SetSbomName(sbomName string) {
	o.SbomName = sbomName
}

// WriteToRequest writes these params to a swagger request
func (o *PackerServiceGetSbomParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param bucket_name
	if err := r.SetPathParam("bucket_name", o.BucketName); err != nil {
		return err
	}

	// path param build_id
	if err := r.SetPathParam("build_id", o.BuildID); err != nil {
		return err
	}

	// path param fingerprint
	if err := r.SetPathParam("fingerprint", o.Fingerprint); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	// path param sbom_name
	if err := r.SetPathParam("sbom_name", o.SbomName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
