// Code generated by go-swagger; DO NOT EDIT.

package network_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-network/stable/2020-09-07/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// CreateTokenReader is a Reader for the CreateToken structure.
type CreateTokenReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateTokenReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateTokenOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateTokenDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateTokenOK creates a CreateTokenOK with default headers values
func NewCreateTokenOK() *CreateTokenOK {
	return &CreateTokenOK{}
}

/*
CreateTokenOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateTokenOK struct {
	Payload *models.HashicorpCloudNetwork20200907CreateTokenResponse
}

// IsSuccess returns true when this create token o k response has a 2xx status code
func (o *CreateTokenOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create token o k response has a 3xx status code
func (o *CreateTokenOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create token o k response has a 4xx status code
func (o *CreateTokenOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create token o k response has a 5xx status code
func (o *CreateTokenOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create token o k response a status code equal to that given
func (o *CreateTokenOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create token o k response
func (o *CreateTokenOK) Code() int {
	return 200
}

func (o *CreateTokenOK) Error() string {
	return fmt.Sprintf("[POST /network/2020-09-07/organizations/{location.organization_id}/projects/{location.project_id}/networks/{id}/tokens][%d] createTokenOK  %+v", 200, o.Payload)
}

func (o *CreateTokenOK) String() string {
	return fmt.Sprintf("[POST /network/2020-09-07/organizations/{location.organization_id}/projects/{location.project_id}/networks/{id}/tokens][%d] createTokenOK  %+v", 200, o.Payload)
}

func (o *CreateTokenOK) GetPayload() *models.HashicorpCloudNetwork20200907CreateTokenResponse {
	return o.Payload
}

func (o *CreateTokenOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudNetwork20200907CreateTokenResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateTokenDefault creates a CreateTokenDefault with default headers values
func NewCreateTokenDefault(code int) *CreateTokenDefault {
	return &CreateTokenDefault{
		_statusCode: code,
	}
}

/*
CreateTokenDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateTokenDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this create token default response has a 2xx status code
func (o *CreateTokenDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create token default response has a 3xx status code
func (o *CreateTokenDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create token default response has a 4xx status code
func (o *CreateTokenDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create token default response has a 5xx status code
func (o *CreateTokenDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create token default response a status code equal to that given
func (o *CreateTokenDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create token default response
func (o *CreateTokenDefault) Code() int {
	return o._statusCode
}

func (o *CreateTokenDefault) Error() string {
	return fmt.Sprintf("[POST /network/2020-09-07/organizations/{location.organization_id}/projects/{location.project_id}/networks/{id}/tokens][%d] CreateToken default  %+v", o._statusCode, o.Payload)
}

func (o *CreateTokenDefault) String() string {
	return fmt.Sprintf("[POST /network/2020-09-07/organizations/{location.organization_id}/projects/{location.project_id}/networks/{id}/tokens][%d] CreateToken default  %+v", o._statusCode, o.Payload)
}

func (o *CreateTokenDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *CreateTokenDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
