// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudGlobalNetworkManager20220215Server hashicorp cloud global network manager 20220215 server
//
// swagger:model hashicorp.cloud.global_network_manager_20220215.Server
type HashicorpCloudGlobalNetworkManager20220215Server struct {

	// failure_tolerance is the number of nodes remaining that could fail before the cluster loses stability
	FailureTolerance int32 `json:"failure_tolerance,omitempty"`

	// gossip_port is the Consul serf port
	GossipPort int32 `json:"gossip_port,omitempty"`

	// id is the consul server ID
	ID string `json:"id,omitempty"`

	// lan_address is the local network address of the consul server
	LanAddress string `json:"lan_address,omitempty"`

	// min_quorum is the minimum number of consul servers needed for a quorum
	MinQuorum int32 `json:"min_quorum,omitempty"`

	// name is the consul server name
	Name string `json:"name,omitempty"`

	// rpc_port is the Consul RPC port
	RPCPort int32 `json:"rpc_port,omitempty"`

	// scada_status is the scada provider client's current status
	ScadaStatus string `json:"scada_status,omitempty"`

	// server_tls contains information about TLS certificates on the server.
	ServerTLS *HashicorpCloudGlobalNetworkManager20220215ServerTLSMetadata `json:"server_tls,omitempty"`

	// tls_enabled is true if consul RPCs are encrypted
	// Deprecated: Use server_tls.internal_rpc.enabled instead.
	TLSEnabled bool `json:"tls_enabled,omitempty"`

	// tls_expiry is the date and time that Consul's TLS certificate expires
	// Deprecated: Use server_tls.internal_rpc.cert_expiry instead.
	// Format: date-time
	TLSExpiry strfmt.DateTime `json:"tls_expiry,omitempty"`

	// version is the consul version
	Version string `json:"version,omitempty"`
}

// Validate validates this hashicorp cloud global network manager 20220215 server
func (m *HashicorpCloudGlobalNetworkManager20220215Server) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateServerTLS(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTLSExpiry(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215Server) validateServerTLS(formats strfmt.Registry) error {
	if swag.IsZero(m.ServerTLS) { // not required
		return nil
	}

	if m.ServerTLS != nil {
		if err := m.ServerTLS.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("server_tls")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("server_tls")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215Server) validateTLSExpiry(formats strfmt.Registry) error {
	if swag.IsZero(m.TLSExpiry) { // not required
		return nil
	}

	if err := validate.FormatOf("tls_expiry", "body", "date-time", m.TLSExpiry.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud global network manager 20220215 server based on the context it is used
func (m *HashicorpCloudGlobalNetworkManager20220215Server) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateServerTLS(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudGlobalNetworkManager20220215Server) contextValidateServerTLS(ctx context.Context, formats strfmt.Registry) error {

	if m.ServerTLS != nil {

		if swag.IsZero(m.ServerTLS) { // not required
			return nil
		}

		if err := m.ServerTLS.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("server_tls")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("server_tls")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215Server) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudGlobalNetworkManager20220215Server) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudGlobalNetworkManager20220215Server
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
