// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewUpdateRandomRotatingSecretParams creates a new UpdateRandomRotatingSecretParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateRandomRotatingSecretParams() *UpdateRandomRotatingSecretParams {
	return &UpdateRandomRotatingSecretParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateRandomRotatingSecretParamsWithTimeout creates a new UpdateRandomRotatingSecretParams object
// with the ability to set a timeout on a request.
func NewUpdateRandomRotatingSecretParamsWithTimeout(timeout time.Duration) *UpdateRandomRotatingSecretParams {
	return &UpdateRandomRotatingSecretParams{
		timeout: timeout,
	}
}

// NewUpdateRandomRotatingSecretParamsWithContext creates a new UpdateRandomRotatingSecretParams object
// with the ability to set a context for a request.
func NewUpdateRandomRotatingSecretParamsWithContext(ctx context.Context) *UpdateRandomRotatingSecretParams {
	return &UpdateRandomRotatingSecretParams{
		Context: ctx,
	}
}

// NewUpdateRandomRotatingSecretParamsWithHTTPClient creates a new UpdateRandomRotatingSecretParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateRandomRotatingSecretParamsWithHTTPClient(client *http.Client) *UpdateRandomRotatingSecretParams {
	return &UpdateRandomRotatingSecretParams{
		HTTPClient: client,
	}
}

/*
UpdateRandomRotatingSecretParams contains all the parameters to send to the API endpoint

	for the update random rotating secret operation.

	Typically these are written to a http.Request.
*/
type UpdateRandomRotatingSecretParams struct {

	// AppName.
	AppName string

	// Body.
	Body *models.SecretServiceUpdateRandomRotatingSecretBody

	// Name.
	Name string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update random rotating secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateRandomRotatingSecretParams) WithDefaults() *UpdateRandomRotatingSecretParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update random rotating secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateRandomRotatingSecretParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) WithTimeout(timeout time.Duration) *UpdateRandomRotatingSecretParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) WithContext(ctx context.Context) *UpdateRandomRotatingSecretParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) WithHTTPClient(client *http.Client) *UpdateRandomRotatingSecretParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) WithAppName(appName string) *UpdateRandomRotatingSecretParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithBody adds the body to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) WithBody(body *models.SecretServiceUpdateRandomRotatingSecretBody) *UpdateRandomRotatingSecretParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) SetBody(body *models.SecretServiceUpdateRandomRotatingSecretBody) {
	o.Body = body
}

// WithName adds the name to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) WithName(name string) *UpdateRandomRotatingSecretParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) SetName(name string) {
	o.Name = name
}

// WithOrganizationID adds the organizationID to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) WithOrganizationID(organizationID string) *UpdateRandomRotatingSecretParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) WithProjectID(projectID string) *UpdateRandomRotatingSecretParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the update random rotating secret params
func (o *UpdateRandomRotatingSecretParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateRandomRotatingSecretParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
