// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// ListTwilioIntegrationsReader is a Reader for the ListTwilioIntegrations structure.
type ListTwilioIntegrationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListTwilioIntegrationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListTwilioIntegrationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListTwilioIntegrationsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListTwilioIntegrationsOK creates a ListTwilioIntegrationsOK with default headers values
func NewListTwilioIntegrationsOK() *ListTwilioIntegrationsOK {
	return &ListTwilioIntegrationsOK{}
}

/*
ListTwilioIntegrationsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListTwilioIntegrationsOK struct {
	Payload *models.Secrets20231128ListTwilioIntegrationsResponse
}

// IsSuccess returns true when this list twilio integrations o k response has a 2xx status code
func (o *ListTwilioIntegrationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list twilio integrations o k response has a 3xx status code
func (o *ListTwilioIntegrationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list twilio integrations o k response has a 4xx status code
func (o *ListTwilioIntegrationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list twilio integrations o k response has a 5xx status code
func (o *ListTwilioIntegrationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list twilio integrations o k response a status code equal to that given
func (o *ListTwilioIntegrationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list twilio integrations o k response
func (o *ListTwilioIntegrationsOK) Code() int {
	return 200
}

func (o *ListTwilioIntegrationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config][%d] listTwilioIntegrationsOK %s", 200, payload)
}

func (o *ListTwilioIntegrationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config][%d] listTwilioIntegrationsOK %s", 200, payload)
}

func (o *ListTwilioIntegrationsOK) GetPayload() *models.Secrets20231128ListTwilioIntegrationsResponse {
	return o.Payload
}

func (o *ListTwilioIntegrationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128ListTwilioIntegrationsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListTwilioIntegrationsDefault creates a ListTwilioIntegrationsDefault with default headers values
func NewListTwilioIntegrationsDefault(code int) *ListTwilioIntegrationsDefault {
	return &ListTwilioIntegrationsDefault{
		_statusCode: code,
	}
}

/*
ListTwilioIntegrationsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListTwilioIntegrationsDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this list twilio integrations default response has a 2xx status code
func (o *ListTwilioIntegrationsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list twilio integrations default response has a 3xx status code
func (o *ListTwilioIntegrationsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list twilio integrations default response has a 4xx status code
func (o *ListTwilioIntegrationsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list twilio integrations default response has a 5xx status code
func (o *ListTwilioIntegrationsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list twilio integrations default response a status code equal to that given
func (o *ListTwilioIntegrationsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list twilio integrations default response
func (o *ListTwilioIntegrationsDefault) Code() int {
	return o._statusCode
}

func (o *ListTwilioIntegrationsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config][%d] ListTwilioIntegrations default %s", o._statusCode, payload)
}

func (o *ListTwilioIntegrationsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config][%d] ListTwilioIntegrations default %s", o._statusCode, payload)
}

func (o *ListTwilioIntegrationsDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *ListTwilioIntegrationsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
