// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewCreateAwsDynamicSecretParams creates a new CreateAwsDynamicSecretParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateAwsDynamicSecretParams() *CreateAwsDynamicSecretParams {
	return &CreateAwsDynamicSecretParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateAwsDynamicSecretParamsWithTimeout creates a new CreateAwsDynamicSecretParams object
// with the ability to set a timeout on a request.
func NewCreateAwsDynamicSecretParamsWithTimeout(timeout time.Duration) *CreateAwsDynamicSecretParams {
	return &CreateAwsDynamicSecretParams{
		timeout: timeout,
	}
}

// NewCreateAwsDynamicSecretParamsWithContext creates a new CreateAwsDynamicSecretParams object
// with the ability to set a context for a request.
func NewCreateAwsDynamicSecretParamsWithContext(ctx context.Context) *CreateAwsDynamicSecretParams {
	return &CreateAwsDynamicSecretParams{
		Context: ctx,
	}
}

// NewCreateAwsDynamicSecretParamsWithHTTPClient creates a new CreateAwsDynamicSecretParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateAwsDynamicSecretParamsWithHTTPClient(client *http.Client) *CreateAwsDynamicSecretParams {
	return &CreateAwsDynamicSecretParams{
		HTTPClient: client,
	}
}

/*
CreateAwsDynamicSecretParams contains all the parameters to send to the API endpoint

	for the create aws dynamic secret operation.

	Typically these are written to a http.Request.
*/
type CreateAwsDynamicSecretParams struct {

	// AppName.
	AppName string

	// Body.
	Body *models.SecretServiceCreateAwsDynamicSecretBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create aws dynamic secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateAwsDynamicSecretParams) WithDefaults() *CreateAwsDynamicSecretParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create aws dynamic secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateAwsDynamicSecretParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) WithTimeout(timeout time.Duration) *CreateAwsDynamicSecretParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) WithContext(ctx context.Context) *CreateAwsDynamicSecretParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) WithHTTPClient(client *http.Client) *CreateAwsDynamicSecretParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) WithAppName(appName string) *CreateAwsDynamicSecretParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithBody adds the body to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) WithBody(body *models.SecretServiceCreateAwsDynamicSecretBody) *CreateAwsDynamicSecretParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) SetBody(body *models.SecretServiceCreateAwsDynamicSecretBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) WithOrganizationID(organizationID string) *CreateAwsDynamicSecretParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) WithProjectID(projectID string) *CreateAwsDynamicSecretParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the create aws dynamic secret params
func (o *CreateAwsDynamicSecretParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateAwsDynamicSecretParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
