// Code generated by go-swagger; DO NOT EDIT.

package tenant_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetTenantParams creates a new GetTenantParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetTenantParams() *GetTenantParams {
	return &GetTenantParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetTenantParamsWithTimeout creates a new GetTenantParams object
// with the ability to set a timeout on a request.
func NewGetTenantParamsWithTimeout(timeout time.Duration) *GetTenantParams {
	return &GetTenantParams{
		timeout: timeout,
	}
}

// NewGetTenantParamsWithContext creates a new GetTenantParams object
// with the ability to set a context for a request.
func NewGetTenantParamsWithContext(ctx context.Context) *GetTenantParams {
	return &GetTenantParams{
		Context: ctx,
	}
}

// NewGetTenantParamsWithHTTPClient creates a new GetTenantParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetTenantParamsWithHTTPClient(client *http.Client) *GetTenantParams {
	return &GetTenantParams{
		HTTPClient: client,
	}
}

/*
GetTenantParams contains all the parameters to send to the API endpoint

	for the get tenant operation.

	Typically these are written to a http.Request.
*/
type GetTenantParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID *string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get tenant params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetTenantParams) WithDefaults() *GetTenantParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get tenant params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetTenantParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get tenant params
func (o *GetTenantParams) WithTimeout(timeout time.Duration) *GetTenantParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get tenant params
func (o *GetTenantParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get tenant params
func (o *GetTenantParams) WithContext(ctx context.Context) *GetTenantParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get tenant params
func (o *GetTenantParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get tenant params
func (o *GetTenantParams) WithHTTPClient(client *http.Client) *GetTenantParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get tenant params
func (o *GetTenantParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the get tenant params
func (o *GetTenantParams) WithLocationOrganizationID(locationOrganizationID *string) *GetTenantParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get tenant params
func (o *GetTenantParams) SetLocationOrganizationID(locationOrganizationID *string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get tenant params
func (o *GetTenantParams) WithLocationProjectID(locationProjectID string) *GetTenantParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get tenant params
func (o *GetTenantParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get tenant params
func (o *GetTenantParams) WithLocationRegionProvider(locationRegionProvider *string) *GetTenantParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get tenant params
func (o *GetTenantParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get tenant params
func (o *GetTenantParams) WithLocationRegionRegion(locationRegionRegion *string) *GetTenantParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get tenant params
func (o *GetTenantParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *GetTenantParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.LocationOrganizationID != nil {

		// query param location.organization_id
		var qrLocationOrganizationID string

		if o.LocationOrganizationID != nil {
			qrLocationOrganizationID = *o.LocationOrganizationID
		}
		qLocationOrganizationID := qrLocationOrganizationID
		if qLocationOrganizationID != "" {

			if err := r.SetQueryParam("location.organization_id", qLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
