// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2021-04-30/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceCreateBuildReader is a Reader for the PackerServiceCreateBuild structure.
type PackerServiceCreateBuildReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceCreateBuildReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceCreateBuildOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceCreateBuildDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceCreateBuildOK creates a PackerServiceCreateBuildOK with default headers values
func NewPackerServiceCreateBuildOK() *PackerServiceCreateBuildOK {
	return &PackerServiceCreateBuildOK{}
}

/*
PackerServiceCreateBuildOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceCreateBuildOK struct {
	Payload *models.HashicorpCloudPackerCreateBuildResponse
}

// IsSuccess returns true when this packer service create build o k response has a 2xx status code
func (o *PackerServiceCreateBuildOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service create build o k response has a 3xx status code
func (o *PackerServiceCreateBuildOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service create build o k response has a 4xx status code
func (o *PackerServiceCreateBuildOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service create build o k response has a 5xx status code
func (o *PackerServiceCreateBuildOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service create build o k response a status code equal to that given
func (o *PackerServiceCreateBuildOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service create build o k response
func (o *PackerServiceCreateBuildOK) Code() int {
	return 200
}

func (o *PackerServiceCreateBuildOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/iterations/{iteration_id}][%d] packerServiceCreateBuildOK %s", 200, payload)
}

func (o *PackerServiceCreateBuildOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/iterations/{iteration_id}][%d] packerServiceCreateBuildOK %s", 200, payload)
}

func (o *PackerServiceCreateBuildOK) GetPayload() *models.HashicorpCloudPackerCreateBuildResponse {
	return o.Payload
}

func (o *PackerServiceCreateBuildOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPackerCreateBuildResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceCreateBuildDefault creates a PackerServiceCreateBuildDefault with default headers values
func NewPackerServiceCreateBuildDefault(code int) *PackerServiceCreateBuildDefault {
	return &PackerServiceCreateBuildDefault{
		_statusCode: code,
	}
}

/*
PackerServiceCreateBuildDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceCreateBuildDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service create build default response has a 2xx status code
func (o *PackerServiceCreateBuildDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service create build default response has a 3xx status code
func (o *PackerServiceCreateBuildDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service create build default response has a 4xx status code
func (o *PackerServiceCreateBuildDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service create build default response has a 5xx status code
func (o *PackerServiceCreateBuildDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service create build default response a status code equal to that given
func (o *PackerServiceCreateBuildDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service create build default response
func (o *PackerServiceCreateBuildDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceCreateBuildDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/iterations/{iteration_id}][%d] PackerService_CreateBuild default %s", o._statusCode, payload)
}

func (o *PackerServiceCreateBuildDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/iterations/{iteration_id}][%d] PackerService_CreateBuild default %s", o._statusCode, payload)
}

func (o *PackerServiceCreateBuildDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceCreateBuildDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PackerServiceCreateBuildBody packer service create build body
swagger:model PackerServiceCreateBuildBody
*/
type PackerServiceCreateBuildBody struct {

	// Information about the build to create.
	Build *models.HashicorpCloudPackerBuildCreateBody `json:"build,omitempty"`

	// Fingerprint of the iteration set by Packer when you call `packer build`.
	// Refer to the Packer documentation for more information on how this value is set.
	// The fingerprint can be used as an identifier for the iteration.
	Fingerprint string `json:"fingerprint,omitempty"`

	// location
	Location *PackerServiceCreateBuildParamsBodyLocation `json:"location,omitempty"`
}

// Validate validates this packer service create build body
func (o *PackerServiceCreateBuildBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBuild(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceCreateBuildBody) validateBuild(formats strfmt.Registry) error {
	if swag.IsZero(o.Build) { // not required
		return nil
	}

	if o.Build != nil {
		if err := o.Build.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "build")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "build")
			}
			return err
		}
	}

	return nil
}

func (o *PackerServiceCreateBuildBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this packer service create build body based on the context it is used
func (o *PackerServiceCreateBuildBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBuild(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceCreateBuildBody) contextValidateBuild(ctx context.Context, formats strfmt.Registry) error {

	if o.Build != nil {

		if swag.IsZero(o.Build) { // not required
			return nil
		}

		if err := o.Build.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "build")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "build")
			}
			return err
		}
	}

	return nil
}

func (o *PackerServiceCreateBuildBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PackerServiceCreateBuildBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PackerServiceCreateBuildBody) UnmarshalBinary(b []byte) error {
	var res PackerServiceCreateBuildBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PackerServiceCreateBuildParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model PackerServiceCreateBuildParamsBodyLocation
*/
type PackerServiceCreateBuildParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *cloud.HashicorpCloudLocationRegion `json:"region,omitempty"`
}

// Validate validates this packer service create build params body location
func (o *PackerServiceCreateBuildParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceCreateBuildParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this packer service create build params body location based on the context it is used
func (o *PackerServiceCreateBuildParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceCreateBuildParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PackerServiceCreateBuildParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PackerServiceCreateBuildParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res PackerServiceCreateBuildParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
