// Code generated by go-swagger; DO NOT EDIT.

package auth_config_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// AuthConfigServiceCreateAuthConnectionReader is a Reader for the AuthConfigServiceCreateAuthConnection structure.
type AuthConfigServiceCreateAuthConnectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AuthConfigServiceCreateAuthConnectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAuthConfigServiceCreateAuthConnectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAuthConfigServiceCreateAuthConnectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAuthConfigServiceCreateAuthConnectionOK creates a AuthConfigServiceCreateAuthConnectionOK with default headers values
func NewAuthConfigServiceCreateAuthConnectionOK() *AuthConfigServiceCreateAuthConnectionOK {
	return &AuthConfigServiceCreateAuthConnectionOK{}
}

/*
AuthConfigServiceCreateAuthConnectionOK describes a response with status code 200, with default header values.

A successful response.
*/
type AuthConfigServiceCreateAuthConnectionOK struct {
	Payload *models.HashicorpCloudIamCreateAuthConnectionResponse
}

// IsSuccess returns true when this auth config service create auth connection o k response has a 2xx status code
func (o *AuthConfigServiceCreateAuthConnectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this auth config service create auth connection o k response has a 3xx status code
func (o *AuthConfigServiceCreateAuthConnectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this auth config service create auth connection o k response has a 4xx status code
func (o *AuthConfigServiceCreateAuthConnectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this auth config service create auth connection o k response has a 5xx status code
func (o *AuthConfigServiceCreateAuthConnectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this auth config service create auth connection o k response a status code equal to that given
func (o *AuthConfigServiceCreateAuthConnectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the auth config service create auth connection o k response
func (o *AuthConfigServiceCreateAuthConnectionOK) Code() int {
	return 200
}

func (o *AuthConfigServiceCreateAuthConnectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/auth_connections][%d] authConfigServiceCreateAuthConnectionOK %s", 200, payload)
}

func (o *AuthConfigServiceCreateAuthConnectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/auth_connections][%d] authConfigServiceCreateAuthConnectionOK %s", 200, payload)
}

func (o *AuthConfigServiceCreateAuthConnectionOK) GetPayload() *models.HashicorpCloudIamCreateAuthConnectionResponse {
	return o.Payload
}

func (o *AuthConfigServiceCreateAuthConnectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamCreateAuthConnectionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAuthConfigServiceCreateAuthConnectionDefault creates a AuthConfigServiceCreateAuthConnectionDefault with default headers values
func NewAuthConfigServiceCreateAuthConnectionDefault(code int) *AuthConfigServiceCreateAuthConnectionDefault {
	return &AuthConfigServiceCreateAuthConnectionDefault{
		_statusCode: code,
	}
}

/*
AuthConfigServiceCreateAuthConnectionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type AuthConfigServiceCreateAuthConnectionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this auth config service create auth connection default response has a 2xx status code
func (o *AuthConfigServiceCreateAuthConnectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this auth config service create auth connection default response has a 3xx status code
func (o *AuthConfigServiceCreateAuthConnectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this auth config service create auth connection default response has a 4xx status code
func (o *AuthConfigServiceCreateAuthConnectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this auth config service create auth connection default response has a 5xx status code
func (o *AuthConfigServiceCreateAuthConnectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this auth config service create auth connection default response a status code equal to that given
func (o *AuthConfigServiceCreateAuthConnectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the auth config service create auth connection default response
func (o *AuthConfigServiceCreateAuthConnectionDefault) Code() int {
	return o._statusCode
}

func (o *AuthConfigServiceCreateAuthConnectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/auth_connections][%d] AuthConfigService_CreateAuthConnection default %s", o._statusCode, payload)
}

func (o *AuthConfigServiceCreateAuthConnectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/auth_connections][%d] AuthConfigService_CreateAuthConnection default %s", o._statusCode, payload)
}

func (o *AuthConfigServiceCreateAuthConnectionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *AuthConfigServiceCreateAuthConnectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AuthConfigServiceCreateAuthConnectionBody CreateAuthConnectionRequest creates an AuthConnection.
swagger:model AuthConfigServiceCreateAuthConnectionBody
*/
type AuthConfigServiceCreateAuthConnectionBody struct {

	// client_id is the ID of the client for the connection.
	ClientID string `json:"client_id,omitempty"`

	// client_secret is the secret for the client above.
	ClientSecret string `json:"client_secret,omitempty"`

	// default_role is the RBAC role that users signing in to the
	// SSO org will get as the default.
	DefaultRole string `json:"default_role,omitempty"`

	// email_domain associated with the of the connection.
	EmailDomain string `json:"email_domain,omitempty"`

	// issuer is the URL of the identity provider.
	Issuer string `json:"issuer,omitempty"`
}

// Validate validates this auth config service create auth connection body
func (o *AuthConfigServiceCreateAuthConnectionBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this auth config service create auth connection body based on context it is used
func (o *AuthConfigServiceCreateAuthConnectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *AuthConfigServiceCreateAuthConnectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AuthConfigServiceCreateAuthConnectionBody) UnmarshalBinary(b []byte) error {
	var res AuthConfigServiceCreateAuthConnectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
