// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewBoundaryServiceMaintenanceWindowGetParams creates a new BoundaryServiceMaintenanceWindowGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBoundaryServiceMaintenanceWindowGetParams() *BoundaryServiceMaintenanceWindowGetParams {
	return &BoundaryServiceMaintenanceWindowGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBoundaryServiceMaintenanceWindowGetParamsWithTimeout creates a new BoundaryServiceMaintenanceWindowGetParams object
// with the ability to set a timeout on a request.
func NewBoundaryServiceMaintenanceWindowGetParamsWithTimeout(timeout time.Duration) *BoundaryServiceMaintenanceWindowGetParams {
	return &BoundaryServiceMaintenanceWindowGetParams{
		timeout: timeout,
	}
}

// NewBoundaryServiceMaintenanceWindowGetParamsWithContext creates a new BoundaryServiceMaintenanceWindowGetParams object
// with the ability to set a context for a request.
func NewBoundaryServiceMaintenanceWindowGetParamsWithContext(ctx context.Context) *BoundaryServiceMaintenanceWindowGetParams {
	return &BoundaryServiceMaintenanceWindowGetParams{
		Context: ctx,
	}
}

// NewBoundaryServiceMaintenanceWindowGetParamsWithHTTPClient creates a new BoundaryServiceMaintenanceWindowGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewBoundaryServiceMaintenanceWindowGetParamsWithHTTPClient(client *http.Client) *BoundaryServiceMaintenanceWindowGetParams {
	return &BoundaryServiceMaintenanceWindowGetParams{
		HTTPClient: client,
	}
}

/*
BoundaryServiceMaintenanceWindowGetParams contains all the parameters to send to the API endpoint

	for the boundary service maintenance window get operation.

	Typically these are written to a http.Request.
*/
type BoundaryServiceMaintenanceWindowGetParams struct {

	/* ClusterID.

	   cluster_id is the id of the cluster set by user on creation.
	*/
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the boundary service maintenance window get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceMaintenanceWindowGetParams) WithDefaults() *BoundaryServiceMaintenanceWindowGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the boundary service maintenance window get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceMaintenanceWindowGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) WithTimeout(timeout time.Duration) *BoundaryServiceMaintenanceWindowGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) WithContext(ctx context.Context) *BoundaryServiceMaintenanceWindowGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) WithHTTPClient(client *http.Client) *BoundaryServiceMaintenanceWindowGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) WithClusterID(clusterID string) *BoundaryServiceMaintenanceWindowGetParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) WithLocationOrganizationID(locationOrganizationID string) *BoundaryServiceMaintenanceWindowGetParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) WithLocationProjectID(locationProjectID string) *BoundaryServiceMaintenanceWindowGetParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) WithLocationRegionProvider(locationRegionProvider *string) *BoundaryServiceMaintenanceWindowGetParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) WithLocationRegionRegion(locationRegionRegion *string) *BoundaryServiceMaintenanceWindowGetParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the boundary service maintenance window get params
func (o *BoundaryServiceMaintenanceWindowGetParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *BoundaryServiceMaintenanceWindowGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
