//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrol?language=objc)
    #[unsafe(super(NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSView"))]
    pub struct NSControl;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSControl {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSControl {}
);

#[cfg(all(feature = "NSAnimation", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSControl {}
);

#[cfg(all(feature = "NSAppearance", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSControl {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSControl {}
);

#[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSControl {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSControl {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSControl {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSControl {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(target))]
        #[unsafe(method_family = none)]
        pub fn target(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`target`][Self::target].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        ///
        /// # Safety
        ///
        /// `target` should be of the correct type.
        #[unsafe(method(setTarget:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTarget(&self, target: Option<&AnyObject>);

        #[unsafe(method(action))]
        #[unsafe(method_family = none)]
        pub fn action(&self) -> Option<Sel>;

        /// Setter for [`action`][Self::action].
        ///
        /// # Safety
        ///
        /// `action` must be a valid selector.
        #[unsafe(method(setAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAction(&self, action: Option<Sel>);

        #[unsafe(method(tag))]
        #[unsafe(method_family = none)]
        pub fn tag(&self) -> NSInteger;

        /// Setter for [`tag`][Self::tag].
        #[unsafe(method(setTag:))]
        #[unsafe(method_family = none)]
        pub fn setTag(&self, tag: NSInteger);

        #[unsafe(method(ignoresMultiClick))]
        #[unsafe(method_family = none)]
        pub fn ignoresMultiClick(&self) -> bool;

        /// Setter for [`ignoresMultiClick`][Self::ignoresMultiClick].
        #[unsafe(method(setIgnoresMultiClick:))]
        #[unsafe(method_family = none)]
        pub fn setIgnoresMultiClick(&self, ignores_multi_click: bool);

        #[unsafe(method(isContinuous))]
        #[unsafe(method_family = none)]
        pub fn isContinuous(&self) -> bool;

        /// Setter for [`isContinuous`][Self::isContinuous].
        #[unsafe(method(setContinuous:))]
        #[unsafe(method_family = none)]
        pub fn setContinuous(&self, continuous: bool);

        #[unsafe(method(isEnabled))]
        #[unsafe(method_family = none)]
        pub fn isEnabled(&self) -> bool;

        /// Setter for [`isEnabled`][Self::isEnabled].
        #[unsafe(method(setEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setEnabled(&self, enabled: bool);

        #[unsafe(method(refusesFirstResponder))]
        #[unsafe(method_family = none)]
        pub fn refusesFirstResponder(&self) -> bool;

        /// Setter for [`refusesFirstResponder`][Self::refusesFirstResponder].
        #[unsafe(method(setRefusesFirstResponder:))]
        #[unsafe(method_family = none)]
        pub fn setRefusesFirstResponder(&self, refuses_first_responder: bool);

        #[unsafe(method(isHighlighted))]
        #[unsafe(method_family = none)]
        pub fn isHighlighted(&self) -> bool;

        /// Setter for [`isHighlighted`][Self::isHighlighted].
        #[unsafe(method(setHighlighted:))]
        #[unsafe(method_family = none)]
        pub fn setHighlighted(&self, highlighted: bool);

        #[cfg(feature = "NSCell")]
        #[unsafe(method(controlSize))]
        #[unsafe(method_family = none)]
        pub fn controlSize(&self) -> NSControlSize;

        #[cfg(feature = "NSCell")]
        /// Setter for [`controlSize`][Self::controlSize].
        #[unsafe(method(setControlSize:))]
        #[unsafe(method_family = none)]
        pub fn setControlSize(&self, control_size: NSControlSize);

        #[unsafe(method(formatter))]
        #[unsafe(method_family = none)]
        pub fn formatter(&self) -> Option<Retained<NSFormatter>>;

        /// Setter for [`formatter`][Self::formatter].
        #[unsafe(method(setFormatter:))]
        #[unsafe(method_family = none)]
        pub fn setFormatter(&self, formatter: Option<&NSFormatter>);

        #[unsafe(method(objectValue))]
        #[unsafe(method_family = none)]
        pub fn objectValue(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`objectValue`][Self::objectValue].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `object_value` should be of the correct type.
        #[unsafe(method(setObjectValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setObjectValue(&self, object_value: Option<&AnyObject>);

        #[unsafe(method(stringValue))]
        #[unsafe(method_family = none)]
        pub fn stringValue(&self) -> Retained<NSString>;

        /// Setter for [`stringValue`][Self::stringValue].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setStringValue:))]
        #[unsafe(method_family = none)]
        pub fn setStringValue(&self, string_value: &NSString);

        #[unsafe(method(attributedStringValue))]
        #[unsafe(method_family = none)]
        pub fn attributedStringValue(&self) -> Retained<NSAttributedString>;

        /// Setter for [`attributedStringValue`][Self::attributedStringValue].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAttributedStringValue:))]
        #[unsafe(method_family = none)]
        pub fn setAttributedStringValue(&self, attributed_string_value: &NSAttributedString);

        #[unsafe(method(intValue))]
        #[unsafe(method_family = none)]
        pub fn intValue(&self) -> c_int;

        /// Setter for [`intValue`][Self::intValue].
        #[unsafe(method(setIntValue:))]
        #[unsafe(method_family = none)]
        pub fn setIntValue(&self, int_value: c_int);

        #[unsafe(method(integerValue))]
        #[unsafe(method_family = none)]
        pub fn integerValue(&self) -> NSInteger;

        /// Setter for [`integerValue`][Self::integerValue].
        #[unsafe(method(setIntegerValue:))]
        #[unsafe(method_family = none)]
        pub fn setIntegerValue(&self, integer_value: NSInteger);

        #[unsafe(method(floatValue))]
        #[unsafe(method_family = none)]
        pub fn floatValue(&self) -> c_float;

        /// Setter for [`floatValue`][Self::floatValue].
        #[unsafe(method(setFloatValue:))]
        #[unsafe(method_family = none)]
        pub fn setFloatValue(&self, float_value: c_float);

        #[unsafe(method(doubleValue))]
        #[unsafe(method_family = none)]
        pub fn doubleValue(&self) -> c_double;

        /// Setter for [`doubleValue`][Self::doubleValue].
        #[unsafe(method(setDoubleValue:))]
        #[unsafe(method_family = none)]
        pub fn setDoubleValue(&self, double_value: c_double);

        #[unsafe(method(sizeThatFits:))]
        #[unsafe(method_family = none)]
        pub fn sizeThatFits(&self, size: NSSize) -> NSSize;

        #[unsafe(method(sizeToFit))]
        #[unsafe(method_family = none)]
        pub fn sizeToFit(&self);

        #[cfg(feature = "NSEvent")]
        #[unsafe(method(sendActionOn:))]
        #[unsafe(method_family = none)]
        pub fn sendActionOn(&self, mask: NSEventMask) -> NSInteger;

        /// # Safety
        ///
        /// - `action` must be a valid selector.
        /// - `target` should be of the correct type.
        #[unsafe(method(sendAction:to:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sendAction_to(&self, action: Option<Sel>, target: Option<&AnyObject>)
            -> bool;

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeIntValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeIntValueFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeFloatValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeFloatValueFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeDoubleValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeDoubleValueFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeStringValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeStringValueFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeObjectValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeObjectValueFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(takeIntegerValueFrom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn takeIntegerValueFrom(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(performClick:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performClick(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSFont")]
        #[unsafe(method(font))]
        #[unsafe(method_family = none)]
        pub fn font(&self) -> Option<Retained<NSFont>>;

        #[cfg(feature = "NSFont")]
        /// Setter for [`font`][Self::font].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setFont:))]
        #[unsafe(method_family = none)]
        pub fn setFont(&self, font: Option<&NSFont>);

        #[unsafe(method(usesSingleLineMode))]
        #[unsafe(method_family = none)]
        pub fn usesSingleLineMode(&self) -> bool;

        /// Setter for [`usesSingleLineMode`][Self::usesSingleLineMode].
        #[unsafe(method(setUsesSingleLineMode:))]
        #[unsafe(method_family = none)]
        pub fn setUsesSingleLineMode(&self, uses_single_line_mode: bool);

        #[cfg(feature = "NSParagraphStyle")]
        #[unsafe(method(lineBreakMode))]
        #[unsafe(method_family = none)]
        pub fn lineBreakMode(&self) -> NSLineBreakMode;

        #[cfg(feature = "NSParagraphStyle")]
        /// Setter for [`lineBreakMode`][Self::lineBreakMode].
        #[unsafe(method(setLineBreakMode:))]
        #[unsafe(method_family = none)]
        pub fn setLineBreakMode(&self, line_break_mode: NSLineBreakMode);

        #[cfg(feature = "NSText")]
        #[unsafe(method(alignment))]
        #[unsafe(method_family = none)]
        pub fn alignment(&self) -> NSTextAlignment;

        #[cfg(feature = "NSText")]
        /// Setter for [`alignment`][Self::alignment].
        #[unsafe(method(setAlignment:))]
        #[unsafe(method_family = none)]
        pub fn setAlignment(&self, alignment: NSTextAlignment);

        #[cfg(feature = "NSText")]
        #[unsafe(method(baseWritingDirection))]
        #[unsafe(method_family = none)]
        pub fn baseWritingDirection(&self) -> NSWritingDirection;

        #[cfg(feature = "NSText")]
        /// Setter for [`baseWritingDirection`][Self::baseWritingDirection].
        #[unsafe(method(setBaseWritingDirection:))]
        #[unsafe(method_family = none)]
        pub fn setBaseWritingDirection(&self, base_writing_direction: NSWritingDirection);

        #[unsafe(method(allowsExpansionToolTips))]
        #[unsafe(method_family = none)]
        pub fn allowsExpansionToolTips(&self) -> bool;

        /// Setter for [`allowsExpansionToolTips`][Self::allowsExpansionToolTips].
        #[unsafe(method(setAllowsExpansionToolTips:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsExpansionToolTips(&self, allows_expansion_tool_tips: bool);

        #[unsafe(method(expansionFrameWithFrame:))]
        #[unsafe(method_family = none)]
        pub fn expansionFrameWithFrame(&self, content_frame: NSRect) -> NSRect;

        #[unsafe(method(drawWithExpansionFrame:inView:))]
        #[unsafe(method_family = none)]
        pub fn drawWithExpansionFrame_inView(&self, content_frame: NSRect, view: &NSView);
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSControl {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSControl {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// NSControlEditableTextMethods.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSControl {
    extern_methods!(
        #[cfg(feature = "NSText")]
        #[unsafe(method(currentEditor))]
        #[unsafe(method_family = none)]
        pub fn currentEditor(&self) -> Option<Retained<NSText>>;

        #[unsafe(method(abortEditing))]
        #[unsafe(method_family = none)]
        pub fn abortEditing(&self) -> bool;

        #[unsafe(method(validateEditing))]
        #[unsafe(method_family = none)]
        pub fn validateEditing(&self);

        #[cfg(all(feature = "NSEvent", feature = "NSText"))]
        /// # Safety
        ///
        /// `delegate` should be of the correct type.
        #[unsafe(method(editWithFrame:editor:delegate:event:))]
        #[unsafe(method_family = none)]
        pub unsafe fn editWithFrame_editor_delegate_event(
            &self,
            rect: NSRect,
            text_obj: &NSText,
            delegate: Option<&AnyObject>,
            event: &NSEvent,
        );

        #[cfg(feature = "NSText")]
        /// # Safety
        ///
        /// `delegate` should be of the correct type.
        #[unsafe(method(selectWithFrame:editor:delegate:start:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectWithFrame_editor_delegate_start_length(
            &self,
            rect: NSRect,
            text_obj: &NSText,
            delegate: Option<&AnyObject>,
            sel_start: NSInteger,
            sel_length: NSInteger,
        );

        #[cfg(feature = "NSText")]
        #[unsafe(method(endEditing:))]
        #[unsafe(method_family = none)]
        pub fn endEditing(&self, text_obj: &NSText);
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontroltexteditingdelegate?language=objc)
    pub unsafe trait NSControlTextEditingDelegate:
        NSObjectProtocol + MainThreadOnly
    {
        #[optional]
        #[unsafe(method(controlTextDidBeginEditing:))]
        #[unsafe(method_family = none)]
        fn controlTextDidBeginEditing(&self, obj: &NSNotification);

        #[optional]
        #[unsafe(method(controlTextDidEndEditing:))]
        #[unsafe(method_family = none)]
        fn controlTextDidEndEditing(&self, obj: &NSNotification);

        #[optional]
        #[unsafe(method(controlTextDidChange:))]
        #[unsafe(method_family = none)]
        fn controlTextDidChange(&self, obj: &NSNotification);

        #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
        #[optional]
        #[unsafe(method(control:textShouldBeginEditing:))]
        #[unsafe(method_family = none)]
        fn control_textShouldBeginEditing(
            &self,
            control: &NSControl,
            field_editor: &NSText,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSText", feature = "NSView"))]
        #[optional]
        #[unsafe(method(control:textShouldEndEditing:))]
        #[unsafe(method_family = none)]
        fn control_textShouldEndEditing(&self, control: &NSControl, field_editor: &NSText) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(control:didFailToFormatString:errorDescription:))]
        #[unsafe(method_family = none)]
        fn control_didFailToFormatString_errorDescription(
            &self,
            control: &NSControl,
            string: &NSString,
            error: Option<&NSString>,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(control:didFailToValidatePartialString:errorDescription:))]
        #[unsafe(method_family = none)]
        fn control_didFailToValidatePartialString_errorDescription(
            &self,
            control: &NSControl,
            string: &NSString,
            error: Option<&NSString>,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `obj` should be of the correct type.
        #[optional]
        #[unsafe(method(control:isValidObject:))]
        #[unsafe(method_family = none)]
        unsafe fn control_isValidObject(
            &self,
            control: &NSControl,
            obj: Option<&AnyObject>,
        ) -> bool;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSText",
            feature = "NSTextView",
            feature = "NSView"
        ))]
        /// # Safety
        ///
        /// `command_selector` must be a valid selector.
        #[optional]
        #[unsafe(method(control:textView:doCommandBySelector:))]
        #[unsafe(method_family = none)]
        unsafe fn control_textView_doCommandBySelector(
            &self,
            control: &NSControl,
            text_view: &NSTextView,
            command_selector: Sel,
        ) -> bool;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSText",
            feature = "NSTextView",
            feature = "NSView"
        ))]
        /// # Safety
        ///
        /// `index` must be a valid pointer.
        #[optional]
        #[unsafe(method(control:textView:completions:forPartialWordRange:indexOfSelectedItem:))]
        #[unsafe(method_family = none)]
        unsafe fn control_textView_completions_forPartialWordRange_indexOfSelectedItem(
            &self,
            control: &NSControl,
            text_view: &NSTextView,
            words: &NSArray<NSString>,
            char_range: NSRange,
            index: NonNull<NSInteger>,
        ) -> Retained<NSArray<NSString>>;
    }
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontroltextdidbegineditingnotification?language=objc)
    pub static NSControlTextDidBeginEditingNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontroltextdidendeditingnotification?language=objc)
    pub static NSControlTextDidEndEditingNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontroltextdidchangenotification?language=objc)
    pub static NSControlTextDidChangeNotification: &'static NSNotificationName;
}

/// NSDeprecated.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSControl {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(setFloatingPointFormat:left:right:))]
        #[unsafe(method_family = none)]
        pub fn setFloatingPointFormat_left_right(
            &self,
            auto_range: bool,
            left_digits: NSUInteger,
            right_digits: NSUInteger,
        );

        #[unsafe(method(cellClass))]
        #[unsafe(method_family = none)]
        pub fn cellClass(mtm: MainThreadMarker) -> Option<&'static AnyClass>;

        /// Setter for [`cellClass`][Self::cellClass].
        ///
        /// # Safety
        ///
        /// `cell_class` probably has further requirements.
        #[unsafe(method(setCellClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCellClass(cell_class: Option<&AnyClass>, mtm: MainThreadMarker);

        #[cfg(feature = "NSCell")]
        #[unsafe(method(cell))]
        #[unsafe(method_family = none)]
        pub fn cell(&self) -> Option<Retained<NSCell>>;

        #[cfg(feature = "NSCell")]
        /// Setter for [`cell`][Self::cell].
        #[unsafe(method(setCell:))]
        #[unsafe(method_family = none)]
        pub fn setCell(&self, cell: Option<&NSCell>);

        #[cfg(feature = "NSCell")]
        #[unsafe(method(selectedCell))]
        #[unsafe(method_family = none)]
        pub fn selectedCell(&self) -> Option<Retained<NSCell>>;

        #[unsafe(method(selectedTag))]
        #[unsafe(method_family = none)]
        pub fn selectedTag(&self) -> NSInteger;

        #[deprecated = "Set the needsDisplay property to YES instead"]
        #[unsafe(method(setNeedsDisplay))]
        #[unsafe(method_family = none)]
        pub fn setNeedsDisplay(&self);

        #[deprecated = "Override -layout instead. This method should never be called"]
        #[unsafe(method(calcSize))]
        #[unsafe(method_family = none)]
        pub fn calcSize(&self);

        #[cfg(feature = "NSCell")]
        #[unsafe(method(updateCell:))]
        #[unsafe(method_family = none)]
        pub fn updateCell(&self, cell: &NSCell);

        #[cfg(feature = "NSCell")]
        #[unsafe(method(updateCellInside:))]
        #[unsafe(method_family = none)]
        pub fn updateCellInside(&self, cell: &NSCell);

        #[cfg(feature = "NSCell")]
        #[unsafe(method(drawCellInside:))]
        #[unsafe(method_family = none)]
        pub fn drawCellInside(&self, cell: &NSCell);

        #[cfg(feature = "NSCell")]
        #[unsafe(method(drawCell:))]
        #[unsafe(method_family = none)]
        pub fn drawCell(&self, cell: &NSCell);

        #[cfg(feature = "NSCell")]
        #[unsafe(method(selectCell:))]
        #[unsafe(method_family = none)]
        pub fn selectCell(&self, cell: &NSCell);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscontrolbordershape?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSControlBorderShape(pub NSInteger);
impl NSControlBorderShape {
    /// The control will resolve this to an appropriate shape for the given control size and context
    #[doc(alias = "NSControlBorderShapeAutomatic")]
    pub const Automatic: Self = Self(0);
    /// The control will resolve this to an appropriate shape for the given control size and context
    #[doc(alias = "NSControlBorderShapeCapsule")]
    pub const Capsule: Self = Self(1);
    /// The control will resolve this to an appropriate shape for the given control size and context
    #[doc(alias = "NSControlBorderShapeRoundedRectangle")]
    pub const RoundedRectangle: Self = Self(2);
    /// The control will resolve this to an appropriate shape for the given control size and context
    #[doc(alias = "NSControlBorderShapeCircle")]
    pub const Circle: Self = Self(3);
}

unsafe impl Encode for NSControlBorderShape {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSControlBorderShape {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}
