package workorder

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCategories invokes the workorder.ListCategories API synchronously
func (client *Client) ListCategories(request *ListCategoriesRequest) (response *ListCategoriesResponse, err error) {
	response = CreateListCategoriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCategoriesWithChan invokes the workorder.ListCategories API asynchronously
func (client *Client) ListCategoriesWithChan(request *ListCategoriesRequest) (<-chan *ListCategoriesResponse, <-chan error) {
	responseChan := make(chan *ListCategoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCategories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCategoriesWithCallback invokes the workorder.ListCategories API asynchronously
func (client *Client) ListCategoriesWithCallback(request *ListCategoriesRequest, callback func(response *ListCategoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCategoriesResponse
		var err error
		defer close(result)
		response, err = client.ListCategories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCategoriesRequest is the request struct for api ListCategories
type ListCategoriesRequest struct {
	*requests.RpcRequest
	ProductId requests.Integer `position:"Body" name:"ProductId"`
	Name      string           `position:"Body" name:"Name"`
}

// ListCategoriesResponse is the response struct for api ListCategories
type ListCategoriesResponse struct {
	*responses.BaseResponse
	Code      int        `json:"Code" xml:"Code"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Message   string     `json:"Message" xml:"Message"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListCategoriesRequest creates a request to invoke ListCategories API
func CreateListCategoriesRequest() (request *ListCategoriesRequest) {
	request = &ListCategoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Workorder", "2021-06-10", "ListCategories", "", "")
	request.Method = requests.POST
	return
}

// CreateListCategoriesResponse creates a response to parse from ListCategories response
func CreateListCategoriesResponse() (response *ListCategoriesResponse) {
	response = &ListCategoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
