package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadDeviceRecord invokes the vs.UploadDeviceRecord API synchronously
func (client *Client) UploadDeviceRecord(request *UploadDeviceRecordRequest) (response *UploadDeviceRecordResponse, err error) {
	response = CreateUploadDeviceRecordResponse()
	err = client.DoAction(request, response)
	return
}

// UploadDeviceRecordWithChan invokes the vs.UploadDeviceRecord API asynchronously
func (client *Client) UploadDeviceRecordWithChan(request *UploadDeviceRecordRequest) (<-chan *UploadDeviceRecordResponse, <-chan error) {
	responseChan := make(chan *UploadDeviceRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadDeviceRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadDeviceRecordWithCallback invokes the vs.UploadDeviceRecord API asynchronously
func (client *Client) UploadDeviceRecordWithCallback(request *UploadDeviceRecordRequest, callback func(response *UploadDeviceRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadDeviceRecordResponse
		var err error
		defer close(result)
		response, err = client.UploadDeviceRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadDeviceRecordRequest is the request struct for api UploadDeviceRecord
type UploadDeviceRecordRequest struct {
	*requests.RpcRequest
	SearchCriteria string           `position:"Query" name:"SearchCriteria"`
	UploadParams   string           `position:"Query" name:"UploadParams"`
	ShowLog        string           `position:"Query" name:"ShowLog"`
	StreamId       string           `position:"Query" name:"StreamId"`
	UploadId       string           `position:"Query" name:"UploadId"`
	UploadType     string           `position:"Query" name:"UploadType"`
	UploadMode     string           `position:"Query" name:"UploadMode"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId       string           `position:"Query" name:"DeviceId"`
}

// UploadDeviceRecordResponse is the response struct for api UploadDeviceRecord
type UploadDeviceRecordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateUploadDeviceRecordRequest creates a request to invoke UploadDeviceRecord API
func CreateUploadDeviceRecordRequest() (request *UploadDeviceRecordRequest) {
	request = &UploadDeviceRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "UploadDeviceRecord", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadDeviceRecordResponse creates a response to parse from UploadDeviceRecord response
func CreateUploadDeviceRecordResponse() (response *UploadDeviceRecordResponse) {
	response = &UploadDeviceRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
