package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTagWithUuid invokes the sas.DeleteTagWithUuid API synchronously
func (client *Client) DeleteTagWithUuid(request *DeleteTagWithUuidRequest) (response *DeleteTagWithUuidResponse, err error) {
	response = CreateDeleteTagWithUuidResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTagWithUuidWithChan invokes the sas.DeleteTagWithUuid API asynchronously
func (client *Client) DeleteTagWithUuidWithChan(request *DeleteTagWithUuidRequest) (<-chan *DeleteTagWithUuidResponse, <-chan error) {
	responseChan := make(chan *DeleteTagWithUuidResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTagWithUuid(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTagWithUuidWithCallback invokes the sas.DeleteTagWithUuid API asynchronously
func (client *Client) DeleteTagWithUuidWithCallback(request *DeleteTagWithUuidRequest, callback func(response *DeleteTagWithUuidResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTagWithUuidResponse
		var err error
		defer close(result)
		response, err = client.DeleteTagWithUuid(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTagWithUuidRequest is the request struct for api DeleteTagWithUuid
type DeleteTagWithUuidRequest struct {
	*requests.RpcRequest
	TagName  string `position:"Query" name:"TagName"`
	SourceIp string `position:"Query" name:"SourceIp"`
	UuidList string `position:"Query" name:"UuidList"`
}

// DeleteTagWithUuidResponse is the response struct for api DeleteTagWithUuid
type DeleteTagWithUuidResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTagWithUuidRequest creates a request to invoke DeleteTagWithUuid API
func CreateDeleteTagWithUuidRequest() (request *DeleteTagWithUuidRequest) {
	request = &DeleteTagWithUuidRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DeleteTagWithUuid", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTagWithUuidResponse creates a response to parse from DeleteTagWithUuid response
func CreateDeleteTagWithUuidResponse() (response *DeleteTagWithUuidResponse) {
	response = &DeleteTagWithUuidResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
