package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUserTagValueList invokes the quickbi_public.QueryUserTagValueList API synchronously
func (client *Client) QueryUserTagValueList(request *QueryUserTagValueListRequest) (response *QueryUserTagValueListResponse, err error) {
	response = CreateQueryUserTagValueListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUserTagValueListWithChan invokes the quickbi_public.QueryUserTagValueList API asynchronously
func (client *Client) QueryUserTagValueListWithChan(request *QueryUserTagValueListRequest) (<-chan *QueryUserTagValueListResponse, <-chan error) {
	responseChan := make(chan *QueryUserTagValueListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUserTagValueList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUserTagValueListWithCallback invokes the quickbi_public.QueryUserTagValueList API asynchronously
func (client *Client) QueryUserTagValueListWithCallback(request *QueryUserTagValueListRequest, callback func(response *QueryUserTagValueListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUserTagValueListResponse
		var err error
		defer close(result)
		response, err = client.QueryUserTagValueList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUserTagValueListRequest is the request struct for api QueryUserTagValueList
type QueryUserTagValueListRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	UserId      string `position:"Query" name:"UserId"`
}

// QueryUserTagValueListResponse is the response struct for api QueryUserTagValueList
type QueryUserTagValueListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    []Data `json:"Result" xml:"Result"`
}

// CreateQueryUserTagValueListRequest creates a request to invoke QueryUserTagValueList API
func CreateQueryUserTagValueListRequest() (request *QueryUserTagValueListRequest) {
	request = &QueryUserTagValueListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2020-08-02", "QueryUserTagValueList", "quickbi", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQueryUserTagValueListResponse creates a response to parse from QueryUserTagValueList response
func CreateQueryUserTagValueListResponse() (response *QueryUserTagValueListResponse) {
	response = &QueryUserTagValueListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
