package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeVisibilityModel invokes the quickbi_public.ChangeVisibilityModel API synchronously
func (client *Client) ChangeVisibilityModel(request *ChangeVisibilityModelRequest) (response *ChangeVisibilityModelResponse, err error) {
	response = CreateChangeVisibilityModelResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeVisibilityModelWithChan invokes the quickbi_public.ChangeVisibilityModel API asynchronously
func (client *Client) ChangeVisibilityModelWithChan(request *ChangeVisibilityModelRequest) (<-chan *ChangeVisibilityModelResponse, <-chan error) {
	responseChan := make(chan *ChangeVisibilityModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeVisibilityModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeVisibilityModelWithCallback invokes the quickbi_public.ChangeVisibilityModel API asynchronously
func (client *Client) ChangeVisibilityModelWithCallback(request *ChangeVisibilityModelRequest, callback func(response *ChangeVisibilityModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeVisibilityModelResponse
		var err error
		defer close(result)
		response, err = client.ChangeVisibilityModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeVisibilityModelRequest is the request struct for api ChangeVisibilityModel
type ChangeVisibilityModelRequest struct {
	*requests.RpcRequest
	DataPortalId       string           `position:"Query" name:"DataPortalId"`
	ShowOnlyWithAccess requests.Boolean `position:"Query" name:"ShowOnlyWithAccess"`
	AccessPoint        string           `position:"Query" name:"AccessPoint"`
	SignType           string           `position:"Query" name:"SignType"`
	MenuIds            string           `position:"Query" name:"MenuIds"`
}

// ChangeVisibilityModelResponse is the response struct for api ChangeVisibilityModel
type ChangeVisibilityModelResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    int    `json:"Result" xml:"Result"`
}

// CreateChangeVisibilityModelRequest creates a request to invoke ChangeVisibilityModel API
func CreateChangeVisibilityModelRequest() (request *ChangeVisibilityModelRequest) {
	request = &ChangeVisibilityModelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2020-08-08", "ChangeVisibilityModel", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateChangeVisibilityModelResponse creates a response to parse from ChangeVisibilityModel response
func CreateChangeVisibilityModelResponse() (response *ChangeVisibilityModelResponse) {
	response = &ChangeVisibilityModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
