package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstancePatchStates invokes the oos.ListInstancePatchStates API synchronously
func (client *Client) ListInstancePatchStates(request *ListInstancePatchStatesRequest) (response *ListInstancePatchStatesResponse, err error) {
	response = CreateListInstancePatchStatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstancePatchStatesWithChan invokes the oos.ListInstancePatchStates API asynchronously
func (client *Client) ListInstancePatchStatesWithChan(request *ListInstancePatchStatesRequest) (<-chan *ListInstancePatchStatesResponse, <-chan error) {
	responseChan := make(chan *ListInstancePatchStatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstancePatchStates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstancePatchStatesWithCallback invokes the oos.ListInstancePatchStates API asynchronously
func (client *Client) ListInstancePatchStatesWithCallback(request *ListInstancePatchStatesRequest, callback func(response *ListInstancePatchStatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstancePatchStatesResponse
		var err error
		defer close(result)
		response, err = client.ListInstancePatchStates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstancePatchStatesRequest is the request struct for api ListInstancePatchStates
type ListInstancePatchStatesRequest struct {
	*requests.RpcRequest
	NextToken   string           `position:"Query" name:"NextToken"`
	InstanceIds string           `position:"Query" name:"InstanceIds"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
}

// ListInstancePatchStatesResponse is the response struct for api ListInstancePatchStates
type ListInstancePatchStatesResponse struct {
	*responses.BaseResponse
	MaxResults          int                  `json:"MaxResults" xml:"MaxResults"`
	NextToken           string               `json:"NextToken" xml:"NextToken"`
	RequestId           string               `json:"RequestId" xml:"RequestId"`
	InstancePatchStates []InstancePatchState `json:"InstancePatchStates" xml:"InstancePatchStates"`
}

// CreateListInstancePatchStatesRequest creates a request to invoke ListInstancePatchStates API
func CreateListInstancePatchStatesRequest() (request *ListInstancePatchStatesRequest) {
	request = &ListInstancePatchStatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListInstancePatchStates", "", "")
	request.Method = requests.POST
	return
}

// CreateListInstancePatchStatesResponse creates a response to parse from ListInstancePatchStates response
func CreateListInstancePatchStatesResponse() (response *ListInstancePatchStatesResponse) {
	response = &ListInstancePatchStatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
