package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUpPeakPublishStreamData invokes the live.DescribeUpPeakPublishStreamData API synchronously
func (client *Client) DescribeUpPeakPublishStreamData(request *DescribeUpPeakPublishStreamDataRequest) (response *DescribeUpPeakPublishStreamDataResponse, err error) {
	response = CreateDescribeUpPeakPublishStreamDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUpPeakPublishStreamDataWithChan invokes the live.DescribeUpPeakPublishStreamData API asynchronously
func (client *Client) DescribeUpPeakPublishStreamDataWithChan(request *DescribeUpPeakPublishStreamDataRequest) (<-chan *DescribeUpPeakPublishStreamDataResponse, <-chan error) {
	responseChan := make(chan *DescribeUpPeakPublishStreamDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUpPeakPublishStreamData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUpPeakPublishStreamDataWithCallback invokes the live.DescribeUpPeakPublishStreamData API asynchronously
func (client *Client) DescribeUpPeakPublishStreamDataWithCallback(request *DescribeUpPeakPublishStreamDataRequest, callback func(response *DescribeUpPeakPublishStreamDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUpPeakPublishStreamDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeUpPeakPublishStreamData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUpPeakPublishStreamDataRequest is the request struct for api DescribeUpPeakPublishStreamData
type DescribeUpPeakPublishStreamDataRequest struct {
	*requests.RpcRequest
	StartTime    string           `position:"Query" name:"StartTime"`
	DomainName   string           `position:"Query" name:"DomainName"`
	EndTime      string           `position:"Query" name:"EndTime"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	DomainSwitch string           `position:"Query" name:"DomainSwitch"`
}

// DescribeUpPeakPublishStreamDataResponse is the response struct for api DescribeUpPeakPublishStreamData
type DescribeUpPeakPublishStreamDataResponse struct {
	*responses.BaseResponse
	RequestId                        string                           `json:"RequestId" xml:"RequestId"`
	DescribeUpPeakPublishStreamDatas DescribeUpPeakPublishStreamDatas `json:"DescribeUpPeakPublishStreamDatas" xml:"DescribeUpPeakPublishStreamDatas"`
}

// CreateDescribeUpPeakPublishStreamDataRequest creates a request to invoke DescribeUpPeakPublishStreamData API
func CreateDescribeUpPeakPublishStreamDataRequest() (request *DescribeUpPeakPublishStreamDataRequest) {
	request = &DescribeUpPeakPublishStreamDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeUpPeakPublishStreamData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUpPeakPublishStreamDataResponse creates a response to parse from DescribeUpPeakPublishStreamData response
func CreateDescribeUpPeakPublishStreamDataResponse() (response *DescribeUpPeakPublishStreamDataResponse) {
	response = &DescribeUpPeakPublishStreamDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
