package ledgerdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLedger invokes the ledgerdb.DeleteLedger API synchronously
// api document: https://help.aliyun.com/api/ledgerdb/deleteledger.html
func (client *Client) DeleteLedger(request *DeleteLedgerRequest) (response *DeleteLedgerResponse, err error) {
	response = CreateDeleteLedgerResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLedgerWithChan invokes the ledgerdb.DeleteLedger API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/deleteledger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLedgerWithChan(request *DeleteLedgerRequest) (<-chan *DeleteLedgerResponse, <-chan error) {
	responseChan := make(chan *DeleteLedgerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLedger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLedgerWithCallback invokes the ledgerdb.DeleteLedger API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/deleteledger.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLedgerWithCallback(request *DeleteLedgerRequest, callback func(response *DeleteLedgerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLedgerResponse
		var err error
		defer close(result)
		response, err = client.DeleteLedger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLedgerRequest is the request struct for api DeleteLedger
type DeleteLedgerRequest struct {
	*requests.RpcRequest
	LedgerId string `position:"Query" name:"LedgerId"`
}

// DeleteLedgerResponse is the response struct for api DeleteLedger
type DeleteLedgerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLedgerRequest creates a request to invoke DeleteLedger API
func CreateDeleteLedgerRequest() (request *DeleteLedgerRequest) {
	request = &DeleteLedgerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ledgerdb", "2019-11-22", "DeleteLedger", "ledgerdb", "openAPI")
	return
}

// CreateDeleteLedgerResponse creates a response to parse from DeleteLedger response
func CreateDeleteLedgerResponse() (response *DeleteLedgerResponse) {
	response = &DeleteLedgerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
