package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateThingModel invokes the iot.CreateThingModel API synchronously
func (client *Client) CreateThingModel(request *CreateThingModelRequest) (response *CreateThingModelResponse, err error) {
	response = CreateCreateThingModelResponse()
	err = client.DoAction(request, response)
	return
}

// CreateThingModelWithChan invokes the iot.CreateThingModel API asynchronously
func (client *Client) CreateThingModelWithChan(request *CreateThingModelRequest) (<-chan *CreateThingModelResponse, <-chan error) {
	responseChan := make(chan *CreateThingModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateThingModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateThingModelWithCallback invokes the iot.CreateThingModel API asynchronously
func (client *Client) CreateThingModelWithCallback(request *CreateThingModelRequest, callback func(response *CreateThingModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateThingModelResponse
		var err error
		defer close(result)
		response, err = client.CreateThingModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateThingModelRequest is the request struct for api CreateThingModel
type CreateThingModelRequest struct {
	*requests.RpcRequest
	RealTenantId      string `position:"Query" name:"RealTenantId"`
	RealTripartiteKey string `position:"Query" name:"RealTripartiteKey"`
	IotInstanceId     string `position:"Query" name:"IotInstanceId"`
	FunctionBlockName string `position:"Query" name:"FunctionBlockName"`
	ProductKey        string `position:"Query" name:"ProductKey"`
	ApiProduct        string `position:"Body" name:"ApiProduct"`
	ThingModelJson    string `position:"Query" name:"ThingModelJson"`
	ApiRevision       string `position:"Body" name:"ApiRevision"`
	FunctionBlockId   string `position:"Query" name:"FunctionBlockId"`
}

// CreateThingModelResponse is the response struct for api CreateThingModel
type CreateThingModelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateCreateThingModelRequest creates a request to invoke CreateThingModel API
func CreateCreateThingModelRequest() (request *CreateThingModelRequest) {
	request = &CreateThingModelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateThingModel", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateThingModelResponse creates a response to parse from CreateThingModel response
func CreateCreateThingModelResponse() (response *CreateThingModelResponse) {
	response = &CreateThingModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
