package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRestoreSummary invokes the hbase.DescribeRestoreSummary API synchronously
func (client *Client) DescribeRestoreSummary(request *DescribeRestoreSummaryRequest) (response *DescribeRestoreSummaryResponse, err error) {
	response = CreateDescribeRestoreSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRestoreSummaryWithChan invokes the hbase.DescribeRestoreSummary API asynchronously
func (client *Client) DescribeRestoreSummaryWithChan(request *DescribeRestoreSummaryRequest) (<-chan *DescribeRestoreSummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeRestoreSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRestoreSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRestoreSummaryWithCallback invokes the hbase.DescribeRestoreSummary API asynchronously
func (client *Client) DescribeRestoreSummaryWithCallback(request *DescribeRestoreSummaryRequest, callback func(response *DescribeRestoreSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRestoreSummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeRestoreSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRestoreSummaryRequest is the request struct for api DescribeRestoreSummary
type DescribeRestoreSummaryRequest struct {
	*requests.RpcRequest
	ClusterId  string           `position:"Query" name:"ClusterId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeRestoreSummaryResponse is the response struct for api DescribeRestoreSummary
type DescribeRestoreSummaryResponse struct {
	*responses.BaseResponse
	RequestId            string   `json:"RequestId" xml:"RequestId"`
	HasMoreRestoreRecord int      `json:"HasMoreRestoreRecord" xml:"HasMoreRestoreRecord"`
	PageNumber           int      `json:"PageNumber" xml:"PageNumber"`
	PageSize             int      `json:"PageSize" xml:"PageSize"`
	Total                int      `json:"Total" xml:"Total"`
	Rescords             Rescords `json:"Rescords" xml:"Rescords"`
}

// CreateDescribeRestoreSummaryRequest creates a request to invoke DescribeRestoreSummary API
func CreateDescribeRestoreSummaryRequest() (request *DescribeRestoreSummaryRequest) {
	request = &DescribeRestoreSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DescribeRestoreSummary", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRestoreSummaryResponse creates a response to parse from DescribeRestoreSummary response
func CreateDescribeRestoreSummaryResponse() (response *DescribeRestoreSummaryResponse) {
	response = &DescribeRestoreSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
