package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UndoRtcNumberAuth invokes the dyvmsapi.UndoRtcNumberAuth API synchronously
func (client *Client) UndoRtcNumberAuth(request *UndoRtcNumberAuthRequest) (response *UndoRtcNumberAuthResponse, err error) {
	response = CreateUndoRtcNumberAuthResponse()
	err = client.DoAction(request, response)
	return
}

// UndoRtcNumberAuthWithChan invokes the dyvmsapi.UndoRtcNumberAuth API asynchronously
func (client *Client) UndoRtcNumberAuthWithChan(request *UndoRtcNumberAuthRequest) (<-chan *UndoRtcNumberAuthResponse, <-chan error) {
	responseChan := make(chan *UndoRtcNumberAuthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UndoRtcNumberAuth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UndoRtcNumberAuthWithCallback invokes the dyvmsapi.UndoRtcNumberAuth API asynchronously
func (client *Client) UndoRtcNumberAuthWithCallback(request *UndoRtcNumberAuthRequest, callback func(response *UndoRtcNumberAuthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UndoRtcNumberAuthResponse
		var err error
		defer close(result)
		response, err = client.UndoRtcNumberAuth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UndoRtcNumberAuthRequest is the request struct for api UndoRtcNumberAuth
type UndoRtcNumberAuthRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PhoneNumber          string           `position:"Query" name:"PhoneNumber"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// UndoRtcNumberAuthResponse is the response struct for api UndoRtcNumberAuth
type UndoRtcNumberAuthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Module    string `json:"Module" xml:"Module"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUndoRtcNumberAuthRequest creates a request to invoke UndoRtcNumberAuth API
func CreateUndoRtcNumberAuthRequest() (request *UndoRtcNumberAuthRequest) {
	request = &UndoRtcNumberAuthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "UndoRtcNumberAuth", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUndoRtcNumberAuthResponse creates a response to parse from UndoRtcNumberAuth response
func CreateUndoRtcNumberAuthResponse() (response *UndoRtcNumberAuthResponse) {
	response = &UndoRtcNumberAuthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
