package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePhoneNumber invokes the dyplsapi.UpdatePhoneNumber API synchronously
func (client *Client) UpdatePhoneNumber(request *UpdatePhoneNumberRequest) (response *UpdatePhoneNumberResponse, err error) {
	response = CreateUpdatePhoneNumberResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePhoneNumberWithChan invokes the dyplsapi.UpdatePhoneNumber API asynchronously
func (client *Client) UpdatePhoneNumberWithChan(request *UpdatePhoneNumberRequest) (<-chan *UpdatePhoneNumberResponse, <-chan error) {
	responseChan := make(chan *UpdatePhoneNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePhoneNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePhoneNumberWithCallback invokes the dyplsapi.UpdatePhoneNumber API asynchronously
func (client *Client) UpdatePhoneNumberWithCallback(request *UpdatePhoneNumberRequest, callback func(response *UpdatePhoneNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePhoneNumberResponse
		var err error
		defer close(result)
		response, err = client.UpdatePhoneNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePhoneNumberRequest is the request struct for api UpdatePhoneNumber
type UpdatePhoneNumberRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SubsId               requests.Integer `position:"Query" name:"SubsId"`
	SecretNo             string           `position:"Query" name:"SecretNo"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	BindToken            string           `position:"Query" name:"BindToken"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
	NewPhoneNo           string           `position:"Query" name:"NewPhoneNo"`
}

// UpdatePhoneNumberResponse is the response struct for api UpdatePhoneNumber
type UpdatePhoneNumberResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdatePhoneNumberRequest creates a request to invoke UpdatePhoneNumber API
func CreateUpdatePhoneNumberRequest() (request *UpdatePhoneNumberRequest) {
	request = &UpdatePhoneNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "UpdatePhoneNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdatePhoneNumberResponse creates a response to parse from UpdatePhoneNumber response
func CreateUpdatePhoneNumberResponse() (response *UpdatePhoneNumberResponse) {
	response = &UpdatePhoneNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
