package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLayer4Rules invokes the ddoscoo.DescribeLayer4Rules API synchronously
func (client *Client) DescribeLayer4Rules(request *DescribeLayer4RulesRequest) (response *DescribeLayer4RulesResponse, err error) {
	response = CreateDescribeLayer4RulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLayer4RulesWithChan invokes the ddoscoo.DescribeLayer4Rules API asynchronously
func (client *Client) DescribeLayer4RulesWithChan(request *DescribeLayer4RulesRequest) (<-chan *DescribeLayer4RulesResponse, <-chan error) {
	responseChan := make(chan *DescribeLayer4RulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLayer4Rules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLayer4RulesWithCallback invokes the ddoscoo.DescribeLayer4Rules API asynchronously
func (client *Client) DescribeLayer4RulesWithCallback(request *DescribeLayer4RulesRequest, callback func(response *DescribeLayer4RulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLayer4RulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeLayer4Rules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLayer4RulesRequest is the request struct for api DescribeLayer4Rules
type DescribeLayer4RulesRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        string           `position:"Query" name:"PageSize"`
	Offset          requests.Integer `position:"Query" name:"Offset"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	FrontendPort    requests.Integer `position:"Query" name:"FrontendPort"`
	ForwardProtocol string           `position:"Query" name:"ForwardProtocol"`
}

// DescribeLayer4RulesResponse is the response struct for api DescribeLayer4Rules
type DescribeLayer4RulesResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Total     int64      `json:"Total" xml:"Total"`
	Listeners []Listener `json:"Listeners" xml:"Listeners"`
}

// CreateDescribeLayer4RulesRequest creates a request to invoke DescribeLayer4Rules API
func CreateDescribeLayer4RulesRequest() (request *DescribeLayer4RulesRequest) {
	request = &DescribeLayer4RulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DescribeLayer4Rules", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeLayer4RulesResponse creates a response to parse from DescribeLayer4Rules response
func CreateDescribeLayer4RulesResponse() (response *DescribeLayer4RulesResponse) {
	response = &DescribeLayer4RulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
